// Code generated by thriftgo (0.4.1). DO NOT EDIT.

package product_public_api

import (
	"context"
	"database/sql"
	"database/sql/driver"
	"fmt"
	"github.com/apache/thrift/lib/go/thrift"
	"github.com/coze-dev/coze-studio/backend/api/model/base"
	"github.com/coze-dev/coze-studio/backend/api/model/flow/marketplace/marketplace_common"
	"github.com/coze-dev/coze-studio/backend/api/model/flow/marketplace/product_common"
)

type PluginAuthMode int64

const (
	// No authorization required.
	PluginAuthMode_NoAuth PluginAuthMode = 0
	// Authorization required, but no authorization configuration
	PluginAuthMode_Required PluginAuthMode = 1
	// Authorization is required and has been configured
	PluginAuthMode_Configured PluginAuthMode = 2
	// Authorization is required, but the authorization configuration may be user-level and can be configured by the user himself
	PluginAuthMode_Supported PluginAuthMode = 3
)

func (p PluginAuthMode) String() string {
	switch p {
	case PluginAuthMode_NoAuth:
		return "NoAuth"
	case PluginAuthMode_Required:
		return "Required"
	case PluginAuthMode_Configured:
		return "Configured"
	case PluginAuthMode_Supported:
		return "Supported"
	}
	return "<UNSET>"
}

func PluginAuthModeFromString(s string) (PluginAuthMode, error) {
	switch s {
	case "NoAuth":
		return PluginAuthMode_NoAuth, nil
	case "Required":
		return PluginAuthMode_Required, nil
	case "Configured":
		return PluginAuthMode_Configured, nil
	case "Supported":
		return PluginAuthMode_Supported, nil
	}
	return PluginAuthMode(0), fmt.Errorf("not a valid PluginAuthMode string")
}

func PluginAuthModePtr(v PluginAuthMode) *PluginAuthMode { return &v }
func (p *PluginAuthMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PluginAuthMode(result.Int64)
	return
}

func (p *PluginAuthMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type PluginRunMode int64

const (
	PluginRunMode_DefaultToSync PluginRunMode = 0
	PluginRunMode_Sync          PluginRunMode = 1
	PluginRunMode_Async         PluginRunMode = 2
	PluginRunMode_Streaming     PluginRunMode = 3
)

func (p PluginRunMode) String() string {
	switch p {
	case PluginRunMode_DefaultToSync:
		return "DefaultToSync"
	case PluginRunMode_Sync:
		return "Sync"
	case PluginRunMode_Async:
		return "Async"
	case PluginRunMode_Streaming:
		return "Streaming"
	}
	return "<UNSET>"
}

func PluginRunModeFromString(s string) (PluginRunMode, error) {
	switch s {
	case "DefaultToSync":
		return PluginRunMode_DefaultToSync, nil
	case "Sync":
		return PluginRunMode_Sync, nil
	case "Async":
		return PluginRunMode_Async, nil
	case "Streaming":
		return PluginRunMode_Streaming, nil
	}
	return PluginRunMode(0), fmt.Errorf("not a valid PluginRunMode string")
}

func PluginRunModePtr(v PluginRunMode) *PluginRunMode { return &v }
func (p *PluginRunMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PluginRunMode(result.Int64)
	return
}

func (p *PluginRunMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type TimeCapsuleMode int64

const (
	TimeCapsuleMode_Off TimeCapsuleMode = 0
	TimeCapsuleMode_On  TimeCapsuleMode = 1
)

func (p TimeCapsuleMode) String() string {
	switch p {
	case TimeCapsuleMode_Off:
		return "Off"
	case TimeCapsuleMode_On:
		return "On"
	}
	return "<UNSET>"
}

func TimeCapsuleModeFromString(s string) (TimeCapsuleMode, error) {
	switch s {
	case "Off":
		return TimeCapsuleMode_Off, nil
	case "On":
		return TimeCapsuleMode_On, nil
	}
	return TimeCapsuleMode(0), fmt.Errorf("not a valid TimeCapsuleMode string")
}

func TimeCapsuleModePtr(v TimeCapsuleMode) *TimeCapsuleMode { return &v }
func (p *TimeCapsuleMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = TimeCapsuleMode(result.Int64)
	return
}

func (p *TimeCapsuleMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type FileboxInfoMode int64

const (
	FileboxInfoMode_Off FileboxInfoMode = 0
	FileboxInfoMode_On  FileboxInfoMode = 1
)

func (p FileboxInfoMode) String() string {
	switch p {
	case FileboxInfoMode_Off:
		return "Off"
	case FileboxInfoMode_On:
		return "On"
	}
	return "<UNSET>"
}

func FileboxInfoModeFromString(s string) (FileboxInfoMode, error) {
	switch s {
	case "Off":
		return FileboxInfoMode_Off, nil
	case "On":
		return FileboxInfoMode_On, nil
	}
	return FileboxInfoMode(0), fmt.Errorf("not a valid FileboxInfoMode string")
}

func FileboxInfoModePtr(v FileboxInfoMode) *FileboxInfoMode { return &v }
func (p *FileboxInfoMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = FileboxInfoMode(result.Int64)
	return
}

func (p *FileboxInfoMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type TriggerEnable int64

const (
	TriggerEnable_Init  TriggerEnable = 0
	TriggerEnable_Open  TriggerEnable = 1
	TriggerEnable_Close TriggerEnable = 2
)

func (p TriggerEnable) String() string {
	switch p {
	case TriggerEnable_Init:
		return "Init"
	case TriggerEnable_Open:
		return "Open"
	case TriggerEnable_Close:
		return "Close"
	}
	return "<UNSET>"
}

func TriggerEnableFromString(s string) (TriggerEnable, error) {
	switch s {
	case "Init":
		return TriggerEnable_Init, nil
	case "Open":
		return TriggerEnable_Open, nil
	case "Close":
		return TriggerEnable_Close, nil
	}
	return TriggerEnable(0), fmt.Errorf("not a valid TriggerEnable string")
}

func TriggerEnablePtr(v TriggerEnable) *TriggerEnable { return &v }
func (p *TriggerEnable) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = TriggerEnable(result.Int64)
	return
}

func (p *TriggerEnable) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type FavoriteProductResponse struct {
	Code            int32          `thrift:"Code,1,required" form:"code,required" json:"code,required"`
	Message         string         `thrift:"Message,2,required" form:"message,required" json:"message,required"`
	IsFirstFavorite *bool          `thrift:"IsFirstFavorite,3,optional" form:"is_first_favorite" json:"is_first_favorite,omitempty"`
	BaseResp        *base.BaseResp `thrift:"BaseResp,255,optional" form:"BaseResp" json:"BaseResp,omitempty" query:"BaseResp"`
}

func NewFavoriteProductResponse() *FavoriteProductResponse {
	return &FavoriteProductResponse{}
}

func (p *FavoriteProductResponse) InitDefault() {
}

func (p *FavoriteProductResponse) GetCode() (v int32) {
	return p.Code
}

func (p *FavoriteProductResponse) GetMessage() (v string) {
	return p.Message
}

var FavoriteProductResponse_IsFirstFavorite_DEFAULT bool

func (p *FavoriteProductResponse) GetIsFirstFavorite() (v bool) {
	if !p.IsSetIsFirstFavorite() {
		return FavoriteProductResponse_IsFirstFavorite_DEFAULT
	}
	return *p.IsFirstFavorite
}

var FavoriteProductResponse_BaseResp_DEFAULT *base.BaseResp

func (p *FavoriteProductResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return FavoriteProductResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_FavoriteProductResponse = map[int16]string{
	1:   "Code",
	2:   "Message",
	3:   "IsFirstFavorite",
	255: "BaseResp",
}

func (p *FavoriteProductResponse) IsSetIsFirstFavorite() bool {
	return p.IsFirstFavorite != nil
}

func (p *FavoriteProductResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *FavoriteProductResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMessage bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetMessage = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetMessage {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_FavoriteProductResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_FavoriteProductResponse[fieldId]))
}

func (p *FavoriteProductResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *FavoriteProductResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Message = _field
	return nil
}
func (p *FavoriteProductResponse) ReadField3(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsFirstFavorite = _field
	return nil
}
func (p *FavoriteProductResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *FavoriteProductResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("FavoriteProductResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *FavoriteProductResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Code", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *FavoriteProductResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Message", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Message); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *FavoriteProductResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsFirstFavorite() {
		if err = oprot.WriteFieldBegin("IsFirstFavorite", thrift.BOOL, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsFirstFavorite); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *FavoriteProductResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseResp() {
		if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BaseResp.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *FavoriteProductResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FavoriteProductResponse(%+v)", *p)

}

type FavoriteProductRequest struct {
	ProductID  *int64                           `thrift:"ProductID,1,optional" form:"product_id" json:"product_id,string,omitempty"`
	EntityType product_common.ProductEntityType `thrift:"EntityType,2,required" form:"entity_type,required" json:"entity_type,required"`
	IsCancel   *bool                            `thrift:"IsCancel,3,optional" form:"is_cancel" json:"is_cancel,omitempty"`
	EntityID   *int64                           `thrift:"EntityID,4,optional" form:"entity_id" json:"entity_id,string,omitempty"`
	TopicID    *int64                           `thrift:"TopicID,5,optional" form:"topic_id" json:"topic_id,string,omitempty"`
	Cookie     *string                          `thrift:"Cookie,100,optional" jsonlog:"-" json:"-" form:"Cookie" query:"Cookie"`
	Base       *base.Base                       `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewFavoriteProductRequest() *FavoriteProductRequest {
	return &FavoriteProductRequest{}
}

func (p *FavoriteProductRequest) InitDefault() {
}

var FavoriteProductRequest_ProductID_DEFAULT int64

func (p *FavoriteProductRequest) GetProductID() (v int64) {
	if !p.IsSetProductID() {
		return FavoriteProductRequest_ProductID_DEFAULT
	}
	return *p.ProductID
}

func (p *FavoriteProductRequest) GetEntityType() (v product_common.ProductEntityType) {
	return p.EntityType
}

var FavoriteProductRequest_IsCancel_DEFAULT bool

func (p *FavoriteProductRequest) GetIsCancel() (v bool) {
	if !p.IsSetIsCancel() {
		return FavoriteProductRequest_IsCancel_DEFAULT
	}
	return *p.IsCancel
}

var FavoriteProductRequest_EntityID_DEFAULT int64

func (p *FavoriteProductRequest) GetEntityID() (v int64) {
	if !p.IsSetEntityID() {
		return FavoriteProductRequest_EntityID_DEFAULT
	}
	return *p.EntityID
}

var FavoriteProductRequest_TopicID_DEFAULT int64

func (p *FavoriteProductRequest) GetTopicID() (v int64) {
	if !p.IsSetTopicID() {
		return FavoriteProductRequest_TopicID_DEFAULT
	}
	return *p.TopicID
}

var FavoriteProductRequest_Cookie_DEFAULT string

func (p *FavoriteProductRequest) GetCookie() (v string) {
	if !p.IsSetCookie() {
		return FavoriteProductRequest_Cookie_DEFAULT
	}
	return *p.Cookie
}

var FavoriteProductRequest_Base_DEFAULT *base.Base

func (p *FavoriteProductRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return FavoriteProductRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_FavoriteProductRequest = map[int16]string{
	1:   "ProductID",
	2:   "EntityType",
	3:   "IsCancel",
	4:   "EntityID",
	5:   "TopicID",
	100: "Cookie",
	255: "Base",
}

func (p *FavoriteProductRequest) IsSetProductID() bool {
	return p.ProductID != nil
}

func (p *FavoriteProductRequest) IsSetIsCancel() bool {
	return p.IsCancel != nil
}

func (p *FavoriteProductRequest) IsSetEntityID() bool {
	return p.EntityID != nil
}

func (p *FavoriteProductRequest) IsSetTopicID() bool {
	return p.TopicID != nil
}

func (p *FavoriteProductRequest) IsSetCookie() bool {
	return p.Cookie != nil
}

func (p *FavoriteProductRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *FavoriteProductRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetEntityType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetEntityType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 100:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField100(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetEntityType {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_FavoriteProductRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_FavoriteProductRequest[fieldId]))
}

func (p *FavoriteProductRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProductID = _field
	return nil
}
func (p *FavoriteProductRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductEntityType(v)
	}
	p.EntityType = _field
	return nil
}
func (p *FavoriteProductRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsCancel = _field
	return nil
}
func (p *FavoriteProductRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EntityID = _field
	return nil
}
func (p *FavoriteProductRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TopicID = _field
	return nil
}
func (p *FavoriteProductRequest) ReadField100(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Cookie = _field
	return nil
}
func (p *FavoriteProductRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *FavoriteProductRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("FavoriteProductRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField100(oprot); err != nil {
			fieldId = 100
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *FavoriteProductRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetProductID() {
		if err = oprot.WriteFieldBegin("ProductID", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ProductID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *FavoriteProductRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityType", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.EntityType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *FavoriteProductRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsCancel() {
		if err = oprot.WriteFieldBegin("IsCancel", thrift.BOOL, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsCancel); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *FavoriteProductRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityID() {
		if err = oprot.WriteFieldBegin("EntityID", thrift.I64, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.EntityID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *FavoriteProductRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetTopicID() {
		if err = oprot.WriteFieldBegin("TopicID", thrift.I64, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.TopicID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *FavoriteProductRequest) writeField100(oprot thrift.TProtocol) (err error) {
	if p.IsSetCookie() {
		if err = oprot.WriteFieldBegin("Cookie", thrift.STRING, 100); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Cookie); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 100 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 100 end error: ", p), err)
}
func (p *FavoriteProductRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *FavoriteProductRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FavoriteProductRequest(%+v)", *p)

}

type GetProductListRequest struct {
	EntityType *product_common.ProductEntityType `thrift:"EntityType,1,optional" form:"entity_type" json:"entity_type,omitempty"`
	CategoryID *int64                            `thrift:"CategoryID,2,optional" json:"CategoryID,string,omitempty" query:"category_id"`
	SortType   product_common.SortType           `thrift:"SortType,3,required" form:"sort_type,required" json:"sort_type,required"`
	PageNum    int32                             `thrift:"PageNum,4,required" form:"page_num,required" json:"page_num,required"`
	PageSize   int32                             `thrift:"PageSize,5,required" form:"page_size,required" json:"page_size,required"`
	// non-empty search
	Keyword *string `thrift:"Keyword,6,optional" form:"keyword" json:"keyword,omitempty"`
	// Open mode: 1-open source; 2-closed source,//open mode
	PublishMode *product_common.ProductPublishMode `thrift:"PublishMode,7,optional" form:"publish_mode" json:"publish_mode,omitempty"`
	// publish platforms
	PublishPlatformIDs []int64 `thrift:"PublishPlatformIDs,8,optional" form:"PublishPlatformIDs" json:"PublishPlatformIDs,string,omitempty" query:"PublishPlatformIDs"`
	// List tab; 1 - Operational recommendations
	Source *product_common.ProductListSource `thrift:"Source,9,optional" form:"source" json:"source,omitempty"`
	// Personalized recommendation scenarios, enter current entity information, and obtain recommended products
	CurrentEntityType *product_common.ProductEntityType `thrift:"CurrentEntityType,10,optional" form:"current_entity_type" json:"current_entity_type,omitempty"`
	// Current entity ID
	CurrentEntityID *int64 `thrift:"CurrentEntityID,11,optional" json:"CurrentEntityID,string,omitempty" query:"current_entity_id"`
	// Current entity version
	CurrentEntityVersion *int64 `thrift:"CurrentEntityVersion,12,optional" json:"CurrentEntityVersion,string,omitempty" query:"current_entity_version"`
	// thematic scenario
	TopicID        *int64  `thrift:"TopicID,13,optional" json:"TopicID,string,omitempty" query:"topic_id"`
	PreviewTopicID *string `thrift:"PreviewTopicID,14,optional" form:"preview_topic_id" json:"preview_topic_id,omitempty"`
	// Do you need to filter out official products?
	IsOfficial *bool `thrift:"IsOfficial,15,optional" form:"is_official" json:"is_official,omitempty"`
	// Do you need to return additional information?
	NeedExtra *bool `thrift:"NeedExtra,16,optional" form:"need_extra" json:"need_extra,omitempty"`
	// List of product types, use this parameter first, followed by EntityType
	EntityTypes []product_common.ProductEntityType `thrift:"EntityTypes,17,optional" form:"entity_types" json:"entity_types,omitempty"`
	// True = filter for free; false = filter for paid; if you don't pass it, you won't distinguish between free and paid.
	IsFree *bool `thrift:"IsFree,18,optional" form:"is_free" json:"is_free,omitempty"`
	// plugin type
	PluginType *product_common.PluginType `thrift:"PluginType,19,optional" form:"plugin_type" json:"plugin_type,omitempty"`
	ClientIP   *string                    `thrift:"ClientIP,101,optional" header:"Tt-Agw-Client-Ip" json:"ClientIP,omitempty"`
	Base       *base.Base                 `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetProductListRequest() *GetProductListRequest {
	return &GetProductListRequest{}
}

func (p *GetProductListRequest) InitDefault() {
}

var GetProductListRequest_EntityType_DEFAULT product_common.ProductEntityType

func (p *GetProductListRequest) GetEntityType() (v product_common.ProductEntityType) {
	if !p.IsSetEntityType() {
		return GetProductListRequest_EntityType_DEFAULT
	}
	return *p.EntityType
}

var GetProductListRequest_CategoryID_DEFAULT int64

func (p *GetProductListRequest) GetCategoryID() (v int64) {
	if !p.IsSetCategoryID() {
		return GetProductListRequest_CategoryID_DEFAULT
	}
	return *p.CategoryID
}

func (p *GetProductListRequest) GetSortType() (v product_common.SortType) {
	return p.SortType
}

func (p *GetProductListRequest) GetPageNum() (v int32) {
	return p.PageNum
}

func (p *GetProductListRequest) GetPageSize() (v int32) {
	return p.PageSize
}

var GetProductListRequest_Keyword_DEFAULT string

func (p *GetProductListRequest) GetKeyword() (v string) {
	if !p.IsSetKeyword() {
		return GetProductListRequest_Keyword_DEFAULT
	}
	return *p.Keyword
}

var GetProductListRequest_PublishMode_DEFAULT product_common.ProductPublishMode

func (p *GetProductListRequest) GetPublishMode() (v product_common.ProductPublishMode) {
	if !p.IsSetPublishMode() {
		return GetProductListRequest_PublishMode_DEFAULT
	}
	return *p.PublishMode
}

var GetProductListRequest_PublishPlatformIDs_DEFAULT []int64

func (p *GetProductListRequest) GetPublishPlatformIDs() (v []int64) {
	if !p.IsSetPublishPlatformIDs() {
		return GetProductListRequest_PublishPlatformIDs_DEFAULT
	}
	return p.PublishPlatformIDs
}

var GetProductListRequest_Source_DEFAULT product_common.ProductListSource

func (p *GetProductListRequest) GetSource() (v product_common.ProductListSource) {
	if !p.IsSetSource() {
		return GetProductListRequest_Source_DEFAULT
	}
	return *p.Source
}

var GetProductListRequest_CurrentEntityType_DEFAULT product_common.ProductEntityType

func (p *GetProductListRequest) GetCurrentEntityType() (v product_common.ProductEntityType) {
	if !p.IsSetCurrentEntityType() {
		return GetProductListRequest_CurrentEntityType_DEFAULT
	}
	return *p.CurrentEntityType
}

var GetProductListRequest_CurrentEntityID_DEFAULT int64

func (p *GetProductListRequest) GetCurrentEntityID() (v int64) {
	if !p.IsSetCurrentEntityID() {
		return GetProductListRequest_CurrentEntityID_DEFAULT
	}
	return *p.CurrentEntityID
}

var GetProductListRequest_CurrentEntityVersion_DEFAULT int64

func (p *GetProductListRequest) GetCurrentEntityVersion() (v int64) {
	if !p.IsSetCurrentEntityVersion() {
		return GetProductListRequest_CurrentEntityVersion_DEFAULT
	}
	return *p.CurrentEntityVersion
}

var GetProductListRequest_TopicID_DEFAULT int64

func (p *GetProductListRequest) GetTopicID() (v int64) {
	if !p.IsSetTopicID() {
		return GetProductListRequest_TopicID_DEFAULT
	}
	return *p.TopicID
}

var GetProductListRequest_PreviewTopicID_DEFAULT string

func (p *GetProductListRequest) GetPreviewTopicID() (v string) {
	if !p.IsSetPreviewTopicID() {
		return GetProductListRequest_PreviewTopicID_DEFAULT
	}
	return *p.PreviewTopicID
}

var GetProductListRequest_IsOfficial_DEFAULT bool

func (p *GetProductListRequest) GetIsOfficial() (v bool) {
	if !p.IsSetIsOfficial() {
		return GetProductListRequest_IsOfficial_DEFAULT
	}
	return *p.IsOfficial
}

var GetProductListRequest_NeedExtra_DEFAULT bool

func (p *GetProductListRequest) GetNeedExtra() (v bool) {
	if !p.IsSetNeedExtra() {
		return GetProductListRequest_NeedExtra_DEFAULT
	}
	return *p.NeedExtra
}

var GetProductListRequest_EntityTypes_DEFAULT []product_common.ProductEntityType

func (p *GetProductListRequest) GetEntityTypes() (v []product_common.ProductEntityType) {
	if !p.IsSetEntityTypes() {
		return GetProductListRequest_EntityTypes_DEFAULT
	}
	return p.EntityTypes
}

var GetProductListRequest_IsFree_DEFAULT bool

func (p *GetProductListRequest) GetIsFree() (v bool) {
	if !p.IsSetIsFree() {
		return GetProductListRequest_IsFree_DEFAULT
	}
	return *p.IsFree
}

var GetProductListRequest_PluginType_DEFAULT product_common.PluginType

func (p *GetProductListRequest) GetPluginType() (v product_common.PluginType) {
	if !p.IsSetPluginType() {
		return GetProductListRequest_PluginType_DEFAULT
	}
	return *p.PluginType
}

var GetProductListRequest_ClientIP_DEFAULT string

func (p *GetProductListRequest) GetClientIP() (v string) {
	if !p.IsSetClientIP() {
		return GetProductListRequest_ClientIP_DEFAULT
	}
	return *p.ClientIP
}

var GetProductListRequest_Base_DEFAULT *base.Base

func (p *GetProductListRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetProductListRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetProductListRequest = map[int16]string{
	1:   "EntityType",
	2:   "CategoryID",
	3:   "SortType",
	4:   "PageNum",
	5:   "PageSize",
	6:   "Keyword",
	7:   "PublishMode",
	8:   "PublishPlatformIDs",
	9:   "Source",
	10:  "CurrentEntityType",
	11:  "CurrentEntityID",
	12:  "CurrentEntityVersion",
	13:  "TopicID",
	14:  "PreviewTopicID",
	15:  "IsOfficial",
	16:  "NeedExtra",
	17:  "EntityTypes",
	18:  "IsFree",
	19:  "PluginType",
	101: "ClientIP",
	255: "Base",
}

func (p *GetProductListRequest) IsSetEntityType() bool {
	return p.EntityType != nil
}

func (p *GetProductListRequest) IsSetCategoryID() bool {
	return p.CategoryID != nil
}

func (p *GetProductListRequest) IsSetKeyword() bool {
	return p.Keyword != nil
}

func (p *GetProductListRequest) IsSetPublishMode() bool {
	return p.PublishMode != nil
}

func (p *GetProductListRequest) IsSetPublishPlatformIDs() bool {
	return p.PublishPlatformIDs != nil
}

func (p *GetProductListRequest) IsSetSource() bool {
	return p.Source != nil
}

func (p *GetProductListRequest) IsSetCurrentEntityType() bool {
	return p.CurrentEntityType != nil
}

func (p *GetProductListRequest) IsSetCurrentEntityID() bool {
	return p.CurrentEntityID != nil
}

func (p *GetProductListRequest) IsSetCurrentEntityVersion() bool {
	return p.CurrentEntityVersion != nil
}

func (p *GetProductListRequest) IsSetTopicID() bool {
	return p.TopicID != nil
}

func (p *GetProductListRequest) IsSetPreviewTopicID() bool {
	return p.PreviewTopicID != nil
}

func (p *GetProductListRequest) IsSetIsOfficial() bool {
	return p.IsOfficial != nil
}

func (p *GetProductListRequest) IsSetNeedExtra() bool {
	return p.NeedExtra != nil
}

func (p *GetProductListRequest) IsSetEntityTypes() bool {
	return p.EntityTypes != nil
}

func (p *GetProductListRequest) IsSetIsFree() bool {
	return p.IsFree != nil
}

func (p *GetProductListRequest) IsSetPluginType() bool {
	return p.PluginType != nil
}

func (p *GetProductListRequest) IsSetClientIP() bool {
	return p.ClientIP != nil
}

func (p *GetProductListRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetProductListRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSortType bool = false
	var issetPageNum bool = false
	var issetPageSize bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetSortType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetPageNum = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
				issetPageSize = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 101:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField101(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSortType {
		fieldId = 3
		goto RequiredFieldNotSetError
	}

	if !issetPageNum {
		fieldId = 4
		goto RequiredFieldNotSetError
	}

	if !issetPageSize {
		fieldId = 5
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetProductListRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetProductListRequest[fieldId]))
}

func (p *GetProductListRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.ProductEntityType(v)
		_field = &tmp
	}
	p.EntityType = _field
	return nil
}
func (p *GetProductListRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CategoryID = _field
	return nil
}
func (p *GetProductListRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field product_common.SortType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.SortType(v)
	}
	p.SortType = _field
	return nil
}
func (p *GetProductListRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PageNum = _field
	return nil
}
func (p *GetProductListRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PageSize = _field
	return nil
}
func (p *GetProductListRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Keyword = _field
	return nil
}
func (p *GetProductListRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *product_common.ProductPublishMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.ProductPublishMode(v)
		_field = &tmp
	}
	p.PublishMode = _field
	return nil
}
func (p *GetProductListRequest) ReadField8(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]int64, 0, size)
	for i := 0; i < size; i++ {

		var _elem int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.PublishPlatformIDs = _field
	return nil
}
func (p *GetProductListRequest) ReadField9(iprot thrift.TProtocol) error {

	var _field *product_common.ProductListSource
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.ProductListSource(v)
		_field = &tmp
	}
	p.Source = _field
	return nil
}
func (p *GetProductListRequest) ReadField10(iprot thrift.TProtocol) error {

	var _field *product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.ProductEntityType(v)
		_field = &tmp
	}
	p.CurrentEntityType = _field
	return nil
}
func (p *GetProductListRequest) ReadField11(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CurrentEntityID = _field
	return nil
}
func (p *GetProductListRequest) ReadField12(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CurrentEntityVersion = _field
	return nil
}
func (p *GetProductListRequest) ReadField13(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TopicID = _field
	return nil
}
func (p *GetProductListRequest) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PreviewTopicID = _field
	return nil
}
func (p *GetProductListRequest) ReadField15(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsOfficial = _field
	return nil
}
func (p *GetProductListRequest) ReadField16(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedExtra = _field
	return nil
}
func (p *GetProductListRequest) ReadField17(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]product_common.ProductEntityType, 0, size)
	for i := 0; i < size; i++ {

		var _elem product_common.ProductEntityType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_elem = product_common.ProductEntityType(v)
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.EntityTypes = _field
	return nil
}
func (p *GetProductListRequest) ReadField18(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsFree = _field
	return nil
}
func (p *GetProductListRequest) ReadField19(iprot thrift.TProtocol) error {

	var _field *product_common.PluginType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.PluginType(v)
		_field = &tmp
	}
	p.PluginType = _field
	return nil
}
func (p *GetProductListRequest) ReadField101(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ClientIP = _field
	return nil
}
func (p *GetProductListRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetProductListRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetProductListRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField101(oprot); err != nil {
			fieldId = 101
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetProductListRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityType() {
		if err = oprot.WriteFieldBegin("EntityType", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.EntityType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetProductListRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetCategoryID() {
		if err = oprot.WriteFieldBegin("CategoryID", thrift.I64, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.CategoryID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetProductListRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("SortType", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SortType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetProductListRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PageNum", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.PageNum); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetProductListRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PageSize", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.PageSize); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetProductListRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetKeyword() {
		if err = oprot.WriteFieldBegin("Keyword", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Keyword); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetProductListRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishMode() {
		if err = oprot.WriteFieldBegin("PublishMode", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.PublishMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetProductListRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishPlatformIDs() {
		if err = oprot.WriteFieldBegin("PublishPlatformIDs", thrift.LIST, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.I64, len(p.PublishPlatformIDs)); err != nil {
			return err
		}
		for _, v := range p.PublishPlatformIDs {
			if err := oprot.WriteI64(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetProductListRequest) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetSource() {
		if err = oprot.WriteFieldBegin("Source", thrift.I32, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Source)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *GetProductListRequest) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetCurrentEntityType() {
		if err = oprot.WriteFieldBegin("CurrentEntityType", thrift.I32, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.CurrentEntityType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *GetProductListRequest) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetCurrentEntityID() {
		if err = oprot.WriteFieldBegin("CurrentEntityID", thrift.I64, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.CurrentEntityID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *GetProductListRequest) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetCurrentEntityVersion() {
		if err = oprot.WriteFieldBegin("CurrentEntityVersion", thrift.I64, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.CurrentEntityVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *GetProductListRequest) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetTopicID() {
		if err = oprot.WriteFieldBegin("TopicID", thrift.I64, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.TopicID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *GetProductListRequest) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetPreviewTopicID() {
		if err = oprot.WriteFieldBegin("PreviewTopicID", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PreviewTopicID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *GetProductListRequest) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsOfficial() {
		if err = oprot.WriteFieldBegin("IsOfficial", thrift.BOOL, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsOfficial); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *GetProductListRequest) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedExtra() {
		if err = oprot.WriteFieldBegin("NeedExtra", thrift.BOOL, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedExtra); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *GetProductListRequest) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityTypes() {
		if err = oprot.WriteFieldBegin("EntityTypes", thrift.LIST, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.I32, len(p.EntityTypes)); err != nil {
			return err
		}
		for _, v := range p.EntityTypes {
			if err := oprot.WriteI32(int32(v)); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *GetProductListRequest) writeField18(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsFree() {
		if err = oprot.WriteFieldBegin("IsFree", thrift.BOOL, 18); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsFree); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *GetProductListRequest) writeField19(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginType() {
		if err = oprot.WriteFieldBegin("PluginType", thrift.I32, 19); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.PluginType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *GetProductListRequest) writeField101(oprot thrift.TProtocol) (err error) {
	if p.IsSetClientIP() {
		if err = oprot.WriteFieldBegin("ClientIP", thrift.STRING, 101); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ClientIP); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 101 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 101 end error: ", p), err)
}
func (p *GetProductListRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetProductListRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetProductListRequest(%+v)", *p)

}

type GetProductListResponse struct {
	Code     int32               `thrift:"Code,1,required" form:"code,required" json:"code,required"`
	Message  string              `thrift:"Message,2,required" form:"message,required" json:"message,required"`
	Data     *GetProductListData `thrift:"Data,3" form:"data" json:"data"`
	BaseResp *base.BaseResp      `thrift:"BaseResp,255,optional" form:"BaseResp" json:"BaseResp,omitempty" query:"BaseResp"`
}

func NewGetProductListResponse() *GetProductListResponse {
	return &GetProductListResponse{}
}

func (p *GetProductListResponse) InitDefault() {
}

func (p *GetProductListResponse) GetCode() (v int32) {
	return p.Code
}

func (p *GetProductListResponse) GetMessage() (v string) {
	return p.Message
}

var GetProductListResponse_Data_DEFAULT *GetProductListData

func (p *GetProductListResponse) GetData() (v *GetProductListData) {
	if !p.IsSetData() {
		return GetProductListResponse_Data_DEFAULT
	}
	return p.Data
}

var GetProductListResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetProductListResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetProductListResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetProductListResponse = map[int16]string{
	1:   "Code",
	2:   "Message",
	3:   "Data",
	255: "BaseResp",
}

func (p *GetProductListResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetProductListResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetProductListResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMessage bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetMessage = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetMessage {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetProductListResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetProductListResponse[fieldId]))
}

func (p *GetProductListResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetProductListResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Message = _field
	return nil
}
func (p *GetProductListResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetProductListData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetProductListResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetProductListResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetProductListResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetProductListResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Code", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetProductListResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Message", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Message); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetProductListResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetProductListResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseResp() {
		if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BaseResp.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetProductListResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetProductListResponse(%+v)", *p)

}

type GetProductListData struct {
	Products []*ProductInfo `thrift:"Products,1,optional" form:"products" json:"products,omitempty"`
	HasMore  bool           `thrift:"HasMore,2" form:"has_more" json:"has_more"`
	Total    int32          `thrift:"Total,3" form:"total" json:"total"`
}

func NewGetProductListData() *GetProductListData {
	return &GetProductListData{}
}

func (p *GetProductListData) InitDefault() {
}

var GetProductListData_Products_DEFAULT []*ProductInfo

func (p *GetProductListData) GetProducts() (v []*ProductInfo) {
	if !p.IsSetProducts() {
		return GetProductListData_Products_DEFAULT
	}
	return p.Products
}

func (p *GetProductListData) GetHasMore() (v bool) {
	return p.HasMore
}

func (p *GetProductListData) GetTotal() (v int32) {
	return p.Total
}

var fieldIDToName_GetProductListData = map[int16]string{
	1: "Products",
	2: "HasMore",
	3: "Total",
}

func (p *GetProductListData) IsSetProducts() bool {
	return p.Products != nil
}

func (p *GetProductListData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetProductListData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetProductListData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ProductInfo, 0, size)
	values := make([]ProductInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Products = _field
	return nil
}
func (p *GetProductListData) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.HasMore = _field
	return nil
}
func (p *GetProductListData) ReadField3(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Total = _field
	return nil
}

func (p *GetProductListData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetProductListData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetProductListData) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetProducts() {
		if err = oprot.WriteFieldBegin("Products", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Products)); err != nil {
			return err
		}
		for _, v := range p.Products {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetProductListData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("HasMore", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.HasMore); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetProductListData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Total", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Total); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetProductListData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetProductListData(%+v)", *p)

}

type ProductInfo struct {
	MetaInfo          *ProductMetaInfo                  `thrift:"MetaInfo,1,required" form:"meta_info,required" json:"meta_info,required"`
	UserBehavior      *UserBehaviorInfo                 `thrift:"UserBehavior,2,optional" form:"user_behavior" json:"user_behavior,omitempty"`
	CommercialSetting *product_common.CommercialSetting `thrift:"CommercialSetting,3,optional" form:"commercial_setting" json:"commercial_setting,omitempty"`
	PluginExtra       *PluginExtraInfo                  `thrift:"PluginExtra,20,optional" form:"plugin_extra" json:"plugin_extra,omitempty"`
	BotExtra          *BotExtraInfo                     `thrift:"BotExtra,21,optional" form:"bot_extra" json:"bot_extra,omitempty"`
	WorkflowExtra     *WorkflowExtraInfo                `thrift:"WorkflowExtra,22,optional" form:"workflow_extra" json:"workflow_extra,omitempty"`
	SocialSceneExtra  *SocialSceneExtraInfo             `thrift:"SocialSceneExtra,23,optional" form:"social_scene_extra" json:"social_scene_extra,omitempty"`
	ProjectExtra      *ProjectExtraInfo                 `thrift:"ProjectExtra,24,optional" form:"project_extra" json:"project_extra,omitempty"`
}

func NewProductInfo() *ProductInfo {
	return &ProductInfo{}
}

func (p *ProductInfo) InitDefault() {
}

var ProductInfo_MetaInfo_DEFAULT *ProductMetaInfo

func (p *ProductInfo) GetMetaInfo() (v *ProductMetaInfo) {
	if !p.IsSetMetaInfo() {
		return ProductInfo_MetaInfo_DEFAULT
	}
	return p.MetaInfo
}

var ProductInfo_UserBehavior_DEFAULT *UserBehaviorInfo

func (p *ProductInfo) GetUserBehavior() (v *UserBehaviorInfo) {
	if !p.IsSetUserBehavior() {
		return ProductInfo_UserBehavior_DEFAULT
	}
	return p.UserBehavior
}

var ProductInfo_CommercialSetting_DEFAULT *product_common.CommercialSetting

func (p *ProductInfo) GetCommercialSetting() (v *product_common.CommercialSetting) {
	if !p.IsSetCommercialSetting() {
		return ProductInfo_CommercialSetting_DEFAULT
	}
	return p.CommercialSetting
}

var ProductInfo_PluginExtra_DEFAULT *PluginExtraInfo

func (p *ProductInfo) GetPluginExtra() (v *PluginExtraInfo) {
	if !p.IsSetPluginExtra() {
		return ProductInfo_PluginExtra_DEFAULT
	}
	return p.PluginExtra
}

var ProductInfo_BotExtra_DEFAULT *BotExtraInfo

func (p *ProductInfo) GetBotExtra() (v *BotExtraInfo) {
	if !p.IsSetBotExtra() {
		return ProductInfo_BotExtra_DEFAULT
	}
	return p.BotExtra
}

var ProductInfo_WorkflowExtra_DEFAULT *WorkflowExtraInfo

func (p *ProductInfo) GetWorkflowExtra() (v *WorkflowExtraInfo) {
	if !p.IsSetWorkflowExtra() {
		return ProductInfo_WorkflowExtra_DEFAULT
	}
	return p.WorkflowExtra
}

var ProductInfo_SocialSceneExtra_DEFAULT *SocialSceneExtraInfo

func (p *ProductInfo) GetSocialSceneExtra() (v *SocialSceneExtraInfo) {
	if !p.IsSetSocialSceneExtra() {
		return ProductInfo_SocialSceneExtra_DEFAULT
	}
	return p.SocialSceneExtra
}

var ProductInfo_ProjectExtra_DEFAULT *ProjectExtraInfo

func (p *ProductInfo) GetProjectExtra() (v *ProjectExtraInfo) {
	if !p.IsSetProjectExtra() {
		return ProductInfo_ProjectExtra_DEFAULT
	}
	return p.ProjectExtra
}

var fieldIDToName_ProductInfo = map[int16]string{
	1:  "MetaInfo",
	2:  "UserBehavior",
	3:  "CommercialSetting",
	20: "PluginExtra",
	21: "BotExtra",
	22: "WorkflowExtra",
	23: "SocialSceneExtra",
	24: "ProjectExtra",
}

func (p *ProductInfo) IsSetMetaInfo() bool {
	return p.MetaInfo != nil
}

func (p *ProductInfo) IsSetUserBehavior() bool {
	return p.UserBehavior != nil
}

func (p *ProductInfo) IsSetCommercialSetting() bool {
	return p.CommercialSetting != nil
}

func (p *ProductInfo) IsSetPluginExtra() bool {
	return p.PluginExtra != nil
}

func (p *ProductInfo) IsSetBotExtra() bool {
	return p.BotExtra != nil
}

func (p *ProductInfo) IsSetWorkflowExtra() bool {
	return p.WorkflowExtra != nil
}

func (p *ProductInfo) IsSetSocialSceneExtra() bool {
	return p.SocialSceneExtra != nil
}

func (p *ProductInfo) IsSetProjectExtra() bool {
	return p.ProjectExtra != nil
}

func (p *ProductInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetMetaInfo bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetMetaInfo = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 22:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField22(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 23:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField23(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 24:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField24(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetMetaInfo {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProductInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ProductInfo[fieldId]))
}

func (p *ProductInfo) ReadField1(iprot thrift.TProtocol) error {
	_field := NewProductMetaInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.MetaInfo = _field
	return nil
}
func (p *ProductInfo) ReadField2(iprot thrift.TProtocol) error {
	_field := NewUserBehaviorInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserBehavior = _field
	return nil
}
func (p *ProductInfo) ReadField3(iprot thrift.TProtocol) error {
	_field := product_common.NewCommercialSetting()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.CommercialSetting = _field
	return nil
}
func (p *ProductInfo) ReadField20(iprot thrift.TProtocol) error {
	_field := NewPluginExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.PluginExtra = _field
	return nil
}
func (p *ProductInfo) ReadField21(iprot thrift.TProtocol) error {
	_field := NewBotExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BotExtra = _field
	return nil
}
func (p *ProductInfo) ReadField22(iprot thrift.TProtocol) error {
	_field := NewWorkflowExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.WorkflowExtra = _field
	return nil
}
func (p *ProductInfo) ReadField23(iprot thrift.TProtocol) error {
	_field := NewSocialSceneExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.SocialSceneExtra = _field
	return nil
}
func (p *ProductInfo) ReadField24(iprot thrift.TProtocol) error {
	_field := NewProjectExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ProjectExtra = _field
	return nil
}

func (p *ProductInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProductInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
		if err = p.writeField22(oprot); err != nil {
			fieldId = 22
			goto WriteFieldError
		}
		if err = p.writeField23(oprot); err != nil {
			fieldId = 23
			goto WriteFieldError
		}
		if err = p.writeField24(oprot); err != nil {
			fieldId = 24
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProductInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("MetaInfo", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.MetaInfo.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ProductInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserBehavior() {
		if err = oprot.WriteFieldBegin("UserBehavior", thrift.STRUCT, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.UserBehavior.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ProductInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommercialSetting() {
		if err = oprot.WriteFieldBegin("CommercialSetting", thrift.STRUCT, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.CommercialSetting.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ProductInfo) writeField20(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginExtra() {
		if err = oprot.WriteFieldBegin("PluginExtra", thrift.STRUCT, 20); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.PluginExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}
func (p *ProductInfo) writeField21(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotExtra() {
		if err = oprot.WriteFieldBegin("BotExtra", thrift.STRUCT, 21); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BotExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}
func (p *ProductInfo) writeField22(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowExtra() {
		if err = oprot.WriteFieldBegin("WorkflowExtra", thrift.STRUCT, 22); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.WorkflowExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 end error: ", p), err)
}
func (p *ProductInfo) writeField23(oprot thrift.TProtocol) (err error) {
	if p.IsSetSocialSceneExtra() {
		if err = oprot.WriteFieldBegin("SocialSceneExtra", thrift.STRUCT, 23); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.SocialSceneExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 end error: ", p), err)
}
func (p *ProductInfo) writeField24(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectExtra() {
		if err = oprot.WriteFieldBegin("ProjectExtra", thrift.STRUCT, 24); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.ProjectExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 end error: ", p), err)
}

func (p *ProductInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProductInfo(%+v)", *p)

}

type SellerInfo struct {
	ID        int64  `thrift:"ID,1" form:"id" json:"id,string"`
	Name      string `thrift:"Name,2" form:"name" json:"name"`
	AvatarURL string `thrift:"AvatarURL,3" form:"avatar_url" json:"avatar_url"`
}

func NewSellerInfo() *SellerInfo {
	return &SellerInfo{}
}

func (p *SellerInfo) InitDefault() {
}

func (p *SellerInfo) GetID() (v int64) {
	return p.ID
}

func (p *SellerInfo) GetName() (v string) {
	return p.Name
}

func (p *SellerInfo) GetAvatarURL() (v string) {
	return p.AvatarURL
}

var fieldIDToName_SellerInfo = map[int16]string{
	1: "ID",
	2: "Name",
	3: "AvatarURL",
}

func (p *SellerInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SellerInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SellerInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *SellerInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *SellerInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AvatarURL = _field
	return nil
}

func (p *SellerInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SellerInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SellerInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SellerInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SellerInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("AvatarURL", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AvatarURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *SellerInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SellerInfo(%+v)", *p)

}

type ProductCategory struct {
	ID            int64  `thrift:"ID,1" form:"id" json:"id,string"`
	Name          string `thrift:"Name,2" form:"name" json:"name"`
	IconURL       string `thrift:"IconURL,3" form:"icon_url" json:"icon_url"`
	ActiveIconURL string `thrift:"ActiveIconURL,4" form:"active_icon_url" json:"active_icon_url"`
	Index         int32  `thrift:"Index,5" form:"index" json:"index"`
	Count         int32  `thrift:"Count,6" form:"count" json:"count"`
}

func NewProductCategory() *ProductCategory {
	return &ProductCategory{}
}

func (p *ProductCategory) InitDefault() {
}

func (p *ProductCategory) GetID() (v int64) {
	return p.ID
}

func (p *ProductCategory) GetName() (v string) {
	return p.Name
}

func (p *ProductCategory) GetIconURL() (v string) {
	return p.IconURL
}

func (p *ProductCategory) GetActiveIconURL() (v string) {
	return p.ActiveIconURL
}

func (p *ProductCategory) GetIndex() (v int32) {
	return p.Index
}

func (p *ProductCategory) GetCount() (v int32) {
	return p.Count
}

var fieldIDToName_ProductCategory = map[int16]string{
	1: "ID",
	2: "Name",
	3: "IconURL",
	4: "ActiveIconURL",
	5: "Index",
	6: "Count",
}

func (p *ProductCategory) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProductCategory[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ProductCategory) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *ProductCategory) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ProductCategory) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *ProductCategory) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ActiveIconURL = _field
	return nil
}
func (p *ProductCategory) ReadField5(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Index = _field
	return nil
}
func (p *ProductCategory) ReadField6(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Count = _field
	return nil
}

func (p *ProductCategory) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProductCategory"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProductCategory) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ProductCategory) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ProductCategory) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IconURL", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ProductCategory) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ActiveIconURL", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ActiveIconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ProductCategory) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Index", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Index); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ProductCategory) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Count", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Count); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}

func (p *ProductCategory) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProductCategory(%+v)", *p)

}

type ProductLabel struct {
	Name string `thrift:"Name,1" form:"name" json:"name"`
}

func NewProductLabel() *ProductLabel {
	return &ProductLabel{}
}

func (p *ProductLabel) InitDefault() {
}

func (p *ProductLabel) GetName() (v string) {
	return p.Name
}

var fieldIDToName_ProductLabel = map[int16]string{
	1: "Name",
}

func (p *ProductLabel) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProductLabel[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ProductLabel) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}

func (p *ProductLabel) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProductLabel"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProductLabel) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *ProductLabel) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProductLabel(%+v)", *p)

}

type ProductMetaInfo struct {
	ID int64 `thrift:"ID,1" form:"id" json:"id,string"`
	// Product/Template Name
	Name string `thrift:"Name,2" form:"name" json:"name"`
	// Creature ID, determined by entity_type is the ID of the bot/plugin
	EntityID int64 `thrift:"EntityID,3" form:"entity_id" json:"entity_id,string"`
	// Product material type
	EntityType product_common.ProductEntityType `thrift:"EntityType,4" form:"entity_type" json:"entity_type"`
	// Product/template avatar
	IconURL string `thrift:"IconURL,5" form:"icon_url" json:"icon_url"`
	// Heat: Template heat = copy volume (used for card display/sorting); product heat = different products have independent calculation logic (only used for sorting) - the calculation of heat has a certain delay
	Heat          int32 `thrift:"Heat,6" form:"heat" json:"heat"`
	FavoriteCount int32 `thrift:"FavoriteCount,7" form:"favorite_count" json:"favorite_count"`
	// Obsolete, use UserInfo instead
	Seller *SellerInfo `thrift:"Seller,8" form:"seller" json:"seller"`
	// Product description
	Description string                       `thrift:"Description,9" form:"description" json:"description"`
	ListedAt    int64                        `thrift:"ListedAt,10" form:"listed_at" json:"listed_at,string"`
	Status      product_common.ProductStatus `thrift:"Status,11" form:"status" json:"status"`
	// Product/template classification information
	Category *ProductCategory `thrift:"Category,12,optional" form:"category" json:"category,omitempty"`
	// Whether to collect
	IsFavorited bool `thrift:"IsFavorited,13" form:"is_favorited" json:"is_favorited"`
	IsFree      bool `thrift:"IsFree,14" form:"is_free" json:"is_free"`
	// Template introduction/plugin introduction (currently in rich text format)
	Readme        string                   `thrift:"Readme,15" form:"readme" json:"readme"`
	EntityVersion *int64                   `thrift:"EntityVersion,16,optional" form:"entity_version" json:"entity_version,string,omitempty"`
	Labels        []*ProductLabel          `thrift:"Labels,17,optional" form:"labels" json:"labels,omitempty"`
	UserInfo      *product_common.UserInfo `thrift:"UserInfo,18" form:"user_info" json:"user_info"`
	MediumIconURL string                   `thrift:"MediumIconURL,19" form:"medium_icon_url" json:"medium_icon_url"`
	OriginIconURL string                   `thrift:"OriginIconURL,20" form:"origin_icon_url" json:"origin_icon_url"`
	// Template cover
	Covers []*product_common.ImageInfo `thrift:"Covers,21,optional" form:"covers" json:"covers,omitempty"`
	// Is the professional version specially available?
	IsProfessional *bool `thrift:"IsProfessional,22,optional" form:"is_professional" json:"is_professional,omitempty"`
	// Is it a template?
	IsTemplate bool `thrift:"IsTemplate,23" form:"is_template" json:"is_template"`
	// Is it an official product?
	IsOfficial bool `thrift:"IsOfficial,24" form:"is_official" json:"is_official"`
	// Price, currently only available in the template.
	Price *marketplace_common.Price `thrift:"Price,25,optional" form:"price" json:"price,omitempty"`
}

func NewProductMetaInfo() *ProductMetaInfo {
	return &ProductMetaInfo{}
}

func (p *ProductMetaInfo) InitDefault() {
}

func (p *ProductMetaInfo) GetID() (v int64) {
	return p.ID
}

func (p *ProductMetaInfo) GetName() (v string) {
	return p.Name
}

func (p *ProductMetaInfo) GetEntityID() (v int64) {
	return p.EntityID
}

func (p *ProductMetaInfo) GetEntityType() (v product_common.ProductEntityType) {
	return p.EntityType
}

func (p *ProductMetaInfo) GetIconURL() (v string) {
	return p.IconURL
}

func (p *ProductMetaInfo) GetHeat() (v int32) {
	return p.Heat
}

func (p *ProductMetaInfo) GetFavoriteCount() (v int32) {
	return p.FavoriteCount
}

var ProductMetaInfo_Seller_DEFAULT *SellerInfo

func (p *ProductMetaInfo) GetSeller() (v *SellerInfo) {
	if !p.IsSetSeller() {
		return ProductMetaInfo_Seller_DEFAULT
	}
	return p.Seller
}

func (p *ProductMetaInfo) GetDescription() (v string) {
	return p.Description
}

func (p *ProductMetaInfo) GetListedAt() (v int64) {
	return p.ListedAt
}

func (p *ProductMetaInfo) GetStatus() (v product_common.ProductStatus) {
	return p.Status
}

var ProductMetaInfo_Category_DEFAULT *ProductCategory

func (p *ProductMetaInfo) GetCategory() (v *ProductCategory) {
	if !p.IsSetCategory() {
		return ProductMetaInfo_Category_DEFAULT
	}
	return p.Category
}

func (p *ProductMetaInfo) GetIsFavorited() (v bool) {
	return p.IsFavorited
}

func (p *ProductMetaInfo) GetIsFree() (v bool) {
	return p.IsFree
}

func (p *ProductMetaInfo) GetReadme() (v string) {
	return p.Readme
}

var ProductMetaInfo_EntityVersion_DEFAULT int64

func (p *ProductMetaInfo) GetEntityVersion() (v int64) {
	if !p.IsSetEntityVersion() {
		return ProductMetaInfo_EntityVersion_DEFAULT
	}
	return *p.EntityVersion
}

var ProductMetaInfo_Labels_DEFAULT []*ProductLabel

func (p *ProductMetaInfo) GetLabels() (v []*ProductLabel) {
	if !p.IsSetLabels() {
		return ProductMetaInfo_Labels_DEFAULT
	}
	return p.Labels
}

var ProductMetaInfo_UserInfo_DEFAULT *product_common.UserInfo

func (p *ProductMetaInfo) GetUserInfo() (v *product_common.UserInfo) {
	if !p.IsSetUserInfo() {
		return ProductMetaInfo_UserInfo_DEFAULT
	}
	return p.UserInfo
}

func (p *ProductMetaInfo) GetMediumIconURL() (v string) {
	return p.MediumIconURL
}

func (p *ProductMetaInfo) GetOriginIconURL() (v string) {
	return p.OriginIconURL
}

var ProductMetaInfo_Covers_DEFAULT []*product_common.ImageInfo

func (p *ProductMetaInfo) GetCovers() (v []*product_common.ImageInfo) {
	if !p.IsSetCovers() {
		return ProductMetaInfo_Covers_DEFAULT
	}
	return p.Covers
}

var ProductMetaInfo_IsProfessional_DEFAULT bool

func (p *ProductMetaInfo) GetIsProfessional() (v bool) {
	if !p.IsSetIsProfessional() {
		return ProductMetaInfo_IsProfessional_DEFAULT
	}
	return *p.IsProfessional
}

func (p *ProductMetaInfo) GetIsTemplate() (v bool) {
	return p.IsTemplate
}

func (p *ProductMetaInfo) GetIsOfficial() (v bool) {
	return p.IsOfficial
}

var ProductMetaInfo_Price_DEFAULT *marketplace_common.Price

func (p *ProductMetaInfo) GetPrice() (v *marketplace_common.Price) {
	if !p.IsSetPrice() {
		return ProductMetaInfo_Price_DEFAULT
	}
	return p.Price
}

var fieldIDToName_ProductMetaInfo = map[int16]string{
	1:  "ID",
	2:  "Name",
	3:  "EntityID",
	4:  "EntityType",
	5:  "IconURL",
	6:  "Heat",
	7:  "FavoriteCount",
	8:  "Seller",
	9:  "Description",
	10: "ListedAt",
	11: "Status",
	12: "Category",
	13: "IsFavorited",
	14: "IsFree",
	15: "Readme",
	16: "EntityVersion",
	17: "Labels",
	18: "UserInfo",
	19: "MediumIconURL",
	20: "OriginIconURL",
	21: "Covers",
	22: "IsProfessional",
	23: "IsTemplate",
	24: "IsOfficial",
	25: "Price",
}

func (p *ProductMetaInfo) IsSetSeller() bool {
	return p.Seller != nil
}

func (p *ProductMetaInfo) IsSetCategory() bool {
	return p.Category != nil
}

func (p *ProductMetaInfo) IsSetEntityVersion() bool {
	return p.EntityVersion != nil
}

func (p *ProductMetaInfo) IsSetLabels() bool {
	return p.Labels != nil
}

func (p *ProductMetaInfo) IsSetUserInfo() bool {
	return p.UserInfo != nil
}

func (p *ProductMetaInfo) IsSetCovers() bool {
	return p.Covers != nil
}

func (p *ProductMetaInfo) IsSetIsProfessional() bool {
	return p.IsProfessional != nil
}

func (p *ProductMetaInfo) IsSetPrice() bool {
	return p.Price != nil
}

func (p *ProductMetaInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 22:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField22(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 23:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField23(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 24:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField24(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 25:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField25(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProductMetaInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ProductMetaInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *ProductMetaInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ProductMetaInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.EntityID = _field
	return nil
}
func (p *ProductMetaInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductEntityType(v)
	}
	p.EntityType = _field
	return nil
}
func (p *ProductMetaInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *ProductMetaInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Heat = _field
	return nil
}
func (p *ProductMetaInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.FavoriteCount = _field
	return nil
}
func (p *ProductMetaInfo) ReadField8(iprot thrift.TProtocol) error {
	_field := NewSellerInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Seller = _field
	return nil
}
func (p *ProductMetaInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *ProductMetaInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ListedAt = _field
	return nil
}
func (p *ProductMetaInfo) ReadField11(iprot thrift.TProtocol) error {

	var _field product_common.ProductStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductStatus(v)
	}
	p.Status = _field
	return nil
}
func (p *ProductMetaInfo) ReadField12(iprot thrift.TProtocol) error {
	_field := NewProductCategory()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Category = _field
	return nil
}
func (p *ProductMetaInfo) ReadField13(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsFavorited = _field
	return nil
}
func (p *ProductMetaInfo) ReadField14(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsFree = _field
	return nil
}
func (p *ProductMetaInfo) ReadField15(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Readme = _field
	return nil
}
func (p *ProductMetaInfo) ReadField16(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EntityVersion = _field
	return nil
}
func (p *ProductMetaInfo) ReadField17(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ProductLabel, 0, size)
	values := make([]ProductLabel, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Labels = _field
	return nil
}
func (p *ProductMetaInfo) ReadField18(iprot thrift.TProtocol) error {
	_field := product_common.NewUserInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserInfo = _field
	return nil
}
func (p *ProductMetaInfo) ReadField19(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.MediumIconURL = _field
	return nil
}
func (p *ProductMetaInfo) ReadField20(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.OriginIconURL = _field
	return nil
}
func (p *ProductMetaInfo) ReadField21(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*product_common.ImageInfo, 0, size)
	values := make([]product_common.ImageInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Covers = _field
	return nil
}
func (p *ProductMetaInfo) ReadField22(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsProfessional = _field
	return nil
}
func (p *ProductMetaInfo) ReadField23(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsTemplate = _field
	return nil
}
func (p *ProductMetaInfo) ReadField24(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsOfficial = _field
	return nil
}
func (p *ProductMetaInfo) ReadField25(iprot thrift.TProtocol) error {
	_field := marketplace_common.NewPrice()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Price = _field
	return nil
}

func (p *ProductMetaInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProductMetaInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
		if err = p.writeField22(oprot); err != nil {
			fieldId = 22
			goto WriteFieldError
		}
		if err = p.writeField23(oprot); err != nil {
			fieldId = 23
			goto WriteFieldError
		}
		if err = p.writeField24(oprot); err != nil {
			fieldId = 24
			goto WriteFieldError
		}
		if err = p.writeField25(oprot); err != nil {
			fieldId = 25
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProductMetaInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityID", thrift.I64, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.EntityID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityType", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.EntityType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IconURL", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Heat", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Heat); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("FavoriteCount", thrift.I32, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.FavoriteCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Seller", thrift.STRUCT, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Seller.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Description", thrift.STRING, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ListedAt", thrift.I64, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ListedAt); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Status", thrift.I32, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetCategory() {
		if err = oprot.WriteFieldBegin("Category", thrift.STRUCT, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Category.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField13(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsFavorited", thrift.BOOL, 13); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsFavorited); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField14(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsFree", thrift.BOOL, 14); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsFree); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField15(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Readme", thrift.STRING, 15); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Readme); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityVersion() {
		if err = oprot.WriteFieldBegin("EntityVersion", thrift.I64, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.EntityVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetLabels() {
		if err = oprot.WriteFieldBegin("Labels", thrift.LIST, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Labels)); err != nil {
			return err
		}
		for _, v := range p.Labels {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField18(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("UserInfo", thrift.STRUCT, 18); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.UserInfo.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField19(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("MediumIconURL", thrift.STRING, 19); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.MediumIconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField20(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("OriginIconURL", thrift.STRING, 20); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.OriginIconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField21(oprot thrift.TProtocol) (err error) {
	if p.IsSetCovers() {
		if err = oprot.WriteFieldBegin("Covers", thrift.LIST, 21); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Covers)); err != nil {
			return err
		}
		for _, v := range p.Covers {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField22(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsProfessional() {
		if err = oprot.WriteFieldBegin("IsProfessional", thrift.BOOL, 22); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsProfessional); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField23(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsTemplate", thrift.BOOL, 23); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsTemplate); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField24(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsOfficial", thrift.BOOL, 24); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsOfficial); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 end error: ", p), err)
}
func (p *ProductMetaInfo) writeField25(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrice() {
		if err = oprot.WriteFieldBegin("Price", thrift.STRUCT, 25); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Price.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 25 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 25 end error: ", p), err)
}

func (p *ProductMetaInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProductMetaInfo(%+v)", *p)

}

type UserBehaviorInfo struct {
	// The user homepage needs to return the most recently viewed/used product time.
	ViewedAt *int64 `thrift:"ViewedAt,1,optional" form:"viewed_at" json:"viewed_at,string,omitempty"`
	// Recently used timestamp
	UsedAt *int64 `thrift:"UsedAt,2,optional" form:"used_at" json:"used_at,string,omitempty"`
}

func NewUserBehaviorInfo() *UserBehaviorInfo {
	return &UserBehaviorInfo{}
}

func (p *UserBehaviorInfo) InitDefault() {
}

var UserBehaviorInfo_ViewedAt_DEFAULT int64

func (p *UserBehaviorInfo) GetViewedAt() (v int64) {
	if !p.IsSetViewedAt() {
		return UserBehaviorInfo_ViewedAt_DEFAULT
	}
	return *p.ViewedAt
}

var UserBehaviorInfo_UsedAt_DEFAULT int64

func (p *UserBehaviorInfo) GetUsedAt() (v int64) {
	if !p.IsSetUsedAt() {
		return UserBehaviorInfo_UsedAt_DEFAULT
	}
	return *p.UsedAt
}

var fieldIDToName_UserBehaviorInfo = map[int16]string{
	1: "ViewedAt",
	2: "UsedAt",
}

func (p *UserBehaviorInfo) IsSetViewedAt() bool {
	return p.ViewedAt != nil
}

func (p *UserBehaviorInfo) IsSetUsedAt() bool {
	return p.UsedAt != nil
}

func (p *UserBehaviorInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserBehaviorInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UserBehaviorInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ViewedAt = _field
	return nil
}
func (p *UserBehaviorInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.UsedAt = _field
	return nil
}

func (p *UserBehaviorInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserBehaviorInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserBehaviorInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetViewedAt() {
		if err = oprot.WriteFieldBegin("ViewedAt", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ViewedAt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UserBehaviorInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetUsedAt() {
		if err = oprot.WriteFieldBegin("UsedAt", thrift.I64, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.UsedAt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UserBehaviorInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserBehaviorInfo(%+v)", *p)

}

type PluginExtraInfo struct {
	Tools         []*PluginToolInfo `thrift:"Tools,1,optional" form:"tools" json:"tools,omitempty"`
	TotalAPICount int32             `thrift:"TotalAPICount,2" form:"total_api_count" json:"total_api_count"`
	BotsUseCount  int32             `thrift:"BotsUseCount,3" form:"bots_use_count" json:"bots_use_count"`
	// Is there a privacy statement, currently only PublicGetProductDetail will take the data
	HasPrivacyStatement *bool `thrift:"HasPrivacyStatement,4,optional" form:"has_private_statement" json:"has_private_statement,omitempty"`
	// Privacy statement, currently only PublicGetProductDetail will access data
	PrivacyStatement       *string `thrift:"PrivacyStatement,5,optional" form:"private_statement" json:"private_statement,omitempty"`
	AssociatedBotsUseCount int32   `thrift:"AssociatedBotsUseCount,6" form:"associated_bots_use_count" json:"associated_bots_use_count"`
	IsPremium              bool    `thrift:"IsPremium,7" form:"is_premium" json:"is_premium"`
	IsOfficial             bool    `thrift:"IsOfficial,8" form:"is_official" json:"is_official"`
	// call amount
	CallAmount *int32 `thrift:"CallAmount,9,optional" form:"call_amount" json:"call_amount,omitempty"`
	// success rate
	SuccessRate *float64 `thrift:"SuccessRate,10,optional" form:"success_rate" json:"success_rate,omitempty"`
	// average execution time
	AvgExecTime   *float64                   `thrift:"AvgExecTime,11,optional" form:"avg_exec_time" json:"avg_exec_time,omitempty"`
	IsDefaultIcon *bool                      `thrift:"IsDefaultIcon,12,optional" form:"is_default_icon" json:"is_default_icon,omitempty"`
	SpaceID       *int64                     `thrift:"SpaceID,13,optional" form:"space_id" json:"space_id,string,omitempty"`
	MaterialID    *int64                     `thrift:"MaterialID,14,optional" form:"material_id" json:"material_id,string,omitempty"`
	Connectors    []*PluginConnectorInfo     `thrift:"Connectors,15" form:"connectors" json:"connectors"`
	PluginType    *product_common.PluginType `thrift:"PluginType,16,optional" form:"plugin_type" json:"plugin_type,omitempty"`
	// for opencoze
	AuthMode *PluginAuthMode `thrift:"AuthMode,50,optional" form:"auth_mode" json:"auth_mode,omitempty"`
}

func NewPluginExtraInfo() *PluginExtraInfo {
	return &PluginExtraInfo{}
}

func (p *PluginExtraInfo) InitDefault() {
}

var PluginExtraInfo_Tools_DEFAULT []*PluginToolInfo

func (p *PluginExtraInfo) GetTools() (v []*PluginToolInfo) {
	if !p.IsSetTools() {
		return PluginExtraInfo_Tools_DEFAULT
	}
	return p.Tools
}

func (p *PluginExtraInfo) GetTotalAPICount() (v int32) {
	return p.TotalAPICount
}

func (p *PluginExtraInfo) GetBotsUseCount() (v int32) {
	return p.BotsUseCount
}

var PluginExtraInfo_HasPrivacyStatement_DEFAULT bool

func (p *PluginExtraInfo) GetHasPrivacyStatement() (v bool) {
	if !p.IsSetHasPrivacyStatement() {
		return PluginExtraInfo_HasPrivacyStatement_DEFAULT
	}
	return *p.HasPrivacyStatement
}

var PluginExtraInfo_PrivacyStatement_DEFAULT string

func (p *PluginExtraInfo) GetPrivacyStatement() (v string) {
	if !p.IsSetPrivacyStatement() {
		return PluginExtraInfo_PrivacyStatement_DEFAULT
	}
	return *p.PrivacyStatement
}

func (p *PluginExtraInfo) GetAssociatedBotsUseCount() (v int32) {
	return p.AssociatedBotsUseCount
}

func (p *PluginExtraInfo) GetIsPremium() (v bool) {
	return p.IsPremium
}

func (p *PluginExtraInfo) GetIsOfficial() (v bool) {
	return p.IsOfficial
}

var PluginExtraInfo_CallAmount_DEFAULT int32

func (p *PluginExtraInfo) GetCallAmount() (v int32) {
	if !p.IsSetCallAmount() {
		return PluginExtraInfo_CallAmount_DEFAULT
	}
	return *p.CallAmount
}

var PluginExtraInfo_SuccessRate_DEFAULT float64

func (p *PluginExtraInfo) GetSuccessRate() (v float64) {
	if !p.IsSetSuccessRate() {
		return PluginExtraInfo_SuccessRate_DEFAULT
	}
	return *p.SuccessRate
}

var PluginExtraInfo_AvgExecTime_DEFAULT float64

func (p *PluginExtraInfo) GetAvgExecTime() (v float64) {
	if !p.IsSetAvgExecTime() {
		return PluginExtraInfo_AvgExecTime_DEFAULT
	}
	return *p.AvgExecTime
}

var PluginExtraInfo_IsDefaultIcon_DEFAULT bool

func (p *PluginExtraInfo) GetIsDefaultIcon() (v bool) {
	if !p.IsSetIsDefaultIcon() {
		return PluginExtraInfo_IsDefaultIcon_DEFAULT
	}
	return *p.IsDefaultIcon
}

var PluginExtraInfo_SpaceID_DEFAULT int64

func (p *PluginExtraInfo) GetSpaceID() (v int64) {
	if !p.IsSetSpaceID() {
		return PluginExtraInfo_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var PluginExtraInfo_MaterialID_DEFAULT int64

func (p *PluginExtraInfo) GetMaterialID() (v int64) {
	if !p.IsSetMaterialID() {
		return PluginExtraInfo_MaterialID_DEFAULT
	}
	return *p.MaterialID
}

func (p *PluginExtraInfo) GetConnectors() (v []*PluginConnectorInfo) {
	return p.Connectors
}

var PluginExtraInfo_PluginType_DEFAULT product_common.PluginType

func (p *PluginExtraInfo) GetPluginType() (v product_common.PluginType) {
	if !p.IsSetPluginType() {
		return PluginExtraInfo_PluginType_DEFAULT
	}
	return *p.PluginType
}

var PluginExtraInfo_AuthMode_DEFAULT PluginAuthMode

func (p *PluginExtraInfo) GetAuthMode() (v PluginAuthMode) {
	if !p.IsSetAuthMode() {
		return PluginExtraInfo_AuthMode_DEFAULT
	}
	return *p.AuthMode
}

var fieldIDToName_PluginExtraInfo = map[int16]string{
	1:  "Tools",
	2:  "TotalAPICount",
	3:  "BotsUseCount",
	4:  "HasPrivacyStatement",
	5:  "PrivacyStatement",
	6:  "AssociatedBotsUseCount",
	7:  "IsPremium",
	8:  "IsOfficial",
	9:  "CallAmount",
	10: "SuccessRate",
	11: "AvgExecTime",
	12: "IsDefaultIcon",
	13: "SpaceID",
	14: "MaterialID",
	15: "Connectors",
	16: "PluginType",
	50: "AuthMode",
}

func (p *PluginExtraInfo) IsSetTools() bool {
	return p.Tools != nil
}

func (p *PluginExtraInfo) IsSetHasPrivacyStatement() bool {
	return p.HasPrivacyStatement != nil
}

func (p *PluginExtraInfo) IsSetPrivacyStatement() bool {
	return p.PrivacyStatement != nil
}

func (p *PluginExtraInfo) IsSetCallAmount() bool {
	return p.CallAmount != nil
}

func (p *PluginExtraInfo) IsSetSuccessRate() bool {
	return p.SuccessRate != nil
}

func (p *PluginExtraInfo) IsSetAvgExecTime() bool {
	return p.AvgExecTime != nil
}

func (p *PluginExtraInfo) IsSetIsDefaultIcon() bool {
	return p.IsDefaultIcon != nil
}

func (p *PluginExtraInfo) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *PluginExtraInfo) IsSetMaterialID() bool {
	return p.MaterialID != nil
}

func (p *PluginExtraInfo) IsSetPluginType() bool {
	return p.PluginType != nil
}

func (p *PluginExtraInfo) IsSetAuthMode() bool {
	return p.AuthMode != nil
}

func (p *PluginExtraInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 50:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField50(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PluginExtraInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PluginExtraInfo) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*PluginToolInfo, 0, size)
	values := make([]PluginToolInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Tools = _field
	return nil
}
func (p *PluginExtraInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TotalAPICount = _field
	return nil
}
func (p *PluginExtraInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotsUseCount = _field
	return nil
}
func (p *PluginExtraInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HasPrivacyStatement = _field
	return nil
}
func (p *PluginExtraInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrivacyStatement = _field
	return nil
}
func (p *PluginExtraInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AssociatedBotsUseCount = _field
	return nil
}
func (p *PluginExtraInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsPremium = _field
	return nil
}
func (p *PluginExtraInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsOfficial = _field
	return nil
}
func (p *PluginExtraInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CallAmount = _field
	return nil
}
func (p *PluginExtraInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field *float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SuccessRate = _field
	return nil
}
func (p *PluginExtraInfo) ReadField11(iprot thrift.TProtocol) error {

	var _field *float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.AvgExecTime = _field
	return nil
}
func (p *PluginExtraInfo) ReadField12(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsDefaultIcon = _field
	return nil
}
func (p *PluginExtraInfo) ReadField13(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *PluginExtraInfo) ReadField14(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.MaterialID = _field
	return nil
}
func (p *PluginExtraInfo) ReadField15(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*PluginConnectorInfo, 0, size)
	values := make([]PluginConnectorInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Connectors = _field
	return nil
}
func (p *PluginExtraInfo) ReadField16(iprot thrift.TProtocol) error {

	var _field *product_common.PluginType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.PluginType(v)
		_field = &tmp
	}
	p.PluginType = _field
	return nil
}
func (p *PluginExtraInfo) ReadField50(iprot thrift.TProtocol) error {

	var _field *PluginAuthMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := PluginAuthMode(v)
		_field = &tmp
	}
	p.AuthMode = _field
	return nil
}

func (p *PluginExtraInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PluginExtraInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField50(oprot); err != nil {
			fieldId = 50
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PluginExtraInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetTools() {
		if err = oprot.WriteFieldBegin("Tools", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Tools)); err != nil {
			return err
		}
		for _, v := range p.Tools {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("TotalAPICount", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TotalAPICount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BotsUseCount", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.BotsUseCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetHasPrivacyStatement() {
		if err = oprot.WriteFieldBegin("HasPrivacyStatement", thrift.BOOL, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.HasPrivacyStatement); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrivacyStatement() {
		if err = oprot.WriteFieldBegin("PrivacyStatement", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PrivacyStatement); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("AssociatedBotsUseCount", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.AssociatedBotsUseCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsPremium", thrift.BOOL, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsPremium); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsOfficial", thrift.BOOL, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsOfficial); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetCallAmount() {
		if err = oprot.WriteFieldBegin("CallAmount", thrift.I32, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.CallAmount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccessRate() {
		if err = oprot.WriteFieldBegin("SuccessRate", thrift.DOUBLE, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteDouble(*p.SuccessRate); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetAvgExecTime() {
		if err = oprot.WriteFieldBegin("AvgExecTime", thrift.DOUBLE, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteDouble(*p.AvgExecTime); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsDefaultIcon() {
		if err = oprot.WriteFieldBegin("IsDefaultIcon", thrift.BOOL, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsDefaultIcon); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("SpaceID", thrift.I64, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetMaterialID() {
		if err = oprot.WriteFieldBegin("MaterialID", thrift.I64, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.MaterialID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField15(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Connectors", thrift.LIST, 15); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Connectors)); err != nil {
		return err
	}
	for _, v := range p.Connectors {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginType() {
		if err = oprot.WriteFieldBegin("PluginType", thrift.I32, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.PluginType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *PluginExtraInfo) writeField50(oprot thrift.TProtocol) (err error) {
	if p.IsSetAuthMode() {
		if err = oprot.WriteFieldBegin("AuthMode", thrift.I32, 50); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.AuthMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 50 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 50 end error: ", p), err)
}

func (p *PluginExtraInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PluginExtraInfo(%+v)", *p)

}

type ToolParameter struct {
	Name         string           `thrift:"Name,1" form:"name" json:"name"`
	IsRequired   bool             `thrift:"IsRequired,2" form:"required" json:"required"`
	Description  string           `thrift:"Description,3" form:"description" json:"description"`
	Type         string           `thrift:"Type,4" form:"type" json:"type"`
	SubParameter []*ToolParameter `thrift:"SubParameter,5" form:"sub_params" json:"sub_params"`
}

func NewToolParameter() *ToolParameter {
	return &ToolParameter{}
}

func (p *ToolParameter) InitDefault() {
}

func (p *ToolParameter) GetName() (v string) {
	return p.Name
}

func (p *ToolParameter) GetIsRequired() (v bool) {
	return p.IsRequired
}

func (p *ToolParameter) GetDescription() (v string) {
	return p.Description
}

func (p *ToolParameter) GetType() (v string) {
	return p.Type
}

func (p *ToolParameter) GetSubParameter() (v []*ToolParameter) {
	return p.SubParameter
}

var fieldIDToName_ToolParameter = map[int16]string{
	1: "Name",
	2: "IsRequired",
	3: "Description",
	4: "Type",
	5: "SubParameter",
}

func (p *ToolParameter) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ToolParameter[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ToolParameter) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ToolParameter) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsRequired = _field
	return nil
}
func (p *ToolParameter) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *ToolParameter) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Type = _field
	return nil
}
func (p *ToolParameter) ReadField5(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ToolParameter, 0, size)
	values := make([]ToolParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubParameter = _field
	return nil
}

func (p *ToolParameter) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ToolParameter"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ToolParameter) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ToolParameter) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsRequired", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsRequired); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ToolParameter) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Description", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ToolParameter) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Type", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Type); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ToolParameter) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("SubParameter", thrift.LIST, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.SubParameter)); err != nil {
		return err
	}
	for _, v := range p.SubParameter {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *ToolParameter) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ToolParameter(%+v)", *p)

}

type CardInfo struct {
	CardURL string `thrift:"CardURL,1" form:"card_url" json:"card_url"`
	// Only the details page returns
	CardID         int64  `thrift:"CardID,2" form:"card_id" json:"card_id,string"`
	MappingRule    string `thrift:"MappingRule,3" form:"MappingRule" json:"MappingRule" query:"MappingRule"`
	MaxDisplayRows int64  `thrift:"MaxDisplayRows,4" form:"max_display_rows" json:"max_display_rows,string"`
	CardVersion    int64  `thrift:"CardVersion,5" form:"card_version" json:"card_version,string"`
}

func NewCardInfo() *CardInfo {
	return &CardInfo{}
}

func (p *CardInfo) InitDefault() {
}

func (p *CardInfo) GetCardURL() (v string) {
	return p.CardURL
}

func (p *CardInfo) GetCardID() (v int64) {
	return p.CardID
}

func (p *CardInfo) GetMappingRule() (v string) {
	return p.MappingRule
}

func (p *CardInfo) GetMaxDisplayRows() (v int64) {
	return p.MaxDisplayRows
}

func (p *CardInfo) GetCardVersion() (v int64) {
	return p.CardVersion
}

var fieldIDToName_CardInfo = map[int16]string{
	1: "CardURL",
	2: "CardID",
	3: "MappingRule",
	4: "MaxDisplayRows",
	5: "CardVersion",
}

func (p *CardInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CardInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CardInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CardURL = _field
	return nil
}
func (p *CardInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CardID = _field
	return nil
}
func (p *CardInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.MappingRule = _field
	return nil
}
func (p *CardInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.MaxDisplayRows = _field
	return nil
}
func (p *CardInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CardVersion = _field
	return nil
}

func (p *CardInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CardInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CardInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("CardURL", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.CardURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CardInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("CardID", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.CardID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CardInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("MappingRule", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.MappingRule); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *CardInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("MaxDisplayRows", thrift.I64, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.MaxDisplayRows); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *CardInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("CardVersion", thrift.I64, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.CardVersion); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *CardInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CardInfo(%+v)", *p)

}

type PluginToolExample struct {
	ReqExample  string `thrift:"ReqExample,1" form:"req_example" json:"req_example"`
	RespExample string `thrift:"RespExample,2" form:"resp_example" json:"resp_example"`
}

func NewPluginToolExample() *PluginToolExample {
	return &PluginToolExample{}
}

func (p *PluginToolExample) InitDefault() {
}

func (p *PluginToolExample) GetReqExample() (v string) {
	return p.ReqExample
}

func (p *PluginToolExample) GetRespExample() (v string) {
	return p.RespExample
}

var fieldIDToName_PluginToolExample = map[int16]string{
	1: "ReqExample",
	2: "RespExample",
}

func (p *PluginToolExample) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PluginToolExample[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PluginToolExample) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ReqExample = _field
	return nil
}
func (p *PluginToolExample) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.RespExample = _field
	return nil
}

func (p *PluginToolExample) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PluginToolExample"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PluginToolExample) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ReqExample", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ReqExample); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PluginToolExample) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("RespExample", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.RespExample); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *PluginToolExample) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PluginToolExample(%+v)", *p)

}

type PluginToolInfo struct {
	ID          int64              `thrift:"ID,1" form:"id" json:"id,string"`
	Name        string             `thrift:"Name,2" form:"name" json:"name"`
	Description string             `thrift:"Description,3" form:"description" json:"description"`
	Parameters  []*ToolParameter   `thrift:"Parameters,4,optional" form:"parameters" json:"parameters,omitempty"`
	CardInfo    *CardInfo          `thrift:"CardInfo,5,optional" form:"card_info" json:"card_info,omitempty"`
	Example     *PluginToolExample `thrift:"Example,6,optional" form:"example" json:"example,omitempty"`
	// call amount
	CallAmount *int32 `thrift:"CallAmount,7,optional" form:"call_amount" json:"call_amount,omitempty"`
	// success rate
	SuccessRate *float64 `thrift:"SuccessRate,8,optional" form:"success_rate" json:"success_rate,omitempty"`
	// average execution time
	AvgExecTime *float64 `thrift:"AvgExecTime,9,optional" form:"avg_exec_time" json:"avg_exec_time,omitempty"`
	// Number of tool bot references
	BotsUseCount *int32 `thrift:"BotsUseCount,10,optional" form:"bots_use_count" json:"bots_use_count,omitempty"`
	// operating mode
	RunMode *PluginRunMode `thrift:"RunMode,11,optional" form:"run_mode" json:"run_mode,omitempty"`
}

func NewPluginToolInfo() *PluginToolInfo {
	return &PluginToolInfo{}
}

func (p *PluginToolInfo) InitDefault() {
}

func (p *PluginToolInfo) GetID() (v int64) {
	return p.ID
}

func (p *PluginToolInfo) GetName() (v string) {
	return p.Name
}

func (p *PluginToolInfo) GetDescription() (v string) {
	return p.Description
}

var PluginToolInfo_Parameters_DEFAULT []*ToolParameter

func (p *PluginToolInfo) GetParameters() (v []*ToolParameter) {
	if !p.IsSetParameters() {
		return PluginToolInfo_Parameters_DEFAULT
	}
	return p.Parameters
}

var PluginToolInfo_CardInfo_DEFAULT *CardInfo

func (p *PluginToolInfo) GetCardInfo() (v *CardInfo) {
	if !p.IsSetCardInfo() {
		return PluginToolInfo_CardInfo_DEFAULT
	}
	return p.CardInfo
}

var PluginToolInfo_Example_DEFAULT *PluginToolExample

func (p *PluginToolInfo) GetExample() (v *PluginToolExample) {
	if !p.IsSetExample() {
		return PluginToolInfo_Example_DEFAULT
	}
	return p.Example
}

var PluginToolInfo_CallAmount_DEFAULT int32

func (p *PluginToolInfo) GetCallAmount() (v int32) {
	if !p.IsSetCallAmount() {
		return PluginToolInfo_CallAmount_DEFAULT
	}
	return *p.CallAmount
}

var PluginToolInfo_SuccessRate_DEFAULT float64

func (p *PluginToolInfo) GetSuccessRate() (v float64) {
	if !p.IsSetSuccessRate() {
		return PluginToolInfo_SuccessRate_DEFAULT
	}
	return *p.SuccessRate
}

var PluginToolInfo_AvgExecTime_DEFAULT float64

func (p *PluginToolInfo) GetAvgExecTime() (v float64) {
	if !p.IsSetAvgExecTime() {
		return PluginToolInfo_AvgExecTime_DEFAULT
	}
	return *p.AvgExecTime
}

var PluginToolInfo_BotsUseCount_DEFAULT int32

func (p *PluginToolInfo) GetBotsUseCount() (v int32) {
	if !p.IsSetBotsUseCount() {
		return PluginToolInfo_BotsUseCount_DEFAULT
	}
	return *p.BotsUseCount
}

var PluginToolInfo_RunMode_DEFAULT PluginRunMode

func (p *PluginToolInfo) GetRunMode() (v PluginRunMode) {
	if !p.IsSetRunMode() {
		return PluginToolInfo_RunMode_DEFAULT
	}
	return *p.RunMode
}

var fieldIDToName_PluginToolInfo = map[int16]string{
	1:  "ID",
	2:  "Name",
	3:  "Description",
	4:  "Parameters",
	5:  "CardInfo",
	6:  "Example",
	7:  "CallAmount",
	8:  "SuccessRate",
	9:  "AvgExecTime",
	10: "BotsUseCount",
	11: "RunMode",
}

func (p *PluginToolInfo) IsSetParameters() bool {
	return p.Parameters != nil
}

func (p *PluginToolInfo) IsSetCardInfo() bool {
	return p.CardInfo != nil
}

func (p *PluginToolInfo) IsSetExample() bool {
	return p.Example != nil
}

func (p *PluginToolInfo) IsSetCallAmount() bool {
	return p.CallAmount != nil
}

func (p *PluginToolInfo) IsSetSuccessRate() bool {
	return p.SuccessRate != nil
}

func (p *PluginToolInfo) IsSetAvgExecTime() bool {
	return p.AvgExecTime != nil
}

func (p *PluginToolInfo) IsSetBotsUseCount() bool {
	return p.BotsUseCount != nil
}

func (p *PluginToolInfo) IsSetRunMode() bool {
	return p.RunMode != nil
}

func (p *PluginToolInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PluginToolInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PluginToolInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *PluginToolInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *PluginToolInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *PluginToolInfo) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ToolParameter, 0, size)
	values := make([]ToolParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Parameters = _field
	return nil
}
func (p *PluginToolInfo) ReadField5(iprot thrift.TProtocol) error {
	_field := NewCardInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.CardInfo = _field
	return nil
}
func (p *PluginToolInfo) ReadField6(iprot thrift.TProtocol) error {
	_field := NewPluginToolExample()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Example = _field
	return nil
}
func (p *PluginToolInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CallAmount = _field
	return nil
}
func (p *PluginToolInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field *float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SuccessRate = _field
	return nil
}
func (p *PluginToolInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field *float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.AvgExecTime = _field
	return nil
}
func (p *PluginToolInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BotsUseCount = _field
	return nil
}
func (p *PluginToolInfo) ReadField11(iprot thrift.TProtocol) error {

	var _field *PluginRunMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := PluginRunMode(v)
		_field = &tmp
	}
	p.RunMode = _field
	return nil
}

func (p *PluginToolInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PluginToolInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PluginToolInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PluginToolInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PluginToolInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Description", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PluginToolInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetParameters() {
		if err = oprot.WriteFieldBegin("Parameters", thrift.LIST, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Parameters)); err != nil {
			return err
		}
		for _, v := range p.Parameters {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PluginToolInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetCardInfo() {
		if err = oprot.WriteFieldBegin("CardInfo", thrift.STRUCT, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.CardInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PluginToolInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetExample() {
		if err = oprot.WriteFieldBegin("Example", thrift.STRUCT, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Example.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PluginToolInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetCallAmount() {
		if err = oprot.WriteFieldBegin("CallAmount", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.CallAmount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *PluginToolInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccessRate() {
		if err = oprot.WriteFieldBegin("SuccessRate", thrift.DOUBLE, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteDouble(*p.SuccessRate); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *PluginToolInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetAvgExecTime() {
		if err = oprot.WriteFieldBegin("AvgExecTime", thrift.DOUBLE, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteDouble(*p.AvgExecTime); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *PluginToolInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotsUseCount() {
		if err = oprot.WriteFieldBegin("BotsUseCount", thrift.I32, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.BotsUseCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *PluginToolInfo) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetRunMode() {
		if err = oprot.WriteFieldBegin("RunMode", thrift.I32, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.RunMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}

func (p *PluginToolInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PluginToolInfo(%+v)", *p)

}

type PluginConnectorInfo struct {
	ID   int64  `thrift:"ID,1" form:"id" json:"id,string"`
	Name string `thrift:"Name,2" form:"name" json:"name"`
	Icon string `thrift:"Icon,3" form:"icon" json:"icon"`
}

func NewPluginConnectorInfo() *PluginConnectorInfo {
	return &PluginConnectorInfo{}
}

func (p *PluginConnectorInfo) InitDefault() {
}

func (p *PluginConnectorInfo) GetID() (v int64) {
	return p.ID
}

func (p *PluginConnectorInfo) GetName() (v string) {
	return p.Name
}

func (p *PluginConnectorInfo) GetIcon() (v string) {
	return p.Icon
}

var fieldIDToName_PluginConnectorInfo = map[int16]string{
	1: "ID",
	2: "Name",
	3: "Icon",
}

func (p *PluginConnectorInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PluginConnectorInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PluginConnectorInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *PluginConnectorInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *PluginConnectorInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}

func (p *PluginConnectorInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PluginConnectorInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PluginConnectorInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PluginConnectorInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PluginConnectorInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *PluginConnectorInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PluginConnectorInfo(%+v)", *p)

}

type BotPublishPlatform struct {
	ID          int64  `thrift:"ID,1" form:"id" json:"id,string"`
	IconURL     string `thrift:"IconURL,2" form:"icon_url" json:"icon_url"`
	PlatformURL string `thrift:"PlatformURL,3" form:"url" json:"url"`
	Name        string `thrift:"Name,4" form:"name" json:"name"`
}

func NewBotPublishPlatform() *BotPublishPlatform {
	return &BotPublishPlatform{}
}

func (p *BotPublishPlatform) InitDefault() {
}

func (p *BotPublishPlatform) GetID() (v int64) {
	return p.ID
}

func (p *BotPublishPlatform) GetIconURL() (v string) {
	return p.IconURL
}

func (p *BotPublishPlatform) GetPlatformURL() (v string) {
	return p.PlatformURL
}

func (p *BotPublishPlatform) GetName() (v string) {
	return p.Name
}

var fieldIDToName_BotPublishPlatform = map[int16]string{
	1: "ID",
	2: "IconURL",
	3: "PlatformURL",
	4: "Name",
}

func (p *BotPublishPlatform) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotPublishPlatform[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotPublishPlatform) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *BotPublishPlatform) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *BotPublishPlatform) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PlatformURL = _field
	return nil
}
func (p *BotPublishPlatform) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}

func (p *BotPublishPlatform) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotPublishPlatform"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotPublishPlatform) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotPublishPlatform) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IconURL", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotPublishPlatform) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PlatformURL", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PlatformURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotPublishPlatform) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *BotPublishPlatform) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotPublishPlatform(%+v)", *p)

}

type ProductMaterial struct {
	Name    string `thrift:"Name,1" form:"name" json:"name"`
	IconURL string `thrift:"IconURL,2" form:"icon_url" json:"icon_url"`
}

func NewProductMaterial() *ProductMaterial {
	return &ProductMaterial{}
}

func (p *ProductMaterial) InitDefault() {
}

func (p *ProductMaterial) GetName() (v string) {
	return p.Name
}

func (p *ProductMaterial) GetIconURL() (v string) {
	return p.IconURL
}

var fieldIDToName_ProductMaterial = map[int16]string{
	1: "Name",
	2: "IconURL",
}

func (p *ProductMaterial) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProductMaterial[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ProductMaterial) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ProductMaterial) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}

func (p *ProductMaterial) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProductMaterial"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProductMaterial) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ProductMaterial) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IconURL", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *ProductMaterial) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProductMaterial(%+v)", *p)

}

type BotVoiceInfo struct {
	VoiceID            int64  `thrift:"VoiceID,1" form:"id" json:"id,string"`
	LanguageCode       string `thrift:"LanguageCode,2" form:"language_code" json:"language_code"`
	LanguageName       string `thrift:"LanguageName,3" form:"language_name" json:"language_name"`
	Name               string `thrift:"Name,4" form:"name" json:"name"`
	StyleID            string `thrift:"StyleID,5" form:"style_id" json:"style_id"`
	IsSupportVoiceCall bool   `thrift:"IsSupportVoiceCall,6" form:"is_support_voice_call" json:"is_support_voice_call"`
}

func NewBotVoiceInfo() *BotVoiceInfo {
	return &BotVoiceInfo{}
}

func (p *BotVoiceInfo) InitDefault() {
}

func (p *BotVoiceInfo) GetVoiceID() (v int64) {
	return p.VoiceID
}

func (p *BotVoiceInfo) GetLanguageCode() (v string) {
	return p.LanguageCode
}

func (p *BotVoiceInfo) GetLanguageName() (v string) {
	return p.LanguageName
}

func (p *BotVoiceInfo) GetName() (v string) {
	return p.Name
}

func (p *BotVoiceInfo) GetStyleID() (v string) {
	return p.StyleID
}

func (p *BotVoiceInfo) GetIsSupportVoiceCall() (v bool) {
	return p.IsSupportVoiceCall
}

var fieldIDToName_BotVoiceInfo = map[int16]string{
	1: "VoiceID",
	2: "LanguageCode",
	3: "LanguageName",
	4: "Name",
	5: "StyleID",
	6: "IsSupportVoiceCall",
}

func (p *BotVoiceInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotVoiceInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotVoiceInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.VoiceID = _field
	return nil
}
func (p *BotVoiceInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LanguageCode = _field
	return nil
}
func (p *BotVoiceInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LanguageName = _field
	return nil
}
func (p *BotVoiceInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *BotVoiceInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.StyleID = _field
	return nil
}
func (p *BotVoiceInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsSupportVoiceCall = _field
	return nil
}

func (p *BotVoiceInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotVoiceInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotVoiceInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("VoiceID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.VoiceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotVoiceInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("LanguageCode", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.LanguageCode); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotVoiceInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("LanguageName", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.LanguageName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotVoiceInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *BotVoiceInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("StyleID", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.StyleID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *BotVoiceInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsSupportVoiceCall", thrift.BOOL, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsSupportVoiceCall); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}

func (p *BotVoiceInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotVoiceInfo(%+v)", *p)

}

type UserQueryCollectConf struct {
	// Bot user query collection configuration
	IsCollected bool `thrift:"IsCollected,1" form:"is_collected" json:"is_collected"`
	// Privacy Policy Link
	PrivatePolicy string `thrift:"PrivatePolicy,2" form:"private_policy" json:"private_policy"`
}

func NewUserQueryCollectConf() *UserQueryCollectConf {
	return &UserQueryCollectConf{}
}

func (p *UserQueryCollectConf) InitDefault() {
}

func (p *UserQueryCollectConf) GetIsCollected() (v bool) {
	return p.IsCollected
}

func (p *UserQueryCollectConf) GetPrivatePolicy() (v string) {
	return p.PrivatePolicy
}

var fieldIDToName_UserQueryCollectConf = map[int16]string{
	1: "IsCollected",
	2: "PrivatePolicy",
}

func (p *UserQueryCollectConf) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserQueryCollectConf[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UserQueryCollectConf) ReadField1(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsCollected = _field
	return nil
}
func (p *UserQueryCollectConf) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PrivatePolicy = _field
	return nil
}

func (p *UserQueryCollectConf) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserQueryCollectConf"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserQueryCollectConf) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsCollected", thrift.BOOL, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsCollected); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UserQueryCollectConf) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PrivatePolicy", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PrivatePolicy); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UserQueryCollectConf) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserQueryCollectConf(%+v)", *p)

}

type BotConfig struct {
	// model
	Models []*ProductMaterial `thrift:"Models,1,optional" form:"models" json:"models,omitempty"`
	// plugin
	Plugins []*ProductMaterial `thrift:"Plugins,2,optional" form:"plugins" json:"plugins,omitempty"`
	// Knowledge Base
	Knowledges []*ProductMaterial `thrift:"Knowledges,3,optional" form:"knowledges" json:"knowledges,omitempty"`
	// Workflow
	Workflows []*ProductMaterial `thrift:"Workflows,4,optional" form:"workflows" json:"workflows,omitempty"`
	// number of private plugins
	PrivatePluginsCount *int32 `thrift:"PrivatePluginsCount,5,optional" form:"private_plugins_count" json:"private_plugins_count,omitempty"`
	// Number of private repositories
	PrivateKnowledgesCount *int32 `thrift:"PrivateKnowledgesCount,6,optional" form:"private_knowledges_count" json:"private_knowledges_count,omitempty"`
	// number of private workflows
	PrivateWorkflowsCount *int32 `thrift:"PrivateWorkflowsCount,7,optional" form:"private_workflows_count" json:"private_workflows_count,omitempty"`
	// Determine if the multiagent has a bot node
	HasBotAgent *bool `thrift:"HasBotAgent,8,optional" form:"has_bot_agent" json:"has_bot_agent,omitempty"`
	// List of sounds configured by bot
	BotVoices []*BotVoiceInfo `thrift:"BotVoices,9,optional" form:"bot_voices" json:"bot_voices,omitempty"`
	// Number of all plugins
	TotalPluginsCount *int32 `thrift:"TotalPluginsCount,10,optional" form:"total_plugins_count" json:"total_plugins_count,omitempty"`
	// Number of all knowledge bases
	TotalKnowledgesCount *int32 `thrift:"TotalKnowledgesCount,11,optional" form:"total_knowledges_count" json:"total_knowledges_count,omitempty"`
	// Number of all workflows
	TotalWorkflowsCount *int32 `thrift:"TotalWorkflowsCount,12,optional" form:"total_workflows_count" json:"total_workflows_count,omitempty"`
	// Time Capsule Mode
	TimeCapsuleMode *TimeCapsuleMode `thrift:"TimeCapsuleMode,13,optional" form:"time_capsule_mode" json:"time_capsule_mode,omitempty"`
	// File box mode
	FileboxMode *FileboxInfoMode `thrift:"FileboxMode,14,optional" form:"filebox_mode" json:"filebox_mode,omitempty"`
	// Number of private image workflows
	PrivateImageWorkflowCount *int32 `thrift:"PrivateImageWorkflowCount,15,optional" form:"private_image_workflow_count" json:"private_image_workflow_count,omitempty"`
	// User qeury collection configuration
	UserQueryCollectConf *UserQueryCollectConf `thrift:"UserQueryCollectConf,16,optional" form:"user_query_collect_conf" json:"user_query_collect_conf,omitempty"`
	// Whether to turn off voice calls (the default is on)
	IsCloseVoiceCall *bool `thrift:"IsCloseVoiceCall,17,optional" form:"is_close_voice_call" json:"is_close_voice_call,omitempty"`
}

func NewBotConfig() *BotConfig {
	return &BotConfig{}
}

func (p *BotConfig) InitDefault() {
}

var BotConfig_Models_DEFAULT []*ProductMaterial

func (p *BotConfig) GetModels() (v []*ProductMaterial) {
	if !p.IsSetModels() {
		return BotConfig_Models_DEFAULT
	}
	return p.Models
}

var BotConfig_Plugins_DEFAULT []*ProductMaterial

func (p *BotConfig) GetPlugins() (v []*ProductMaterial) {
	if !p.IsSetPlugins() {
		return BotConfig_Plugins_DEFAULT
	}
	return p.Plugins
}

var BotConfig_Knowledges_DEFAULT []*ProductMaterial

func (p *BotConfig) GetKnowledges() (v []*ProductMaterial) {
	if !p.IsSetKnowledges() {
		return BotConfig_Knowledges_DEFAULT
	}
	return p.Knowledges
}

var BotConfig_Workflows_DEFAULT []*ProductMaterial

func (p *BotConfig) GetWorkflows() (v []*ProductMaterial) {
	if !p.IsSetWorkflows() {
		return BotConfig_Workflows_DEFAULT
	}
	return p.Workflows
}

var BotConfig_PrivatePluginsCount_DEFAULT int32

func (p *BotConfig) GetPrivatePluginsCount() (v int32) {
	if !p.IsSetPrivatePluginsCount() {
		return BotConfig_PrivatePluginsCount_DEFAULT
	}
	return *p.PrivatePluginsCount
}

var BotConfig_PrivateKnowledgesCount_DEFAULT int32

func (p *BotConfig) GetPrivateKnowledgesCount() (v int32) {
	if !p.IsSetPrivateKnowledgesCount() {
		return BotConfig_PrivateKnowledgesCount_DEFAULT
	}
	return *p.PrivateKnowledgesCount
}

var BotConfig_PrivateWorkflowsCount_DEFAULT int32

func (p *BotConfig) GetPrivateWorkflowsCount() (v int32) {
	if !p.IsSetPrivateWorkflowsCount() {
		return BotConfig_PrivateWorkflowsCount_DEFAULT
	}
	return *p.PrivateWorkflowsCount
}

var BotConfig_HasBotAgent_DEFAULT bool

func (p *BotConfig) GetHasBotAgent() (v bool) {
	if !p.IsSetHasBotAgent() {
		return BotConfig_HasBotAgent_DEFAULT
	}
	return *p.HasBotAgent
}

var BotConfig_BotVoices_DEFAULT []*BotVoiceInfo

func (p *BotConfig) GetBotVoices() (v []*BotVoiceInfo) {
	if !p.IsSetBotVoices() {
		return BotConfig_BotVoices_DEFAULT
	}
	return p.BotVoices
}

var BotConfig_TotalPluginsCount_DEFAULT int32

func (p *BotConfig) GetTotalPluginsCount() (v int32) {
	if !p.IsSetTotalPluginsCount() {
		return BotConfig_TotalPluginsCount_DEFAULT
	}
	return *p.TotalPluginsCount
}

var BotConfig_TotalKnowledgesCount_DEFAULT int32

func (p *BotConfig) GetTotalKnowledgesCount() (v int32) {
	if !p.IsSetTotalKnowledgesCount() {
		return BotConfig_TotalKnowledgesCount_DEFAULT
	}
	return *p.TotalKnowledgesCount
}

var BotConfig_TotalWorkflowsCount_DEFAULT int32

func (p *BotConfig) GetTotalWorkflowsCount() (v int32) {
	if !p.IsSetTotalWorkflowsCount() {
		return BotConfig_TotalWorkflowsCount_DEFAULT
	}
	return *p.TotalWorkflowsCount
}

var BotConfig_TimeCapsuleMode_DEFAULT TimeCapsuleMode

func (p *BotConfig) GetTimeCapsuleMode() (v TimeCapsuleMode) {
	if !p.IsSetTimeCapsuleMode() {
		return BotConfig_TimeCapsuleMode_DEFAULT
	}
	return *p.TimeCapsuleMode
}

var BotConfig_FileboxMode_DEFAULT FileboxInfoMode

func (p *BotConfig) GetFileboxMode() (v FileboxInfoMode) {
	if !p.IsSetFileboxMode() {
		return BotConfig_FileboxMode_DEFAULT
	}
	return *p.FileboxMode
}

var BotConfig_PrivateImageWorkflowCount_DEFAULT int32

func (p *BotConfig) GetPrivateImageWorkflowCount() (v int32) {
	if !p.IsSetPrivateImageWorkflowCount() {
		return BotConfig_PrivateImageWorkflowCount_DEFAULT
	}
	return *p.PrivateImageWorkflowCount
}

var BotConfig_UserQueryCollectConf_DEFAULT *UserQueryCollectConf

func (p *BotConfig) GetUserQueryCollectConf() (v *UserQueryCollectConf) {
	if !p.IsSetUserQueryCollectConf() {
		return BotConfig_UserQueryCollectConf_DEFAULT
	}
	return p.UserQueryCollectConf
}

var BotConfig_IsCloseVoiceCall_DEFAULT bool

func (p *BotConfig) GetIsCloseVoiceCall() (v bool) {
	if !p.IsSetIsCloseVoiceCall() {
		return BotConfig_IsCloseVoiceCall_DEFAULT
	}
	return *p.IsCloseVoiceCall
}

var fieldIDToName_BotConfig = map[int16]string{
	1:  "Models",
	2:  "Plugins",
	3:  "Knowledges",
	4:  "Workflows",
	5:  "PrivatePluginsCount",
	6:  "PrivateKnowledgesCount",
	7:  "PrivateWorkflowsCount",
	8:  "HasBotAgent",
	9:  "BotVoices",
	10: "TotalPluginsCount",
	11: "TotalKnowledgesCount",
	12: "TotalWorkflowsCount",
	13: "TimeCapsuleMode",
	14: "FileboxMode",
	15: "PrivateImageWorkflowCount",
	16: "UserQueryCollectConf",
	17: "IsCloseVoiceCall",
}

func (p *BotConfig) IsSetModels() bool {
	return p.Models != nil
}

func (p *BotConfig) IsSetPlugins() bool {
	return p.Plugins != nil
}

func (p *BotConfig) IsSetKnowledges() bool {
	return p.Knowledges != nil
}

func (p *BotConfig) IsSetWorkflows() bool {
	return p.Workflows != nil
}

func (p *BotConfig) IsSetPrivatePluginsCount() bool {
	return p.PrivatePluginsCount != nil
}

func (p *BotConfig) IsSetPrivateKnowledgesCount() bool {
	return p.PrivateKnowledgesCount != nil
}

func (p *BotConfig) IsSetPrivateWorkflowsCount() bool {
	return p.PrivateWorkflowsCount != nil
}

func (p *BotConfig) IsSetHasBotAgent() bool {
	return p.HasBotAgent != nil
}

func (p *BotConfig) IsSetBotVoices() bool {
	return p.BotVoices != nil
}

func (p *BotConfig) IsSetTotalPluginsCount() bool {
	return p.TotalPluginsCount != nil
}

func (p *BotConfig) IsSetTotalKnowledgesCount() bool {
	return p.TotalKnowledgesCount != nil
}

func (p *BotConfig) IsSetTotalWorkflowsCount() bool {
	return p.TotalWorkflowsCount != nil
}

func (p *BotConfig) IsSetTimeCapsuleMode() bool {
	return p.TimeCapsuleMode != nil
}

func (p *BotConfig) IsSetFileboxMode() bool {
	return p.FileboxMode != nil
}

func (p *BotConfig) IsSetPrivateImageWorkflowCount() bool {
	return p.PrivateImageWorkflowCount != nil
}

func (p *BotConfig) IsSetUserQueryCollectConf() bool {
	return p.UserQueryCollectConf != nil
}

func (p *BotConfig) IsSetIsCloseVoiceCall() bool {
	return p.IsCloseVoiceCall != nil
}

func (p *BotConfig) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotConfig[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotConfig) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ProductMaterial, 0, size)
	values := make([]ProductMaterial, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Models = _field
	return nil
}
func (p *BotConfig) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ProductMaterial, 0, size)
	values := make([]ProductMaterial, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Plugins = _field
	return nil
}
func (p *BotConfig) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ProductMaterial, 0, size)
	values := make([]ProductMaterial, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Knowledges = _field
	return nil
}
func (p *BotConfig) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ProductMaterial, 0, size)
	values := make([]ProductMaterial, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Workflows = _field
	return nil
}
func (p *BotConfig) ReadField5(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrivatePluginsCount = _field
	return nil
}
func (p *BotConfig) ReadField6(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrivateKnowledgesCount = _field
	return nil
}
func (p *BotConfig) ReadField7(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrivateWorkflowsCount = _field
	return nil
}
func (p *BotConfig) ReadField8(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HasBotAgent = _field
	return nil
}
func (p *BotConfig) ReadField9(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*BotVoiceInfo, 0, size)
	values := make([]BotVoiceInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.BotVoices = _field
	return nil
}
func (p *BotConfig) ReadField10(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TotalPluginsCount = _field
	return nil
}
func (p *BotConfig) ReadField11(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TotalKnowledgesCount = _field
	return nil
}
func (p *BotConfig) ReadField12(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TotalWorkflowsCount = _field
	return nil
}
func (p *BotConfig) ReadField13(iprot thrift.TProtocol) error {

	var _field *TimeCapsuleMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TimeCapsuleMode(v)
		_field = &tmp
	}
	p.TimeCapsuleMode = _field
	return nil
}
func (p *BotConfig) ReadField14(iprot thrift.TProtocol) error {

	var _field *FileboxInfoMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := FileboxInfoMode(v)
		_field = &tmp
	}
	p.FileboxMode = _field
	return nil
}
func (p *BotConfig) ReadField15(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrivateImageWorkflowCount = _field
	return nil
}
func (p *BotConfig) ReadField16(iprot thrift.TProtocol) error {
	_field := NewUserQueryCollectConf()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserQueryCollectConf = _field
	return nil
}
func (p *BotConfig) ReadField17(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsCloseVoiceCall = _field
	return nil
}

func (p *BotConfig) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotConfig"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotConfig) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetModels() {
		if err = oprot.WriteFieldBegin("Models", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Models)); err != nil {
			return err
		}
		for _, v := range p.Models {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotConfig) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetPlugins() {
		if err = oprot.WriteFieldBegin("Plugins", thrift.LIST, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Plugins)); err != nil {
			return err
		}
		for _, v := range p.Plugins {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotConfig) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetKnowledges() {
		if err = oprot.WriteFieldBegin("Knowledges", thrift.LIST, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Knowledges)); err != nil {
			return err
		}
		for _, v := range p.Knowledges {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotConfig) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflows() {
		if err = oprot.WriteFieldBegin("Workflows", thrift.LIST, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Workflows)); err != nil {
			return err
		}
		for _, v := range p.Workflows {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *BotConfig) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrivatePluginsCount() {
		if err = oprot.WriteFieldBegin("PrivatePluginsCount", thrift.I32, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.PrivatePluginsCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *BotConfig) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrivateKnowledgesCount() {
		if err = oprot.WriteFieldBegin("PrivateKnowledgesCount", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.PrivateKnowledgesCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *BotConfig) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrivateWorkflowsCount() {
		if err = oprot.WriteFieldBegin("PrivateWorkflowsCount", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.PrivateWorkflowsCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *BotConfig) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetHasBotAgent() {
		if err = oprot.WriteFieldBegin("HasBotAgent", thrift.BOOL, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.HasBotAgent); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *BotConfig) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotVoices() {
		if err = oprot.WriteFieldBegin("BotVoices", thrift.LIST, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.BotVoices)); err != nil {
			return err
		}
		for _, v := range p.BotVoices {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *BotConfig) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetTotalPluginsCount() {
		if err = oprot.WriteFieldBegin("TotalPluginsCount", thrift.I32, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.TotalPluginsCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *BotConfig) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetTotalKnowledgesCount() {
		if err = oprot.WriteFieldBegin("TotalKnowledgesCount", thrift.I32, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.TotalKnowledgesCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *BotConfig) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetTotalWorkflowsCount() {
		if err = oprot.WriteFieldBegin("TotalWorkflowsCount", thrift.I32, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.TotalWorkflowsCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *BotConfig) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetTimeCapsuleMode() {
		if err = oprot.WriteFieldBegin("TimeCapsuleMode", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.TimeCapsuleMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *BotConfig) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetFileboxMode() {
		if err = oprot.WriteFieldBegin("FileboxMode", thrift.I32, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.FileboxMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *BotConfig) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrivateImageWorkflowCount() {
		if err = oprot.WriteFieldBegin("PrivateImageWorkflowCount", thrift.I32, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.PrivateImageWorkflowCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *BotConfig) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserQueryCollectConf() {
		if err = oprot.WriteFieldBegin("UserQueryCollectConf", thrift.STRUCT, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.UserQueryCollectConf.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *BotConfig) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsCloseVoiceCall() {
		if err = oprot.WriteFieldBegin("IsCloseVoiceCall", thrift.BOOL, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsCloseVoiceCall); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}

func (p *BotConfig) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotConfig(%+v)", *p)

}

// The bot information involved in the message, sharing the scene in the home, the message belongs to multiple bots
type ConversationRelateBot struct {
	ID          int64  `thrift:"ID,1" form:"id" json:"id,string"`
	Name        string `thrift:"Name,2" form:"name" json:"name"`
	Description string `thrift:"Description,3" form:"description" json:"description"`
	IconURL     string `thrift:"IconURL,4" form:"icon_url" json:"icon_url"`
}

func NewConversationRelateBot() *ConversationRelateBot {
	return &ConversationRelateBot{}
}

func (p *ConversationRelateBot) InitDefault() {
}

func (p *ConversationRelateBot) GetID() (v int64) {
	return p.ID
}

func (p *ConversationRelateBot) GetName() (v string) {
	return p.Name
}

func (p *ConversationRelateBot) GetDescription() (v string) {
	return p.Description
}

func (p *ConversationRelateBot) GetIconURL() (v string) {
	return p.IconURL
}

var fieldIDToName_ConversationRelateBot = map[int16]string{
	1: "ID",
	2: "Name",
	3: "Description",
	4: "IconURL",
}

func (p *ConversationRelateBot) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ConversationRelateBot[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ConversationRelateBot) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *ConversationRelateBot) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ConversationRelateBot) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *ConversationRelateBot) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}

func (p *ConversationRelateBot) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ConversationRelateBot"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ConversationRelateBot) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ConversationRelateBot) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ConversationRelateBot) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Description", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ConversationRelateBot) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IconURL", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *ConversationRelateBot) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ConversationRelateBot(%+v)", *p)

}

// The user information involved in the message, sharing the scene in the home, the message belongs to multiple users
type ConversationRelateUser struct {
	UserInfo *product_common.UserInfo `thrift:"UserInfo,1,optional" form:"user_info" json:"user_info,omitempty"`
}

func NewConversationRelateUser() *ConversationRelateUser {
	return &ConversationRelateUser{}
}

func (p *ConversationRelateUser) InitDefault() {
}

var ConversationRelateUser_UserInfo_DEFAULT *product_common.UserInfo

func (p *ConversationRelateUser) GetUserInfo() (v *product_common.UserInfo) {
	if !p.IsSetUserInfo() {
		return ConversationRelateUser_UserInfo_DEFAULT
	}
	return p.UserInfo
}

var fieldIDToName_ConversationRelateUser = map[int16]string{
	1: "UserInfo",
}

func (p *ConversationRelateUser) IsSetUserInfo() bool {
	return p.UserInfo != nil
}

func (p *ConversationRelateUser) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ConversationRelateUser[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ConversationRelateUser) ReadField1(iprot thrift.TProtocol) error {
	_field := product_common.NewUserInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserInfo = _field
	return nil
}

func (p *ConversationRelateUser) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ConversationRelateUser"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ConversationRelateUser) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserInfo() {
		if err = oprot.WriteFieldBegin("UserInfo", thrift.STRUCT, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.UserInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *ConversationRelateUser) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ConversationRelateUser(%+v)", *p)

}

type Conversation struct {
	// conversation example
	Snippets []string `thrift:"Snippets,1,optional" form:"snippets" json:"snippets,omitempty"`
	// conversation title
	Title *string `thrift:"Title,2,optional" form:"title" json:"title,omitempty"`
	// Conversation ID, generated by idGen
	ID *int64 `thrift:"ID,3,optional" form:"id" json:"id,string,omitempty"`
	// Do you need to generate a conversation?
	GenTitle *bool `thrift:"GenTitle,4,optional" form:"gen_title" json:"gen_title,omitempty"`
	// conversation moderation status
	AuditStatus *product_common.AuditStatus `thrift:"AuditStatus,5,optional" form:"audit_status" json:"audit_status,omitempty"`
	// opening statement
	OpeningDialog *product_common.OpeningDialog `thrift:"OpeningDialog,6,optional" form:"opening_dialog" json:"opening_dialog,omitempty"`
	// The bot information involved in the message, key bot_id
	RelateBots map[string]*ConversationRelateBot `thrift:"RelateBots,7,optional" form:"relate_bots" json:"relate_bots,omitempty"`
	// The user information involved in the message, key user_id
	RelateUsers map[string]*ConversationRelateUser `thrift:"RelateUsers,8,optional" form:"relate_users" json:"relate_users,omitempty"`
}

func NewConversation() *Conversation {
	return &Conversation{}
}

func (p *Conversation) InitDefault() {
}

var Conversation_Snippets_DEFAULT []string

func (p *Conversation) GetSnippets() (v []string) {
	if !p.IsSetSnippets() {
		return Conversation_Snippets_DEFAULT
	}
	return p.Snippets
}

var Conversation_Title_DEFAULT string

func (p *Conversation) GetTitle() (v string) {
	if !p.IsSetTitle() {
		return Conversation_Title_DEFAULT
	}
	return *p.Title
}

var Conversation_ID_DEFAULT int64

func (p *Conversation) GetID() (v int64) {
	if !p.IsSetID() {
		return Conversation_ID_DEFAULT
	}
	return *p.ID
}

var Conversation_GenTitle_DEFAULT bool

func (p *Conversation) GetGenTitle() (v bool) {
	if !p.IsSetGenTitle() {
		return Conversation_GenTitle_DEFAULT
	}
	return *p.GenTitle
}

var Conversation_AuditStatus_DEFAULT product_common.AuditStatus

func (p *Conversation) GetAuditStatus() (v product_common.AuditStatus) {
	if !p.IsSetAuditStatus() {
		return Conversation_AuditStatus_DEFAULT
	}
	return *p.AuditStatus
}

var Conversation_OpeningDialog_DEFAULT *product_common.OpeningDialog

func (p *Conversation) GetOpeningDialog() (v *product_common.OpeningDialog) {
	if !p.IsSetOpeningDialog() {
		return Conversation_OpeningDialog_DEFAULT
	}
	return p.OpeningDialog
}

var Conversation_RelateBots_DEFAULT map[string]*ConversationRelateBot

func (p *Conversation) GetRelateBots() (v map[string]*ConversationRelateBot) {
	if !p.IsSetRelateBots() {
		return Conversation_RelateBots_DEFAULT
	}
	return p.RelateBots
}

var Conversation_RelateUsers_DEFAULT map[string]*ConversationRelateUser

func (p *Conversation) GetRelateUsers() (v map[string]*ConversationRelateUser) {
	if !p.IsSetRelateUsers() {
		return Conversation_RelateUsers_DEFAULT
	}
	return p.RelateUsers
}

var fieldIDToName_Conversation = map[int16]string{
	1: "Snippets",
	2: "Title",
	3: "ID",
	4: "GenTitle",
	5: "AuditStatus",
	6: "OpeningDialog",
	7: "RelateBots",
	8: "RelateUsers",
}

func (p *Conversation) IsSetSnippets() bool {
	return p.Snippets != nil
}

func (p *Conversation) IsSetTitle() bool {
	return p.Title != nil
}

func (p *Conversation) IsSetID() bool {
	return p.ID != nil
}

func (p *Conversation) IsSetGenTitle() bool {
	return p.GenTitle != nil
}

func (p *Conversation) IsSetAuditStatus() bool {
	return p.AuditStatus != nil
}

func (p *Conversation) IsSetOpeningDialog() bool {
	return p.OpeningDialog != nil
}

func (p *Conversation) IsSetRelateBots() bool {
	return p.RelateBots != nil
}

func (p *Conversation) IsSetRelateUsers() bool {
	return p.RelateUsers != nil
}

func (p *Conversation) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Conversation[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Conversation) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Snippets = _field
	return nil
}
func (p *Conversation) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Title = _field
	return nil
}
func (p *Conversation) ReadField3(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ID = _field
	return nil
}
func (p *Conversation) ReadField4(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.GenTitle = _field
	return nil
}
func (p *Conversation) ReadField5(iprot thrift.TProtocol) error {

	var _field *product_common.AuditStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.AuditStatus(v)
		_field = &tmp
	}
	p.AuditStatus = _field
	return nil
}
func (p *Conversation) ReadField6(iprot thrift.TProtocol) error {
	_field := product_common.NewOpeningDialog()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.OpeningDialog = _field
	return nil
}
func (p *Conversation) ReadField7(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]*ConversationRelateBot, size)
	values := make([]ConversationRelateBot, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.RelateBots = _field
	return nil
}
func (p *Conversation) ReadField8(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]*ConversationRelateUser, size)
	values := make([]ConversationRelateUser, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.RelateUsers = _field
	return nil
}

func (p *Conversation) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Conversation"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Conversation) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetSnippets() {
		if err = oprot.WriteFieldBegin("Snippets", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.Snippets)); err != nil {
			return err
		}
		for _, v := range p.Snippets {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Conversation) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetTitle() {
		if err = oprot.WriteFieldBegin("Title", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Title); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Conversation) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetID() {
		if err = oprot.WriteFieldBegin("ID", thrift.I64, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Conversation) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetGenTitle() {
		if err = oprot.WriteFieldBegin("GenTitle", thrift.BOOL, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.GenTitle); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Conversation) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetAuditStatus() {
		if err = oprot.WriteFieldBegin("AuditStatus", thrift.I32, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.AuditStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Conversation) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetOpeningDialog() {
		if err = oprot.WriteFieldBegin("OpeningDialog", thrift.STRUCT, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.OpeningDialog.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *Conversation) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetRelateBots() {
		if err = oprot.WriteFieldBegin("RelateBots", thrift.MAP, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRUCT, len(p.RelateBots)); err != nil {
			return err
		}
		for k, v := range p.RelateBots {
			if err := oprot.WriteString(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *Conversation) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetRelateUsers() {
		if err = oprot.WriteFieldBegin("RelateUsers", thrift.MAP, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRUCT, len(p.RelateUsers)); err != nil {
			return err
		}
		for k, v := range p.RelateUsers {
			if err := oprot.WriteString(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}

func (p *Conversation) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Conversation(%+v)", *p)

}

type BotExtraInfo struct {
	// publish platforms
	PublishPlatforms []*BotPublishPlatform `thrift:"PublishPlatforms,1" form:"publish_platforms" json:"publish_platforms"`
	// user count
	UserCount int32 `thrift:"UserCount,2" form:"user_count" json:"user_count"`
	// public method
	PublishMode product_common.ProductPublishMode `thrift:"PublishMode,3" form:"publish_mode" json:"publish_mode"`
	// Details page unique
	ConversationSnippets [][]string `thrift:"ConversationSnippets,4,optional" form:"conversation_snippets" json:"conversation_snippets,omitempty"`
	// configuration
	Config *BotConfig `thrift:"Config,5,optional" form:"config" json:"config,omitempty"`
	// whitelist
	IsInhouseUser *bool `thrift:"IsInhouseUser,6,optional" form:"is_inhouse_user" json:"is_inhouse_user,omitempty"`
	// Number of copy-created bots
	DuplicateBotCount *int32 `thrift:"DuplicateBotCount,7,optional" form:"duplicate_bot_count" json:"duplicate_bot_count,omitempty"`
	// Share the conversation
	Conversations []*Conversation `thrift:"Conversations,8,optional" form:"conversations" json:"conversations,omitempty"`
	// Number of conversations with Bot
	ChatConversationCount *int64 `thrift:"ChatConversationCount,9,optional" form:"chat_conversation_count" json:"chat_conversation_count,string,omitempty"`
	// number of related products
	RelatedProductCount *int64 `thrift:"RelatedProductCount,10,optional" form:"related_product_count" json:"related_product_count,string,omitempty"`
}

func NewBotExtraInfo() *BotExtraInfo {
	return &BotExtraInfo{}
}

func (p *BotExtraInfo) InitDefault() {
}

func (p *BotExtraInfo) GetPublishPlatforms() (v []*BotPublishPlatform) {
	return p.PublishPlatforms
}

func (p *BotExtraInfo) GetUserCount() (v int32) {
	return p.UserCount
}

func (p *BotExtraInfo) GetPublishMode() (v product_common.ProductPublishMode) {
	return p.PublishMode
}

var BotExtraInfo_ConversationSnippets_DEFAULT [][]string

func (p *BotExtraInfo) GetConversationSnippets() (v [][]string) {
	if !p.IsSetConversationSnippets() {
		return BotExtraInfo_ConversationSnippets_DEFAULT
	}
	return p.ConversationSnippets
}

var BotExtraInfo_Config_DEFAULT *BotConfig

func (p *BotExtraInfo) GetConfig() (v *BotConfig) {
	if !p.IsSetConfig() {
		return BotExtraInfo_Config_DEFAULT
	}
	return p.Config
}

var BotExtraInfo_IsInhouseUser_DEFAULT bool

func (p *BotExtraInfo) GetIsInhouseUser() (v bool) {
	if !p.IsSetIsInhouseUser() {
		return BotExtraInfo_IsInhouseUser_DEFAULT
	}
	return *p.IsInhouseUser
}

var BotExtraInfo_DuplicateBotCount_DEFAULT int32

func (p *BotExtraInfo) GetDuplicateBotCount() (v int32) {
	if !p.IsSetDuplicateBotCount() {
		return BotExtraInfo_DuplicateBotCount_DEFAULT
	}
	return *p.DuplicateBotCount
}

var BotExtraInfo_Conversations_DEFAULT []*Conversation

func (p *BotExtraInfo) GetConversations() (v []*Conversation) {
	if !p.IsSetConversations() {
		return BotExtraInfo_Conversations_DEFAULT
	}
	return p.Conversations
}

var BotExtraInfo_ChatConversationCount_DEFAULT int64

func (p *BotExtraInfo) GetChatConversationCount() (v int64) {
	if !p.IsSetChatConversationCount() {
		return BotExtraInfo_ChatConversationCount_DEFAULT
	}
	return *p.ChatConversationCount
}

var BotExtraInfo_RelatedProductCount_DEFAULT int64

func (p *BotExtraInfo) GetRelatedProductCount() (v int64) {
	if !p.IsSetRelatedProductCount() {
		return BotExtraInfo_RelatedProductCount_DEFAULT
	}
	return *p.RelatedProductCount
}

var fieldIDToName_BotExtraInfo = map[int16]string{
	1:  "PublishPlatforms",
	2:  "UserCount",
	3:  "PublishMode",
	4:  "ConversationSnippets",
	5:  "Config",
	6:  "IsInhouseUser",
	7:  "DuplicateBotCount",
	8:  "Conversations",
	9:  "ChatConversationCount",
	10: "RelatedProductCount",
}

func (p *BotExtraInfo) IsSetConversationSnippets() bool {
	return p.ConversationSnippets != nil
}

func (p *BotExtraInfo) IsSetConfig() bool {
	return p.Config != nil
}

func (p *BotExtraInfo) IsSetIsInhouseUser() bool {
	return p.IsInhouseUser != nil
}

func (p *BotExtraInfo) IsSetDuplicateBotCount() bool {
	return p.DuplicateBotCount != nil
}

func (p *BotExtraInfo) IsSetConversations() bool {
	return p.Conversations != nil
}

func (p *BotExtraInfo) IsSetChatConversationCount() bool {
	return p.ChatConversationCount != nil
}

func (p *BotExtraInfo) IsSetRelatedProductCount() bool {
	return p.RelatedProductCount != nil
}

func (p *BotExtraInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotExtraInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotExtraInfo) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*BotPublishPlatform, 0, size)
	values := make([]BotPublishPlatform, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.PublishPlatforms = _field
	return nil
}
func (p *BotExtraInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserCount = _field
	return nil
}
func (p *BotExtraInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field product_common.ProductPublishMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductPublishMode(v)
	}
	p.PublishMode = _field
	return nil
}
func (p *BotExtraInfo) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([][]string, 0, size)
	for i := 0; i < size; i++ {
		_, size, err := iprot.ReadListBegin()
		if err != nil {
			return err
		}
		_elem := make([]string, 0, size)
		for i := 0; i < size; i++ {

			var _elem1 string
			if v, err := iprot.ReadString(); err != nil {
				return err
			} else {
				_elem1 = v
			}

			_elem = append(_elem, _elem1)
		}
		if err := iprot.ReadListEnd(); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.ConversationSnippets = _field
	return nil
}
func (p *BotExtraInfo) ReadField5(iprot thrift.TProtocol) error {
	_field := NewBotConfig()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Config = _field
	return nil
}
func (p *BotExtraInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsInhouseUser = _field
	return nil
}
func (p *BotExtraInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.DuplicateBotCount = _field
	return nil
}
func (p *BotExtraInfo) ReadField8(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Conversation, 0, size)
	values := make([]Conversation, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Conversations = _field
	return nil
}
func (p *BotExtraInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ChatConversationCount = _field
	return nil
}
func (p *BotExtraInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.RelatedProductCount = _field
	return nil
}

func (p *BotExtraInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotExtraInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotExtraInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PublishPlatforms", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.PublishPlatforms)); err != nil {
		return err
	}
	for _, v := range p.PublishPlatforms {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotExtraInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("UserCount", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.UserCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotExtraInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PublishMode", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.PublishMode)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotExtraInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetConversationSnippets() {
		if err = oprot.WriteFieldBegin("ConversationSnippets", thrift.LIST, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.LIST, len(p.ConversationSnippets)); err != nil {
			return err
		}
		for _, v := range p.ConversationSnippets {
			if err := oprot.WriteListBegin(thrift.STRING, len(v)); err != nil {
				return err
			}
			for _, v := range v {
				if err := oprot.WriteString(v); err != nil {
					return err
				}
			}
			if err := oprot.WriteListEnd(); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *BotExtraInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetConfig() {
		if err = oprot.WriteFieldBegin("Config", thrift.STRUCT, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Config.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *BotExtraInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsInhouseUser() {
		if err = oprot.WriteFieldBegin("IsInhouseUser", thrift.BOOL, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsInhouseUser); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *BotExtraInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetDuplicateBotCount() {
		if err = oprot.WriteFieldBegin("DuplicateBotCount", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.DuplicateBotCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *BotExtraInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetConversations() {
		if err = oprot.WriteFieldBegin("Conversations", thrift.LIST, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Conversations)); err != nil {
			return err
		}
		for _, v := range p.Conversations {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *BotExtraInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetChatConversationCount() {
		if err = oprot.WriteFieldBegin("ChatConversationCount", thrift.I64, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ChatConversationCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *BotExtraInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetRelatedProductCount() {
		if err = oprot.WriteFieldBegin("RelatedProductCount", thrift.I64, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.RelatedProductCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}

func (p *BotExtraInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotExtraInfo(%+v)", *p)

}

type WorkflowParameter struct {
	Name          string                   `thrift:"Name,1" form:"name" json:"name"`
	Desc          string                   `thrift:"Desc,2" form:"desc" json:"desc"`
	IsRequired    bool                     `thrift:"IsRequired,3" form:"is_required" json:"is_required"`
	InputType     product_common.InputType `thrift:"InputType,4" form:"input_type" json:"input_type"`
	SubParameters []*WorkflowParameter     `thrift:"SubParameters,5" form:"sub_parameters" json:"sub_parameters"`
	// If Type is an array, there is a subtype
	SubType product_common.InputType `thrift:"SubType,6" form:"sub_type" json:"sub_type"`
	// If the imported parameter is the user's hand input, put it here
	Value      *string                               `thrift:"Value,7,optional" form:"value" json:"value,omitempty"`
	Format     *product_common.PluginParamTypeFormat `thrift:"Format,8,optional" form:"format" json:"format,omitempty"`
	FromNodeId *string                               `thrift:"FromNodeId,9,optional" form:"from_node_id" json:"from_node_id,omitempty"`
	FromOutput []string                              `thrift:"FromOutput,10,optional" form:"from_output" json:"from_output,omitempty"`
	// InputType (+ AssistType) defines the final type of a variable, which only needs to be passed through
	AssistType *int64 `thrift:"AssistType,11,optional" form:"assist_type" json:"assist_type,omitempty"`
	// Display name (unique to the store, used for details page GUI display parameters)
	ShowName *string `thrift:"ShowName,12,optional" form:"show_name" json:"show_name,omitempty"`
	// If the InputType is an array, there is a subassistant type
	SubAssistType *int64 `thrift:"SubAssistType,13,optional" form:"sub_assist_type" json:"sub_assist_type,omitempty"`
	// Component configuration, parsed and rendered by the front end
	ComponentConfig *string `thrift:"ComponentConfig,14,optional" form:"component_config" json:"component_config,omitempty"`
	// Component configuration type, required for front-end display
	ComponentType *string `thrift:"ComponentType,15,optional" form:"component_type" json:"component_type,omitempty"`
}

func NewWorkflowParameter() *WorkflowParameter {
	return &WorkflowParameter{}
}

func (p *WorkflowParameter) InitDefault() {
}

func (p *WorkflowParameter) GetName() (v string) {
	return p.Name
}

func (p *WorkflowParameter) GetDesc() (v string) {
	return p.Desc
}

func (p *WorkflowParameter) GetIsRequired() (v bool) {
	return p.IsRequired
}

func (p *WorkflowParameter) GetInputType() (v product_common.InputType) {
	return p.InputType
}

func (p *WorkflowParameter) GetSubParameters() (v []*WorkflowParameter) {
	return p.SubParameters
}

func (p *WorkflowParameter) GetSubType() (v product_common.InputType) {
	return p.SubType
}

var WorkflowParameter_Value_DEFAULT string

func (p *WorkflowParameter) GetValue() (v string) {
	if !p.IsSetValue() {
		return WorkflowParameter_Value_DEFAULT
	}
	return *p.Value
}

var WorkflowParameter_Format_DEFAULT product_common.PluginParamTypeFormat

func (p *WorkflowParameter) GetFormat() (v product_common.PluginParamTypeFormat) {
	if !p.IsSetFormat() {
		return WorkflowParameter_Format_DEFAULT
	}
	return *p.Format
}

var WorkflowParameter_FromNodeId_DEFAULT string

func (p *WorkflowParameter) GetFromNodeId() (v string) {
	if !p.IsSetFromNodeId() {
		return WorkflowParameter_FromNodeId_DEFAULT
	}
	return *p.FromNodeId
}

var WorkflowParameter_FromOutput_DEFAULT []string

func (p *WorkflowParameter) GetFromOutput() (v []string) {
	if !p.IsSetFromOutput() {
		return WorkflowParameter_FromOutput_DEFAULT
	}
	return p.FromOutput
}

var WorkflowParameter_AssistType_DEFAULT int64

func (p *WorkflowParameter) GetAssistType() (v int64) {
	if !p.IsSetAssistType() {
		return WorkflowParameter_AssistType_DEFAULT
	}
	return *p.AssistType
}

var WorkflowParameter_ShowName_DEFAULT string

func (p *WorkflowParameter) GetShowName() (v string) {
	if !p.IsSetShowName() {
		return WorkflowParameter_ShowName_DEFAULT
	}
	return *p.ShowName
}

var WorkflowParameter_SubAssistType_DEFAULT int64

func (p *WorkflowParameter) GetSubAssistType() (v int64) {
	if !p.IsSetSubAssistType() {
		return WorkflowParameter_SubAssistType_DEFAULT
	}
	return *p.SubAssistType
}

var WorkflowParameter_ComponentConfig_DEFAULT string

func (p *WorkflowParameter) GetComponentConfig() (v string) {
	if !p.IsSetComponentConfig() {
		return WorkflowParameter_ComponentConfig_DEFAULT
	}
	return *p.ComponentConfig
}

var WorkflowParameter_ComponentType_DEFAULT string

func (p *WorkflowParameter) GetComponentType() (v string) {
	if !p.IsSetComponentType() {
		return WorkflowParameter_ComponentType_DEFAULT
	}
	return *p.ComponentType
}

var fieldIDToName_WorkflowParameter = map[int16]string{
	1:  "Name",
	2:  "Desc",
	3:  "IsRequired",
	4:  "InputType",
	5:  "SubParameters",
	6:  "SubType",
	7:  "Value",
	8:  "Format",
	9:  "FromNodeId",
	10: "FromOutput",
	11: "AssistType",
	12: "ShowName",
	13: "SubAssistType",
	14: "ComponentConfig",
	15: "ComponentType",
}

func (p *WorkflowParameter) IsSetValue() bool {
	return p.Value != nil
}

func (p *WorkflowParameter) IsSetFormat() bool {
	return p.Format != nil
}

func (p *WorkflowParameter) IsSetFromNodeId() bool {
	return p.FromNodeId != nil
}

func (p *WorkflowParameter) IsSetFromOutput() bool {
	return p.FromOutput != nil
}

func (p *WorkflowParameter) IsSetAssistType() bool {
	return p.AssistType != nil
}

func (p *WorkflowParameter) IsSetShowName() bool {
	return p.ShowName != nil
}

func (p *WorkflowParameter) IsSetSubAssistType() bool {
	return p.SubAssistType != nil
}

func (p *WorkflowParameter) IsSetComponentConfig() bool {
	return p.ComponentConfig != nil
}

func (p *WorkflowParameter) IsSetComponentType() bool {
	return p.ComponentType != nil
}

func (p *WorkflowParameter) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowParameter[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowParameter) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *WorkflowParameter) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *WorkflowParameter) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsRequired = _field
	return nil
}
func (p *WorkflowParameter) ReadField4(iprot thrift.TProtocol) error {

	var _field product_common.InputType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.InputType(v)
	}
	p.InputType = _field
	return nil
}
func (p *WorkflowParameter) ReadField5(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowParameter, 0, size)
	values := make([]WorkflowParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubParameters = _field
	return nil
}
func (p *WorkflowParameter) ReadField6(iprot thrift.TProtocol) error {

	var _field product_common.InputType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.InputType(v)
	}
	p.SubType = _field
	return nil
}
func (p *WorkflowParameter) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Value = _field
	return nil
}
func (p *WorkflowParameter) ReadField8(iprot thrift.TProtocol) error {

	var _field *product_common.PluginParamTypeFormat
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.PluginParamTypeFormat(v)
		_field = &tmp
	}
	p.Format = _field
	return nil
}
func (p *WorkflowParameter) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.FromNodeId = _field
	return nil
}
func (p *WorkflowParameter) ReadField10(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.FromOutput = _field
	return nil
}
func (p *WorkflowParameter) ReadField11(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.AssistType = _field
	return nil
}
func (p *WorkflowParameter) ReadField12(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ShowName = _field
	return nil
}
func (p *WorkflowParameter) ReadField13(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SubAssistType = _field
	return nil
}
func (p *WorkflowParameter) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ComponentConfig = _field
	return nil
}
func (p *WorkflowParameter) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ComponentType = _field
	return nil
}

func (p *WorkflowParameter) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowParameter"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowParameter) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowParameter) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Desc", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowParameter) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsRequired", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsRequired); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkflowParameter) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("InputType", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.InputType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkflowParameter) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("SubParameters", thrift.LIST, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.SubParameters)); err != nil {
		return err
	}
	for _, v := range p.SubParameters {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WorkflowParameter) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("SubType", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SubType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *WorkflowParameter) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetValue() {
		if err = oprot.WriteFieldBegin("Value", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Value); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *WorkflowParameter) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetFormat() {
		if err = oprot.WriteFieldBegin("Format", thrift.I32, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Format)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *WorkflowParameter) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetFromNodeId() {
		if err = oprot.WriteFieldBegin("FromNodeId", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.FromNodeId); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *WorkflowParameter) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetFromOutput() {
		if err = oprot.WriteFieldBegin("FromOutput", thrift.LIST, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.FromOutput)); err != nil {
			return err
		}
		for _, v := range p.FromOutput {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *WorkflowParameter) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetAssistType() {
		if err = oprot.WriteFieldBegin("AssistType", thrift.I64, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.AssistType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *WorkflowParameter) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetShowName() {
		if err = oprot.WriteFieldBegin("ShowName", thrift.STRING, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ShowName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *WorkflowParameter) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubAssistType() {
		if err = oprot.WriteFieldBegin("SubAssistType", thrift.I64, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.SubAssistType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *WorkflowParameter) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetComponentConfig() {
		if err = oprot.WriteFieldBegin("ComponentConfig", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ComponentConfig); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *WorkflowParameter) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetComponentType() {
		if err = oprot.WriteFieldBegin("ComponentType", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ComponentType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}

func (p *WorkflowParameter) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowParameter(%+v)", *p)

}

type WorkflowTerminatePlan struct {
	// The answer mode corresponding to the end node of the workflow: 1 - Return the variable, and the Bot generates the answer; 2 - Use the set content to answer directly
	TerminatePlanType int32 `thrift:"TerminatePlanType,1" form:"terminate_plan_type" json:"terminate_plan_type"`
	// Return content of scene configuration corresponding to terminate_plan_type = 2
	Content string `thrift:"Content,2" form:"content" json:"content"`
}

func NewWorkflowTerminatePlan() *WorkflowTerminatePlan {
	return &WorkflowTerminatePlan{}
}

func (p *WorkflowTerminatePlan) InitDefault() {
}

func (p *WorkflowTerminatePlan) GetTerminatePlanType() (v int32) {
	return p.TerminatePlanType
}

func (p *WorkflowTerminatePlan) GetContent() (v string) {
	return p.Content
}

var fieldIDToName_WorkflowTerminatePlan = map[int16]string{
	1: "TerminatePlanType",
	2: "Content",
}

func (p *WorkflowTerminatePlan) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowTerminatePlan[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowTerminatePlan) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TerminatePlanType = _field
	return nil
}
func (p *WorkflowTerminatePlan) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Content = _field
	return nil
}

func (p *WorkflowTerminatePlan) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowTerminatePlan"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowTerminatePlan) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("TerminatePlanType", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TerminatePlanType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowTerminatePlan) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Content", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Content); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *WorkflowTerminatePlan) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowTerminatePlan(%+v)", *p)

}

type WorkflowNodeParam struct {
	InputParameters  []*WorkflowParameter   `thrift:"InputParameters,1,optional" form:"input_parameters" json:"input_parameters,omitempty"`
	TerminatePlan    *WorkflowTerminatePlan `thrift:"TerminatePlan,2,optional" form:"terminate_plan" json:"terminate_plan,omitempty"`
	OutpurParameters []*WorkflowParameter   `thrift:"OutpurParameters,3,optional" form:"output_parameters" json:"output_parameters,omitempty"`
}

func NewWorkflowNodeParam() *WorkflowNodeParam {
	return &WorkflowNodeParam{}
}

func (p *WorkflowNodeParam) InitDefault() {
}

var WorkflowNodeParam_InputParameters_DEFAULT []*WorkflowParameter

func (p *WorkflowNodeParam) GetInputParameters() (v []*WorkflowParameter) {
	if !p.IsSetInputParameters() {
		return WorkflowNodeParam_InputParameters_DEFAULT
	}
	return p.InputParameters
}

var WorkflowNodeParam_TerminatePlan_DEFAULT *WorkflowTerminatePlan

func (p *WorkflowNodeParam) GetTerminatePlan() (v *WorkflowTerminatePlan) {
	if !p.IsSetTerminatePlan() {
		return WorkflowNodeParam_TerminatePlan_DEFAULT
	}
	return p.TerminatePlan
}

var WorkflowNodeParam_OutpurParameters_DEFAULT []*WorkflowParameter

func (p *WorkflowNodeParam) GetOutpurParameters() (v []*WorkflowParameter) {
	if !p.IsSetOutpurParameters() {
		return WorkflowNodeParam_OutpurParameters_DEFAULT
	}
	return p.OutpurParameters
}

var fieldIDToName_WorkflowNodeParam = map[int16]string{
	1: "InputParameters",
	2: "TerminatePlan",
	3: "OutpurParameters",
}

func (p *WorkflowNodeParam) IsSetInputParameters() bool {
	return p.InputParameters != nil
}

func (p *WorkflowNodeParam) IsSetTerminatePlan() bool {
	return p.TerminatePlan != nil
}

func (p *WorkflowNodeParam) IsSetOutpurParameters() bool {
	return p.OutpurParameters != nil
}

func (p *WorkflowNodeParam) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowNodeParam[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowNodeParam) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowParameter, 0, size)
	values := make([]WorkflowParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.InputParameters = _field
	return nil
}
func (p *WorkflowNodeParam) ReadField2(iprot thrift.TProtocol) error {
	_field := NewWorkflowTerminatePlan()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.TerminatePlan = _field
	return nil
}
func (p *WorkflowNodeParam) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowParameter, 0, size)
	values := make([]WorkflowParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.OutpurParameters = _field
	return nil
}

func (p *WorkflowNodeParam) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowNodeParam"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowNodeParam) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetInputParameters() {
		if err = oprot.WriteFieldBegin("InputParameters", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.InputParameters)); err != nil {
			return err
		}
		for _, v := range p.InputParameters {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowNodeParam) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetTerminatePlan() {
		if err = oprot.WriteFieldBegin("TerminatePlan", thrift.STRUCT, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.TerminatePlan.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowNodeParam) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetOutpurParameters() {
		if err = oprot.WriteFieldBegin("OutpurParameters", thrift.LIST, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.OutpurParameters)); err != nil {
			return err
		}
		for _, v := range p.OutpurParameters {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *WorkflowNodeParam) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowNodeParam(%+v)", *p)

}

type WorkflowNodeInfo struct {
	NodeID    string                          `thrift:"NodeID,1" form:"node_id" json:"node_id"`
	NodeType  product_common.WorkflowNodeType `thrift:"NodeType,2" form:"node_type" json:"node_type"`
	NodeParam *WorkflowNodeParam              `thrift:"NodeParam,3,optional" form:"node_param" json:"node_param,omitempty"`
	// Node icon
	NodeIconURL string `thrift:"NodeIconURL,4" form:"node_icon_url" json:"node_icon_url"`
	// Presentation name (unique to the store, the name used for the details page GUI display message node)
	ShowName *string `thrift:"ShowName,5,optional" form:"show_name" json:"show_name,omitempty"`
}

func NewWorkflowNodeInfo() *WorkflowNodeInfo {
	return &WorkflowNodeInfo{}
}

func (p *WorkflowNodeInfo) InitDefault() {
}

func (p *WorkflowNodeInfo) GetNodeID() (v string) {
	return p.NodeID
}

func (p *WorkflowNodeInfo) GetNodeType() (v product_common.WorkflowNodeType) {
	return p.NodeType
}

var WorkflowNodeInfo_NodeParam_DEFAULT *WorkflowNodeParam

func (p *WorkflowNodeInfo) GetNodeParam() (v *WorkflowNodeParam) {
	if !p.IsSetNodeParam() {
		return WorkflowNodeInfo_NodeParam_DEFAULT
	}
	return p.NodeParam
}

func (p *WorkflowNodeInfo) GetNodeIconURL() (v string) {
	return p.NodeIconURL
}

var WorkflowNodeInfo_ShowName_DEFAULT string

func (p *WorkflowNodeInfo) GetShowName() (v string) {
	if !p.IsSetShowName() {
		return WorkflowNodeInfo_ShowName_DEFAULT
	}
	return *p.ShowName
}

var fieldIDToName_WorkflowNodeInfo = map[int16]string{
	1: "NodeID",
	2: "NodeType",
	3: "NodeParam",
	4: "NodeIconURL",
	5: "ShowName",
}

func (p *WorkflowNodeInfo) IsSetNodeParam() bool {
	return p.NodeParam != nil
}

func (p *WorkflowNodeInfo) IsSetShowName() bool {
	return p.ShowName != nil
}

func (p *WorkflowNodeInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowNodeInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowNodeInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.NodeID = _field
	return nil
}
func (p *WorkflowNodeInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field product_common.WorkflowNodeType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.WorkflowNodeType(v)
	}
	p.NodeType = _field
	return nil
}
func (p *WorkflowNodeInfo) ReadField3(iprot thrift.TProtocol) error {
	_field := NewWorkflowNodeParam()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.NodeParam = _field
	return nil
}
func (p *WorkflowNodeInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.NodeIconURL = _field
	return nil
}
func (p *WorkflowNodeInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ShowName = _field
	return nil
}

func (p *WorkflowNodeInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowNodeInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowNodeInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("NodeID", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.NodeID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowNodeInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("NodeType", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.NodeType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowNodeInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetNodeParam() {
		if err = oprot.WriteFieldBegin("NodeParam", thrift.STRUCT, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.NodeParam.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkflowNodeInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("NodeIconURL", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.NodeIconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkflowNodeInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetShowName() {
		if err = oprot.WriteFieldBegin("ShowName", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ShowName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *WorkflowNodeInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowNodeInfo(%+v)", *p)

}

type WorkflowEntity struct {
	// Product ID
	ProductID     int64                            `thrift:"ProductID,1" form:"product_id" json:"product_id,string"`
	Name          string                           `thrift:"Name,2" form:"name" json:"name"`
	EntityID      int64                            `thrift:"EntityID,3" form:"entity_id" json:"entity_id,string"`
	EntityType    product_common.ProductEntityType `thrift:"EntityType,4" form:"entity_type" json:"entity_type"`
	EntityVersion int64                            `thrift:"EntityVersion,5" form:"entity_version" json:"entity_version,string"`
	IconURL       string                           `thrift:"IconURL,6" form:"icon_url" json:"icon_url"`
	EntityName    string                           `thrift:"EntityName,7" form:"entity_name" json:"entity_name"`
	Readme        string                           `thrift:"Readme,8" form:"readme" json:"readme"`
	Category      *ProductCategory                 `thrift:"Category,9" form:"category" json:"category"`
	// Recommended categories,
	RecommendedCategory *ProductCategory    `thrift:"RecommendedCategory,10,optional" form:"recommended_category" json:"recommended_category,omitempty"`
	Nodes               []*WorkflowNodeInfo `thrift:"Nodes,11,optional" form:"nodes" json:"nodes,omitempty"`
	Desc                string              `thrift:"Desc,12" form:"desc" json:"desc"`
	// Imported parameters Picture icon
	CaseInputIconURL *string `thrift:"CaseInputIconURL,13,optional" form:"case_input_icon_url" json:"case_input_icon_url,omitempty"`
	// Exported parameters Image icon
	CaseOutputIconURL     *string `thrift:"CaseOutputIconURL,14,optional" form:"case_output_icon_url" json:"case_output_icon_url,omitempty"`
	LatestPublishCommitID *string `thrift:"LatestPublishCommitID,15,optional" form:"latest_publish_commit_id" json:"latest_publish_commit_id,omitempty"`
}

func NewWorkflowEntity() *WorkflowEntity {
	return &WorkflowEntity{}
}

func (p *WorkflowEntity) InitDefault() {
}

func (p *WorkflowEntity) GetProductID() (v int64) {
	return p.ProductID
}

func (p *WorkflowEntity) GetName() (v string) {
	return p.Name
}

func (p *WorkflowEntity) GetEntityID() (v int64) {
	return p.EntityID
}

func (p *WorkflowEntity) GetEntityType() (v product_common.ProductEntityType) {
	return p.EntityType
}

func (p *WorkflowEntity) GetEntityVersion() (v int64) {
	return p.EntityVersion
}

func (p *WorkflowEntity) GetIconURL() (v string) {
	return p.IconURL
}

func (p *WorkflowEntity) GetEntityName() (v string) {
	return p.EntityName
}

func (p *WorkflowEntity) GetReadme() (v string) {
	return p.Readme
}

var WorkflowEntity_Category_DEFAULT *ProductCategory

func (p *WorkflowEntity) GetCategory() (v *ProductCategory) {
	if !p.IsSetCategory() {
		return WorkflowEntity_Category_DEFAULT
	}
	return p.Category
}

var WorkflowEntity_RecommendedCategory_DEFAULT *ProductCategory

func (p *WorkflowEntity) GetRecommendedCategory() (v *ProductCategory) {
	if !p.IsSetRecommendedCategory() {
		return WorkflowEntity_RecommendedCategory_DEFAULT
	}
	return p.RecommendedCategory
}

var WorkflowEntity_Nodes_DEFAULT []*WorkflowNodeInfo

func (p *WorkflowEntity) GetNodes() (v []*WorkflowNodeInfo) {
	if !p.IsSetNodes() {
		return WorkflowEntity_Nodes_DEFAULT
	}
	return p.Nodes
}

func (p *WorkflowEntity) GetDesc() (v string) {
	return p.Desc
}

var WorkflowEntity_CaseInputIconURL_DEFAULT string

func (p *WorkflowEntity) GetCaseInputIconURL() (v string) {
	if !p.IsSetCaseInputIconURL() {
		return WorkflowEntity_CaseInputIconURL_DEFAULT
	}
	return *p.CaseInputIconURL
}

var WorkflowEntity_CaseOutputIconURL_DEFAULT string

func (p *WorkflowEntity) GetCaseOutputIconURL() (v string) {
	if !p.IsSetCaseOutputIconURL() {
		return WorkflowEntity_CaseOutputIconURL_DEFAULT
	}
	return *p.CaseOutputIconURL
}

var WorkflowEntity_LatestPublishCommitID_DEFAULT string

func (p *WorkflowEntity) GetLatestPublishCommitID() (v string) {
	if !p.IsSetLatestPublishCommitID() {
		return WorkflowEntity_LatestPublishCommitID_DEFAULT
	}
	return *p.LatestPublishCommitID
}

var fieldIDToName_WorkflowEntity = map[int16]string{
	1:  "ProductID",
	2:  "Name",
	3:  "EntityID",
	4:  "EntityType",
	5:  "EntityVersion",
	6:  "IconURL",
	7:  "EntityName",
	8:  "Readme",
	9:  "Category",
	10: "RecommendedCategory",
	11: "Nodes",
	12: "Desc",
	13: "CaseInputIconURL",
	14: "CaseOutputIconURL",
	15: "LatestPublishCommitID",
}

func (p *WorkflowEntity) IsSetCategory() bool {
	return p.Category != nil
}

func (p *WorkflowEntity) IsSetRecommendedCategory() bool {
	return p.RecommendedCategory != nil
}

func (p *WorkflowEntity) IsSetNodes() bool {
	return p.Nodes != nil
}

func (p *WorkflowEntity) IsSetCaseInputIconURL() bool {
	return p.CaseInputIconURL != nil
}

func (p *WorkflowEntity) IsSetCaseOutputIconURL() bool {
	return p.CaseOutputIconURL != nil
}

func (p *WorkflowEntity) IsSetLatestPublishCommitID() bool {
	return p.LatestPublishCommitID != nil
}

func (p *WorkflowEntity) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowEntity[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowEntity) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ProductID = _field
	return nil
}
func (p *WorkflowEntity) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *WorkflowEntity) ReadField3(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.EntityID = _field
	return nil
}
func (p *WorkflowEntity) ReadField4(iprot thrift.TProtocol) error {

	var _field product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductEntityType(v)
	}
	p.EntityType = _field
	return nil
}
func (p *WorkflowEntity) ReadField5(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.EntityVersion = _field
	return nil
}
func (p *WorkflowEntity) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *WorkflowEntity) ReadField7(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.EntityName = _field
	return nil
}
func (p *WorkflowEntity) ReadField8(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Readme = _field
	return nil
}
func (p *WorkflowEntity) ReadField9(iprot thrift.TProtocol) error {
	_field := NewProductCategory()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Category = _field
	return nil
}
func (p *WorkflowEntity) ReadField10(iprot thrift.TProtocol) error {
	_field := NewProductCategory()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.RecommendedCategory = _field
	return nil
}
func (p *WorkflowEntity) ReadField11(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowNodeInfo, 0, size)
	values := make([]WorkflowNodeInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Nodes = _field
	return nil
}
func (p *WorkflowEntity) ReadField12(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *WorkflowEntity) ReadField13(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CaseInputIconURL = _field
	return nil
}
func (p *WorkflowEntity) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CaseOutputIconURL = _field
	return nil
}
func (p *WorkflowEntity) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.LatestPublishCommitID = _field
	return nil
}

func (p *WorkflowEntity) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowEntity"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowEntity) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ProductID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ProductID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowEntity) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowEntity) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityID", thrift.I64, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.EntityID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkflowEntity) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityType", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.EntityType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkflowEntity) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityVersion", thrift.I64, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.EntityVersion); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WorkflowEntity) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IconURL", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *WorkflowEntity) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityName", thrift.STRING, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.EntityName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *WorkflowEntity) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Readme", thrift.STRING, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Readme); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *WorkflowEntity) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Category", thrift.STRUCT, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Category.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *WorkflowEntity) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetRecommendedCategory() {
		if err = oprot.WriteFieldBegin("RecommendedCategory", thrift.STRUCT, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.RecommendedCategory.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *WorkflowEntity) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetNodes() {
		if err = oprot.WriteFieldBegin("Nodes", thrift.LIST, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Nodes)); err != nil {
			return err
		}
		for _, v := range p.Nodes {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *WorkflowEntity) writeField12(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Desc", thrift.STRING, 12); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *WorkflowEntity) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetCaseInputIconURL() {
		if err = oprot.WriteFieldBegin("CaseInputIconURL", thrift.STRING, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CaseInputIconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *WorkflowEntity) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetCaseOutputIconURL() {
		if err = oprot.WriteFieldBegin("CaseOutputIconURL", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CaseOutputIconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *WorkflowEntity) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetLatestPublishCommitID() {
		if err = oprot.WriteFieldBegin("LatestPublishCommitID", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.LatestPublishCommitID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}

func (p *WorkflowEntity) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowEntity(%+v)", *p)

}

type WorkflowGUIConfig struct {
	// Used to convert the input/output/intermediate message node of a workflow into a user visual configuration
	StartNode *WorkflowNodeInfo `thrift:"StartNode,1" form:"start_node" json:"start_node"`
	EndNode   *WorkflowNodeInfo `thrift:"EndNode,2" form:"end_node" json:"end_node"`
	// The message node will output the intermediate process, which also needs to be displayed.
	MessageNodes []*WorkflowNodeInfo `thrift:"MessageNodes,3,optional" form:"message_nodes" json:"message_nodes,omitempty"`
}

func NewWorkflowGUIConfig() *WorkflowGUIConfig {
	return &WorkflowGUIConfig{}
}

func (p *WorkflowGUIConfig) InitDefault() {
}

var WorkflowGUIConfig_StartNode_DEFAULT *WorkflowNodeInfo

func (p *WorkflowGUIConfig) GetStartNode() (v *WorkflowNodeInfo) {
	if !p.IsSetStartNode() {
		return WorkflowGUIConfig_StartNode_DEFAULT
	}
	return p.StartNode
}

var WorkflowGUIConfig_EndNode_DEFAULT *WorkflowNodeInfo

func (p *WorkflowGUIConfig) GetEndNode() (v *WorkflowNodeInfo) {
	if !p.IsSetEndNode() {
		return WorkflowGUIConfig_EndNode_DEFAULT
	}
	return p.EndNode
}

var WorkflowGUIConfig_MessageNodes_DEFAULT []*WorkflowNodeInfo

func (p *WorkflowGUIConfig) GetMessageNodes() (v []*WorkflowNodeInfo) {
	if !p.IsSetMessageNodes() {
		return WorkflowGUIConfig_MessageNodes_DEFAULT
	}
	return p.MessageNodes
}

var fieldIDToName_WorkflowGUIConfig = map[int16]string{
	1: "StartNode",
	2: "EndNode",
	3: "MessageNodes",
}

func (p *WorkflowGUIConfig) IsSetStartNode() bool {
	return p.StartNode != nil
}

func (p *WorkflowGUIConfig) IsSetEndNode() bool {
	return p.EndNode != nil
}

func (p *WorkflowGUIConfig) IsSetMessageNodes() bool {
	return p.MessageNodes != nil
}

func (p *WorkflowGUIConfig) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowGUIConfig[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowGUIConfig) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkflowNodeInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.StartNode = _field
	return nil
}
func (p *WorkflowGUIConfig) ReadField2(iprot thrift.TProtocol) error {
	_field := NewWorkflowNodeInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.EndNode = _field
	return nil
}
func (p *WorkflowGUIConfig) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowNodeInfo, 0, size)
	values := make([]WorkflowNodeInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.MessageNodes = _field
	return nil
}

func (p *WorkflowGUIConfig) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowGUIConfig"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowGUIConfig) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("StartNode", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.StartNode.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowGUIConfig) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EndNode", thrift.STRUCT, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.EndNode.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowGUIConfig) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetMessageNodes() {
		if err = oprot.WriteFieldBegin("MessageNodes", thrift.LIST, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.MessageNodes)); err != nil {
			return err
		}
		for _, v := range p.MessageNodes {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *WorkflowGUIConfig) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowGUIConfig(%+v)", *p)

}

type WorkflowExtraInfo struct {
	RelatedWorkflows []*WorkflowEntity `thrift:"RelatedWorkflows,1" form:"related_workflows" json:"related_workflows"`
	DuplicateCount   *int32            `thrift:"DuplicateCount,2,optional" form:"duplicate_count" json:"duplicate_count,omitempty"`
	// Workflow canvas information
	WorkflowSchema *string `thrift:"WorkflowSchema,3,optional" form:"workflow_schema" json:"workflow_schema,omitempty"`
	// /api/workflowV2/query  schema_json
	RecommendedCategory *ProductCategory    `thrift:"RecommendedCategory,4,optional" form:"recommended_category" json:"recommended_category,omitempty"`
	Nodes               []*WorkflowNodeInfo `thrift:"Nodes,5,optional" form:"nodes" json:"nodes,omitempty"`
	StartNode           *WorkflowNodeInfo   `thrift:"StartNode,6,optional" form:"start_node" json:"start_node,omitempty"`
	// Entity name (for presentation)
	EntityName *string `thrift:"EntityName,7,optional" form:"entity_name" json:"entity_name,omitempty"`
	// Use case diagrams imported parameters
	CaseInputIconURL *string `thrift:"CaseInputIconURL,8,optional" form:"case_input_icon_url" json:"case_input_icon_url,omitempty"`
	// Use case diagram exported parameters
	CaseOutputIconURL *string `thrift:"CaseOutputIconURL,9,optional" form:"case_output_icon_url" json:"case_output_icon_url,omitempty"`
	// case execution ID
	CaseExecuteID         *int64  `thrift:"CaseExecuteID,10,optional" form:"case_execute_id" json:"case_execute_id,string,omitempty"`
	HoverText             *string `thrift:"HoverText,11,optional" form:"hover_text" json:"hover_text,omitempty"`
	LatestPublishCommitID *string `thrift:"LatestPublishCommitID,12,optional" form:"latest_publish_commit_id" json:"latest_publish_commit_id,omitempty"`
	// Practice running times, take from the number of warehouses
	UsedCount *int32 `thrift:"UsedCount,13,optional" form:"used_count" json:"used_count,omitempty"`
	// Used to convert the input/output/intermediate message node of a workflow into a user visual configuration
	GUIConfig *WorkflowGUIConfig `thrift:"GUIConfig,14,optional" form:"gui_config" json:"gui_config,omitempty"`
}

func NewWorkflowExtraInfo() *WorkflowExtraInfo {
	return &WorkflowExtraInfo{}
}

func (p *WorkflowExtraInfo) InitDefault() {
}

func (p *WorkflowExtraInfo) GetRelatedWorkflows() (v []*WorkflowEntity) {
	return p.RelatedWorkflows
}

var WorkflowExtraInfo_DuplicateCount_DEFAULT int32

func (p *WorkflowExtraInfo) GetDuplicateCount() (v int32) {
	if !p.IsSetDuplicateCount() {
		return WorkflowExtraInfo_DuplicateCount_DEFAULT
	}
	return *p.DuplicateCount
}

var WorkflowExtraInfo_WorkflowSchema_DEFAULT string

func (p *WorkflowExtraInfo) GetWorkflowSchema() (v string) {
	if !p.IsSetWorkflowSchema() {
		return WorkflowExtraInfo_WorkflowSchema_DEFAULT
	}
	return *p.WorkflowSchema
}

var WorkflowExtraInfo_RecommendedCategory_DEFAULT *ProductCategory

func (p *WorkflowExtraInfo) GetRecommendedCategory() (v *ProductCategory) {
	if !p.IsSetRecommendedCategory() {
		return WorkflowExtraInfo_RecommendedCategory_DEFAULT
	}
	return p.RecommendedCategory
}

var WorkflowExtraInfo_Nodes_DEFAULT []*WorkflowNodeInfo

func (p *WorkflowExtraInfo) GetNodes() (v []*WorkflowNodeInfo) {
	if !p.IsSetNodes() {
		return WorkflowExtraInfo_Nodes_DEFAULT
	}
	return p.Nodes
}

var WorkflowExtraInfo_StartNode_DEFAULT *WorkflowNodeInfo

func (p *WorkflowExtraInfo) GetStartNode() (v *WorkflowNodeInfo) {
	if !p.IsSetStartNode() {
		return WorkflowExtraInfo_StartNode_DEFAULT
	}
	return p.StartNode
}

var WorkflowExtraInfo_EntityName_DEFAULT string

func (p *WorkflowExtraInfo) GetEntityName() (v string) {
	if !p.IsSetEntityName() {
		return WorkflowExtraInfo_EntityName_DEFAULT
	}
	return *p.EntityName
}

var WorkflowExtraInfo_CaseInputIconURL_DEFAULT string

func (p *WorkflowExtraInfo) GetCaseInputIconURL() (v string) {
	if !p.IsSetCaseInputIconURL() {
		return WorkflowExtraInfo_CaseInputIconURL_DEFAULT
	}
	return *p.CaseInputIconURL
}

var WorkflowExtraInfo_CaseOutputIconURL_DEFAULT string

func (p *WorkflowExtraInfo) GetCaseOutputIconURL() (v string) {
	if !p.IsSetCaseOutputIconURL() {
		return WorkflowExtraInfo_CaseOutputIconURL_DEFAULT
	}
	return *p.CaseOutputIconURL
}

var WorkflowExtraInfo_CaseExecuteID_DEFAULT int64

func (p *WorkflowExtraInfo) GetCaseExecuteID() (v int64) {
	if !p.IsSetCaseExecuteID() {
		return WorkflowExtraInfo_CaseExecuteID_DEFAULT
	}
	return *p.CaseExecuteID
}

var WorkflowExtraInfo_HoverText_DEFAULT string

func (p *WorkflowExtraInfo) GetHoverText() (v string) {
	if !p.IsSetHoverText() {
		return WorkflowExtraInfo_HoverText_DEFAULT
	}
	return *p.HoverText
}

var WorkflowExtraInfo_LatestPublishCommitID_DEFAULT string

func (p *WorkflowExtraInfo) GetLatestPublishCommitID() (v string) {
	if !p.IsSetLatestPublishCommitID() {
		return WorkflowExtraInfo_LatestPublishCommitID_DEFAULT
	}
	return *p.LatestPublishCommitID
}

var WorkflowExtraInfo_UsedCount_DEFAULT int32

func (p *WorkflowExtraInfo) GetUsedCount() (v int32) {
	if !p.IsSetUsedCount() {
		return WorkflowExtraInfo_UsedCount_DEFAULT
	}
	return *p.UsedCount
}

var WorkflowExtraInfo_GUIConfig_DEFAULT *WorkflowGUIConfig

func (p *WorkflowExtraInfo) GetGUIConfig() (v *WorkflowGUIConfig) {
	if !p.IsSetGUIConfig() {
		return WorkflowExtraInfo_GUIConfig_DEFAULT
	}
	return p.GUIConfig
}

var fieldIDToName_WorkflowExtraInfo = map[int16]string{
	1:  "RelatedWorkflows",
	2:  "DuplicateCount",
	3:  "WorkflowSchema",
	4:  "RecommendedCategory",
	5:  "Nodes",
	6:  "StartNode",
	7:  "EntityName",
	8:  "CaseInputIconURL",
	9:  "CaseOutputIconURL",
	10: "CaseExecuteID",
	11: "HoverText",
	12: "LatestPublishCommitID",
	13: "UsedCount",
	14: "GUIConfig",
}

func (p *WorkflowExtraInfo) IsSetDuplicateCount() bool {
	return p.DuplicateCount != nil
}

func (p *WorkflowExtraInfo) IsSetWorkflowSchema() bool {
	return p.WorkflowSchema != nil
}

func (p *WorkflowExtraInfo) IsSetRecommendedCategory() bool {
	return p.RecommendedCategory != nil
}

func (p *WorkflowExtraInfo) IsSetNodes() bool {
	return p.Nodes != nil
}

func (p *WorkflowExtraInfo) IsSetStartNode() bool {
	return p.StartNode != nil
}

func (p *WorkflowExtraInfo) IsSetEntityName() bool {
	return p.EntityName != nil
}

func (p *WorkflowExtraInfo) IsSetCaseInputIconURL() bool {
	return p.CaseInputIconURL != nil
}

func (p *WorkflowExtraInfo) IsSetCaseOutputIconURL() bool {
	return p.CaseOutputIconURL != nil
}

func (p *WorkflowExtraInfo) IsSetCaseExecuteID() bool {
	return p.CaseExecuteID != nil
}

func (p *WorkflowExtraInfo) IsSetHoverText() bool {
	return p.HoverText != nil
}

func (p *WorkflowExtraInfo) IsSetLatestPublishCommitID() bool {
	return p.LatestPublishCommitID != nil
}

func (p *WorkflowExtraInfo) IsSetUsedCount() bool {
	return p.UsedCount != nil
}

func (p *WorkflowExtraInfo) IsSetGUIConfig() bool {
	return p.GUIConfig != nil
}

func (p *WorkflowExtraInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowExtraInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowExtraInfo) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowEntity, 0, size)
	values := make([]WorkflowEntity, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.RelatedWorkflows = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.DuplicateCount = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.WorkflowSchema = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField4(iprot thrift.TProtocol) error {
	_field := NewProductCategory()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.RecommendedCategory = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField5(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowNodeInfo, 0, size)
	values := make([]WorkflowNodeInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Nodes = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField6(iprot thrift.TProtocol) error {
	_field := NewWorkflowNodeInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.StartNode = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EntityName = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CaseInputIconURL = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CaseOutputIconURL = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CaseExecuteID = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField11(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HoverText = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField12(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.LatestPublishCommitID = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField13(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.UsedCount = _field
	return nil
}
func (p *WorkflowExtraInfo) ReadField14(iprot thrift.TProtocol) error {
	_field := NewWorkflowGUIConfig()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.GUIConfig = _field
	return nil
}

func (p *WorkflowExtraInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowExtraInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowExtraInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("RelatedWorkflows", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.RelatedWorkflows)); err != nil {
		return err
	}
	for _, v := range p.RelatedWorkflows {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetDuplicateCount() {
		if err = oprot.WriteFieldBegin("DuplicateCount", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.DuplicateCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowSchema() {
		if err = oprot.WriteFieldBegin("WorkflowSchema", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.WorkflowSchema); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetRecommendedCategory() {
		if err = oprot.WriteFieldBegin("RecommendedCategory", thrift.STRUCT, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.RecommendedCategory.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetNodes() {
		if err = oprot.WriteFieldBegin("Nodes", thrift.LIST, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Nodes)); err != nil {
			return err
		}
		for _, v := range p.Nodes {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetStartNode() {
		if err = oprot.WriteFieldBegin("StartNode", thrift.STRUCT, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.StartNode.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityName() {
		if err = oprot.WriteFieldBegin("EntityName", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.EntityName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetCaseInputIconURL() {
		if err = oprot.WriteFieldBegin("CaseInputIconURL", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CaseInputIconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetCaseOutputIconURL() {
		if err = oprot.WriteFieldBegin("CaseOutputIconURL", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CaseOutputIconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetCaseExecuteID() {
		if err = oprot.WriteFieldBegin("CaseExecuteID", thrift.I64, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.CaseExecuteID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetHoverText() {
		if err = oprot.WriteFieldBegin("HoverText", thrift.STRING, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.HoverText); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetLatestPublishCommitID() {
		if err = oprot.WriteFieldBegin("LatestPublishCommitID", thrift.STRING, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.LatestPublishCommitID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetUsedCount() {
		if err = oprot.WriteFieldBegin("UsedCount", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.UsedCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *WorkflowExtraInfo) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetGUIConfig() {
		if err = oprot.WriteFieldBegin("GUIConfig", thrift.STRUCT, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.GUIConfig.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}

func (p *WorkflowExtraInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowExtraInfo(%+v)", *p)

}

type SocialScenePlayerInfo struct {
	ID       int64                              `thrift:"ID,1" form:"id" json:"id,string"`
	Name     string                             `thrift:"Name,2" form:"name" json:"name"`
	RoleType product_common.SocialSceneRoleType `thrift:"RoleType,3" form:"role_type" json:"role_type"`
}

func NewSocialScenePlayerInfo() *SocialScenePlayerInfo {
	return &SocialScenePlayerInfo{}
}

func (p *SocialScenePlayerInfo) InitDefault() {
}

func (p *SocialScenePlayerInfo) GetID() (v int64) {
	return p.ID
}

func (p *SocialScenePlayerInfo) GetName() (v string) {
	return p.Name
}

func (p *SocialScenePlayerInfo) GetRoleType() (v product_common.SocialSceneRoleType) {
	return p.RoleType
}

var fieldIDToName_SocialScenePlayerInfo = map[int16]string{
	1: "ID",
	2: "Name",
	3: "RoleType",
}

func (p *SocialScenePlayerInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SocialScenePlayerInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SocialScenePlayerInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *SocialScenePlayerInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *SocialScenePlayerInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field product_common.SocialSceneRoleType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.SocialSceneRoleType(v)
	}
	p.RoleType = _field
	return nil
}

func (p *SocialScenePlayerInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SocialScenePlayerInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SocialScenePlayerInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SocialScenePlayerInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SocialScenePlayerInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("RoleType", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.RoleType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *SocialScenePlayerInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SocialScenePlayerInfo(%+v)", *p)

}

type SocialSceneExtraInfo struct {
	// role
	Players []*SocialScenePlayerInfo `thrift:"Players,1,optional" form:"players" json:"players,omitempty"`
	// Number of people used
	UsedCount int64 `thrift:"UsedCount,2" form:"used_count" json:"used_count,string"`
	// number of times started
	StartedCount int64 `thrift:"StartedCount,3" form:"started_count" json:"started_count,string"`
	// publish_mode
	PublishMode product_common.ProductPublishMode `thrift:"PublishMode,4" form:"publish_mode" json:"publish_mode"`
}

func NewSocialSceneExtraInfo() *SocialSceneExtraInfo {
	return &SocialSceneExtraInfo{}
}

func (p *SocialSceneExtraInfo) InitDefault() {
}

var SocialSceneExtraInfo_Players_DEFAULT []*SocialScenePlayerInfo

func (p *SocialSceneExtraInfo) GetPlayers() (v []*SocialScenePlayerInfo) {
	if !p.IsSetPlayers() {
		return SocialSceneExtraInfo_Players_DEFAULT
	}
	return p.Players
}

func (p *SocialSceneExtraInfo) GetUsedCount() (v int64) {
	return p.UsedCount
}

func (p *SocialSceneExtraInfo) GetStartedCount() (v int64) {
	return p.StartedCount
}

func (p *SocialSceneExtraInfo) GetPublishMode() (v product_common.ProductPublishMode) {
	return p.PublishMode
}

var fieldIDToName_SocialSceneExtraInfo = map[int16]string{
	1: "Players",
	2: "UsedCount",
	3: "StartedCount",
	4: "PublishMode",
}

func (p *SocialSceneExtraInfo) IsSetPlayers() bool {
	return p.Players != nil
}

func (p *SocialSceneExtraInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SocialSceneExtraInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SocialSceneExtraInfo) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*SocialScenePlayerInfo, 0, size)
	values := make([]SocialScenePlayerInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Players = _field
	return nil
}
func (p *SocialSceneExtraInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UsedCount = _field
	return nil
}
func (p *SocialSceneExtraInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.StartedCount = _field
	return nil
}
func (p *SocialSceneExtraInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field product_common.ProductPublishMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductPublishMode(v)
	}
	p.PublishMode = _field
	return nil
}

func (p *SocialSceneExtraInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SocialSceneExtraInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SocialSceneExtraInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPlayers() {
		if err = oprot.WriteFieldBegin("Players", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Players)); err != nil {
			return err
		}
		for _, v := range p.Players {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SocialSceneExtraInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("UsedCount", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.UsedCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SocialSceneExtraInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("StartedCount", thrift.I64, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.StartedCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *SocialSceneExtraInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PublishMode", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.PublishMode)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *SocialSceneExtraInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SocialSceneExtraInfo(%+v)", *p)

}

type ProjectConfig struct {
	// number of plugins
	PluginCount int32 `thrift:"PluginCount,1" form:"plugin_count" json:"plugin_count"`
	// number of workflows
	WorkflowCount int32 `thrift:"WorkflowCount,2" form:"workflow_count" json:"workflow_count"`
	// Number of knowledge bases
	KnowledgeCount int32 `thrift:"KnowledgeCount,3" form:"knowledge_count" json:"knowledge_count"`
	// Number of databases
	DatabaseCount int32 `thrift:"DatabaseCount,4" form:"database_count" json:"database_count"`
}

func NewProjectConfig() *ProjectConfig {
	return &ProjectConfig{}
}

func (p *ProjectConfig) InitDefault() {
}

func (p *ProjectConfig) GetPluginCount() (v int32) {
	return p.PluginCount
}

func (p *ProjectConfig) GetWorkflowCount() (v int32) {
	return p.WorkflowCount
}

func (p *ProjectConfig) GetKnowledgeCount() (v int32) {
	return p.KnowledgeCount
}

func (p *ProjectConfig) GetDatabaseCount() (v int32) {
	return p.DatabaseCount
}

var fieldIDToName_ProjectConfig = map[int16]string{
	1: "PluginCount",
	2: "WorkflowCount",
	3: "KnowledgeCount",
	4: "DatabaseCount",
}

func (p *ProjectConfig) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProjectConfig[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ProjectConfig) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginCount = _field
	return nil
}
func (p *ProjectConfig) ReadField2(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowCount = _field
	return nil
}
func (p *ProjectConfig) ReadField3(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.KnowledgeCount = _field
	return nil
}
func (p *ProjectConfig) ReadField4(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DatabaseCount = _field
	return nil
}

func (p *ProjectConfig) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProjectConfig"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProjectConfig) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PluginCount", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.PluginCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ProjectConfig) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("WorkflowCount", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.WorkflowCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ProjectConfig) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("KnowledgeCount", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.KnowledgeCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ProjectConfig) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("DatabaseCount", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.DatabaseCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *ProjectConfig) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProjectConfig(%+v)", *p)

}

type ProjectExtraInfo struct {
	// Generate a copy of the template before Project is put on the shelves. To use or copy the template, you need to use TemplateProjectID and TemplateProjectVersion
	TemplateProjectID      int64 `thrift:"TemplateProjectID,1" form:"template_project_id" json:"template_project_id,string"`
	TemplateProjectVersion int64 `thrift:"TemplateProjectVersion,2" form:"template_project_version" json:"template_project_version,string"`
	// Project-bound UI supported preview types
	PreviewTypes []product_common.UIPreviewType `thrift:"PreviewTypes,3" form:"preview_types" json:"preview_types"`
	// user count
	UserCount int32 `thrift:"UserCount,4" form:"user_count" json:"user_count"`
	// number of runs
	ExecuteCount int32 `thrift:"ExecuteCount,5" form:"execute_count" json:"execute_count"`
	// publish platforms
	PublishPlatforms []*BotPublishPlatform `thrift:"PublishPlatforms,6" form:"publish_platforms" json:"publish_platforms"`
	// Near real-time copy volume, obtained from the data warehouse interface (copy-report event tracking-data warehouse calculation drop library)
	DupliacateCount int32 `thrift:"DupliacateCount,7" form:"duplicate_count" json:"duplicate_count"`
	// configuration
	Config *ProjectConfig `thrift:"Config,8,optional" form:"config" json:"config,omitempty"`
}

func NewProjectExtraInfo() *ProjectExtraInfo {
	return &ProjectExtraInfo{}
}

func (p *ProjectExtraInfo) InitDefault() {
}

func (p *ProjectExtraInfo) GetTemplateProjectID() (v int64) {
	return p.TemplateProjectID
}

func (p *ProjectExtraInfo) GetTemplateProjectVersion() (v int64) {
	return p.TemplateProjectVersion
}

func (p *ProjectExtraInfo) GetPreviewTypes() (v []product_common.UIPreviewType) {
	return p.PreviewTypes
}

func (p *ProjectExtraInfo) GetUserCount() (v int32) {
	return p.UserCount
}

func (p *ProjectExtraInfo) GetExecuteCount() (v int32) {
	return p.ExecuteCount
}

func (p *ProjectExtraInfo) GetPublishPlatforms() (v []*BotPublishPlatform) {
	return p.PublishPlatforms
}

func (p *ProjectExtraInfo) GetDupliacateCount() (v int32) {
	return p.DupliacateCount
}

var ProjectExtraInfo_Config_DEFAULT *ProjectConfig

func (p *ProjectExtraInfo) GetConfig() (v *ProjectConfig) {
	if !p.IsSetConfig() {
		return ProjectExtraInfo_Config_DEFAULT
	}
	return p.Config
}

var fieldIDToName_ProjectExtraInfo = map[int16]string{
	1: "TemplateProjectID",
	2: "TemplateProjectVersion",
	3: "PreviewTypes",
	4: "UserCount",
	5: "ExecuteCount",
	6: "PublishPlatforms",
	7: "DupliacateCount",
	8: "Config",
}

func (p *ProjectExtraInfo) IsSetConfig() bool {
	return p.Config != nil
}

func (p *ProjectExtraInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProjectExtraInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ProjectExtraInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TemplateProjectID = _field
	return nil
}
func (p *ProjectExtraInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TemplateProjectVersion = _field
	return nil
}
func (p *ProjectExtraInfo) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]product_common.UIPreviewType, 0, size)
	for i := 0; i < size; i++ {

		var _elem product_common.UIPreviewType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_elem = product_common.UIPreviewType(v)
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.PreviewTypes = _field
	return nil
}
func (p *ProjectExtraInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserCount = _field
	return nil
}
func (p *ProjectExtraInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ExecuteCount = _field
	return nil
}
func (p *ProjectExtraInfo) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*BotPublishPlatform, 0, size)
	values := make([]BotPublishPlatform, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.PublishPlatforms = _field
	return nil
}
func (p *ProjectExtraInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DupliacateCount = _field
	return nil
}
func (p *ProjectExtraInfo) ReadField8(iprot thrift.TProtocol) error {
	_field := NewProjectConfig()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Config = _field
	return nil
}

func (p *ProjectExtraInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProjectExtraInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProjectExtraInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("TemplateProjectID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.TemplateProjectID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ProjectExtraInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("TemplateProjectVersion", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.TemplateProjectVersion); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ProjectExtraInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PreviewTypes", thrift.LIST, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.I32, len(p.PreviewTypes)); err != nil {
		return err
	}
	for _, v := range p.PreviewTypes {
		if err := oprot.WriteI32(int32(v)); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ProjectExtraInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("UserCount", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.UserCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ProjectExtraInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ExecuteCount", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.ExecuteCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ProjectExtraInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PublishPlatforms", thrift.LIST, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.PublishPlatforms)); err != nil {
		return err
	}
	for _, v := range p.PublishPlatforms {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *ProjectExtraInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("DupliacateCount", thrift.I32, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.DupliacateCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *ProjectExtraInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetConfig() {
		if err = oprot.WriteFieldBegin("Config", thrift.STRUCT, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Config.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}

func (p *ProjectExtraInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProjectExtraInfo(%+v)", *p)

}

type GetProductDetailRequest struct {
	ProductID  *int64                            `thrift:"ProductID,1,optional" json:"ProductID,string,omitempty" query:"product_id"`
	EntityType *product_common.ProductEntityType `thrift:"EntityType,2,optional" form:"entity_type" json:"entity_type,omitempty"`
	EntityID   *int64                            `thrift:"EntityID,3,optional" json:"EntityID,string,omitempty" query:"entity_id"`
	// Whether to check the latest audit failure draft
	NeedAuditFailed *bool      `thrift:"NeedAuditFailed,4,optional" form:"need_audit_failed" json:"need_audit_failed,omitempty"`
	ClientIP        *string    `thrift:"ClientIP,101,optional" header:"Tt-Agw-Client-Ip" json:"ClientIP,omitempty"`
	Base            *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetProductDetailRequest() *GetProductDetailRequest {
	return &GetProductDetailRequest{}
}

func (p *GetProductDetailRequest) InitDefault() {
}

var GetProductDetailRequest_ProductID_DEFAULT int64

func (p *GetProductDetailRequest) GetProductID() (v int64) {
	if !p.IsSetProductID() {
		return GetProductDetailRequest_ProductID_DEFAULT
	}
	return *p.ProductID
}

var GetProductDetailRequest_EntityType_DEFAULT product_common.ProductEntityType

func (p *GetProductDetailRequest) GetEntityType() (v product_common.ProductEntityType) {
	if !p.IsSetEntityType() {
		return GetProductDetailRequest_EntityType_DEFAULT
	}
	return *p.EntityType
}

var GetProductDetailRequest_EntityID_DEFAULT int64

func (p *GetProductDetailRequest) GetEntityID() (v int64) {
	if !p.IsSetEntityID() {
		return GetProductDetailRequest_EntityID_DEFAULT
	}
	return *p.EntityID
}

var GetProductDetailRequest_NeedAuditFailed_DEFAULT bool

func (p *GetProductDetailRequest) GetNeedAuditFailed() (v bool) {
	if !p.IsSetNeedAuditFailed() {
		return GetProductDetailRequest_NeedAuditFailed_DEFAULT
	}
	return *p.NeedAuditFailed
}

var GetProductDetailRequest_ClientIP_DEFAULT string

func (p *GetProductDetailRequest) GetClientIP() (v string) {
	if !p.IsSetClientIP() {
		return GetProductDetailRequest_ClientIP_DEFAULT
	}
	return *p.ClientIP
}

var GetProductDetailRequest_Base_DEFAULT *base.Base

func (p *GetProductDetailRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetProductDetailRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetProductDetailRequest = map[int16]string{
	1:   "ProductID",
	2:   "EntityType",
	3:   "EntityID",
	4:   "NeedAuditFailed",
	101: "ClientIP",
	255: "Base",
}

func (p *GetProductDetailRequest) IsSetProductID() bool {
	return p.ProductID != nil
}

func (p *GetProductDetailRequest) IsSetEntityType() bool {
	return p.EntityType != nil
}

func (p *GetProductDetailRequest) IsSetEntityID() bool {
	return p.EntityID != nil
}

func (p *GetProductDetailRequest) IsSetNeedAuditFailed() bool {
	return p.NeedAuditFailed != nil
}

func (p *GetProductDetailRequest) IsSetClientIP() bool {
	return p.ClientIP != nil
}

func (p *GetProductDetailRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetProductDetailRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 101:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField101(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetProductDetailRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetProductDetailRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProductID = _field
	return nil
}
func (p *GetProductDetailRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.ProductEntityType(v)
		_field = &tmp
	}
	p.EntityType = _field
	return nil
}
func (p *GetProductDetailRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EntityID = _field
	return nil
}
func (p *GetProductDetailRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedAuditFailed = _field
	return nil
}
func (p *GetProductDetailRequest) ReadField101(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ClientIP = _field
	return nil
}
func (p *GetProductDetailRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetProductDetailRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetProductDetailRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField101(oprot); err != nil {
			fieldId = 101
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetProductDetailRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetProductID() {
		if err = oprot.WriteFieldBegin("ProductID", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ProductID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetProductDetailRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityType() {
		if err = oprot.WriteFieldBegin("EntityType", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.EntityType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetProductDetailRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityID() {
		if err = oprot.WriteFieldBegin("EntityID", thrift.I64, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.EntityID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetProductDetailRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedAuditFailed() {
		if err = oprot.WriteFieldBegin("NeedAuditFailed", thrift.BOOL, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedAuditFailed); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetProductDetailRequest) writeField101(oprot thrift.TProtocol) (err error) {
	if p.IsSetClientIP() {
		if err = oprot.WriteFieldBegin("ClientIP", thrift.STRING, 101); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ClientIP); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 101 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 101 end error: ", p), err)
}
func (p *GetProductDetailRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetProductDetailRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetProductDetailRequest(%+v)", *p)

}

type GetProductDetailResponse struct {
	Code     int32                 `thrift:"Code,1,required" form:"code,required" json:"code,required"`
	Message  string                `thrift:"Message,2,required" form:"message,required" json:"message,required"`
	Data     *GetProductDetailData `thrift:"Data,3" form:"data" json:"data"`
	BaseResp *base.BaseResp        `thrift:"BaseResp,255,optional" form:"BaseResp" json:"BaseResp,omitempty" query:"BaseResp"`
}

func NewGetProductDetailResponse() *GetProductDetailResponse {
	return &GetProductDetailResponse{}
}

func (p *GetProductDetailResponse) InitDefault() {
}

func (p *GetProductDetailResponse) GetCode() (v int32) {
	return p.Code
}

func (p *GetProductDetailResponse) GetMessage() (v string) {
	return p.Message
}

var GetProductDetailResponse_Data_DEFAULT *GetProductDetailData

func (p *GetProductDetailResponse) GetData() (v *GetProductDetailData) {
	if !p.IsSetData() {
		return GetProductDetailResponse_Data_DEFAULT
	}
	return p.Data
}

var GetProductDetailResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetProductDetailResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetProductDetailResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetProductDetailResponse = map[int16]string{
	1:   "Code",
	2:   "Message",
	3:   "Data",
	255: "BaseResp",
}

func (p *GetProductDetailResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetProductDetailResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetProductDetailResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMessage bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetMessage = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetMessage {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetProductDetailResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetProductDetailResponse[fieldId]))
}

func (p *GetProductDetailResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetProductDetailResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Message = _field
	return nil
}
func (p *GetProductDetailResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetProductDetailData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetProductDetailResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetProductDetailResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetProductDetailResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetProductDetailResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Code", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetProductDetailResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Message", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Message); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetProductDetailResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetProductDetailResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseResp() {
		if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BaseResp.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetProductDetailResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetProductDetailResponse(%+v)", *p)

}

type Price struct {
	Value        int32  `thrift:"Value,1" form:"value" json:"value"`
	Currency     string `thrift:"Currency,2" form:"currency" json:"currency"`
	DisplayPrice string `thrift:"DisplayPrice,3" form:"display_price" json:"display_price"`
}

func NewPrice() *Price {
	return &Price{}
}

func (p *Price) InitDefault() {
}

func (p *Price) GetValue() (v int32) {
	return p.Value
}

func (p *Price) GetCurrency() (v string) {
	return p.Currency
}

func (p *Price) GetDisplayPrice() (v string) {
	return p.DisplayPrice
}

var fieldIDToName_Price = map[int16]string{
	1: "Value",
	2: "Currency",
	3: "DisplayPrice",
}

func (p *Price) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Price[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Price) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Value = _field
	return nil
}
func (p *Price) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Currency = _field
	return nil
}
func (p *Price) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DisplayPrice = _field
	return nil
}

func (p *Price) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Price"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Price) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Value", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Value); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Price) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Currency", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Currency); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Price) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("DisplayPrice", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.DisplayPrice); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *Price) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Price(%+v)", *p)

}

type SKUInfo struct {
	ID int64 `thrift:"ID,1" form:"id" json:"id,string"`
	// to be abandoned
	Price           []*Price                       `thrift:"Price,2" form:"price" json:"price"`
	Description     string                         `thrift:"Description,3" form:"description" json:"description"`
	PriceV2         []*marketplace_common.Price    `thrift:"PriceV2,4" form:"price_v2" json:"price_v2"`
	ChargeInfoExtra *product_common.ChargeSKUExtra `thrift:"ChargeInfoExtra,5,optional" form:"charge_sku_info" json:"charge_sku_info,omitempty"`
}

func NewSKUInfo() *SKUInfo {
	return &SKUInfo{}
}

func (p *SKUInfo) InitDefault() {
}

func (p *SKUInfo) GetID() (v int64) {
	return p.ID
}

func (p *SKUInfo) GetPrice() (v []*Price) {
	return p.Price
}

func (p *SKUInfo) GetDescription() (v string) {
	return p.Description
}

func (p *SKUInfo) GetPriceV2() (v []*marketplace_common.Price) {
	return p.PriceV2
}

var SKUInfo_ChargeInfoExtra_DEFAULT *product_common.ChargeSKUExtra

func (p *SKUInfo) GetChargeInfoExtra() (v *product_common.ChargeSKUExtra) {
	if !p.IsSetChargeInfoExtra() {
		return SKUInfo_ChargeInfoExtra_DEFAULT
	}
	return p.ChargeInfoExtra
}

var fieldIDToName_SKUInfo = map[int16]string{
	1: "ID",
	2: "Price",
	3: "Description",
	4: "PriceV2",
	5: "ChargeInfoExtra",
}

func (p *SKUInfo) IsSetChargeInfoExtra() bool {
	return p.ChargeInfoExtra != nil
}

func (p *SKUInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SKUInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SKUInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *SKUInfo) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Price, 0, size)
	values := make([]Price, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Price = _field
	return nil
}
func (p *SKUInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *SKUInfo) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*marketplace_common.Price, 0, size)
	values := make([]marketplace_common.Price, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.PriceV2 = _field
	return nil
}
func (p *SKUInfo) ReadField5(iprot thrift.TProtocol) error {
	_field := product_common.NewChargeSKUExtra()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ChargeInfoExtra = _field
	return nil
}

func (p *SKUInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SKUInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SKUInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SKUInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Price", thrift.LIST, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Price)); err != nil {
		return err
	}
	for _, v := range p.Price {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SKUInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Description", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *SKUInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PriceV2", thrift.LIST, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.PriceV2)); err != nil {
		return err
	}
	for _, v := range p.PriceV2 {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *SKUInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetChargeInfoExtra() {
		if err = oprot.WriteFieldBegin("ChargeInfoExtra", thrift.STRUCT, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.ChargeInfoExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *SKUInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SKUInfo(%+v)", *p)

}

type SellAttrValue struct {
	ID    int64  `thrift:"ID,1" form:"id" json:"id,string"`
	Value string `thrift:"Value,2" form:"value" json:"value"`
}

func NewSellAttrValue() *SellAttrValue {
	return &SellAttrValue{}
}

func (p *SellAttrValue) InitDefault() {
}

func (p *SellAttrValue) GetID() (v int64) {
	return p.ID
}

func (p *SellAttrValue) GetValue() (v string) {
	return p.Value
}

var fieldIDToName_SellAttrValue = map[int16]string{
	1: "ID",
	2: "Value",
}

func (p *SellAttrValue) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SellAttrValue[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SellAttrValue) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *SellAttrValue) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Value = _field
	return nil
}

func (p *SellAttrValue) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SellAttrValue"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SellAttrValue) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SellAttrValue) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Value", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Value); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *SellAttrValue) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SellAttrValue(%+v)", *p)

}

type SellAttr struct {
	DisplayName string           `thrift:"DisplayName,1" form:"display_name" json:"display_name"`
	Key         string           `thrift:"Key,2" form:"key" json:"key"`
	Values      []*SellAttrValue `thrift:"Values,3" form:"values" json:"values"`
}

func NewSellAttr() *SellAttr {
	return &SellAttr{}
}

func (p *SellAttr) InitDefault() {
}

func (p *SellAttr) GetDisplayName() (v string) {
	return p.DisplayName
}

func (p *SellAttr) GetKey() (v string) {
	return p.Key
}

func (p *SellAttr) GetValues() (v []*SellAttrValue) {
	return p.Values
}

var fieldIDToName_SellAttr = map[int16]string{
	1: "DisplayName",
	2: "Key",
	3: "Values",
}

func (p *SellAttr) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SellAttr[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SellAttr) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DisplayName = _field
	return nil
}
func (p *SellAttr) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Key = _field
	return nil
}
func (p *SellAttr) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*SellAttrValue, 0, size)
	values := make([]SellAttrValue, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Values = _field
	return nil
}

func (p *SellAttr) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SellAttr"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SellAttr) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("DisplayName", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.DisplayName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SellAttr) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Key", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Key); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SellAttr) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Values", thrift.LIST, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Values)); err != nil {
		return err
	}
	for _, v := range p.Values {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *SellAttr) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SellAttr(%+v)", *p)

}

type SellInfo struct {
	SKUs map[int64]*SKUInfo `thrift:"SKUs,1" form:"skus" json:"skus,string"`
	Attr []*SellAttr        `thrift:"Attr,2" form:"attr" json:"attr"`
	// Key is attrkey: attrvalue path, value is skuID
	SKUAttrRef map[string]int64 `thrift:"SKUAttrRef,3" form:"sku_attr_ref" json:"sku_attr_ref,string"`
}

func NewSellInfo() *SellInfo {
	return &SellInfo{}
}

func (p *SellInfo) InitDefault() {
}

func (p *SellInfo) GetSKUs() (v map[int64]*SKUInfo) {
	return p.SKUs
}

func (p *SellInfo) GetAttr() (v []*SellAttr) {
	return p.Attr
}

func (p *SellInfo) GetSKUAttrRef() (v map[string]int64) {
	return p.SKUAttrRef
}

var fieldIDToName_SellInfo = map[int16]string{
	1: "SKUs",
	2: "Attr",
	3: "SKUAttrRef",
}

func (p *SellInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SellInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SellInfo) ReadField1(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*SKUInfo, size)
	values := make([]SKUInfo, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.SKUs = _field
	return nil
}
func (p *SellInfo) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*SellAttr, 0, size)
	values := make([]SellAttr, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Attr = _field
	return nil
}
func (p *SellInfo) ReadField3(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]int64, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		var _val int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_val = v
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.SKUAttrRef = _field
	return nil
}

func (p *SellInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SellInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SellInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("SKUs", thrift.MAP, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.SKUs)); err != nil {
		return err
	}
	for k, v := range p.SKUs {
		if err := oprot.WriteI64(k); err != nil {
			return err
		}
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SellInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Attr", thrift.LIST, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Attr)); err != nil {
		return err
	}
	for _, v := range p.Attr {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SellInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("SKUAttrRef", thrift.MAP, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.I64, len(p.SKUAttrRef)); err != nil {
		return err
	}
	for k, v := range p.SKUAttrRef {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := oprot.WriteI64(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *SellInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SellInfo(%+v)", *p)

}

type Topic struct {
	ID          int64  `thrift:"ID,1" form:"id" json:"id,string"`
	Name        string `thrift:"Name,2" form:"name" json:"name"`
	Description string `thrift:"Description,3" form:"description" json:"description"`
	BannerURL   string `thrift:"BannerURL,4" form:"banner_url" json:"banner_url"`
	// Small background image, front-end priority loading
	BannerURLSmall string `thrift:"BannerURLSmall,5" form:"banner_url_small" json:"banner_url_small"`
	Reason         string `thrift:"Reason,6" form:"reason" json:"reason"`
	// The presentation document provided by the operation is visible to users
	IntroductionURL string `thrift:"IntroductionURL,7" form:"introduction_url" json:"introduction_url"`
	// Does the user collect the topic?
	IsFavorite bool `thrift:"IsFavorite,8" form:"is_favorite" json:"is_favorite"`
}

func NewTopic() *Topic {
	return &Topic{}
}

func (p *Topic) InitDefault() {
}

func (p *Topic) GetID() (v int64) {
	return p.ID
}

func (p *Topic) GetName() (v string) {
	return p.Name
}

func (p *Topic) GetDescription() (v string) {
	return p.Description
}

func (p *Topic) GetBannerURL() (v string) {
	return p.BannerURL
}

func (p *Topic) GetBannerURLSmall() (v string) {
	return p.BannerURLSmall
}

func (p *Topic) GetReason() (v string) {
	return p.Reason
}

func (p *Topic) GetIntroductionURL() (v string) {
	return p.IntroductionURL
}

func (p *Topic) GetIsFavorite() (v bool) {
	return p.IsFavorite
}

var fieldIDToName_Topic = map[int16]string{
	1: "ID",
	2: "Name",
	3: "Description",
	4: "BannerURL",
	5: "BannerURLSmall",
	6: "Reason",
	7: "IntroductionURL",
	8: "IsFavorite",
}

func (p *Topic) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Topic[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Topic) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *Topic) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *Topic) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *Topic) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BannerURL = _field
	return nil
}
func (p *Topic) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BannerURLSmall = _field
	return nil
}
func (p *Topic) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Reason = _field
	return nil
}
func (p *Topic) ReadField7(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IntroductionURL = _field
	return nil
}
func (p *Topic) ReadField8(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsFavorite = _field
	return nil
}

func (p *Topic) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Topic"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Topic) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Topic) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Topic) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Description", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Topic) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BannerURL", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.BannerURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Topic) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BannerURLSmall", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.BannerURLSmall); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Topic) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Reason", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Reason); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *Topic) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IntroductionURL", thrift.STRING, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IntroductionURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *Topic) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsFavorite", thrift.BOOL, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsFavorite); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}

func (p *Topic) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Topic(%+v)", *p)

}

type ProductDataIndicator struct {
	// Data analytics metrics, source number, such as template purchases, replicas, etc
	PurchaseCount *int32 `thrift:"PurchaseCount,1,optional" form:"purchase_count" json:"purchase_count,omitempty"`
}

func NewProductDataIndicator() *ProductDataIndicator {
	return &ProductDataIndicator{}
}

func (p *ProductDataIndicator) InitDefault() {
}

var ProductDataIndicator_PurchaseCount_DEFAULT int32

func (p *ProductDataIndicator) GetPurchaseCount() (v int32) {
	if !p.IsSetPurchaseCount() {
		return ProductDataIndicator_PurchaseCount_DEFAULT
	}
	return *p.PurchaseCount
}

var fieldIDToName_ProductDataIndicator = map[int16]string{
	1: "PurchaseCount",
}

func (p *ProductDataIndicator) IsSetPurchaseCount() bool {
	return p.PurchaseCount != nil
}

func (p *ProductDataIndicator) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ProductDataIndicator[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ProductDataIndicator) ReadField1(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PurchaseCount = _field
	return nil
}

func (p *ProductDataIndicator) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ProductDataIndicator"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ProductDataIndicator) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPurchaseCount() {
		if err = oprot.WriteFieldBegin("PurchaseCount", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.PurchaseCount); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *ProductDataIndicator) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ProductDataIndicator(%+v)", *p)

}

type GetProductDetailData struct {
	// Products removed from the shelves only return non-optional fields
	MetaInfo *ProductMetaInfo `thrift:"MetaInfo,1,required" form:"meta_info,required" json:"meta_info,required"`
	// To distinguish between host and guest states
	IsOwner bool `thrift:"IsOwner,2,required" form:"is_owner,required" json:"is_owner,required"`
	// Audit status, return in the main state, you need to pay attention. If the main state is under review, you need to show the status under review.
	AuditStatus product_common.ProductDraftStatus `thrift:"AuditStatus,3" form:"audit_status" json:"audit_status"`
	SellInfo    *SellInfo                         `thrift:"SellInfo,4,optional" form:"sell_info" json:"sell_info,omitempty"`
	SpaceID     *int64                            `thrift:"SpaceID,5,optional" form:"space_id" json:"space_id,string,omitempty"`
	// Details page Back
	Topic *Topic `thrift:"Topic,6,optional" form:"topic" json:"topic,omitempty"`
	// Details page Back
	CanDuplicate      *bool                             `thrift:"CanDuplicate,7,optional" form:"can_duplicate" json:"can_duplicate,omitempty"`
	CommercialSetting *product_common.CommercialSetting `thrift:"CommercialSetting,8,optional" form:"commercial_setting" json:"commercial_setting,omitempty"`
	PluginExtra       *PluginExtraInfo                  `thrift:"PluginExtra,20,optional" form:"plugin_extra" json:"plugin_extra,omitempty"`
	BotExtra          *BotExtraInfo                     `thrift:"BotExtra,21,optional" form:"bot_extra" json:"bot_extra,omitempty"`
	WorkflowExtra     *WorkflowExtraInfo                `thrift:"WorkflowExtra,22,optional" form:"workflow_extra" json:"workflow_extra,omitempty"`
	SocialSceneExtra  *SocialSceneExtraInfo             `thrift:"SocialSceneExtra,23,optional" form:"social_scene_extra" json:"social_scene_extra,omitempty"`
	ProjectExtra      *ProjectExtraInfo                 `thrift:"ProjectExtra,24,optional" form:"project_extra" json:"project_extra,omitempty"`
	DataIndicator     *ProductDataIndicator             `thrift:"DataIndicator,25,optional" form:"data_indicator" json:"data_indicator,omitempty"`
}

func NewGetProductDetailData() *GetProductDetailData {
	return &GetProductDetailData{}
}

func (p *GetProductDetailData) InitDefault() {
}

var GetProductDetailData_MetaInfo_DEFAULT *ProductMetaInfo

func (p *GetProductDetailData) GetMetaInfo() (v *ProductMetaInfo) {
	if !p.IsSetMetaInfo() {
		return GetProductDetailData_MetaInfo_DEFAULT
	}
	return p.MetaInfo
}

func (p *GetProductDetailData) GetIsOwner() (v bool) {
	return p.IsOwner
}

func (p *GetProductDetailData) GetAuditStatus() (v product_common.ProductDraftStatus) {
	return p.AuditStatus
}

var GetProductDetailData_SellInfo_DEFAULT *SellInfo

func (p *GetProductDetailData) GetSellInfo() (v *SellInfo) {
	if !p.IsSetSellInfo() {
		return GetProductDetailData_SellInfo_DEFAULT
	}
	return p.SellInfo
}

var GetProductDetailData_SpaceID_DEFAULT int64

func (p *GetProductDetailData) GetSpaceID() (v int64) {
	if !p.IsSetSpaceID() {
		return GetProductDetailData_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var GetProductDetailData_Topic_DEFAULT *Topic

func (p *GetProductDetailData) GetTopic() (v *Topic) {
	if !p.IsSetTopic() {
		return GetProductDetailData_Topic_DEFAULT
	}
	return p.Topic
}

var GetProductDetailData_CanDuplicate_DEFAULT bool

func (p *GetProductDetailData) GetCanDuplicate() (v bool) {
	if !p.IsSetCanDuplicate() {
		return GetProductDetailData_CanDuplicate_DEFAULT
	}
	return *p.CanDuplicate
}

var GetProductDetailData_CommercialSetting_DEFAULT *product_common.CommercialSetting

func (p *GetProductDetailData) GetCommercialSetting() (v *product_common.CommercialSetting) {
	if !p.IsSetCommercialSetting() {
		return GetProductDetailData_CommercialSetting_DEFAULT
	}
	return p.CommercialSetting
}

var GetProductDetailData_PluginExtra_DEFAULT *PluginExtraInfo

func (p *GetProductDetailData) GetPluginExtra() (v *PluginExtraInfo) {
	if !p.IsSetPluginExtra() {
		return GetProductDetailData_PluginExtra_DEFAULT
	}
	return p.PluginExtra
}

var GetProductDetailData_BotExtra_DEFAULT *BotExtraInfo

func (p *GetProductDetailData) GetBotExtra() (v *BotExtraInfo) {
	if !p.IsSetBotExtra() {
		return GetProductDetailData_BotExtra_DEFAULT
	}
	return p.BotExtra
}

var GetProductDetailData_WorkflowExtra_DEFAULT *WorkflowExtraInfo

func (p *GetProductDetailData) GetWorkflowExtra() (v *WorkflowExtraInfo) {
	if !p.IsSetWorkflowExtra() {
		return GetProductDetailData_WorkflowExtra_DEFAULT
	}
	return p.WorkflowExtra
}

var GetProductDetailData_SocialSceneExtra_DEFAULT *SocialSceneExtraInfo

func (p *GetProductDetailData) GetSocialSceneExtra() (v *SocialSceneExtraInfo) {
	if !p.IsSetSocialSceneExtra() {
		return GetProductDetailData_SocialSceneExtra_DEFAULT
	}
	return p.SocialSceneExtra
}

var GetProductDetailData_ProjectExtra_DEFAULT *ProjectExtraInfo

func (p *GetProductDetailData) GetProjectExtra() (v *ProjectExtraInfo) {
	if !p.IsSetProjectExtra() {
		return GetProductDetailData_ProjectExtra_DEFAULT
	}
	return p.ProjectExtra
}

var GetProductDetailData_DataIndicator_DEFAULT *ProductDataIndicator

func (p *GetProductDetailData) GetDataIndicator() (v *ProductDataIndicator) {
	if !p.IsSetDataIndicator() {
		return GetProductDetailData_DataIndicator_DEFAULT
	}
	return p.DataIndicator
}

var fieldIDToName_GetProductDetailData = map[int16]string{
	1:  "MetaInfo",
	2:  "IsOwner",
	3:  "AuditStatus",
	4:  "SellInfo",
	5:  "SpaceID",
	6:  "Topic",
	7:  "CanDuplicate",
	8:  "CommercialSetting",
	20: "PluginExtra",
	21: "BotExtra",
	22: "WorkflowExtra",
	23: "SocialSceneExtra",
	24: "ProjectExtra",
	25: "DataIndicator",
}

func (p *GetProductDetailData) IsSetMetaInfo() bool {
	return p.MetaInfo != nil
}

func (p *GetProductDetailData) IsSetSellInfo() bool {
	return p.SellInfo != nil
}

func (p *GetProductDetailData) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *GetProductDetailData) IsSetTopic() bool {
	return p.Topic != nil
}

func (p *GetProductDetailData) IsSetCanDuplicate() bool {
	return p.CanDuplicate != nil
}

func (p *GetProductDetailData) IsSetCommercialSetting() bool {
	return p.CommercialSetting != nil
}

func (p *GetProductDetailData) IsSetPluginExtra() bool {
	return p.PluginExtra != nil
}

func (p *GetProductDetailData) IsSetBotExtra() bool {
	return p.BotExtra != nil
}

func (p *GetProductDetailData) IsSetWorkflowExtra() bool {
	return p.WorkflowExtra != nil
}

func (p *GetProductDetailData) IsSetSocialSceneExtra() bool {
	return p.SocialSceneExtra != nil
}

func (p *GetProductDetailData) IsSetProjectExtra() bool {
	return p.ProjectExtra != nil
}

func (p *GetProductDetailData) IsSetDataIndicator() bool {
	return p.DataIndicator != nil
}

func (p *GetProductDetailData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetMetaInfo bool = false
	var issetIsOwner bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetMetaInfo = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetIsOwner = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 22:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField22(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 23:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField23(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 24:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField24(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 25:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField25(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetMetaInfo {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetIsOwner {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetProductDetailData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetProductDetailData[fieldId]))
}

func (p *GetProductDetailData) ReadField1(iprot thrift.TProtocol) error {
	_field := NewProductMetaInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.MetaInfo = _field
	return nil
}
func (p *GetProductDetailData) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsOwner = _field
	return nil
}
func (p *GetProductDetailData) ReadField3(iprot thrift.TProtocol) error {

	var _field product_common.ProductDraftStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductDraftStatus(v)
	}
	p.AuditStatus = _field
	return nil
}
func (p *GetProductDetailData) ReadField4(iprot thrift.TProtocol) error {
	_field := NewSellInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.SellInfo = _field
	return nil
}
func (p *GetProductDetailData) ReadField5(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetProductDetailData) ReadField6(iprot thrift.TProtocol) error {
	_field := NewTopic()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Topic = _field
	return nil
}
func (p *GetProductDetailData) ReadField7(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CanDuplicate = _field
	return nil
}
func (p *GetProductDetailData) ReadField8(iprot thrift.TProtocol) error {
	_field := product_common.NewCommercialSetting()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.CommercialSetting = _field
	return nil
}
func (p *GetProductDetailData) ReadField20(iprot thrift.TProtocol) error {
	_field := NewPluginExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.PluginExtra = _field
	return nil
}
func (p *GetProductDetailData) ReadField21(iprot thrift.TProtocol) error {
	_field := NewBotExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BotExtra = _field
	return nil
}
func (p *GetProductDetailData) ReadField22(iprot thrift.TProtocol) error {
	_field := NewWorkflowExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.WorkflowExtra = _field
	return nil
}
func (p *GetProductDetailData) ReadField23(iprot thrift.TProtocol) error {
	_field := NewSocialSceneExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.SocialSceneExtra = _field
	return nil
}
func (p *GetProductDetailData) ReadField24(iprot thrift.TProtocol) error {
	_field := NewProjectExtraInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ProjectExtra = _field
	return nil
}
func (p *GetProductDetailData) ReadField25(iprot thrift.TProtocol) error {
	_field := NewProductDataIndicator()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.DataIndicator = _field
	return nil
}

func (p *GetProductDetailData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetProductDetailData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
		if err = p.writeField22(oprot); err != nil {
			fieldId = 22
			goto WriteFieldError
		}
		if err = p.writeField23(oprot); err != nil {
			fieldId = 23
			goto WriteFieldError
		}
		if err = p.writeField24(oprot); err != nil {
			fieldId = 24
			goto WriteFieldError
		}
		if err = p.writeField25(oprot); err != nil {
			fieldId = 25
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetProductDetailData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("MetaInfo", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.MetaInfo.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetProductDetailData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsOwner", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsOwner); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetProductDetailData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("AuditStatus", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.AuditStatus)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetProductDetailData) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSellInfo() {
		if err = oprot.WriteFieldBegin("SellInfo", thrift.STRUCT, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.SellInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetProductDetailData) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("SpaceID", thrift.I64, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetProductDetailData) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetTopic() {
		if err = oprot.WriteFieldBegin("Topic", thrift.STRUCT, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Topic.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetProductDetailData) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetCanDuplicate() {
		if err = oprot.WriteFieldBegin("CanDuplicate", thrift.BOOL, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.CanDuplicate); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetProductDetailData) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommercialSetting() {
		if err = oprot.WriteFieldBegin("CommercialSetting", thrift.STRUCT, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.CommercialSetting.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetProductDetailData) writeField20(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginExtra() {
		if err = oprot.WriteFieldBegin("PluginExtra", thrift.STRUCT, 20); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.PluginExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}
func (p *GetProductDetailData) writeField21(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotExtra() {
		if err = oprot.WriteFieldBegin("BotExtra", thrift.STRUCT, 21); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BotExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}
func (p *GetProductDetailData) writeField22(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowExtra() {
		if err = oprot.WriteFieldBegin("WorkflowExtra", thrift.STRUCT, 22); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.WorkflowExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 end error: ", p), err)
}
func (p *GetProductDetailData) writeField23(oprot thrift.TProtocol) (err error) {
	if p.IsSetSocialSceneExtra() {
		if err = oprot.WriteFieldBegin("SocialSceneExtra", thrift.STRUCT, 23); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.SocialSceneExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 end error: ", p), err)
}
func (p *GetProductDetailData) writeField24(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectExtra() {
		if err = oprot.WriteFieldBegin("ProjectExtra", thrift.STRUCT, 24); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.ProjectExtra.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 end error: ", p), err)
}
func (p *GetProductDetailData) writeField25(oprot thrift.TProtocol) (err error) {
	if p.IsSetDataIndicator() {
		if err = oprot.WriteFieldBegin("DataIndicator", thrift.STRUCT, 25); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.DataIndicator.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 25 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 25 end error: ", p), err)
}

func (p *GetProductDetailData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetProductDetailData(%+v)", *p)

}

type GetUserFavoriteListV2Request struct {
	// The first page is not passed, and the last returned cursor_id is passed when subsequent calls are made
	CursorID   *string                           `thrift:"CursorID,1,optional" json:"CursorID,omitempty" query:"cursor_id"`
	PageSize   int32                             `thrift:"PageSize,2,required" json:"PageSize,required" query:"page_size,required"`
	EntityType *product_common.ProductEntityType `thrift:"EntityType,3,optional" json:"EntityType,omitempty" query:"entity_type"`
	SortType   product_common.SortType           `thrift:"SortType,4,required" json:"SortType,required" query:"sort_type,required"`
	// Search keyword,optional
	Keyword *string `thrift:"Keyword,5,optional" json:"Keyword,omitempty" query:"keyword"`
	// List page tab
	Source *product_common.FavoriteListSource `thrift:"Source,6,optional" json:"Source,omitempty" query:"source"`
	// Whether you need to query the user's trigger configuration for the Bot, when true, it will return EntityUserTriggerConfig
	NeedUserTriggerConfig *bool `thrift:"NeedUserTriggerConfig,7,optional" json:"NeedUserTriggerConfig,omitempty" query:"need_user_trigger_config"`
	// Filter collection time
	BeginAt *int64 `thrift:"BeginAt,8,optional" json:"BeginAt,string,omitempty" query:"begin_at"`
	// Filter collection time
	EndAt       *int64                             `thrift:"EndAt,9,optional" json:"EndAt,string,omitempty" query:"end_at"`
	EntityTypes []product_common.ProductEntityType `thrift:"EntityTypes,10,optional" json:"EntityTypes,omitempty" query:"entity_types"`
	// Organization ID, Enterprise Edition needs to be passed when you want to get all the content in the user's collection
	OrganizationID *int64     `thrift:"OrganizationID,11,optional" json:"OrganizationID,omitempty" query:"organization_id"`
	Base           *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetUserFavoriteListV2Request() *GetUserFavoriteListV2Request {
	return &GetUserFavoriteListV2Request{}
}

func (p *GetUserFavoriteListV2Request) InitDefault() {
}

var GetUserFavoriteListV2Request_CursorID_DEFAULT string

func (p *GetUserFavoriteListV2Request) GetCursorID() (v string) {
	if !p.IsSetCursorID() {
		return GetUserFavoriteListV2Request_CursorID_DEFAULT
	}
	return *p.CursorID
}

func (p *GetUserFavoriteListV2Request) GetPageSize() (v int32) {
	return p.PageSize
}

var GetUserFavoriteListV2Request_EntityType_DEFAULT product_common.ProductEntityType

func (p *GetUserFavoriteListV2Request) GetEntityType() (v product_common.ProductEntityType) {
	if !p.IsSetEntityType() {
		return GetUserFavoriteListV2Request_EntityType_DEFAULT
	}
	return *p.EntityType
}

func (p *GetUserFavoriteListV2Request) GetSortType() (v product_common.SortType) {
	return p.SortType
}

var GetUserFavoriteListV2Request_Keyword_DEFAULT string

func (p *GetUserFavoriteListV2Request) GetKeyword() (v string) {
	if !p.IsSetKeyword() {
		return GetUserFavoriteListV2Request_Keyword_DEFAULT
	}
	return *p.Keyword
}

var GetUserFavoriteListV2Request_Source_DEFAULT product_common.FavoriteListSource

func (p *GetUserFavoriteListV2Request) GetSource() (v product_common.FavoriteListSource) {
	if !p.IsSetSource() {
		return GetUserFavoriteListV2Request_Source_DEFAULT
	}
	return *p.Source
}

var GetUserFavoriteListV2Request_NeedUserTriggerConfig_DEFAULT bool

func (p *GetUserFavoriteListV2Request) GetNeedUserTriggerConfig() (v bool) {
	if !p.IsSetNeedUserTriggerConfig() {
		return GetUserFavoriteListV2Request_NeedUserTriggerConfig_DEFAULT
	}
	return *p.NeedUserTriggerConfig
}

var GetUserFavoriteListV2Request_BeginAt_DEFAULT int64

func (p *GetUserFavoriteListV2Request) GetBeginAt() (v int64) {
	if !p.IsSetBeginAt() {
		return GetUserFavoriteListV2Request_BeginAt_DEFAULT
	}
	return *p.BeginAt
}

var GetUserFavoriteListV2Request_EndAt_DEFAULT int64

func (p *GetUserFavoriteListV2Request) GetEndAt() (v int64) {
	if !p.IsSetEndAt() {
		return GetUserFavoriteListV2Request_EndAt_DEFAULT
	}
	return *p.EndAt
}

var GetUserFavoriteListV2Request_EntityTypes_DEFAULT []product_common.ProductEntityType

func (p *GetUserFavoriteListV2Request) GetEntityTypes() (v []product_common.ProductEntityType) {
	if !p.IsSetEntityTypes() {
		return GetUserFavoriteListV2Request_EntityTypes_DEFAULT
	}
	return p.EntityTypes
}

var GetUserFavoriteListV2Request_OrganizationID_DEFAULT int64

func (p *GetUserFavoriteListV2Request) GetOrganizationID() (v int64) {
	if !p.IsSetOrganizationID() {
		return GetUserFavoriteListV2Request_OrganizationID_DEFAULT
	}
	return *p.OrganizationID
}

var GetUserFavoriteListV2Request_Base_DEFAULT *base.Base

func (p *GetUserFavoriteListV2Request) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetUserFavoriteListV2Request_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetUserFavoriteListV2Request = map[int16]string{
	1:   "CursorID",
	2:   "PageSize",
	3:   "EntityType",
	4:   "SortType",
	5:   "Keyword",
	6:   "Source",
	7:   "NeedUserTriggerConfig",
	8:   "BeginAt",
	9:   "EndAt",
	10:  "EntityTypes",
	11:  "OrganizationID",
	255: "Base",
}

func (p *GetUserFavoriteListV2Request) IsSetCursorID() bool {
	return p.CursorID != nil
}

func (p *GetUserFavoriteListV2Request) IsSetEntityType() bool {
	return p.EntityType != nil
}

func (p *GetUserFavoriteListV2Request) IsSetKeyword() bool {
	return p.Keyword != nil
}

func (p *GetUserFavoriteListV2Request) IsSetSource() bool {
	return p.Source != nil
}

func (p *GetUserFavoriteListV2Request) IsSetNeedUserTriggerConfig() bool {
	return p.NeedUserTriggerConfig != nil
}

func (p *GetUserFavoriteListV2Request) IsSetBeginAt() bool {
	return p.BeginAt != nil
}

func (p *GetUserFavoriteListV2Request) IsSetEndAt() bool {
	return p.EndAt != nil
}

func (p *GetUserFavoriteListV2Request) IsSetEntityTypes() bool {
	return p.EntityTypes != nil
}

func (p *GetUserFavoriteListV2Request) IsSetOrganizationID() bool {
	return p.OrganizationID != nil
}

func (p *GetUserFavoriteListV2Request) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetUserFavoriteListV2Request) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetPageSize bool = false
	var issetSortType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetPageSize = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetSortType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetPageSize {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetSortType {
		fieldId = 4
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetUserFavoriteListV2Request[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetUserFavoriteListV2Request[fieldId]))
}

func (p *GetUserFavoriteListV2Request) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CursorID = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField2(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PageSize = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField3(iprot thrift.TProtocol) error {

	var _field *product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.ProductEntityType(v)
		_field = &tmp
	}
	p.EntityType = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField4(iprot thrift.TProtocol) error {

	var _field product_common.SortType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.SortType(v)
	}
	p.SortType = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Keyword = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField6(iprot thrift.TProtocol) error {

	var _field *product_common.FavoriteListSource
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := product_common.FavoriteListSource(v)
		_field = &tmp
	}
	p.Source = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField7(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedUserTriggerConfig = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField8(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BeginAt = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField9(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EndAt = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField10(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]product_common.ProductEntityType, 0, size)
	for i := 0; i < size; i++ {

		var _elem product_common.ProductEntityType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_elem = product_common.ProductEntityType(v)
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.EntityTypes = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField11(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OrganizationID = _field
	return nil
}
func (p *GetUserFavoriteListV2Request) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetUserFavoriteListV2Request) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUserFavoriteListV2Request"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetUserFavoriteListV2Request) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetCursorID() {
		if err = oprot.WriteFieldBegin("CursorID", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CursorID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PageSize", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.PageSize); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityType() {
		if err = oprot.WriteFieldBegin("EntityType", thrift.I32, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.EntityType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("SortType", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SortType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetKeyword() {
		if err = oprot.WriteFieldBegin("Keyword", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Keyword); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetSource() {
		if err = oprot.WriteFieldBegin("Source", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Source)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedUserTriggerConfig() {
		if err = oprot.WriteFieldBegin("NeedUserTriggerConfig", thrift.BOOL, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedUserTriggerConfig); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetBeginAt() {
		if err = oprot.WriteFieldBegin("BeginAt", thrift.I64, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.BeginAt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetEndAt() {
		if err = oprot.WriteFieldBegin("EndAt", thrift.I64, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.EndAt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetEntityTypes() {
		if err = oprot.WriteFieldBegin("EntityTypes", thrift.LIST, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.I32, len(p.EntityTypes)); err != nil {
			return err
		}
		for _, v := range p.EntityTypes {
			if err := oprot.WriteI32(int32(v)); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetOrganizationID() {
		if err = oprot.WriteFieldBegin("OrganizationID", thrift.I64, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.OrganizationID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Request) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetUserFavoriteListV2Request) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetUserFavoriteListV2Request(%+v)", *p)

}

type GetUserFavoriteListV2Response struct {
	Code     int32                      `thrift:"Code,1,required" form:"Code,required" json:"Code,required" query:"Code,required"`
	Message  string                     `thrift:"Message,2,required" form:"Message,required" json:"Message,required" query:"Message,required"`
	Data     *GetUserFavoriteListDataV2 `thrift:"Data,3,optional" form:"Data" json:"Data,omitempty" query:"Data"`
	BaseResp *base.BaseResp             `thrift:"BaseResp,255,optional" form:"BaseResp" json:"BaseResp,omitempty" query:"BaseResp"`
}

func NewGetUserFavoriteListV2Response() *GetUserFavoriteListV2Response {
	return &GetUserFavoriteListV2Response{}
}

func (p *GetUserFavoriteListV2Response) InitDefault() {
}

func (p *GetUserFavoriteListV2Response) GetCode() (v int32) {
	return p.Code
}

func (p *GetUserFavoriteListV2Response) GetMessage() (v string) {
	return p.Message
}

var GetUserFavoriteListV2Response_Data_DEFAULT *GetUserFavoriteListDataV2

func (p *GetUserFavoriteListV2Response) GetData() (v *GetUserFavoriteListDataV2) {
	if !p.IsSetData() {
		return GetUserFavoriteListV2Response_Data_DEFAULT
	}
	return p.Data
}

var GetUserFavoriteListV2Response_BaseResp_DEFAULT *base.BaseResp

func (p *GetUserFavoriteListV2Response) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetUserFavoriteListV2Response_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetUserFavoriteListV2Response = map[int16]string{
	1:   "Code",
	2:   "Message",
	3:   "Data",
	255: "BaseResp",
}

func (p *GetUserFavoriteListV2Response) IsSetData() bool {
	return p.Data != nil
}

func (p *GetUserFavoriteListV2Response) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetUserFavoriteListV2Response) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMessage bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetMessage = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetMessage {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetUserFavoriteListV2Response[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetUserFavoriteListV2Response[fieldId]))
}

func (p *GetUserFavoriteListV2Response) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetUserFavoriteListV2Response) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Message = _field
	return nil
}
func (p *GetUserFavoriteListV2Response) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetUserFavoriteListDataV2()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetUserFavoriteListV2Response) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetUserFavoriteListV2Response) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUserFavoriteListV2Response"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetUserFavoriteListV2Response) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Code", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Response) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Message", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Message); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Response) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetData() {
		if err = oprot.WriteFieldBegin("Data", thrift.STRUCT, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Data.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetUserFavoriteListV2Response) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseResp() {
		if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BaseResp.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetUserFavoriteListV2Response) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetUserFavoriteListV2Response(%+v)", *p)

}

type GetUserFavoriteListDataV2 struct {
	FavoriteEntities []*product_common.FavoriteEntity `thrift:"FavoriteEntities,1" form:"favorite_entities" json:"favorite_entities"`
	CursorID         string                           `thrift:"CursorID,2" form:"cursor_id" json:"cursor_id"`
	HasMore          bool                             `thrift:"HasMore,3" form:"has_more" json:"has_more"`
	// User timed task configuration, corresponding to flow.bot TriggerEnabled of the task service
	EntityUserTriggerConfig map[int64]*UserTriggerConfig `thrift:"EntityUserTriggerConfig,4" form:"entity_user_trigger_config" json:"entity_user_trigger_config"`
}

func NewGetUserFavoriteListDataV2() *GetUserFavoriteListDataV2 {
	return &GetUserFavoriteListDataV2{}
}

func (p *GetUserFavoriteListDataV2) InitDefault() {
}

func (p *GetUserFavoriteListDataV2) GetFavoriteEntities() (v []*product_common.FavoriteEntity) {
	return p.FavoriteEntities
}

func (p *GetUserFavoriteListDataV2) GetCursorID() (v string) {
	return p.CursorID
}

func (p *GetUserFavoriteListDataV2) GetHasMore() (v bool) {
	return p.HasMore
}

func (p *GetUserFavoriteListDataV2) GetEntityUserTriggerConfig() (v map[int64]*UserTriggerConfig) {
	return p.EntityUserTriggerConfig
}

var fieldIDToName_GetUserFavoriteListDataV2 = map[int16]string{
	1: "FavoriteEntities",
	2: "CursorID",
	3: "HasMore",
	4: "EntityUserTriggerConfig",
}

func (p *GetUserFavoriteListDataV2) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetUserFavoriteListDataV2[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetUserFavoriteListDataV2) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*product_common.FavoriteEntity, 0, size)
	values := make([]product_common.FavoriteEntity, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.FavoriteEntities = _field
	return nil
}
func (p *GetUserFavoriteListDataV2) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CursorID = _field
	return nil
}
func (p *GetUserFavoriteListDataV2) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.HasMore = _field
	return nil
}
func (p *GetUserFavoriteListDataV2) ReadField4(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*UserTriggerConfig, size)
	values := make([]UserTriggerConfig, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.EntityUserTriggerConfig = _field
	return nil
}

func (p *GetUserFavoriteListDataV2) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUserFavoriteListDataV2"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetUserFavoriteListDataV2) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("FavoriteEntities", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.FavoriteEntities)); err != nil {
		return err
	}
	for _, v := range p.FavoriteEntities {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetUserFavoriteListDataV2) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("CursorID", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.CursorID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetUserFavoriteListDataV2) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("HasMore", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.HasMore); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetUserFavoriteListDataV2) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityUserTriggerConfig", thrift.MAP, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.EntityUserTriggerConfig)); err != nil {
		return err
	}
	for k, v := range p.EntityUserTriggerConfig {
		if err := oprot.WriteI64(k); err != nil {
			return err
		}
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *GetUserFavoriteListDataV2) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetUserFavoriteListDataV2(%+v)", *p)

}

type UserTriggerConfig struct {
	TriggerEnabled TriggerEnable `thrift:"TriggerEnabled,1" form:"TriggerEnabled" json:"TriggerEnabled" query:"TriggerEnabled"`
}

func NewUserTriggerConfig() *UserTriggerConfig {
	return &UserTriggerConfig{}
}

func (p *UserTriggerConfig) InitDefault() {
}

func (p *UserTriggerConfig) GetTriggerEnabled() (v TriggerEnable) {
	return p.TriggerEnabled
}

var fieldIDToName_UserTriggerConfig = map[int16]string{
	1: "TriggerEnabled",
}

func (p *UserTriggerConfig) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserTriggerConfig[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UserTriggerConfig) ReadField1(iprot thrift.TProtocol) error {

	var _field TriggerEnable
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = TriggerEnable(v)
	}
	p.TriggerEnabled = _field
	return nil
}

func (p *UserTriggerConfig) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserTriggerConfig"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserTriggerConfig) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("TriggerEnabled", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.TriggerEnabled)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *UserTriggerConfig) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserTriggerConfig(%+v)", *p)

}

type DuplicateProductRequest struct {
	ProductID  int64                            `thrift:"ProductID,1,required" form:"product_id,required" json:"product_id,string,required"`
	EntityType product_common.ProductEntityType `thrift:"EntityType,2,required" form:"entity_type,required" json:"entity_type,required"`
	SpaceID    *int64                           `thrift:"SpaceID,3,optional" form:"space_id" json:"space_id,string,omitempty"`
	Name       *string                          `thrift:"Name,4,optional" form:"name" json:"name,omitempty"`
	Cookie     *string                          `thrift:"Cookie,100,optional" jsonlog:"-" json:"-" form:"Cookie" query:"Cookie"`
	Base       *base.Base                       `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewDuplicateProductRequest() *DuplicateProductRequest {
	return &DuplicateProductRequest{}
}

func (p *DuplicateProductRequest) InitDefault() {
}

func (p *DuplicateProductRequest) GetProductID() (v int64) {
	return p.ProductID
}

func (p *DuplicateProductRequest) GetEntityType() (v product_common.ProductEntityType) {
	return p.EntityType
}

var DuplicateProductRequest_SpaceID_DEFAULT int64

func (p *DuplicateProductRequest) GetSpaceID() (v int64) {
	if !p.IsSetSpaceID() {
		return DuplicateProductRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var DuplicateProductRequest_Name_DEFAULT string

func (p *DuplicateProductRequest) GetName() (v string) {
	if !p.IsSetName() {
		return DuplicateProductRequest_Name_DEFAULT
	}
	return *p.Name
}

var DuplicateProductRequest_Cookie_DEFAULT string

func (p *DuplicateProductRequest) GetCookie() (v string) {
	if !p.IsSetCookie() {
		return DuplicateProductRequest_Cookie_DEFAULT
	}
	return *p.Cookie
}

var DuplicateProductRequest_Base_DEFAULT *base.Base

func (p *DuplicateProductRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return DuplicateProductRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_DuplicateProductRequest = map[int16]string{
	1:   "ProductID",
	2:   "EntityType",
	3:   "SpaceID",
	4:   "Name",
	100: "Cookie",
	255: "Base",
}

func (p *DuplicateProductRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *DuplicateProductRequest) IsSetName() bool {
	return p.Name != nil
}

func (p *DuplicateProductRequest) IsSetCookie() bool {
	return p.Cookie != nil
}

func (p *DuplicateProductRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *DuplicateProductRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetProductID bool = false
	var issetEntityType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetProductID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetEntityType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 100:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField100(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetProductID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetEntityType {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DuplicateProductRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DuplicateProductRequest[fieldId]))
}

func (p *DuplicateProductRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ProductID = _field
	return nil
}
func (p *DuplicateProductRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field product_common.ProductEntityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = product_common.ProductEntityType(v)
	}
	p.EntityType = _field
	return nil
}
func (p *DuplicateProductRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *DuplicateProductRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *DuplicateProductRequest) ReadField100(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Cookie = _field
	return nil
}
func (p *DuplicateProductRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *DuplicateProductRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateProductRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField100(oprot); err != nil {
			fieldId = 100
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DuplicateProductRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ProductID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ProductID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DuplicateProductRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("EntityType", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.EntityType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DuplicateProductRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("SpaceID", thrift.I64, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *DuplicateProductRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("Name", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *DuplicateProductRequest) writeField100(oprot thrift.TProtocol) (err error) {
	if p.IsSetCookie() {
		if err = oprot.WriteFieldBegin("Cookie", thrift.STRING, 100); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Cookie); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 100 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 100 end error: ", p), err)
}
func (p *DuplicateProductRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *DuplicateProductRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DuplicateProductRequest(%+v)", *p)

}

type DuplicateProductResponse struct {
	Code     int32                 `thrift:"Code,1,required" form:"code,required" json:"code,required"`
	Message  string                `thrift:"Message,2,required" form:"message,required" json:"message,required"`
	Data     *DuplicateProductData `thrift:"Data,3" form:"data" json:"data"`
	BaseResp *base.BaseResp        `thrift:"BaseResp,255,optional" form:"BaseResp" json:"BaseResp,omitempty" query:"BaseResp"`
}

func NewDuplicateProductResponse() *DuplicateProductResponse {
	return &DuplicateProductResponse{}
}

func (p *DuplicateProductResponse) InitDefault() {
}

func (p *DuplicateProductResponse) GetCode() (v int32) {
	return p.Code
}

func (p *DuplicateProductResponse) GetMessage() (v string) {
	return p.Message
}

var DuplicateProductResponse_Data_DEFAULT *DuplicateProductData

func (p *DuplicateProductResponse) GetData() (v *DuplicateProductData) {
	if !p.IsSetData() {
		return DuplicateProductResponse_Data_DEFAULT
	}
	return p.Data
}

var DuplicateProductResponse_BaseResp_DEFAULT *base.BaseResp

func (p *DuplicateProductResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return DuplicateProductResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_DuplicateProductResponse = map[int16]string{
	1:   "Code",
	2:   "Message",
	3:   "Data",
	255: "BaseResp",
}

func (p *DuplicateProductResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *DuplicateProductResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *DuplicateProductResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMessage bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetMessage = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetMessage {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DuplicateProductResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DuplicateProductResponse[fieldId]))
}

func (p *DuplicateProductResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *DuplicateProductResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Message = _field
	return nil
}
func (p *DuplicateProductResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewDuplicateProductData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *DuplicateProductResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *DuplicateProductResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateProductResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DuplicateProductResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Code", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DuplicateProductResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Message", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Message); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DuplicateProductResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *DuplicateProductResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseResp() {
		if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BaseResp.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *DuplicateProductResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DuplicateProductResponse(%+v)", *p)

}

type DuplicateProductData struct {
	// New ID after copy
	NewEntityID int64 `thrift:"NewEntityID,1" form:"new_entity_id" json:"new_entity_id,string"`
	// Plugin ID for workflow
	NewPluginID *int64 `thrift:"NewPluginID,2,optional" form:"new_plugin_id" json:"new_plugin_id,string,omitempty"`
}

func NewDuplicateProductData() *DuplicateProductData {
	return &DuplicateProductData{}
}

func (p *DuplicateProductData) InitDefault() {
}

func (p *DuplicateProductData) GetNewEntityID() (v int64) {
	return p.NewEntityID
}

var DuplicateProductData_NewPluginID_DEFAULT int64

func (p *DuplicateProductData) GetNewPluginID() (v int64) {
	if !p.IsSetNewPluginID() {
		return DuplicateProductData_NewPluginID_DEFAULT
	}
	return *p.NewPluginID
}

var fieldIDToName_DuplicateProductData = map[int16]string{
	1: "NewEntityID",
	2: "NewPluginID",
}

func (p *DuplicateProductData) IsSetNewPluginID() bool {
	return p.NewPluginID != nil
}

func (p *DuplicateProductData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DuplicateProductData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DuplicateProductData) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.NewEntityID = _field
	return nil
}
func (p *DuplicateProductData) ReadField2(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NewPluginID = _field
	return nil
}

func (p *DuplicateProductData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateProductData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DuplicateProductData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("NewEntityID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.NewEntityID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DuplicateProductData) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetNewPluginID() {
		if err = oprot.WriteFieldBegin("NewPluginID", thrift.I64, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.NewPluginID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *DuplicateProductData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DuplicateProductData(%+v)", *p)

}

type PublicProductService interface {
	PublicGetProductList(ctx context.Context, req *GetProductListRequest) (r *GetProductListResponse, err error)

	PublicGetProductDetail(ctx context.Context, req *GetProductDetailRequest) (r *GetProductDetailResponse, err error)

	PublicFavoriteProduct(ctx context.Context, req *FavoriteProductRequest) (r *FavoriteProductResponse, err error)

	PublicGetUserFavoriteListV2(ctx context.Context, req *GetUserFavoriteListV2Request) (r *GetUserFavoriteListV2Response, err error)

	PublicDuplicateProduct(ctx context.Context, req *DuplicateProductRequest) (r *DuplicateProductResponse, err error)
}

type PublicProductServiceClient struct {
	c thrift.TClient
}

func NewPublicProductServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *PublicProductServiceClient {
	return &PublicProductServiceClient{
		c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
	}
}

func NewPublicProductServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *PublicProductServiceClient {
	return &PublicProductServiceClient{
		c: thrift.NewTStandardClient(iprot, oprot),
	}
}

func NewPublicProductServiceClient(c thrift.TClient) *PublicProductServiceClient {
	return &PublicProductServiceClient{
		c: c,
	}
}

func (p *PublicProductServiceClient) Client_() thrift.TClient {
	return p.c
}

func (p *PublicProductServiceClient) PublicGetProductList(ctx context.Context, req *GetProductListRequest) (r *GetProductListResponse, err error) {
	var _args PublicProductServicePublicGetProductListArgs
	_args.Req = req
	var _result PublicProductServicePublicGetProductListResult
	if err = p.Client_().Call(ctx, "PublicGetProductList", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PublicProductServiceClient) PublicGetProductDetail(ctx context.Context, req *GetProductDetailRequest) (r *GetProductDetailResponse, err error) {
	var _args PublicProductServicePublicGetProductDetailArgs
	_args.Req = req
	var _result PublicProductServicePublicGetProductDetailResult
	if err = p.Client_().Call(ctx, "PublicGetProductDetail", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PublicProductServiceClient) PublicFavoriteProduct(ctx context.Context, req *FavoriteProductRequest) (r *FavoriteProductResponse, err error) {
	var _args PublicProductServicePublicFavoriteProductArgs
	_args.Req = req
	var _result PublicProductServicePublicFavoriteProductResult
	if err = p.Client_().Call(ctx, "PublicFavoriteProduct", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PublicProductServiceClient) PublicGetUserFavoriteListV2(ctx context.Context, req *GetUserFavoriteListV2Request) (r *GetUserFavoriteListV2Response, err error) {
	var _args PublicProductServicePublicGetUserFavoriteListV2Args
	_args.Req = req
	var _result PublicProductServicePublicGetUserFavoriteListV2Result
	if err = p.Client_().Call(ctx, "PublicGetUserFavoriteListV2", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PublicProductServiceClient) PublicDuplicateProduct(ctx context.Context, req *DuplicateProductRequest) (r *DuplicateProductResponse, err error) {
	var _args PublicProductServicePublicDuplicateProductArgs
	_args.Req = req
	var _result PublicProductServicePublicDuplicateProductResult
	if err = p.Client_().Call(ctx, "PublicDuplicateProduct", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}

type PublicProductServiceProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      PublicProductService
}

func (p *PublicProductServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *PublicProductServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *PublicProductServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewPublicProductServiceProcessor(handler PublicProductService) *PublicProductServiceProcessor {
	self := &PublicProductServiceProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self.AddToProcessorMap("PublicGetProductList", &publicProductServiceProcessorPublicGetProductList{handler: handler})
	self.AddToProcessorMap("PublicGetProductDetail", &publicProductServiceProcessorPublicGetProductDetail{handler: handler})
	self.AddToProcessorMap("PublicFavoriteProduct", &publicProductServiceProcessorPublicFavoriteProduct{handler: handler})
	self.AddToProcessorMap("PublicGetUserFavoriteListV2", &publicProductServiceProcessorPublicGetUserFavoriteListV2{handler: handler})
	self.AddToProcessorMap("PublicDuplicateProduct", &publicProductServiceProcessorPublicDuplicateProduct{handler: handler})
	return self
}
func (p *PublicProductServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(ctx, seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush(ctx)
	return false, x
}

type publicProductServiceProcessorPublicGetProductList struct {
	handler PublicProductService
}

func (p *publicProductServiceProcessorPublicGetProductList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PublicProductServicePublicGetProductListArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublicGetProductList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PublicProductServicePublicGetProductListResult{}
	var retval *GetProductListResponse
	if retval, err2 = p.handler.PublicGetProductList(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublicGetProductList: "+err2.Error())
		oprot.WriteMessageBegin("PublicGetProductList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublicGetProductList", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type publicProductServiceProcessorPublicGetProductDetail struct {
	handler PublicProductService
}

func (p *publicProductServiceProcessorPublicGetProductDetail) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PublicProductServicePublicGetProductDetailArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublicGetProductDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PublicProductServicePublicGetProductDetailResult{}
	var retval *GetProductDetailResponse
	if retval, err2 = p.handler.PublicGetProductDetail(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublicGetProductDetail: "+err2.Error())
		oprot.WriteMessageBegin("PublicGetProductDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublicGetProductDetail", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type publicProductServiceProcessorPublicFavoriteProduct struct {
	handler PublicProductService
}

func (p *publicProductServiceProcessorPublicFavoriteProduct) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PublicProductServicePublicFavoriteProductArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublicFavoriteProduct", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PublicProductServicePublicFavoriteProductResult{}
	var retval *FavoriteProductResponse
	if retval, err2 = p.handler.PublicFavoriteProduct(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublicFavoriteProduct: "+err2.Error())
		oprot.WriteMessageBegin("PublicFavoriteProduct", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublicFavoriteProduct", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type publicProductServiceProcessorPublicGetUserFavoriteListV2 struct {
	handler PublicProductService
}

func (p *publicProductServiceProcessorPublicGetUserFavoriteListV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PublicProductServicePublicGetUserFavoriteListV2Args{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublicGetUserFavoriteListV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PublicProductServicePublicGetUserFavoriteListV2Result{}
	var retval *GetUserFavoriteListV2Response
	if retval, err2 = p.handler.PublicGetUserFavoriteListV2(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublicGetUserFavoriteListV2: "+err2.Error())
		oprot.WriteMessageBegin("PublicGetUserFavoriteListV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublicGetUserFavoriteListV2", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type publicProductServiceProcessorPublicDuplicateProduct struct {
	handler PublicProductService
}

func (p *publicProductServiceProcessorPublicDuplicateProduct) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PublicProductServicePublicDuplicateProductArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublicDuplicateProduct", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PublicProductServicePublicDuplicateProductResult{}
	var retval *DuplicateProductResponse
	if retval, err2 = p.handler.PublicDuplicateProduct(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublicDuplicateProduct: "+err2.Error())
		oprot.WriteMessageBegin("PublicDuplicateProduct", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublicDuplicateProduct", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type PublicProductServicePublicGetProductListArgs struct {
	Req *GetProductListRequest `thrift:"req,1"`
}

func NewPublicProductServicePublicGetProductListArgs() *PublicProductServicePublicGetProductListArgs {
	return &PublicProductServicePublicGetProductListArgs{}
}

func (p *PublicProductServicePublicGetProductListArgs) InitDefault() {
}

var PublicProductServicePublicGetProductListArgs_Req_DEFAULT *GetProductListRequest

func (p *PublicProductServicePublicGetProductListArgs) GetReq() (v *GetProductListRequest) {
	if !p.IsSetReq() {
		return PublicProductServicePublicGetProductListArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_PublicProductServicePublicGetProductListArgs = map[int16]string{
	1: "req",
}

func (p *PublicProductServicePublicGetProductListArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *PublicProductServicePublicGetProductListArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicGetProductListArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductListArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetProductListRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *PublicProductServicePublicGetProductListArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicGetProductList_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductListArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductListArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicGetProductListArgs(%+v)", *p)

}

type PublicProductServicePublicGetProductListResult struct {
	Success *GetProductListResponse `thrift:"success,0,optional"`
}

func NewPublicProductServicePublicGetProductListResult() *PublicProductServicePublicGetProductListResult {
	return &PublicProductServicePublicGetProductListResult{}
}

func (p *PublicProductServicePublicGetProductListResult) InitDefault() {
}

var PublicProductServicePublicGetProductListResult_Success_DEFAULT *GetProductListResponse

func (p *PublicProductServicePublicGetProductListResult) GetSuccess() (v *GetProductListResponse) {
	if !p.IsSetSuccess() {
		return PublicProductServicePublicGetProductListResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PublicProductServicePublicGetProductListResult = map[int16]string{
	0: "success",
}

func (p *PublicProductServicePublicGetProductListResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PublicProductServicePublicGetProductListResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicGetProductListResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductListResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetProductListResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PublicProductServicePublicGetProductListResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicGetProductList_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductListResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductListResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicGetProductListResult(%+v)", *p)

}

type PublicProductServicePublicGetProductDetailArgs struct {
	Req *GetProductDetailRequest `thrift:"req,1"`
}

func NewPublicProductServicePublicGetProductDetailArgs() *PublicProductServicePublicGetProductDetailArgs {
	return &PublicProductServicePublicGetProductDetailArgs{}
}

func (p *PublicProductServicePublicGetProductDetailArgs) InitDefault() {
}

var PublicProductServicePublicGetProductDetailArgs_Req_DEFAULT *GetProductDetailRequest

func (p *PublicProductServicePublicGetProductDetailArgs) GetReq() (v *GetProductDetailRequest) {
	if !p.IsSetReq() {
		return PublicProductServicePublicGetProductDetailArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_PublicProductServicePublicGetProductDetailArgs = map[int16]string{
	1: "req",
}

func (p *PublicProductServicePublicGetProductDetailArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *PublicProductServicePublicGetProductDetailArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicGetProductDetailArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductDetailArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetProductDetailRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *PublicProductServicePublicGetProductDetailArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicGetProductDetail_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductDetailArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductDetailArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicGetProductDetailArgs(%+v)", *p)

}

type PublicProductServicePublicGetProductDetailResult struct {
	Success *GetProductDetailResponse `thrift:"success,0,optional"`
}

func NewPublicProductServicePublicGetProductDetailResult() *PublicProductServicePublicGetProductDetailResult {
	return &PublicProductServicePublicGetProductDetailResult{}
}

func (p *PublicProductServicePublicGetProductDetailResult) InitDefault() {
}

var PublicProductServicePublicGetProductDetailResult_Success_DEFAULT *GetProductDetailResponse

func (p *PublicProductServicePublicGetProductDetailResult) GetSuccess() (v *GetProductDetailResponse) {
	if !p.IsSetSuccess() {
		return PublicProductServicePublicGetProductDetailResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PublicProductServicePublicGetProductDetailResult = map[int16]string{
	0: "success",
}

func (p *PublicProductServicePublicGetProductDetailResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PublicProductServicePublicGetProductDetailResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicGetProductDetailResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductDetailResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetProductDetailResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PublicProductServicePublicGetProductDetailResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicGetProductDetail_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductDetailResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PublicProductServicePublicGetProductDetailResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicGetProductDetailResult(%+v)", *p)

}

type PublicProductServicePublicFavoriteProductArgs struct {
	Req *FavoriteProductRequest `thrift:"req,1"`
}

func NewPublicProductServicePublicFavoriteProductArgs() *PublicProductServicePublicFavoriteProductArgs {
	return &PublicProductServicePublicFavoriteProductArgs{}
}

func (p *PublicProductServicePublicFavoriteProductArgs) InitDefault() {
}

var PublicProductServicePublicFavoriteProductArgs_Req_DEFAULT *FavoriteProductRequest

func (p *PublicProductServicePublicFavoriteProductArgs) GetReq() (v *FavoriteProductRequest) {
	if !p.IsSetReq() {
		return PublicProductServicePublicFavoriteProductArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_PublicProductServicePublicFavoriteProductArgs = map[int16]string{
	1: "req",
}

func (p *PublicProductServicePublicFavoriteProductArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *PublicProductServicePublicFavoriteProductArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicFavoriteProductArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicFavoriteProductArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewFavoriteProductRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *PublicProductServicePublicFavoriteProductArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicFavoriteProduct_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicFavoriteProductArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PublicProductServicePublicFavoriteProductArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicFavoriteProductArgs(%+v)", *p)

}

type PublicProductServicePublicFavoriteProductResult struct {
	Success *FavoriteProductResponse `thrift:"success,0,optional"`
}

func NewPublicProductServicePublicFavoriteProductResult() *PublicProductServicePublicFavoriteProductResult {
	return &PublicProductServicePublicFavoriteProductResult{}
}

func (p *PublicProductServicePublicFavoriteProductResult) InitDefault() {
}

var PublicProductServicePublicFavoriteProductResult_Success_DEFAULT *FavoriteProductResponse

func (p *PublicProductServicePublicFavoriteProductResult) GetSuccess() (v *FavoriteProductResponse) {
	if !p.IsSetSuccess() {
		return PublicProductServicePublicFavoriteProductResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PublicProductServicePublicFavoriteProductResult = map[int16]string{
	0: "success",
}

func (p *PublicProductServicePublicFavoriteProductResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PublicProductServicePublicFavoriteProductResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicFavoriteProductResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicFavoriteProductResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewFavoriteProductResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PublicProductServicePublicFavoriteProductResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicFavoriteProduct_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicFavoriteProductResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PublicProductServicePublicFavoriteProductResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicFavoriteProductResult(%+v)", *p)

}

type PublicProductServicePublicGetUserFavoriteListV2Args struct {
	Req *GetUserFavoriteListV2Request `thrift:"req,1"`
}

func NewPublicProductServicePublicGetUserFavoriteListV2Args() *PublicProductServicePublicGetUserFavoriteListV2Args {
	return &PublicProductServicePublicGetUserFavoriteListV2Args{}
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) InitDefault() {
}

var PublicProductServicePublicGetUserFavoriteListV2Args_Req_DEFAULT *GetUserFavoriteListV2Request

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) GetReq() (v *GetUserFavoriteListV2Request) {
	if !p.IsSetReq() {
		return PublicProductServicePublicGetUserFavoriteListV2Args_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_PublicProductServicePublicGetUserFavoriteListV2Args = map[int16]string{
	1: "req",
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) IsSetReq() bool {
	return p.Req != nil
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicGetUserFavoriteListV2Args[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetUserFavoriteListV2Request()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicGetUserFavoriteListV2_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Args) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicGetUserFavoriteListV2Args(%+v)", *p)

}

type PublicProductServicePublicGetUserFavoriteListV2Result struct {
	Success *GetUserFavoriteListV2Response `thrift:"success,0,optional"`
}

func NewPublicProductServicePublicGetUserFavoriteListV2Result() *PublicProductServicePublicGetUserFavoriteListV2Result {
	return &PublicProductServicePublicGetUserFavoriteListV2Result{}
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) InitDefault() {
}

var PublicProductServicePublicGetUserFavoriteListV2Result_Success_DEFAULT *GetUserFavoriteListV2Response

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) GetSuccess() (v *GetUserFavoriteListV2Response) {
	if !p.IsSetSuccess() {
		return PublicProductServicePublicGetUserFavoriteListV2Result_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PublicProductServicePublicGetUserFavoriteListV2Result = map[int16]string{
	0: "success",
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicGetUserFavoriteListV2Result[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetUserFavoriteListV2Response()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicGetUserFavoriteListV2_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PublicProductServicePublicGetUserFavoriteListV2Result) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicGetUserFavoriteListV2Result(%+v)", *p)

}

type PublicProductServicePublicDuplicateProductArgs struct {
	Req *DuplicateProductRequest `thrift:"req,1"`
}

func NewPublicProductServicePublicDuplicateProductArgs() *PublicProductServicePublicDuplicateProductArgs {
	return &PublicProductServicePublicDuplicateProductArgs{}
}

func (p *PublicProductServicePublicDuplicateProductArgs) InitDefault() {
}

var PublicProductServicePublicDuplicateProductArgs_Req_DEFAULT *DuplicateProductRequest

func (p *PublicProductServicePublicDuplicateProductArgs) GetReq() (v *DuplicateProductRequest) {
	if !p.IsSetReq() {
		return PublicProductServicePublicDuplicateProductArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_PublicProductServicePublicDuplicateProductArgs = map[int16]string{
	1: "req",
}

func (p *PublicProductServicePublicDuplicateProductArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *PublicProductServicePublicDuplicateProductArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicDuplicateProductArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicDuplicateProductArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDuplicateProductRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *PublicProductServicePublicDuplicateProductArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicDuplicateProduct_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicDuplicateProductArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PublicProductServicePublicDuplicateProductArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicDuplicateProductArgs(%+v)", *p)

}

type PublicProductServicePublicDuplicateProductResult struct {
	Success *DuplicateProductResponse `thrift:"success,0,optional"`
}

func NewPublicProductServicePublicDuplicateProductResult() *PublicProductServicePublicDuplicateProductResult {
	return &PublicProductServicePublicDuplicateProductResult{}
}

func (p *PublicProductServicePublicDuplicateProductResult) InitDefault() {
}

var PublicProductServicePublicDuplicateProductResult_Success_DEFAULT *DuplicateProductResponse

func (p *PublicProductServicePublicDuplicateProductResult) GetSuccess() (v *DuplicateProductResponse) {
	if !p.IsSetSuccess() {
		return PublicProductServicePublicDuplicateProductResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PublicProductServicePublicDuplicateProductResult = map[int16]string{
	0: "success",
}

func (p *PublicProductServicePublicDuplicateProductResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PublicProductServicePublicDuplicateProductResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublicProductServicePublicDuplicateProductResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublicProductServicePublicDuplicateProductResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDuplicateProductResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PublicProductServicePublicDuplicateProductResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublicDuplicateProduct_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublicProductServicePublicDuplicateProductResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PublicProductServicePublicDuplicateProductResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublicProductServicePublicDuplicateProductResult(%+v)", *p)

}
