// Code generated by thriftgo (0.4.1). DO NOT EDIT.

package developer_api

import (
	"context"
	"database/sql"
	"database/sql/driver"
	"fmt"
	"github.com/apache/thrift/lib/go/thrift"
	"github.com/coze-dev/coze-studio/backend/api/model/ocean/cloud/bot_common"
	"github.com/coze-dev/coze-studio/backend/api/model/ocean/cloud/playground"
)

type VisibilityType int64

const (
	// invisible
	VisibilityType_Invisible VisibilityType = 0
	// visible
	VisibilityType_Visible VisibilityType = 1
)

func (p VisibilityType) String() string {
	switch p {
	case VisibilityType_Invisible:
		return "Invisible"
	case VisibilityType_Visible:
		return "Visible"
	}
	return "<UNSET>"
}

func VisibilityTypeFromString(s string) (VisibilityType, error) {
	switch s {
	case "Invisible":
		return VisibilityType_Invisible, nil
	case "Visible":
		return VisibilityType_Visible, nil
	}
	return VisibilityType(0), fmt.Errorf("not a valid VisibilityType string")
}

func VisibilityTypePtr(v VisibilityType) *VisibilityType { return &v }
func (p *VisibilityType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = VisibilityType(result.Int64)
	return
}

func (p *VisibilityType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// draft bot display info
type TabStatus int64

const (
	TabStatus_Default TabStatus = 0
	TabStatus_Open    TabStatus = 1
	TabStatus_Close   TabStatus = 2
	TabStatus_Hide    TabStatus = 3
)

func (p TabStatus) String() string {
	switch p {
	case TabStatus_Default:
		return "Default"
	case TabStatus_Open:
		return "Open"
	case TabStatus_Close:
		return "Close"
	case TabStatus_Hide:
		return "Hide"
	}
	return "<UNSET>"
}

func TabStatusFromString(s string) (TabStatus, error) {
	switch s {
	case "Default":
		return TabStatus_Default, nil
	case "Open":
		return TabStatus_Open, nil
	case "Close":
		return TabStatus_Close, nil
	case "Hide":
		return TabStatus_Hide, nil
	}
	return TabStatus(0), fmt.Errorf("not a valid TabStatus string")
}

func TabStatusPtr(v TabStatus) *TabStatus { return &v }
func (p *TabStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = TabStatus(result.Int64)
	return
}

func (p *TabStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type PublishResultStatus int64

const (
	// success
	PublishResultStatus_Success PublishResultStatus = 1
	// fail
	PublishResultStatus_Failed PublishResultStatus = 2
	// in approval
	PublishResultStatus_InReview PublishResultStatus = 3
)

func (p PublishResultStatus) String() string {
	switch p {
	case PublishResultStatus_Success:
		return "Success"
	case PublishResultStatus_Failed:
		return "Failed"
	case PublishResultStatus_InReview:
		return "InReview"
	}
	return "<UNSET>"
}

func PublishResultStatusFromString(s string) (PublishResultStatus, error) {
	switch s {
	case "Success":
		return PublishResultStatus_Success, nil
	case "Failed":
		return PublishResultStatus_Failed, nil
	case "InReview":
		return PublishResultStatus_InReview, nil
	}
	return PublishResultStatus(0), fmt.Errorf("not a valid PublishResultStatus string")
}

func PublishResultStatusPtr(v PublishResultStatus) *PublishResultStatus { return &v }
func (p *PublishResultStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PublishResultStatus(result.Int64)
	return
}

func (p *PublishResultStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type AgentType int64

const (
	AgentType_Start_Agent  AgentType = 0
	AgentType_LLM_Agent    AgentType = 1
	AgentType_Task_Agent   AgentType = 2
	AgentType_Global_Agent AgentType = 3
	AgentType_Bot_Agent    AgentType = 4
)

func (p AgentType) String() string {
	switch p {
	case AgentType_Start_Agent:
		return "Start_Agent"
	case AgentType_LLM_Agent:
		return "LLM_Agent"
	case AgentType_Task_Agent:
		return "Task_Agent"
	case AgentType_Global_Agent:
		return "Global_Agent"
	case AgentType_Bot_Agent:
		return "Bot_Agent"
	}
	return "<UNSET>"
}

func AgentTypeFromString(s string) (AgentType, error) {
	switch s {
	case "Start_Agent":
		return AgentType_Start_Agent, nil
	case "LLM_Agent":
		return AgentType_LLM_Agent, nil
	case "Task_Agent":
		return AgentType_Task_Agent, nil
	case "Global_Agent":
		return AgentType_Global_Agent, nil
	case "Bot_Agent":
		return AgentType_Bot_Agent, nil
	}
	return AgentType(0), fmt.Errorf("not a valid AgentType string")
}

func AgentTypePtr(v AgentType) *AgentType { return &v }
func (p *AgentType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = AgentType(result.Int64)
	return
}

func (p *AgentType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ReferenceInfoStatus int64

const (
	// 1: Updates are available
	ReferenceInfoStatus_HasUpdates ReferenceInfoStatus = 1
	// 2: Deleted
	ReferenceInfoStatus_IsDelete ReferenceInfoStatus = 2
)

func (p ReferenceInfoStatus) String() string {
	switch p {
	case ReferenceInfoStatus_HasUpdates:
		return "HasUpdates"
	case ReferenceInfoStatus_IsDelete:
		return "IsDelete"
	}
	return "<UNSET>"
}

func ReferenceInfoStatusFromString(s string) (ReferenceInfoStatus, error) {
	switch s {
	case "HasUpdates":
		return ReferenceInfoStatus_HasUpdates, nil
	case "IsDelete":
		return ReferenceInfoStatus_IsDelete, nil
	}
	return ReferenceInfoStatus(0), fmt.Errorf("not a valid ReferenceInfoStatus string")
}

func ReferenceInfoStatusPtr(v ReferenceInfoStatus) *ReferenceInfoStatus { return &v }
func (p *ReferenceInfoStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ReferenceInfoStatus(result.Int64)
	return
}

func (p *ReferenceInfoStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ReferenceUpdateType int64

const (
	ReferenceUpdateType_ManualUpdate ReferenceUpdateType = 1
	ReferenceUpdateType_AutoUpdate   ReferenceUpdateType = 2
)

func (p ReferenceUpdateType) String() string {
	switch p {
	case ReferenceUpdateType_ManualUpdate:
		return "ManualUpdate"
	case ReferenceUpdateType_AutoUpdate:
		return "AutoUpdate"
	}
	return "<UNSET>"
}

func ReferenceUpdateTypeFromString(s string) (ReferenceUpdateType, error) {
	switch s {
	case "ManualUpdate":
		return ReferenceUpdateType_ManualUpdate, nil
	case "AutoUpdate":
		return ReferenceUpdateType_AutoUpdate, nil
	}
	return ReferenceUpdateType(0), fmt.Errorf("not a valid ReferenceUpdateType string")
}

func ReferenceUpdateTypePtr(v ReferenceUpdateType) *ReferenceUpdateType { return &v }
func (p *ReferenceUpdateType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ReferenceUpdateType(result.Int64)
	return
}

func (p *ReferenceUpdateType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BacktrackMode int64

const (
	BacktrackMode_Current      BacktrackMode = 1
	BacktrackMode_Previous     BacktrackMode = 2
	BacktrackMode_Start        BacktrackMode = 3
	BacktrackMode_MostSuitable BacktrackMode = 4
)

func (p BacktrackMode) String() string {
	switch p {
	case BacktrackMode_Current:
		return "Current"
	case BacktrackMode_Previous:
		return "Previous"
	case BacktrackMode_Start:
		return "Start"
	case BacktrackMode_MostSuitable:
		return "MostSuitable"
	}
	return "<UNSET>"
}

func BacktrackModeFromString(s string) (BacktrackMode, error) {
	switch s {
	case "Current":
		return BacktrackMode_Current, nil
	case "Previous":
		return BacktrackMode_Previous, nil
	case "Start":
		return BacktrackMode_Start, nil
	case "MostSuitable":
		return BacktrackMode_MostSuitable, nil
	}
	return BacktrackMode(0), fmt.Errorf("not a valid BacktrackMode string")
}

func BacktrackModePtr(v BacktrackMode) *BacktrackMode { return &v }
func (p *BacktrackMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BacktrackMode(result.Int64)
	return
}

func (p *BacktrackMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type RecognitionMode int64

const (
	RecognitionMode_FunctionCall RecognitionMode = 1
	RecognitionMode_Independent  RecognitionMode = 2
)

func (p RecognitionMode) String() string {
	switch p {
	case RecognitionMode_FunctionCall:
		return "FunctionCall"
	case RecognitionMode_Independent:
		return "Independent"
	}
	return "<UNSET>"
}

func RecognitionModeFromString(s string) (RecognitionMode, error) {
	switch s {
	case "FunctionCall":
		return RecognitionMode_FunctionCall, nil
	case "Independent":
		return RecognitionMode_Independent, nil
	}
	return RecognitionMode(0), fmt.Errorf("not a valid RecognitionMode string")
}

func RecognitionModePtr(v RecognitionMode) *RecognitionMode { return &v }
func (p *RecognitionMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = RecognitionMode(result.Int64)
	return
}

func (p *RecognitionMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type IndependentTiming int64

const (
	// Determine user input (front)
	IndependentTiming_Pre IndependentTiming = 1
	// Determine node output (postfix)
	IndependentTiming_Post IndependentTiming = 2
	// Front mode and rear mode support simultaneous selection
	IndependentTiming_PreAndPost IndependentTiming = 3
)

func (p IndependentTiming) String() string {
	switch p {
	case IndependentTiming_Pre:
		return "Pre"
	case IndependentTiming_Post:
		return "Post"
	case IndependentTiming_PreAndPost:
		return "PreAndPost"
	}
	return "<UNSET>"
}

func IndependentTimingFromString(s string) (IndependentTiming, error) {
	switch s {
	case "Pre":
		return IndependentTiming_Pre, nil
	case "Post":
		return IndependentTiming_Post, nil
	case "PreAndPost":
		return IndependentTiming_PreAndPost, nil
	}
	return IndependentTiming(0), fmt.Errorf("not a valid IndependentTiming string")
}

func IndependentTimingPtr(v IndependentTiming) *IndependentTiming { return &v }
func (p *IndependentTiming) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = IndependentTiming(result.Int64)
	return
}

func (p *IndependentTiming) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type IndependentRecognitionModelType int64

const (
	// Small model
	IndependentRecognitionModelType_SLM IndependentRecognitionModelType = 0
	// Large model
	IndependentRecognitionModelType_LLM IndependentRecognitionModelType = 1
)

func (p IndependentRecognitionModelType) String() string {
	switch p {
	case IndependentRecognitionModelType_SLM:
		return "SLM"
	case IndependentRecognitionModelType_LLM:
		return "LLM"
	}
	return "<UNSET>"
}

func IndependentRecognitionModelTypeFromString(s string) (IndependentRecognitionModelType, error) {
	switch s {
	case "SLM":
		return IndependentRecognitionModelType_SLM, nil
	case "LLM":
		return IndependentRecognitionModelType_LLM, nil
	}
	return IndependentRecognitionModelType(0), fmt.Errorf("not a valid IndependentRecognitionModelType string")
}

func IndependentRecognitionModelTypePtr(v IndependentRecognitionModelType) *IndependentRecognitionModelType {
	return &v
}
func (p *IndependentRecognitionModelType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = IndependentRecognitionModelType(result.Int64)
	return
}

func (p *IndependentRecognitionModelType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type PublishType int64

const (
	PublishType_OnlinePublish PublishType = 0
	PublishType_PrePublish    PublishType = 1
)

func (p PublishType) String() string {
	switch p {
	case PublishType_OnlinePublish:
		return "OnlinePublish"
	case PublishType_PrePublish:
		return "PrePublish"
	}
	return "<UNSET>"
}

func PublishTypeFromString(s string) (PublishType, error) {
	switch s {
	case "OnlinePublish":
		return PublishType_OnlinePublish, nil
	case "PrePublish":
		return PublishType_PrePublish, nil
	}
	return PublishType(0), fmt.Errorf("not a valid PublishType string")
}

func PublishTypePtr(v PublishType) *PublishType { return &v }
func (p *PublishType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PublishType(result.Int64)
	return
}

func (p *PublishType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BotMode int64

const (
	BotMode_SingleMode   BotMode = 0
	BotMode_MultiMode    BotMode = 1
	BotMode_WorkflowMode BotMode = 2
)

func (p BotMode) String() string {
	switch p {
	case BotMode_SingleMode:
		return "SingleMode"
	case BotMode_MultiMode:
		return "MultiMode"
	case BotMode_WorkflowMode:
		return "WorkflowMode"
	}
	return "<UNSET>"
}

func BotModeFromString(s string) (BotMode, error) {
	switch s {
	case "SingleMode":
		return BotMode_SingleMode, nil
	case "MultiMode":
		return BotMode_MultiMode, nil
	case "WorkflowMode":
		return BotMode_WorkflowMode, nil
	}
	return BotMode(0), fmt.Errorf("not a valid BotMode string")
}

func BotModePtr(v BotMode) *BotMode { return &v }
func (p *BotMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BotMode(result.Int64)
	return
}

func (p *BotMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type HistoryType int64

const (
	// abandoned
	HistoryType_SUBMIT HistoryType = 1
	// publish
	HistoryType_FLAG HistoryType = 2
	// submit
	HistoryType_COMMIT HistoryType = 4
	// Submit and publish
	HistoryType_COMMITANDFLAG HistoryType = 5
)

func (p HistoryType) String() string {
	switch p {
	case HistoryType_SUBMIT:
		return "SUBMIT"
	case HistoryType_FLAG:
		return "FLAG"
	case HistoryType_COMMIT:
		return "COMMIT"
	case HistoryType_COMMITANDFLAG:
		return "COMMITANDFLAG"
	}
	return "<UNSET>"
}

func HistoryTypeFromString(s string) (HistoryType, error) {
	switch s {
	case "SUBMIT":
		return HistoryType_SUBMIT, nil
	case "FLAG":
		return HistoryType_FLAG, nil
	case "COMMIT":
		return HistoryType_COMMIT, nil
	case "COMMITANDFLAG":
		return HistoryType_COMMITANDFLAG, nil
	}
	return HistoryType(0), fmt.Errorf("not a valid HistoryType string")
}

func HistoryTypePtr(v HistoryType) *HistoryType { return &v }
func (p *HistoryType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = HistoryType(result.Int64)
	return
}

func (p *HistoryType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ConnectorDynamicStatus int64

const (
	ConnectorDynamicStatus_Normal          ConnectorDynamicStatus = 0
	ConnectorDynamicStatus_Offline         ConnectorDynamicStatus = 1
	ConnectorDynamicStatus_TokenDisconnect ConnectorDynamicStatus = 2
)

func (p ConnectorDynamicStatus) String() string {
	switch p {
	case ConnectorDynamicStatus_Normal:
		return "Normal"
	case ConnectorDynamicStatus_Offline:
		return "Offline"
	case ConnectorDynamicStatus_TokenDisconnect:
		return "TokenDisconnect"
	}
	return "<UNSET>"
}

func ConnectorDynamicStatusFromString(s string) (ConnectorDynamicStatus, error) {
	switch s {
	case "Normal":
		return ConnectorDynamicStatus_Normal, nil
	case "Offline":
		return ConnectorDynamicStatus_Offline, nil
	case "TokenDisconnect":
		return ConnectorDynamicStatus_TokenDisconnect, nil
	}
	return ConnectorDynamicStatus(0), fmt.Errorf("not a valid ConnectorDynamicStatus string")
}

func ConnectorDynamicStatusPtr(v ConnectorDynamicStatus) *ConnectorDynamicStatus { return &v }
func (p *ConnectorDynamicStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ConnectorDynamicStatus(result.Int64)
	return
}

func (p *ConnectorDynamicStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type IconType int64

const (
	IconType_Bot        IconType = 1
	IconType_User       IconType = 2
	IconType_Plugin     IconType = 3
	IconType_Dataset    IconType = 4
	IconType_Space      IconType = 5
	IconType_Workflow   IconType = 6
	IconType_Imageflow  IconType = 7
	IconType_Society    IconType = 8
	IconType_Connector  IconType = 9
	IconType_ChatFlow   IconType = 10
	IconType_Voice      IconType = 11
	IconType_Enterprise IconType = 12
)

func (p IconType) String() string {
	switch p {
	case IconType_Bot:
		return "Bot"
	case IconType_User:
		return "User"
	case IconType_Plugin:
		return "Plugin"
	case IconType_Dataset:
		return "Dataset"
	case IconType_Space:
		return "Space"
	case IconType_Workflow:
		return "Workflow"
	case IconType_Imageflow:
		return "Imageflow"
	case IconType_Society:
		return "Society"
	case IconType_Connector:
		return "Connector"
	case IconType_ChatFlow:
		return "ChatFlow"
	case IconType_Voice:
		return "Voice"
	case IconType_Enterprise:
		return "Enterprise"
	}
	return "<UNSET>"
}

func IconTypeFromString(s string) (IconType, error) {
	switch s {
	case "Bot":
		return IconType_Bot, nil
	case "User":
		return IconType_User, nil
	case "Plugin":
		return IconType_Plugin, nil
	case "Dataset":
		return IconType_Dataset, nil
	case "Space":
		return IconType_Space, nil
	case "Workflow":
		return IconType_Workflow, nil
	case "Imageflow":
		return IconType_Imageflow, nil
	case "Society":
		return IconType_Society, nil
	case "Connector":
		return IconType_Connector, nil
	case "ChatFlow":
		return IconType_ChatFlow, nil
	case "Voice":
		return IconType_Voice, nil
	case "Enterprise":
		return IconType_Enterprise, nil
	}
	return IconType(0), fmt.Errorf("not a valid IconType string")
}

func IconTypePtr(v IconType) *IconType { return &v }
func (p *IconType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = IconType(result.Int64)
	return
}

func (p *IconType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type FileBizType int64

const (
	FileBizType_BIZ_UNKNOWN            FileBizType = 0
	FileBizType_BIZ_BOT_ICON           FileBizType = 1
	FileBizType_BIZ_BOT_DATASET        FileBizType = 2
	FileBizType_BIZ_DATASET_ICON       FileBizType = 3
	FileBizType_BIZ_PLUGIN_ICON        FileBizType = 4
	FileBizType_BIZ_BOT_SPACE          FileBizType = 5
	FileBizType_BIZ_BOT_WORKFLOW       FileBizType = 6
	FileBizType_BIZ_SOCIETY_ICON       FileBizType = 7
	FileBizType_BIZ_CONNECTOR_ICON     FileBizType = 8
	FileBizType_BIZ_LIBRARY_VOICE_ICON FileBizType = 9
	FileBizType_BIZ_ENTERPRISE_ICON    FileBizType = 10
)

func (p FileBizType) String() string {
	switch p {
	case FileBizType_BIZ_UNKNOWN:
		return "BIZ_UNKNOWN"
	case FileBizType_BIZ_BOT_ICON:
		return "BIZ_BOT_ICON"
	case FileBizType_BIZ_BOT_DATASET:
		return "BIZ_BOT_DATASET"
	case FileBizType_BIZ_DATASET_ICON:
		return "BIZ_DATASET_ICON"
	case FileBizType_BIZ_PLUGIN_ICON:
		return "BIZ_PLUGIN_ICON"
	case FileBizType_BIZ_BOT_SPACE:
		return "BIZ_BOT_SPACE"
	case FileBizType_BIZ_BOT_WORKFLOW:
		return "BIZ_BOT_WORKFLOW"
	case FileBizType_BIZ_SOCIETY_ICON:
		return "BIZ_SOCIETY_ICON"
	case FileBizType_BIZ_CONNECTOR_ICON:
		return "BIZ_CONNECTOR_ICON"
	case FileBizType_BIZ_LIBRARY_VOICE_ICON:
		return "BIZ_LIBRARY_VOICE_ICON"
	case FileBizType_BIZ_ENTERPRISE_ICON:
		return "BIZ_ENTERPRISE_ICON"
	}
	return "<UNSET>"
}

func FileBizTypeFromString(s string) (FileBizType, error) {
	switch s {
	case "BIZ_UNKNOWN":
		return FileBizType_BIZ_UNKNOWN, nil
	case "BIZ_BOT_ICON":
		return FileBizType_BIZ_BOT_ICON, nil
	case "BIZ_BOT_DATASET":
		return FileBizType_BIZ_BOT_DATASET, nil
	case "BIZ_DATASET_ICON":
		return FileBizType_BIZ_DATASET_ICON, nil
	case "BIZ_PLUGIN_ICON":
		return FileBizType_BIZ_PLUGIN_ICON, nil
	case "BIZ_BOT_SPACE":
		return FileBizType_BIZ_BOT_SPACE, nil
	case "BIZ_BOT_WORKFLOW":
		return FileBizType_BIZ_BOT_WORKFLOW, nil
	case "BIZ_SOCIETY_ICON":
		return FileBizType_BIZ_SOCIETY_ICON, nil
	case "BIZ_CONNECTOR_ICON":
		return FileBizType_BIZ_CONNECTOR_ICON, nil
	case "BIZ_LIBRARY_VOICE_ICON":
		return FileBizType_BIZ_LIBRARY_VOICE_ICON, nil
	case "BIZ_ENTERPRISE_ICON":
		return FileBizType_BIZ_ENTERPRISE_ICON, nil
	}
	return FileBizType(0), fmt.Errorf("not a valid FileBizType string")
}

func FileBizTypePtr(v FileBizType) *FileBizType { return &v }
func (p *FileBizType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = FileBizType(result.Int64)
	return
}

func (p *FileBizType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ModelScene int64

const (
	ModelScene_Douyin ModelScene = 1
)

func (p ModelScene) String() string {
	switch p {
	case ModelScene_Douyin:
		return "Douyin"
	}
	return "<UNSET>"
}

func ModelSceneFromString(s string) (ModelScene, error) {
	switch s {
	case "Douyin":
		return ModelScene_Douyin, nil
	}
	return ModelScene(0), fmt.Errorf("not a valid ModelScene string")
}

func ModelScenePtr(v ModelScene) *ModelScene { return &v }
func (p *ModelScene) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ModelScene(result.Int64)
	return
}

func (p *ModelScene) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ModelClass int64

const (
	ModelClass_GPT    ModelClass = 1
	ModelClass_SEED   ModelClass = 2
	ModelClass_Claude ModelClass = 3
	// name: MiniMax
	ModelClass_MiniMax         ModelClass = 4
	ModelClass_Plugin          ModelClass = 5
	ModelClass_StableDiffusion ModelClass = 6
	ModelClass_ByteArtist      ModelClass = 7
	ModelClass_Maas            ModelClass = 9
	// Abandoned: Qianfan (Baidu Cloud)
	ModelClass_QianFan ModelClass = 10
	// name：Google Gemini
	ModelClass_Gemini ModelClass = 11
	// name: Moonshot
	ModelClass_Moonshot ModelClass = 12
	// Name: Zhipu
	ModelClass_GLM ModelClass = 13
	// Name: Volcano Ark
	ModelClass_MaaSAutoSync ModelClass = 14
	// Name: Tongyi Qianwen
	ModelClass_QWen ModelClass = 15
	// name: Cohere
	ModelClass_Cohere ModelClass = 16
	// Name: Baichuan Intelligent
	ModelClass_Baichuan ModelClass = 17
	// Name: ERNIE Bot
	ModelClass_Ernie ModelClass = 18
	// Name: Magic Square
	ModelClass_DeekSeek ModelClass = 19
	// name: Llama
	ModelClass_Llama   ModelClass = 20
	ModelClass_StepFun ModelClass = 23
	ModelClass_Other   ModelClass = 999
)

func (p ModelClass) String() string {
	switch p {
	case ModelClass_GPT:
		return "GPT"
	case ModelClass_SEED:
		return "SEED"
	case ModelClass_Claude:
		return "Claude"
	case ModelClass_MiniMax:
		return "MiniMax"
	case ModelClass_Plugin:
		return "Plugin"
	case ModelClass_StableDiffusion:
		return "StableDiffusion"
	case ModelClass_ByteArtist:
		return "ByteArtist"
	case ModelClass_Maas:
		return "Maas"
	case ModelClass_QianFan:
		return "QianFan"
	case ModelClass_Gemini:
		return "Gemini"
	case ModelClass_Moonshot:
		return "Moonshot"
	case ModelClass_GLM:
		return "GLM"
	case ModelClass_MaaSAutoSync:
		return "MaaSAutoSync"
	case ModelClass_QWen:
		return "QWen"
	case ModelClass_Cohere:
		return "Cohere"
	case ModelClass_Baichuan:
		return "Baichuan"
	case ModelClass_Ernie:
		return "Ernie"
	case ModelClass_DeekSeek:
		return "DeekSeek"
	case ModelClass_Llama:
		return "Llama"
	case ModelClass_StepFun:
		return "StepFun"
	case ModelClass_Other:
		return "Other"
	}
	return "<UNSET>"
}

func ModelClassFromString(s string) (ModelClass, error) {
	switch s {
	case "GPT":
		return ModelClass_GPT, nil
	case "SEED":
		return ModelClass_SEED, nil
	case "Claude":
		return ModelClass_Claude, nil
	case "MiniMax":
		return ModelClass_MiniMax, nil
	case "Plugin":
		return ModelClass_Plugin, nil
	case "StableDiffusion":
		return ModelClass_StableDiffusion, nil
	case "ByteArtist":
		return ModelClass_ByteArtist, nil
	case "Maas":
		return ModelClass_Maas, nil
	case "QianFan":
		return ModelClass_QianFan, nil
	case "Gemini":
		return ModelClass_Gemini, nil
	case "Moonshot":
		return ModelClass_Moonshot, nil
	case "GLM":
		return ModelClass_GLM, nil
	case "MaaSAutoSync":
		return ModelClass_MaaSAutoSync, nil
	case "QWen":
		return ModelClass_QWen, nil
	case "Cohere":
		return ModelClass_Cohere, nil
	case "Baichuan":
		return ModelClass_Baichuan, nil
	case "Ernie":
		return ModelClass_Ernie, nil
	case "DeekSeek":
		return ModelClass_DeekSeek, nil
	case "Llama":
		return ModelClass_Llama, nil
	case "StepFun":
		return ModelClass_StepFun, nil
	case "Other":
		return ModelClass_Other, nil
	}
	return ModelClass(0), fmt.Errorf("not a valid ModelClass string")
}

func ModelClassPtr(v ModelClass) *ModelClass { return &v }
func (p *ModelClass) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ModelClass(result.Int64)
	return
}

func (p *ModelClass) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ModelTagClass int64

const (
	ModelTagClass_ModelType      ModelTagClass = 1
	ModelTagClass_ModelUserRight ModelTagClass = 2
	ModelTagClass_ModelFeature   ModelTagClass = 3
	ModelTagClass_ModelFunction  ModelTagClass = 4
	// Do not do this issue
	ModelTagClass_Custom ModelTagClass = 20
	ModelTagClass_Others ModelTagClass = 100
)

func (p ModelTagClass) String() string {
	switch p {
	case ModelTagClass_ModelType:
		return "ModelType"
	case ModelTagClass_ModelUserRight:
		return "ModelUserRight"
	case ModelTagClass_ModelFeature:
		return "ModelFeature"
	case ModelTagClass_ModelFunction:
		return "ModelFunction"
	case ModelTagClass_Custom:
		return "Custom"
	case ModelTagClass_Others:
		return "Others"
	}
	return "<UNSET>"
}

func ModelTagClassFromString(s string) (ModelTagClass, error) {
	switch s {
	case "ModelType":
		return ModelTagClass_ModelType, nil
	case "ModelUserRight":
		return ModelTagClass_ModelUserRight, nil
	case "ModelFeature":
		return ModelTagClass_ModelFeature, nil
	case "ModelFunction":
		return ModelTagClass_ModelFunction, nil
	case "Custom":
		return ModelTagClass_Custom, nil
	case "Others":
		return ModelTagClass_Others, nil
	}
	return ModelTagClass(0), fmt.Errorf("not a valid ModelTagClass string")
}

func ModelTagClassPtr(v ModelTagClass) *ModelTagClass { return &v }
func (p *ModelTagClass) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ModelTagClass(result.Int64)
	return
}

func (p *ModelTagClass) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ModelParamType int64

const (
	ModelParamType_Float   ModelParamType = 1
	ModelParamType_Int     ModelParamType = 2
	ModelParamType_Boolean ModelParamType = 3
	ModelParamType_String  ModelParamType = 4
)

func (p ModelParamType) String() string {
	switch p {
	case ModelParamType_Float:
		return "Float"
	case ModelParamType_Int:
		return "Int"
	case ModelParamType_Boolean:
		return "Boolean"
	case ModelParamType_String:
		return "String"
	}
	return "<UNSET>"
}

func ModelParamTypeFromString(s string) (ModelParamType, error) {
	switch s {
	case "Float":
		return ModelParamType_Float, nil
	case "Int":
		return ModelParamType_Int, nil
	case "Boolean":
		return ModelParamType_Boolean, nil
	case "String":
		return ModelParamType_String, nil
	}
	return ModelParamType(0), fmt.Errorf("not a valid ModelParamType string")
}

func ModelParamTypePtr(v ModelParamType) *ModelParamType { return &v }
func (p *ModelParamType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ModelParamType(result.Int64)
	return
}

func (p *ModelParamType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ModelTagValue int64

const (
	ModelTagValue_Flagship           ModelTagValue = 1
	ModelTagValue_HighSpeed          ModelTagValue = 2
	ModelTagValue_ToolInvocation     ModelTagValue = 3
	ModelTagValue_RolePlaying        ModelTagValue = 4
	ModelTagValue_LongText           ModelTagValue = 5
	ModelTagValue_ImageUnderstanding ModelTagValue = 6
	ModelTagValue_Reasoning          ModelTagValue = 7
	ModelTagValue_VideoUnderstanding ModelTagValue = 8
	ModelTagValue_CostPerformance    ModelTagValue = 9
	ModelTagValue_CodeSpecialization ModelTagValue = 10
	ModelTagValue_AudioUnderstanding ModelTagValue = 11
)

func (p ModelTagValue) String() string {
	switch p {
	case ModelTagValue_Flagship:
		return "Flagship"
	case ModelTagValue_HighSpeed:
		return "HighSpeed"
	case ModelTagValue_ToolInvocation:
		return "ToolInvocation"
	case ModelTagValue_RolePlaying:
		return "RolePlaying"
	case ModelTagValue_LongText:
		return "LongText"
	case ModelTagValue_ImageUnderstanding:
		return "ImageUnderstanding"
	case ModelTagValue_Reasoning:
		return "Reasoning"
	case ModelTagValue_VideoUnderstanding:
		return "VideoUnderstanding"
	case ModelTagValue_CostPerformance:
		return "CostPerformance"
	case ModelTagValue_CodeSpecialization:
		return "CodeSpecialization"
	case ModelTagValue_AudioUnderstanding:
		return "AudioUnderstanding"
	}
	return "<UNSET>"
}

func ModelTagValueFromString(s string) (ModelTagValue, error) {
	switch s {
	case "Flagship":
		return ModelTagValue_Flagship, nil
	case "HighSpeed":
		return ModelTagValue_HighSpeed, nil
	case "ToolInvocation":
		return ModelTagValue_ToolInvocation, nil
	case "RolePlaying":
		return ModelTagValue_RolePlaying, nil
	case "LongText":
		return ModelTagValue_LongText, nil
	case "ImageUnderstanding":
		return ModelTagValue_ImageUnderstanding, nil
	case "Reasoning":
		return ModelTagValue_Reasoning, nil
	case "VideoUnderstanding":
		return ModelTagValue_VideoUnderstanding, nil
	case "CostPerformance":
		return ModelTagValue_CostPerformance, nil
	case "CodeSpecialization":
		return ModelTagValue_CodeSpecialization, nil
	case "AudioUnderstanding":
		return ModelTagValue_AudioUnderstanding, nil
	}
	return ModelTagValue(0), fmt.Errorf("not a valid ModelTagValue string")
}

func ModelTagValuePtr(v ModelTagValue) *ModelTagValue { return &v }
func (p *ModelTagValue) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ModelTagValue(result.Int64)
	return
}

func (p *ModelTagValue) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type CommitStatus int64

const (
	CommitStatus_Undefined CommitStatus = 0
	// It is the latest, the same as the main draft
	CommitStatus_Uptodate CommitStatus = 1
	// Behind the main draft
	CommitStatus_Behind CommitStatus = 2
	// No personal draft
	CommitStatus_NoDraftReplica CommitStatus = 3
)

func (p CommitStatus) String() string {
	switch p {
	case CommitStatus_Undefined:
		return "Undefined"
	case CommitStatus_Uptodate:
		return "Uptodate"
	case CommitStatus_Behind:
		return "Behind"
	case CommitStatus_NoDraftReplica:
		return "NoDraftReplica"
	}
	return "<UNSET>"
}

func CommitStatusFromString(s string) (CommitStatus, error) {
	switch s {
	case "Undefined":
		return CommitStatus_Undefined, nil
	case "Uptodate":
		return CommitStatus_Uptodate, nil
	case "Behind":
		return CommitStatus_Behind, nil
	case "NoDraftReplica":
		return CommitStatus_NoDraftReplica, nil
	}
	return CommitStatus(0), fmt.Errorf("not a valid CommitStatus string")
}

func CommitStatusPtr(v CommitStatus) *CommitStatus { return &v }
func (p *CommitStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = CommitStatus(result.Int64)
	return
}

func (p *CommitStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ConfigStatus int64

const (
	// Configured
	ConfigStatus_Configured ConfigStatus = 1
	// Not configured
	ConfigStatus_NotConfigured ConfigStatus = 2
	// Token changes
	ConfigStatus_Disconnected ConfigStatus = 3
	// Configuring, authorizing
	ConfigStatus_Configuring ConfigStatus = 4
	// Need to reconfigure
	ConfigStatus_NeedReconfiguring ConfigStatus = 5
)

func (p ConfigStatus) String() string {
	switch p {
	case ConfigStatus_Configured:
		return "Configured"
	case ConfigStatus_NotConfigured:
		return "NotConfigured"
	case ConfigStatus_Disconnected:
		return "Disconnected"
	case ConfigStatus_Configuring:
		return "Configuring"
	case ConfigStatus_NeedReconfiguring:
		return "NeedReconfiguring"
	}
	return "<UNSET>"
}

func ConfigStatusFromString(s string) (ConfigStatus, error) {
	switch s {
	case "Configured":
		return ConfigStatus_Configured, nil
	case "NotConfigured":
		return ConfigStatus_NotConfigured, nil
	case "Disconnected":
		return ConfigStatus_Disconnected, nil
	case "Configuring":
		return ConfigStatus_Configuring, nil
	case "NeedReconfiguring":
		return ConfigStatus_NeedReconfiguring, nil
	}
	return ConfigStatus(0), fmt.Errorf("not a valid ConfigStatus string")
}

func ConfigStatusPtr(v ConfigStatus) *ConfigStatus { return &v }
func (p *ConfigStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ConfigStatus(result.Int64)
	return
}

func (p *ConfigStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BindType int64

const (
	// No binding required
	BindType_NoBindRequired BindType = 1
	// Auth binding
	BindType_AuthBind BindType = 2
	// Kv binding =
	BindType_KvBind BindType = 3
	// Kv and Auth authorization
	BindType_KvAuthBind BindType = 4
	// API channel binding
	BindType_ApiBind    BindType = 5
	BindType_WebSDKBind BindType = 6
	BindType_StoreBind  BindType = 7
	// One button each for authorization and configuration
	BindType_AuthAndConfig BindType = 8
)

func (p BindType) String() string {
	switch p {
	case BindType_NoBindRequired:
		return "NoBindRequired"
	case BindType_AuthBind:
		return "AuthBind"
	case BindType_KvBind:
		return "KvBind"
	case BindType_KvAuthBind:
		return "KvAuthBind"
	case BindType_ApiBind:
		return "ApiBind"
	case BindType_WebSDKBind:
		return "WebSDKBind"
	case BindType_StoreBind:
		return "StoreBind"
	case BindType_AuthAndConfig:
		return "AuthAndConfig"
	}
	return "<UNSET>"
}

func BindTypeFromString(s string) (BindType, error) {
	switch s {
	case "NoBindRequired":
		return BindType_NoBindRequired, nil
	case "AuthBind":
		return BindType_AuthBind, nil
	case "KvBind":
		return BindType_KvBind, nil
	case "KvAuthBind":
		return BindType_KvAuthBind, nil
	case "ApiBind":
		return BindType_ApiBind, nil
	case "WebSDKBind":
		return BindType_WebSDKBind, nil
	case "StoreBind":
		return BindType_StoreBind, nil
	case "AuthAndConfig":
		return BindType_AuthAndConfig, nil
	}
	return BindType(0), fmt.Errorf("not a valid BindType string")
}

func BindTypePtr(v BindType) *BindType { return &v }
func (p *BindType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BindType(result.Int64)
	return
}

func (p *BindType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type AllowPublishStatus int64

const (
	AllowPublishStatus_Allowed AllowPublishStatus = 0
	AllowPublishStatus_Forbid  AllowPublishStatus = 1
)

func (p AllowPublishStatus) String() string {
	switch p {
	case AllowPublishStatus_Allowed:
		return "Allowed"
	case AllowPublishStatus_Forbid:
		return "Forbid"
	}
	return "<UNSET>"
}

func AllowPublishStatusFromString(s string) (AllowPublishStatus, error) {
	switch s {
	case "Allowed":
		return AllowPublishStatus_Allowed, nil
	case "Forbid":
		return AllowPublishStatus_Forbid, nil
	}
	return AllowPublishStatus(0), fmt.Errorf("not a valid AllowPublishStatus string")
}

func AllowPublishStatusPtr(v AllowPublishStatus) *AllowPublishStatus { return &v }
func (p *AllowPublishStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = AllowPublishStatus(result.Int64)
	return
}

func (p *AllowPublishStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BotConnectorStatus int64

const (
	// Normal
	BotConnectorStatus_Normal BotConnectorStatus = 0
	// Under review.
	BotConnectorStatus_InReview BotConnectorStatus = 1
	// offline
	BotConnectorStatus_Offline BotConnectorStatus = 2
)

func (p BotConnectorStatus) String() string {
	switch p {
	case BotConnectorStatus_Normal:
		return "Normal"
	case BotConnectorStatus_InReview:
		return "InReview"
	case BotConnectorStatus_Offline:
		return "Offline"
	}
	return "<UNSET>"
}

func BotConnectorStatusFromString(s string) (BotConnectorStatus, error) {
	switch s {
	case "Normal":
		return BotConnectorStatus_Normal, nil
	case "InReview":
		return BotConnectorStatus_InReview, nil
	case "Offline":
		return BotConnectorStatus_Offline, nil
	}
	return BotConnectorStatus(0), fmt.Errorf("not a valid BotConnectorStatus string")
}

func BotConnectorStatusPtr(v BotConnectorStatus) *BotConnectorStatus { return &v }
func (p *BotConnectorStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BotConnectorStatus(result.Int64)
	return
}

func (p *BotConnectorStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type UserAuthStatus int64

const (
	// Authorized
	UserAuthStatus_Authorized UserAuthStatus = 1
	// unauthorized
	UserAuthStatus_UnAuthorized UserAuthStatus = 2
	// Authorizing
	UserAuthStatus_Authorizing UserAuthStatus = 3
)

func (p UserAuthStatus) String() string {
	switch p {
	case UserAuthStatus_Authorized:
		return "Authorized"
	case UserAuthStatus_UnAuthorized:
		return "UnAuthorized"
	case UserAuthStatus_Authorizing:
		return "Authorizing"
	}
	return "<UNSET>"
}

func UserAuthStatusFromString(s string) (UserAuthStatus, error) {
	switch s {
	case "Authorized":
		return UserAuthStatus_Authorized, nil
	case "UnAuthorized":
		return UserAuthStatus_UnAuthorized, nil
	case "Authorizing":
		return UserAuthStatus_Authorizing, nil
	}
	return UserAuthStatus(0), fmt.Errorf("not a valid UserAuthStatus string")
}

func UserAuthStatusPtr(v UserAuthStatus) *UserAuthStatus { return &v }
func (p *UserAuthStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = UserAuthStatus(result.Int64)
	return
}

func (p *UserAuthStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type DraftBotCreateRequest struct {
	SpaceID          int64             `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,string,required" query:"space_id,required"`
	Name             string            `thrift:"name,2" form:"name" json:"name" query:"name"`
	Description      string            `thrift:"description,3" form:"description" json:"description" query:"description"`
	IconURI          string            `thrift:"icon_uri,4" form:"icon_uri" json:"icon_uri" query:"icon_uri"`
	Visibility       VisibilityType    `thrift:"visibility,5" form:"visibility" json:"visibility" query:"visibility"`
	MonetizationConf *MonetizationConf `thrift:"monetization_conf,6,optional" form:"monetization_conf" json:"monetization_conf,omitempty" query:"monetization_conf"`
	// Create source navi: navbar space: space
	CreateFrom   *string                  `thrift:"create_from,7,optional" form:"create_from" json:"create_from,omitempty" query:"create_from"`
	BusinessType *bot_common.BusinessType `thrift:"business_type,9,optional" form:"business_type" json:"business_type,omitempty" query:"business_type"`
}

func NewDraftBotCreateRequest() *DraftBotCreateRequest {
	return &DraftBotCreateRequest{}
}

func (p *DraftBotCreateRequest) InitDefault() {
}

func (p *DraftBotCreateRequest) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *DraftBotCreateRequest) GetName() (v string) {
	return p.Name
}

func (p *DraftBotCreateRequest) GetDescription() (v string) {
	return p.Description
}

func (p *DraftBotCreateRequest) GetIconURI() (v string) {
	return p.IconURI
}

func (p *DraftBotCreateRequest) GetVisibility() (v VisibilityType) {
	return p.Visibility
}

var DraftBotCreateRequest_MonetizationConf_DEFAULT *MonetizationConf

func (p *DraftBotCreateRequest) GetMonetizationConf() (v *MonetizationConf) {
	if !p.IsSetMonetizationConf() {
		return DraftBotCreateRequest_MonetizationConf_DEFAULT
	}
	return p.MonetizationConf
}

var DraftBotCreateRequest_CreateFrom_DEFAULT string

func (p *DraftBotCreateRequest) GetCreateFrom() (v string) {
	if !p.IsSetCreateFrom() {
		return DraftBotCreateRequest_CreateFrom_DEFAULT
	}
	return *p.CreateFrom
}

var DraftBotCreateRequest_BusinessType_DEFAULT bot_common.BusinessType

func (p *DraftBotCreateRequest) GetBusinessType() (v bot_common.BusinessType) {
	if !p.IsSetBusinessType() {
		return DraftBotCreateRequest_BusinessType_DEFAULT
	}
	return *p.BusinessType
}

var fieldIDToName_DraftBotCreateRequest = map[int16]string{
	1: "space_id",
	2: "name",
	3: "description",
	4: "icon_uri",
	5: "visibility",
	6: "monetization_conf",
	7: "create_from",
	9: "business_type",
}

func (p *DraftBotCreateRequest) IsSetMonetizationConf() bool {
	return p.MonetizationConf != nil
}

func (p *DraftBotCreateRequest) IsSetCreateFrom() bool {
	return p.CreateFrom != nil
}

func (p *DraftBotCreateRequest) IsSetBusinessType() bool {
	return p.BusinessType != nil
}

func (p *DraftBotCreateRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DraftBotCreateRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DraftBotCreateRequest[fieldId]))
}

func (p *DraftBotCreateRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *DraftBotCreateRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *DraftBotCreateRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *DraftBotCreateRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURI = _field
	return nil
}
func (p *DraftBotCreateRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field VisibilityType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = VisibilityType(v)
	}
	p.Visibility = _field
	return nil
}
func (p *DraftBotCreateRequest) ReadField6(iprot thrift.TProtocol) error {
	_field := NewMonetizationConf()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.MonetizationConf = _field
	return nil
}
func (p *DraftBotCreateRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CreateFrom = _field
	return nil
}
func (p *DraftBotCreateRequest) ReadField9(iprot thrift.TProtocol) error {

	var _field *bot_common.BusinessType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := bot_common.BusinessType(v)
		_field = &tmp
	}
	p.BusinessType = _field
	return nil
}

func (p *DraftBotCreateRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DraftBotCreateRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DraftBotCreateRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DraftBotCreateRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DraftBotCreateRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("description", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *DraftBotCreateRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *DraftBotCreateRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("visibility", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Visibility)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *DraftBotCreateRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetMonetizationConf() {
		if err = oprot.WriteFieldBegin("monetization_conf", thrift.STRUCT, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.MonetizationConf.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *DraftBotCreateRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetCreateFrom() {
		if err = oprot.WriteFieldBegin("create_from", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CreateFrom); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *DraftBotCreateRequest) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetBusinessType() {
		if err = oprot.WriteFieldBegin("business_type", thrift.I32, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.BusinessType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}

func (p *DraftBotCreateRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DraftBotCreateRequest(%+v)", *p)

}

type MonetizationConf struct {
	IsEnable *bool `thrift:"is_enable,1,optional" form:"is_enable" json:"is_enable,omitempty" query:"is_enable"`
}

func NewMonetizationConf() *MonetizationConf {
	return &MonetizationConf{}
}

func (p *MonetizationConf) InitDefault() {
}

var MonetizationConf_IsEnable_DEFAULT bool

func (p *MonetizationConf) GetIsEnable() (v bool) {
	if !p.IsSetIsEnable() {
		return MonetizationConf_IsEnable_DEFAULT
	}
	return *p.IsEnable
}

var fieldIDToName_MonetizationConf = map[int16]string{
	1: "is_enable",
}

func (p *MonetizationConf) IsSetIsEnable() bool {
	return p.IsEnable != nil
}

func (p *MonetizationConf) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_MonetizationConf[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *MonetizationConf) ReadField1(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsEnable = _field
	return nil
}

func (p *MonetizationConf) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MonetizationConf"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *MonetizationConf) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsEnable() {
		if err = oprot.WriteFieldBegin("is_enable", thrift.BOOL, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsEnable); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *MonetizationConf) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MonetizationConf(%+v)", *p)

}

type DraftBotCreateData struct {
	BotID int64 `thrift:"bot_id,1" form:"bot_id" json:"bot_id,string" query:"bot_id"`
	// True: The machine audit verification failed
	CheckNotPass bool `thrift:"check_not_pass,2" form:"check_not_pass" json:"check_not_pass" query:"check_not_pass"`
	// The machine audit verification failed the copy.
	CheckNotPassMsg *string `thrift:"check_not_pass_msg,3,optional" form:"check_not_pass_msg" json:"check_not_pass_msg,omitempty" query:"check_not_pass_msg"`
}

func NewDraftBotCreateData() *DraftBotCreateData {
	return &DraftBotCreateData{}
}

func (p *DraftBotCreateData) InitDefault() {
}

func (p *DraftBotCreateData) GetBotID() (v int64) {
	return p.BotID
}

func (p *DraftBotCreateData) GetCheckNotPass() (v bool) {
	return p.CheckNotPass
}

var DraftBotCreateData_CheckNotPassMsg_DEFAULT string

func (p *DraftBotCreateData) GetCheckNotPassMsg() (v string) {
	if !p.IsSetCheckNotPassMsg() {
		return DraftBotCreateData_CheckNotPassMsg_DEFAULT
	}
	return *p.CheckNotPassMsg
}

var fieldIDToName_DraftBotCreateData = map[int16]string{
	1: "bot_id",
	2: "check_not_pass",
	3: "check_not_pass_msg",
}

func (p *DraftBotCreateData) IsSetCheckNotPassMsg() bool {
	return p.CheckNotPassMsg != nil
}

func (p *DraftBotCreateData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DraftBotCreateData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DraftBotCreateData) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *DraftBotCreateData) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CheckNotPass = _field
	return nil
}
func (p *DraftBotCreateData) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CheckNotPassMsg = _field
	return nil
}

func (p *DraftBotCreateData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DraftBotCreateData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DraftBotCreateData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DraftBotCreateData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("check_not_pass", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.CheckNotPass); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DraftBotCreateData) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCheckNotPassMsg() {
		if err = oprot.WriteFieldBegin("check_not_pass_msg", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CheckNotPassMsg); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *DraftBotCreateData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DraftBotCreateData(%+v)", *p)

}

type DraftBotCreateResponse struct {
	Code int64               `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string              `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *DraftBotCreateData `thrift:"data,3,required" form:"data,required" json:"data,required" query:"data,required"`
}

func NewDraftBotCreateResponse() *DraftBotCreateResponse {
	return &DraftBotCreateResponse{}
}

func (p *DraftBotCreateResponse) InitDefault() {
}

func (p *DraftBotCreateResponse) GetCode() (v int64) {
	return p.Code
}

func (p *DraftBotCreateResponse) GetMsg() (v string) {
	return p.Msg
}

var DraftBotCreateResponse_Data_DEFAULT *DraftBotCreateData

func (p *DraftBotCreateResponse) GetData() (v *DraftBotCreateData) {
	if !p.IsSetData() {
		return DraftBotCreateResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_DraftBotCreateResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *DraftBotCreateResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *DraftBotCreateResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DraftBotCreateResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DraftBotCreateResponse[fieldId]))
}

func (p *DraftBotCreateResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *DraftBotCreateResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *DraftBotCreateResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewDraftBotCreateData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *DraftBotCreateResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DraftBotCreateResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DraftBotCreateResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DraftBotCreateResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DraftBotCreateResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *DraftBotCreateResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DraftBotCreateResponse(%+v)", *p)

}

type DeleteDraftBotRequest struct {
	SpaceID int64 `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,string,required" query:"space_id,required"`
	BotID   int64 `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
}

func NewDeleteDraftBotRequest() *DeleteDraftBotRequest {
	return &DeleteDraftBotRequest{}
}

func (p *DeleteDraftBotRequest) InitDefault() {
}

func (p *DeleteDraftBotRequest) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *DeleteDraftBotRequest) GetBotID() (v int64) {
	return p.BotID
}

var fieldIDToName_DeleteDraftBotRequest = map[int16]string{
	1: "space_id",
	2: "bot_id",
}

func (p *DeleteDraftBotRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeleteDraftBotRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DeleteDraftBotRequest[fieldId]))
}

func (p *DeleteDraftBotRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *DeleteDraftBotRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}

func (p *DeleteDraftBotRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteDraftBotRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeleteDraftBotRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DeleteDraftBotRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *DeleteDraftBotRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeleteDraftBotRequest(%+v)", *p)

}

type DeleteDraftBotData struct {
}

func NewDeleteDraftBotData() *DeleteDraftBotData {
	return &DeleteDraftBotData{}
}

func (p *DeleteDraftBotData) InitDefault() {
}

var fieldIDToName_DeleteDraftBotData = map[int16]string{}

func (p *DeleteDraftBotData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err = iprot.Skip(fieldTypeId); err != nil {
			goto SkipFieldTypeError
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
SkipFieldTypeError:
	return thrift.PrependError(fmt.Sprintf("%T skip field type %d error", p, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeleteDraftBotData) Write(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteStructBegin("DeleteDraftBotData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeleteDraftBotData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeleteDraftBotData(%+v)", *p)

}

type DeleteDraftBotResponse struct {
	Code int64               `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string              `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *DeleteDraftBotData `thrift:"data,3,required" form:"data,required" json:"data,required" query:"data,required"`
}

func NewDeleteDraftBotResponse() *DeleteDraftBotResponse {
	return &DeleteDraftBotResponse{}
}

func (p *DeleteDraftBotResponse) InitDefault() {
}

func (p *DeleteDraftBotResponse) GetCode() (v int64) {
	return p.Code
}

func (p *DeleteDraftBotResponse) GetMsg() (v string) {
	return p.Msg
}

var DeleteDraftBotResponse_Data_DEFAULT *DeleteDraftBotData

func (p *DeleteDraftBotResponse) GetData() (v *DeleteDraftBotData) {
	if !p.IsSetData() {
		return DeleteDraftBotResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_DeleteDraftBotResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *DeleteDraftBotResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *DeleteDraftBotResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeleteDraftBotResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DeleteDraftBotResponse[fieldId]))
}

func (p *DeleteDraftBotResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *DeleteDraftBotResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *DeleteDraftBotResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewDeleteDraftBotData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *DeleteDraftBotResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteDraftBotResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeleteDraftBotResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DeleteDraftBotResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DeleteDraftBotResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *DeleteDraftBotResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeleteDraftBotResponse(%+v)", *p)

}

type DuplicateDraftBotRequest struct {
	SpaceID int64 `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,string,required" query:"space_id,required"`
	BotID   int64 `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
}

func NewDuplicateDraftBotRequest() *DuplicateDraftBotRequest {
	return &DuplicateDraftBotRequest{}
}

func (p *DuplicateDraftBotRequest) InitDefault() {
}

func (p *DuplicateDraftBotRequest) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *DuplicateDraftBotRequest) GetBotID() (v int64) {
	return p.BotID
}

var fieldIDToName_DuplicateDraftBotRequest = map[int16]string{
	1: "space_id",
	2: "bot_id",
}

func (p *DuplicateDraftBotRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DuplicateDraftBotRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DuplicateDraftBotRequest[fieldId]))
}

func (p *DuplicateDraftBotRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *DuplicateDraftBotRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}

func (p *DuplicateDraftBotRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateDraftBotRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DuplicateDraftBotRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DuplicateDraftBotRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *DuplicateDraftBotRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DuplicateDraftBotRequest(%+v)", *p)

}

type UserLabel struct {
	LabelID   int64  `thrift:"label_id,1" form:"label_id" json:"label_id,string" query:"label_id"`
	LabelName string `thrift:"label_name,2" form:"label_name" json:"label_name" query:"label_name"`
	IconURI   string `thrift:"icon_uri,3" form:"icon_uri" json:"icon_uri" query:"icon_uri"`
	IconURL   string `thrift:"icon_url,4" form:"icon_url" json:"icon_url" query:"icon_url"`
	JumpLink  string `thrift:"jump_link,5" form:"jump_link" json:"jump_link" query:"jump_link"`
}

func NewUserLabel() *UserLabel {
	return &UserLabel{}
}

func (p *UserLabel) InitDefault() {
}

func (p *UserLabel) GetLabelID() (v int64) {
	return p.LabelID
}

func (p *UserLabel) GetLabelName() (v string) {
	return p.LabelName
}

func (p *UserLabel) GetIconURI() (v string) {
	return p.IconURI
}

func (p *UserLabel) GetIconURL() (v string) {
	return p.IconURL
}

func (p *UserLabel) GetJumpLink() (v string) {
	return p.JumpLink
}

var fieldIDToName_UserLabel = map[int16]string{
	1: "label_id",
	2: "label_name",
	3: "icon_uri",
	4: "icon_url",
	5: "jump_link",
}

func (p *UserLabel) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserLabel[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UserLabel) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LabelID = _field
	return nil
}
func (p *UserLabel) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LabelName = _field
	return nil
}
func (p *UserLabel) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURI = _field
	return nil
}
func (p *UserLabel) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *UserLabel) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.JumpLink = _field
	return nil
}

func (p *UserLabel) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserLabel"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserLabel) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("label_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.LabelID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UserLabel) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("label_name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.LabelName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UserLabel) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *UserLabel) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *UserLabel) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("jump_link", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.JumpLink); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *UserLabel) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserLabel(%+v)", *p)

}

type Creator struct {
	ID int64 `thrift:"id,1" form:"id" json:"id,string" query:"id"`
	// nickname
	Name      string `thrift:"name,2" form:"name" json:"name" query:"name"`
	AvatarURL string `thrift:"avatar_url,3" form:"avatar_url" json:"avatar_url" query:"avatar_url"`
	// Did you create it yourself?
	Self bool `thrift:"self,4" form:"self" json:"self" query:"self"`
	// user name
	UserUniqueName string `thrift:"user_unique_name,5" form:"user_unique_name" json:"user_unique_name" query:"user_unique_name"`
	// user tag
	UserLabel *UserLabel `thrift:"user_label,6" form:"user_label" json:"user_label" query:"user_label"`
}

func NewCreator() *Creator {
	return &Creator{}
}

func (p *Creator) InitDefault() {
}

func (p *Creator) GetID() (v int64) {
	return p.ID
}

func (p *Creator) GetName() (v string) {
	return p.Name
}

func (p *Creator) GetAvatarURL() (v string) {
	return p.AvatarURL
}

func (p *Creator) GetSelf() (v bool) {
	return p.Self
}

func (p *Creator) GetUserUniqueName() (v string) {
	return p.UserUniqueName
}

var Creator_UserLabel_DEFAULT *UserLabel

func (p *Creator) GetUserLabel() (v *UserLabel) {
	if !p.IsSetUserLabel() {
		return Creator_UserLabel_DEFAULT
	}
	return p.UserLabel
}

var fieldIDToName_Creator = map[int16]string{
	1: "id",
	2: "name",
	3: "avatar_url",
	4: "self",
	5: "user_unique_name",
	6: "user_label",
}

func (p *Creator) IsSetUserLabel() bool {
	return p.UserLabel != nil
}

func (p *Creator) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Creator[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Creator) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *Creator) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *Creator) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AvatarURL = _field
	return nil
}
func (p *Creator) ReadField4(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Self = _field
	return nil
}
func (p *Creator) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserUniqueName = _field
	return nil
}
func (p *Creator) ReadField6(iprot thrift.TProtocol) error {
	_field := NewUserLabel()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserLabel = _field
	return nil
}

func (p *Creator) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Creator"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Creator) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Creator) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Creator) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("avatar_url", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AvatarURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Creator) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("self", thrift.BOOL, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Self); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Creator) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_unique_name", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UserUniqueName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Creator) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_label", thrift.STRUCT, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.UserLabel.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}

func (p *Creator) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Creator(%+v)", *p)

}

type DuplicateDraftBotData struct {
	BotID    int64    `thrift:"bot_id,1" form:"bot_id" json:"bot_id,string" query:"bot_id"`
	Name     string   `thrift:"name,2" form:"name" json:"name" query:"name"`
	UserInfo *Creator `thrift:"user_info,3" form:"user_info" json:"user_info" query:"user_info"`
}

func NewDuplicateDraftBotData() *DuplicateDraftBotData {
	return &DuplicateDraftBotData{}
}

func (p *DuplicateDraftBotData) InitDefault() {
}

func (p *DuplicateDraftBotData) GetBotID() (v int64) {
	return p.BotID
}

func (p *DuplicateDraftBotData) GetName() (v string) {
	return p.Name
}

var DuplicateDraftBotData_UserInfo_DEFAULT *Creator

func (p *DuplicateDraftBotData) GetUserInfo() (v *Creator) {
	if !p.IsSetUserInfo() {
		return DuplicateDraftBotData_UserInfo_DEFAULT
	}
	return p.UserInfo
}

var fieldIDToName_DuplicateDraftBotData = map[int16]string{
	1: "bot_id",
	2: "name",
	3: "user_info",
}

func (p *DuplicateDraftBotData) IsSetUserInfo() bool {
	return p.UserInfo != nil
}

func (p *DuplicateDraftBotData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DuplicateDraftBotData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DuplicateDraftBotData) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *DuplicateDraftBotData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *DuplicateDraftBotData) ReadField3(iprot thrift.TProtocol) error {
	_field := NewCreator()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserInfo = _field
	return nil
}

func (p *DuplicateDraftBotData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateDraftBotData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DuplicateDraftBotData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DuplicateDraftBotData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DuplicateDraftBotData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_info", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.UserInfo.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *DuplicateDraftBotData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DuplicateDraftBotData(%+v)", *p)

}

type DuplicateDraftBotResponse struct {
	Code int64                  `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string                 `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *DuplicateDraftBotData `thrift:"data,3,required" form:"data,required" json:"data,required" query:"data,required"`
}

func NewDuplicateDraftBotResponse() *DuplicateDraftBotResponse {
	return &DuplicateDraftBotResponse{}
}

func (p *DuplicateDraftBotResponse) InitDefault() {
}

func (p *DuplicateDraftBotResponse) GetCode() (v int64) {
	return p.Code
}

func (p *DuplicateDraftBotResponse) GetMsg() (v string) {
	return p.Msg
}

var DuplicateDraftBotResponse_Data_DEFAULT *DuplicateDraftBotData

func (p *DuplicateDraftBotResponse) GetData() (v *DuplicateDraftBotData) {
	if !p.IsSetData() {
		return DuplicateDraftBotResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_DuplicateDraftBotResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *DuplicateDraftBotResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *DuplicateDraftBotResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DuplicateDraftBotResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DuplicateDraftBotResponse[fieldId]))
}

func (p *DuplicateDraftBotResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *DuplicateDraftBotResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *DuplicateDraftBotResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewDuplicateDraftBotData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *DuplicateDraftBotResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateDraftBotResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DuplicateDraftBotResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DuplicateDraftBotResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DuplicateDraftBotResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *DuplicateDraftBotResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DuplicateDraftBotResponse(%+v)", *p)

}

type UpdateDraftBotDisplayInfoResponse struct {
	Code int64  `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
}

func NewUpdateDraftBotDisplayInfoResponse() *UpdateDraftBotDisplayInfoResponse {
	return &UpdateDraftBotDisplayInfoResponse{}
}

func (p *UpdateDraftBotDisplayInfoResponse) InitDefault() {
}

func (p *UpdateDraftBotDisplayInfoResponse) GetCode() (v int64) {
	return p.Code
}

func (p *UpdateDraftBotDisplayInfoResponse) GetMsg() (v string) {
	return p.Msg
}

var fieldIDToName_UpdateDraftBotDisplayInfoResponse = map[int16]string{
	1: "code",
	2: "msg",
}

func (p *UpdateDraftBotDisplayInfoResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateDraftBotDisplayInfoResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UpdateDraftBotDisplayInfoResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *UpdateDraftBotDisplayInfoResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}

func (p *UpdateDraftBotDisplayInfoResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotDisplayInfoResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateDraftBotDisplayInfoResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateDraftBotDisplayInfoResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UpdateDraftBotDisplayInfoResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateDraftBotDisplayInfoResponse(%+v)", *p)

}

type DraftBotDisplayInfoData struct {
	TabDisplayInfo *TabDisplayItems `thrift:"tab_display_info,1,optional" form:"tab_display_info" json:"tab_display_info,omitempty" query:"tab_display_info"`
}

func NewDraftBotDisplayInfoData() *DraftBotDisplayInfoData {
	return &DraftBotDisplayInfoData{}
}

func (p *DraftBotDisplayInfoData) InitDefault() {
}

var DraftBotDisplayInfoData_TabDisplayInfo_DEFAULT *TabDisplayItems

func (p *DraftBotDisplayInfoData) GetTabDisplayInfo() (v *TabDisplayItems) {
	if !p.IsSetTabDisplayInfo() {
		return DraftBotDisplayInfoData_TabDisplayInfo_DEFAULT
	}
	return p.TabDisplayInfo
}

var fieldIDToName_DraftBotDisplayInfoData = map[int16]string{
	1: "tab_display_info",
}

func (p *DraftBotDisplayInfoData) IsSetTabDisplayInfo() bool {
	return p.TabDisplayInfo != nil
}

func (p *DraftBotDisplayInfoData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DraftBotDisplayInfoData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DraftBotDisplayInfoData) ReadField1(iprot thrift.TProtocol) error {
	_field := NewTabDisplayItems()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.TabDisplayInfo = _field
	return nil
}

func (p *DraftBotDisplayInfoData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DraftBotDisplayInfoData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DraftBotDisplayInfoData) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetTabDisplayInfo() {
		if err = oprot.WriteFieldBegin("tab_display_info", thrift.STRUCT, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.TabDisplayInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DraftBotDisplayInfoData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DraftBotDisplayInfoData(%+v)", *p)

}

type UpdateDraftBotDisplayInfoRequest struct {
	BotID       int64                    `thrift:"bot_id,1,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	DisplayInfo *DraftBotDisplayInfoData `thrift:"display_info,2,optional" form:"display_info" json:"display_info,omitempty" query:"display_info"`
	SpaceID     *string                  `thrift:"space_id,3,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
}

func NewUpdateDraftBotDisplayInfoRequest() *UpdateDraftBotDisplayInfoRequest {
	return &UpdateDraftBotDisplayInfoRequest{}
}

func (p *UpdateDraftBotDisplayInfoRequest) InitDefault() {
}

func (p *UpdateDraftBotDisplayInfoRequest) GetBotID() (v int64) {
	return p.BotID
}

var UpdateDraftBotDisplayInfoRequest_DisplayInfo_DEFAULT *DraftBotDisplayInfoData

func (p *UpdateDraftBotDisplayInfoRequest) GetDisplayInfo() (v *DraftBotDisplayInfoData) {
	if !p.IsSetDisplayInfo() {
		return UpdateDraftBotDisplayInfoRequest_DisplayInfo_DEFAULT
	}
	return p.DisplayInfo
}

var UpdateDraftBotDisplayInfoRequest_SpaceID_DEFAULT string

func (p *UpdateDraftBotDisplayInfoRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return UpdateDraftBotDisplayInfoRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var fieldIDToName_UpdateDraftBotDisplayInfoRequest = map[int16]string{
	1: "bot_id",
	2: "display_info",
	3: "space_id",
}

func (p *UpdateDraftBotDisplayInfoRequest) IsSetDisplayInfo() bool {
	return p.DisplayInfo != nil
}

func (p *UpdateDraftBotDisplayInfoRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *UpdateDraftBotDisplayInfoRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateDraftBotDisplayInfoRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UpdateDraftBotDisplayInfoRequest[fieldId]))
}

func (p *UpdateDraftBotDisplayInfoRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *UpdateDraftBotDisplayInfoRequest) ReadField2(iprot thrift.TProtocol) error {
	_field := NewDraftBotDisplayInfoData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.DisplayInfo = _field
	return nil
}
func (p *UpdateDraftBotDisplayInfoRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}

func (p *UpdateDraftBotDisplayInfoRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotDisplayInfoRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateDraftBotDisplayInfoRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateDraftBotDisplayInfoRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetDisplayInfo() {
		if err = oprot.WriteFieldBegin("display_info", thrift.STRUCT, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.DisplayInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UpdateDraftBotDisplayInfoRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *UpdateDraftBotDisplayInfoRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateDraftBotDisplayInfoRequest(%+v)", *p)

}

type TabDisplayItems struct {
	PluginTabStatus           *TabStatus `thrift:"plugin_tab_status,1,optional" form:"plugin_tab_status" json:"plugin_tab_status,omitempty" query:"plugin_tab_status"`
	WorkflowTabStatus         *TabStatus `thrift:"workflow_tab_status,2,optional" form:"workflow_tab_status" json:"workflow_tab_status,omitempty" query:"workflow_tab_status"`
	KnowledgeTabStatus        *TabStatus `thrift:"knowledge_tab_status,3,optional" form:"knowledge_tab_status" json:"knowledge_tab_status,omitempty" query:"knowledge_tab_status"`
	DatabaseTabStatus         *TabStatus `thrift:"database_tab_status,4,optional" form:"database_tab_status" json:"database_tab_status,omitempty" query:"database_tab_status"`
	VariableTabStatus         *TabStatus `thrift:"variable_tab_status,5,optional" form:"variable_tab_status" json:"variable_tab_status,omitempty" query:"variable_tab_status"`
	OpeningDialogTabStatus    *TabStatus `thrift:"opening_dialog_tab_status,6,optional" form:"opening_dialog_tab_status" json:"opening_dialog_tab_status,omitempty" query:"opening_dialog_tab_status"`
	ScheduledTaskTabStatus    *TabStatus `thrift:"scheduled_task_tab_status,7,optional" form:"scheduled_task_tab_status" json:"scheduled_task_tab_status,omitempty" query:"scheduled_task_tab_status"`
	SuggestionTabStatus       *TabStatus `thrift:"suggestion_tab_status,8,optional" form:"suggestion_tab_status" json:"suggestion_tab_status,omitempty" query:"suggestion_tab_status"`
	TtsTabStatus              *TabStatus `thrift:"tts_tab_status,9,optional" form:"tts_tab_status" json:"tts_tab_status,omitempty" query:"tts_tab_status"`
	FileboxTabStatus          *TabStatus `thrift:"filebox_tab_status,10,optional" form:"filebox_tab_status" json:"filebox_tab_status,omitempty" query:"filebox_tab_status"`
	LongTermMemoryTabStatus   *TabStatus `thrift:"long_term_memory_tab_status,11,optional" form:"long_term_memory_tab_status" json:"long_term_memory_tab_status,omitempty" query:"long_term_memory_tab_status"`
	AnswerActionTabStatus     *TabStatus `thrift:"answer_action_tab_status,12,optional" form:"answer_action_tab_status" json:"answer_action_tab_status,omitempty" query:"answer_action_tab_status"`
	ImageflowTabStatus        *TabStatus `thrift:"imageflow_tab_status,13,optional" form:"imageflow_tab_status" json:"imageflow_tab_status,omitempty" query:"imageflow_tab_status"`
	BackgroundImageTabStatus  *TabStatus `thrift:"background_image_tab_status,14,optional" form:"background_image_tab_status" json:"background_image_tab_status,omitempty" query:"background_image_tab_status"`
	ShortcutTabStatus         *TabStatus `thrift:"shortcut_tab_status,15,optional" form:"shortcut_tab_status" json:"shortcut_tab_status,omitempty" query:"shortcut_tab_status"`
	KnowledgeTableTabStatus   *TabStatus `thrift:"knowledge_table_tab_status,16,optional" form:"knowledge_table_tab_status" json:"knowledge_table_tab_status,omitempty" query:"knowledge_table_tab_status"`
	KnowledgeTextTabStatus    *TabStatus `thrift:"knowledge_text_tab_status,17,optional" form:"knowledge_text_tab_status" json:"knowledge_text_tab_status,omitempty" query:"knowledge_text_tab_status"`
	KnowledgePhotoTabStatus   *TabStatus `thrift:"knowledge_photo_tab_status,18,optional" form:"knowledge_photo_tab_status" json:"knowledge_photo_tab_status,omitempty" query:"knowledge_photo_tab_status"`
	HookInfoTabStatus         *TabStatus `thrift:"hook_info_tab_status,19,optional" form:"hook_info_tab_status" json:"hook_info_tab_status,omitempty" query:"hook_info_tab_status"`
	DefaultUserInputTabStatus *TabStatus `thrift:"default_user_input_tab_status,20,optional" form:"default_user_input_tab_status" json:"default_user_input_tab_status,omitempty" query:"default_user_input_tab_status"`
}

func NewTabDisplayItems() *TabDisplayItems {
	return &TabDisplayItems{}
}

func (p *TabDisplayItems) InitDefault() {
}

var TabDisplayItems_PluginTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetPluginTabStatus() (v TabStatus) {
	if !p.IsSetPluginTabStatus() {
		return TabDisplayItems_PluginTabStatus_DEFAULT
	}
	return *p.PluginTabStatus
}

var TabDisplayItems_WorkflowTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetWorkflowTabStatus() (v TabStatus) {
	if !p.IsSetWorkflowTabStatus() {
		return TabDisplayItems_WorkflowTabStatus_DEFAULT
	}
	return *p.WorkflowTabStatus
}

var TabDisplayItems_KnowledgeTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetKnowledgeTabStatus() (v TabStatus) {
	if !p.IsSetKnowledgeTabStatus() {
		return TabDisplayItems_KnowledgeTabStatus_DEFAULT
	}
	return *p.KnowledgeTabStatus
}

var TabDisplayItems_DatabaseTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetDatabaseTabStatus() (v TabStatus) {
	if !p.IsSetDatabaseTabStatus() {
		return TabDisplayItems_DatabaseTabStatus_DEFAULT
	}
	return *p.DatabaseTabStatus
}

var TabDisplayItems_VariableTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetVariableTabStatus() (v TabStatus) {
	if !p.IsSetVariableTabStatus() {
		return TabDisplayItems_VariableTabStatus_DEFAULT
	}
	return *p.VariableTabStatus
}

var TabDisplayItems_OpeningDialogTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetOpeningDialogTabStatus() (v TabStatus) {
	if !p.IsSetOpeningDialogTabStatus() {
		return TabDisplayItems_OpeningDialogTabStatus_DEFAULT
	}
	return *p.OpeningDialogTabStatus
}

var TabDisplayItems_ScheduledTaskTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetScheduledTaskTabStatus() (v TabStatus) {
	if !p.IsSetScheduledTaskTabStatus() {
		return TabDisplayItems_ScheduledTaskTabStatus_DEFAULT
	}
	return *p.ScheduledTaskTabStatus
}

var TabDisplayItems_SuggestionTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetSuggestionTabStatus() (v TabStatus) {
	if !p.IsSetSuggestionTabStatus() {
		return TabDisplayItems_SuggestionTabStatus_DEFAULT
	}
	return *p.SuggestionTabStatus
}

var TabDisplayItems_TtsTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetTtsTabStatus() (v TabStatus) {
	if !p.IsSetTtsTabStatus() {
		return TabDisplayItems_TtsTabStatus_DEFAULT
	}
	return *p.TtsTabStatus
}

var TabDisplayItems_FileboxTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetFileboxTabStatus() (v TabStatus) {
	if !p.IsSetFileboxTabStatus() {
		return TabDisplayItems_FileboxTabStatus_DEFAULT
	}
	return *p.FileboxTabStatus
}

var TabDisplayItems_LongTermMemoryTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetLongTermMemoryTabStatus() (v TabStatus) {
	if !p.IsSetLongTermMemoryTabStatus() {
		return TabDisplayItems_LongTermMemoryTabStatus_DEFAULT
	}
	return *p.LongTermMemoryTabStatus
}

var TabDisplayItems_AnswerActionTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetAnswerActionTabStatus() (v TabStatus) {
	if !p.IsSetAnswerActionTabStatus() {
		return TabDisplayItems_AnswerActionTabStatus_DEFAULT
	}
	return *p.AnswerActionTabStatus
}

var TabDisplayItems_ImageflowTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetImageflowTabStatus() (v TabStatus) {
	if !p.IsSetImageflowTabStatus() {
		return TabDisplayItems_ImageflowTabStatus_DEFAULT
	}
	return *p.ImageflowTabStatus
}

var TabDisplayItems_BackgroundImageTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetBackgroundImageTabStatus() (v TabStatus) {
	if !p.IsSetBackgroundImageTabStatus() {
		return TabDisplayItems_BackgroundImageTabStatus_DEFAULT
	}
	return *p.BackgroundImageTabStatus
}

var TabDisplayItems_ShortcutTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetShortcutTabStatus() (v TabStatus) {
	if !p.IsSetShortcutTabStatus() {
		return TabDisplayItems_ShortcutTabStatus_DEFAULT
	}
	return *p.ShortcutTabStatus
}

var TabDisplayItems_KnowledgeTableTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetKnowledgeTableTabStatus() (v TabStatus) {
	if !p.IsSetKnowledgeTableTabStatus() {
		return TabDisplayItems_KnowledgeTableTabStatus_DEFAULT
	}
	return *p.KnowledgeTableTabStatus
}

var TabDisplayItems_KnowledgeTextTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetKnowledgeTextTabStatus() (v TabStatus) {
	if !p.IsSetKnowledgeTextTabStatus() {
		return TabDisplayItems_KnowledgeTextTabStatus_DEFAULT
	}
	return *p.KnowledgeTextTabStatus
}

var TabDisplayItems_KnowledgePhotoTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetKnowledgePhotoTabStatus() (v TabStatus) {
	if !p.IsSetKnowledgePhotoTabStatus() {
		return TabDisplayItems_KnowledgePhotoTabStatus_DEFAULT
	}
	return *p.KnowledgePhotoTabStatus
}

var TabDisplayItems_HookInfoTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetHookInfoTabStatus() (v TabStatus) {
	if !p.IsSetHookInfoTabStatus() {
		return TabDisplayItems_HookInfoTabStatus_DEFAULT
	}
	return *p.HookInfoTabStatus
}

var TabDisplayItems_DefaultUserInputTabStatus_DEFAULT TabStatus

func (p *TabDisplayItems) GetDefaultUserInputTabStatus() (v TabStatus) {
	if !p.IsSetDefaultUserInputTabStatus() {
		return TabDisplayItems_DefaultUserInputTabStatus_DEFAULT
	}
	return *p.DefaultUserInputTabStatus
}

var fieldIDToName_TabDisplayItems = map[int16]string{
	1:  "plugin_tab_status",
	2:  "workflow_tab_status",
	3:  "knowledge_tab_status",
	4:  "database_tab_status",
	5:  "variable_tab_status",
	6:  "opening_dialog_tab_status",
	7:  "scheduled_task_tab_status",
	8:  "suggestion_tab_status",
	9:  "tts_tab_status",
	10: "filebox_tab_status",
	11: "long_term_memory_tab_status",
	12: "answer_action_tab_status",
	13: "imageflow_tab_status",
	14: "background_image_tab_status",
	15: "shortcut_tab_status",
	16: "knowledge_table_tab_status",
	17: "knowledge_text_tab_status",
	18: "knowledge_photo_tab_status",
	19: "hook_info_tab_status",
	20: "default_user_input_tab_status",
}

func (p *TabDisplayItems) IsSetPluginTabStatus() bool {
	return p.PluginTabStatus != nil
}

func (p *TabDisplayItems) IsSetWorkflowTabStatus() bool {
	return p.WorkflowTabStatus != nil
}

func (p *TabDisplayItems) IsSetKnowledgeTabStatus() bool {
	return p.KnowledgeTabStatus != nil
}

func (p *TabDisplayItems) IsSetDatabaseTabStatus() bool {
	return p.DatabaseTabStatus != nil
}

func (p *TabDisplayItems) IsSetVariableTabStatus() bool {
	return p.VariableTabStatus != nil
}

func (p *TabDisplayItems) IsSetOpeningDialogTabStatus() bool {
	return p.OpeningDialogTabStatus != nil
}

func (p *TabDisplayItems) IsSetScheduledTaskTabStatus() bool {
	return p.ScheduledTaskTabStatus != nil
}

func (p *TabDisplayItems) IsSetSuggestionTabStatus() bool {
	return p.SuggestionTabStatus != nil
}

func (p *TabDisplayItems) IsSetTtsTabStatus() bool {
	return p.TtsTabStatus != nil
}

func (p *TabDisplayItems) IsSetFileboxTabStatus() bool {
	return p.FileboxTabStatus != nil
}

func (p *TabDisplayItems) IsSetLongTermMemoryTabStatus() bool {
	return p.LongTermMemoryTabStatus != nil
}

func (p *TabDisplayItems) IsSetAnswerActionTabStatus() bool {
	return p.AnswerActionTabStatus != nil
}

func (p *TabDisplayItems) IsSetImageflowTabStatus() bool {
	return p.ImageflowTabStatus != nil
}

func (p *TabDisplayItems) IsSetBackgroundImageTabStatus() bool {
	return p.BackgroundImageTabStatus != nil
}

func (p *TabDisplayItems) IsSetShortcutTabStatus() bool {
	return p.ShortcutTabStatus != nil
}

func (p *TabDisplayItems) IsSetKnowledgeTableTabStatus() bool {
	return p.KnowledgeTableTabStatus != nil
}

func (p *TabDisplayItems) IsSetKnowledgeTextTabStatus() bool {
	return p.KnowledgeTextTabStatus != nil
}

func (p *TabDisplayItems) IsSetKnowledgePhotoTabStatus() bool {
	return p.KnowledgePhotoTabStatus != nil
}

func (p *TabDisplayItems) IsSetHookInfoTabStatus() bool {
	return p.HookInfoTabStatus != nil
}

func (p *TabDisplayItems) IsSetDefaultUserInputTabStatus() bool {
	return p.DefaultUserInputTabStatus != nil
}

func (p *TabDisplayItems) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_TabDisplayItems[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *TabDisplayItems) ReadField1(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.PluginTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField2(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.WorkflowTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField3(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.KnowledgeTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField4(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.DatabaseTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField5(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.VariableTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField6(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.OpeningDialogTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField7(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.ScheduledTaskTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField8(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.SuggestionTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField9(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.TtsTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField10(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.FileboxTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField11(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.LongTermMemoryTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField12(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.AnswerActionTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField13(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.ImageflowTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField14(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.BackgroundImageTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField15(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.ShortcutTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField16(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.KnowledgeTableTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField17(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.KnowledgeTextTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField18(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.KnowledgePhotoTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField19(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.HookInfoTabStatus = _field
	return nil
}
func (p *TabDisplayItems) ReadField20(iprot thrift.TProtocol) error {

	var _field *TabStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := TabStatus(v)
		_field = &tmp
	}
	p.DefaultUserInputTabStatus = _field
	return nil
}

func (p *TabDisplayItems) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("TabDisplayItems"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *TabDisplayItems) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginTabStatus() {
		if err = oprot.WriteFieldBegin("plugin_tab_status", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.PluginTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *TabDisplayItems) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowTabStatus() {
		if err = oprot.WriteFieldBegin("workflow_tab_status", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.WorkflowTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *TabDisplayItems) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetKnowledgeTabStatus() {
		if err = oprot.WriteFieldBegin("knowledge_tab_status", thrift.I32, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.KnowledgeTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *TabDisplayItems) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetDatabaseTabStatus() {
		if err = oprot.WriteFieldBegin("database_tab_status", thrift.I32, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.DatabaseTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *TabDisplayItems) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetVariableTabStatus() {
		if err = oprot.WriteFieldBegin("variable_tab_status", thrift.I32, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.VariableTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *TabDisplayItems) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetOpeningDialogTabStatus() {
		if err = oprot.WriteFieldBegin("opening_dialog_tab_status", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.OpeningDialogTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *TabDisplayItems) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetScheduledTaskTabStatus() {
		if err = oprot.WriteFieldBegin("scheduled_task_tab_status", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.ScheduledTaskTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *TabDisplayItems) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuggestionTabStatus() {
		if err = oprot.WriteFieldBegin("suggestion_tab_status", thrift.I32, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.SuggestionTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *TabDisplayItems) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetTtsTabStatus() {
		if err = oprot.WriteFieldBegin("tts_tab_status", thrift.I32, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.TtsTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *TabDisplayItems) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetFileboxTabStatus() {
		if err = oprot.WriteFieldBegin("filebox_tab_status", thrift.I32, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.FileboxTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *TabDisplayItems) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetLongTermMemoryTabStatus() {
		if err = oprot.WriteFieldBegin("long_term_memory_tab_status", thrift.I32, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.LongTermMemoryTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *TabDisplayItems) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetAnswerActionTabStatus() {
		if err = oprot.WriteFieldBegin("answer_action_tab_status", thrift.I32, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.AnswerActionTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *TabDisplayItems) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetImageflowTabStatus() {
		if err = oprot.WriteFieldBegin("imageflow_tab_status", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.ImageflowTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *TabDisplayItems) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetBackgroundImageTabStatus() {
		if err = oprot.WriteFieldBegin("background_image_tab_status", thrift.I32, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.BackgroundImageTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *TabDisplayItems) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetShortcutTabStatus() {
		if err = oprot.WriteFieldBegin("shortcut_tab_status", thrift.I32, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.ShortcutTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *TabDisplayItems) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetKnowledgeTableTabStatus() {
		if err = oprot.WriteFieldBegin("knowledge_table_tab_status", thrift.I32, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.KnowledgeTableTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *TabDisplayItems) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetKnowledgeTextTabStatus() {
		if err = oprot.WriteFieldBegin("knowledge_text_tab_status", thrift.I32, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.KnowledgeTextTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *TabDisplayItems) writeField18(oprot thrift.TProtocol) (err error) {
	if p.IsSetKnowledgePhotoTabStatus() {
		if err = oprot.WriteFieldBegin("knowledge_photo_tab_status", thrift.I32, 18); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.KnowledgePhotoTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *TabDisplayItems) writeField19(oprot thrift.TProtocol) (err error) {
	if p.IsSetHookInfoTabStatus() {
		if err = oprot.WriteFieldBegin("hook_info_tab_status", thrift.I32, 19); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.HookInfoTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *TabDisplayItems) writeField20(oprot thrift.TProtocol) (err error) {
	if p.IsSetDefaultUserInputTabStatus() {
		if err = oprot.WriteFieldBegin("default_user_input_tab_status", thrift.I32, 20); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.DefaultUserInputTabStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}

func (p *TabDisplayItems) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TabDisplayItems(%+v)", *p)

}

type GetDraftBotDisplayInfoResponse struct {
	Code int64                    `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string                   `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *DraftBotDisplayInfoData `thrift:"data,3" form:"data" json:"data" query:"data"`
}

func NewGetDraftBotDisplayInfoResponse() *GetDraftBotDisplayInfoResponse {
	return &GetDraftBotDisplayInfoResponse{}
}

func (p *GetDraftBotDisplayInfoResponse) InitDefault() {
}

func (p *GetDraftBotDisplayInfoResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetDraftBotDisplayInfoResponse) GetMsg() (v string) {
	return p.Msg
}

var GetDraftBotDisplayInfoResponse_Data_DEFAULT *DraftBotDisplayInfoData

func (p *GetDraftBotDisplayInfoResponse) GetData() (v *DraftBotDisplayInfoData) {
	if !p.IsSetData() {
		return GetDraftBotDisplayInfoResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_GetDraftBotDisplayInfoResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *GetDraftBotDisplayInfoResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetDraftBotDisplayInfoResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetDraftBotDisplayInfoResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetDraftBotDisplayInfoResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetDraftBotDisplayInfoResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetDraftBotDisplayInfoResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewDraftBotDisplayInfoData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *GetDraftBotDisplayInfoResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotDisplayInfoResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetDraftBotDisplayInfoResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetDraftBotDisplayInfoResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetDraftBotDisplayInfoResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetDraftBotDisplayInfoResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetDraftBotDisplayInfoResponse(%+v)", *p)

}

type GetDraftBotDisplayInfoRequest struct {
	BotID int64 `thrift:"bot_id,1,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
}

func NewGetDraftBotDisplayInfoRequest() *GetDraftBotDisplayInfoRequest {
	return &GetDraftBotDisplayInfoRequest{}
}

func (p *GetDraftBotDisplayInfoRequest) InitDefault() {
}

func (p *GetDraftBotDisplayInfoRequest) GetBotID() (v int64) {
	return p.BotID
}

var fieldIDToName_GetDraftBotDisplayInfoRequest = map[int16]string{
	1: "bot_id",
}

func (p *GetDraftBotDisplayInfoRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetDraftBotDisplayInfoRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetDraftBotDisplayInfoRequest[fieldId]))
}

func (p *GetDraftBotDisplayInfoRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}

func (p *GetDraftBotDisplayInfoRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotDisplayInfoRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetDraftBotDisplayInfoRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *GetDraftBotDisplayInfoRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetDraftBotDisplayInfoRequest(%+v)", *p)

}

type PublishDraftBotResponse struct {
	Code int64                `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string               `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *PublishDraftBotData `thrift:"data,3,required" form:"data,required" json:"data,required" query:"data,required"`
}

func NewPublishDraftBotResponse() *PublishDraftBotResponse {
	return &PublishDraftBotResponse{}
}

func (p *PublishDraftBotResponse) InitDefault() {
}

func (p *PublishDraftBotResponse) GetCode() (v int64) {
	return p.Code
}

func (p *PublishDraftBotResponse) GetMsg() (v string) {
	return p.Msg
}

var PublishDraftBotResponse_Data_DEFAULT *PublishDraftBotData

func (p *PublishDraftBotResponse) GetData() (v *PublishDraftBotData) {
	if !p.IsSetData() {
		return PublishDraftBotResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_PublishDraftBotResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *PublishDraftBotResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *PublishDraftBotResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishDraftBotResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_PublishDraftBotResponse[fieldId]))
}

func (p *PublishDraftBotResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *PublishDraftBotResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *PublishDraftBotResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewPublishDraftBotData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *PublishDraftBotResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishDraftBotResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishDraftBotResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishDraftBotResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishDraftBotResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *PublishDraftBotResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishDraftBotResponse(%+v)", *p)

}

type PublishDraftBotData struct {
	// Key represents connector_name enumeration Feishu = "feishu" -- obsolete
	ConnectorBindResult map[string][]*ConnectorBindResult `thrift:"connector_bind_result,1" form:"connector_bind_result" json:"connector_bind_result" query:"connector_bind_result"`
	// The key represents connector_id, and the value is the published result
	PublishResult map[string]*ConnectorBindResult `thrift:"publish_result,2" form:"publish_result" json:"publish_result" query:"publish_result"`
	// True: The machine audit verification failed
	CheckNotPass bool `thrift:"check_not_pass,3" form:"check_not_pass" json:"check_not_pass" query:"check_not_pass"`
	// Added bot marketing results
	SubmitBotMarketResult *SubmitBotMarketResult `thrift:"submit_bot_market_result,4,optional" form:"submit_bot_market_result" json:"submit_bot_market_result,omitempty" query:"submit_bot_market_result"`
	// In human moderation
	HitManualCheck *bool `thrift:"hit_manual_check,5,optional" form:"hit_manual_check" json:"hit_manual_check,omitempty" query:"hit_manual_check"`
	// starlingKey list of reasons why the machine audit failed
	NotPassReason []string `thrift:"not_pass_reason,6,optional" form:"not_pass_reason" json:"not_pass_reason,omitempty" query:"not_pass_reason"`
	// Publish bot billing results
	PublishMonetizationResult *bool `thrift:"publish_monetization_result,7,optional" form:"publish_monetization_result" json:"publish_monetization_result,omitempty" query:"publish_monetization_result"`
}

func NewPublishDraftBotData() *PublishDraftBotData {
	return &PublishDraftBotData{}
}

func (p *PublishDraftBotData) InitDefault() {
}

func (p *PublishDraftBotData) GetConnectorBindResult() (v map[string][]*ConnectorBindResult) {
	return p.ConnectorBindResult
}

func (p *PublishDraftBotData) GetPublishResult() (v map[string]*ConnectorBindResult) {
	return p.PublishResult
}

func (p *PublishDraftBotData) GetCheckNotPass() (v bool) {
	return p.CheckNotPass
}

var PublishDraftBotData_SubmitBotMarketResult_DEFAULT *SubmitBotMarketResult

func (p *PublishDraftBotData) GetSubmitBotMarketResult() (v *SubmitBotMarketResult) {
	if !p.IsSetSubmitBotMarketResult() {
		return PublishDraftBotData_SubmitBotMarketResult_DEFAULT
	}
	return p.SubmitBotMarketResult
}

var PublishDraftBotData_HitManualCheck_DEFAULT bool

func (p *PublishDraftBotData) GetHitManualCheck() (v bool) {
	if !p.IsSetHitManualCheck() {
		return PublishDraftBotData_HitManualCheck_DEFAULT
	}
	return *p.HitManualCheck
}

var PublishDraftBotData_NotPassReason_DEFAULT []string

func (p *PublishDraftBotData) GetNotPassReason() (v []string) {
	if !p.IsSetNotPassReason() {
		return PublishDraftBotData_NotPassReason_DEFAULT
	}
	return p.NotPassReason
}

var PublishDraftBotData_PublishMonetizationResult_DEFAULT bool

func (p *PublishDraftBotData) GetPublishMonetizationResult() (v bool) {
	if !p.IsSetPublishMonetizationResult() {
		return PublishDraftBotData_PublishMonetizationResult_DEFAULT
	}
	return *p.PublishMonetizationResult
}

var fieldIDToName_PublishDraftBotData = map[int16]string{
	1: "connector_bind_result",
	2: "publish_result",
	3: "check_not_pass",
	4: "submit_bot_market_result",
	5: "hit_manual_check",
	6: "not_pass_reason",
	7: "publish_monetization_result",
}

func (p *PublishDraftBotData) IsSetSubmitBotMarketResult() bool {
	return p.SubmitBotMarketResult != nil
}

func (p *PublishDraftBotData) IsSetHitManualCheck() bool {
	return p.HitManualCheck != nil
}

func (p *PublishDraftBotData) IsSetNotPassReason() bool {
	return p.NotPassReason != nil
}

func (p *PublishDraftBotData) IsSetPublishMonetizationResult() bool {
	return p.PublishMonetizationResult != nil
}

func (p *PublishDraftBotData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishDraftBotData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublishDraftBotData) ReadField1(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string][]*ConnectorBindResult, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}
		_, size, err := iprot.ReadListBegin()
		if err != nil {
			return err
		}
		_val := make([]*ConnectorBindResult, 0, size)
		values := make([]ConnectorBindResult, size)
		for i := 0; i < size; i++ {
			_elem := &values[i]
			_elem.InitDefault()

			if err := _elem.Read(iprot); err != nil {
				return err
			}

			_val = append(_val, _elem)
		}
		if err := iprot.ReadListEnd(); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.ConnectorBindResult = _field
	return nil
}
func (p *PublishDraftBotData) ReadField2(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]*ConnectorBindResult, size)
	values := make([]ConnectorBindResult, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.PublishResult = _field
	return nil
}
func (p *PublishDraftBotData) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CheckNotPass = _field
	return nil
}
func (p *PublishDraftBotData) ReadField4(iprot thrift.TProtocol) error {
	_field := NewSubmitBotMarketResult()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.SubmitBotMarketResult = _field
	return nil
}
func (p *PublishDraftBotData) ReadField5(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HitManualCheck = _field
	return nil
}
func (p *PublishDraftBotData) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.NotPassReason = _field
	return nil
}
func (p *PublishDraftBotData) ReadField7(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PublishMonetizationResult = _field
	return nil
}

func (p *PublishDraftBotData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishDraftBotData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishDraftBotData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connector_bind_result", thrift.MAP, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.LIST, len(p.ConnectorBindResult)); err != nil {
		return err
	}
	for k, v := range p.ConnectorBindResult {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(v)); err != nil {
			return err
		}
		for _, v := range v {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishDraftBotData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("publish_result", thrift.MAP, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRUCT, len(p.PublishResult)); err != nil {
		return err
	}
	for k, v := range p.PublishResult {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishDraftBotData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("check_not_pass", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.CheckNotPass); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PublishDraftBotData) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubmitBotMarketResult() {
		if err = oprot.WriteFieldBegin("submit_bot_market_result", thrift.STRUCT, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.SubmitBotMarketResult.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PublishDraftBotData) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetHitManualCheck() {
		if err = oprot.WriteFieldBegin("hit_manual_check", thrift.BOOL, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.HitManualCheck); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PublishDraftBotData) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetNotPassReason() {
		if err = oprot.WriteFieldBegin("not_pass_reason", thrift.LIST, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.NotPassReason)); err != nil {
			return err
		}
		for _, v := range p.NotPassReason {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PublishDraftBotData) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishMonetizationResult() {
		if err = oprot.WriteFieldBegin("publish_monetization_result", thrift.BOOL, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.PublishMonetizationResult); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *PublishDraftBotData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishDraftBotData(%+v)", *p)

}

type ConnectorBindResult struct {
	Connector *Connector `thrift:"connector,1" form:"connector" json:"connector" query:"connector"`
	// The status code returned downstream of the publish call is not consumed by the front end.
	Code int64 `thrift:"code,2" form:"code" json:"code" query:"code"`
	// Additional copy of the release status, the front end is parsed in markdown format
	Msg string `thrift:"msg,3" form:"msg" json:"msg" query:"msg"`
	// post result status
	PublishResultStatus *PublishResultStatus `thrift:"publish_result_status,4,optional" form:"publish_result_status" json:"publish_result_status,omitempty" query:"publish_result_status"`
}

func NewConnectorBindResult() *ConnectorBindResult {
	return &ConnectorBindResult{}
}

func (p *ConnectorBindResult) InitDefault() {
}

var ConnectorBindResult_Connector_DEFAULT *Connector

func (p *ConnectorBindResult) GetConnector() (v *Connector) {
	if !p.IsSetConnector() {
		return ConnectorBindResult_Connector_DEFAULT
	}
	return p.Connector
}

func (p *ConnectorBindResult) GetCode() (v int64) {
	return p.Code
}

func (p *ConnectorBindResult) GetMsg() (v string) {
	return p.Msg
}

var ConnectorBindResult_PublishResultStatus_DEFAULT PublishResultStatus

func (p *ConnectorBindResult) GetPublishResultStatus() (v PublishResultStatus) {
	if !p.IsSetPublishResultStatus() {
		return ConnectorBindResult_PublishResultStatus_DEFAULT
	}
	return *p.PublishResultStatus
}

var fieldIDToName_ConnectorBindResult = map[int16]string{
	1: "connector",
	2: "code",
	3: "msg",
	4: "publish_result_status",
}

func (p *ConnectorBindResult) IsSetConnector() bool {
	return p.Connector != nil
}

func (p *ConnectorBindResult) IsSetPublishResultStatus() bool {
	return p.PublishResultStatus != nil
}

func (p *ConnectorBindResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ConnectorBindResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ConnectorBindResult) ReadField1(iprot thrift.TProtocol) error {
	_field := NewConnector()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Connector = _field
	return nil
}
func (p *ConnectorBindResult) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *ConnectorBindResult) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *ConnectorBindResult) ReadField4(iprot thrift.TProtocol) error {

	var _field *PublishResultStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := PublishResultStatus(v)
		_field = &tmp
	}
	p.PublishResultStatus = _field
	return nil
}

func (p *ConnectorBindResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ConnectorBindResult"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ConnectorBindResult) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connector", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Connector.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ConnectorBindResult) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ConnectorBindResult) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ConnectorBindResult) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishResultStatus() {
		if err = oprot.WriteFieldBegin("publish_result_status", thrift.I32, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.PublishResultStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *ConnectorBindResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ConnectorBindResult(%+v)", *p)

}

type Connector struct {
	// connector_name enumeration Feishu = "feishu"
	Name      string            `thrift:"name,1" form:"name" json:"name" query:"name"`
	AppID     string            `thrift:"app_id,2" form:"app_id" json:"app_id" query:"app_id"`
	AppSecret string            `thrift:"app_secret,3" form:"app_secret" json:"app_secret" query:"app_secret"`
	ShareLink string            `thrift:"share_link,4" form:"share_link" json:"share_link" query:"share_link"`
	BindInfo  map[string]string `thrift:"bind_info,5,optional" form:"bind_info" json:"bind_info,omitempty" query:"bind_info"`
}

func NewConnector() *Connector {
	return &Connector{}
}

func (p *Connector) InitDefault() {
}

func (p *Connector) GetName() (v string) {
	return p.Name
}

func (p *Connector) GetAppID() (v string) {
	return p.AppID
}

func (p *Connector) GetAppSecret() (v string) {
	return p.AppSecret
}

func (p *Connector) GetShareLink() (v string) {
	return p.ShareLink
}

var Connector_BindInfo_DEFAULT map[string]string

func (p *Connector) GetBindInfo() (v map[string]string) {
	if !p.IsSetBindInfo() {
		return Connector_BindInfo_DEFAULT
	}
	return p.BindInfo
}

var fieldIDToName_Connector = map[int16]string{
	1: "name",
	2: "app_id",
	3: "app_secret",
	4: "share_link",
	5: "bind_info",
}

func (p *Connector) IsSetBindInfo() bool {
	return p.BindInfo != nil
}

func (p *Connector) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Connector[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Connector) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *Connector) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AppID = _field
	return nil
}
func (p *Connector) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AppSecret = _field
	return nil
}
func (p *Connector) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ShareLink = _field
	return nil
}
func (p *Connector) ReadField5(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]string, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		var _val string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_val = v
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.BindInfo = _field
	return nil
}

func (p *Connector) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Connector"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Connector) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Connector) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("app_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AppID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Connector) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("app_secret", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AppSecret); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Connector) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("share_link", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ShareLink); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Connector) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindInfo() {
		if err = oprot.WriteFieldBegin("bind_info", thrift.MAP, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRING, len(p.BindInfo)); err != nil {
			return err
		}
		for k, v := range p.BindInfo {
			if err := oprot.WriteString(k); err != nil {
				return err
			}
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *Connector) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Connector(%+v)", *p)

}

type SubmitBotMarketResult struct {
	// Shelf status, 0-success
	ResultCode *int64 `thrift:"result_code,1,optional" form:"result_code" json:"result_code,omitempty" query:"result_code"`
	// msg
	Msg *string `thrift:"msg,2,optional" form:"msg" json:"msg,omitempty" query:"msg"`
}

func NewSubmitBotMarketResult() *SubmitBotMarketResult {
	return &SubmitBotMarketResult{}
}

func (p *SubmitBotMarketResult) InitDefault() {
}

var SubmitBotMarketResult_ResultCode_DEFAULT int64

func (p *SubmitBotMarketResult) GetResultCode() (v int64) {
	if !p.IsSetResultCode() {
		return SubmitBotMarketResult_ResultCode_DEFAULT
	}
	return *p.ResultCode
}

var SubmitBotMarketResult_Msg_DEFAULT string

func (p *SubmitBotMarketResult) GetMsg() (v string) {
	if !p.IsSetMsg() {
		return SubmitBotMarketResult_Msg_DEFAULT
	}
	return *p.Msg
}

var fieldIDToName_SubmitBotMarketResult = map[int16]string{
	1: "result_code",
	2: "msg",
}

func (p *SubmitBotMarketResult) IsSetResultCode() bool {
	return p.ResultCode != nil
}

func (p *SubmitBotMarketResult) IsSetMsg() bool {
	return p.Msg != nil
}

func (p *SubmitBotMarketResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SubmitBotMarketResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SubmitBotMarketResult) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ResultCode = _field
	return nil
}
func (p *SubmitBotMarketResult) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Msg = _field
	return nil
}

func (p *SubmitBotMarketResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SubmitBotMarketResult"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SubmitBotMarketResult) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetResultCode() {
		if err = oprot.WriteFieldBegin("result_code", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ResultCode); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SubmitBotMarketResult) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetMsg() {
		if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Msg); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *SubmitBotMarketResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SubmitBotMarketResult(%+v)", *p)

}

type AgentInfo struct {
	ID             *string        `thrift:"id,1,optional" form:"id" json:"id,omitempty" query:"id"`
	AgentType      *AgentType     `thrift:"agent_type,2,optional" form:"agent_type" json:"agent_type,omitempty" query:"agent_type"`
	Name           *string        `thrift:"name,3,optional" form:"name" json:"name,omitempty" query:"name"`
	Position       *AgentPosition `thrift:"position,4,optional" form:"position" json:"position,omitempty" query:"position"`
	IconURI        *string        `thrift:"icon_uri,5,optional" form:"icon_uri" json:"icon_uri,omitempty" query:"icon_uri"`
	Intents        []*Intent      `thrift:"intents,6,optional" form:"intents" json:"intents,omitempty" query:"intents"`
	WorkInfo       *AgentWorkInfo `thrift:"work_info,7,optional" form:"work_info" json:"work_info,omitempty" query:"work_info"`
	ReferenceID    *string        `thrift:"reference_id,8,optional" form:"reference_id" json:"reference_id,omitempty" query:"reference_id"`
	FirstVersion   *string        `thrift:"first_version,9,optional" form:"first_version" json:"first_version,omitempty" query:"first_version"`
	CurrentVersion *string        `thrift:"current_version,10,optional" form:"current_version" json:"current_version,omitempty" query:"current_version"`
	// 1: Available update 2: Removed
	ReferenceInfoStatus *ReferenceInfoStatus `thrift:"reference_info_status,11,optional" form:"reference_info_status" json:"reference_info_status,omitempty" query:"reference_info_status"`
	Description         *string              `thrift:"description,12,optional" form:"description" json:"description,omitempty" query:"description"`
	UpdateType          *ReferenceUpdateType `thrift:"update_type,13,optional" form:"update_type" json:"update_type,omitempty" query:"update_type"`
}

func NewAgentInfo() *AgentInfo {
	return &AgentInfo{}
}

func (p *AgentInfo) InitDefault() {
}

var AgentInfo_ID_DEFAULT string

func (p *AgentInfo) GetID() (v string) {
	if !p.IsSetID() {
		return AgentInfo_ID_DEFAULT
	}
	return *p.ID
}

var AgentInfo_AgentType_DEFAULT AgentType

func (p *AgentInfo) GetAgentType() (v AgentType) {
	if !p.IsSetAgentType() {
		return AgentInfo_AgentType_DEFAULT
	}
	return *p.AgentType
}

var AgentInfo_Name_DEFAULT string

func (p *AgentInfo) GetName() (v string) {
	if !p.IsSetName() {
		return AgentInfo_Name_DEFAULT
	}
	return *p.Name
}

var AgentInfo_Position_DEFAULT *AgentPosition

func (p *AgentInfo) GetPosition() (v *AgentPosition) {
	if !p.IsSetPosition() {
		return AgentInfo_Position_DEFAULT
	}
	return p.Position
}

var AgentInfo_IconURI_DEFAULT string

func (p *AgentInfo) GetIconURI() (v string) {
	if !p.IsSetIconURI() {
		return AgentInfo_IconURI_DEFAULT
	}
	return *p.IconURI
}

var AgentInfo_Intents_DEFAULT []*Intent

func (p *AgentInfo) GetIntents() (v []*Intent) {
	if !p.IsSetIntents() {
		return AgentInfo_Intents_DEFAULT
	}
	return p.Intents
}

var AgentInfo_WorkInfo_DEFAULT *AgentWorkInfo

func (p *AgentInfo) GetWorkInfo() (v *AgentWorkInfo) {
	if !p.IsSetWorkInfo() {
		return AgentInfo_WorkInfo_DEFAULT
	}
	return p.WorkInfo
}

var AgentInfo_ReferenceID_DEFAULT string

func (p *AgentInfo) GetReferenceID() (v string) {
	if !p.IsSetReferenceID() {
		return AgentInfo_ReferenceID_DEFAULT
	}
	return *p.ReferenceID
}

var AgentInfo_FirstVersion_DEFAULT string

func (p *AgentInfo) GetFirstVersion() (v string) {
	if !p.IsSetFirstVersion() {
		return AgentInfo_FirstVersion_DEFAULT
	}
	return *p.FirstVersion
}

var AgentInfo_CurrentVersion_DEFAULT string

func (p *AgentInfo) GetCurrentVersion() (v string) {
	if !p.IsSetCurrentVersion() {
		return AgentInfo_CurrentVersion_DEFAULT
	}
	return *p.CurrentVersion
}

var AgentInfo_ReferenceInfoStatus_DEFAULT ReferenceInfoStatus

func (p *AgentInfo) GetReferenceInfoStatus() (v ReferenceInfoStatus) {
	if !p.IsSetReferenceInfoStatus() {
		return AgentInfo_ReferenceInfoStatus_DEFAULT
	}
	return *p.ReferenceInfoStatus
}

var AgentInfo_Description_DEFAULT string

func (p *AgentInfo) GetDescription() (v string) {
	if !p.IsSetDescription() {
		return AgentInfo_Description_DEFAULT
	}
	return *p.Description
}

var AgentInfo_UpdateType_DEFAULT ReferenceUpdateType

func (p *AgentInfo) GetUpdateType() (v ReferenceUpdateType) {
	if !p.IsSetUpdateType() {
		return AgentInfo_UpdateType_DEFAULT
	}
	return *p.UpdateType
}

var fieldIDToName_AgentInfo = map[int16]string{
	1:  "id",
	2:  "agent_type",
	3:  "name",
	4:  "position",
	5:  "icon_uri",
	6:  "intents",
	7:  "work_info",
	8:  "reference_id",
	9:  "first_version",
	10: "current_version",
	11: "reference_info_status",
	12: "description",
	13: "update_type",
}

func (p *AgentInfo) IsSetID() bool {
	return p.ID != nil
}

func (p *AgentInfo) IsSetAgentType() bool {
	return p.AgentType != nil
}

func (p *AgentInfo) IsSetName() bool {
	return p.Name != nil
}

func (p *AgentInfo) IsSetPosition() bool {
	return p.Position != nil
}

func (p *AgentInfo) IsSetIconURI() bool {
	return p.IconURI != nil
}

func (p *AgentInfo) IsSetIntents() bool {
	return p.Intents != nil
}

func (p *AgentInfo) IsSetWorkInfo() bool {
	return p.WorkInfo != nil
}

func (p *AgentInfo) IsSetReferenceID() bool {
	return p.ReferenceID != nil
}

func (p *AgentInfo) IsSetFirstVersion() bool {
	return p.FirstVersion != nil
}

func (p *AgentInfo) IsSetCurrentVersion() bool {
	return p.CurrentVersion != nil
}

func (p *AgentInfo) IsSetReferenceInfoStatus() bool {
	return p.ReferenceInfoStatus != nil
}

func (p *AgentInfo) IsSetDescription() bool {
	return p.Description != nil
}

func (p *AgentInfo) IsSetUpdateType() bool {
	return p.UpdateType != nil
}

func (p *AgentInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_AgentInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *AgentInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ID = _field
	return nil
}
func (p *AgentInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field *AgentType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := AgentType(v)
		_field = &tmp
	}
	p.AgentType = _field
	return nil
}
func (p *AgentInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *AgentInfo) ReadField4(iprot thrift.TProtocol) error {
	_field := NewAgentPosition()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Position = _field
	return nil
}
func (p *AgentInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IconURI = _field
	return nil
}
func (p *AgentInfo) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Intent, 0, size)
	values := make([]Intent, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Intents = _field
	return nil
}
func (p *AgentInfo) ReadField7(iprot thrift.TProtocol) error {
	_field := NewAgentWorkInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.WorkInfo = _field
	return nil
}
func (p *AgentInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ReferenceID = _field
	return nil
}
func (p *AgentInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.FirstVersion = _field
	return nil
}
func (p *AgentInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CurrentVersion = _field
	return nil
}
func (p *AgentInfo) ReadField11(iprot thrift.TProtocol) error {

	var _field *ReferenceInfoStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := ReferenceInfoStatus(v)
		_field = &tmp
	}
	p.ReferenceInfoStatus = _field
	return nil
}
func (p *AgentInfo) ReadField12(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Description = _field
	return nil
}
func (p *AgentInfo) ReadField13(iprot thrift.TProtocol) error {

	var _field *ReferenceUpdateType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := ReferenceUpdateType(v)
		_field = &tmp
	}
	p.UpdateType = _field
	return nil
}

func (p *AgentInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("AgentInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *AgentInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetID() {
		if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *AgentInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetAgentType() {
		if err = oprot.WriteFieldBegin("agent_type", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.AgentType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *AgentInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *AgentInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetPosition() {
		if err = oprot.WriteFieldBegin("position", thrift.STRUCT, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Position.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *AgentInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetIconURI() {
		if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IconURI); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *AgentInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetIntents() {
		if err = oprot.WriteFieldBegin("intents", thrift.LIST, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Intents)); err != nil {
			return err
		}
		for _, v := range p.Intents {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *AgentInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkInfo() {
		if err = oprot.WriteFieldBegin("work_info", thrift.STRUCT, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.WorkInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *AgentInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetReferenceID() {
		if err = oprot.WriteFieldBegin("reference_id", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ReferenceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *AgentInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetFirstVersion() {
		if err = oprot.WriteFieldBegin("first_version", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.FirstVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *AgentInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetCurrentVersion() {
		if err = oprot.WriteFieldBegin("current_version", thrift.STRING, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CurrentVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *AgentInfo) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetReferenceInfoStatus() {
		if err = oprot.WriteFieldBegin("reference_info_status", thrift.I32, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.ReferenceInfoStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *AgentInfo) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetDescription() {
		if err = oprot.WriteFieldBegin("description", thrift.STRING, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Description); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *AgentInfo) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetUpdateType() {
		if err = oprot.WriteFieldBegin("update_type", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.UpdateType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}

func (p *AgentInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AgentInfo(%+v)", *p)

}

type AgentPosition struct {
	X float64 `thrift:"x,1" form:"x" json:"x" query:"x"`
	Y float64 `thrift:"y,2" form:"y" json:"y" query:"y"`
}

func NewAgentPosition() *AgentPosition {
	return &AgentPosition{}
}

func (p *AgentPosition) InitDefault() {
}

func (p *AgentPosition) GetX() (v float64) {
	return p.X
}

func (p *AgentPosition) GetY() (v float64) {
	return p.Y
}

var fieldIDToName_AgentPosition = map[int16]string{
	1: "x",
	2: "y",
}

func (p *AgentPosition) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_AgentPosition[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *AgentPosition) ReadField1(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.X = _field
	return nil
}
func (p *AgentPosition) ReadField2(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Y = _field
	return nil
}

func (p *AgentPosition) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("AgentPosition"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *AgentPosition) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("x", thrift.DOUBLE, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.X); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *AgentPosition) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("y", thrift.DOUBLE, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.Y); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *AgentPosition) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AgentPosition(%+v)", *p)

}

type Intent struct {
	IntentID    *string `thrift:"intent_id,1,optional" form:"intent_id" json:"intent_id,omitempty" query:"intent_id"`
	Prompt      *string `thrift:"prompt,2,optional" form:"prompt" json:"prompt,omitempty" query:"prompt"`
	NextAgentID *string `thrift:"next_agent_id,3,optional" form:"next_agent_id" json:"next_agent_id,omitempty" query:"next_agent_id"`
}

func NewIntent() *Intent {
	return &Intent{}
}

func (p *Intent) InitDefault() {
}

var Intent_IntentID_DEFAULT string

func (p *Intent) GetIntentID() (v string) {
	if !p.IsSetIntentID() {
		return Intent_IntentID_DEFAULT
	}
	return *p.IntentID
}

var Intent_Prompt_DEFAULT string

func (p *Intent) GetPrompt() (v string) {
	if !p.IsSetPrompt() {
		return Intent_Prompt_DEFAULT
	}
	return *p.Prompt
}

var Intent_NextAgentID_DEFAULT string

func (p *Intent) GetNextAgentID() (v string) {
	if !p.IsSetNextAgentID() {
		return Intent_NextAgentID_DEFAULT
	}
	return *p.NextAgentID
}

var fieldIDToName_Intent = map[int16]string{
	1: "intent_id",
	2: "prompt",
	3: "next_agent_id",
}

func (p *Intent) IsSetIntentID() bool {
	return p.IntentID != nil
}

func (p *Intent) IsSetPrompt() bool {
	return p.Prompt != nil
}

func (p *Intent) IsSetNextAgentID() bool {
	return p.NextAgentID != nil
}

func (p *Intent) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Intent[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Intent) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IntentID = _field
	return nil
}
func (p *Intent) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Prompt = _field
	return nil
}
func (p *Intent) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NextAgentID = _field
	return nil
}

func (p *Intent) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Intent"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Intent) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetIntentID() {
		if err = oprot.WriteFieldBegin("intent_id", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IntentID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Intent) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrompt() {
		if err = oprot.WriteFieldBegin("prompt", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Prompt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Intent) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetNextAgentID() {
		if err = oprot.WriteFieldBegin("next_agent_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.NextAgentID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *Intent) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Intent(%+v)", *p)

}

// Information about each module in the agent workspace
type AgentWorkInfo struct {
	// The agent prompts the front-end information, the server does not need to perceive
	Prompt *string `thrift:"prompt,1,optional" form:"prompt" json:"prompt,omitempty" query:"prompt"`
	// model configuration
	OtherInfo *string `thrift:"other_info,2,optional" form:"other_info" json:"other_info,omitempty" query:"other_info"`
	// Plugin information
	Tools *string `thrift:"tools,3,optional" form:"tools" json:"tools,omitempty" query:"tools"`
	// Dataset information
	Dataset *string `thrift:"dataset,4,optional" form:"dataset" json:"dataset,omitempty" query:"dataset"`
	// Workflow information
	Workflow *string `thrift:"workflow,5,optional" form:"workflow" json:"workflow,omitempty" query:"workflow"`
	// system_info_all with bot
	SystemInfoAll *string `thrift:"system_info_all,6,optional" form:"system_info_all" json:"system_info_all,omitempty" query:"system_info_all"`
	// backtrack configuration
	JumpConfig *JumpConfig `thrift:"jump_config,7,optional" form:"jump_config" json:"jump_config,omitempty" query:"jump_config"`
	// Referral Configuration
	SuggestReply *string `thrift:"suggest_reply,8,optional" form:"suggest_reply" json:"suggest_reply,omitempty" query:"suggest_reply"`
	// Hook configuration
	HookInfo *string `thrift:"hook_info,9,optional" form:"hook_info" json:"hook_info,omitempty" query:"hook_info"`
}

func NewAgentWorkInfo() *AgentWorkInfo {
	return &AgentWorkInfo{}
}

func (p *AgentWorkInfo) InitDefault() {
}

var AgentWorkInfo_Prompt_DEFAULT string

func (p *AgentWorkInfo) GetPrompt() (v string) {
	if !p.IsSetPrompt() {
		return AgentWorkInfo_Prompt_DEFAULT
	}
	return *p.Prompt
}

var AgentWorkInfo_OtherInfo_DEFAULT string

func (p *AgentWorkInfo) GetOtherInfo() (v string) {
	if !p.IsSetOtherInfo() {
		return AgentWorkInfo_OtherInfo_DEFAULT
	}
	return *p.OtherInfo
}

var AgentWorkInfo_Tools_DEFAULT string

func (p *AgentWorkInfo) GetTools() (v string) {
	if !p.IsSetTools() {
		return AgentWorkInfo_Tools_DEFAULT
	}
	return *p.Tools
}

var AgentWorkInfo_Dataset_DEFAULT string

func (p *AgentWorkInfo) GetDataset() (v string) {
	if !p.IsSetDataset() {
		return AgentWorkInfo_Dataset_DEFAULT
	}
	return *p.Dataset
}

var AgentWorkInfo_Workflow_DEFAULT string

func (p *AgentWorkInfo) GetWorkflow() (v string) {
	if !p.IsSetWorkflow() {
		return AgentWorkInfo_Workflow_DEFAULT
	}
	return *p.Workflow
}

var AgentWorkInfo_SystemInfoAll_DEFAULT string

func (p *AgentWorkInfo) GetSystemInfoAll() (v string) {
	if !p.IsSetSystemInfoAll() {
		return AgentWorkInfo_SystemInfoAll_DEFAULT
	}
	return *p.SystemInfoAll
}

var AgentWorkInfo_JumpConfig_DEFAULT *JumpConfig

func (p *AgentWorkInfo) GetJumpConfig() (v *JumpConfig) {
	if !p.IsSetJumpConfig() {
		return AgentWorkInfo_JumpConfig_DEFAULT
	}
	return p.JumpConfig
}

var AgentWorkInfo_SuggestReply_DEFAULT string

func (p *AgentWorkInfo) GetSuggestReply() (v string) {
	if !p.IsSetSuggestReply() {
		return AgentWorkInfo_SuggestReply_DEFAULT
	}
	return *p.SuggestReply
}

var AgentWorkInfo_HookInfo_DEFAULT string

func (p *AgentWorkInfo) GetHookInfo() (v string) {
	if !p.IsSetHookInfo() {
		return AgentWorkInfo_HookInfo_DEFAULT
	}
	return *p.HookInfo
}

var fieldIDToName_AgentWorkInfo = map[int16]string{
	1: "prompt",
	2: "other_info",
	3: "tools",
	4: "dataset",
	5: "workflow",
	6: "system_info_all",
	7: "jump_config",
	8: "suggest_reply",
	9: "hook_info",
}

func (p *AgentWorkInfo) IsSetPrompt() bool {
	return p.Prompt != nil
}

func (p *AgentWorkInfo) IsSetOtherInfo() bool {
	return p.OtherInfo != nil
}

func (p *AgentWorkInfo) IsSetTools() bool {
	return p.Tools != nil
}

func (p *AgentWorkInfo) IsSetDataset() bool {
	return p.Dataset != nil
}

func (p *AgentWorkInfo) IsSetWorkflow() bool {
	return p.Workflow != nil
}

func (p *AgentWorkInfo) IsSetSystemInfoAll() bool {
	return p.SystemInfoAll != nil
}

func (p *AgentWorkInfo) IsSetJumpConfig() bool {
	return p.JumpConfig != nil
}

func (p *AgentWorkInfo) IsSetSuggestReply() bool {
	return p.SuggestReply != nil
}

func (p *AgentWorkInfo) IsSetHookInfo() bool {
	return p.HookInfo != nil
}

func (p *AgentWorkInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_AgentWorkInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *AgentWorkInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Prompt = _field
	return nil
}
func (p *AgentWorkInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OtherInfo = _field
	return nil
}
func (p *AgentWorkInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Tools = _field
	return nil
}
func (p *AgentWorkInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Dataset = _field
	return nil
}
func (p *AgentWorkInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Workflow = _field
	return nil
}
func (p *AgentWorkInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SystemInfoAll = _field
	return nil
}
func (p *AgentWorkInfo) ReadField7(iprot thrift.TProtocol) error {
	_field := NewJumpConfig()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.JumpConfig = _field
	return nil
}
func (p *AgentWorkInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SuggestReply = _field
	return nil
}
func (p *AgentWorkInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HookInfo = _field
	return nil
}

func (p *AgentWorkInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("AgentWorkInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *AgentWorkInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrompt() {
		if err = oprot.WriteFieldBegin("prompt", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Prompt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetOtherInfo() {
		if err = oprot.WriteFieldBegin("other_info", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.OtherInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetTools() {
		if err = oprot.WriteFieldBegin("tools", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Tools); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetDataset() {
		if err = oprot.WriteFieldBegin("dataset", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Dataset); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflow() {
		if err = oprot.WriteFieldBegin("workflow", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Workflow); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetSystemInfoAll() {
		if err = oprot.WriteFieldBegin("system_info_all", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SystemInfoAll); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetJumpConfig() {
		if err = oprot.WriteFieldBegin("jump_config", thrift.STRUCT, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.JumpConfig.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuggestReply() {
		if err = oprot.WriteFieldBegin("suggest_reply", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SuggestReply); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *AgentWorkInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetHookInfo() {
		if err = oprot.WriteFieldBegin("hook_info", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.HookInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}

func (p *AgentWorkInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AgentWorkInfo(%+v)", *p)

}

type JumpConfig struct {
	Backtrack       BacktrackMode          `thrift:"backtrack,1" form:"backtrack" json:"backtrack" query:"backtrack"`
	Recognition     RecognitionMode        `thrift:"recognition,2" form:"recognition" json:"recognition" query:"recognition"`
	IndependentConf *IndependentModeConfig `thrift:"independent_conf,3,optional" form:"independent_conf" json:"independent_conf,omitempty" query:"independent_conf"`
}

func NewJumpConfig() *JumpConfig {
	return &JumpConfig{}
}

func (p *JumpConfig) InitDefault() {
}

func (p *JumpConfig) GetBacktrack() (v BacktrackMode) {
	return p.Backtrack
}

func (p *JumpConfig) GetRecognition() (v RecognitionMode) {
	return p.Recognition
}

var JumpConfig_IndependentConf_DEFAULT *IndependentModeConfig

func (p *JumpConfig) GetIndependentConf() (v *IndependentModeConfig) {
	if !p.IsSetIndependentConf() {
		return JumpConfig_IndependentConf_DEFAULT
	}
	return p.IndependentConf
}

var fieldIDToName_JumpConfig = map[int16]string{
	1: "backtrack",
	2: "recognition",
	3: "independent_conf",
}

func (p *JumpConfig) IsSetIndependentConf() bool {
	return p.IndependentConf != nil
}

func (p *JumpConfig) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_JumpConfig[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *JumpConfig) ReadField1(iprot thrift.TProtocol) error {

	var _field BacktrackMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = BacktrackMode(v)
	}
	p.Backtrack = _field
	return nil
}
func (p *JumpConfig) ReadField2(iprot thrift.TProtocol) error {

	var _field RecognitionMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = RecognitionMode(v)
	}
	p.Recognition = _field
	return nil
}
func (p *JumpConfig) ReadField3(iprot thrift.TProtocol) error {
	_field := NewIndependentModeConfig()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.IndependentConf = _field
	return nil
}

func (p *JumpConfig) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("JumpConfig"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *JumpConfig) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("backtrack", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Backtrack)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *JumpConfig) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("recognition", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Recognition)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *JumpConfig) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetIndependentConf() {
		if err = oprot.WriteFieldBegin("independent_conf", thrift.STRUCT, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.IndependentConf.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *JumpConfig) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("JumpConfig(%+v)", *p)

}

type IndependentModeConfig struct {
	// Judge timing
	JudgeTiming  IndependentTiming               `thrift:"judge_timing,1" form:"judge_timing" json:"judge_timing" query:"judge_timing"`
	HistoryRound int32                           `thrift:"history_round,2" form:"history_round" json:"history_round" query:"history_round"`
	ModelType    IndependentRecognitionModelType `thrift:"model_type,3" form:"model_type" json:"model_type" query:"model_type"`
	ModelID      *string                         `thrift:"model_id,4,optional" form:"model_id" json:"model_id,omitempty" query:"model_id"`
	Prompt       *string                         `thrift:"prompt,5,optional" form:"prompt" json:"prompt,omitempty" query:"prompt"`
}

func NewIndependentModeConfig() *IndependentModeConfig {
	return &IndependentModeConfig{}
}

func (p *IndependentModeConfig) InitDefault() {
}

func (p *IndependentModeConfig) GetJudgeTiming() (v IndependentTiming) {
	return p.JudgeTiming
}

func (p *IndependentModeConfig) GetHistoryRound() (v int32) {
	return p.HistoryRound
}

func (p *IndependentModeConfig) GetModelType() (v IndependentRecognitionModelType) {
	return p.ModelType
}

var IndependentModeConfig_ModelID_DEFAULT string

func (p *IndependentModeConfig) GetModelID() (v string) {
	if !p.IsSetModelID() {
		return IndependentModeConfig_ModelID_DEFAULT
	}
	return *p.ModelID
}

var IndependentModeConfig_Prompt_DEFAULT string

func (p *IndependentModeConfig) GetPrompt() (v string) {
	if !p.IsSetPrompt() {
		return IndependentModeConfig_Prompt_DEFAULT
	}
	return *p.Prompt
}

var fieldIDToName_IndependentModeConfig = map[int16]string{
	1: "judge_timing",
	2: "history_round",
	3: "model_type",
	4: "model_id",
	5: "prompt",
}

func (p *IndependentModeConfig) IsSetModelID() bool {
	return p.ModelID != nil
}

func (p *IndependentModeConfig) IsSetPrompt() bool {
	return p.Prompt != nil
}

func (p *IndependentModeConfig) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_IndependentModeConfig[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *IndependentModeConfig) ReadField1(iprot thrift.TProtocol) error {

	var _field IndependentTiming
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = IndependentTiming(v)
	}
	p.JudgeTiming = _field
	return nil
}
func (p *IndependentModeConfig) ReadField2(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.HistoryRound = _field
	return nil
}
func (p *IndependentModeConfig) ReadField3(iprot thrift.TProtocol) error {

	var _field IndependentRecognitionModelType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = IndependentRecognitionModelType(v)
	}
	p.ModelType = _field
	return nil
}
func (p *IndependentModeConfig) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ModelID = _field
	return nil
}
func (p *IndependentModeConfig) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Prompt = _field
	return nil
}

func (p *IndependentModeConfig) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("IndependentModeConfig"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *IndependentModeConfig) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("judge_timing", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.JudgeTiming)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *IndependentModeConfig) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("history_round", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.HistoryRound); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *IndependentModeConfig) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_type", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ModelType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *IndependentModeConfig) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelID() {
		if err = oprot.WriteFieldBegin("model_id", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ModelID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *IndependentModeConfig) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrompt() {
		if err = oprot.WriteFieldBegin("prompt", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Prompt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *IndependentModeConfig) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("IndependentModeConfig(%+v)", *p)

}

type BotTagInfo struct {
	BotID int64 `thrift:"bot_id,1" form:"bot_id" json:"bot_id" query:"bot_id"`
	// time_capsule
	Key string `thrift:"key,2" form:"key" json:"key" query:"key"`
	// TimeCapsuleInfo json
	Value   string `thrift:"value,3" form:"value" json:"value" query:"value"`
	Version int64  `thrift:"version,4" form:"version" json:"version" query:"version"`
}

func NewBotTagInfo() *BotTagInfo {
	return &BotTagInfo{}
}

func (p *BotTagInfo) InitDefault() {
}

func (p *BotTagInfo) GetBotID() (v int64) {
	return p.BotID
}

func (p *BotTagInfo) GetKey() (v string) {
	return p.Key
}

func (p *BotTagInfo) GetValue() (v string) {
	return p.Value
}

func (p *BotTagInfo) GetVersion() (v int64) {
	return p.Version
}

var fieldIDToName_BotTagInfo = map[int16]string{
	1: "bot_id",
	2: "key",
	3: "value",
	4: "version",
}

func (p *BotTagInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotTagInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotTagInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *BotTagInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Key = _field
	return nil
}
func (p *BotTagInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Value = _field
	return nil
}
func (p *BotTagInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Version = _field
	return nil
}

func (p *BotTagInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotTagInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotTagInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotTagInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("key", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Key); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotTagInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("value", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Value); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotTagInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("version", thrift.I64, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Version); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *BotTagInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotTagInfo(%+v)", *p)

}

type PublishDraftBotRequest struct {
	SpaceID  int64     `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,string,required" query:"space_id,required"`
	BotID    int64     `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	WorkInfo *WorkInfo `thrift:"work_info,3" form:"work_info" json:"work_info" query:"work_info"`
	// Key represents connector_name enumeration Feishu = "feishu" -- obsolete
	ConnectorList map[string][]*Connector `thrift:"connector_list,4" form:"connector_list" json:"connector_list" query:"connector_list"`
	// The key represents connector_id, and the value is the published parameter
	Connectors map[string]map[string]string `thrift:"connectors,5" form:"connectors" json:"connectors" query:"connectors"`
	// Default 0
	BotMode    *BotMode      `thrift:"botMode,6,optional" form:"botMode" json:"botMode,omitempty" query:"botMode"`
	Agents     []*AgentInfo  `thrift:"agents,7,optional" form:"agents" json:"agents,omitempty" query:"agents"`
	CanvasData *string       `thrift:"canvas_data,8,optional" form:"canvas_data" json:"canvas_data,omitempty" query:"canvas_data"`
	BotTagInfo []*BotTagInfo `thrift:"bot_tag_info,9,optional" form:"bot_tag_info" json:"bot_tag_info,omitempty" query:"bot_tag_info"`
	// Configuration published to the market
	SubmitBotMarketConfig *SubmitBotMarketConfig `thrift:"submit_bot_market_config,10,optional" form:"submit_bot_market_config" json:"submit_bot_market_config,omitempty" query:"submit_bot_market_config"`
	PublishID             *string                `thrift:"publish_id,11,optional" form:"publish_id" json:"publish_id,omitempty" query:"publish_id"`
	// Specify the release of a CommitVersion
	CommitVersion *string `thrift:"commit_version,12,optional" form:"commit_version" json:"commit_version,omitempty" query:"commit_version"`
	// Release type, online release/pre-release
	PublishType *PublishType `thrift:"publish_type,13,optional" form:"publish_type" json:"publish_type,omitempty" query:"publish_type"`
	// Pre-release other information
	PrePublishExt *string `thrift:"pre_publish_ext,14,optional" form:"pre_publish_ext" json:"pre_publish_ext,omitempty" query:"pre_publish_ext"`
	// Replace the history_info in the original workinfo
	HistoryInfo *string `thrift:"history_info,15,optional" form:"history_info" json:"history_info,omitempty" query:"history_info"`
}

func NewPublishDraftBotRequest() *PublishDraftBotRequest {
	return &PublishDraftBotRequest{}
}

func (p *PublishDraftBotRequest) InitDefault() {
}

func (p *PublishDraftBotRequest) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *PublishDraftBotRequest) GetBotID() (v int64) {
	return p.BotID
}

var PublishDraftBotRequest_WorkInfo_DEFAULT *WorkInfo

func (p *PublishDraftBotRequest) GetWorkInfo() (v *WorkInfo) {
	if !p.IsSetWorkInfo() {
		return PublishDraftBotRequest_WorkInfo_DEFAULT
	}
	return p.WorkInfo
}

func (p *PublishDraftBotRequest) GetConnectorList() (v map[string][]*Connector) {
	return p.ConnectorList
}

func (p *PublishDraftBotRequest) GetConnectors() (v map[string]map[string]string) {
	return p.Connectors
}

var PublishDraftBotRequest_BotMode_DEFAULT BotMode

func (p *PublishDraftBotRequest) GetBotMode() (v BotMode) {
	if !p.IsSetBotMode() {
		return PublishDraftBotRequest_BotMode_DEFAULT
	}
	return *p.BotMode
}

var PublishDraftBotRequest_Agents_DEFAULT []*AgentInfo

func (p *PublishDraftBotRequest) GetAgents() (v []*AgentInfo) {
	if !p.IsSetAgents() {
		return PublishDraftBotRequest_Agents_DEFAULT
	}
	return p.Agents
}

var PublishDraftBotRequest_CanvasData_DEFAULT string

func (p *PublishDraftBotRequest) GetCanvasData() (v string) {
	if !p.IsSetCanvasData() {
		return PublishDraftBotRequest_CanvasData_DEFAULT
	}
	return *p.CanvasData
}

var PublishDraftBotRequest_BotTagInfo_DEFAULT []*BotTagInfo

func (p *PublishDraftBotRequest) GetBotTagInfo() (v []*BotTagInfo) {
	if !p.IsSetBotTagInfo() {
		return PublishDraftBotRequest_BotTagInfo_DEFAULT
	}
	return p.BotTagInfo
}

var PublishDraftBotRequest_SubmitBotMarketConfig_DEFAULT *SubmitBotMarketConfig

func (p *PublishDraftBotRequest) GetSubmitBotMarketConfig() (v *SubmitBotMarketConfig) {
	if !p.IsSetSubmitBotMarketConfig() {
		return PublishDraftBotRequest_SubmitBotMarketConfig_DEFAULT
	}
	return p.SubmitBotMarketConfig
}

var PublishDraftBotRequest_PublishID_DEFAULT string

func (p *PublishDraftBotRequest) GetPublishID() (v string) {
	if !p.IsSetPublishID() {
		return PublishDraftBotRequest_PublishID_DEFAULT
	}
	return *p.PublishID
}

var PublishDraftBotRequest_CommitVersion_DEFAULT string

func (p *PublishDraftBotRequest) GetCommitVersion() (v string) {
	if !p.IsSetCommitVersion() {
		return PublishDraftBotRequest_CommitVersion_DEFAULT
	}
	return *p.CommitVersion
}

var PublishDraftBotRequest_PublishType_DEFAULT PublishType

func (p *PublishDraftBotRequest) GetPublishType() (v PublishType) {
	if !p.IsSetPublishType() {
		return PublishDraftBotRequest_PublishType_DEFAULT
	}
	return *p.PublishType
}

var PublishDraftBotRequest_PrePublishExt_DEFAULT string

func (p *PublishDraftBotRequest) GetPrePublishExt() (v string) {
	if !p.IsSetPrePublishExt() {
		return PublishDraftBotRequest_PrePublishExt_DEFAULT
	}
	return *p.PrePublishExt
}

var PublishDraftBotRequest_HistoryInfo_DEFAULT string

func (p *PublishDraftBotRequest) GetHistoryInfo() (v string) {
	if !p.IsSetHistoryInfo() {
		return PublishDraftBotRequest_HistoryInfo_DEFAULT
	}
	return *p.HistoryInfo
}

var fieldIDToName_PublishDraftBotRequest = map[int16]string{
	1:  "space_id",
	2:  "bot_id",
	3:  "work_info",
	4:  "connector_list",
	5:  "connectors",
	6:  "botMode",
	7:  "agents",
	8:  "canvas_data",
	9:  "bot_tag_info",
	10: "submit_bot_market_config",
	11: "publish_id",
	12: "commit_version",
	13: "publish_type",
	14: "pre_publish_ext",
	15: "history_info",
}

func (p *PublishDraftBotRequest) IsSetWorkInfo() bool {
	return p.WorkInfo != nil
}

func (p *PublishDraftBotRequest) IsSetBotMode() bool {
	return p.BotMode != nil
}

func (p *PublishDraftBotRequest) IsSetAgents() bool {
	return p.Agents != nil
}

func (p *PublishDraftBotRequest) IsSetCanvasData() bool {
	return p.CanvasData != nil
}

func (p *PublishDraftBotRequest) IsSetBotTagInfo() bool {
	return p.BotTagInfo != nil
}

func (p *PublishDraftBotRequest) IsSetSubmitBotMarketConfig() bool {
	return p.SubmitBotMarketConfig != nil
}

func (p *PublishDraftBotRequest) IsSetPublishID() bool {
	return p.PublishID != nil
}

func (p *PublishDraftBotRequest) IsSetCommitVersion() bool {
	return p.CommitVersion != nil
}

func (p *PublishDraftBotRequest) IsSetPublishType() bool {
	return p.PublishType != nil
}

func (p *PublishDraftBotRequest) IsSetPrePublishExt() bool {
	return p.PrePublishExt != nil
}

func (p *PublishDraftBotRequest) IsSetHistoryInfo() bool {
	return p.HistoryInfo != nil
}

func (p *PublishDraftBotRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishDraftBotRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_PublishDraftBotRequest[fieldId]))
}

func (p *PublishDraftBotRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField3(iprot thrift.TProtocol) error {
	_field := NewWorkInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.WorkInfo = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField4(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string][]*Connector, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}
		_, size, err := iprot.ReadListBegin()
		if err != nil {
			return err
		}
		_val := make([]*Connector, 0, size)
		values := make([]Connector, size)
		for i := 0; i < size; i++ {
			_elem := &values[i]
			_elem.InitDefault()

			if err := _elem.Read(iprot); err != nil {
				return err
			}

			_val = append(_val, _elem)
		}
		if err := iprot.ReadListEnd(); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.ConnectorList = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField5(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]map[string]string, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}
		_, _, size, err := iprot.ReadMapBegin()
		if err != nil {
			return err
		}
		_val := make(map[string]string, size)
		for i := 0; i < size; i++ {
			var _key1 string
			if v, err := iprot.ReadString(); err != nil {
				return err
			} else {
				_key1 = v
			}

			var _val1 string
			if v, err := iprot.ReadString(); err != nil {
				return err
			} else {
				_val1 = v
			}

			_val[_key1] = _val1
		}
		if err := iprot.ReadMapEnd(); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.Connectors = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *BotMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := BotMode(v)
		_field = &tmp
	}
	p.BotMode = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField7(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*AgentInfo, 0, size)
	values := make([]AgentInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Agents = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CanvasData = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField9(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*BotTagInfo, 0, size)
	values := make([]BotTagInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.BotTagInfo = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField10(iprot thrift.TProtocol) error {
	_field := NewSubmitBotMarketConfig()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.SubmitBotMarketConfig = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField11(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PublishID = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField12(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitVersion = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField13(iprot thrift.TProtocol) error {

	var _field *PublishType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := PublishType(v)
		_field = &tmp
	}
	p.PublishType = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrePublishExt = _field
	return nil
}
func (p *PublishDraftBotRequest) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HistoryInfo = _field
	return nil
}

func (p *PublishDraftBotRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishDraftBotRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishDraftBotRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("work_info", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.WorkInfo.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connector_list", thrift.MAP, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.LIST, len(p.ConnectorList)); err != nil {
		return err
	}
	for k, v := range p.ConnectorList {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(v)); err != nil {
			return err
		}
		for _, v := range v {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connectors", thrift.MAP, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.MAP, len(p.Connectors)); err != nil {
		return err
	}
	for k, v := range p.Connectors {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRING, len(v)); err != nil {
			return err
		}
		for k, v := range v {
			if err := oprot.WriteString(k); err != nil {
				return err
			}
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotMode() {
		if err = oprot.WriteFieldBegin("botMode", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.BotMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetAgents() {
		if err = oprot.WriteFieldBegin("agents", thrift.LIST, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Agents)); err != nil {
			return err
		}
		for _, v := range p.Agents {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetCanvasData() {
		if err = oprot.WriteFieldBegin("canvas_data", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CanvasData); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotTagInfo() {
		if err = oprot.WriteFieldBegin("bot_tag_info", thrift.LIST, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.BotTagInfo)); err != nil {
			return err
		}
		for _, v := range p.BotTagInfo {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubmitBotMarketConfig() {
		if err = oprot.WriteFieldBegin("submit_bot_market_config", thrift.STRUCT, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.SubmitBotMarketConfig.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishID() {
		if err = oprot.WriteFieldBegin("publish_id", thrift.STRING, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PublishID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitVersion() {
		if err = oprot.WriteFieldBegin("commit_version", thrift.STRING, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishType() {
		if err = oprot.WriteFieldBegin("publish_type", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.PublishType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrePublishExt() {
		if err = oprot.WriteFieldBegin("pre_publish_ext", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PrePublishExt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *PublishDraftBotRequest) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetHistoryInfo() {
		if err = oprot.WriteFieldBegin("history_info", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.HistoryInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}

func (p *PublishDraftBotRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishDraftBotRequest(%+v)", *p)

}

type SubmitBotMarketConfig struct {
	// Whether to publish to the market
	NeedSubmit *bool `thrift:"need_submit,1,optional" form:"need_submit" json:"need_submit,omitempty" query:"need_submit"`
	// Is it open source?
	OpenSource *bool `thrift:"open_source,2,optional" form:"open_source" json:"open_source,omitempty" query:"open_source"`
	// classification
	CategoryID *string `thrift:"category_id,3,optional" form:"category_id" json:"category_id,omitempty" query:"category_id"`
}

func NewSubmitBotMarketConfig() *SubmitBotMarketConfig {
	return &SubmitBotMarketConfig{}
}

func (p *SubmitBotMarketConfig) InitDefault() {
}

var SubmitBotMarketConfig_NeedSubmit_DEFAULT bool

func (p *SubmitBotMarketConfig) GetNeedSubmit() (v bool) {
	if !p.IsSetNeedSubmit() {
		return SubmitBotMarketConfig_NeedSubmit_DEFAULT
	}
	return *p.NeedSubmit
}

var SubmitBotMarketConfig_OpenSource_DEFAULT bool

func (p *SubmitBotMarketConfig) GetOpenSource() (v bool) {
	if !p.IsSetOpenSource() {
		return SubmitBotMarketConfig_OpenSource_DEFAULT
	}
	return *p.OpenSource
}

var SubmitBotMarketConfig_CategoryID_DEFAULT string

func (p *SubmitBotMarketConfig) GetCategoryID() (v string) {
	if !p.IsSetCategoryID() {
		return SubmitBotMarketConfig_CategoryID_DEFAULT
	}
	return *p.CategoryID
}

var fieldIDToName_SubmitBotMarketConfig = map[int16]string{
	1: "need_submit",
	2: "open_source",
	3: "category_id",
}

func (p *SubmitBotMarketConfig) IsSetNeedSubmit() bool {
	return p.NeedSubmit != nil
}

func (p *SubmitBotMarketConfig) IsSetOpenSource() bool {
	return p.OpenSource != nil
}

func (p *SubmitBotMarketConfig) IsSetCategoryID() bool {
	return p.CategoryID != nil
}

func (p *SubmitBotMarketConfig) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SubmitBotMarketConfig[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SubmitBotMarketConfig) ReadField1(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedSubmit = _field
	return nil
}
func (p *SubmitBotMarketConfig) ReadField2(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OpenSource = _field
	return nil
}
func (p *SubmitBotMarketConfig) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CategoryID = _field
	return nil
}

func (p *SubmitBotMarketConfig) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SubmitBotMarketConfig"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SubmitBotMarketConfig) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedSubmit() {
		if err = oprot.WriteFieldBegin("need_submit", thrift.BOOL, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedSubmit); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SubmitBotMarketConfig) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetOpenSource() {
		if err = oprot.WriteFieldBegin("open_source", thrift.BOOL, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.OpenSource); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SubmitBotMarketConfig) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCategoryID() {
		if err = oprot.WriteFieldBegin("category_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CategoryID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *SubmitBotMarketConfig) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SubmitBotMarketConfig(%+v)", *p)

}

// Information for each module in the workspace
type WorkInfo struct {
	MessageInfo             *string `thrift:"message_info,1,optional" form:"message_info" json:"message_info,omitempty" query:"message_info"`
	Prompt                  *string `thrift:"prompt,2,optional" form:"prompt" json:"prompt,omitempty" query:"prompt"`
	Variable                *string `thrift:"variable,3,optional" form:"variable" json:"variable,omitempty" query:"variable"`
	OtherInfo               *string `thrift:"other_info,4,optional" form:"other_info" json:"other_info,omitempty" query:"other_info"`
	HistoryInfo             *string `thrift:"history_info,5,optional" form:"history_info" json:"history_info,omitempty" query:"history_info"`
	Tools                   *string `thrift:"tools,6,optional" form:"tools" json:"tools,omitempty" query:"tools"`
	SystemInfoAll           *string `thrift:"system_info_all,7,optional" form:"system_info_all" json:"system_info_all,omitempty" query:"system_info_all"`
	Dataset                 *string `thrift:"dataset,8,optional" form:"dataset" json:"dataset,omitempty" query:"dataset"`
	Onboarding              *string `thrift:"onboarding,9,optional" form:"onboarding" json:"onboarding,omitempty" query:"onboarding"`
	ProfileMemory           *string `thrift:"profile_memory,10,optional" form:"profile_memory" json:"profile_memory,omitempty" query:"profile_memory"`
	TableInfo               *string `thrift:"table_info,11,optional" form:"table_info" json:"table_info,omitempty" query:"table_info"`
	Workflow                *string `thrift:"workflow,12,optional" form:"workflow" json:"workflow,omitempty" query:"workflow"`
	Task                    *string `thrift:"task,13,optional" form:"task" json:"task,omitempty" query:"task"`
	SuggestReply            *string `thrift:"suggest_reply,14,optional" form:"suggest_reply" json:"suggest_reply,omitempty" query:"suggest_reply"`
	Tts                     *string `thrift:"tts,15,optional" form:"tts" json:"tts,omitempty" query:"tts"`
	BackgroundImageInfoList *string `thrift:"background_image_info_list,16,optional" form:"background_image_info_list" json:"background_image_info_list,omitempty" query:"background_image_info_list"`
	// Quick Instruction
	Shortcuts *playground.ShortcutStruct `thrift:"shortcuts,17,optional" form:"shortcuts" json:"shortcuts,omitempty" query:"shortcuts"`
	// Hook configuration
	HookInfo *string `thrift:"hook_info,18,optional" form:"hook_info" json:"hook_info,omitempty" query:"hook_info"`
	// User query collection configuration
	UserQueryCollectConf *UserQueryCollectConf `thrift:"user_query_collect_conf,19,optional" form:"user_query_collect_conf" json:"user_query_collect_conf,omitempty" query:"user_query_collect_conf"`
	//Workflow pattern orchestration data
	LayoutInfo *LayoutInfo `thrift:"layout_info,20,optional" form:"layout_info" json:"layout_info,omitempty" query:"layout_info"`
}

func NewWorkInfo() *WorkInfo {
	return &WorkInfo{}
}

func (p *WorkInfo) InitDefault() {
}

var WorkInfo_MessageInfo_DEFAULT string

func (p *WorkInfo) GetMessageInfo() (v string) {
	if !p.IsSetMessageInfo() {
		return WorkInfo_MessageInfo_DEFAULT
	}
	return *p.MessageInfo
}

var WorkInfo_Prompt_DEFAULT string

func (p *WorkInfo) GetPrompt() (v string) {
	if !p.IsSetPrompt() {
		return WorkInfo_Prompt_DEFAULT
	}
	return *p.Prompt
}

var WorkInfo_Variable_DEFAULT string

func (p *WorkInfo) GetVariable() (v string) {
	if !p.IsSetVariable() {
		return WorkInfo_Variable_DEFAULT
	}
	return *p.Variable
}

var WorkInfo_OtherInfo_DEFAULT string

func (p *WorkInfo) GetOtherInfo() (v string) {
	if !p.IsSetOtherInfo() {
		return WorkInfo_OtherInfo_DEFAULT
	}
	return *p.OtherInfo
}

var WorkInfo_HistoryInfo_DEFAULT string

func (p *WorkInfo) GetHistoryInfo() (v string) {
	if !p.IsSetHistoryInfo() {
		return WorkInfo_HistoryInfo_DEFAULT
	}
	return *p.HistoryInfo
}

var WorkInfo_Tools_DEFAULT string

func (p *WorkInfo) GetTools() (v string) {
	if !p.IsSetTools() {
		return WorkInfo_Tools_DEFAULT
	}
	return *p.Tools
}

var WorkInfo_SystemInfoAll_DEFAULT string

func (p *WorkInfo) GetSystemInfoAll() (v string) {
	if !p.IsSetSystemInfoAll() {
		return WorkInfo_SystemInfoAll_DEFAULT
	}
	return *p.SystemInfoAll
}

var WorkInfo_Dataset_DEFAULT string

func (p *WorkInfo) GetDataset() (v string) {
	if !p.IsSetDataset() {
		return WorkInfo_Dataset_DEFAULT
	}
	return *p.Dataset
}

var WorkInfo_Onboarding_DEFAULT string

func (p *WorkInfo) GetOnboarding() (v string) {
	if !p.IsSetOnboarding() {
		return WorkInfo_Onboarding_DEFAULT
	}
	return *p.Onboarding
}

var WorkInfo_ProfileMemory_DEFAULT string

func (p *WorkInfo) GetProfileMemory() (v string) {
	if !p.IsSetProfileMemory() {
		return WorkInfo_ProfileMemory_DEFAULT
	}
	return *p.ProfileMemory
}

var WorkInfo_TableInfo_DEFAULT string

func (p *WorkInfo) GetTableInfo() (v string) {
	if !p.IsSetTableInfo() {
		return WorkInfo_TableInfo_DEFAULT
	}
	return *p.TableInfo
}

var WorkInfo_Workflow_DEFAULT string

func (p *WorkInfo) GetWorkflow() (v string) {
	if !p.IsSetWorkflow() {
		return WorkInfo_Workflow_DEFAULT
	}
	return *p.Workflow
}

var WorkInfo_Task_DEFAULT string

func (p *WorkInfo) GetTask() (v string) {
	if !p.IsSetTask() {
		return WorkInfo_Task_DEFAULT
	}
	return *p.Task
}

var WorkInfo_SuggestReply_DEFAULT string

func (p *WorkInfo) GetSuggestReply() (v string) {
	if !p.IsSetSuggestReply() {
		return WorkInfo_SuggestReply_DEFAULT
	}
	return *p.SuggestReply
}

var WorkInfo_Tts_DEFAULT string

func (p *WorkInfo) GetTts() (v string) {
	if !p.IsSetTts() {
		return WorkInfo_Tts_DEFAULT
	}
	return *p.Tts
}

var WorkInfo_BackgroundImageInfoList_DEFAULT string

func (p *WorkInfo) GetBackgroundImageInfoList() (v string) {
	if !p.IsSetBackgroundImageInfoList() {
		return WorkInfo_BackgroundImageInfoList_DEFAULT
	}
	return *p.BackgroundImageInfoList
}

var WorkInfo_Shortcuts_DEFAULT *playground.ShortcutStruct

func (p *WorkInfo) GetShortcuts() (v *playground.ShortcutStruct) {
	if !p.IsSetShortcuts() {
		return WorkInfo_Shortcuts_DEFAULT
	}
	return p.Shortcuts
}

var WorkInfo_HookInfo_DEFAULT string

func (p *WorkInfo) GetHookInfo() (v string) {
	if !p.IsSetHookInfo() {
		return WorkInfo_HookInfo_DEFAULT
	}
	return *p.HookInfo
}

var WorkInfo_UserQueryCollectConf_DEFAULT *UserQueryCollectConf

func (p *WorkInfo) GetUserQueryCollectConf() (v *UserQueryCollectConf) {
	if !p.IsSetUserQueryCollectConf() {
		return WorkInfo_UserQueryCollectConf_DEFAULT
	}
	return p.UserQueryCollectConf
}

var WorkInfo_LayoutInfo_DEFAULT *LayoutInfo

func (p *WorkInfo) GetLayoutInfo() (v *LayoutInfo) {
	if !p.IsSetLayoutInfo() {
		return WorkInfo_LayoutInfo_DEFAULT
	}
	return p.LayoutInfo
}

var fieldIDToName_WorkInfo = map[int16]string{
	1:  "message_info",
	2:  "prompt",
	3:  "variable",
	4:  "other_info",
	5:  "history_info",
	6:  "tools",
	7:  "system_info_all",
	8:  "dataset",
	9:  "onboarding",
	10: "profile_memory",
	11: "table_info",
	12: "workflow",
	13: "task",
	14: "suggest_reply",
	15: "tts",
	16: "background_image_info_list",
	17: "shortcuts",
	18: "hook_info",
	19: "user_query_collect_conf",
	20: "layout_info",
}

func (p *WorkInfo) IsSetMessageInfo() bool {
	return p.MessageInfo != nil
}

func (p *WorkInfo) IsSetPrompt() bool {
	return p.Prompt != nil
}

func (p *WorkInfo) IsSetVariable() bool {
	return p.Variable != nil
}

func (p *WorkInfo) IsSetOtherInfo() bool {
	return p.OtherInfo != nil
}

func (p *WorkInfo) IsSetHistoryInfo() bool {
	return p.HistoryInfo != nil
}

func (p *WorkInfo) IsSetTools() bool {
	return p.Tools != nil
}

func (p *WorkInfo) IsSetSystemInfoAll() bool {
	return p.SystemInfoAll != nil
}

func (p *WorkInfo) IsSetDataset() bool {
	return p.Dataset != nil
}

func (p *WorkInfo) IsSetOnboarding() bool {
	return p.Onboarding != nil
}

func (p *WorkInfo) IsSetProfileMemory() bool {
	return p.ProfileMemory != nil
}

func (p *WorkInfo) IsSetTableInfo() bool {
	return p.TableInfo != nil
}

func (p *WorkInfo) IsSetWorkflow() bool {
	return p.Workflow != nil
}

func (p *WorkInfo) IsSetTask() bool {
	return p.Task != nil
}

func (p *WorkInfo) IsSetSuggestReply() bool {
	return p.SuggestReply != nil
}

func (p *WorkInfo) IsSetTts() bool {
	return p.Tts != nil
}

func (p *WorkInfo) IsSetBackgroundImageInfoList() bool {
	return p.BackgroundImageInfoList != nil
}

func (p *WorkInfo) IsSetShortcuts() bool {
	return p.Shortcuts != nil
}

func (p *WorkInfo) IsSetHookInfo() bool {
	return p.HookInfo != nil
}

func (p *WorkInfo) IsSetUserQueryCollectConf() bool {
	return p.UserQueryCollectConf != nil
}

func (p *WorkInfo) IsSetLayoutInfo() bool {
	return p.LayoutInfo != nil
}

func (p *WorkInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.MessageInfo = _field
	return nil
}
func (p *WorkInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Prompt = _field
	return nil
}
func (p *WorkInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Variable = _field
	return nil
}
func (p *WorkInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OtherInfo = _field
	return nil
}
func (p *WorkInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HistoryInfo = _field
	return nil
}
func (p *WorkInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Tools = _field
	return nil
}
func (p *WorkInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SystemInfoAll = _field
	return nil
}
func (p *WorkInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Dataset = _field
	return nil
}
func (p *WorkInfo) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Onboarding = _field
	return nil
}
func (p *WorkInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProfileMemory = _field
	return nil
}
func (p *WorkInfo) ReadField11(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TableInfo = _field
	return nil
}
func (p *WorkInfo) ReadField12(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Workflow = _field
	return nil
}
func (p *WorkInfo) ReadField13(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Task = _field
	return nil
}
func (p *WorkInfo) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SuggestReply = _field
	return nil
}
func (p *WorkInfo) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Tts = _field
	return nil
}
func (p *WorkInfo) ReadField16(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BackgroundImageInfoList = _field
	return nil
}
func (p *WorkInfo) ReadField17(iprot thrift.TProtocol) error {
	_field := playground.NewShortcutStruct()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Shortcuts = _field
	return nil
}
func (p *WorkInfo) ReadField18(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HookInfo = _field
	return nil
}
func (p *WorkInfo) ReadField19(iprot thrift.TProtocol) error {
	_field := NewUserQueryCollectConf()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserQueryCollectConf = _field
	return nil
}
func (p *WorkInfo) ReadField20(iprot thrift.TProtocol) error {
	_field := NewLayoutInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.LayoutInfo = _field
	return nil
}

func (p *WorkInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetMessageInfo() {
		if err = oprot.WriteFieldBegin("message_info", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.MessageInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrompt() {
		if err = oprot.WriteFieldBegin("prompt", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Prompt); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetVariable() {
		if err = oprot.WriteFieldBegin("variable", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Variable); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetOtherInfo() {
		if err = oprot.WriteFieldBegin("other_info", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.OtherInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetHistoryInfo() {
		if err = oprot.WriteFieldBegin("history_info", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.HistoryInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WorkInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetTools() {
		if err = oprot.WriteFieldBegin("tools", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Tools); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *WorkInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetSystemInfoAll() {
		if err = oprot.WriteFieldBegin("system_info_all", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SystemInfoAll); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *WorkInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetDataset() {
		if err = oprot.WriteFieldBegin("dataset", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Dataset); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *WorkInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetOnboarding() {
		if err = oprot.WriteFieldBegin("onboarding", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Onboarding); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *WorkInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetProfileMemory() {
		if err = oprot.WriteFieldBegin("profile_memory", thrift.STRING, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProfileMemory); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *WorkInfo) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetTableInfo() {
		if err = oprot.WriteFieldBegin("table_info", thrift.STRING, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.TableInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *WorkInfo) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflow() {
		if err = oprot.WriteFieldBegin("workflow", thrift.STRING, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Workflow); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *WorkInfo) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetTask() {
		if err = oprot.WriteFieldBegin("task", thrift.STRING, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Task); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *WorkInfo) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuggestReply() {
		if err = oprot.WriteFieldBegin("suggest_reply", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SuggestReply); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *WorkInfo) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetTts() {
		if err = oprot.WriteFieldBegin("tts", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Tts); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *WorkInfo) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetBackgroundImageInfoList() {
		if err = oprot.WriteFieldBegin("background_image_info_list", thrift.STRING, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BackgroundImageInfoList); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *WorkInfo) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetShortcuts() {
		if err = oprot.WriteFieldBegin("shortcuts", thrift.STRUCT, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Shortcuts.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *WorkInfo) writeField18(oprot thrift.TProtocol) (err error) {
	if p.IsSetHookInfo() {
		if err = oprot.WriteFieldBegin("hook_info", thrift.STRING, 18); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.HookInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *WorkInfo) writeField19(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserQueryCollectConf() {
		if err = oprot.WriteFieldBegin("user_query_collect_conf", thrift.STRUCT, 19); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.UserQueryCollectConf.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *WorkInfo) writeField20(oprot thrift.TProtocol) (err error) {
	if p.IsSetLayoutInfo() {
		if err = oprot.WriteFieldBegin("layout_info", thrift.STRUCT, 20); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.LayoutInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}

func (p *WorkInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkInfo(%+v)", *p)

}

type UserQueryCollectConf struct {
	// Whether to turn on the collection switch
	IsCollected bool `thrift:"IsCollected,1" form:"is_collected" json:"is_collected"`
	// Privacy Policy Link
	PrivatePolicy string `thrift:"PrivatePolicy,2" form:"private_policy" json:"private_policy"`
}

func NewUserQueryCollectConf() *UserQueryCollectConf {
	return &UserQueryCollectConf{}
}

func (p *UserQueryCollectConf) InitDefault() {
}

func (p *UserQueryCollectConf) GetIsCollected() (v bool) {
	return p.IsCollected
}

func (p *UserQueryCollectConf) GetPrivatePolicy() (v string) {
	return p.PrivatePolicy
}

var fieldIDToName_UserQueryCollectConf = map[int16]string{
	1: "IsCollected",
	2: "PrivatePolicy",
}

func (p *UserQueryCollectConf) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserQueryCollectConf[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UserQueryCollectConf) ReadField1(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsCollected = _field
	return nil
}
func (p *UserQueryCollectConf) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PrivatePolicy = _field
	return nil
}

func (p *UserQueryCollectConf) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserQueryCollectConf"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserQueryCollectConf) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("IsCollected", thrift.BOOL, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsCollected); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UserQueryCollectConf) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PrivatePolicy", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PrivatePolicy); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UserQueryCollectConf) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserQueryCollectConf(%+v)", *p)

}

type LayoutInfo struct {
	// workflowId
	WorkflowId string `thrift:"WorkflowId,1" form:"workflow_id" json:"workflow_id"`
	// PluginId
	PluginId string `thrift:"PluginId,2" form:"plugin_id" json:"plugin_id"`
}

func NewLayoutInfo() *LayoutInfo {
	return &LayoutInfo{}
}

func (p *LayoutInfo) InitDefault() {
}

func (p *LayoutInfo) GetWorkflowId() (v string) {
	return p.WorkflowId
}

func (p *LayoutInfo) GetPluginId() (v string) {
	return p.PluginId
}

var fieldIDToName_LayoutInfo = map[int16]string{
	1: "WorkflowId",
	2: "PluginId",
}

func (p *LayoutInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_LayoutInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *LayoutInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowId = _field
	return nil
}
func (p *LayoutInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginId = _field
	return nil
}

func (p *LayoutInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("LayoutInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *LayoutInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("WorkflowId", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowId); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *LayoutInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("PluginId", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PluginId); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *LayoutInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("LayoutInfo(%+v)", *p)

}

type ListDraftBotHistoryRequest struct {
	SpaceID     int64       `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,string,required" query:"space_id,required"`
	BotID       int64       `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	PageIndex   int32       `thrift:"page_index,3,required" form:"page_index,required" json:"page_index,required" query:"page_index,required"`
	PageSize    int32       `thrift:"page_size,4,required" form:"page_size,required" json:"page_size,required" query:"page_size,required"`
	HistoryType HistoryType `thrift:"history_type,5,required" form:"history_type,required" json:"history_type,required" query:"history_type,required"`
	ConnectorID *string     `thrift:"connector_id,6,optional" form:"connector_id" json:"connector_id,omitempty" query:"connector_id"`
}

func NewListDraftBotHistoryRequest() *ListDraftBotHistoryRequest {
	return &ListDraftBotHistoryRequest{}
}

func (p *ListDraftBotHistoryRequest) InitDefault() {
}

func (p *ListDraftBotHistoryRequest) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *ListDraftBotHistoryRequest) GetBotID() (v int64) {
	return p.BotID
}

func (p *ListDraftBotHistoryRequest) GetPageIndex() (v int32) {
	return p.PageIndex
}

func (p *ListDraftBotHistoryRequest) GetPageSize() (v int32) {
	return p.PageSize
}

func (p *ListDraftBotHistoryRequest) GetHistoryType() (v HistoryType) {
	return p.HistoryType
}

var ListDraftBotHistoryRequest_ConnectorID_DEFAULT string

func (p *ListDraftBotHistoryRequest) GetConnectorID() (v string) {
	if !p.IsSetConnectorID() {
		return ListDraftBotHistoryRequest_ConnectorID_DEFAULT
	}
	return *p.ConnectorID
}

var fieldIDToName_ListDraftBotHistoryRequest = map[int16]string{
	1: "space_id",
	2: "bot_id",
	3: "page_index",
	4: "page_size",
	5: "history_type",
	6: "connector_id",
}

func (p *ListDraftBotHistoryRequest) IsSetConnectorID() bool {
	return p.ConnectorID != nil
}

func (p *ListDraftBotHistoryRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false
	var issetBotID bool = false
	var issetPageIndex bool = false
	var issetPageSize bool = false
	var issetHistoryType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetPageIndex = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetPageSize = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
				issetHistoryType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetPageIndex {
		fieldId = 3
		goto RequiredFieldNotSetError
	}

	if !issetPageSize {
		fieldId = 4
		goto RequiredFieldNotSetError
	}

	if !issetHistoryType {
		fieldId = 5
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ListDraftBotHistoryRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ListDraftBotHistoryRequest[fieldId]))
}

func (p *ListDraftBotHistoryRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *ListDraftBotHistoryRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *ListDraftBotHistoryRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PageIndex = _field
	return nil
}
func (p *ListDraftBotHistoryRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PageSize = _field
	return nil
}
func (p *ListDraftBotHistoryRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field HistoryType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = HistoryType(v)
	}
	p.HistoryType = _field
	return nil
}
func (p *ListDraftBotHistoryRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ConnectorID = _field
	return nil
}

func (p *ListDraftBotHistoryRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListDraftBotHistoryRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ListDraftBotHistoryRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ListDraftBotHistoryRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ListDraftBotHistoryRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("page_index", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.PageIndex); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ListDraftBotHistoryRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("page_size", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.PageSize); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ListDraftBotHistoryRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("history_type", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.HistoryType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ListDraftBotHistoryRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetConnectorID() {
		if err = oprot.WriteFieldBegin("connector_id", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ConnectorID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}

func (p *ListDraftBotHistoryRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ListDraftBotHistoryRequest(%+v)", *p)

}

type ListDraftBotHistoryResponse struct {
	Code int64                    `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string                   `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *ListDraftBotHistoryData `thrift:"data,3,required" form:"data,required" json:"data,required" query:"data,required"`
}

func NewListDraftBotHistoryResponse() *ListDraftBotHistoryResponse {
	return &ListDraftBotHistoryResponse{}
}

func (p *ListDraftBotHistoryResponse) InitDefault() {
}

func (p *ListDraftBotHistoryResponse) GetCode() (v int64) {
	return p.Code
}

func (p *ListDraftBotHistoryResponse) GetMsg() (v string) {
	return p.Msg
}

var ListDraftBotHistoryResponse_Data_DEFAULT *ListDraftBotHistoryData

func (p *ListDraftBotHistoryResponse) GetData() (v *ListDraftBotHistoryData) {
	if !p.IsSetData() {
		return ListDraftBotHistoryResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_ListDraftBotHistoryResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *ListDraftBotHistoryResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *ListDraftBotHistoryResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ListDraftBotHistoryResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ListDraftBotHistoryResponse[fieldId]))
}

func (p *ListDraftBotHistoryResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *ListDraftBotHistoryResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *ListDraftBotHistoryResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewListDraftBotHistoryData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *ListDraftBotHistoryResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListDraftBotHistoryResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ListDraftBotHistoryResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ListDraftBotHistoryResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ListDraftBotHistoryResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *ListDraftBotHistoryResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ListDraftBotHistoryResponse(%+v)", *p)

}

type ListDraftBotHistoryData struct {
	HistoryInfos []*HistoryInfo `thrift:"history_infos,1" form:"history_infos" json:"history_infos" query:"history_infos"`
	Total        int32          `thrift:"total,2" form:"total" json:"total" query:"total"`
}

func NewListDraftBotHistoryData() *ListDraftBotHistoryData {
	return &ListDraftBotHistoryData{}
}

func (p *ListDraftBotHistoryData) InitDefault() {
}

func (p *ListDraftBotHistoryData) GetHistoryInfos() (v []*HistoryInfo) {
	return p.HistoryInfos
}

func (p *ListDraftBotHistoryData) GetTotal() (v int32) {
	return p.Total
}

var fieldIDToName_ListDraftBotHistoryData = map[int16]string{
	1: "history_infos",
	2: "total",
}

func (p *ListDraftBotHistoryData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ListDraftBotHistoryData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ListDraftBotHistoryData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*HistoryInfo, 0, size)
	values := make([]HistoryInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.HistoryInfos = _field
	return nil
}
func (p *ListDraftBotHistoryData) ReadField2(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Total = _field
	return nil
}

func (p *ListDraftBotHistoryData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListDraftBotHistoryData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ListDraftBotHistoryData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("history_infos", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.HistoryInfos)); err != nil {
		return err
	}
	for _, v := range p.HistoryInfos {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ListDraftBotHistoryData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("total", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Total); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *ListDraftBotHistoryData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ListDraftBotHistoryData(%+v)", *p)

}

// If historical information is preserved
type HistoryInfo struct {
	Version     string      `thrift:"version,1" form:"version" json:"version" query:"version"`
	HistoryType HistoryType `thrift:"history_type,2" form:"history_type" json:"history_type" query:"history_type"`
	// Additional information added to the historical record
	Info           string           `thrift:"info,3" form:"info" json:"info" query:"info"`
	CreateTime     string           `thrift:"create_time,4" form:"create_time" json:"create_time" query:"create_time"`
	ConnectorInfos []*ConnectorInfo `thrift:"connector_infos,5" form:"connector_infos" json:"connector_infos" query:"connector_infos"`
	Creator        *Creator         `thrift:"creator,6" form:"creator" json:"creator" query:"creator"`
	PublishID      *string          `thrift:"publish_id,7,optional" form:"publish_id" json:"publish_id,omitempty" query:"publish_id"`
	// Instructions to fill in when submitting
	CommitRemark *string `thrift:"commit_remark,8,optional" form:"commit_remark" json:"commit_remark,omitempty" query:"commit_remark"`
}

func NewHistoryInfo() *HistoryInfo {
	return &HistoryInfo{}
}

func (p *HistoryInfo) InitDefault() {
}

func (p *HistoryInfo) GetVersion() (v string) {
	return p.Version
}

func (p *HistoryInfo) GetHistoryType() (v HistoryType) {
	return p.HistoryType
}

func (p *HistoryInfo) GetInfo() (v string) {
	return p.Info
}

func (p *HistoryInfo) GetCreateTime() (v string) {
	return p.CreateTime
}

func (p *HistoryInfo) GetConnectorInfos() (v []*ConnectorInfo) {
	return p.ConnectorInfos
}

var HistoryInfo_Creator_DEFAULT *Creator

func (p *HistoryInfo) GetCreator() (v *Creator) {
	if !p.IsSetCreator() {
		return HistoryInfo_Creator_DEFAULT
	}
	return p.Creator
}

var HistoryInfo_PublishID_DEFAULT string

func (p *HistoryInfo) GetPublishID() (v string) {
	if !p.IsSetPublishID() {
		return HistoryInfo_PublishID_DEFAULT
	}
	return *p.PublishID
}

var HistoryInfo_CommitRemark_DEFAULT string

func (p *HistoryInfo) GetCommitRemark() (v string) {
	if !p.IsSetCommitRemark() {
		return HistoryInfo_CommitRemark_DEFAULT
	}
	return *p.CommitRemark
}

var fieldIDToName_HistoryInfo = map[int16]string{
	1: "version",
	2: "history_type",
	3: "info",
	4: "create_time",
	5: "connector_infos",
	6: "creator",
	7: "publish_id",
	8: "commit_remark",
}

func (p *HistoryInfo) IsSetCreator() bool {
	return p.Creator != nil
}

func (p *HistoryInfo) IsSetPublishID() bool {
	return p.PublishID != nil
}

func (p *HistoryInfo) IsSetCommitRemark() bool {
	return p.CommitRemark != nil
}

func (p *HistoryInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_HistoryInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *HistoryInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Version = _field
	return nil
}
func (p *HistoryInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field HistoryType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = HistoryType(v)
	}
	p.HistoryType = _field
	return nil
}
func (p *HistoryInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Info = _field
	return nil
}
func (p *HistoryInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CreateTime = _field
	return nil
}
func (p *HistoryInfo) ReadField5(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ConnectorInfo, 0, size)
	values := make([]ConnectorInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.ConnectorInfos = _field
	return nil
}
func (p *HistoryInfo) ReadField6(iprot thrift.TProtocol) error {
	_field := NewCreator()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Creator = _field
	return nil
}
func (p *HistoryInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PublishID = _field
	return nil
}
func (p *HistoryInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitRemark = _field
	return nil
}

func (p *HistoryInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("HistoryInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *HistoryInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("version", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Version); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *HistoryInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("history_type", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.HistoryType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *HistoryInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("info", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Info); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *HistoryInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("create_time", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.CreateTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *HistoryInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connector_infos", thrift.LIST, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.ConnectorInfos)); err != nil {
		return err
	}
	for _, v := range p.ConnectorInfos {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *HistoryInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("creator", thrift.STRUCT, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Creator.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *HistoryInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishID() {
		if err = oprot.WriteFieldBegin("publish_id", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PublishID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *HistoryInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitRemark() {
		if err = oprot.WriteFieldBegin("commit_remark", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitRemark); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}

func (p *HistoryInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("HistoryInfo(%+v)", *p)

}

type ConnectorInfo struct {
	ID              string                 `thrift:"id,1" form:"id" json:"id" query:"id"`
	Name            string                 `thrift:"name,2" form:"name" json:"name" query:"name"`
	Icon            string                 `thrift:"icon,3" form:"icon" json:"icon" query:"icon"`
	ConnectorStatus ConnectorDynamicStatus `thrift:"connector_status,4" form:"connector_status" json:"connector_status" query:"connector_status"`
	ShareLink       *string                `thrift:"share_link,5,optional" form:"share_link" json:"share_link,omitempty" query:"share_link"`
}

func NewConnectorInfo() *ConnectorInfo {
	return &ConnectorInfo{}
}

func (p *ConnectorInfo) InitDefault() {
}

func (p *ConnectorInfo) GetID() (v string) {
	return p.ID
}

func (p *ConnectorInfo) GetName() (v string) {
	return p.Name
}

func (p *ConnectorInfo) GetIcon() (v string) {
	return p.Icon
}

func (p *ConnectorInfo) GetConnectorStatus() (v ConnectorDynamicStatus) {
	return p.ConnectorStatus
}

var ConnectorInfo_ShareLink_DEFAULT string

func (p *ConnectorInfo) GetShareLink() (v string) {
	if !p.IsSetShareLink() {
		return ConnectorInfo_ShareLink_DEFAULT
	}
	return *p.ShareLink
}

var fieldIDToName_ConnectorInfo = map[int16]string{
	1: "id",
	2: "name",
	3: "icon",
	4: "connector_status",
	5: "share_link",
}

func (p *ConnectorInfo) IsSetShareLink() bool {
	return p.ShareLink != nil
}

func (p *ConnectorInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ConnectorInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ConnectorInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *ConnectorInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ConnectorInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}
func (p *ConnectorInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field ConnectorDynamicStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ConnectorDynamicStatus(v)
	}
	p.ConnectorStatus = _field
	return nil
}
func (p *ConnectorInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ShareLink = _field
	return nil
}

func (p *ConnectorInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ConnectorInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ConnectorInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ConnectorInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ConnectorInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ConnectorInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connector_status", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ConnectorStatus)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ConnectorInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetShareLink() {
		if err = oprot.WriteFieldBegin("share_link", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ShareLink); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *ConnectorInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ConnectorInfo(%+v)", *p)

}

type GetIconRequest struct {
	IconType IconType `thrift:"icon_type,1" form:"icon_type" json:"icon_type" query:"icon_type"`
}

func NewGetIconRequest() *GetIconRequest {
	return &GetIconRequest{}
}

func (p *GetIconRequest) InitDefault() {
}

func (p *GetIconRequest) GetIconType() (v IconType) {
	return p.IconType
}

var fieldIDToName_GetIconRequest = map[int16]string{
	1: "icon_type",
}

func (p *GetIconRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetIconRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetIconRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field IconType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = IconType(v)
	}
	p.IconType = _field
	return nil
}

func (p *GetIconRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetIconRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetIconRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_type", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.IconType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *GetIconRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetIconRequest(%+v)", *p)

}

type Icon struct {
	URL string `thrift:"url,1" form:"url" json:"url" query:"url"`
	URI string `thrift:"uri,2" form:"uri" json:"uri" query:"uri"`
}

func NewIcon() *Icon {
	return &Icon{}
}

func (p *Icon) InitDefault() {
}

func (p *Icon) GetURL() (v string) {
	return p.URL
}

func (p *Icon) GetURI() (v string) {
	return p.URI
}

var fieldIDToName_Icon = map[int16]string{
	1: "url",
	2: "uri",
}

func (p *Icon) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Icon[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Icon) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *Icon) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URI = _field
	return nil
}

func (p *Icon) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Icon"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Icon) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Icon) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("uri", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *Icon) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Icon(%+v)", *p)

}

type GetIconResponseData struct {
	IconList []*Icon `thrift:"icon_list,1" form:"icon_list" json:"icon_list" query:"icon_list"`
}

func NewGetIconResponseData() *GetIconResponseData {
	return &GetIconResponseData{}
}

func (p *GetIconResponseData) InitDefault() {
}

func (p *GetIconResponseData) GetIconList() (v []*Icon) {
	return p.IconList
}

var fieldIDToName_GetIconResponseData = map[int16]string{
	1: "icon_list",
}

func (p *GetIconResponseData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetIconResponseData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetIconResponseData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Icon, 0, size)
	values := make([]Icon, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.IconList = _field
	return nil
}

func (p *GetIconResponseData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetIconResponseData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetIconResponseData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.IconList)); err != nil {
		return err
	}
	for _, v := range p.IconList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *GetIconResponseData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetIconResponseData(%+v)", *p)

}

type GetIconResponse struct {
	Code int64                `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string               `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *GetIconResponseData `thrift:"data,3" form:"data" json:"data" query:"data"`
}

func NewGetIconResponse() *GetIconResponse {
	return &GetIconResponse{}
}

func (p *GetIconResponse) InitDefault() {
}

func (p *GetIconResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetIconResponse) GetMsg() (v string) {
	return p.Msg
}

var GetIconResponse_Data_DEFAULT *GetIconResponseData

func (p *GetIconResponse) GetData() (v *GetIconResponseData) {
	if !p.IsSetData() {
		return GetIconResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_GetIconResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *GetIconResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetIconResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetIconResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetIconResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetIconResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetIconResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetIconResponseData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *GetIconResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetIconResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetIconResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetIconResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetIconResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetIconResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetIconResponse(%+v)", *p)

}

type GetUploadAuthTokenResponse struct {
	Code int64                   `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string                  `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *GetUploadAuthTokenData `thrift:"data,3" form:"data" json:"data" query:"data"`
}

func NewGetUploadAuthTokenResponse() *GetUploadAuthTokenResponse {
	return &GetUploadAuthTokenResponse{}
}

func (p *GetUploadAuthTokenResponse) InitDefault() {
}

func (p *GetUploadAuthTokenResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetUploadAuthTokenResponse) GetMsg() (v string) {
	return p.Msg
}

var GetUploadAuthTokenResponse_Data_DEFAULT *GetUploadAuthTokenData

func (p *GetUploadAuthTokenResponse) GetData() (v *GetUploadAuthTokenData) {
	if !p.IsSetData() {
		return GetUploadAuthTokenResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_GetUploadAuthTokenResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *GetUploadAuthTokenResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetUploadAuthTokenResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetUploadAuthTokenResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetUploadAuthTokenResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetUploadAuthTokenResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetUploadAuthTokenResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetUploadAuthTokenData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *GetUploadAuthTokenResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUploadAuthTokenResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetUploadAuthTokenResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetUploadAuthTokenResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetUploadAuthTokenResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetUploadAuthTokenResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetUploadAuthTokenResponse(%+v)", *p)

}

type GetUploadAuthTokenData struct {
	ServiceID        string               `thrift:"service_id,1" form:"service_id" json:"service_id" query:"service_id"`
	UploadPathPrefix string               `thrift:"upload_path_prefix,2" form:"upload_path_prefix" json:"upload_path_prefix" query:"upload_path_prefix"`
	Auth             *UploadAuthTokenInfo `thrift:"auth,3" form:"auth" json:"auth" query:"auth"`
	UploadHost       string               `thrift:"upload_host,4" form:"upload_host" json:"upload_host" query:"upload_host"`
	Schema           string               `thrift:"schema,5" form:"schema" json:"schema" query:"schema"`
}

func NewGetUploadAuthTokenData() *GetUploadAuthTokenData {
	return &GetUploadAuthTokenData{}
}

func (p *GetUploadAuthTokenData) InitDefault() {
}

func (p *GetUploadAuthTokenData) GetServiceID() (v string) {
	return p.ServiceID
}

func (p *GetUploadAuthTokenData) GetUploadPathPrefix() (v string) {
	return p.UploadPathPrefix
}

var GetUploadAuthTokenData_Auth_DEFAULT *UploadAuthTokenInfo

func (p *GetUploadAuthTokenData) GetAuth() (v *UploadAuthTokenInfo) {
	if !p.IsSetAuth() {
		return GetUploadAuthTokenData_Auth_DEFAULT
	}
	return p.Auth
}

func (p *GetUploadAuthTokenData) GetUploadHost() (v string) {
	return p.UploadHost
}

func (p *GetUploadAuthTokenData) GetSchema() (v string) {
	return p.Schema
}

var fieldIDToName_GetUploadAuthTokenData = map[int16]string{
	1: "service_id",
	2: "upload_path_prefix",
	3: "auth",
	4: "upload_host",
	5: "schema",
}

func (p *GetUploadAuthTokenData) IsSetAuth() bool {
	return p.Auth != nil
}

func (p *GetUploadAuthTokenData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetUploadAuthTokenData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetUploadAuthTokenData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ServiceID = _field
	return nil
}
func (p *GetUploadAuthTokenData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UploadPathPrefix = _field
	return nil
}
func (p *GetUploadAuthTokenData) ReadField3(iprot thrift.TProtocol) error {
	_field := NewUploadAuthTokenInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Auth = _field
	return nil
}
func (p *GetUploadAuthTokenData) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UploadHost = _field
	return nil
}
func (p *GetUploadAuthTokenData) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Schema = _field
	return nil
}

func (p *GetUploadAuthTokenData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUploadAuthTokenData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetUploadAuthTokenData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("service_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ServiceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetUploadAuthTokenData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("upload_path_prefix", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UploadPathPrefix); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetUploadAuthTokenData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("auth", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Auth.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetUploadAuthTokenData) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("upload_host", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UploadHost); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetUploadAuthTokenData) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("schema", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Schema); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *GetUploadAuthTokenData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetUploadAuthTokenData(%+v)", *p)

}

type UploadAuthTokenInfo struct {
	AccessKeyID     string `thrift:"access_key_id,1" form:"access_key_id" json:"access_key_id" query:"access_key_id"`
	SecretAccessKey string `thrift:"secret_access_key,2" form:"secret_access_key" json:"secret_access_key" query:"secret_access_key"`
	SessionToken    string `thrift:"session_token,3" form:"session_token" json:"session_token" query:"session_token"`
	ExpiredTime     string `thrift:"expired_time,4" form:"expired_time" json:"expired_time" query:"expired_time"`
	CurrentTime     string `thrift:"current_time,5" form:"current_time" json:"current_time" query:"current_time"`
}

func NewUploadAuthTokenInfo() *UploadAuthTokenInfo {
	return &UploadAuthTokenInfo{}
}

func (p *UploadAuthTokenInfo) InitDefault() {
}

func (p *UploadAuthTokenInfo) GetAccessKeyID() (v string) {
	return p.AccessKeyID
}

func (p *UploadAuthTokenInfo) GetSecretAccessKey() (v string) {
	return p.SecretAccessKey
}

func (p *UploadAuthTokenInfo) GetSessionToken() (v string) {
	return p.SessionToken
}

func (p *UploadAuthTokenInfo) GetExpiredTime() (v string) {
	return p.ExpiredTime
}

func (p *UploadAuthTokenInfo) GetCurrentTime() (v string) {
	return p.CurrentTime
}

var fieldIDToName_UploadAuthTokenInfo = map[int16]string{
	1: "access_key_id",
	2: "secret_access_key",
	3: "session_token",
	4: "expired_time",
	5: "current_time",
}

func (p *UploadAuthTokenInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UploadAuthTokenInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UploadAuthTokenInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AccessKeyID = _field
	return nil
}
func (p *UploadAuthTokenInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SecretAccessKey = _field
	return nil
}
func (p *UploadAuthTokenInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SessionToken = _field
	return nil
}
func (p *UploadAuthTokenInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ExpiredTime = _field
	return nil
}
func (p *UploadAuthTokenInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CurrentTime = _field
	return nil
}

func (p *UploadAuthTokenInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadAuthTokenInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UploadAuthTokenInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("access_key_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AccessKeyID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UploadAuthTokenInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("secret_access_key", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SecretAccessKey); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UploadAuthTokenInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("session_token", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SessionToken); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *UploadAuthTokenInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("expired_time", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ExpiredTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *UploadAuthTokenInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("current_time", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.CurrentTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *UploadAuthTokenInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UploadAuthTokenInfo(%+v)", *p)

}

type GetUploadAuthTokenRequest struct {
	Scene    string `thrift:"scene,1" form:"scene" json:"scene" query:"scene"`
	DataType string `thrift:"data_type,2" form:"data_type" json:"data_type" query:"data_type"`
}

func NewGetUploadAuthTokenRequest() *GetUploadAuthTokenRequest {
	return &GetUploadAuthTokenRequest{}
}

func (p *GetUploadAuthTokenRequest) InitDefault() {
}

func (p *GetUploadAuthTokenRequest) GetScene() (v string) {
	return p.Scene
}

func (p *GetUploadAuthTokenRequest) GetDataType() (v string) {
	return p.DataType
}

var fieldIDToName_GetUploadAuthTokenRequest = map[int16]string{
	1: "scene",
	2: "data_type",
}

func (p *GetUploadAuthTokenRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetUploadAuthTokenRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetUploadAuthTokenRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Scene = _field
	return nil
}
func (p *GetUploadAuthTokenRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DataType = _field
	return nil
}

func (p *GetUploadAuthTokenRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUploadAuthTokenRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetUploadAuthTokenRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("scene", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Scene); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetUploadAuthTokenRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data_type", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.DataType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *GetUploadAuthTokenRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetUploadAuthTokenRequest(%+v)", *p)

}

type UploadFileRequest struct {
	// Document related description
	FileHead *CommonFileInfo `thrift:"file_head,1" form:"file_head" json:"file_head" query:"file_head"`
	// file data
	Data string `thrift:"data,2" form:"data" json:"data" query:"data"`
}

func NewUploadFileRequest() *UploadFileRequest {
	return &UploadFileRequest{}
}

func (p *UploadFileRequest) InitDefault() {
}

var UploadFileRequest_FileHead_DEFAULT *CommonFileInfo

func (p *UploadFileRequest) GetFileHead() (v *CommonFileInfo) {
	if !p.IsSetFileHead() {
		return UploadFileRequest_FileHead_DEFAULT
	}
	return p.FileHead
}

func (p *UploadFileRequest) GetData() (v string) {
	return p.Data
}

var fieldIDToName_UploadFileRequest = map[int16]string{
	1: "file_head",
	2: "data",
}

func (p *UploadFileRequest) IsSetFileHead() bool {
	return p.FileHead != nil
}

func (p *UploadFileRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UploadFileRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UploadFileRequest) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCommonFileInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.FileHead = _field
	return nil
}
func (p *UploadFileRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Data = _field
	return nil
}

func (p *UploadFileRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFileRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UploadFileRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("file_head", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.FileHead.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UploadFileRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Data); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UploadFileRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UploadFileRequest(%+v)", *p)

}

// Upload file, file header
type CommonFileInfo struct {
	// File type, suffix
	FileType string `thrift:"file_type,1" form:"file_type" json:"file_type" query:"file_type"`
	// business type
	BizType FileBizType `thrift:"biz_type,2" form:"biz_type" json:"biz_type" query:"biz_type"`
}

func NewCommonFileInfo() *CommonFileInfo {
	return &CommonFileInfo{}
}

func (p *CommonFileInfo) InitDefault() {
}

func (p *CommonFileInfo) GetFileType() (v string) {
	return p.FileType
}

func (p *CommonFileInfo) GetBizType() (v FileBizType) {
	return p.BizType
}

var fieldIDToName_CommonFileInfo = map[int16]string{
	1: "file_type",
	2: "biz_type",
}

func (p *CommonFileInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CommonFileInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CommonFileInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.FileType = _field
	return nil
}
func (p *CommonFileInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field FileBizType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = FileBizType(v)
	}
	p.BizType = _field
	return nil
}

func (p *CommonFileInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CommonFileInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CommonFileInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("file_type", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.FileType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CommonFileInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("biz_type", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.BizType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *CommonFileInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CommonFileInfo(%+v)", *p)

}

type UploadFileResponse struct {
	Code int64  `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	// data
	Data *UploadFileData `thrift:"data,3" form:"data" json:"data" query:"data"`
}

func NewUploadFileResponse() *UploadFileResponse {
	return &UploadFileResponse{}
}

func (p *UploadFileResponse) InitDefault() {
}

func (p *UploadFileResponse) GetCode() (v int64) {
	return p.Code
}

func (p *UploadFileResponse) GetMsg() (v string) {
	return p.Msg
}

var UploadFileResponse_Data_DEFAULT *UploadFileData

func (p *UploadFileResponse) GetData() (v *UploadFileData) {
	if !p.IsSetData() {
		return UploadFileResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_UploadFileResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *UploadFileResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *UploadFileResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UploadFileResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UploadFileResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *UploadFileResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *UploadFileResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewUploadFileData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *UploadFileResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFileResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UploadFileResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UploadFileResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UploadFileResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *UploadFileResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UploadFileResponse(%+v)", *p)

}

type GetTypeListRequest struct {
	Model    *bool   `thrift:"model,1,optional" form:"model" json:"model,omitempty" query:"model"`
	Voice    *bool   `thrift:"voice,2,optional" form:"voice" json:"voice,omitempty" query:"voice"`
	RawModel *bool   `thrift:"raw_model,3,optional" form:"raw_model" json:"raw_model,omitempty" query:"raw_model"`
	SpaceID  *string `thrift:"space_id,4,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	// The model ID used by the current bot to handle issues that cannot be displayed by the bot model synchronized by cici/doubao
	CurModelID *string `thrift:"cur_model_id,5,optional" form:"cur_model_id" json:"cur_model_id,omitempty" query:"cur_model_id"`
	// Compatible with MultiAgent, with multiple cur_model_id
	CurModelIds []string `thrift:"cur_model_ids,6,optional" form:"cur_model_ids" json:"cur_model_ids,omitempty" query:"cur_model_ids"`
	// model scenario
	ModelScene *ModelScene `thrift:"model_scene,7,optional" form:"model_scene" json:"model_scene,omitempty" query:"model_scene"`
}

func NewGetTypeListRequest() *GetTypeListRequest {
	return &GetTypeListRequest{}
}

func (p *GetTypeListRequest) InitDefault() {
}

var GetTypeListRequest_Model_DEFAULT bool

func (p *GetTypeListRequest) GetModel() (v bool) {
	if !p.IsSetModel() {
		return GetTypeListRequest_Model_DEFAULT
	}
	return *p.Model
}

var GetTypeListRequest_Voice_DEFAULT bool

func (p *GetTypeListRequest) GetVoice() (v bool) {
	if !p.IsSetVoice() {
		return GetTypeListRequest_Voice_DEFAULT
	}
	return *p.Voice
}

var GetTypeListRequest_RawModel_DEFAULT bool

func (p *GetTypeListRequest) GetRawModel() (v bool) {
	if !p.IsSetRawModel() {
		return GetTypeListRequest_RawModel_DEFAULT
	}
	return *p.RawModel
}

var GetTypeListRequest_SpaceID_DEFAULT string

func (p *GetTypeListRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return GetTypeListRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var GetTypeListRequest_CurModelID_DEFAULT string

func (p *GetTypeListRequest) GetCurModelID() (v string) {
	if !p.IsSetCurModelID() {
		return GetTypeListRequest_CurModelID_DEFAULT
	}
	return *p.CurModelID
}

var GetTypeListRequest_CurModelIds_DEFAULT []string

func (p *GetTypeListRequest) GetCurModelIds() (v []string) {
	if !p.IsSetCurModelIds() {
		return GetTypeListRequest_CurModelIds_DEFAULT
	}
	return p.CurModelIds
}

var GetTypeListRequest_ModelScene_DEFAULT ModelScene

func (p *GetTypeListRequest) GetModelScene() (v ModelScene) {
	if !p.IsSetModelScene() {
		return GetTypeListRequest_ModelScene_DEFAULT
	}
	return *p.ModelScene
}

var fieldIDToName_GetTypeListRequest = map[int16]string{
	1: "model",
	2: "voice",
	3: "raw_model",
	4: "space_id",
	5: "cur_model_id",
	6: "cur_model_ids",
	7: "model_scene",
}

func (p *GetTypeListRequest) IsSetModel() bool {
	return p.Model != nil
}

func (p *GetTypeListRequest) IsSetVoice() bool {
	return p.Voice != nil
}

func (p *GetTypeListRequest) IsSetRawModel() bool {
	return p.RawModel != nil
}

func (p *GetTypeListRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *GetTypeListRequest) IsSetCurModelID() bool {
	return p.CurModelID != nil
}

func (p *GetTypeListRequest) IsSetCurModelIds() bool {
	return p.CurModelIds != nil
}

func (p *GetTypeListRequest) IsSetModelScene() bool {
	return p.ModelScene != nil
}

func (p *GetTypeListRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetTypeListRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetTypeListRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Model = _field
	return nil
}
func (p *GetTypeListRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Voice = _field
	return nil
}
func (p *GetTypeListRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.RawModel = _field
	return nil
}
func (p *GetTypeListRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetTypeListRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CurModelID = _field
	return nil
}
func (p *GetTypeListRequest) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.CurModelIds = _field
	return nil
}
func (p *GetTypeListRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *ModelScene
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := ModelScene(v)
		_field = &tmp
	}
	p.ModelScene = _field
	return nil
}

func (p *GetTypeListRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetTypeListRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetTypeListRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetModel() {
		if err = oprot.WriteFieldBegin("model", thrift.BOOL, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.Model); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetTypeListRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetVoice() {
		if err = oprot.WriteFieldBegin("voice", thrift.BOOL, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.Voice); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetTypeListRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetRawModel() {
		if err = oprot.WriteFieldBegin("raw_model", thrift.BOOL, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.RawModel); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetTypeListRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetTypeListRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetCurModelID() {
		if err = oprot.WriteFieldBegin("cur_model_id", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CurModelID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetTypeListRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetCurModelIds() {
		if err = oprot.WriteFieldBegin("cur_model_ids", thrift.LIST, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.CurModelIds)); err != nil {
			return err
		}
		for _, v := range p.CurModelIds {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetTypeListRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelScene() {
		if err = oprot.WriteFieldBegin("model_scene", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.ModelScene)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *GetTypeListRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetTypeListRequest(%+v)", *p)

}

type ModelQuota struct {
	// Maximum total number of tokens
	TokenLimit int32 `thrift:"token_limit,1" form:"token_limit" json:"token_limit" query:"token_limit"`
	// Final reply maximum number of tokens
	TokenResp int32 `thrift:"token_resp,2" form:"token_resp" json:"token_resp" query:"token_resp"`
	// Prompt system maximum number of tokens
	TokenSystem int32 `thrift:"token_system,3" form:"token_system" json:"token_system" query:"token_system"`
	// Prompt user to enter maximum number of tokens
	TokenUserIn int32 `thrift:"token_user_in,4" form:"token_user_in" json:"token_user_in" query:"token_user_in"`
	// Prompt tool to enter maximum number of tokens
	TokenToolsIn int32 `thrift:"token_tools_in,5" form:"token_tools_in" json:"token_tools_in" query:"token_tools_in"`
	// Prompt tool output maximum number of tokens
	TokenToolsOut int32 `thrift:"token_tools_out,6" form:"token_tools_out" json:"token_tools_out" query:"token_tools_out"`
	// Prompt data maximum number of tokens
	TokenData int32 `thrift:"token_data,7" form:"token_data" json:"token_data" query:"token_data"`
	// Prompt history maximum number of tokens
	TokenHistory int32 `thrift:"token_history,8" form:"token_history" json:"token_history" query:"token_history"`
	// Prompt history maximum number of tokens
	TokenCutSwitch bool `thrift:"token_cut_switch,9" form:"token_cut_switch" json:"token_cut_switch" query:"token_cut_switch"`
	// input cost
	PriceIn float64 `thrift:"price_in,10" form:"price_in" json:"price_in" query:"price_in"`
	// output cost
	PriceOut float64 `thrift:"price_out,11" form:"price_out" json:"price_out" query:"price_out"`
	// Systemprompt input restrictions, if not passed, no input restrictions
	SystemPromptLimit *int32 `thrift:"system_prompt_limit,12,optional" form:"system_prompt_limit" json:"system_prompt_limit,omitempty" query:"system_prompt_limit"`
}

func NewModelQuota() *ModelQuota {
	return &ModelQuota{}
}

func (p *ModelQuota) InitDefault() {
}

func (p *ModelQuota) GetTokenLimit() (v int32) {
	return p.TokenLimit
}

func (p *ModelQuota) GetTokenResp() (v int32) {
	return p.TokenResp
}

func (p *ModelQuota) GetTokenSystem() (v int32) {
	return p.TokenSystem
}

func (p *ModelQuota) GetTokenUserIn() (v int32) {
	return p.TokenUserIn
}

func (p *ModelQuota) GetTokenToolsIn() (v int32) {
	return p.TokenToolsIn
}

func (p *ModelQuota) GetTokenToolsOut() (v int32) {
	return p.TokenToolsOut
}

func (p *ModelQuota) GetTokenData() (v int32) {
	return p.TokenData
}

func (p *ModelQuota) GetTokenHistory() (v int32) {
	return p.TokenHistory
}

func (p *ModelQuota) GetTokenCutSwitch() (v bool) {
	return p.TokenCutSwitch
}

func (p *ModelQuota) GetPriceIn() (v float64) {
	return p.PriceIn
}

func (p *ModelQuota) GetPriceOut() (v float64) {
	return p.PriceOut
}

var ModelQuota_SystemPromptLimit_DEFAULT int32

func (p *ModelQuota) GetSystemPromptLimit() (v int32) {
	if !p.IsSetSystemPromptLimit() {
		return ModelQuota_SystemPromptLimit_DEFAULT
	}
	return *p.SystemPromptLimit
}

var fieldIDToName_ModelQuota = map[int16]string{
	1:  "token_limit",
	2:  "token_resp",
	3:  "token_system",
	4:  "token_user_in",
	5:  "token_tools_in",
	6:  "token_tools_out",
	7:  "token_data",
	8:  "token_history",
	9:  "token_cut_switch",
	10: "price_in",
	11: "price_out",
	12: "system_prompt_limit",
}

func (p *ModelQuota) IsSetSystemPromptLimit() bool {
	return p.SystemPromptLimit != nil
}

func (p *ModelQuota) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelQuota[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelQuota) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenLimit = _field
	return nil
}
func (p *ModelQuota) ReadField2(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenResp = _field
	return nil
}
func (p *ModelQuota) ReadField3(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenSystem = _field
	return nil
}
func (p *ModelQuota) ReadField4(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenUserIn = _field
	return nil
}
func (p *ModelQuota) ReadField5(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenToolsIn = _field
	return nil
}
func (p *ModelQuota) ReadField6(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenToolsOut = _field
	return nil
}
func (p *ModelQuota) ReadField7(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenData = _field
	return nil
}
func (p *ModelQuota) ReadField8(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenHistory = _field
	return nil
}
func (p *ModelQuota) ReadField9(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TokenCutSwitch = _field
	return nil
}
func (p *ModelQuota) ReadField10(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PriceIn = _field
	return nil
}
func (p *ModelQuota) ReadField11(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PriceOut = _field
	return nil
}
func (p *ModelQuota) ReadField12(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SystemPromptLimit = _field
	return nil
}

func (p *ModelQuota) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelQuota"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelQuota) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_limit", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenLimit); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelQuota) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_resp", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenResp); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelQuota) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_system", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenSystem); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelQuota) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_user_in", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenUserIn); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ModelQuota) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_tools_in", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenToolsIn); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ModelQuota) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_tools_out", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenToolsOut); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *ModelQuota) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_data", thrift.I32, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenData); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *ModelQuota) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_history", thrift.I32, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TokenHistory); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *ModelQuota) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("token_cut_switch", thrift.BOOL, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.TokenCutSwitch); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *ModelQuota) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("price_in", thrift.DOUBLE, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.PriceIn); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *ModelQuota) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("price_out", thrift.DOUBLE, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.PriceOut); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *ModelQuota) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetSystemPromptLimit() {
		if err = oprot.WriteFieldBegin("system_prompt_limit", thrift.I32, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.SystemPromptLimit); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}

func (p *ModelQuota) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelQuota(%+v)", *p)

}

type ModelParamDefaultValue struct {
	DefaultVal string  `thrift:"default_val,1,required" form:"default_val,required" json:"default_val,required" query:"default_val,required"`
	Creative   *string `thrift:"creative,2,optional" form:"creative" json:"creative,omitempty" query:"creative"`
	Balance    *string `thrift:"balance,3,optional" form:"balance" json:"balance,omitempty" query:"balance"`
	Precise    *string `thrift:"precise,4,optional" form:"precise" json:"precise,omitempty" query:"precise"`
}

func NewModelParamDefaultValue() *ModelParamDefaultValue {
	return &ModelParamDefaultValue{}
}

func (p *ModelParamDefaultValue) InitDefault() {
}

func (p *ModelParamDefaultValue) GetDefaultVal() (v string) {
	return p.DefaultVal
}

var ModelParamDefaultValue_Creative_DEFAULT string

func (p *ModelParamDefaultValue) GetCreative() (v string) {
	if !p.IsSetCreative() {
		return ModelParamDefaultValue_Creative_DEFAULT
	}
	return *p.Creative
}

var ModelParamDefaultValue_Balance_DEFAULT string

func (p *ModelParamDefaultValue) GetBalance() (v string) {
	if !p.IsSetBalance() {
		return ModelParamDefaultValue_Balance_DEFAULT
	}
	return *p.Balance
}

var ModelParamDefaultValue_Precise_DEFAULT string

func (p *ModelParamDefaultValue) GetPrecise() (v string) {
	if !p.IsSetPrecise() {
		return ModelParamDefaultValue_Precise_DEFAULT
	}
	return *p.Precise
}

var fieldIDToName_ModelParamDefaultValue = map[int16]string{
	1: "default_val",
	2: "creative",
	3: "balance",
	4: "precise",
}

func (p *ModelParamDefaultValue) IsSetCreative() bool {
	return p.Creative != nil
}

func (p *ModelParamDefaultValue) IsSetBalance() bool {
	return p.Balance != nil
}

func (p *ModelParamDefaultValue) IsSetPrecise() bool {
	return p.Precise != nil
}

func (p *ModelParamDefaultValue) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetDefaultVal bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetDefaultVal = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetDefaultVal {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelParamDefaultValue[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ModelParamDefaultValue[fieldId]))
}

func (p *ModelParamDefaultValue) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DefaultVal = _field
	return nil
}
func (p *ModelParamDefaultValue) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Creative = _field
	return nil
}
func (p *ModelParamDefaultValue) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Balance = _field
	return nil
}
func (p *ModelParamDefaultValue) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Precise = _field
	return nil
}

func (p *ModelParamDefaultValue) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelParamDefaultValue"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelParamDefaultValue) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("default_val", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.DefaultVal); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelParamDefaultValue) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetCreative() {
		if err = oprot.WriteFieldBegin("creative", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Creative); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelParamDefaultValue) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetBalance() {
		if err = oprot.WriteFieldBegin("balance", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Balance); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelParamDefaultValue) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrecise() {
		if err = oprot.WriteFieldBegin("precise", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Precise); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *ModelParamDefaultValue) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelParamDefaultValue(%+v)", *p)

}

type ModelParamClass struct {
	// 1="Generation diversity", 2="Input and output length", 3="Output format"
	ClassID int32  `thrift:"class_id,1" form:"class_id" json:"class_id" query:"class_id"`
	Label   string `thrift:"label,2" form:"label" json:"label" query:"label"`
}

func NewModelParamClass() *ModelParamClass {
	return &ModelParamClass{}
}

func (p *ModelParamClass) InitDefault() {
}

func (p *ModelParamClass) GetClassID() (v int32) {
	return p.ClassID
}

func (p *ModelParamClass) GetLabel() (v string) {
	return p.Label
}

var fieldIDToName_ModelParamClass = map[int16]string{
	1: "class_id",
	2: "label",
}

func (p *ModelParamClass) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelParamClass[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelParamClass) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ClassID = _field
	return nil
}
func (p *ModelParamClass) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Label = _field
	return nil
}

func (p *ModelParamClass) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelParamClass"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelParamClass) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("class_id", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.ClassID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelParamClass) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("label", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Label); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *ModelParamClass) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelParamClass(%+v)", *p)

}

type Option struct {
	// The value displayed by the option
	Label string `thrift:"label,1" form:"label" json:"label" query:"label"`
	// Filled in value
	Value string `thrift:"value,2" form:"value" json:"value" query:"value"`
}

func NewOption() *Option {
	return &Option{}
}

func (p *Option) InitDefault() {
}

func (p *Option) GetLabel() (v string) {
	return p.Label
}

func (p *Option) GetValue() (v string) {
	return p.Value
}

var fieldIDToName_Option = map[int16]string{
	1: "label",
	2: "value",
}

func (p *Option) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Option[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Option) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Label = _field
	return nil
}
func (p *Option) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Value = _field
	return nil
}

func (p *Option) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Option"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Option) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("label", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Label); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Option) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("value", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Value); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *Option) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Option(%+v)", *p)

}

type ModelParameter struct {
	// Configuration fields, such as max_tokens
	Name string `thrift:"name,1,required" form:"name,required" json:"name,required" query:"name,required"`
	// Configure field display name
	Label string `thrift:"label,2" form:"label" json:"label" query:"label"`
	// Configuration field detail description
	Desc string `thrift:"desc,3" form:"desc" json:"desc" query:"desc"`
	// type
	Type ModelParamType `thrift:"type,4,required" form:"type,required" json:"type,required" query:"type,required"`
	// Numerical type parameters, the minimum value allowed to be set
	Min string `thrift:"min,5" form:"min" json:"min" query:"min"`
	// Numerical type parameter, the maximum value allowed to be set
	Max string `thrift:"max,6" form:"max" json:"max" query:"max"`
	// Precision of float type parameters
	Precision int32 `thrift:"precision,7" form:"precision" json:"precision" query:"precision"`
	// Parameter default {"default": xx, "creative": xx}
	DefaultVal *ModelParamDefaultValue `thrift:"default_val,8,required" form:"default_val,required" json:"default_val,required" query:"default_val,required"`
	// Enumeration values such as response_format support text, markdown, json
	Options []*Option `thrift:"options,9" form:"options" json:"options" query:"options"`
	// Parameter classification, "Generation diversity", "Input and output length", "Output format"
	ParamClass *ModelParamClass `thrift:"param_class,10" form:"param_class" json:"param_class" query:"param_class"`
}

func NewModelParameter() *ModelParameter {
	return &ModelParameter{}
}

func (p *ModelParameter) InitDefault() {
}

func (p *ModelParameter) GetName() (v string) {
	return p.Name
}

func (p *ModelParameter) GetLabel() (v string) {
	return p.Label
}

func (p *ModelParameter) GetDesc() (v string) {
	return p.Desc
}

func (p *ModelParameter) GetType() (v ModelParamType) {
	return p.Type
}

func (p *ModelParameter) GetMin() (v string) {
	return p.Min
}

func (p *ModelParameter) GetMax() (v string) {
	return p.Max
}

func (p *ModelParameter) GetPrecision() (v int32) {
	return p.Precision
}

var ModelParameter_DefaultVal_DEFAULT *ModelParamDefaultValue

func (p *ModelParameter) GetDefaultVal() (v *ModelParamDefaultValue) {
	if !p.IsSetDefaultVal() {
		return ModelParameter_DefaultVal_DEFAULT
	}
	return p.DefaultVal
}

func (p *ModelParameter) GetOptions() (v []*Option) {
	return p.Options
}

var ModelParameter_ParamClass_DEFAULT *ModelParamClass

func (p *ModelParameter) GetParamClass() (v *ModelParamClass) {
	if !p.IsSetParamClass() {
		return ModelParameter_ParamClass_DEFAULT
	}
	return p.ParamClass
}

var fieldIDToName_ModelParameter = map[int16]string{
	1:  "name",
	2:  "label",
	3:  "desc",
	4:  "type",
	5:  "min",
	6:  "max",
	7:  "precision",
	8:  "default_val",
	9:  "options",
	10: "param_class",
}

func (p *ModelParameter) IsSetDefaultVal() bool {
	return p.DefaultVal != nil
}

func (p *ModelParameter) IsSetParamClass() bool {
	return p.ParamClass != nil
}

func (p *ModelParameter) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetName bool = false
	var issetType bool = false
	var issetDefaultVal bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetName = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
				issetDefaultVal = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetName {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetType {
		fieldId = 4
		goto RequiredFieldNotSetError
	}

	if !issetDefaultVal {
		fieldId = 8
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelParameter[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ModelParameter[fieldId]))
}

func (p *ModelParameter) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ModelParameter) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Label = _field
	return nil
}
func (p *ModelParameter) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *ModelParameter) ReadField4(iprot thrift.TProtocol) error {

	var _field ModelParamType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ModelParamType(v)
	}
	p.Type = _field
	return nil
}
func (p *ModelParameter) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Min = _field
	return nil
}
func (p *ModelParameter) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Max = _field
	return nil
}
func (p *ModelParameter) ReadField7(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Precision = _field
	return nil
}
func (p *ModelParameter) ReadField8(iprot thrift.TProtocol) error {
	_field := NewModelParamDefaultValue()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.DefaultVal = _field
	return nil
}
func (p *ModelParameter) ReadField9(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Option, 0, size)
	values := make([]Option, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Options = _field
	return nil
}
func (p *ModelParameter) ReadField10(iprot thrift.TProtocol) error {
	_field := NewModelParamClass()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ParamClass = _field
	return nil
}

func (p *ModelParameter) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelParameter"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelParameter) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelParameter) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("label", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Label); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelParameter) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelParameter) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ModelParameter) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("min", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Min); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ModelParameter) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("max", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Max); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *ModelParameter) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("precision", thrift.I32, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Precision); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *ModelParameter) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("default_val", thrift.STRUCT, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.DefaultVal.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *ModelParameter) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("options", thrift.LIST, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Options)); err != nil {
		return err
	}
	for _, v := range p.Options {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *ModelParameter) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("param_class", thrift.STRUCT, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.ParamClass.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}

func (p *ModelParameter) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelParameter(%+v)", *p)

}

type ModelDescGroup struct {
	GroupName string   `thrift:"group_name,1" form:"group_name" json:"group_name" query:"group_name"`
	Desc      []string `thrift:"desc,2" form:"desc" json:"desc" query:"desc"`
}

func NewModelDescGroup() *ModelDescGroup {
	return &ModelDescGroup{}
}

func (p *ModelDescGroup) InitDefault() {
}

func (p *ModelDescGroup) GetGroupName() (v string) {
	return p.GroupName
}

func (p *ModelDescGroup) GetDesc() (v []string) {
	return p.Desc
}

var fieldIDToName_ModelDescGroup = map[int16]string{
	1: "group_name",
	2: "desc",
}

func (p *ModelDescGroup) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelDescGroup[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelDescGroup) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.GroupName = _field
	return nil
}
func (p *ModelDescGroup) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Desc = _field
	return nil
}

func (p *ModelDescGroup) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelDescGroup"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelDescGroup) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("group_name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.GroupName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelDescGroup) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.LIST, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.Desc)); err != nil {
		return err
	}
	for _, v := range p.Desc {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *ModelDescGroup) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelDescGroup(%+v)", *p)

}

type ModelTag struct {
	TagName         string        `thrift:"tag_name,1" form:"tag_name" json:"tag_name" query:"tag_name"`
	TagClass        ModelTagClass `thrift:"tag_class,2" form:"tag_class" json:"tag_class" query:"tag_class"`
	TagIcon         string        `thrift:"tag_icon,3" form:"tag_icon" json:"tag_icon" query:"tag_icon"`
	TagDescriptions string        `thrift:"tag_descriptions,4" form:"tag_descriptions" json:"tag_descriptions" query:"tag_descriptions"`
}

func NewModelTag() *ModelTag {
	return &ModelTag{}
}

func (p *ModelTag) InitDefault() {
}

func (p *ModelTag) GetTagName() (v string) {
	return p.TagName
}

func (p *ModelTag) GetTagClass() (v ModelTagClass) {
	return p.TagClass
}

func (p *ModelTag) GetTagIcon() (v string) {
	return p.TagIcon
}

func (p *ModelTag) GetTagDescriptions() (v string) {
	return p.TagDescriptions
}

var fieldIDToName_ModelTag = map[int16]string{
	1: "tag_name",
	2: "tag_class",
	3: "tag_icon",
	4: "tag_descriptions",
}

func (p *ModelTag) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelTag[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelTag) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TagName = _field
	return nil
}
func (p *ModelTag) ReadField2(iprot thrift.TProtocol) error {

	var _field ModelTagClass
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ModelTagClass(v)
	}
	p.TagClass = _field
	return nil
}
func (p *ModelTag) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TagIcon = _field
	return nil
}
func (p *ModelTag) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TagDescriptions = _field
	return nil
}

func (p *ModelTag) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelTag"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelTag) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("tag_name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.TagName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelTag) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("tag_class", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.TagClass)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelTag) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("tag_icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.TagIcon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelTag) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("tag_descriptions", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.TagDescriptions); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *ModelTag) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelTag(%+v)", *p)

}

type ModelSeriesInfo struct {
	SeriesName  string  `thrift:"series_name,1" form:"series_name" json:"series_name" query:"series_name"`
	IconURL     string  `thrift:"icon_url,2" form:"icon_url" json:"icon_url" query:"icon_url"`
	ModelVendor string  `thrift:"model_vendor,3" form:"model_vendor" json:"model_vendor" query:"model_vendor"`
	ModelTips   *string `thrift:"model_tips,4,optional" form:"model_tips" json:"model_tips,omitempty" query:"model_tips"`
}

func NewModelSeriesInfo() *ModelSeriesInfo {
	return &ModelSeriesInfo{}
}

func (p *ModelSeriesInfo) InitDefault() {
}

func (p *ModelSeriesInfo) GetSeriesName() (v string) {
	return p.SeriesName
}

func (p *ModelSeriesInfo) GetIconURL() (v string) {
	return p.IconURL
}

func (p *ModelSeriesInfo) GetModelVendor() (v string) {
	return p.ModelVendor
}

var ModelSeriesInfo_ModelTips_DEFAULT string

func (p *ModelSeriesInfo) GetModelTips() (v string) {
	if !p.IsSetModelTips() {
		return ModelSeriesInfo_ModelTips_DEFAULT
	}
	return *p.ModelTips
}

var fieldIDToName_ModelSeriesInfo = map[int16]string{
	1: "series_name",
	2: "icon_url",
	3: "model_vendor",
	4: "model_tips",
}

func (p *ModelSeriesInfo) IsSetModelTips() bool {
	return p.ModelTips != nil
}

func (p *ModelSeriesInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelSeriesInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelSeriesInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SeriesName = _field
	return nil
}
func (p *ModelSeriesInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *ModelSeriesInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelVendor = _field
	return nil
}
func (p *ModelSeriesInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ModelTips = _field
	return nil
}

func (p *ModelSeriesInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelSeriesInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelSeriesInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("series_name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SeriesName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelSeriesInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelSeriesInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_vendor", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ModelVendor); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelSeriesInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelTips() {
		if err = oprot.WriteFieldBegin("model_tips", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ModelTips); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *ModelSeriesInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelSeriesInfo(%+v)", *p)

}

type ModelStatusDetails struct {
	// Is it a new model?
	IsNewModel bool `thrift:"is_new_model,1" form:"is_new_model" json:"is_new_model" query:"is_new_model"`
	// Is it a high-level model?
	IsAdvancedModel bool `thrift:"is_advanced_model,2" form:"is_advanced_model" json:"is_advanced_model" query:"is_advanced_model"`
	// Is it a free model?
	IsFreeModel bool `thrift:"is_free_model,3" form:"is_free_model" json:"is_free_model" query:"is_free_model"`
	// Will it be removed from the shelves soon?
	IsUpcomingDeprecated bool `thrift:"is_upcoming_deprecated,11" form:"is_upcoming_deprecated" json:"is_upcoming_deprecated" query:"is_upcoming_deprecated"`
	// removal date
	DeprecatedDate string `thrift:"deprecated_date,12" form:"deprecated_date" json:"deprecated_date" query:"deprecated_date"`
	// Remove the replacement model from the shelves.
	ReplaceModelName string `thrift:"replace_model_name,13" form:"replace_model_name" json:"replace_model_name" query:"replace_model_name"`
	// Recently updated information
	UpdateInfo string `thrift:"update_info,21" form:"update_info" json:"update_info" query:"update_info"`
	// Model Features
	ModelFeature ModelTagValue `thrift:"model_feature,22" form:"model_feature" json:"model_feature" query:"model_feature"`
}

func NewModelStatusDetails() *ModelStatusDetails {
	return &ModelStatusDetails{}
}

func (p *ModelStatusDetails) InitDefault() {
}

func (p *ModelStatusDetails) GetIsNewModel() (v bool) {
	return p.IsNewModel
}

func (p *ModelStatusDetails) GetIsAdvancedModel() (v bool) {
	return p.IsAdvancedModel
}

func (p *ModelStatusDetails) GetIsFreeModel() (v bool) {
	return p.IsFreeModel
}

func (p *ModelStatusDetails) GetIsUpcomingDeprecated() (v bool) {
	return p.IsUpcomingDeprecated
}

func (p *ModelStatusDetails) GetDeprecatedDate() (v string) {
	return p.DeprecatedDate
}

func (p *ModelStatusDetails) GetReplaceModelName() (v string) {
	return p.ReplaceModelName
}

func (p *ModelStatusDetails) GetUpdateInfo() (v string) {
	return p.UpdateInfo
}

func (p *ModelStatusDetails) GetModelFeature() (v ModelTagValue) {
	return p.ModelFeature
}

var fieldIDToName_ModelStatusDetails = map[int16]string{
	1:  "is_new_model",
	2:  "is_advanced_model",
	3:  "is_free_model",
	11: "is_upcoming_deprecated",
	12: "deprecated_date",
	13: "replace_model_name",
	21: "update_info",
	22: "model_feature",
}

func (p *ModelStatusDetails) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 22:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField22(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelStatusDetails[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelStatusDetails) ReadField1(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsNewModel = _field
	return nil
}
func (p *ModelStatusDetails) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsAdvancedModel = _field
	return nil
}
func (p *ModelStatusDetails) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsFreeModel = _field
	return nil
}
func (p *ModelStatusDetails) ReadField11(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsUpcomingDeprecated = _field
	return nil
}
func (p *ModelStatusDetails) ReadField12(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DeprecatedDate = _field
	return nil
}
func (p *ModelStatusDetails) ReadField13(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ReplaceModelName = _field
	return nil
}
func (p *ModelStatusDetails) ReadField21(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UpdateInfo = _field
	return nil
}
func (p *ModelStatusDetails) ReadField22(iprot thrift.TProtocol) error {

	var _field ModelTagValue
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ModelTagValue(v)
	}
	p.ModelFeature = _field
	return nil
}

func (p *ModelStatusDetails) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelStatusDetails"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
		if err = p.writeField22(oprot); err != nil {
			fieldId = 22
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelStatusDetails) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_new_model", thrift.BOOL, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsNewModel); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelStatusDetails) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_advanced_model", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsAdvancedModel); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelStatusDetails) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_free_model", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsFreeModel); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelStatusDetails) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_upcoming_deprecated", thrift.BOOL, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsUpcomingDeprecated); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *ModelStatusDetails) writeField12(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("deprecated_date", thrift.STRING, 12); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.DeprecatedDate); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *ModelStatusDetails) writeField13(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("replace_model_name", thrift.STRING, 13); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ReplaceModelName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *ModelStatusDetails) writeField21(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("update_info", thrift.STRING, 21); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UpdateInfo); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}
func (p *ModelStatusDetails) writeField22(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_feature", thrift.I32, 22); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ModelFeature)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 end error: ", p), err)
}

func (p *ModelStatusDetails) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelStatusDetails(%+v)", *p)

}

type ModelAbility struct {
	// Do you want to show cot?
	CotDisplay *bool `thrift:"cot_display,1,optional" form:"cot_display" json:"cot_display,omitempty" query:"cot_display"`
	// Supports function calls
	FunctionCall *bool `thrift:"function_call,2,optional" form:"function_call" json:"function_call,omitempty" query:"function_call"`
	// Does it support picture understanding?
	ImageUnderstanding *bool `thrift:"image_understanding,3,optional" form:"image_understanding" json:"image_understanding,omitempty" query:"image_understanding"`
	// Does it support video understanding?
	VideoUnderstanding *bool `thrift:"video_understanding,4,optional" form:"video_understanding" json:"video_understanding,omitempty" query:"video_understanding"`
	// Does it support audio understanding?
	AudioUnderstanding *bool `thrift:"audio_understanding,5,optional" form:"audio_understanding" json:"audio_understanding,omitempty" query:"audio_understanding"`
	// Does it support multimodality?
	SupportMultiModal *bool `thrift:"support_multi_modal,6,optional" form:"support_multi_modal" json:"support_multi_modal,omitempty" query:"support_multi_modal"`
	// Whether to support continuation
	PrefillResp *bool `thrift:"prefill_resp,7,optional" form:"prefill_resp" json:"prefill_resp,omitempty" query:"prefill_resp"`
}

func NewModelAbility() *ModelAbility {
	return &ModelAbility{}
}

func (p *ModelAbility) InitDefault() {
}

var ModelAbility_CotDisplay_DEFAULT bool

func (p *ModelAbility) GetCotDisplay() (v bool) {
	if !p.IsSetCotDisplay() {
		return ModelAbility_CotDisplay_DEFAULT
	}
	return *p.CotDisplay
}

var ModelAbility_FunctionCall_DEFAULT bool

func (p *ModelAbility) GetFunctionCall() (v bool) {
	if !p.IsSetFunctionCall() {
		return ModelAbility_FunctionCall_DEFAULT
	}
	return *p.FunctionCall
}

var ModelAbility_ImageUnderstanding_DEFAULT bool

func (p *ModelAbility) GetImageUnderstanding() (v bool) {
	if !p.IsSetImageUnderstanding() {
		return ModelAbility_ImageUnderstanding_DEFAULT
	}
	return *p.ImageUnderstanding
}

var ModelAbility_VideoUnderstanding_DEFAULT bool

func (p *ModelAbility) GetVideoUnderstanding() (v bool) {
	if !p.IsSetVideoUnderstanding() {
		return ModelAbility_VideoUnderstanding_DEFAULT
	}
	return *p.VideoUnderstanding
}

var ModelAbility_AudioUnderstanding_DEFAULT bool

func (p *ModelAbility) GetAudioUnderstanding() (v bool) {
	if !p.IsSetAudioUnderstanding() {
		return ModelAbility_AudioUnderstanding_DEFAULT
	}
	return *p.AudioUnderstanding
}

var ModelAbility_SupportMultiModal_DEFAULT bool

func (p *ModelAbility) GetSupportMultiModal() (v bool) {
	if !p.IsSetSupportMultiModal() {
		return ModelAbility_SupportMultiModal_DEFAULT
	}
	return *p.SupportMultiModal
}

var ModelAbility_PrefillResp_DEFAULT bool

func (p *ModelAbility) GetPrefillResp() (v bool) {
	if !p.IsSetPrefillResp() {
		return ModelAbility_PrefillResp_DEFAULT
	}
	return *p.PrefillResp
}

var fieldIDToName_ModelAbility = map[int16]string{
	1: "cot_display",
	2: "function_call",
	3: "image_understanding",
	4: "video_understanding",
	5: "audio_understanding",
	6: "support_multi_modal",
	7: "prefill_resp",
}

func (p *ModelAbility) IsSetCotDisplay() bool {
	return p.CotDisplay != nil
}

func (p *ModelAbility) IsSetFunctionCall() bool {
	return p.FunctionCall != nil
}

func (p *ModelAbility) IsSetImageUnderstanding() bool {
	return p.ImageUnderstanding != nil
}

func (p *ModelAbility) IsSetVideoUnderstanding() bool {
	return p.VideoUnderstanding != nil
}

func (p *ModelAbility) IsSetAudioUnderstanding() bool {
	return p.AudioUnderstanding != nil
}

func (p *ModelAbility) IsSetSupportMultiModal() bool {
	return p.SupportMultiModal != nil
}

func (p *ModelAbility) IsSetPrefillResp() bool {
	return p.PrefillResp != nil
}

func (p *ModelAbility) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelAbility[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelAbility) ReadField1(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CotDisplay = _field
	return nil
}
func (p *ModelAbility) ReadField2(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.FunctionCall = _field
	return nil
}
func (p *ModelAbility) ReadField3(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ImageUnderstanding = _field
	return nil
}
func (p *ModelAbility) ReadField4(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.VideoUnderstanding = _field
	return nil
}
func (p *ModelAbility) ReadField5(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.AudioUnderstanding = _field
	return nil
}
func (p *ModelAbility) ReadField6(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SupportMultiModal = _field
	return nil
}
func (p *ModelAbility) ReadField7(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrefillResp = _field
	return nil
}

func (p *ModelAbility) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelAbility"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelAbility) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetCotDisplay() {
		if err = oprot.WriteFieldBegin("cot_display", thrift.BOOL, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.CotDisplay); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelAbility) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetFunctionCall() {
		if err = oprot.WriteFieldBegin("function_call", thrift.BOOL, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.FunctionCall); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelAbility) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetImageUnderstanding() {
		if err = oprot.WriteFieldBegin("image_understanding", thrift.BOOL, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.ImageUnderstanding); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelAbility) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetVideoUnderstanding() {
		if err = oprot.WriteFieldBegin("video_understanding", thrift.BOOL, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.VideoUnderstanding); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ModelAbility) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetAudioUnderstanding() {
		if err = oprot.WriteFieldBegin("audio_understanding", thrift.BOOL, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.AudioUnderstanding); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ModelAbility) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetSupportMultiModal() {
		if err = oprot.WriteFieldBegin("support_multi_modal", thrift.BOOL, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.SupportMultiModal); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *ModelAbility) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrefillResp() {
		if err = oprot.WriteFieldBegin("prefill_resp", thrift.BOOL, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.PrefillResp); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *ModelAbility) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelAbility(%+v)", *p)

}

type Model struct {
	Name       string     `thrift:"name,1" form:"name" json:"name" query:"name"`
	ModelType  int64      `thrift:"model_type,2" form:"model_type" json:"model_type" query:"model_type"`
	ModelClass ModelClass `thrift:"model_class,3" form:"model_class" json:"model_class" query:"model_class"`
	// Model icon url
	ModelIcon        string      `thrift:"model_icon,4" form:"model_icon" json:"model_icon" query:"model_icon"`
	ModelInputPrice  float64     `thrift:"model_input_price,5" form:"model_input_price" json:"model_input_price" query:"model_input_price"`
	ModelOutputPrice float64     `thrift:"model_output_price,6" form:"model_output_price" json:"model_output_price" query:"model_output_price"`
	ModelQuota       *ModelQuota `thrift:"model_quota,7" form:"model_quota" json:"model_quota" query:"model_quota"`
	// Model real name, front-end calculation token
	ModelName      string            `thrift:"model_name,8" form:"model_name" json:"model_name" query:"model_name"`
	ModelClassName string            `thrift:"model_class_name,9" form:"model_class_name" json:"model_class_name" query:"model_class_name"`
	IsOffline      bool              `thrift:"is_offline,10" form:"is_offline" json:"is_offline" query:"is_offline"`
	ModelParams    []*ModelParameter `thrift:"model_params,11" form:"model_params" json:"model_params" query:"model_params"`
	ModelDesc      []*ModelDescGroup `thrift:"model_desc,12,optional" form:"model_desc" json:"model_desc,omitempty" query:"model_desc"`
	// model function configuration
	FuncConfig map[bot_common.ModelFuncConfigType]bot_common.ModelFuncConfigStatus `thrift:"func_config,13,optional" form:"func_config" json:"func_config,omitempty" query:"func_config"`
	// Ark model node name
	EndpointName *string `thrift:"endpoint_name,14,optional" form:"endpoint_name" json:"endpoint_name,omitempty" query:"endpoint_name"`
	// model label
	ModelTagList []*ModelTag `thrift:"model_tag_list,15,optional" form:"model_tag_list" json:"model_tag_list,omitempty" query:"model_tag_list"`
	// User prompt must have and cannot be empty
	IsUpRequired *bool `thrift:"is_up_required,16,optional" form:"is_up_required" json:"is_up_required,omitempty" query:"is_up_required"`
	// Model brief description
	ModelBriefDesc string `thrift:"model_brief_desc,17" form:"model_brief_desc" json:"model_brief_desc" query:"model_brief_desc"`
	// Model series
	ModelSeries *ModelSeriesInfo `thrift:"model_series,18" form:"model_series" json:"model_series" query:"model_series"`
	// model state
	ModelStatusDetails *ModelStatusDetails `thrift:"model_status_details,19" form:"model_status_details" json:"model_status_details" query:"model_status_details"`
	// model capability
	ModelAbility *ModelAbility `thrift:"model_ability,20" form:"model_ability" json:"model_ability" query:"model_ability"`
}

func NewModel() *Model {
	return &Model{}
}

func (p *Model) InitDefault() {
}

func (p *Model) GetName() (v string) {
	return p.Name
}

func (p *Model) GetModelType() (v int64) {
	return p.ModelType
}

func (p *Model) GetModelClass() (v ModelClass) {
	return p.ModelClass
}

func (p *Model) GetModelIcon() (v string) {
	return p.ModelIcon
}

func (p *Model) GetModelInputPrice() (v float64) {
	return p.ModelInputPrice
}

func (p *Model) GetModelOutputPrice() (v float64) {
	return p.ModelOutputPrice
}

var Model_ModelQuota_DEFAULT *ModelQuota

func (p *Model) GetModelQuota() (v *ModelQuota) {
	if !p.IsSetModelQuota() {
		return Model_ModelQuota_DEFAULT
	}
	return p.ModelQuota
}

func (p *Model) GetModelName() (v string) {
	return p.ModelName
}

func (p *Model) GetModelClassName() (v string) {
	return p.ModelClassName
}

func (p *Model) GetIsOffline() (v bool) {
	return p.IsOffline
}

func (p *Model) GetModelParams() (v []*ModelParameter) {
	return p.ModelParams
}

var Model_ModelDesc_DEFAULT []*ModelDescGroup

func (p *Model) GetModelDesc() (v []*ModelDescGroup) {
	if !p.IsSetModelDesc() {
		return Model_ModelDesc_DEFAULT
	}
	return p.ModelDesc
}

var Model_FuncConfig_DEFAULT map[bot_common.ModelFuncConfigType]bot_common.ModelFuncConfigStatus

func (p *Model) GetFuncConfig() (v map[bot_common.ModelFuncConfigType]bot_common.ModelFuncConfigStatus) {
	if !p.IsSetFuncConfig() {
		return Model_FuncConfig_DEFAULT
	}
	return p.FuncConfig
}

var Model_EndpointName_DEFAULT string

func (p *Model) GetEndpointName() (v string) {
	if !p.IsSetEndpointName() {
		return Model_EndpointName_DEFAULT
	}
	return *p.EndpointName
}

var Model_ModelTagList_DEFAULT []*ModelTag

func (p *Model) GetModelTagList() (v []*ModelTag) {
	if !p.IsSetModelTagList() {
		return Model_ModelTagList_DEFAULT
	}
	return p.ModelTagList
}

var Model_IsUpRequired_DEFAULT bool

func (p *Model) GetIsUpRequired() (v bool) {
	if !p.IsSetIsUpRequired() {
		return Model_IsUpRequired_DEFAULT
	}
	return *p.IsUpRequired
}

func (p *Model) GetModelBriefDesc() (v string) {
	return p.ModelBriefDesc
}

var Model_ModelSeries_DEFAULT *ModelSeriesInfo

func (p *Model) GetModelSeries() (v *ModelSeriesInfo) {
	if !p.IsSetModelSeries() {
		return Model_ModelSeries_DEFAULT
	}
	return p.ModelSeries
}

var Model_ModelStatusDetails_DEFAULT *ModelStatusDetails

func (p *Model) GetModelStatusDetails() (v *ModelStatusDetails) {
	if !p.IsSetModelStatusDetails() {
		return Model_ModelStatusDetails_DEFAULT
	}
	return p.ModelStatusDetails
}

var Model_ModelAbility_DEFAULT *ModelAbility

func (p *Model) GetModelAbility() (v *ModelAbility) {
	if !p.IsSetModelAbility() {
		return Model_ModelAbility_DEFAULT
	}
	return p.ModelAbility
}

var fieldIDToName_Model = map[int16]string{
	1:  "name",
	2:  "model_type",
	3:  "model_class",
	4:  "model_icon",
	5:  "model_input_price",
	6:  "model_output_price",
	7:  "model_quota",
	8:  "model_name",
	9:  "model_class_name",
	10: "is_offline",
	11: "model_params",
	12: "model_desc",
	13: "func_config",
	14: "endpoint_name",
	15: "model_tag_list",
	16: "is_up_required",
	17: "model_brief_desc",
	18: "model_series",
	19: "model_status_details",
	20: "model_ability",
}

func (p *Model) IsSetModelQuota() bool {
	return p.ModelQuota != nil
}

func (p *Model) IsSetModelDesc() bool {
	return p.ModelDesc != nil
}

func (p *Model) IsSetFuncConfig() bool {
	return p.FuncConfig != nil
}

func (p *Model) IsSetEndpointName() bool {
	return p.EndpointName != nil
}

func (p *Model) IsSetModelTagList() bool {
	return p.ModelTagList != nil
}

func (p *Model) IsSetIsUpRequired() bool {
	return p.IsUpRequired != nil
}

func (p *Model) IsSetModelSeries() bool {
	return p.ModelSeries != nil
}

func (p *Model) IsSetModelStatusDetails() bool {
	return p.ModelStatusDetails != nil
}

func (p *Model) IsSetModelAbility() bool {
	return p.ModelAbility != nil
}

func (p *Model) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Model[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Model) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *Model) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelType = _field
	return nil
}
func (p *Model) ReadField3(iprot thrift.TProtocol) error {

	var _field ModelClass
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ModelClass(v)
	}
	p.ModelClass = _field
	return nil
}
func (p *Model) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelIcon = _field
	return nil
}
func (p *Model) ReadField5(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelInputPrice = _field
	return nil
}
func (p *Model) ReadField6(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelOutputPrice = _field
	return nil
}
func (p *Model) ReadField7(iprot thrift.TProtocol) error {
	_field := NewModelQuota()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ModelQuota = _field
	return nil
}
func (p *Model) ReadField8(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelName = _field
	return nil
}
func (p *Model) ReadField9(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelClassName = _field
	return nil
}
func (p *Model) ReadField10(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsOffline = _field
	return nil
}
func (p *Model) ReadField11(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ModelParameter, 0, size)
	values := make([]ModelParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.ModelParams = _field
	return nil
}
func (p *Model) ReadField12(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ModelDescGroup, 0, size)
	values := make([]ModelDescGroup, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.ModelDesc = _field
	return nil
}
func (p *Model) ReadField13(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[bot_common.ModelFuncConfigType]bot_common.ModelFuncConfigStatus, size)
	for i := 0; i < size; i++ {
		var _key bot_common.ModelFuncConfigType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_key = bot_common.ModelFuncConfigType(v)
		}

		var _val bot_common.ModelFuncConfigStatus
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_val = bot_common.ModelFuncConfigStatus(v)
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.FuncConfig = _field
	return nil
}
func (p *Model) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EndpointName = _field
	return nil
}
func (p *Model) ReadField15(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ModelTag, 0, size)
	values := make([]ModelTag, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.ModelTagList = _field
	return nil
}
func (p *Model) ReadField16(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsUpRequired = _field
	return nil
}
func (p *Model) ReadField17(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelBriefDesc = _field
	return nil
}
func (p *Model) ReadField18(iprot thrift.TProtocol) error {
	_field := NewModelSeriesInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ModelSeries = _field
	return nil
}
func (p *Model) ReadField19(iprot thrift.TProtocol) error {
	_field := NewModelStatusDetails()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ModelStatusDetails = _field
	return nil
}
func (p *Model) ReadField20(iprot thrift.TProtocol) error {
	_field := NewModelAbility()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ModelAbility = _field
	return nil
}

func (p *Model) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Model"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Model) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Model) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_type", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ModelType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Model) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_class", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ModelClass)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Model) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_icon", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ModelIcon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Model) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_input_price", thrift.DOUBLE, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.ModelInputPrice); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Model) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_output_price", thrift.DOUBLE, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.ModelOutputPrice); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *Model) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_quota", thrift.STRUCT, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.ModelQuota.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *Model) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_name", thrift.STRING, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ModelName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *Model) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_class_name", thrift.STRING, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ModelClassName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *Model) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_offline", thrift.BOOL, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsOffline); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *Model) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_params", thrift.LIST, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.ModelParams)); err != nil {
		return err
	}
	for _, v := range p.ModelParams {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *Model) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelDesc() {
		if err = oprot.WriteFieldBegin("model_desc", thrift.LIST, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.ModelDesc)); err != nil {
			return err
		}
		for _, v := range p.ModelDesc {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *Model) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetFuncConfig() {
		if err = oprot.WriteFieldBegin("func_config", thrift.MAP, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.I32, thrift.I32, len(p.FuncConfig)); err != nil {
			return err
		}
		for k, v := range p.FuncConfig {
			if err := oprot.WriteI32(int32(k)); err != nil {
				return err
			}
			if err := oprot.WriteI32(int32(v)); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *Model) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetEndpointName() {
		if err = oprot.WriteFieldBegin("endpoint_name", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.EndpointName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *Model) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelTagList() {
		if err = oprot.WriteFieldBegin("model_tag_list", thrift.LIST, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.ModelTagList)); err != nil {
			return err
		}
		for _, v := range p.ModelTagList {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *Model) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsUpRequired() {
		if err = oprot.WriteFieldBegin("is_up_required", thrift.BOOL, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsUpRequired); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *Model) writeField17(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_brief_desc", thrift.STRING, 17); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ModelBriefDesc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *Model) writeField18(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_series", thrift.STRUCT, 18); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.ModelSeries.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *Model) writeField19(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_status_details", thrift.STRUCT, 19); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.ModelStatusDetails.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *Model) writeField20(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_ability", thrift.STRUCT, 20); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.ModelAbility.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}

func (p *Model) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Model(%+v)", *p)

}

type VoiceType struct {
	ID        int64  `thrift:"id,1" form:"id" json:"id" query:"id"`
	ModelName string `thrift:"model_name,2" form:"model_name" json:"model_name" query:"model_name"`
	Name      string `thrift:"name,3" form:"name" json:"name" query:"name"`
	Language  string `thrift:"language,4" form:"language" json:"language" query:"language"`
	StyleID   string `thrift:"style_id,5" form:"style_id" json:"style_id" query:"style_id"`
	StyleName string `thrift:"style_name,6" form:"style_name" json:"style_name" query:"style_name"`
}

func NewVoiceType() *VoiceType {
	return &VoiceType{}
}

func (p *VoiceType) InitDefault() {
}

func (p *VoiceType) GetID() (v int64) {
	return p.ID
}

func (p *VoiceType) GetModelName() (v string) {
	return p.ModelName
}

func (p *VoiceType) GetName() (v string) {
	return p.Name
}

func (p *VoiceType) GetLanguage() (v string) {
	return p.Language
}

func (p *VoiceType) GetStyleID() (v string) {
	return p.StyleID
}

func (p *VoiceType) GetStyleName() (v string) {
	return p.StyleName
}

var fieldIDToName_VoiceType = map[int16]string{
	1: "id",
	2: "model_name",
	3: "name",
	4: "language",
	5: "style_id",
	6: "style_name",
}

func (p *VoiceType) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_VoiceType[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *VoiceType) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *VoiceType) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelName = _field
	return nil
}
func (p *VoiceType) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *VoiceType) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Language = _field
	return nil
}
func (p *VoiceType) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.StyleID = _field
	return nil
}
func (p *VoiceType) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.StyleName = _field
	return nil
}

func (p *VoiceType) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("VoiceType"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *VoiceType) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *VoiceType) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ModelName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *VoiceType) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *VoiceType) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("language", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Language); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *VoiceType) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("style_id", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.StyleID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *VoiceType) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("style_name", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.StyleName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}

func (p *VoiceType) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("VoiceType(%+v)", *p)

}

type GetTypeListData struct {
	ModelList    []*Model     `thrift:"model_list,1" form:"model_list" json:"model_list" query:"model_list"`
	VoiceList    []*VoiceType `thrift:"voice_list,2" form:"voice_list" json:"voice_list" query:"voice_list"`
	RawModelList []*Model     `thrift:"raw_model_list,3" form:"raw_model_list" json:"raw_model_list" query:"raw_model_list"`
}

func NewGetTypeListData() *GetTypeListData {
	return &GetTypeListData{}
}

func (p *GetTypeListData) InitDefault() {
}

func (p *GetTypeListData) GetModelList() (v []*Model) {
	return p.ModelList
}

func (p *GetTypeListData) GetVoiceList() (v []*VoiceType) {
	return p.VoiceList
}

func (p *GetTypeListData) GetRawModelList() (v []*Model) {
	return p.RawModelList
}

var fieldIDToName_GetTypeListData = map[int16]string{
	1: "model_list",
	2: "voice_list",
	3: "raw_model_list",
}

func (p *GetTypeListData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetTypeListData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetTypeListData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Model, 0, size)
	values := make([]Model, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.ModelList = _field
	return nil
}
func (p *GetTypeListData) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*VoiceType, 0, size)
	values := make([]VoiceType, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.VoiceList = _field
	return nil
}
func (p *GetTypeListData) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Model, 0, size)
	values := make([]Model, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.RawModelList = _field
	return nil
}

func (p *GetTypeListData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetTypeListData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetTypeListData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.ModelList)); err != nil {
		return err
	}
	for _, v := range p.ModelList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetTypeListData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("voice_list", thrift.LIST, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.VoiceList)); err != nil {
		return err
	}
	for _, v := range p.VoiceList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetTypeListData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("raw_model_list", thrift.LIST, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.RawModelList)); err != nil {
		return err
	}
	for _, v := range p.RawModelList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetTypeListData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetTypeListData(%+v)", *p)

}

type GetTypeListResponse struct {
	Code int64            `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string           `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *GetTypeListData `thrift:"data,3,required" form:"data,required" json:"data,required" query:"data,required"`
}

func NewGetTypeListResponse() *GetTypeListResponse {
	return &GetTypeListResponse{}
}

func (p *GetTypeListResponse) InitDefault() {
}

func (p *GetTypeListResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetTypeListResponse) GetMsg() (v string) {
	return p.Msg
}

var GetTypeListResponse_Data_DEFAULT *GetTypeListData

func (p *GetTypeListResponse) GetData() (v *GetTypeListData) {
	if !p.IsSetData() {
		return GetTypeListResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_GetTypeListResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *GetTypeListResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetTypeListResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetTypeListResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetTypeListResponse[fieldId]))
}

func (p *GetTypeListResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetTypeListResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetTypeListResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetTypeListData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *GetTypeListResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetTypeListResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetTypeListResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetTypeListResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetTypeListResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetTypeListResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetTypeListResponse(%+v)", *p)

}

type UploadFileData struct {
	// File URL
	UploadURL string `thrift:"upload_url,1" form:"upload_url" json:"upload_url" query:"upload_url"`
	// File URI, submit using this
	UploadURI string `thrift:"upload_uri,2" form:"upload_uri" json:"upload_uri" query:"upload_uri"`
}

func NewUploadFileData() *UploadFileData {
	return &UploadFileData{}
}

func (p *UploadFileData) InitDefault() {
}

func (p *UploadFileData) GetUploadURL() (v string) {
	return p.UploadURL
}

func (p *UploadFileData) GetUploadURI() (v string) {
	return p.UploadURI
}

var fieldIDToName_UploadFileData = map[int16]string{
	1: "upload_url",
	2: "upload_uri",
}

func (p *UploadFileData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UploadFileData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UploadFileData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UploadURL = _field
	return nil
}
func (p *UploadFileData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UploadURI = _field
	return nil
}

func (p *UploadFileData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFileData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UploadFileData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("upload_url", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UploadURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UploadFileData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("upload_uri", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UploadURI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UploadFileData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UploadFileData(%+v)", *p)

}

type UpdateUserProfileCheckRequest struct {
	UserUniqueName *string `thrift:"user_unique_name,1,optional" form:"user_unique_name" json:"user_unique_name,omitempty" query:"user_unique_name"`
}

func NewUpdateUserProfileCheckRequest() *UpdateUserProfileCheckRequest {
	return &UpdateUserProfileCheckRequest{}
}

func (p *UpdateUserProfileCheckRequest) InitDefault() {
}

var UpdateUserProfileCheckRequest_UserUniqueName_DEFAULT string

func (p *UpdateUserProfileCheckRequest) GetUserUniqueName() (v string) {
	if !p.IsSetUserUniqueName() {
		return UpdateUserProfileCheckRequest_UserUniqueName_DEFAULT
	}
	return *p.UserUniqueName
}

var fieldIDToName_UpdateUserProfileCheckRequest = map[int16]string{
	1: "user_unique_name",
}

func (p *UpdateUserProfileCheckRequest) IsSetUserUniqueName() bool {
	return p.UserUniqueName != nil
}

func (p *UpdateUserProfileCheckRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateUserProfileCheckRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UpdateUserProfileCheckRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.UserUniqueName = _field
	return nil
}

func (p *UpdateUserProfileCheckRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateUserProfileCheckRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateUserProfileCheckRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserUniqueName() {
		if err = oprot.WriteFieldBegin("user_unique_name", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.UserUniqueName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *UpdateUserProfileCheckRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateUserProfileCheckRequest(%+v)", *p)

}

type UpdateUserProfileCheckResponse struct {
	Code int64  `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
}

func NewUpdateUserProfileCheckResponse() *UpdateUserProfileCheckResponse {
	return &UpdateUserProfileCheckResponse{}
}

func (p *UpdateUserProfileCheckResponse) InitDefault() {
}

func (p *UpdateUserProfileCheckResponse) GetCode() (v int64) {
	return p.Code
}

func (p *UpdateUserProfileCheckResponse) GetMsg() (v string) {
	return p.Msg
}

var fieldIDToName_UpdateUserProfileCheckResponse = map[int16]string{
	1: "code",
	2: "msg",
}

func (p *UpdateUserProfileCheckResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateUserProfileCheckResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UpdateUserProfileCheckResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *UpdateUserProfileCheckResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}

func (p *UpdateUserProfileCheckResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateUserProfileCheckResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateUserProfileCheckResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateUserProfileCheckResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UpdateUserProfileCheckResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateUserProfileCheckResponse(%+v)", *p)

}

type Committer struct {
	ID         *string `thrift:"id,1,optional" form:"id" json:"id,omitempty" query:"id"`
	Name       *string `thrift:"name,2,optional" form:"name" json:"name,omitempty" query:"name"`
	CommitTime *string `thrift:"commit_time,3,optional" form:"commit_time" json:"commit_time,omitempty" query:"commit_time"`
}

func NewCommitter() *Committer {
	return &Committer{}
}

func (p *Committer) InitDefault() {
}

var Committer_ID_DEFAULT string

func (p *Committer) GetID() (v string) {
	if !p.IsSetID() {
		return Committer_ID_DEFAULT
	}
	return *p.ID
}

var Committer_Name_DEFAULT string

func (p *Committer) GetName() (v string) {
	if !p.IsSetName() {
		return Committer_Name_DEFAULT
	}
	return *p.Name
}

var Committer_CommitTime_DEFAULT string

func (p *Committer) GetCommitTime() (v string) {
	if !p.IsSetCommitTime() {
		return Committer_CommitTime_DEFAULT
	}
	return *p.CommitTime
}

var fieldIDToName_Committer = map[int16]string{
	1: "id",
	2: "name",
	3: "commit_time",
}

func (p *Committer) IsSetID() bool {
	return p.ID != nil
}

func (p *Committer) IsSetName() bool {
	return p.Name != nil
}

func (p *Committer) IsSetCommitTime() bool {
	return p.CommitTime != nil
}

func (p *Committer) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Committer[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Committer) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ID = _field
	return nil
}
func (p *Committer) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *Committer) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitTime = _field
	return nil
}

func (p *Committer) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Committer"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Committer) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetID() {
		if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Committer) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Committer) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitTime() {
		if err = oprot.WriteFieldBegin("commit_time", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitTime); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *Committer) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Committer(%+v)", *p)

}

// Check if the draft can be submitted and returned.
type CheckDraftBotCommitResponse struct {
	Code *int64                   `thrift:"code,1,optional" form:"code" json:"code,omitempty" query:"code"`
	Msg  *string                  `thrift:"msg,2,optional" form:"msg" json:"msg,omitempty" query:"msg"`
	Data *CheckDraftBotCommitData `thrift:"data,3,optional" form:"data" json:"data,omitempty" query:"data"`
}

func NewCheckDraftBotCommitResponse() *CheckDraftBotCommitResponse {
	return &CheckDraftBotCommitResponse{}
}

func (p *CheckDraftBotCommitResponse) InitDefault() {
}

var CheckDraftBotCommitResponse_Code_DEFAULT int64

func (p *CheckDraftBotCommitResponse) GetCode() (v int64) {
	if !p.IsSetCode() {
		return CheckDraftBotCommitResponse_Code_DEFAULT
	}
	return *p.Code
}

var CheckDraftBotCommitResponse_Msg_DEFAULT string

func (p *CheckDraftBotCommitResponse) GetMsg() (v string) {
	if !p.IsSetMsg() {
		return CheckDraftBotCommitResponse_Msg_DEFAULT
	}
	return *p.Msg
}

var CheckDraftBotCommitResponse_Data_DEFAULT *CheckDraftBotCommitData

func (p *CheckDraftBotCommitResponse) GetData() (v *CheckDraftBotCommitData) {
	if !p.IsSetData() {
		return CheckDraftBotCommitResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_CheckDraftBotCommitResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *CheckDraftBotCommitResponse) IsSetCode() bool {
	return p.Code != nil
}

func (p *CheckDraftBotCommitResponse) IsSetMsg() bool {
	return p.Msg != nil
}

func (p *CheckDraftBotCommitResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *CheckDraftBotCommitResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CheckDraftBotCommitResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CheckDraftBotCommitResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Code = _field
	return nil
}
func (p *CheckDraftBotCommitResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Msg = _field
	return nil
}
func (p *CheckDraftBotCommitResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewCheckDraftBotCommitData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *CheckDraftBotCommitResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CheckDraftBotCommitResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CheckDraftBotCommitResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetCode() {
		if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.Code); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CheckDraftBotCommitResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetMsg() {
		if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Msg); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CheckDraftBotCommitResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetData() {
		if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Data.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *CheckDraftBotCommitResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CheckDraftBotCommitResponse(%+v)", *p)

}

type CheckDraftBotCommitData struct {
	Status *CommitStatus `thrift:"status,1,optional" form:"status" json:"status,omitempty" query:"status"`
	// master draft version
	BaseCommitVersion *string `thrift:"base_commit_version,2,optional" form:"base_commit_version" json:"base_commit_version,omitempty" query:"base_commit_version"`
	// Master Draft Submission Information
	BaseCommitter *Committer `thrift:"base_committer,3,optional" form:"base_committer" json:"base_committer,omitempty" query:"base_committer"`
	// Personal draft version
	CommitVersion *string `thrift:"commit_version,4,optional" form:"commit_version" json:"commit_version,omitempty" query:"commit_version"`
}

func NewCheckDraftBotCommitData() *CheckDraftBotCommitData {
	return &CheckDraftBotCommitData{}
}

func (p *CheckDraftBotCommitData) InitDefault() {
}

var CheckDraftBotCommitData_Status_DEFAULT CommitStatus

func (p *CheckDraftBotCommitData) GetStatus() (v CommitStatus) {
	if !p.IsSetStatus() {
		return CheckDraftBotCommitData_Status_DEFAULT
	}
	return *p.Status
}

var CheckDraftBotCommitData_BaseCommitVersion_DEFAULT string

func (p *CheckDraftBotCommitData) GetBaseCommitVersion() (v string) {
	if !p.IsSetBaseCommitVersion() {
		return CheckDraftBotCommitData_BaseCommitVersion_DEFAULT
	}
	return *p.BaseCommitVersion
}

var CheckDraftBotCommitData_BaseCommitter_DEFAULT *Committer

func (p *CheckDraftBotCommitData) GetBaseCommitter() (v *Committer) {
	if !p.IsSetBaseCommitter() {
		return CheckDraftBotCommitData_BaseCommitter_DEFAULT
	}
	return p.BaseCommitter
}

var CheckDraftBotCommitData_CommitVersion_DEFAULT string

func (p *CheckDraftBotCommitData) GetCommitVersion() (v string) {
	if !p.IsSetCommitVersion() {
		return CheckDraftBotCommitData_CommitVersion_DEFAULT
	}
	return *p.CommitVersion
}

var fieldIDToName_CheckDraftBotCommitData = map[int16]string{
	1: "status",
	2: "base_commit_version",
	3: "base_committer",
	4: "commit_version",
}

func (p *CheckDraftBotCommitData) IsSetStatus() bool {
	return p.Status != nil
}

func (p *CheckDraftBotCommitData) IsSetBaseCommitVersion() bool {
	return p.BaseCommitVersion != nil
}

func (p *CheckDraftBotCommitData) IsSetBaseCommitter() bool {
	return p.BaseCommitter != nil
}

func (p *CheckDraftBotCommitData) IsSetCommitVersion() bool {
	return p.CommitVersion != nil
}

func (p *CheckDraftBotCommitData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CheckDraftBotCommitData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CheckDraftBotCommitData) ReadField1(iprot thrift.TProtocol) error {

	var _field *CommitStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := CommitStatus(v)
		_field = &tmp
	}
	p.Status = _field
	return nil
}
func (p *CheckDraftBotCommitData) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BaseCommitVersion = _field
	return nil
}
func (p *CheckDraftBotCommitData) ReadField3(iprot thrift.TProtocol) error {
	_field := NewCommitter()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseCommitter = _field
	return nil
}
func (p *CheckDraftBotCommitData) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitVersion = _field
	return nil
}

func (p *CheckDraftBotCommitData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CheckDraftBotCommitData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CheckDraftBotCommitData) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetStatus() {
		if err = oprot.WriteFieldBegin("status", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Status)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CheckDraftBotCommitData) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseCommitVersion() {
		if err = oprot.WriteFieldBegin("base_commit_version", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BaseCommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CheckDraftBotCommitData) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseCommitter() {
		if err = oprot.WriteFieldBegin("base_committer", thrift.STRUCT, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BaseCommitter.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *CheckDraftBotCommitData) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitVersion() {
		if err = oprot.WriteFieldBegin("commit_version", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *CheckDraftBotCommitData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CheckDraftBotCommitData(%+v)", *p)

}

// Check if the draft can be submitted to the request
type CheckDraftBotCommitRequest struct {
	SpaceID       string  `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	BotID         string  `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,required" query:"bot_id,required"`
	CommitVersion *string `thrift:"commit_version,3,optional" form:"commit_version" json:"commit_version,omitempty" query:"commit_version"`
}

func NewCheckDraftBotCommitRequest() *CheckDraftBotCommitRequest {
	return &CheckDraftBotCommitRequest{}
}

func (p *CheckDraftBotCommitRequest) InitDefault() {
}

func (p *CheckDraftBotCommitRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

func (p *CheckDraftBotCommitRequest) GetBotID() (v string) {
	return p.BotID
}

var CheckDraftBotCommitRequest_CommitVersion_DEFAULT string

func (p *CheckDraftBotCommitRequest) GetCommitVersion() (v string) {
	if !p.IsSetCommitVersion() {
		return CheckDraftBotCommitRequest_CommitVersion_DEFAULT
	}
	return *p.CommitVersion
}

var fieldIDToName_CheckDraftBotCommitRequest = map[int16]string{
	1: "space_id",
	2: "bot_id",
	3: "commit_version",
}

func (p *CheckDraftBotCommitRequest) IsSetCommitVersion() bool {
	return p.CommitVersion != nil
}

func (p *CheckDraftBotCommitRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CheckDraftBotCommitRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CheckDraftBotCommitRequest[fieldId]))
}

func (p *CheckDraftBotCommitRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *CheckDraftBotCommitRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *CheckDraftBotCommitRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitVersion = _field
	return nil
}

func (p *CheckDraftBotCommitRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CheckDraftBotCommitRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CheckDraftBotCommitRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CheckDraftBotCommitRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CheckDraftBotCommitRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitVersion() {
		if err = oprot.WriteFieldBegin("commit_version", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *CheckDraftBotCommitRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CheckDraftBotCommitRequest(%+v)", *p)

}

type GetOnboardingRequest struct {
	BotID     string `thrift:"bot_id,1" form:"bot_id" json:"bot_id" query:"bot_id"`
	BotPrompt string `thrift:"bot_prompt,2" form:"bot_prompt" json:"bot_prompt" query:"bot_prompt"`
}

func NewGetOnboardingRequest() *GetOnboardingRequest {
	return &GetOnboardingRequest{}
}

func (p *GetOnboardingRequest) InitDefault() {
}

func (p *GetOnboardingRequest) GetBotID() (v string) {
	return p.BotID
}

func (p *GetOnboardingRequest) GetBotPrompt() (v string) {
	return p.BotPrompt
}

var fieldIDToName_GetOnboardingRequest = map[int16]string{
	1: "bot_id",
	2: "bot_prompt",
}

func (p *GetOnboardingRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetOnboardingRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetOnboardingRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *GetOnboardingRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotPrompt = _field
	return nil
}

func (p *GetOnboardingRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetOnboardingRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetOnboardingRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetOnboardingRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_prompt", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.BotPrompt); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *GetOnboardingRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetOnboardingRequest(%+v)", *p)

}

type GetOnboardingResponseData struct {
	OnboardingContent *OnboardingContent `thrift:"onboarding_content,1" form:"onboarding_content" json:"onboarding_content" query:"onboarding_content"`
}

func NewGetOnboardingResponseData() *GetOnboardingResponseData {
	return &GetOnboardingResponseData{}
}

func (p *GetOnboardingResponseData) InitDefault() {
}

var GetOnboardingResponseData_OnboardingContent_DEFAULT *OnboardingContent

func (p *GetOnboardingResponseData) GetOnboardingContent() (v *OnboardingContent) {
	if !p.IsSetOnboardingContent() {
		return GetOnboardingResponseData_OnboardingContent_DEFAULT
	}
	return p.OnboardingContent
}

var fieldIDToName_GetOnboardingResponseData = map[int16]string{
	1: "onboarding_content",
}

func (p *GetOnboardingResponseData) IsSetOnboardingContent() bool {
	return p.OnboardingContent != nil
}

func (p *GetOnboardingResponseData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetOnboardingResponseData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetOnboardingResponseData) ReadField1(iprot thrift.TProtocol) error {
	_field := NewOnboardingContent()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.OnboardingContent = _field
	return nil
}

func (p *GetOnboardingResponseData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetOnboardingResponseData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetOnboardingResponseData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("onboarding_content", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.OnboardingContent.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *GetOnboardingResponseData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetOnboardingResponseData(%+v)", *p)

}

type GetOnboardingResponse struct {
	Code int64                      `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg  string                     `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data *GetOnboardingResponseData `thrift:"data,3" form:"data" json:"data" query:"data"`
}

func NewGetOnboardingResponse() *GetOnboardingResponse {
	return &GetOnboardingResponse{}
}

func (p *GetOnboardingResponse) InitDefault() {
}

func (p *GetOnboardingResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetOnboardingResponse) GetMsg() (v string) {
	return p.Msg
}

var GetOnboardingResponse_Data_DEFAULT *GetOnboardingResponseData

func (p *GetOnboardingResponse) GetData() (v *GetOnboardingResponseData) {
	if !p.IsSetData() {
		return GetOnboardingResponse_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_GetOnboardingResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *GetOnboardingResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetOnboardingResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetOnboardingResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetOnboardingResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetOnboardingResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetOnboardingResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetOnboardingResponseData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *GetOnboardingResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetOnboardingResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetOnboardingResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetOnboardingResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetOnboardingResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetOnboardingResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetOnboardingResponse(%+v)", *p)

}

type OnboardingContent struct {
	// opening statement
	Prologue *string `thrift:"prologue,1,optional" form:"prologue" json:"prologue,omitempty" query:"prologue"`
	// suggestion question
	SuggestedQuestions []string `thrift:"suggested_questions,2,optional" form:"suggested_questions" json:"suggested_questions,omitempty" query:"suggested_questions"`
}

func NewOnboardingContent() *OnboardingContent {
	return &OnboardingContent{}
}

func (p *OnboardingContent) InitDefault() {
}

var OnboardingContent_Prologue_DEFAULT string

func (p *OnboardingContent) GetPrologue() (v string) {
	if !p.IsSetPrologue() {
		return OnboardingContent_Prologue_DEFAULT
	}
	return *p.Prologue
}

var OnboardingContent_SuggestedQuestions_DEFAULT []string

func (p *OnboardingContent) GetSuggestedQuestions() (v []string) {
	if !p.IsSetSuggestedQuestions() {
		return OnboardingContent_SuggestedQuestions_DEFAULT
	}
	return p.SuggestedQuestions
}

var fieldIDToName_OnboardingContent = map[int16]string{
	1: "prologue",
	2: "suggested_questions",
}

func (p *OnboardingContent) IsSetPrologue() bool {
	return p.Prologue != nil
}

func (p *OnboardingContent) IsSetSuggestedQuestions() bool {
	return p.SuggestedQuestions != nil
}

func (p *OnboardingContent) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_OnboardingContent[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *OnboardingContent) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Prologue = _field
	return nil
}
func (p *OnboardingContent) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SuggestedQuestions = _field
	return nil
}

func (p *OnboardingContent) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OnboardingContent"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *OnboardingContent) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrologue() {
		if err = oprot.WriteFieldBegin("prologue", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Prologue); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *OnboardingContent) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuggestedQuestions() {
		if err = oprot.WriteFieldBegin("suggested_questions", thrift.LIST, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.SuggestedQuestions)); err != nil {
			return err
		}
		for _, v := range p.SuggestedQuestions {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *OnboardingContent) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("OnboardingContent(%+v)", *p)

}

type AuthLoginInfo struct {
	AppID        string `thrift:"app_id,1" form:"app_id" json:"app_id" query:"app_id"`
	ResponseType string `thrift:"response_type,2" form:"response_type" json:"response_type" query:"response_type"`
	AuthorizeURL string `thrift:"authorize_url,3" form:"authorize_url" json:"authorize_url" query:"authorize_url"`
	Scope        string `thrift:"scope,4" form:"scope" json:"scope" query:"scope"`
	ClientID     string `thrift:"client_id,5" form:"client_id" json:"client_id" query:"client_id"`
	Duration     string `thrift:"duration,6" form:"duration" json:"duration" query:"duration"`
	Aid          string `thrift:"aid,7" form:"aid" json:"aid" query:"aid"`
	ClientKey    string `thrift:"client_key,8" form:"client_key" json:"client_key" query:"client_key"`
}

func NewAuthLoginInfo() *AuthLoginInfo {
	return &AuthLoginInfo{}
}

func (p *AuthLoginInfo) InitDefault() {
}

func (p *AuthLoginInfo) GetAppID() (v string) {
	return p.AppID
}

func (p *AuthLoginInfo) GetResponseType() (v string) {
	return p.ResponseType
}

func (p *AuthLoginInfo) GetAuthorizeURL() (v string) {
	return p.AuthorizeURL
}

func (p *AuthLoginInfo) GetScope() (v string) {
	return p.Scope
}

func (p *AuthLoginInfo) GetClientID() (v string) {
	return p.ClientID
}

func (p *AuthLoginInfo) GetDuration() (v string) {
	return p.Duration
}

func (p *AuthLoginInfo) GetAid() (v string) {
	return p.Aid
}

func (p *AuthLoginInfo) GetClientKey() (v string) {
	return p.ClientKey
}

var fieldIDToName_AuthLoginInfo = map[int16]string{
	1: "app_id",
	2: "response_type",
	3: "authorize_url",
	4: "scope",
	5: "client_id",
	6: "duration",
	7: "aid",
	8: "client_key",
}

func (p *AuthLoginInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_AuthLoginInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *AuthLoginInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AppID = _field
	return nil
}
func (p *AuthLoginInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ResponseType = _field
	return nil
}
func (p *AuthLoginInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AuthorizeURL = _field
	return nil
}
func (p *AuthLoginInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Scope = _field
	return nil
}
func (p *AuthLoginInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ClientID = _field
	return nil
}
func (p *AuthLoginInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Duration = _field
	return nil
}
func (p *AuthLoginInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Aid = _field
	return nil
}
func (p *AuthLoginInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ClientKey = _field
	return nil
}

func (p *AuthLoginInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("AuthLoginInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *AuthLoginInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("app_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AppID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *AuthLoginInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("response_type", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ResponseType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *AuthLoginInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("authorize_url", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AuthorizeURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *AuthLoginInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("scope", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Scope); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *AuthLoginInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("client_id", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ClientID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *AuthLoginInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("duration", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Duration); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *AuthLoginInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("aid", thrift.STRING, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Aid); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *AuthLoginInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("client_key", thrift.STRING, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ClientKey); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}

func (p *AuthLoginInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AuthLoginInfo(%+v)", *p)

}

type PublishConnectorListRequest struct {
	SpaceID       int64   `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,string,required" query:"space_id,required"`
	BotID         int64   `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	CommitVersion *string `thrift:"commit_version,3,optional" form:"commit_version" json:"commit_version,omitempty" query:"commit_version"`
}

func NewPublishConnectorListRequest() *PublishConnectorListRequest {
	return &PublishConnectorListRequest{}
}

func (p *PublishConnectorListRequest) InitDefault() {
}

func (p *PublishConnectorListRequest) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *PublishConnectorListRequest) GetBotID() (v int64) {
	return p.BotID
}

var PublishConnectorListRequest_CommitVersion_DEFAULT string

func (p *PublishConnectorListRequest) GetCommitVersion() (v string) {
	if !p.IsSetCommitVersion() {
		return PublishConnectorListRequest_CommitVersion_DEFAULT
	}
	return *p.CommitVersion
}

var fieldIDToName_PublishConnectorListRequest = map[int16]string{
	1: "space_id",
	2: "bot_id",
	3: "commit_version",
}

func (p *PublishConnectorListRequest) IsSetCommitVersion() bool {
	return p.CommitVersion != nil
}

func (p *PublishConnectorListRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishConnectorListRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_PublishConnectorListRequest[fieldId]))
}

func (p *PublishConnectorListRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *PublishConnectorListRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *PublishConnectorListRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitVersion = _field
	return nil
}

func (p *PublishConnectorListRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishConnectorListRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishConnectorListRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishConnectorListRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishConnectorListRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitVersion() {
		if err = oprot.WriteFieldBegin("commit_version", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *PublishConnectorListRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishConnectorListRequest(%+v)", *p)

}

type PublishConnectorInfo struct {
	// Publishing Platform connector_id
	ID string `thrift:"id,1,required" form:"id,required" json:"id,required" query:"id,required"`
	// publishing platform name
	Name string `thrift:"name,2,required" form:"name,required" json:"name,required" query:"name,required"`
	// publishing platform icon
	Icon string `thrift:"icon,3,required" form:"icon,required" json:"icon,required" query:"icon,required"`
	// Publish Platform Description
	Desc string `thrift:"desc,4,required" form:"desc,required" json:"desc,required" query:"desc,required"`
	// share link
	ShareLink string `thrift:"share_link,5,required" form:"share_link,required" json:"share_link,required" query:"share_link,required"`
	// Configuration Status 1: Bound 2: Unbound
	ConfigStatus ConfigStatus `thrift:"config_status,6,required" form:"config_status,required" json:"config_status,required" query:"config_status,required"`
	// Last Post
	LastPublishTime int64 `thrift:"last_publish_time,7,required" form:"last_publish_time,required" json:"last_publish_time,required" query:"last_publish_time,required"`
	// Binding type 1: No binding required 2: Auth 3: kv value
	BindType BindType `thrift:"bind_type,8,required" form:"bind_type,required" json:"bind_type,required" query:"bind_type,required"`
	// Binding information key field name value is value
	BindInfo map[string]string `thrift:"bind_info,9,required" form:"bind_info,required" json:"bind_info,required" query:"bind_info,required"`
	// Bind id information for unbinding and use
	BindID *string `thrift:"bind_id,10,optional" form:"bind_id" json:"bind_id,omitempty" query:"bind_id"`
	// user authorization login information
	AuthLoginInfo *AuthLoginInfo `thrift:"auth_login_info,11,optional" form:"auth_login_info" json:"auth_login_info,omitempty" query:"auth_login_info"`
	// Is it the last release?
	IsLastPublished *bool `thrift:"is_last_published,12,optional" form:"is_last_published" json:"is_last_published,omitempty" query:"is_last_published"`
	// bot channel status
	ConnectorStatus *BotConnectorStatus `thrift:"connector_status,13,optional" form:"connector_status" json:"connector_status,omitempty" query:"connector_status"`
	// Privacy Policy
	PrivacyPolicy *string `thrift:"privacy_policy,14,optional" form:"privacy_policy" json:"privacy_policy,omitempty" query:"privacy_policy"`
	// User Agreement
	UserAgreement *string `thrift:"user_agreement,15,optional" form:"user_agreement" json:"user_agreement,omitempty" query:"user_agreement"`
	// Is the channel allowed to publish?
	AllowPunish *AllowPublishStatus `thrift:"allow_punish,16,optional" form:"allow_punish" json:"allow_punish,omitempty" query:"allow_punish"`
	// Reason for not allowing posting
	NotAllowReason *string `thrift:"not_allow_reason,17,optional" form:"not_allow_reason" json:"not_allow_reason,omitempty" query:"not_allow_reason"`
	// Configuration status toast
	ConfigStatusToast *string `thrift:"config_status_toast,18,optional" form:"config_status_toast" json:"config_status_toast,omitempty" query:"config_status_toast"`
	// Brand ID
	BrandID *int64 `thrift:"brand_id,19,optional" form:"brand_id" json:"brand_id,omitempty" query:"brand_id"`
	// Support commercialization
	SupportMonetization *bool `thrift:"support_monetization,20,optional" form:"support_monetization" json:"support_monetization,omitempty" query:"support_monetization"`
	// 1: Authorized, 2: Unauthorized. Currently this field is only available bind_type == 8
	AuthStatus *UserAuthStatus `thrift:"auth_status,21,optional" form:"auth_status" json:"auth_status,omitempty" query:"auth_status"`
	// URL of the complete info button
	ToCompleteInfoURL *string `thrift:"to_complete_info_url,22,optional" form:"to_complete_info_url" json:"to_complete_info_url,omitempty" query:"to_complete_info_url"`
}

func NewPublishConnectorInfo() *PublishConnectorInfo {
	return &PublishConnectorInfo{}
}

func (p *PublishConnectorInfo) InitDefault() {
}

func (p *PublishConnectorInfo) GetID() (v string) {
	return p.ID
}

func (p *PublishConnectorInfo) GetName() (v string) {
	return p.Name
}

func (p *PublishConnectorInfo) GetIcon() (v string) {
	return p.Icon
}

func (p *PublishConnectorInfo) GetDesc() (v string) {
	return p.Desc
}

func (p *PublishConnectorInfo) GetShareLink() (v string) {
	return p.ShareLink
}

func (p *PublishConnectorInfo) GetConfigStatus() (v ConfigStatus) {
	return p.ConfigStatus
}

func (p *PublishConnectorInfo) GetLastPublishTime() (v int64) {
	return p.LastPublishTime
}

func (p *PublishConnectorInfo) GetBindType() (v BindType) {
	return p.BindType
}

func (p *PublishConnectorInfo) GetBindInfo() (v map[string]string) {
	return p.BindInfo
}

var PublishConnectorInfo_BindID_DEFAULT string

func (p *PublishConnectorInfo) GetBindID() (v string) {
	if !p.IsSetBindID() {
		return PublishConnectorInfo_BindID_DEFAULT
	}
	return *p.BindID
}

var PublishConnectorInfo_AuthLoginInfo_DEFAULT *AuthLoginInfo

func (p *PublishConnectorInfo) GetAuthLoginInfo() (v *AuthLoginInfo) {
	if !p.IsSetAuthLoginInfo() {
		return PublishConnectorInfo_AuthLoginInfo_DEFAULT
	}
	return p.AuthLoginInfo
}

var PublishConnectorInfo_IsLastPublished_DEFAULT bool

func (p *PublishConnectorInfo) GetIsLastPublished() (v bool) {
	if !p.IsSetIsLastPublished() {
		return PublishConnectorInfo_IsLastPublished_DEFAULT
	}
	return *p.IsLastPublished
}

var PublishConnectorInfo_ConnectorStatus_DEFAULT BotConnectorStatus

func (p *PublishConnectorInfo) GetConnectorStatus() (v BotConnectorStatus) {
	if !p.IsSetConnectorStatus() {
		return PublishConnectorInfo_ConnectorStatus_DEFAULT
	}
	return *p.ConnectorStatus
}

var PublishConnectorInfo_PrivacyPolicy_DEFAULT string

func (p *PublishConnectorInfo) GetPrivacyPolicy() (v string) {
	if !p.IsSetPrivacyPolicy() {
		return PublishConnectorInfo_PrivacyPolicy_DEFAULT
	}
	return *p.PrivacyPolicy
}

var PublishConnectorInfo_UserAgreement_DEFAULT string

func (p *PublishConnectorInfo) GetUserAgreement() (v string) {
	if !p.IsSetUserAgreement() {
		return PublishConnectorInfo_UserAgreement_DEFAULT
	}
	return *p.UserAgreement
}

var PublishConnectorInfo_AllowPunish_DEFAULT AllowPublishStatus

func (p *PublishConnectorInfo) GetAllowPunish() (v AllowPublishStatus) {
	if !p.IsSetAllowPunish() {
		return PublishConnectorInfo_AllowPunish_DEFAULT
	}
	return *p.AllowPunish
}

var PublishConnectorInfo_NotAllowReason_DEFAULT string

func (p *PublishConnectorInfo) GetNotAllowReason() (v string) {
	if !p.IsSetNotAllowReason() {
		return PublishConnectorInfo_NotAllowReason_DEFAULT
	}
	return *p.NotAllowReason
}

var PublishConnectorInfo_ConfigStatusToast_DEFAULT string

func (p *PublishConnectorInfo) GetConfigStatusToast() (v string) {
	if !p.IsSetConfigStatusToast() {
		return PublishConnectorInfo_ConfigStatusToast_DEFAULT
	}
	return *p.ConfigStatusToast
}

var PublishConnectorInfo_BrandID_DEFAULT int64

func (p *PublishConnectorInfo) GetBrandID() (v int64) {
	if !p.IsSetBrandID() {
		return PublishConnectorInfo_BrandID_DEFAULT
	}
	return *p.BrandID
}

var PublishConnectorInfo_SupportMonetization_DEFAULT bool

func (p *PublishConnectorInfo) GetSupportMonetization() (v bool) {
	if !p.IsSetSupportMonetization() {
		return PublishConnectorInfo_SupportMonetization_DEFAULT
	}
	return *p.SupportMonetization
}

var PublishConnectorInfo_AuthStatus_DEFAULT UserAuthStatus

func (p *PublishConnectorInfo) GetAuthStatus() (v UserAuthStatus) {
	if !p.IsSetAuthStatus() {
		return PublishConnectorInfo_AuthStatus_DEFAULT
	}
	return *p.AuthStatus
}

var PublishConnectorInfo_ToCompleteInfoURL_DEFAULT string

func (p *PublishConnectorInfo) GetToCompleteInfoURL() (v string) {
	if !p.IsSetToCompleteInfoURL() {
		return PublishConnectorInfo_ToCompleteInfoURL_DEFAULT
	}
	return *p.ToCompleteInfoURL
}

var fieldIDToName_PublishConnectorInfo = map[int16]string{
	1:  "id",
	2:  "name",
	3:  "icon",
	4:  "desc",
	5:  "share_link",
	6:  "config_status",
	7:  "last_publish_time",
	8:  "bind_type",
	9:  "bind_info",
	10: "bind_id",
	11: "auth_login_info",
	12: "is_last_published",
	13: "connector_status",
	14: "privacy_policy",
	15: "user_agreement",
	16: "allow_punish",
	17: "not_allow_reason",
	18: "config_status_toast",
	19: "brand_id",
	20: "support_monetization",
	21: "auth_status",
	22: "to_complete_info_url",
}

func (p *PublishConnectorInfo) IsSetBindID() bool {
	return p.BindID != nil
}

func (p *PublishConnectorInfo) IsSetAuthLoginInfo() bool {
	return p.AuthLoginInfo != nil
}

func (p *PublishConnectorInfo) IsSetIsLastPublished() bool {
	return p.IsLastPublished != nil
}

func (p *PublishConnectorInfo) IsSetConnectorStatus() bool {
	return p.ConnectorStatus != nil
}

func (p *PublishConnectorInfo) IsSetPrivacyPolicy() bool {
	return p.PrivacyPolicy != nil
}

func (p *PublishConnectorInfo) IsSetUserAgreement() bool {
	return p.UserAgreement != nil
}

func (p *PublishConnectorInfo) IsSetAllowPunish() bool {
	return p.AllowPunish != nil
}

func (p *PublishConnectorInfo) IsSetNotAllowReason() bool {
	return p.NotAllowReason != nil
}

func (p *PublishConnectorInfo) IsSetConfigStatusToast() bool {
	return p.ConfigStatusToast != nil
}

func (p *PublishConnectorInfo) IsSetBrandID() bool {
	return p.BrandID != nil
}

func (p *PublishConnectorInfo) IsSetSupportMonetization() bool {
	return p.SupportMonetization != nil
}

func (p *PublishConnectorInfo) IsSetAuthStatus() bool {
	return p.AuthStatus != nil
}

func (p *PublishConnectorInfo) IsSetToCompleteInfoURL() bool {
	return p.ToCompleteInfoURL != nil
}

func (p *PublishConnectorInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetID bool = false
	var issetName bool = false
	var issetIcon bool = false
	var issetDesc bool = false
	var issetShareLink bool = false
	var issetConfigStatus bool = false
	var issetLastPublishTime bool = false
	var issetBindType bool = false
	var issetBindInfo bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetName = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetIcon = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetDesc = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
				issetShareLink = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
				issetConfigStatus = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
				issetLastPublishTime = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
				issetBindType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
				issetBindInfo = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 22:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField22(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetName {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetIcon {
		fieldId = 3
		goto RequiredFieldNotSetError
	}

	if !issetDesc {
		fieldId = 4
		goto RequiredFieldNotSetError
	}

	if !issetShareLink {
		fieldId = 5
		goto RequiredFieldNotSetError
	}

	if !issetConfigStatus {
		fieldId = 6
		goto RequiredFieldNotSetError
	}

	if !issetLastPublishTime {
		fieldId = 7
		goto RequiredFieldNotSetError
	}

	if !issetBindType {
		fieldId = 8
		goto RequiredFieldNotSetError
	}

	if !issetBindInfo {
		fieldId = 9
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishConnectorInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_PublishConnectorInfo[fieldId]))
}

func (p *PublishConnectorInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ShareLink = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field ConfigStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ConfigStatus(v)
	}
	p.ConfigStatus = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LastPublishTime = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField8(iprot thrift.TProtocol) error {

	var _field BindType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = BindType(v)
	}
	p.BindType = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField9(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]string, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		var _val string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_val = v
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.BindInfo = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField10(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BindID = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField11(iprot thrift.TProtocol) error {
	_field := NewAuthLoginInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.AuthLoginInfo = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField12(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsLastPublished = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField13(iprot thrift.TProtocol) error {

	var _field *BotConnectorStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := BotConnectorStatus(v)
		_field = &tmp
	}
	p.ConnectorStatus = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PrivacyPolicy = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.UserAgreement = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField16(iprot thrift.TProtocol) error {

	var _field *AllowPublishStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := AllowPublishStatus(v)
		_field = &tmp
	}
	p.AllowPunish = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField17(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NotAllowReason = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField18(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ConfigStatusToast = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField19(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BrandID = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField20(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SupportMonetization = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField21(iprot thrift.TProtocol) error {

	var _field *UserAuthStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := UserAuthStatus(v)
		_field = &tmp
	}
	p.AuthStatus = _field
	return nil
}
func (p *PublishConnectorInfo) ReadField22(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ToCompleteInfoURL = _field
	return nil
}

func (p *PublishConnectorInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishConnectorInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
		if err = p.writeField22(oprot); err != nil {
			fieldId = 22
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishConnectorInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("share_link", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ShareLink); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("config_status", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ConfigStatus)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("last_publish_time", thrift.I64, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.LastPublishTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bind_type", thrift.I32, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.BindType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bind_info", thrift.MAP, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRING, len(p.BindInfo)); err != nil {
		return err
	}
	for k, v := range p.BindInfo {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindID() {
		if err = oprot.WriteFieldBegin("bind_id", thrift.STRING, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BindID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetAuthLoginInfo() {
		if err = oprot.WriteFieldBegin("auth_login_info", thrift.STRUCT, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.AuthLoginInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsLastPublished() {
		if err = oprot.WriteFieldBegin("is_last_published", thrift.BOOL, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsLastPublished); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetConnectorStatus() {
		if err = oprot.WriteFieldBegin("connector_status", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.ConnectorStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrivacyPolicy() {
		if err = oprot.WriteFieldBegin("privacy_policy", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PrivacyPolicy); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserAgreement() {
		if err = oprot.WriteFieldBegin("user_agreement", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.UserAgreement); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetAllowPunish() {
		if err = oprot.WriteFieldBegin("allow_punish", thrift.I32, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.AllowPunish)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetNotAllowReason() {
		if err = oprot.WriteFieldBegin("not_allow_reason", thrift.STRING, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.NotAllowReason); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField18(oprot thrift.TProtocol) (err error) {
	if p.IsSetConfigStatusToast() {
		if err = oprot.WriteFieldBegin("config_status_toast", thrift.STRING, 18); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ConfigStatusToast); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField19(oprot thrift.TProtocol) (err error) {
	if p.IsSetBrandID() {
		if err = oprot.WriteFieldBegin("brand_id", thrift.I64, 19); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.BrandID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField20(oprot thrift.TProtocol) (err error) {
	if p.IsSetSupportMonetization() {
		if err = oprot.WriteFieldBegin("support_monetization", thrift.BOOL, 20); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.SupportMonetization); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField21(oprot thrift.TProtocol) (err error) {
	if p.IsSetAuthStatus() {
		if err = oprot.WriteFieldBegin("auth_status", thrift.I32, 21); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.AuthStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}
func (p *PublishConnectorInfo) writeField22(oprot thrift.TProtocol) (err error) {
	if p.IsSetToCompleteInfoURL() {
		if err = oprot.WriteFieldBegin("to_complete_info_url", thrift.STRING, 22); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ToCompleteInfoURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 end error: ", p), err)
}

func (p *PublishConnectorInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishConnectorInfo(%+v)", *p)

}

type SubmitBotMarketOption struct {
	// Is it possible to publicly orchestrate?
	CanOpenSource *bool `thrift:"can_open_source,1,optional" form:"can_open_source" json:"can_open_source,omitempty" query:"can_open_source"`
}

func NewSubmitBotMarketOption() *SubmitBotMarketOption {
	return &SubmitBotMarketOption{}
}

func (p *SubmitBotMarketOption) InitDefault() {
}

var SubmitBotMarketOption_CanOpenSource_DEFAULT bool

func (p *SubmitBotMarketOption) GetCanOpenSource() (v bool) {
	if !p.IsSetCanOpenSource() {
		return SubmitBotMarketOption_CanOpenSource_DEFAULT
	}
	return *p.CanOpenSource
}

var fieldIDToName_SubmitBotMarketOption = map[int16]string{
	1: "can_open_source",
}

func (p *SubmitBotMarketOption) IsSetCanOpenSource() bool {
	return p.CanOpenSource != nil
}

func (p *SubmitBotMarketOption) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SubmitBotMarketOption[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SubmitBotMarketOption) ReadField1(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CanOpenSource = _field
	return nil
}

func (p *SubmitBotMarketOption) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SubmitBotMarketOption"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SubmitBotMarketOption) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetCanOpenSource() {
		if err = oprot.WriteFieldBegin("can_open_source", thrift.BOOL, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.CanOpenSource); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *SubmitBotMarketOption) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SubmitBotMarketOption(%+v)", *p)

}

type ConnectorBrandInfo struct {
	ID   int64  `thrift:"id,1,required" form:"id,required" json:"id,required" query:"id,required"`
	Name string `thrift:"name,2,required" form:"name,required" json:"name,required" query:"name,required"`
	Icon string `thrift:"icon,3,required" form:"icon,required" json:"icon,required" query:"icon,required"`
}

func NewConnectorBrandInfo() *ConnectorBrandInfo {
	return &ConnectorBrandInfo{}
}

func (p *ConnectorBrandInfo) InitDefault() {
}

func (p *ConnectorBrandInfo) GetID() (v int64) {
	return p.ID
}

func (p *ConnectorBrandInfo) GetName() (v string) {
	return p.Name
}

func (p *ConnectorBrandInfo) GetIcon() (v string) {
	return p.Icon
}

var fieldIDToName_ConnectorBrandInfo = map[int16]string{
	1: "id",
	2: "name",
	3: "icon",
}

func (p *ConnectorBrandInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetID bool = false
	var issetName bool = false
	var issetIcon bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetName = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetIcon = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetName {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetIcon {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ConnectorBrandInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ConnectorBrandInfo[fieldId]))
}

func (p *ConnectorBrandInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *ConnectorBrandInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ConnectorBrandInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}

func (p *ConnectorBrandInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ConnectorBrandInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ConnectorBrandInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ConnectorBrandInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ConnectorBrandInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *ConnectorBrandInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ConnectorBrandInfo(%+v)", *p)

}

type PublishTips struct {
	// cost-bearing reminder
	CostTips *string `thrift:"cost_tips,1,optional" form:"cost_tips" json:"cost_tips,omitempty" query:"cost_tips"`
}

func NewPublishTips() *PublishTips {
	return &PublishTips{}
}

func (p *PublishTips) InitDefault() {
}

var PublishTips_CostTips_DEFAULT string

func (p *PublishTips) GetCostTips() (v string) {
	if !p.IsSetCostTips() {
		return PublishTips_CostTips_DEFAULT
	}
	return *p.CostTips
}

var fieldIDToName_PublishTips = map[int16]string{
	1: "cost_tips",
}

func (p *PublishTips) IsSetCostTips() bool {
	return p.CostTips != nil
}

func (p *PublishTips) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishTips[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublishTips) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CostTips = _field
	return nil
}

func (p *PublishTips) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishTips"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishTips) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetCostTips() {
		if err = oprot.WriteFieldBegin("cost_tips", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CostTips); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PublishTips) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishTips(%+v)", *p)

}

type PublishConnectorListResponse struct {
	Code                  int64                   `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg                   string                  `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	PublishConnectorList  []*PublishConnectorInfo `thrift:"publish_connector_list,3" form:"publish_connector_list" json:"publish_connector_list" query:"publish_connector_list"`
	SubmitBotMarketOption *SubmitBotMarketOption  `thrift:"submit_bot_market_option,4,optional" form:"submit_bot_market_option" json:"submit_bot_market_option,omitempty" query:"submit_bot_market_option"`
	// The configuration of the last submitted market
	LastSubmitConfig *SubmitBotMarketConfig `thrift:"last_submit_config,5,optional" form:"last_submit_config" json:"last_submit_config,omitempty" query:"last_submit_config"`
	// Channel brand information
	ConnectorBrandInfoMap map[int64]*ConnectorBrandInfo `thrift:"connector_brand_info_map,6" form:"connector_brand_info_map" json:"connector_brand_info_map" query:"connector_brand_info_map"`
	// post alert
	PublishTips *PublishTips `thrift:"publish_tips,7,optional" form:"publish_tips" json:"publish_tips,omitempty" query:"publish_tips"`
}

func NewPublishConnectorListResponse() *PublishConnectorListResponse {
	return &PublishConnectorListResponse{}
}

func (p *PublishConnectorListResponse) InitDefault() {
}

func (p *PublishConnectorListResponse) GetCode() (v int64) {
	return p.Code
}

func (p *PublishConnectorListResponse) GetMsg() (v string) {
	return p.Msg
}

func (p *PublishConnectorListResponse) GetPublishConnectorList() (v []*PublishConnectorInfo) {
	return p.PublishConnectorList
}

var PublishConnectorListResponse_SubmitBotMarketOption_DEFAULT *SubmitBotMarketOption

func (p *PublishConnectorListResponse) GetSubmitBotMarketOption() (v *SubmitBotMarketOption) {
	if !p.IsSetSubmitBotMarketOption() {
		return PublishConnectorListResponse_SubmitBotMarketOption_DEFAULT
	}
	return p.SubmitBotMarketOption
}

var PublishConnectorListResponse_LastSubmitConfig_DEFAULT *SubmitBotMarketConfig

func (p *PublishConnectorListResponse) GetLastSubmitConfig() (v *SubmitBotMarketConfig) {
	if !p.IsSetLastSubmitConfig() {
		return PublishConnectorListResponse_LastSubmitConfig_DEFAULT
	}
	return p.LastSubmitConfig
}

func (p *PublishConnectorListResponse) GetConnectorBrandInfoMap() (v map[int64]*ConnectorBrandInfo) {
	return p.ConnectorBrandInfoMap
}

var PublishConnectorListResponse_PublishTips_DEFAULT *PublishTips

func (p *PublishConnectorListResponse) GetPublishTips() (v *PublishTips) {
	if !p.IsSetPublishTips() {
		return PublishConnectorListResponse_PublishTips_DEFAULT
	}
	return p.PublishTips
}

var fieldIDToName_PublishConnectorListResponse = map[int16]string{
	1: "code",
	2: "msg",
	3: "publish_connector_list",
	4: "submit_bot_market_option",
	5: "last_submit_config",
	6: "connector_brand_info_map",
	7: "publish_tips",
}

func (p *PublishConnectorListResponse) IsSetSubmitBotMarketOption() bool {
	return p.SubmitBotMarketOption != nil
}

func (p *PublishConnectorListResponse) IsSetLastSubmitConfig() bool {
	return p.LastSubmitConfig != nil
}

func (p *PublishConnectorListResponse) IsSetPublishTips() bool {
	return p.PublishTips != nil
}

func (p *PublishConnectorListResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishConnectorListResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublishConnectorListResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *PublishConnectorListResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *PublishConnectorListResponse) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*PublishConnectorInfo, 0, size)
	values := make([]PublishConnectorInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.PublishConnectorList = _field
	return nil
}
func (p *PublishConnectorListResponse) ReadField4(iprot thrift.TProtocol) error {
	_field := NewSubmitBotMarketOption()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.SubmitBotMarketOption = _field
	return nil
}
func (p *PublishConnectorListResponse) ReadField5(iprot thrift.TProtocol) error {
	_field := NewSubmitBotMarketConfig()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.LastSubmitConfig = _field
	return nil
}
func (p *PublishConnectorListResponse) ReadField6(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*ConnectorBrandInfo, size)
	values := make([]ConnectorBrandInfo, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.ConnectorBrandInfoMap = _field
	return nil
}
func (p *PublishConnectorListResponse) ReadField7(iprot thrift.TProtocol) error {
	_field := NewPublishTips()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.PublishTips = _field
	return nil
}

func (p *PublishConnectorListResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishConnectorListResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishConnectorListResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishConnectorListResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishConnectorListResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("publish_connector_list", thrift.LIST, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.PublishConnectorList)); err != nil {
		return err
	}
	for _, v := range p.PublishConnectorList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PublishConnectorListResponse) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubmitBotMarketOption() {
		if err = oprot.WriteFieldBegin("submit_bot_market_option", thrift.STRUCT, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.SubmitBotMarketOption.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PublishConnectorListResponse) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetLastSubmitConfig() {
		if err = oprot.WriteFieldBegin("last_submit_config", thrift.STRUCT, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.LastSubmitConfig.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PublishConnectorListResponse) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connector_brand_info_map", thrift.MAP, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.ConnectorBrandInfoMap)); err != nil {
		return err
	}
	for k, v := range p.ConnectorBrandInfoMap {
		if err := oprot.WriteI64(k); err != nil {
			return err
		}
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PublishConnectorListResponse) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishTips() {
		if err = oprot.WriteFieldBegin("publish_tips", thrift.STRUCT, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.PublishTips.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *PublishConnectorListResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishConnectorListResponse(%+v)", *p)

}

type DeveloperApiService interface {
	GetUploadAuthToken(ctx context.Context, request *GetUploadAuthTokenRequest) (r *GetUploadAuthTokenResponse, err error)

	DeleteDraftBot(ctx context.Context, request *DeleteDraftBotRequest) (r *DeleteDraftBotResponse, err error)

	DuplicateDraftBot(ctx context.Context, request *DuplicateDraftBotRequest) (r *DuplicateDraftBotResponse, err error)

	CheckDraftBotCommit(ctx context.Context, request *CheckDraftBotCommitRequest) (r *CheckDraftBotCommitResponse, err error)

	GetOnboarding(ctx context.Context, request *GetOnboardingRequest) (r *GetOnboardingResponse, err error)

	PublishConnectorList(ctx context.Context, request *PublishConnectorListRequest) (r *PublishConnectorListResponse, err error)

	DraftBotCreate(ctx context.Context, request *DraftBotCreateRequest) (r *DraftBotCreateResponse, err error)

	UpdateDraftBotDisplayInfo(ctx context.Context, request *UpdateDraftBotDisplayInfoRequest) (r *UpdateDraftBotDisplayInfoResponse, err error)

	GetDraftBotDisplayInfo(ctx context.Context, request *GetDraftBotDisplayInfoRequest) (r *GetDraftBotDisplayInfoResponse, err error)

	PublishDraftBot(ctx context.Context, request *PublishDraftBotRequest) (r *PublishDraftBotResponse, err error)

	ListDraftBotHistory(ctx context.Context, request *ListDraftBotHistoryRequest) (r *ListDraftBotHistoryResponse, err error)

	UploadFile(ctx context.Context, request *UploadFileRequest) (r *UploadFileResponse, err error)

	GetTypeList(ctx context.Context, request *GetTypeListRequest) (r *GetTypeListResponse, err error)

	GetIcon(ctx context.Context, request *GetIconRequest) (r *GetIconResponse, err error)

	UpdateUserProfileCheck(ctx context.Context, request *UpdateUserProfileCheckRequest) (r *UpdateUserProfileCheckResponse, err error)
}

type DeveloperApiServiceClient struct {
	c thrift.TClient
}

func NewDeveloperApiServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *DeveloperApiServiceClient {
	return &DeveloperApiServiceClient{
		c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
	}
}

func NewDeveloperApiServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *DeveloperApiServiceClient {
	return &DeveloperApiServiceClient{
		c: thrift.NewTStandardClient(iprot, oprot),
	}
}

func NewDeveloperApiServiceClient(c thrift.TClient) *DeveloperApiServiceClient {
	return &DeveloperApiServiceClient{
		c: c,
	}
}

func (p *DeveloperApiServiceClient) Client_() thrift.TClient {
	return p.c
}

func (p *DeveloperApiServiceClient) GetUploadAuthToken(ctx context.Context, request *GetUploadAuthTokenRequest) (r *GetUploadAuthTokenResponse, err error) {
	var _args DeveloperApiServiceGetUploadAuthTokenArgs
	_args.Request = request
	var _result DeveloperApiServiceGetUploadAuthTokenResult
	if err = p.Client_().Call(ctx, "GetUploadAuthToken", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) DeleteDraftBot(ctx context.Context, request *DeleteDraftBotRequest) (r *DeleteDraftBotResponse, err error) {
	var _args DeveloperApiServiceDeleteDraftBotArgs
	_args.Request = request
	var _result DeveloperApiServiceDeleteDraftBotResult
	if err = p.Client_().Call(ctx, "DeleteDraftBot", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) DuplicateDraftBot(ctx context.Context, request *DuplicateDraftBotRequest) (r *DuplicateDraftBotResponse, err error) {
	var _args DeveloperApiServiceDuplicateDraftBotArgs
	_args.Request = request
	var _result DeveloperApiServiceDuplicateDraftBotResult
	if err = p.Client_().Call(ctx, "DuplicateDraftBot", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) CheckDraftBotCommit(ctx context.Context, request *CheckDraftBotCommitRequest) (r *CheckDraftBotCommitResponse, err error) {
	var _args DeveloperApiServiceCheckDraftBotCommitArgs
	_args.Request = request
	var _result DeveloperApiServiceCheckDraftBotCommitResult
	if err = p.Client_().Call(ctx, "CheckDraftBotCommit", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) GetOnboarding(ctx context.Context, request *GetOnboardingRequest) (r *GetOnboardingResponse, err error) {
	var _args DeveloperApiServiceGetOnboardingArgs
	_args.Request = request
	var _result DeveloperApiServiceGetOnboardingResult
	if err = p.Client_().Call(ctx, "GetOnboarding", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) PublishConnectorList(ctx context.Context, request *PublishConnectorListRequest) (r *PublishConnectorListResponse, err error) {
	var _args DeveloperApiServicePublishConnectorListArgs
	_args.Request = request
	var _result DeveloperApiServicePublishConnectorListResult
	if err = p.Client_().Call(ctx, "PublishConnectorList", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) DraftBotCreate(ctx context.Context, request *DraftBotCreateRequest) (r *DraftBotCreateResponse, err error) {
	var _args DeveloperApiServiceDraftBotCreateArgs
	_args.Request = request
	var _result DeveloperApiServiceDraftBotCreateResult
	if err = p.Client_().Call(ctx, "DraftBotCreate", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) UpdateDraftBotDisplayInfo(ctx context.Context, request *UpdateDraftBotDisplayInfoRequest) (r *UpdateDraftBotDisplayInfoResponse, err error) {
	var _args DeveloperApiServiceUpdateDraftBotDisplayInfoArgs
	_args.Request = request
	var _result DeveloperApiServiceUpdateDraftBotDisplayInfoResult
	if err = p.Client_().Call(ctx, "UpdateDraftBotDisplayInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) GetDraftBotDisplayInfo(ctx context.Context, request *GetDraftBotDisplayInfoRequest) (r *GetDraftBotDisplayInfoResponse, err error) {
	var _args DeveloperApiServiceGetDraftBotDisplayInfoArgs
	_args.Request = request
	var _result DeveloperApiServiceGetDraftBotDisplayInfoResult
	if err = p.Client_().Call(ctx, "GetDraftBotDisplayInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) PublishDraftBot(ctx context.Context, request *PublishDraftBotRequest) (r *PublishDraftBotResponse, err error) {
	var _args DeveloperApiServicePublishDraftBotArgs
	_args.Request = request
	var _result DeveloperApiServicePublishDraftBotResult
	if err = p.Client_().Call(ctx, "PublishDraftBot", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) ListDraftBotHistory(ctx context.Context, request *ListDraftBotHistoryRequest) (r *ListDraftBotHistoryResponse, err error) {
	var _args DeveloperApiServiceListDraftBotHistoryArgs
	_args.Request = request
	var _result DeveloperApiServiceListDraftBotHistoryResult
	if err = p.Client_().Call(ctx, "ListDraftBotHistory", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) UploadFile(ctx context.Context, request *UploadFileRequest) (r *UploadFileResponse, err error) {
	var _args DeveloperApiServiceUploadFileArgs
	_args.Request = request
	var _result DeveloperApiServiceUploadFileResult
	if err = p.Client_().Call(ctx, "UploadFile", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) GetTypeList(ctx context.Context, request *GetTypeListRequest) (r *GetTypeListResponse, err error) {
	var _args DeveloperApiServiceGetTypeListArgs
	_args.Request = request
	var _result DeveloperApiServiceGetTypeListResult
	if err = p.Client_().Call(ctx, "GetTypeList", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) GetIcon(ctx context.Context, request *GetIconRequest) (r *GetIconResponse, err error) {
	var _args DeveloperApiServiceGetIconArgs
	_args.Request = request
	var _result DeveloperApiServiceGetIconResult
	if err = p.Client_().Call(ctx, "GetIcon", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *DeveloperApiServiceClient) UpdateUserProfileCheck(ctx context.Context, request *UpdateUserProfileCheckRequest) (r *UpdateUserProfileCheckResponse, err error) {
	var _args DeveloperApiServiceUpdateUserProfileCheckArgs
	_args.Request = request
	var _result DeveloperApiServiceUpdateUserProfileCheckResult
	if err = p.Client_().Call(ctx, "UpdateUserProfileCheck", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}

type DeveloperApiServiceProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      DeveloperApiService
}

func (p *DeveloperApiServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *DeveloperApiServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *DeveloperApiServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewDeveloperApiServiceProcessor(handler DeveloperApiService) *DeveloperApiServiceProcessor {
	self := &DeveloperApiServiceProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self.AddToProcessorMap("GetUploadAuthToken", &developerApiServiceProcessorGetUploadAuthToken{handler: handler})
	self.AddToProcessorMap("DeleteDraftBot", &developerApiServiceProcessorDeleteDraftBot{handler: handler})
	self.AddToProcessorMap("DuplicateDraftBot", &developerApiServiceProcessorDuplicateDraftBot{handler: handler})
	self.AddToProcessorMap("CheckDraftBotCommit", &developerApiServiceProcessorCheckDraftBotCommit{handler: handler})
	self.AddToProcessorMap("GetOnboarding", &developerApiServiceProcessorGetOnboarding{handler: handler})
	self.AddToProcessorMap("PublishConnectorList", &developerApiServiceProcessorPublishConnectorList{handler: handler})
	self.AddToProcessorMap("DraftBotCreate", &developerApiServiceProcessorDraftBotCreate{handler: handler})
	self.AddToProcessorMap("UpdateDraftBotDisplayInfo", &developerApiServiceProcessorUpdateDraftBotDisplayInfo{handler: handler})
	self.AddToProcessorMap("GetDraftBotDisplayInfo", &developerApiServiceProcessorGetDraftBotDisplayInfo{handler: handler})
	self.AddToProcessorMap("PublishDraftBot", &developerApiServiceProcessorPublishDraftBot{handler: handler})
	self.AddToProcessorMap("ListDraftBotHistory", &developerApiServiceProcessorListDraftBotHistory{handler: handler})
	self.AddToProcessorMap("UploadFile", &developerApiServiceProcessorUploadFile{handler: handler})
	self.AddToProcessorMap("GetTypeList", &developerApiServiceProcessorGetTypeList{handler: handler})
	self.AddToProcessorMap("GetIcon", &developerApiServiceProcessorGetIcon{handler: handler})
	self.AddToProcessorMap("UpdateUserProfileCheck", &developerApiServiceProcessorUpdateUserProfileCheck{handler: handler})
	return self
}
func (p *DeveloperApiServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(ctx, seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush(ctx)
	return false, x
}

type developerApiServiceProcessorGetUploadAuthToken struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorGetUploadAuthToken) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceGetUploadAuthTokenArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetUploadAuthToken", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceGetUploadAuthTokenResult{}
	var retval *GetUploadAuthTokenResponse
	if retval, err2 = p.handler.GetUploadAuthToken(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetUploadAuthToken: "+err2.Error())
		oprot.WriteMessageBegin("GetUploadAuthToken", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetUploadAuthToken", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorDeleteDraftBot struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorDeleteDraftBot) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceDeleteDraftBotArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("DeleteDraftBot", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceDeleteDraftBotResult{}
	var retval *DeleteDraftBotResponse
	if retval, err2 = p.handler.DeleteDraftBot(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing DeleteDraftBot: "+err2.Error())
		oprot.WriteMessageBegin("DeleteDraftBot", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("DeleteDraftBot", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorDuplicateDraftBot struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorDuplicateDraftBot) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceDuplicateDraftBotArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("DuplicateDraftBot", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceDuplicateDraftBotResult{}
	var retval *DuplicateDraftBotResponse
	if retval, err2 = p.handler.DuplicateDraftBot(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing DuplicateDraftBot: "+err2.Error())
		oprot.WriteMessageBegin("DuplicateDraftBot", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("DuplicateDraftBot", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorCheckDraftBotCommit struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorCheckDraftBotCommit) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceCheckDraftBotCommitArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CheckDraftBotCommit", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceCheckDraftBotCommitResult{}
	var retval *CheckDraftBotCommitResponse
	if retval, err2 = p.handler.CheckDraftBotCommit(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CheckDraftBotCommit: "+err2.Error())
		oprot.WriteMessageBegin("CheckDraftBotCommit", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CheckDraftBotCommit", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorGetOnboarding struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorGetOnboarding) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceGetOnboardingArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetOnboarding", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceGetOnboardingResult{}
	var retval *GetOnboardingResponse
	if retval, err2 = p.handler.GetOnboarding(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetOnboarding: "+err2.Error())
		oprot.WriteMessageBegin("GetOnboarding", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetOnboarding", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorPublishConnectorList struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorPublishConnectorList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServicePublishConnectorListArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublishConnectorList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServicePublishConnectorListResult{}
	var retval *PublishConnectorListResponse
	if retval, err2 = p.handler.PublishConnectorList(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublishConnectorList: "+err2.Error())
		oprot.WriteMessageBegin("PublishConnectorList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublishConnectorList", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorDraftBotCreate struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorDraftBotCreate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceDraftBotCreateArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("DraftBotCreate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceDraftBotCreateResult{}
	var retval *DraftBotCreateResponse
	if retval, err2 = p.handler.DraftBotCreate(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing DraftBotCreate: "+err2.Error())
		oprot.WriteMessageBegin("DraftBotCreate", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("DraftBotCreate", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorUpdateDraftBotDisplayInfo struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorUpdateDraftBotDisplayInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceUpdateDraftBotDisplayInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UpdateDraftBotDisplayInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceUpdateDraftBotDisplayInfoResult{}
	var retval *UpdateDraftBotDisplayInfoResponse
	if retval, err2 = p.handler.UpdateDraftBotDisplayInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UpdateDraftBotDisplayInfo: "+err2.Error())
		oprot.WriteMessageBegin("UpdateDraftBotDisplayInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UpdateDraftBotDisplayInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorGetDraftBotDisplayInfo struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorGetDraftBotDisplayInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceGetDraftBotDisplayInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetDraftBotDisplayInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceGetDraftBotDisplayInfoResult{}
	var retval *GetDraftBotDisplayInfoResponse
	if retval, err2 = p.handler.GetDraftBotDisplayInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetDraftBotDisplayInfo: "+err2.Error())
		oprot.WriteMessageBegin("GetDraftBotDisplayInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetDraftBotDisplayInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorPublishDraftBot struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorPublishDraftBot) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServicePublishDraftBotArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublishDraftBot", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServicePublishDraftBotResult{}
	var retval *PublishDraftBotResponse
	if retval, err2 = p.handler.PublishDraftBot(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublishDraftBot: "+err2.Error())
		oprot.WriteMessageBegin("PublishDraftBot", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublishDraftBot", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorListDraftBotHistory struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorListDraftBotHistory) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceListDraftBotHistoryArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("ListDraftBotHistory", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceListDraftBotHistoryResult{}
	var retval *ListDraftBotHistoryResponse
	if retval, err2 = p.handler.ListDraftBotHistory(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ListDraftBotHistory: "+err2.Error())
		oprot.WriteMessageBegin("ListDraftBotHistory", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("ListDraftBotHistory", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorUploadFile struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorUploadFile) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceUploadFileArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UploadFile", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceUploadFileResult{}
	var retval *UploadFileResponse
	if retval, err2 = p.handler.UploadFile(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UploadFile: "+err2.Error())
		oprot.WriteMessageBegin("UploadFile", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UploadFile", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorGetTypeList struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorGetTypeList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceGetTypeListArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetTypeList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceGetTypeListResult{}
	var retval *GetTypeListResponse
	if retval, err2 = p.handler.GetTypeList(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetTypeList: "+err2.Error())
		oprot.WriteMessageBegin("GetTypeList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetTypeList", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorGetIcon struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorGetIcon) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceGetIconArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetIcon", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceGetIconResult{}
	var retval *GetIconResponse
	if retval, err2 = p.handler.GetIcon(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetIcon: "+err2.Error())
		oprot.WriteMessageBegin("GetIcon", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetIcon", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type developerApiServiceProcessorUpdateUserProfileCheck struct {
	handler DeveloperApiService
}

func (p *developerApiServiceProcessorUpdateUserProfileCheck) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := DeveloperApiServiceUpdateUserProfileCheckArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UpdateUserProfileCheck", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := DeveloperApiServiceUpdateUserProfileCheckResult{}
	var retval *UpdateUserProfileCheckResponse
	if retval, err2 = p.handler.UpdateUserProfileCheck(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UpdateUserProfileCheck: "+err2.Error())
		oprot.WriteMessageBegin("UpdateUserProfileCheck", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UpdateUserProfileCheck", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type DeveloperApiServiceGetUploadAuthTokenArgs struct {
	Request *GetUploadAuthTokenRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceGetUploadAuthTokenArgs() *DeveloperApiServiceGetUploadAuthTokenArgs {
	return &DeveloperApiServiceGetUploadAuthTokenArgs{}
}

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) InitDefault() {
}

var DeveloperApiServiceGetUploadAuthTokenArgs_Request_DEFAULT *GetUploadAuthTokenRequest

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) GetRequest() (v *GetUploadAuthTokenRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceGetUploadAuthTokenArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceGetUploadAuthTokenArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetUploadAuthTokenArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetUploadAuthTokenRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUploadAuthToken_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceGetUploadAuthTokenArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetUploadAuthTokenArgs(%+v)", *p)

}

type DeveloperApiServiceGetUploadAuthTokenResult struct {
	Success *GetUploadAuthTokenResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceGetUploadAuthTokenResult() *DeveloperApiServiceGetUploadAuthTokenResult {
	return &DeveloperApiServiceGetUploadAuthTokenResult{}
}

func (p *DeveloperApiServiceGetUploadAuthTokenResult) InitDefault() {
}

var DeveloperApiServiceGetUploadAuthTokenResult_Success_DEFAULT *GetUploadAuthTokenResponse

func (p *DeveloperApiServiceGetUploadAuthTokenResult) GetSuccess() (v *GetUploadAuthTokenResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceGetUploadAuthTokenResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceGetUploadAuthTokenResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceGetUploadAuthTokenResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceGetUploadAuthTokenResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetUploadAuthTokenResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetUploadAuthTokenResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetUploadAuthTokenResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceGetUploadAuthTokenResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetUploadAuthToken_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetUploadAuthTokenResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceGetUploadAuthTokenResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetUploadAuthTokenResult(%+v)", *p)

}

type DeveloperApiServiceDeleteDraftBotArgs struct {
	Request *DeleteDraftBotRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceDeleteDraftBotArgs() *DeveloperApiServiceDeleteDraftBotArgs {
	return &DeveloperApiServiceDeleteDraftBotArgs{}
}

func (p *DeveloperApiServiceDeleteDraftBotArgs) InitDefault() {
}

var DeveloperApiServiceDeleteDraftBotArgs_Request_DEFAULT *DeleteDraftBotRequest

func (p *DeveloperApiServiceDeleteDraftBotArgs) GetRequest() (v *DeleteDraftBotRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceDeleteDraftBotArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceDeleteDraftBotArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceDeleteDraftBotArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceDeleteDraftBotArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceDeleteDraftBotArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceDeleteDraftBotArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDeleteDraftBotRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceDeleteDraftBotArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteDraftBot_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceDeleteDraftBotArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceDeleteDraftBotArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceDeleteDraftBotArgs(%+v)", *p)

}

type DeveloperApiServiceDeleteDraftBotResult struct {
	Success *DeleteDraftBotResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceDeleteDraftBotResult() *DeveloperApiServiceDeleteDraftBotResult {
	return &DeveloperApiServiceDeleteDraftBotResult{}
}

func (p *DeveloperApiServiceDeleteDraftBotResult) InitDefault() {
}

var DeveloperApiServiceDeleteDraftBotResult_Success_DEFAULT *DeleteDraftBotResponse

func (p *DeveloperApiServiceDeleteDraftBotResult) GetSuccess() (v *DeleteDraftBotResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceDeleteDraftBotResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceDeleteDraftBotResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceDeleteDraftBotResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceDeleteDraftBotResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceDeleteDraftBotResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceDeleteDraftBotResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDeleteDraftBotResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceDeleteDraftBotResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteDraftBot_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceDeleteDraftBotResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceDeleteDraftBotResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceDeleteDraftBotResult(%+v)", *p)

}

type DeveloperApiServiceDuplicateDraftBotArgs struct {
	Request *DuplicateDraftBotRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceDuplicateDraftBotArgs() *DeveloperApiServiceDuplicateDraftBotArgs {
	return &DeveloperApiServiceDuplicateDraftBotArgs{}
}

func (p *DeveloperApiServiceDuplicateDraftBotArgs) InitDefault() {
}

var DeveloperApiServiceDuplicateDraftBotArgs_Request_DEFAULT *DuplicateDraftBotRequest

func (p *DeveloperApiServiceDuplicateDraftBotArgs) GetRequest() (v *DuplicateDraftBotRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceDuplicateDraftBotArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceDuplicateDraftBotArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceDuplicateDraftBotArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceDuplicateDraftBotArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceDuplicateDraftBotArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceDuplicateDraftBotArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDuplicateDraftBotRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceDuplicateDraftBotArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateDraftBot_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceDuplicateDraftBotArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceDuplicateDraftBotArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceDuplicateDraftBotArgs(%+v)", *p)

}

type DeveloperApiServiceDuplicateDraftBotResult struct {
	Success *DuplicateDraftBotResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceDuplicateDraftBotResult() *DeveloperApiServiceDuplicateDraftBotResult {
	return &DeveloperApiServiceDuplicateDraftBotResult{}
}

func (p *DeveloperApiServiceDuplicateDraftBotResult) InitDefault() {
}

var DeveloperApiServiceDuplicateDraftBotResult_Success_DEFAULT *DuplicateDraftBotResponse

func (p *DeveloperApiServiceDuplicateDraftBotResult) GetSuccess() (v *DuplicateDraftBotResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceDuplicateDraftBotResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceDuplicateDraftBotResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceDuplicateDraftBotResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceDuplicateDraftBotResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceDuplicateDraftBotResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceDuplicateDraftBotResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDuplicateDraftBotResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceDuplicateDraftBotResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DuplicateDraftBot_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceDuplicateDraftBotResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceDuplicateDraftBotResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceDuplicateDraftBotResult(%+v)", *p)

}

type DeveloperApiServiceCheckDraftBotCommitArgs struct {
	Request *CheckDraftBotCommitRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceCheckDraftBotCommitArgs() *DeveloperApiServiceCheckDraftBotCommitArgs {
	return &DeveloperApiServiceCheckDraftBotCommitArgs{}
}

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) InitDefault() {
}

var DeveloperApiServiceCheckDraftBotCommitArgs_Request_DEFAULT *CheckDraftBotCommitRequest

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) GetRequest() (v *CheckDraftBotCommitRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceCheckDraftBotCommitArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceCheckDraftBotCommitArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceCheckDraftBotCommitArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCheckDraftBotCommitRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CheckDraftBotCommit_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceCheckDraftBotCommitArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceCheckDraftBotCommitArgs(%+v)", *p)

}

type DeveloperApiServiceCheckDraftBotCommitResult struct {
	Success *CheckDraftBotCommitResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceCheckDraftBotCommitResult() *DeveloperApiServiceCheckDraftBotCommitResult {
	return &DeveloperApiServiceCheckDraftBotCommitResult{}
}

func (p *DeveloperApiServiceCheckDraftBotCommitResult) InitDefault() {
}

var DeveloperApiServiceCheckDraftBotCommitResult_Success_DEFAULT *CheckDraftBotCommitResponse

func (p *DeveloperApiServiceCheckDraftBotCommitResult) GetSuccess() (v *CheckDraftBotCommitResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceCheckDraftBotCommitResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceCheckDraftBotCommitResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceCheckDraftBotCommitResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceCheckDraftBotCommitResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceCheckDraftBotCommitResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceCheckDraftBotCommitResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCheckDraftBotCommitResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceCheckDraftBotCommitResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CheckDraftBotCommit_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceCheckDraftBotCommitResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceCheckDraftBotCommitResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceCheckDraftBotCommitResult(%+v)", *p)

}

type DeveloperApiServiceGetOnboardingArgs struct {
	Request *GetOnboardingRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceGetOnboardingArgs() *DeveloperApiServiceGetOnboardingArgs {
	return &DeveloperApiServiceGetOnboardingArgs{}
}

func (p *DeveloperApiServiceGetOnboardingArgs) InitDefault() {
}

var DeveloperApiServiceGetOnboardingArgs_Request_DEFAULT *GetOnboardingRequest

func (p *DeveloperApiServiceGetOnboardingArgs) GetRequest() (v *GetOnboardingRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceGetOnboardingArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceGetOnboardingArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceGetOnboardingArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceGetOnboardingArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetOnboardingArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetOnboardingArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetOnboardingRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceGetOnboardingArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetOnboarding_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetOnboardingArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceGetOnboardingArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetOnboardingArgs(%+v)", *p)

}

type DeveloperApiServiceGetOnboardingResult struct {
	Success *GetOnboardingResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceGetOnboardingResult() *DeveloperApiServiceGetOnboardingResult {
	return &DeveloperApiServiceGetOnboardingResult{}
}

func (p *DeveloperApiServiceGetOnboardingResult) InitDefault() {
}

var DeveloperApiServiceGetOnboardingResult_Success_DEFAULT *GetOnboardingResponse

func (p *DeveloperApiServiceGetOnboardingResult) GetSuccess() (v *GetOnboardingResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceGetOnboardingResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceGetOnboardingResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceGetOnboardingResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceGetOnboardingResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetOnboardingResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetOnboardingResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetOnboardingResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceGetOnboardingResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetOnboarding_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetOnboardingResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceGetOnboardingResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetOnboardingResult(%+v)", *p)

}

type DeveloperApiServicePublishConnectorListArgs struct {
	Request *PublishConnectorListRequest `thrift:"request,1"`
}

func NewDeveloperApiServicePublishConnectorListArgs() *DeveloperApiServicePublishConnectorListArgs {
	return &DeveloperApiServicePublishConnectorListArgs{}
}

func (p *DeveloperApiServicePublishConnectorListArgs) InitDefault() {
}

var DeveloperApiServicePublishConnectorListArgs_Request_DEFAULT *PublishConnectorListRequest

func (p *DeveloperApiServicePublishConnectorListArgs) GetRequest() (v *PublishConnectorListRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServicePublishConnectorListArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServicePublishConnectorListArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServicePublishConnectorListArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServicePublishConnectorListArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServicePublishConnectorListArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishConnectorListArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewPublishConnectorListRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServicePublishConnectorListArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishConnectorList_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishConnectorListArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServicePublishConnectorListArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServicePublishConnectorListArgs(%+v)", *p)

}

type DeveloperApiServicePublishConnectorListResult struct {
	Success *PublishConnectorListResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServicePublishConnectorListResult() *DeveloperApiServicePublishConnectorListResult {
	return &DeveloperApiServicePublishConnectorListResult{}
}

func (p *DeveloperApiServicePublishConnectorListResult) InitDefault() {
}

var DeveloperApiServicePublishConnectorListResult_Success_DEFAULT *PublishConnectorListResponse

func (p *DeveloperApiServicePublishConnectorListResult) GetSuccess() (v *PublishConnectorListResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServicePublishConnectorListResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServicePublishConnectorListResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServicePublishConnectorListResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServicePublishConnectorListResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServicePublishConnectorListResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishConnectorListResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewPublishConnectorListResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServicePublishConnectorListResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishConnectorList_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishConnectorListResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServicePublishConnectorListResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServicePublishConnectorListResult(%+v)", *p)

}

type DeveloperApiServiceDraftBotCreateArgs struct {
	Request *DraftBotCreateRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceDraftBotCreateArgs() *DeveloperApiServiceDraftBotCreateArgs {
	return &DeveloperApiServiceDraftBotCreateArgs{}
}

func (p *DeveloperApiServiceDraftBotCreateArgs) InitDefault() {
}

var DeveloperApiServiceDraftBotCreateArgs_Request_DEFAULT *DraftBotCreateRequest

func (p *DeveloperApiServiceDraftBotCreateArgs) GetRequest() (v *DraftBotCreateRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceDraftBotCreateArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceDraftBotCreateArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceDraftBotCreateArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceDraftBotCreateArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceDraftBotCreateArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceDraftBotCreateArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDraftBotCreateRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceDraftBotCreateArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DraftBotCreate_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceDraftBotCreateArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceDraftBotCreateArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceDraftBotCreateArgs(%+v)", *p)

}

type DeveloperApiServiceDraftBotCreateResult struct {
	Success *DraftBotCreateResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceDraftBotCreateResult() *DeveloperApiServiceDraftBotCreateResult {
	return &DeveloperApiServiceDraftBotCreateResult{}
}

func (p *DeveloperApiServiceDraftBotCreateResult) InitDefault() {
}

var DeveloperApiServiceDraftBotCreateResult_Success_DEFAULT *DraftBotCreateResponse

func (p *DeveloperApiServiceDraftBotCreateResult) GetSuccess() (v *DraftBotCreateResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceDraftBotCreateResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceDraftBotCreateResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceDraftBotCreateResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceDraftBotCreateResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceDraftBotCreateResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceDraftBotCreateResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDraftBotCreateResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceDraftBotCreateResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DraftBotCreate_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceDraftBotCreateResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceDraftBotCreateResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceDraftBotCreateResult(%+v)", *p)

}

type DeveloperApiServiceUpdateDraftBotDisplayInfoArgs struct {
	Request *UpdateDraftBotDisplayInfoRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceUpdateDraftBotDisplayInfoArgs() *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs {
	return &DeveloperApiServiceUpdateDraftBotDisplayInfoArgs{}
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) InitDefault() {
}

var DeveloperApiServiceUpdateDraftBotDisplayInfoArgs_Request_DEFAULT *UpdateDraftBotDisplayInfoRequest

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) GetRequest() (v *UpdateDraftBotDisplayInfoRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceUpdateDraftBotDisplayInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceUpdateDraftBotDisplayInfoArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceUpdateDraftBotDisplayInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpdateDraftBotDisplayInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotDisplayInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceUpdateDraftBotDisplayInfoArgs(%+v)", *p)

}

type DeveloperApiServiceUpdateDraftBotDisplayInfoResult struct {
	Success *UpdateDraftBotDisplayInfoResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceUpdateDraftBotDisplayInfoResult() *DeveloperApiServiceUpdateDraftBotDisplayInfoResult {
	return &DeveloperApiServiceUpdateDraftBotDisplayInfoResult{}
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) InitDefault() {
}

var DeveloperApiServiceUpdateDraftBotDisplayInfoResult_Success_DEFAULT *UpdateDraftBotDisplayInfoResponse

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) GetSuccess() (v *UpdateDraftBotDisplayInfoResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceUpdateDraftBotDisplayInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceUpdateDraftBotDisplayInfoResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceUpdateDraftBotDisplayInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUpdateDraftBotDisplayInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotDisplayInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateDraftBotDisplayInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceUpdateDraftBotDisplayInfoResult(%+v)", *p)

}

type DeveloperApiServiceGetDraftBotDisplayInfoArgs struct {
	Request *GetDraftBotDisplayInfoRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceGetDraftBotDisplayInfoArgs() *DeveloperApiServiceGetDraftBotDisplayInfoArgs {
	return &DeveloperApiServiceGetDraftBotDisplayInfoArgs{}
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) InitDefault() {
}

var DeveloperApiServiceGetDraftBotDisplayInfoArgs_Request_DEFAULT *GetDraftBotDisplayInfoRequest

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) GetRequest() (v *GetDraftBotDisplayInfoRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceGetDraftBotDisplayInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceGetDraftBotDisplayInfoArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetDraftBotDisplayInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetDraftBotDisplayInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotDisplayInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetDraftBotDisplayInfoArgs(%+v)", *p)

}

type DeveloperApiServiceGetDraftBotDisplayInfoResult struct {
	Success *GetDraftBotDisplayInfoResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceGetDraftBotDisplayInfoResult() *DeveloperApiServiceGetDraftBotDisplayInfoResult {
	return &DeveloperApiServiceGetDraftBotDisplayInfoResult{}
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) InitDefault() {
}

var DeveloperApiServiceGetDraftBotDisplayInfoResult_Success_DEFAULT *GetDraftBotDisplayInfoResponse

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) GetSuccess() (v *GetDraftBotDisplayInfoResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceGetDraftBotDisplayInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceGetDraftBotDisplayInfoResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetDraftBotDisplayInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetDraftBotDisplayInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotDisplayInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceGetDraftBotDisplayInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetDraftBotDisplayInfoResult(%+v)", *p)

}

type DeveloperApiServicePublishDraftBotArgs struct {
	Request *PublishDraftBotRequest `thrift:"request,1"`
}

func NewDeveloperApiServicePublishDraftBotArgs() *DeveloperApiServicePublishDraftBotArgs {
	return &DeveloperApiServicePublishDraftBotArgs{}
}

func (p *DeveloperApiServicePublishDraftBotArgs) InitDefault() {
}

var DeveloperApiServicePublishDraftBotArgs_Request_DEFAULT *PublishDraftBotRequest

func (p *DeveloperApiServicePublishDraftBotArgs) GetRequest() (v *PublishDraftBotRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServicePublishDraftBotArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServicePublishDraftBotArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServicePublishDraftBotArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServicePublishDraftBotArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServicePublishDraftBotArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishDraftBotArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewPublishDraftBotRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServicePublishDraftBotArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishDraftBot_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishDraftBotArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServicePublishDraftBotArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServicePublishDraftBotArgs(%+v)", *p)

}

type DeveloperApiServicePublishDraftBotResult struct {
	Success *PublishDraftBotResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServicePublishDraftBotResult() *DeveloperApiServicePublishDraftBotResult {
	return &DeveloperApiServicePublishDraftBotResult{}
}

func (p *DeveloperApiServicePublishDraftBotResult) InitDefault() {
}

var DeveloperApiServicePublishDraftBotResult_Success_DEFAULT *PublishDraftBotResponse

func (p *DeveloperApiServicePublishDraftBotResult) GetSuccess() (v *PublishDraftBotResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServicePublishDraftBotResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServicePublishDraftBotResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServicePublishDraftBotResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServicePublishDraftBotResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServicePublishDraftBotResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishDraftBotResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewPublishDraftBotResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServicePublishDraftBotResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishDraftBot_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServicePublishDraftBotResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServicePublishDraftBotResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServicePublishDraftBotResult(%+v)", *p)

}

type DeveloperApiServiceListDraftBotHistoryArgs struct {
	Request *ListDraftBotHistoryRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceListDraftBotHistoryArgs() *DeveloperApiServiceListDraftBotHistoryArgs {
	return &DeveloperApiServiceListDraftBotHistoryArgs{}
}

func (p *DeveloperApiServiceListDraftBotHistoryArgs) InitDefault() {
}

var DeveloperApiServiceListDraftBotHistoryArgs_Request_DEFAULT *ListDraftBotHistoryRequest

func (p *DeveloperApiServiceListDraftBotHistoryArgs) GetRequest() (v *ListDraftBotHistoryRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceListDraftBotHistoryArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceListDraftBotHistoryArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceListDraftBotHistoryArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceListDraftBotHistoryArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceListDraftBotHistoryArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceListDraftBotHistoryArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewListDraftBotHistoryRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceListDraftBotHistoryArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListDraftBotHistory_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceListDraftBotHistoryArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceListDraftBotHistoryArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceListDraftBotHistoryArgs(%+v)", *p)

}

type DeveloperApiServiceListDraftBotHistoryResult struct {
	Success *ListDraftBotHistoryResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceListDraftBotHistoryResult() *DeveloperApiServiceListDraftBotHistoryResult {
	return &DeveloperApiServiceListDraftBotHistoryResult{}
}

func (p *DeveloperApiServiceListDraftBotHistoryResult) InitDefault() {
}

var DeveloperApiServiceListDraftBotHistoryResult_Success_DEFAULT *ListDraftBotHistoryResponse

func (p *DeveloperApiServiceListDraftBotHistoryResult) GetSuccess() (v *ListDraftBotHistoryResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceListDraftBotHistoryResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceListDraftBotHistoryResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceListDraftBotHistoryResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceListDraftBotHistoryResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceListDraftBotHistoryResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceListDraftBotHistoryResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewListDraftBotHistoryResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceListDraftBotHistoryResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListDraftBotHistory_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceListDraftBotHistoryResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceListDraftBotHistoryResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceListDraftBotHistoryResult(%+v)", *p)

}

type DeveloperApiServiceUploadFileArgs struct {
	Request *UploadFileRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceUploadFileArgs() *DeveloperApiServiceUploadFileArgs {
	return &DeveloperApiServiceUploadFileArgs{}
}

func (p *DeveloperApiServiceUploadFileArgs) InitDefault() {
}

var DeveloperApiServiceUploadFileArgs_Request_DEFAULT *UploadFileRequest

func (p *DeveloperApiServiceUploadFileArgs) GetRequest() (v *UploadFileRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceUploadFileArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceUploadFileArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceUploadFileArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceUploadFileArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceUploadFileArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceUploadFileArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUploadFileRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceUploadFileArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFile_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceUploadFileArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceUploadFileArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceUploadFileArgs(%+v)", *p)

}

type DeveloperApiServiceUploadFileResult struct {
	Success *UploadFileResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceUploadFileResult() *DeveloperApiServiceUploadFileResult {
	return &DeveloperApiServiceUploadFileResult{}
}

func (p *DeveloperApiServiceUploadFileResult) InitDefault() {
}

var DeveloperApiServiceUploadFileResult_Success_DEFAULT *UploadFileResponse

func (p *DeveloperApiServiceUploadFileResult) GetSuccess() (v *UploadFileResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceUploadFileResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceUploadFileResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceUploadFileResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceUploadFileResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceUploadFileResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceUploadFileResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUploadFileResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceUploadFileResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFile_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceUploadFileResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceUploadFileResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceUploadFileResult(%+v)", *p)

}

type DeveloperApiServiceGetTypeListArgs struct {
	Request *GetTypeListRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceGetTypeListArgs() *DeveloperApiServiceGetTypeListArgs {
	return &DeveloperApiServiceGetTypeListArgs{}
}

func (p *DeveloperApiServiceGetTypeListArgs) InitDefault() {
}

var DeveloperApiServiceGetTypeListArgs_Request_DEFAULT *GetTypeListRequest

func (p *DeveloperApiServiceGetTypeListArgs) GetRequest() (v *GetTypeListRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceGetTypeListArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceGetTypeListArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceGetTypeListArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceGetTypeListArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetTypeListArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetTypeListArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetTypeListRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceGetTypeListArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetTypeList_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetTypeListArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceGetTypeListArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetTypeListArgs(%+v)", *p)

}

type DeveloperApiServiceGetTypeListResult struct {
	Success *GetTypeListResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceGetTypeListResult() *DeveloperApiServiceGetTypeListResult {
	return &DeveloperApiServiceGetTypeListResult{}
}

func (p *DeveloperApiServiceGetTypeListResult) InitDefault() {
}

var DeveloperApiServiceGetTypeListResult_Success_DEFAULT *GetTypeListResponse

func (p *DeveloperApiServiceGetTypeListResult) GetSuccess() (v *GetTypeListResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceGetTypeListResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceGetTypeListResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceGetTypeListResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceGetTypeListResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetTypeListResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetTypeListResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetTypeListResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceGetTypeListResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetTypeList_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetTypeListResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceGetTypeListResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetTypeListResult(%+v)", *p)

}

type DeveloperApiServiceGetIconArgs struct {
	Request *GetIconRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceGetIconArgs() *DeveloperApiServiceGetIconArgs {
	return &DeveloperApiServiceGetIconArgs{}
}

func (p *DeveloperApiServiceGetIconArgs) InitDefault() {
}

var DeveloperApiServiceGetIconArgs_Request_DEFAULT *GetIconRequest

func (p *DeveloperApiServiceGetIconArgs) GetRequest() (v *GetIconRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceGetIconArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceGetIconArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceGetIconArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceGetIconArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetIconArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetIconArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetIconRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceGetIconArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetIcon_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetIconArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceGetIconArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetIconArgs(%+v)", *p)

}

type DeveloperApiServiceGetIconResult struct {
	Success *GetIconResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceGetIconResult() *DeveloperApiServiceGetIconResult {
	return &DeveloperApiServiceGetIconResult{}
}

func (p *DeveloperApiServiceGetIconResult) InitDefault() {
}

var DeveloperApiServiceGetIconResult_Success_DEFAULT *GetIconResponse

func (p *DeveloperApiServiceGetIconResult) GetSuccess() (v *GetIconResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceGetIconResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceGetIconResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceGetIconResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceGetIconResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceGetIconResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetIconResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetIconResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceGetIconResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetIcon_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceGetIconResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceGetIconResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceGetIconResult(%+v)", *p)

}

type DeveloperApiServiceUpdateUserProfileCheckArgs struct {
	Request *UpdateUserProfileCheckRequest `thrift:"request,1"`
}

func NewDeveloperApiServiceUpdateUserProfileCheckArgs() *DeveloperApiServiceUpdateUserProfileCheckArgs {
	return &DeveloperApiServiceUpdateUserProfileCheckArgs{}
}

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) InitDefault() {
}

var DeveloperApiServiceUpdateUserProfileCheckArgs_Request_DEFAULT *UpdateUserProfileCheckRequest

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) GetRequest() (v *UpdateUserProfileCheckRequest) {
	if !p.IsSetRequest() {
		return DeveloperApiServiceUpdateUserProfileCheckArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_DeveloperApiServiceUpdateUserProfileCheckArgs = map[int16]string{
	1: "request",
}

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceUpdateUserProfileCheckArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpdateUserProfileCheckRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateUserProfileCheck_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateUserProfileCheckArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceUpdateUserProfileCheckArgs(%+v)", *p)

}

type DeveloperApiServiceUpdateUserProfileCheckResult struct {
	Success *UpdateUserProfileCheckResponse `thrift:"success,0,optional"`
}

func NewDeveloperApiServiceUpdateUserProfileCheckResult() *DeveloperApiServiceUpdateUserProfileCheckResult {
	return &DeveloperApiServiceUpdateUserProfileCheckResult{}
}

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) InitDefault() {
}

var DeveloperApiServiceUpdateUserProfileCheckResult_Success_DEFAULT *UpdateUserProfileCheckResponse

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) GetSuccess() (v *UpdateUserProfileCheckResponse) {
	if !p.IsSetSuccess() {
		return DeveloperApiServiceUpdateUserProfileCheckResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_DeveloperApiServiceUpdateUserProfileCheckResult = map[int16]string{
	0: "success",
}

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeveloperApiServiceUpdateUserProfileCheckResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUpdateUserProfileCheckResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateUserProfileCheck_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *DeveloperApiServiceUpdateUserProfileCheckResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeveloperApiServiceUpdateUserProfileCheckResult(%+v)", *p)

}
