// Code generated by thriftgo (0.4.1). DO NOT EDIT.

package playground

import (
	"context"
	"database/sql"
	"database/sql/driver"
	"fmt"
	"github.com/apache/thrift/lib/go/thrift"
	"github.com/coze-dev/coze-studio/backend/api/model/base"
	"github.com/coze-dev/coze-studio/backend/api/model/ocean/cloud/bot_common"
)

// branch
type Branch int64

const (
	Branch_Undefined Branch = 0
	// draft
	Branch_PersonalDraft Branch = 1
	// Space draft
	Branch_Base Branch = 2
	// Online version, used in diff scenarios
	Branch_Publish Branch = 3
)

func (p Branch) String() string {
	switch p {
	case Branch_Undefined:
		return "Undefined"
	case Branch_PersonalDraft:
		return "PersonalDraft"
	case Branch_Base:
		return "Base"
	case Branch_Publish:
		return "Publish"
	}
	return "<UNSET>"
}

func BranchFromString(s string) (Branch, error) {
	switch s {
	case "Undefined":
		return Branch_Undefined, nil
	case "PersonalDraft":
		return Branch_PersonalDraft, nil
	case "Base":
		return Branch_Base, nil
	case "Publish":
		return Branch_Publish, nil
	}
	return Branch(0), fmt.Errorf("not a valid Branch string")
}

func BranchPtr(v Branch) *Branch { return &v }
func (p *Branch) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = Branch(result.Int64)
	return
}

func (p *Branch) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type DataSetType int64

const (
	// Text
	DataSetType_Text DataSetType = 0
	// table
	DataSetType_Table DataSetType = 1
	// image
	DataSetType_Image DataSetType = 2
)

func (p DataSetType) String() string {
	switch p {
	case DataSetType_Text:
		return "Text"
	case DataSetType_Table:
		return "Table"
	case DataSetType_Image:
		return "Image"
	}
	return "<UNSET>"
}

func DataSetTypeFromString(s string) (DataSetType, error) {
	switch s {
	case "Text":
		return DataSetType_Text, nil
	case "Table":
		return DataSetType_Table, nil
	case "Image":
		return DataSetType_Image, nil
	}
	return DataSetType(0), fmt.Errorf("not a valid DataSetType string")
}

func DataSetTypePtr(v DataSetType) *DataSetType { return &v }
func (p *DataSetType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = DataSetType(result.Int64)
	return
}

func (p *DataSetType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BotMarketStatus int64

const (
	// offline
	BotMarketStatus_Offline BotMarketStatus = 0
	// put on the shelves
	BotMarketStatus_Online BotMarketStatus = 1
)

func (p BotMarketStatus) String() string {
	switch p {
	case BotMarketStatus_Offline:
		return "Offline"
	case BotMarketStatus_Online:
		return "Online"
	}
	return "<UNSET>"
}

func BotMarketStatusFromString(s string) (BotMarketStatus, error) {
	switch s {
	case "Offline":
		return BotMarketStatus_Offline, nil
	case "Online":
		return BotMarketStatus_Online, nil
	}
	return BotMarketStatus(0), fmt.Errorf("not a valid BotMarketStatus string")
}

func BotMarketStatusPtr(v BotMarketStatus) *BotMarketStatus { return &v }
func (p *BotMarketStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BotMarketStatus(result.Int64)
	return
}

func (p *BotMarketStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ConnectorDynamicStatus int64

const (
	ConnectorDynamicStatus_Normal          ConnectorDynamicStatus = 0
	ConnectorDynamicStatus_Offline         ConnectorDynamicStatus = 1
	ConnectorDynamicStatus_TokenDisconnect ConnectorDynamicStatus = 2
)

func (p ConnectorDynamicStatus) String() string {
	switch p {
	case ConnectorDynamicStatus_Normal:
		return "Normal"
	case ConnectorDynamicStatus_Offline:
		return "Offline"
	case ConnectorDynamicStatus_TokenDisconnect:
		return "TokenDisconnect"
	}
	return "<UNSET>"
}

func ConnectorDynamicStatusFromString(s string) (ConnectorDynamicStatus, error) {
	switch s {
	case "Normal":
		return ConnectorDynamicStatus_Normal, nil
	case "Offline":
		return ConnectorDynamicStatus_Offline, nil
	case "TokenDisconnect":
		return ConnectorDynamicStatus_TokenDisconnect, nil
	}
	return ConnectorDynamicStatus(0), fmt.Errorf("not a valid ConnectorDynamicStatus string")
}

func ConnectorDynamicStatusPtr(v ConnectorDynamicStatus) *ConnectorDynamicStatus { return &v }
func (p *ConnectorDynamicStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ConnectorDynamicStatus(result.Int64)
	return
}

func (p *ConnectorDynamicStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type AuditStatus int64

const (
	// Under review.
	AuditStatus_Auditing AuditStatus = 0
	// approved
	AuditStatus_Success AuditStatus = 1
	// audit failed
	AuditStatus_Failed AuditStatus = 2
)

func (p AuditStatus) String() string {
	switch p {
	case AuditStatus_Auditing:
		return "Auditing"
	case AuditStatus_Success:
		return "Success"
	case AuditStatus_Failed:
		return "Failed"
	}
	return "<UNSET>"
}

func AuditStatusFromString(s string) (AuditStatus, error) {
	switch s {
	case "Auditing":
		return AuditStatus_Auditing, nil
	case "Success":
		return AuditStatus_Success, nil
	case "Failed":
		return AuditStatus_Failed, nil
	}
	return AuditStatus(0), fmt.Errorf("not a valid AuditStatus string")
}

func AuditStatusPtr(v AuditStatus) *AuditStatus { return &v }
func (p *AuditStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = AuditStatus(result.Int64)
	return
}

func (p *AuditStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ScopeType int64

const (
	// All under the enterprise (effective under the enterprise)
	ScopeType_All ScopeType = 0
	// I joined (both companies and individuals are valid, no default self is passed on)
	ScopeType_Self ScopeType = 1
)

func (p ScopeType) String() string {
	switch p {
	case ScopeType_All:
		return "All"
	case ScopeType_Self:
		return "Self"
	}
	return "<UNSET>"
}

func ScopeTypeFromString(s string) (ScopeType, error) {
	switch s {
	case "All":
		return ScopeType_All, nil
	case "Self":
		return ScopeType_Self, nil
	}
	return ScopeType(0), fmt.Errorf("not a valid ScopeType string")
}

func ScopeTypePtr(v ScopeType) *ScopeType { return &v }
func (p *ScopeType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ScopeType(result.Int64)
	return
}

func (p *ScopeType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SpaceType int64

const (
	// individual
	SpaceType_Personal SpaceType = 1
	// group
	SpaceType_Team SpaceType = 2
)

func (p SpaceType) String() string {
	switch p {
	case SpaceType_Personal:
		return "Personal"
	case SpaceType_Team:
		return "Team"
	}
	return "<UNSET>"
}

func SpaceTypeFromString(s string) (SpaceType, error) {
	switch s {
	case "Personal":
		return SpaceType_Personal, nil
	case "Team":
		return SpaceType_Team, nil
	}
	return SpaceType(0), fmt.Errorf("not a valid SpaceType string")
}

func SpaceTypePtr(v SpaceType) *SpaceType { return &v }
func (p *SpaceType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SpaceType(result.Int64)
	return
}

func (p *SpaceType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SpaceMode int64

const (
	SpaceMode_Normal  SpaceMode = 0
	SpaceMode_DevMode SpaceMode = 1
)

func (p SpaceMode) String() string {
	switch p {
	case SpaceMode_Normal:
		return "Normal"
	case SpaceMode_DevMode:
		return "DevMode"
	}
	return "<UNSET>"
}

func SpaceModeFromString(s string) (SpaceMode, error) {
	switch s {
	case "Normal":
		return SpaceMode_Normal, nil
	case "DevMode":
		return SpaceMode_DevMode, nil
	}
	return SpaceMode(0), fmt.Errorf("not a valid SpaceMode string")
}

func SpaceModePtr(v SpaceMode) *SpaceMode { return &v }
func (p *SpaceMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SpaceMode(result.Int64)
	return
}

func (p *SpaceMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SpaceTag int64

const (
	// Professional Edition
	SpaceTag_Professional SpaceTag = 1
)

func (p SpaceTag) String() string {
	switch p {
	case SpaceTag_Professional:
		return "Professional"
	}
	return "<UNSET>"
}

func SpaceTagFromString(s string) (SpaceTag, error) {
	switch s {
	case "Professional":
		return SpaceTag_Professional, nil
	}
	return SpaceTag(0), fmt.Errorf("not a valid SpaceTag string")
}

func SpaceTagPtr(v SpaceTag) *SpaceTag { return &v }
func (p *SpaceTag) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SpaceTag(result.Int64)
	return
}

func (p *SpaceTag) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SpaceRoleType int64

const (
	// default
	SpaceRoleType_Default SpaceRoleType = 0
	// owner
	SpaceRoleType_Owner SpaceRoleType = 1
	// administrator
	SpaceRoleType_Admin SpaceRoleType = 2
	// ordinary member
	SpaceRoleType_Member SpaceRoleType = 3
)

func (p SpaceRoleType) String() string {
	switch p {
	case SpaceRoleType_Default:
		return "Default"
	case SpaceRoleType_Owner:
		return "Owner"
	case SpaceRoleType_Admin:
		return "Admin"
	case SpaceRoleType_Member:
		return "Member"
	}
	return "<UNSET>"
}

func SpaceRoleTypeFromString(s string) (SpaceRoleType, error) {
	switch s {
	case "Default":
		return SpaceRoleType_Default, nil
	case "Owner":
		return SpaceRoleType_Owner, nil
	case "Admin":
		return SpaceRoleType_Admin, nil
	case "Member":
		return SpaceRoleType_Member, nil
	}
	return SpaceRoleType(0), fmt.Errorf("not a valid SpaceRoleType string")
}

func SpaceRoleTypePtr(v SpaceRoleType) *SpaceRoleType { return &v }
func (p *SpaceRoleType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SpaceRoleType(result.Int64)
	return
}

func (p *SpaceRoleType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Application management list
type SpaceApplyStatus int64

const (
	// all
	SpaceApplyStatus_All SpaceApplyStatus = 0
	// Joined
	SpaceApplyStatus_Joined SpaceApplyStatus = 1
	// Confirming
	SpaceApplyStatus_Confirming SpaceApplyStatus = 2
	// Rejected
	SpaceApplyStatus_Rejected SpaceApplyStatus = 3
)

func (p SpaceApplyStatus) String() string {
	switch p {
	case SpaceApplyStatus_All:
		return "All"
	case SpaceApplyStatus_Joined:
		return "Joined"
	case SpaceApplyStatus_Confirming:
		return "Confirming"
	case SpaceApplyStatus_Rejected:
		return "Rejected"
	}
	return "<UNSET>"
}

func SpaceApplyStatusFromString(s string) (SpaceApplyStatus, error) {
	switch s {
	case "All":
		return SpaceApplyStatus_All, nil
	case "Joined":
		return SpaceApplyStatus_Joined, nil
	case "Confirming":
		return SpaceApplyStatus_Confirming, nil
	case "Rejected":
		return SpaceApplyStatus_Rejected, nil
	}
	return SpaceApplyStatus(0), fmt.Errorf("not a valid SpaceApplyStatus string")
}

func SpaceApplyStatusPtr(v SpaceApplyStatus) *SpaceApplyStatus { return &v }
func (p *SpaceApplyStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SpaceApplyStatus(result.Int64)
	return
}

func (p *SpaceApplyStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type GetImageScene int64

const (
	GetImageScene_Onboarding      GetImageScene = 0
	GetImageScene_BackgroundImage GetImageScene = 1
)

func (p GetImageScene) String() string {
	switch p {
	case GetImageScene_Onboarding:
		return "Onboarding"
	case GetImageScene_BackgroundImage:
		return "BackgroundImage"
	}
	return "<UNSET>"
}

func GetImageSceneFromString(s string) (GetImageScene, error) {
	switch s {
	case "Onboarding":
		return GetImageScene_Onboarding, nil
	case "BackgroundImage":
		return GetImageScene_BackgroundImage, nil
	}
	return GetImageScene(0), fmt.Errorf("not a valid GetImageScene string")
}

func GetImageScenePtr(v GetImageScene) *GetImageScene { return &v }
func (p *GetImageScene) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = GetImageScene(result.Int64)
	return
}

func (p *GetImageScene) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BotPopupType int64

const (
	BotPopupType_AutoGenBeforePublish BotPopupType = 1
)

func (p BotPopupType) String() string {
	switch p {
	case BotPopupType_AutoGenBeforePublish:
		return "AutoGenBeforePublish"
	}
	return "<UNSET>"
}

func BotPopupTypeFromString(s string) (BotPopupType, error) {
	switch s {
	case "AutoGenBeforePublish":
		return BotPopupType_AutoGenBeforePublish, nil
	}
	return BotPopupType(0), fmt.Errorf("not a valid BotPopupType string")
}

func BotPopupTypePtr(v BotPopupType) *BotPopupType { return &v }
func (p *BotPopupType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BotPopupType(result.Int64)
	return
}

func (p *BotPopupType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SpaceResourceType int64

const (
	SpaceResourceType_DraftBot        SpaceResourceType = 1
	SpaceResourceType_Project         SpaceResourceType = 2
	SpaceResourceType_Space           SpaceResourceType = 3
	SpaceResourceType_DouyinAvatarBot SpaceResourceType = 4
)

func (p SpaceResourceType) String() string {
	switch p {
	case SpaceResourceType_DraftBot:
		return "DraftBot"
	case SpaceResourceType_Project:
		return "Project"
	case SpaceResourceType_Space:
		return "Space"
	case SpaceResourceType_DouyinAvatarBot:
		return "DouyinAvatarBot"
	}
	return "<UNSET>"
}

func SpaceResourceTypeFromString(s string) (SpaceResourceType, error) {
	switch s {
	case "DraftBot":
		return SpaceResourceType_DraftBot, nil
	case "Project":
		return SpaceResourceType_Project, nil
	case "Space":
		return SpaceResourceType_Space, nil
	case "DouyinAvatarBot":
		return SpaceResourceType_DouyinAvatarBot, nil
	}
	return SpaceResourceType(0), fmt.Errorf("not a valid SpaceResourceType string")
}

func SpaceResourceTypePtr(v SpaceResourceType) *SpaceResourceType { return &v }
func (p *SpaceResourceType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SpaceResourceType(result.Int64)
	return
}

func (p *SpaceResourceType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BehaviorType int64

const (
	BehaviorType_Visit BehaviorType = 1
	BehaviorType_Edit  BehaviorType = 2
)

func (p BehaviorType) String() string {
	switch p {
	case BehaviorType_Visit:
		return "Visit"
	case BehaviorType_Edit:
		return "Edit"
	}
	return "<UNSET>"
}

func BehaviorTypeFromString(s string) (BehaviorType, error) {
	switch s {
	case "Visit":
		return BehaviorType_Visit, nil
	case "Edit":
		return BehaviorType_Edit, nil
	}
	return BehaviorType(0), fmt.Errorf("not a valid BehaviorType string")
}

func BehaviorTypePtr(v BehaviorType) *BehaviorType { return &v }
func (p *BehaviorType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BehaviorType(result.Int64)
	return
}

func (p *BehaviorType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type GetFileUrlsScene int64

const (
	GetFileUrlsScene_shorcutIcon GetFileUrlsScene = 1
)

func (p GetFileUrlsScene) String() string {
	switch p {
	case GetFileUrlsScene_shorcutIcon:
		return "shorcutIcon"
	}
	return "<UNSET>"
}

func GetFileUrlsSceneFromString(s string) (GetFileUrlsScene, error) {
	switch s {
	case "shorcutIcon":
		return GetFileUrlsScene_shorcutIcon, nil
	}
	return GetFileUrlsScene(0), fmt.Errorf("not a valid GetFileUrlsScene string")
}

func GetFileUrlsScenePtr(v GetFileUrlsScene) *GetFileUrlsScene { return &v }
func (p *GetFileUrlsScene) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = GetFileUrlsScene(result.Int64)
	return
}

func (p *GetFileUrlsScene) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type UpdateDraftBotInfoAgwResponse struct {
	Data     *UpdateDraftBotInfoAgwData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64                      `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                     `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp             `thrift:"BaseResp,255,required" form:"-" json:"-" query:"-"`
}

func NewUpdateDraftBotInfoAgwResponse() *UpdateDraftBotInfoAgwResponse {
	return &UpdateDraftBotInfoAgwResponse{}
}

func (p *UpdateDraftBotInfoAgwResponse) InitDefault() {
}

var UpdateDraftBotInfoAgwResponse_Data_DEFAULT *UpdateDraftBotInfoAgwData

func (p *UpdateDraftBotInfoAgwResponse) GetData() (v *UpdateDraftBotInfoAgwData) {
	if !p.IsSetData() {
		return UpdateDraftBotInfoAgwResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *UpdateDraftBotInfoAgwResponse) GetCode() (v int64) {
	return p.Code
}

func (p *UpdateDraftBotInfoAgwResponse) GetMsg() (v string) {
	return p.Msg
}

var UpdateDraftBotInfoAgwResponse_BaseResp_DEFAULT *base.BaseResp

func (p *UpdateDraftBotInfoAgwResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return UpdateDraftBotInfoAgwResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_UpdateDraftBotInfoAgwResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *UpdateDraftBotInfoAgwResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *UpdateDraftBotInfoAgwResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *UpdateDraftBotInfoAgwResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateDraftBotInfoAgwResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UpdateDraftBotInfoAgwResponse[fieldId]))
}

func (p *UpdateDraftBotInfoAgwResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpdateDraftBotInfoAgwData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *UpdateDraftBotInfoAgwResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotInfoAgwResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateDraftBotInfoAgwResponse(%+v)", *p)

}

type UpdateDraftBotInfoAgwData struct {
	// Is there any change?
	HasChange *bool `thrift:"has_change,1,optional" form:"has_change" json:"has_change,omitempty" query:"has_change"`
	// True: The machine audit verification failed
	CheckNotPass bool `thrift:"check_not_pass,2" form:"check_not_pass" json:"check_not_pass" query:"check_not_pass"`
	// Which branch is it currently on?
	Branch         *Branch `thrift:"branch,3,optional" form:"branch" json:"branch,omitempty" query:"branch"`
	SameWithOnline *bool   `thrift:"same_with_online,4,optional" form:"same_with_online" json:"same_with_online,omitempty" query:"same_with_online"`
	// The machine audit verification failed the copy.
	CheckNotPassMsg *string `thrift:"check_not_pass_msg,5,optional" form:"check_not_pass_msg" json:"check_not_pass_msg,omitempty" query:"check_not_pass_msg"`
}

func NewUpdateDraftBotInfoAgwData() *UpdateDraftBotInfoAgwData {
	return &UpdateDraftBotInfoAgwData{}
}

func (p *UpdateDraftBotInfoAgwData) InitDefault() {
}

var UpdateDraftBotInfoAgwData_HasChange_DEFAULT bool

func (p *UpdateDraftBotInfoAgwData) GetHasChange() (v bool) {
	if !p.IsSetHasChange() {
		return UpdateDraftBotInfoAgwData_HasChange_DEFAULT
	}
	return *p.HasChange
}

func (p *UpdateDraftBotInfoAgwData) GetCheckNotPass() (v bool) {
	return p.CheckNotPass
}

var UpdateDraftBotInfoAgwData_Branch_DEFAULT Branch

func (p *UpdateDraftBotInfoAgwData) GetBranch() (v Branch) {
	if !p.IsSetBranch() {
		return UpdateDraftBotInfoAgwData_Branch_DEFAULT
	}
	return *p.Branch
}

var UpdateDraftBotInfoAgwData_SameWithOnline_DEFAULT bool

func (p *UpdateDraftBotInfoAgwData) GetSameWithOnline() (v bool) {
	if !p.IsSetSameWithOnline() {
		return UpdateDraftBotInfoAgwData_SameWithOnline_DEFAULT
	}
	return *p.SameWithOnline
}

var UpdateDraftBotInfoAgwData_CheckNotPassMsg_DEFAULT string

func (p *UpdateDraftBotInfoAgwData) GetCheckNotPassMsg() (v string) {
	if !p.IsSetCheckNotPassMsg() {
		return UpdateDraftBotInfoAgwData_CheckNotPassMsg_DEFAULT
	}
	return *p.CheckNotPassMsg
}

var fieldIDToName_UpdateDraftBotInfoAgwData = map[int16]string{
	1: "has_change",
	2: "check_not_pass",
	3: "branch",
	4: "same_with_online",
	5: "check_not_pass_msg",
}

func (p *UpdateDraftBotInfoAgwData) IsSetHasChange() bool {
	return p.HasChange != nil
}

func (p *UpdateDraftBotInfoAgwData) IsSetBranch() bool {
	return p.Branch != nil
}

func (p *UpdateDraftBotInfoAgwData) IsSetSameWithOnline() bool {
	return p.SameWithOnline != nil
}

func (p *UpdateDraftBotInfoAgwData) IsSetCheckNotPassMsg() bool {
	return p.CheckNotPassMsg != nil
}

func (p *UpdateDraftBotInfoAgwData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateDraftBotInfoAgwData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwData) ReadField1(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HasChange = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwData) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CheckNotPass = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwData) ReadField3(iprot thrift.TProtocol) error {

	var _field *Branch
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := Branch(v)
		_field = &tmp
	}
	p.Branch = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwData) ReadField4(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SameWithOnline = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwData) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CheckNotPassMsg = _field
	return nil
}

func (p *UpdateDraftBotInfoAgwData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotInfoAgwData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwData) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetHasChange() {
		if err = oprot.WriteFieldBegin("has_change", thrift.BOOL, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.HasChange); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("check_not_pass", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.CheckNotPass); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwData) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetBranch() {
		if err = oprot.WriteFieldBegin("branch", thrift.I32, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Branch)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwData) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSameWithOnline() {
		if err = oprot.WriteFieldBegin("same_with_online", thrift.BOOL, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.SameWithOnline); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwData) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetCheckNotPassMsg() {
		if err = oprot.WriteFieldBegin("check_not_pass_msg", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CheckNotPassMsg); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateDraftBotInfoAgwData(%+v)", *p)

}

type UpdateDraftBotInfoAgwRequest struct {
	BotInfo           *bot_common.BotInfoForUpdate `thrift:"bot_info,1,optional" form:"bot_info" json:"bot_info,omitempty" query:"bot_info"`
	BaseCommitVersion *int64                       `thrift:"base_commit_version,2,optional" form:"base_commit_version" json:"base_commit_version,string,omitempty" query:"base_commit_version"`
	Base              *base.Base                   `thrift:"Base,255" form:"-" json:"-" query:"-"`
}

func NewUpdateDraftBotInfoAgwRequest() *UpdateDraftBotInfoAgwRequest {
	return &UpdateDraftBotInfoAgwRequest{}
}

func (p *UpdateDraftBotInfoAgwRequest) InitDefault() {
}

var UpdateDraftBotInfoAgwRequest_BotInfo_DEFAULT *bot_common.BotInfoForUpdate

func (p *UpdateDraftBotInfoAgwRequest) GetBotInfo() (v *bot_common.BotInfoForUpdate) {
	if !p.IsSetBotInfo() {
		return UpdateDraftBotInfoAgwRequest_BotInfo_DEFAULT
	}
	return p.BotInfo
}

var UpdateDraftBotInfoAgwRequest_BaseCommitVersion_DEFAULT int64

func (p *UpdateDraftBotInfoAgwRequest) GetBaseCommitVersion() (v int64) {
	if !p.IsSetBaseCommitVersion() {
		return UpdateDraftBotInfoAgwRequest_BaseCommitVersion_DEFAULT
	}
	return *p.BaseCommitVersion
}

var UpdateDraftBotInfoAgwRequest_Base_DEFAULT *base.Base

func (p *UpdateDraftBotInfoAgwRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return UpdateDraftBotInfoAgwRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_UpdateDraftBotInfoAgwRequest = map[int16]string{
	1:   "bot_info",
	2:   "base_commit_version",
	255: "Base",
}

func (p *UpdateDraftBotInfoAgwRequest) IsSetBotInfo() bool {
	return p.BotInfo != nil
}

func (p *UpdateDraftBotInfoAgwRequest) IsSetBaseCommitVersion() bool {
	return p.BaseCommitVersion != nil
}

func (p *UpdateDraftBotInfoAgwRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *UpdateDraftBotInfoAgwRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateDraftBotInfoAgwRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwRequest) ReadField1(iprot thrift.TProtocol) error {
	_field := bot_common.NewBotInfoForUpdate()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BotInfo = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BaseCommitVersion = _field
	return nil
}
func (p *UpdateDraftBotInfoAgwRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *UpdateDraftBotInfoAgwRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotInfoAgwRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotInfo() {
		if err = oprot.WriteFieldBegin("bot_info", thrift.STRUCT, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BotInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseCommitVersion() {
		if err = oprot.WriteFieldBegin("base_commit_version", thrift.I64, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.BaseCommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UpdateDraftBotInfoAgwRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UpdateDraftBotInfoAgwRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateDraftBotInfoAgwRequest(%+v)", *p)

}

type GetDraftBotInfoAgwRequest struct {
	// Draft bot_id
	BotID int64 `thrift:"bot_id,1,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	// Check the history, the id of the historical version, corresponding to the id of the bot_draft_history
	Version *string `thrift:"version,2,optional" form:"version" json:"version,omitempty" query:"version"`
	// Query specifies commit_version version, pre-release use, seems to be the same thing as version, but the acquisition logic is different
	CommitVersion *string    `thrift:"commit_version,3,optional" form:"commit_version" json:"commit_version,omitempty" query:"commit_version"`
	Base          *base.Base `thrift:"Base,255" form:"-" json:"-" query:"-"`
}

func NewGetDraftBotInfoAgwRequest() *GetDraftBotInfoAgwRequest {
	return &GetDraftBotInfoAgwRequest{}
}

func (p *GetDraftBotInfoAgwRequest) InitDefault() {
}

func (p *GetDraftBotInfoAgwRequest) GetBotID() (v int64) {
	return p.BotID
}

var GetDraftBotInfoAgwRequest_Version_DEFAULT string

func (p *GetDraftBotInfoAgwRequest) GetVersion() (v string) {
	if !p.IsSetVersion() {
		return GetDraftBotInfoAgwRequest_Version_DEFAULT
	}
	return *p.Version
}

var GetDraftBotInfoAgwRequest_CommitVersion_DEFAULT string

func (p *GetDraftBotInfoAgwRequest) GetCommitVersion() (v string) {
	if !p.IsSetCommitVersion() {
		return GetDraftBotInfoAgwRequest_CommitVersion_DEFAULT
	}
	return *p.CommitVersion
}

var GetDraftBotInfoAgwRequest_Base_DEFAULT *base.Base

func (p *GetDraftBotInfoAgwRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetDraftBotInfoAgwRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetDraftBotInfoAgwRequest = map[int16]string{
	1:   "bot_id",
	2:   "version",
	3:   "commit_version",
	255: "Base",
}

func (p *GetDraftBotInfoAgwRequest) IsSetVersion() bool {
	return p.Version != nil
}

func (p *GetDraftBotInfoAgwRequest) IsSetCommitVersion() bool {
	return p.CommitVersion != nil
}

func (p *GetDraftBotInfoAgwRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetDraftBotInfoAgwRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetDraftBotInfoAgwRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetDraftBotInfoAgwRequest[fieldId]))
}

func (p *GetDraftBotInfoAgwRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *GetDraftBotInfoAgwRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Version = _field
	return nil
}
func (p *GetDraftBotInfoAgwRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitVersion = _field
	return nil
}
func (p *GetDraftBotInfoAgwRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetDraftBotInfoAgwRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotInfoAgwRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetDraftBotInfoAgwRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetVersion() {
		if err = oprot.WriteFieldBegin("version", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Version); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitVersion() {
		if err = oprot.WriteFieldBegin("commit_version", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetDraftBotInfoAgwRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetDraftBotInfoAgwRequest(%+v)", *p)

}

type GetDraftBotInfoAgwResponse struct {
	Data     *GetDraftBotInfoAgwData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64                   `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                  `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp          `thrift:"BaseResp,255,required" form:"-" json:"-" query:"-"`
}

func NewGetDraftBotInfoAgwResponse() *GetDraftBotInfoAgwResponse {
	return &GetDraftBotInfoAgwResponse{}
}

func (p *GetDraftBotInfoAgwResponse) InitDefault() {
}

var GetDraftBotInfoAgwResponse_Data_DEFAULT *GetDraftBotInfoAgwData

func (p *GetDraftBotInfoAgwResponse) GetData() (v *GetDraftBotInfoAgwData) {
	if !p.IsSetData() {
		return GetDraftBotInfoAgwResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetDraftBotInfoAgwResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetDraftBotInfoAgwResponse) GetMsg() (v string) {
	return p.Msg
}

var GetDraftBotInfoAgwResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetDraftBotInfoAgwResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetDraftBotInfoAgwResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetDraftBotInfoAgwResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetDraftBotInfoAgwResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetDraftBotInfoAgwResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetDraftBotInfoAgwResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetDraftBotInfoAgwResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetDraftBotInfoAgwResponse[fieldId]))
}

func (p *GetDraftBotInfoAgwResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetDraftBotInfoAgwData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetDraftBotInfoAgwResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetDraftBotInfoAgwResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetDraftBotInfoAgwResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetDraftBotInfoAgwResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotInfoAgwResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetDraftBotInfoAgwResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetDraftBotInfoAgwResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetDraftBotInfoAgwResponse(%+v)", *p)

}

type GetDraftBotInfoAgwData struct {
	// core bot data
	BotInfo *bot_common.BotInfo `thrift:"bot_info,1,required" form:"bot_info,required" json:"bot_info,required" query:"bot_info,required"`
	// bot option information
	BotOptionData *BotOptionData `thrift:"bot_option_data,2,optional" form:"bot_option_data" json:"bot_option_data,omitempty" query:"bot_option_data"`
	// Are there any unpublished changes?
	HasUnpublishedChange *bool `thrift:"has_unpublished_change,3,optional" form:"has_unpublished_change" json:"has_unpublished_change,omitempty" query:"has_unpublished_change"`
	// The product status after the bot is put on the shelves
	BotMarketStatus *BotMarketStatus `thrift:"bot_market_status,4,optional" form:"bot_market_status" json:"bot_market_status,omitempty" query:"bot_market_status"`
	// Is the bot in multiplayer cooperative mode?
	InCollaboration *bool `thrift:"in_collaboration,5,optional" form:"in_collaboration" json:"in_collaboration,omitempty" query:"in_collaboration"`
	// Is the content committed consistent with the online content?
	SameWithOnline *bool `thrift:"same_with_online,6,optional" form:"same_with_online" json:"same_with_online,omitempty" query:"same_with_online"`
	// For frontend, permission related, can the current user edit this bot
	Editable *bool `thrift:"editable,7,optional" form:"editable" json:"editable,omitempty" query:"editable"`
	// For frontend, permission related, can the current user delete this bot
	Deletable *bool `thrift:"deletable,8,optional" form:"deletable" json:"deletable,omitempty" query:"deletable"`
	// Is the publisher of the latest release version
	Publisher *UserInfo `thrift:"publisher,9,optional" form:"publisher" json:"publisher,omitempty" query:"publisher"`
	// Has it been published?
	HasPublish bool `thrift:"has_publish,10" form:"has_publish" json:"has_publish" query:"has_publish"`
	// Space ID
	SpaceID int64 `thrift:"space_id,11" form:"space_id" json:"space_id,string" query:"space_id"`
	// Published business line details
	Connectors []*BotConnectorInfo `thrift:"connectors,12" form:"connectors" json:"connectors" query:"connectors"`
	// What branch did you get the content of?
	Branch *Branch `thrift:"branch,13,optional" form:"branch" json:"branch,omitempty" query:"branch"`
	// If branch=PersonalDraft, the version number of checkout/rebase; if branch = base, the committed version
	CommitVersion *string `thrift:"commit_version,14,optional" form:"commit_version" json:"commit_version,omitempty" query:"commit_version"`
	// For the front end, the most recent author
	CommitterName *string `thrift:"committer_name,15,optional" form:"committer_name" json:"committer_name,omitempty" query:"committer_name"`
	// For frontend, commit time
	CommitTime *string `thrift:"commit_time,16,optional" form:"commit_time" json:"commit_time,omitempty" query:"commit_time"`
	// For frontend, release time
	PublishTime *string `thrift:"publish_time,17,optional" form:"publish_time" json:"publish_time,omitempty" query:"publish_time"`
	// Multi-person collaboration related operation permissions
	CollaboratorStatus *BotCollaboratorStatus `thrift:"collaborator_status,18,optional" form:"collaborator_status" json:"collaborator_status,omitempty" query:"collaborator_status"`
	// Details of the most recent review
	LatestAuditInfo *AuditInfo `thrift:"latest_audit_info,19,optional" form:"latest_audit_info" json:"latest_audit_info,omitempty" query:"latest_audit_info"`
	// Douyin's doppelganger bot will have appId.
	AppID *string `thrift:"app_id,20,optional" form:"app_id" json:"app_id,omitempty" query:"app_id"`
}

func NewGetDraftBotInfoAgwData() *GetDraftBotInfoAgwData {
	return &GetDraftBotInfoAgwData{}
}

func (p *GetDraftBotInfoAgwData) InitDefault() {
}

var GetDraftBotInfoAgwData_BotInfo_DEFAULT *bot_common.BotInfo

func (p *GetDraftBotInfoAgwData) GetBotInfo() (v *bot_common.BotInfo) {
	if !p.IsSetBotInfo() {
		return GetDraftBotInfoAgwData_BotInfo_DEFAULT
	}
	return p.BotInfo
}

var GetDraftBotInfoAgwData_BotOptionData_DEFAULT *BotOptionData

func (p *GetDraftBotInfoAgwData) GetBotOptionData() (v *BotOptionData) {
	if !p.IsSetBotOptionData() {
		return GetDraftBotInfoAgwData_BotOptionData_DEFAULT
	}
	return p.BotOptionData
}

var GetDraftBotInfoAgwData_HasUnpublishedChange_DEFAULT bool

func (p *GetDraftBotInfoAgwData) GetHasUnpublishedChange() (v bool) {
	if !p.IsSetHasUnpublishedChange() {
		return GetDraftBotInfoAgwData_HasUnpublishedChange_DEFAULT
	}
	return *p.HasUnpublishedChange
}

var GetDraftBotInfoAgwData_BotMarketStatus_DEFAULT BotMarketStatus

func (p *GetDraftBotInfoAgwData) GetBotMarketStatus() (v BotMarketStatus) {
	if !p.IsSetBotMarketStatus() {
		return GetDraftBotInfoAgwData_BotMarketStatus_DEFAULT
	}
	return *p.BotMarketStatus
}

var GetDraftBotInfoAgwData_InCollaboration_DEFAULT bool

func (p *GetDraftBotInfoAgwData) GetInCollaboration() (v bool) {
	if !p.IsSetInCollaboration() {
		return GetDraftBotInfoAgwData_InCollaboration_DEFAULT
	}
	return *p.InCollaboration
}

var GetDraftBotInfoAgwData_SameWithOnline_DEFAULT bool

func (p *GetDraftBotInfoAgwData) GetSameWithOnline() (v bool) {
	if !p.IsSetSameWithOnline() {
		return GetDraftBotInfoAgwData_SameWithOnline_DEFAULT
	}
	return *p.SameWithOnline
}

var GetDraftBotInfoAgwData_Editable_DEFAULT bool

func (p *GetDraftBotInfoAgwData) GetEditable() (v bool) {
	if !p.IsSetEditable() {
		return GetDraftBotInfoAgwData_Editable_DEFAULT
	}
	return *p.Editable
}

var GetDraftBotInfoAgwData_Deletable_DEFAULT bool

func (p *GetDraftBotInfoAgwData) GetDeletable() (v bool) {
	if !p.IsSetDeletable() {
		return GetDraftBotInfoAgwData_Deletable_DEFAULT
	}
	return *p.Deletable
}

var GetDraftBotInfoAgwData_Publisher_DEFAULT *UserInfo

func (p *GetDraftBotInfoAgwData) GetPublisher() (v *UserInfo) {
	if !p.IsSetPublisher() {
		return GetDraftBotInfoAgwData_Publisher_DEFAULT
	}
	return p.Publisher
}

func (p *GetDraftBotInfoAgwData) GetHasPublish() (v bool) {
	return p.HasPublish
}

func (p *GetDraftBotInfoAgwData) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *GetDraftBotInfoAgwData) GetConnectors() (v []*BotConnectorInfo) {
	return p.Connectors
}

var GetDraftBotInfoAgwData_Branch_DEFAULT Branch

func (p *GetDraftBotInfoAgwData) GetBranch() (v Branch) {
	if !p.IsSetBranch() {
		return GetDraftBotInfoAgwData_Branch_DEFAULT
	}
	return *p.Branch
}

var GetDraftBotInfoAgwData_CommitVersion_DEFAULT string

func (p *GetDraftBotInfoAgwData) GetCommitVersion() (v string) {
	if !p.IsSetCommitVersion() {
		return GetDraftBotInfoAgwData_CommitVersion_DEFAULT
	}
	return *p.CommitVersion
}

var GetDraftBotInfoAgwData_CommitterName_DEFAULT string

func (p *GetDraftBotInfoAgwData) GetCommitterName() (v string) {
	if !p.IsSetCommitterName() {
		return GetDraftBotInfoAgwData_CommitterName_DEFAULT
	}
	return *p.CommitterName
}

var GetDraftBotInfoAgwData_CommitTime_DEFAULT string

func (p *GetDraftBotInfoAgwData) GetCommitTime() (v string) {
	if !p.IsSetCommitTime() {
		return GetDraftBotInfoAgwData_CommitTime_DEFAULT
	}
	return *p.CommitTime
}

var GetDraftBotInfoAgwData_PublishTime_DEFAULT string

func (p *GetDraftBotInfoAgwData) GetPublishTime() (v string) {
	if !p.IsSetPublishTime() {
		return GetDraftBotInfoAgwData_PublishTime_DEFAULT
	}
	return *p.PublishTime
}

var GetDraftBotInfoAgwData_CollaboratorStatus_DEFAULT *BotCollaboratorStatus

func (p *GetDraftBotInfoAgwData) GetCollaboratorStatus() (v *BotCollaboratorStatus) {
	if !p.IsSetCollaboratorStatus() {
		return GetDraftBotInfoAgwData_CollaboratorStatus_DEFAULT
	}
	return p.CollaboratorStatus
}

var GetDraftBotInfoAgwData_LatestAuditInfo_DEFAULT *AuditInfo

func (p *GetDraftBotInfoAgwData) GetLatestAuditInfo() (v *AuditInfo) {
	if !p.IsSetLatestAuditInfo() {
		return GetDraftBotInfoAgwData_LatestAuditInfo_DEFAULT
	}
	return p.LatestAuditInfo
}

var GetDraftBotInfoAgwData_AppID_DEFAULT string

func (p *GetDraftBotInfoAgwData) GetAppID() (v string) {
	if !p.IsSetAppID() {
		return GetDraftBotInfoAgwData_AppID_DEFAULT
	}
	return *p.AppID
}

var fieldIDToName_GetDraftBotInfoAgwData = map[int16]string{
	1:  "bot_info",
	2:  "bot_option_data",
	3:  "has_unpublished_change",
	4:  "bot_market_status",
	5:  "in_collaboration",
	6:  "same_with_online",
	7:  "editable",
	8:  "deletable",
	9:  "publisher",
	10: "has_publish",
	11: "space_id",
	12: "connectors",
	13: "branch",
	14: "commit_version",
	15: "committer_name",
	16: "commit_time",
	17: "publish_time",
	18: "collaborator_status",
	19: "latest_audit_info",
	20: "app_id",
}

func (p *GetDraftBotInfoAgwData) IsSetBotInfo() bool {
	return p.BotInfo != nil
}

func (p *GetDraftBotInfoAgwData) IsSetBotOptionData() bool {
	return p.BotOptionData != nil
}

func (p *GetDraftBotInfoAgwData) IsSetHasUnpublishedChange() bool {
	return p.HasUnpublishedChange != nil
}

func (p *GetDraftBotInfoAgwData) IsSetBotMarketStatus() bool {
	return p.BotMarketStatus != nil
}

func (p *GetDraftBotInfoAgwData) IsSetInCollaboration() bool {
	return p.InCollaboration != nil
}

func (p *GetDraftBotInfoAgwData) IsSetSameWithOnline() bool {
	return p.SameWithOnline != nil
}

func (p *GetDraftBotInfoAgwData) IsSetEditable() bool {
	return p.Editable != nil
}

func (p *GetDraftBotInfoAgwData) IsSetDeletable() bool {
	return p.Deletable != nil
}

func (p *GetDraftBotInfoAgwData) IsSetPublisher() bool {
	return p.Publisher != nil
}

func (p *GetDraftBotInfoAgwData) IsSetBranch() bool {
	return p.Branch != nil
}

func (p *GetDraftBotInfoAgwData) IsSetCommitVersion() bool {
	return p.CommitVersion != nil
}

func (p *GetDraftBotInfoAgwData) IsSetCommitterName() bool {
	return p.CommitterName != nil
}

func (p *GetDraftBotInfoAgwData) IsSetCommitTime() bool {
	return p.CommitTime != nil
}

func (p *GetDraftBotInfoAgwData) IsSetPublishTime() bool {
	return p.PublishTime != nil
}

func (p *GetDraftBotInfoAgwData) IsSetCollaboratorStatus() bool {
	return p.CollaboratorStatus != nil
}

func (p *GetDraftBotInfoAgwData) IsSetLatestAuditInfo() bool {
	return p.LatestAuditInfo != nil
}

func (p *GetDraftBotInfoAgwData) IsSetAppID() bool {
	return p.AppID != nil
}

func (p *GetDraftBotInfoAgwData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotInfo bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotInfo = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotInfo {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetDraftBotInfoAgwData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetDraftBotInfoAgwData[fieldId]))
}

func (p *GetDraftBotInfoAgwData) ReadField1(iprot thrift.TProtocol) error {
	_field := bot_common.NewBotInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BotInfo = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField2(iprot thrift.TProtocol) error {
	_field := NewBotOptionData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BotOptionData = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField3(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HasUnpublishedChange = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField4(iprot thrift.TProtocol) error {

	var _field *BotMarketStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := BotMarketStatus(v)
		_field = &tmp
	}
	p.BotMarketStatus = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField5(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.InCollaboration = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField6(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SameWithOnline = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField7(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Editable = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField8(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Deletable = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField9(iprot thrift.TProtocol) error {
	_field := NewUserInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Publisher = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField10(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.HasPublish = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField11(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField12(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*BotConnectorInfo, 0, size)
	values := make([]BotConnectorInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Connectors = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField13(iprot thrift.TProtocol) error {

	var _field *Branch
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := Branch(v)
		_field = &tmp
	}
	p.Branch = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitVersion = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitterName = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField16(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitTime = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField17(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PublishTime = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField18(iprot thrift.TProtocol) error {
	_field := NewBotCollaboratorStatus()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.CollaboratorStatus = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField19(iprot thrift.TProtocol) error {
	_field := NewAuditInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.LatestAuditInfo = _field
	return nil
}
func (p *GetDraftBotInfoAgwData) ReadField20(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.AppID = _field
	return nil
}

func (p *GetDraftBotInfoAgwData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotInfoAgwData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetDraftBotInfoAgwData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_info", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BotInfo.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotOptionData() {
		if err = oprot.WriteFieldBegin("bot_option_data", thrift.STRUCT, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BotOptionData.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetHasUnpublishedChange() {
		if err = oprot.WriteFieldBegin("has_unpublished_change", thrift.BOOL, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.HasUnpublishedChange); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotMarketStatus() {
		if err = oprot.WriteFieldBegin("bot_market_status", thrift.I32, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.BotMarketStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetInCollaboration() {
		if err = oprot.WriteFieldBegin("in_collaboration", thrift.BOOL, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.InCollaboration); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetSameWithOnline() {
		if err = oprot.WriteFieldBegin("same_with_online", thrift.BOOL, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.SameWithOnline); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetEditable() {
		if err = oprot.WriteFieldBegin("editable", thrift.BOOL, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.Editable); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetDeletable() {
		if err = oprot.WriteFieldBegin("deletable", thrift.BOOL, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.Deletable); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublisher() {
		if err = oprot.WriteFieldBegin("publisher", thrift.STRUCT, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Publisher.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("has_publish", thrift.BOOL, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.HasPublish); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField12(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connectors", thrift.LIST, 12); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Connectors)); err != nil {
		return err
	}
	for _, v := range p.Connectors {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetBranch() {
		if err = oprot.WriteFieldBegin("branch", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Branch)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitVersion() {
		if err = oprot.WriteFieldBegin("commit_version", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitterName() {
		if err = oprot.WriteFieldBegin("committer_name", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitterName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitTime() {
		if err = oprot.WriteFieldBegin("commit_time", thrift.STRING, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitTime); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishTime() {
		if err = oprot.WriteFieldBegin("publish_time", thrift.STRING, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PublishTime); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField18(oprot thrift.TProtocol) (err error) {
	if p.IsSetCollaboratorStatus() {
		if err = oprot.WriteFieldBegin("collaborator_status", thrift.STRUCT, 18); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.CollaboratorStatus.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField19(oprot thrift.TProtocol) (err error) {
	if p.IsSetLatestAuditInfo() {
		if err = oprot.WriteFieldBegin("latest_audit_info", thrift.STRUCT, 19); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.LatestAuditInfo.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *GetDraftBotInfoAgwData) writeField20(oprot thrift.TProtocol) (err error) {
	if p.IsSetAppID() {
		if err = oprot.WriteFieldBegin("app_id", thrift.STRING, 20); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.AppID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}

func (p *GetDraftBotInfoAgwData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetDraftBotInfoAgwData(%+v)", *p)

}

type BotOptionData struct {
	// model details
	ModelDetailMap map[int64]*ModelDetail `thrift:"model_detail_map,1,optional" form:"model_detail_map" json:"model_detail_map,omitempty" query:"model_detail_map"`
	// plugin details
	PluginDetailMap map[int64]*PluginDetal `thrift:"plugin_detail_map,2,optional" form:"plugin_detail_map" json:"plugin_detail_map,omitempty" query:"plugin_detail_map"`
	// Plugin API Details
	PluginAPIDetailMap map[int64]*PluginAPIDetal `thrift:"plugin_api_detail_map,3,optional" form:"plugin_api_detail_map" json:"plugin_api_detail_map,omitempty" query:"plugin_api_detail_map"`
	// Workflow Details
	WorkflowDetailMap map[int64]*WorkflowDetail `thrift:"workflow_detail_map,4,optional" form:"workflow_detail_map" json:"workflow_detail_map,omitempty" query:"workflow_detail_map"`
	// Knowledge Details
	KnowledgeDetailMap map[string]*KnowledgeDetail `thrift:"knowledge_detail_map,5,optional" form:"knowledge_detail_map" json:"knowledge_detail_map,omitempty" query:"knowledge_detail_map"`
	// Quick command list
	ShortcutCommandList []*ShortcutCommand `thrift:"shortcut_command_list,6,optional" form:"shortcut_command_list" json:"shortcut_command_list,omitempty" query:"shortcut_command_list"`
}

func NewBotOptionData() *BotOptionData {
	return &BotOptionData{}
}

func (p *BotOptionData) InitDefault() {
}

var BotOptionData_ModelDetailMap_DEFAULT map[int64]*ModelDetail

func (p *BotOptionData) GetModelDetailMap() (v map[int64]*ModelDetail) {
	if !p.IsSetModelDetailMap() {
		return BotOptionData_ModelDetailMap_DEFAULT
	}
	return p.ModelDetailMap
}

var BotOptionData_PluginDetailMap_DEFAULT map[int64]*PluginDetal

func (p *BotOptionData) GetPluginDetailMap() (v map[int64]*PluginDetal) {
	if !p.IsSetPluginDetailMap() {
		return BotOptionData_PluginDetailMap_DEFAULT
	}
	return p.PluginDetailMap
}

var BotOptionData_PluginAPIDetailMap_DEFAULT map[int64]*PluginAPIDetal

func (p *BotOptionData) GetPluginAPIDetailMap() (v map[int64]*PluginAPIDetal) {
	if !p.IsSetPluginAPIDetailMap() {
		return BotOptionData_PluginAPIDetailMap_DEFAULT
	}
	return p.PluginAPIDetailMap
}

var BotOptionData_WorkflowDetailMap_DEFAULT map[int64]*WorkflowDetail

func (p *BotOptionData) GetWorkflowDetailMap() (v map[int64]*WorkflowDetail) {
	if !p.IsSetWorkflowDetailMap() {
		return BotOptionData_WorkflowDetailMap_DEFAULT
	}
	return p.WorkflowDetailMap
}

var BotOptionData_KnowledgeDetailMap_DEFAULT map[string]*KnowledgeDetail

func (p *BotOptionData) GetKnowledgeDetailMap() (v map[string]*KnowledgeDetail) {
	if !p.IsSetKnowledgeDetailMap() {
		return BotOptionData_KnowledgeDetailMap_DEFAULT
	}
	return p.KnowledgeDetailMap
}

var BotOptionData_ShortcutCommandList_DEFAULT []*ShortcutCommand

func (p *BotOptionData) GetShortcutCommandList() (v []*ShortcutCommand) {
	if !p.IsSetShortcutCommandList() {
		return BotOptionData_ShortcutCommandList_DEFAULT
	}
	return p.ShortcutCommandList
}

var fieldIDToName_BotOptionData = map[int16]string{
	1: "model_detail_map",
	2: "plugin_detail_map",
	3: "plugin_api_detail_map",
	4: "workflow_detail_map",
	5: "knowledge_detail_map",
	6: "shortcut_command_list",
}

func (p *BotOptionData) IsSetModelDetailMap() bool {
	return p.ModelDetailMap != nil
}

func (p *BotOptionData) IsSetPluginDetailMap() bool {
	return p.PluginDetailMap != nil
}

func (p *BotOptionData) IsSetPluginAPIDetailMap() bool {
	return p.PluginAPIDetailMap != nil
}

func (p *BotOptionData) IsSetWorkflowDetailMap() bool {
	return p.WorkflowDetailMap != nil
}

func (p *BotOptionData) IsSetKnowledgeDetailMap() bool {
	return p.KnowledgeDetailMap != nil
}

func (p *BotOptionData) IsSetShortcutCommandList() bool {
	return p.ShortcutCommandList != nil
}

func (p *BotOptionData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotOptionData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotOptionData) ReadField1(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*ModelDetail, size)
	values := make([]ModelDetail, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.ModelDetailMap = _field
	return nil
}
func (p *BotOptionData) ReadField2(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*PluginDetal, size)
	values := make([]PluginDetal, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.PluginDetailMap = _field
	return nil
}
func (p *BotOptionData) ReadField3(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*PluginAPIDetal, size)
	values := make([]PluginAPIDetal, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.PluginAPIDetailMap = _field
	return nil
}
func (p *BotOptionData) ReadField4(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*WorkflowDetail, size)
	values := make([]WorkflowDetail, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.WorkflowDetailMap = _field
	return nil
}
func (p *BotOptionData) ReadField5(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]*KnowledgeDetail, size)
	values := make([]KnowledgeDetail, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.KnowledgeDetailMap = _field
	return nil
}
func (p *BotOptionData) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ShortcutCommand, 0, size)
	values := make([]ShortcutCommand, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.ShortcutCommandList = _field
	return nil
}

func (p *BotOptionData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotOptionData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotOptionData) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelDetailMap() {
		if err = oprot.WriteFieldBegin("model_detail_map", thrift.MAP, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.ModelDetailMap)); err != nil {
			return err
		}
		for k, v := range p.ModelDetailMap {
			if err := oprot.WriteI64(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotOptionData) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginDetailMap() {
		if err = oprot.WriteFieldBegin("plugin_detail_map", thrift.MAP, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.PluginDetailMap)); err != nil {
			return err
		}
		for k, v := range p.PluginDetailMap {
			if err := oprot.WriteI64(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotOptionData) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginAPIDetailMap() {
		if err = oprot.WriteFieldBegin("plugin_api_detail_map", thrift.MAP, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.PluginAPIDetailMap)); err != nil {
			return err
		}
		for k, v := range p.PluginAPIDetailMap {
			if err := oprot.WriteI64(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotOptionData) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowDetailMap() {
		if err = oprot.WriteFieldBegin("workflow_detail_map", thrift.MAP, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.WorkflowDetailMap)); err != nil {
			return err
		}
		for k, v := range p.WorkflowDetailMap {
			if err := oprot.WriteI64(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *BotOptionData) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetKnowledgeDetailMap() {
		if err = oprot.WriteFieldBegin("knowledge_detail_map", thrift.MAP, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRUCT, len(p.KnowledgeDetailMap)); err != nil {
			return err
		}
		for k, v := range p.KnowledgeDetailMap {
			if err := oprot.WriteString(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *BotOptionData) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetShortcutCommandList() {
		if err = oprot.WriteFieldBegin("shortcut_command_list", thrift.LIST, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.ShortcutCommandList)); err != nil {
			return err
		}
		for _, v := range p.ShortcutCommandList {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}

func (p *BotOptionData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotOptionData(%+v)", *p)

}

type ModelDetail struct {
	// Model display name (to the user)
	Name *string `thrift:"name,1,optional" form:"name" json:"name,omitempty" query:"name"`
	// Model name (for internal)
	ModelName *string `thrift:"model_name,2,optional" form:"model_name" json:"model_name,omitempty" query:"model_name"`
	// Model ID
	ModelID *int64 `thrift:"model_id,3,optional" form:"model_id" json:"model_id,string,omitempty" query:"model_id"`
	// Model Category
	ModelFamily *int64 `thrift:"model_family,4,optional" form:"model_family" json:"model_family,omitempty" query:"model_family"`
	// IconURL
	ModelIconURL *string `thrift:"model_icon_url,5,optional" form:"model_icon_url" json:"model_icon_url,omitempty" query:"model_icon_url"`
}

func NewModelDetail() *ModelDetail {
	return &ModelDetail{}
}

func (p *ModelDetail) InitDefault() {
}

var ModelDetail_Name_DEFAULT string

func (p *ModelDetail) GetName() (v string) {
	if !p.IsSetName() {
		return ModelDetail_Name_DEFAULT
	}
	return *p.Name
}

var ModelDetail_ModelName_DEFAULT string

func (p *ModelDetail) GetModelName() (v string) {
	if !p.IsSetModelName() {
		return ModelDetail_ModelName_DEFAULT
	}
	return *p.ModelName
}

var ModelDetail_ModelID_DEFAULT int64

func (p *ModelDetail) GetModelID() (v int64) {
	if !p.IsSetModelID() {
		return ModelDetail_ModelID_DEFAULT
	}
	return *p.ModelID
}

var ModelDetail_ModelFamily_DEFAULT int64

func (p *ModelDetail) GetModelFamily() (v int64) {
	if !p.IsSetModelFamily() {
		return ModelDetail_ModelFamily_DEFAULT
	}
	return *p.ModelFamily
}

var ModelDetail_ModelIconURL_DEFAULT string

func (p *ModelDetail) GetModelIconURL() (v string) {
	if !p.IsSetModelIconURL() {
		return ModelDetail_ModelIconURL_DEFAULT
	}
	return *p.ModelIconURL
}

var fieldIDToName_ModelDetail = map[int16]string{
	1: "name",
	2: "model_name",
	3: "model_id",
	4: "model_family",
	5: "model_icon_url",
}

func (p *ModelDetail) IsSetName() bool {
	return p.Name != nil
}

func (p *ModelDetail) IsSetModelName() bool {
	return p.ModelName != nil
}

func (p *ModelDetail) IsSetModelID() bool {
	return p.ModelID != nil
}

func (p *ModelDetail) IsSetModelFamily() bool {
	return p.ModelFamily != nil
}

func (p *ModelDetail) IsSetModelIconURL() bool {
	return p.ModelIconURL != nil
}

func (p *ModelDetail) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ModelDetail[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ModelDetail) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *ModelDetail) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ModelName = _field
	return nil
}
func (p *ModelDetail) ReadField3(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ModelID = _field
	return nil
}
func (p *ModelDetail) ReadField4(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ModelFamily = _field
	return nil
}
func (p *ModelDetail) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ModelIconURL = _field
	return nil
}

func (p *ModelDetail) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ModelDetail"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ModelDetail) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ModelDetail) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelName() {
		if err = oprot.WriteFieldBegin("model_name", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ModelName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ModelDetail) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelID() {
		if err = oprot.WriteFieldBegin("model_id", thrift.I64, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ModelID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ModelDetail) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelFamily() {
		if err = oprot.WriteFieldBegin("model_family", thrift.I64, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ModelFamily); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ModelDetail) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetModelIconURL() {
		if err = oprot.WriteFieldBegin("model_icon_url", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ModelIconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *ModelDetail) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ModelDetail(%+v)", *p)

}

type PluginDetal struct {
	ID           *int64  `thrift:"id,1,optional" form:"id" json:"id,string,omitempty" query:"id"`
	Name         *string `thrift:"name,2,optional" form:"name" json:"name,omitempty" query:"name"`
	Description  *string `thrift:"description,3,optional" form:"description" json:"description,omitempty" query:"description"`
	IconURL      *string `thrift:"icon_url,4,optional" form:"icon_url" json:"icon_url,omitempty" query:"icon_url"`
	PluginType   *int64  `thrift:"plugin_type,5,optional" form:"plugin_type" json:"plugin_type,string,omitempty" query:"plugin_type"`
	PluginStatus *int64  `thrift:"plugin_status,6,optional" form:"plugin_status" json:"plugin_status,string,omitempty" query:"plugin_status"`
	IsOfficial   *bool   `thrift:"is_official,7,optional" form:"is_official" json:"is_official,omitempty" query:"is_official"`
}

func NewPluginDetal() *PluginDetal {
	return &PluginDetal{}
}

func (p *PluginDetal) InitDefault() {
}

var PluginDetal_ID_DEFAULT int64

func (p *PluginDetal) GetID() (v int64) {
	if !p.IsSetID() {
		return PluginDetal_ID_DEFAULT
	}
	return *p.ID
}

var PluginDetal_Name_DEFAULT string

func (p *PluginDetal) GetName() (v string) {
	if !p.IsSetName() {
		return PluginDetal_Name_DEFAULT
	}
	return *p.Name
}

var PluginDetal_Description_DEFAULT string

func (p *PluginDetal) GetDescription() (v string) {
	if !p.IsSetDescription() {
		return PluginDetal_Description_DEFAULT
	}
	return *p.Description
}

var PluginDetal_IconURL_DEFAULT string

func (p *PluginDetal) GetIconURL() (v string) {
	if !p.IsSetIconURL() {
		return PluginDetal_IconURL_DEFAULT
	}
	return *p.IconURL
}

var PluginDetal_PluginType_DEFAULT int64

func (p *PluginDetal) GetPluginType() (v int64) {
	if !p.IsSetPluginType() {
		return PluginDetal_PluginType_DEFAULT
	}
	return *p.PluginType
}

var PluginDetal_PluginStatus_DEFAULT int64

func (p *PluginDetal) GetPluginStatus() (v int64) {
	if !p.IsSetPluginStatus() {
		return PluginDetal_PluginStatus_DEFAULT
	}
	return *p.PluginStatus
}

var PluginDetal_IsOfficial_DEFAULT bool

func (p *PluginDetal) GetIsOfficial() (v bool) {
	if !p.IsSetIsOfficial() {
		return PluginDetal_IsOfficial_DEFAULT
	}
	return *p.IsOfficial
}

var fieldIDToName_PluginDetal = map[int16]string{
	1: "id",
	2: "name",
	3: "description",
	4: "icon_url",
	5: "plugin_type",
	6: "plugin_status",
	7: "is_official",
}

func (p *PluginDetal) IsSetID() bool {
	return p.ID != nil
}

func (p *PluginDetal) IsSetName() bool {
	return p.Name != nil
}

func (p *PluginDetal) IsSetDescription() bool {
	return p.Description != nil
}

func (p *PluginDetal) IsSetIconURL() bool {
	return p.IconURL != nil
}

func (p *PluginDetal) IsSetPluginType() bool {
	return p.PluginType != nil
}

func (p *PluginDetal) IsSetPluginStatus() bool {
	return p.PluginStatus != nil
}

func (p *PluginDetal) IsSetIsOfficial() bool {
	return p.IsOfficial != nil
}

func (p *PluginDetal) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PluginDetal[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PluginDetal) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ID = _field
	return nil
}
func (p *PluginDetal) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *PluginDetal) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Description = _field
	return nil
}
func (p *PluginDetal) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IconURL = _field
	return nil
}
func (p *PluginDetal) ReadField5(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PluginType = _field
	return nil
}
func (p *PluginDetal) ReadField6(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PluginStatus = _field
	return nil
}
func (p *PluginDetal) ReadField7(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsOfficial = _field
	return nil
}

func (p *PluginDetal) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PluginDetal"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PluginDetal) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetID() {
		if err = oprot.WriteFieldBegin("id", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PluginDetal) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PluginDetal) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetDescription() {
		if err = oprot.WriteFieldBegin("description", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Description); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PluginDetal) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetIconURL() {
		if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PluginDetal) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginType() {
		if err = oprot.WriteFieldBegin("plugin_type", thrift.I64, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.PluginType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PluginDetal) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginStatus() {
		if err = oprot.WriteFieldBegin("plugin_status", thrift.I64, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.PluginStatus); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PluginDetal) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsOfficial() {
		if err = oprot.WriteFieldBegin("is_official", thrift.BOOL, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsOfficial); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *PluginDetal) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PluginDetal(%+v)", *p)

}

type PluginAPIDetal struct {
	ID          *int64             `thrift:"id,1,optional" form:"id" json:"id,string,omitempty" query:"id"`
	Name        *string            `thrift:"name,2,optional" form:"name" json:"name,omitempty" query:"name"`
	Description *string            `thrift:"description,3,optional" form:"description" json:"description,omitempty" query:"description"`
	Parameters  []*PluginParameter `thrift:"parameters,4,optional" form:"parameters" json:"parameters,omitempty" query:"parameters"`
	PluginID    *int64             `thrift:"plugin_id,5,optional" form:"plugin_id" json:"plugin_id,string,omitempty" query:"plugin_id"`
}

func NewPluginAPIDetal() *PluginAPIDetal {
	return &PluginAPIDetal{}
}

func (p *PluginAPIDetal) InitDefault() {
}

var PluginAPIDetal_ID_DEFAULT int64

func (p *PluginAPIDetal) GetID() (v int64) {
	if !p.IsSetID() {
		return PluginAPIDetal_ID_DEFAULT
	}
	return *p.ID
}

var PluginAPIDetal_Name_DEFAULT string

func (p *PluginAPIDetal) GetName() (v string) {
	if !p.IsSetName() {
		return PluginAPIDetal_Name_DEFAULT
	}
	return *p.Name
}

var PluginAPIDetal_Description_DEFAULT string

func (p *PluginAPIDetal) GetDescription() (v string) {
	if !p.IsSetDescription() {
		return PluginAPIDetal_Description_DEFAULT
	}
	return *p.Description
}

var PluginAPIDetal_Parameters_DEFAULT []*PluginParameter

func (p *PluginAPIDetal) GetParameters() (v []*PluginParameter) {
	if !p.IsSetParameters() {
		return PluginAPIDetal_Parameters_DEFAULT
	}
	return p.Parameters
}

var PluginAPIDetal_PluginID_DEFAULT int64

func (p *PluginAPIDetal) GetPluginID() (v int64) {
	if !p.IsSetPluginID() {
		return PluginAPIDetal_PluginID_DEFAULT
	}
	return *p.PluginID
}

var fieldIDToName_PluginAPIDetal = map[int16]string{
	1: "id",
	2: "name",
	3: "description",
	4: "parameters",
	5: "plugin_id",
}

func (p *PluginAPIDetal) IsSetID() bool {
	return p.ID != nil
}

func (p *PluginAPIDetal) IsSetName() bool {
	return p.Name != nil
}

func (p *PluginAPIDetal) IsSetDescription() bool {
	return p.Description != nil
}

func (p *PluginAPIDetal) IsSetParameters() bool {
	return p.Parameters != nil
}

func (p *PluginAPIDetal) IsSetPluginID() bool {
	return p.PluginID != nil
}

func (p *PluginAPIDetal) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PluginAPIDetal[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PluginAPIDetal) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ID = _field
	return nil
}
func (p *PluginAPIDetal) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *PluginAPIDetal) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Description = _field
	return nil
}
func (p *PluginAPIDetal) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*PluginParameter, 0, size)
	values := make([]PluginParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Parameters = _field
	return nil
}
func (p *PluginAPIDetal) ReadField5(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PluginID = _field
	return nil
}

func (p *PluginAPIDetal) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PluginAPIDetal"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PluginAPIDetal) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetID() {
		if err = oprot.WriteFieldBegin("id", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PluginAPIDetal) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PluginAPIDetal) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetDescription() {
		if err = oprot.WriteFieldBegin("description", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Description); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PluginAPIDetal) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetParameters() {
		if err = oprot.WriteFieldBegin("parameters", thrift.LIST, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Parameters)); err != nil {
			return err
		}
		for _, v := range p.Parameters {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PluginAPIDetal) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginID() {
		if err = oprot.WriteFieldBegin("plugin_id", thrift.I64, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.PluginID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *PluginAPIDetal) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PluginAPIDetal(%+v)", *p)

}

type PluginParameter struct {
	Name          *string            `thrift:"name,1,optional" form:"name" json:"name,omitempty" query:"name"`
	Description   *string            `thrift:"description,2,optional" form:"description" json:"description,omitempty" query:"description"`
	IsRequired    *bool              `thrift:"is_required,3,optional" form:"is_required" json:"is_required,omitempty" query:"is_required"`
	Type          *string            `thrift:"type,4,optional" form:"type" json:"type,omitempty" query:"type"`
	SubParameters []*PluginParameter `thrift:"sub_parameters,5,optional" form:"sub_parameters" json:"sub_parameters,omitempty" query:"sub_parameters"`
	// If Type is an array, there is a subtype
	SubType    *string `thrift:"sub_type,6,optional" form:"sub_type" json:"sub_type,omitempty" query:"sub_type"`
	AssistType *int64  `thrift:"assist_type,7,optional" form:"assist_type" json:"assist_type,omitempty" query:"assist_type"`
}

func NewPluginParameter() *PluginParameter {
	return &PluginParameter{}
}

func (p *PluginParameter) InitDefault() {
}

var PluginParameter_Name_DEFAULT string

func (p *PluginParameter) GetName() (v string) {
	if !p.IsSetName() {
		return PluginParameter_Name_DEFAULT
	}
	return *p.Name
}

var PluginParameter_Description_DEFAULT string

func (p *PluginParameter) GetDescription() (v string) {
	if !p.IsSetDescription() {
		return PluginParameter_Description_DEFAULT
	}
	return *p.Description
}

var PluginParameter_IsRequired_DEFAULT bool

func (p *PluginParameter) GetIsRequired() (v bool) {
	if !p.IsSetIsRequired() {
		return PluginParameter_IsRequired_DEFAULT
	}
	return *p.IsRequired
}

var PluginParameter_Type_DEFAULT string

func (p *PluginParameter) GetType() (v string) {
	if !p.IsSetType() {
		return PluginParameter_Type_DEFAULT
	}
	return *p.Type
}

var PluginParameter_SubParameters_DEFAULT []*PluginParameter

func (p *PluginParameter) GetSubParameters() (v []*PluginParameter) {
	if !p.IsSetSubParameters() {
		return PluginParameter_SubParameters_DEFAULT
	}
	return p.SubParameters
}

var PluginParameter_SubType_DEFAULT string

func (p *PluginParameter) GetSubType() (v string) {
	if !p.IsSetSubType() {
		return PluginParameter_SubType_DEFAULT
	}
	return *p.SubType
}

var PluginParameter_AssistType_DEFAULT int64

func (p *PluginParameter) GetAssistType() (v int64) {
	if !p.IsSetAssistType() {
		return PluginParameter_AssistType_DEFAULT
	}
	return *p.AssistType
}

var fieldIDToName_PluginParameter = map[int16]string{
	1: "name",
	2: "description",
	3: "is_required",
	4: "type",
	5: "sub_parameters",
	6: "sub_type",
	7: "assist_type",
}

func (p *PluginParameter) IsSetName() bool {
	return p.Name != nil
}

func (p *PluginParameter) IsSetDescription() bool {
	return p.Description != nil
}

func (p *PluginParameter) IsSetIsRequired() bool {
	return p.IsRequired != nil
}

func (p *PluginParameter) IsSetType() bool {
	return p.Type != nil
}

func (p *PluginParameter) IsSetSubParameters() bool {
	return p.SubParameters != nil
}

func (p *PluginParameter) IsSetSubType() bool {
	return p.SubType != nil
}

func (p *PluginParameter) IsSetAssistType() bool {
	return p.AssistType != nil
}

func (p *PluginParameter) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PluginParameter[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PluginParameter) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *PluginParameter) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Description = _field
	return nil
}
func (p *PluginParameter) ReadField3(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsRequired = _field
	return nil
}
func (p *PluginParameter) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Type = _field
	return nil
}
func (p *PluginParameter) ReadField5(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*PluginParameter, 0, size)
	values := make([]PluginParameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubParameters = _field
	return nil
}
func (p *PluginParameter) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SubType = _field
	return nil
}
func (p *PluginParameter) ReadField7(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.AssistType = _field
	return nil
}

func (p *PluginParameter) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PluginParameter"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PluginParameter) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PluginParameter) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetDescription() {
		if err = oprot.WriteFieldBegin("description", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Description); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PluginParameter) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsRequired() {
		if err = oprot.WriteFieldBegin("is_required", thrift.BOOL, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsRequired); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PluginParameter) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetType() {
		if err = oprot.WriteFieldBegin("type", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Type); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PluginParameter) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubParameters() {
		if err = oprot.WriteFieldBegin("sub_parameters", thrift.LIST, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.SubParameters)); err != nil {
			return err
		}
		for _, v := range p.SubParameters {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PluginParameter) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubType() {
		if err = oprot.WriteFieldBegin("sub_type", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SubType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PluginParameter) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetAssistType() {
		if err = oprot.WriteFieldBegin("assist_type", thrift.I64, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.AssistType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *PluginParameter) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PluginParameter(%+v)", *p)

}

type WorkflowDetail struct {
	ID          *int64  `thrift:"id,1,optional" form:"id" json:"id,string,omitempty" query:"id"`
	Name        *string `thrift:"name,2,optional" form:"name" json:"name,omitempty" query:"name"`
	Description *string `thrift:"description,3,optional" form:"description" json:"description,omitempty" query:"description"`
	IconURL     *string `thrift:"icon_url,4,optional" form:"icon_url" json:"icon_url,omitempty" query:"icon_url"`
	Status      *int64  `thrift:"status,5,optional" form:"status" json:"status,omitempty" query:"status"`
	// Type 1: Official Template
	Type *int64 `thrift:"type,6,optional" form:"type" json:"type,omitempty" query:"type"`
	// Plugin ID corresponding to workfklow
	PluginID   *int64          `thrift:"plugin_id,7,optional" form:"plugin_id" json:"plugin_id,string,omitempty" query:"plugin_id"`
	IsOfficial *bool           `thrift:"is_official,8,optional" form:"is_official" json:"is_official,omitempty" query:"is_official"`
	APIDetail  *PluginAPIDetal `thrift:"api_detail,9,optional" form:"api_detail" json:"api_detail,omitempty" query:"api_detail"`
}

func NewWorkflowDetail() *WorkflowDetail {
	return &WorkflowDetail{}
}

func (p *WorkflowDetail) InitDefault() {
}

var WorkflowDetail_ID_DEFAULT int64

func (p *WorkflowDetail) GetID() (v int64) {
	if !p.IsSetID() {
		return WorkflowDetail_ID_DEFAULT
	}
	return *p.ID
}

var WorkflowDetail_Name_DEFAULT string

func (p *WorkflowDetail) GetName() (v string) {
	if !p.IsSetName() {
		return WorkflowDetail_Name_DEFAULT
	}
	return *p.Name
}

var WorkflowDetail_Description_DEFAULT string

func (p *WorkflowDetail) GetDescription() (v string) {
	if !p.IsSetDescription() {
		return WorkflowDetail_Description_DEFAULT
	}
	return *p.Description
}

var WorkflowDetail_IconURL_DEFAULT string

func (p *WorkflowDetail) GetIconURL() (v string) {
	if !p.IsSetIconURL() {
		return WorkflowDetail_IconURL_DEFAULT
	}
	return *p.IconURL
}

var WorkflowDetail_Status_DEFAULT int64

func (p *WorkflowDetail) GetStatus() (v int64) {
	if !p.IsSetStatus() {
		return WorkflowDetail_Status_DEFAULT
	}
	return *p.Status
}

var WorkflowDetail_Type_DEFAULT int64

func (p *WorkflowDetail) GetType() (v int64) {
	if !p.IsSetType() {
		return WorkflowDetail_Type_DEFAULT
	}
	return *p.Type
}

var WorkflowDetail_PluginID_DEFAULT int64

func (p *WorkflowDetail) GetPluginID() (v int64) {
	if !p.IsSetPluginID() {
		return WorkflowDetail_PluginID_DEFAULT
	}
	return *p.PluginID
}

var WorkflowDetail_IsOfficial_DEFAULT bool

func (p *WorkflowDetail) GetIsOfficial() (v bool) {
	if !p.IsSetIsOfficial() {
		return WorkflowDetail_IsOfficial_DEFAULT
	}
	return *p.IsOfficial
}

var WorkflowDetail_APIDetail_DEFAULT *PluginAPIDetal

func (p *WorkflowDetail) GetAPIDetail() (v *PluginAPIDetal) {
	if !p.IsSetAPIDetail() {
		return WorkflowDetail_APIDetail_DEFAULT
	}
	return p.APIDetail
}

var fieldIDToName_WorkflowDetail = map[int16]string{
	1: "id",
	2: "name",
	3: "description",
	4: "icon_url",
	5: "status",
	6: "type",
	7: "plugin_id",
	8: "is_official",
	9: "api_detail",
}

func (p *WorkflowDetail) IsSetID() bool {
	return p.ID != nil
}

func (p *WorkflowDetail) IsSetName() bool {
	return p.Name != nil
}

func (p *WorkflowDetail) IsSetDescription() bool {
	return p.Description != nil
}

func (p *WorkflowDetail) IsSetIconURL() bool {
	return p.IconURL != nil
}

func (p *WorkflowDetail) IsSetStatus() bool {
	return p.Status != nil
}

func (p *WorkflowDetail) IsSetType() bool {
	return p.Type != nil
}

func (p *WorkflowDetail) IsSetPluginID() bool {
	return p.PluginID != nil
}

func (p *WorkflowDetail) IsSetIsOfficial() bool {
	return p.IsOfficial != nil
}

func (p *WorkflowDetail) IsSetAPIDetail() bool {
	return p.APIDetail != nil
}

func (p *WorkflowDetail) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowDetail[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowDetail) ReadField1(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ID = _field
	return nil
}
func (p *WorkflowDetail) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *WorkflowDetail) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Description = _field
	return nil
}
func (p *WorkflowDetail) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IconURL = _field
	return nil
}
func (p *WorkflowDetail) ReadField5(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Status = _field
	return nil
}
func (p *WorkflowDetail) ReadField6(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Type = _field
	return nil
}
func (p *WorkflowDetail) ReadField7(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PluginID = _field
	return nil
}
func (p *WorkflowDetail) ReadField8(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsOfficial = _field
	return nil
}
func (p *WorkflowDetail) ReadField9(iprot thrift.TProtocol) error {
	_field := NewPluginAPIDetal()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.APIDetail = _field
	return nil
}

func (p *WorkflowDetail) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowDetail"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowDetail) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetID() {
		if err = oprot.WriteFieldBegin("id", thrift.I64, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.ID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowDetail) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowDetail) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetDescription() {
		if err = oprot.WriteFieldBegin("description", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Description); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkflowDetail) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetIconURL() {
		if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkflowDetail) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetStatus() {
		if err = oprot.WriteFieldBegin("status", thrift.I64, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.Status); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WorkflowDetail) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetType() {
		if err = oprot.WriteFieldBegin("type", thrift.I64, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.Type); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *WorkflowDetail) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetPluginID() {
		if err = oprot.WriteFieldBegin("plugin_id", thrift.I64, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.PluginID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *WorkflowDetail) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsOfficial() {
		if err = oprot.WriteFieldBegin("is_official", thrift.BOOL, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsOfficial); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *WorkflowDetail) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetAPIDetail() {
		if err = oprot.WriteFieldBegin("api_detail", thrift.STRUCT, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.APIDetail.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}

func (p *WorkflowDetail) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowDetail(%+v)", *p)

}

type KnowledgeDetail struct {
	ID         *string     `thrift:"id,1,optional" form:"id" json:"id,omitempty" query:"id"`
	Name       *string     `thrift:"name,2,optional" form:"name" json:"name,omitempty" query:"name"`
	IconURL    *string     `thrift:"icon_url,3,optional" form:"icon_url" json:"icon_url,omitempty" query:"icon_url"`
	FormatType DataSetType `thrift:"format_type,4" form:"format_type" json:"format_type" query:"format_type"`
}

func NewKnowledgeDetail() *KnowledgeDetail {
	return &KnowledgeDetail{}
}

func (p *KnowledgeDetail) InitDefault() {
}

var KnowledgeDetail_ID_DEFAULT string

func (p *KnowledgeDetail) GetID() (v string) {
	if !p.IsSetID() {
		return KnowledgeDetail_ID_DEFAULT
	}
	return *p.ID
}

var KnowledgeDetail_Name_DEFAULT string

func (p *KnowledgeDetail) GetName() (v string) {
	if !p.IsSetName() {
		return KnowledgeDetail_Name_DEFAULT
	}
	return *p.Name
}

var KnowledgeDetail_IconURL_DEFAULT string

func (p *KnowledgeDetail) GetIconURL() (v string) {
	if !p.IsSetIconURL() {
		return KnowledgeDetail_IconURL_DEFAULT
	}
	return *p.IconURL
}

func (p *KnowledgeDetail) GetFormatType() (v DataSetType) {
	return p.FormatType
}

var fieldIDToName_KnowledgeDetail = map[int16]string{
	1: "id",
	2: "name",
	3: "icon_url",
	4: "format_type",
}

func (p *KnowledgeDetail) IsSetID() bool {
	return p.ID != nil
}

func (p *KnowledgeDetail) IsSetName() bool {
	return p.Name != nil
}

func (p *KnowledgeDetail) IsSetIconURL() bool {
	return p.IconURL != nil
}

func (p *KnowledgeDetail) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_KnowledgeDetail[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *KnowledgeDetail) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ID = _field
	return nil
}
func (p *KnowledgeDetail) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *KnowledgeDetail) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IconURL = _field
	return nil
}
func (p *KnowledgeDetail) ReadField4(iprot thrift.TProtocol) error {

	var _field DataSetType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = DataSetType(v)
	}
	p.FormatType = _field
	return nil
}

func (p *KnowledgeDetail) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("KnowledgeDetail"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *KnowledgeDetail) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetID() {
		if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *KnowledgeDetail) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *KnowledgeDetail) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetIconURL() {
		if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *KnowledgeDetail) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("format_type", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.FormatType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *KnowledgeDetail) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("KnowledgeDetail(%+v)", *p)

}

type UserInfo struct {
	// user id
	UserID int64 `thrift:"user_id,1" form:"user_id" json:"user_id,string" query:"user_id"`
	// user name
	Name string `thrift:"name,2" form:"name" json:"name" query:"name"`
	// user icon
	IconURL string `thrift:"icon_url,3" form:"icon_url" json:"icon_url" query:"icon_url"`
}

func NewUserInfo() *UserInfo {
	return &UserInfo{}
}

func (p *UserInfo) InitDefault() {
}

func (p *UserInfo) GetUserID() (v int64) {
	return p.UserID
}

func (p *UserInfo) GetName() (v string) {
	return p.Name
}

func (p *UserInfo) GetIconURL() (v string) {
	return p.IconURL
}

var fieldIDToName_UserInfo = map[int16]string{
	1: "user_id",
	2: "name",
	3: "icon_url",
}

func (p *UserInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UserInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserID = _field
	return nil
}
func (p *UserInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *UserInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}

func (p *UserInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.UserID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UserInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UserInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *UserInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserInfo(%+v)", *p)

}

type BotConnectorInfo struct {
	ID              string                 `thrift:"id,1" form:"id" json:"id" query:"id"`
	Name            string                 `thrift:"name,2" form:"name" json:"name" query:"name"`
	Icon            string                 `thrift:"icon,3" form:"icon" json:"icon" query:"icon"`
	ConnectorStatus ConnectorDynamicStatus `thrift:"connector_status,4" form:"connector_status" json:"connector_status" query:"connector_status"`
	ShareLink       *string                `thrift:"share_link,5,optional" form:"share_link" json:"share_link,omitempty" query:"share_link"`
}

func NewBotConnectorInfo() *BotConnectorInfo {
	return &BotConnectorInfo{}
}

func (p *BotConnectorInfo) InitDefault() {
}

func (p *BotConnectorInfo) GetID() (v string) {
	return p.ID
}

func (p *BotConnectorInfo) GetName() (v string) {
	return p.Name
}

func (p *BotConnectorInfo) GetIcon() (v string) {
	return p.Icon
}

func (p *BotConnectorInfo) GetConnectorStatus() (v ConnectorDynamicStatus) {
	return p.ConnectorStatus
}

var BotConnectorInfo_ShareLink_DEFAULT string

func (p *BotConnectorInfo) GetShareLink() (v string) {
	if !p.IsSetShareLink() {
		return BotConnectorInfo_ShareLink_DEFAULT
	}
	return *p.ShareLink
}

var fieldIDToName_BotConnectorInfo = map[int16]string{
	1: "id",
	2: "name",
	3: "icon",
	4: "connector_status",
	5: "share_link",
}

func (p *BotConnectorInfo) IsSetShareLink() bool {
	return p.ShareLink != nil
}

func (p *BotConnectorInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotConnectorInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotConnectorInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *BotConnectorInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *BotConnectorInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}
func (p *BotConnectorInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field ConnectorDynamicStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ConnectorDynamicStatus(v)
	}
	p.ConnectorStatus = _field
	return nil
}
func (p *BotConnectorInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ShareLink = _field
	return nil
}

func (p *BotConnectorInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotConnectorInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotConnectorInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotConnectorInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotConnectorInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotConnectorInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connector_status", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ConnectorStatus)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *BotConnectorInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetShareLink() {
		if err = oprot.WriteFieldBegin("share_link", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ShareLink); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *BotConnectorInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotConnectorInfo(%+v)", *p)

}

type BotCollaboratorStatus struct {
	// Can the current user submit?
	Commitable bool `thrift:"commitable,1" form:"commitable" json:"commitable" query:"commitable"`
	// Is the current user operable?
	Operateable bool `thrift:"operateable,2" form:"operateable" json:"operateable" query:"operateable"`
	// Can the current user manage collaborators?
	Manageable bool `thrift:"manageable,3" form:"manageable" json:"manageable" query:"manageable"`
}

func NewBotCollaboratorStatus() *BotCollaboratorStatus {
	return &BotCollaboratorStatus{}
}

func (p *BotCollaboratorStatus) InitDefault() {
}

func (p *BotCollaboratorStatus) GetCommitable() (v bool) {
	return p.Commitable
}

func (p *BotCollaboratorStatus) GetOperateable() (v bool) {
	return p.Operateable
}

func (p *BotCollaboratorStatus) GetManageable() (v bool) {
	return p.Manageable
}

var fieldIDToName_BotCollaboratorStatus = map[int16]string{
	1: "commitable",
	2: "operateable",
	3: "manageable",
}

func (p *BotCollaboratorStatus) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotCollaboratorStatus[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotCollaboratorStatus) ReadField1(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Commitable = _field
	return nil
}
func (p *BotCollaboratorStatus) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Operateable = _field
	return nil
}
func (p *BotCollaboratorStatus) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Manageable = _field
	return nil
}

func (p *BotCollaboratorStatus) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotCollaboratorStatus"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotCollaboratorStatus) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("commitable", thrift.BOOL, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Commitable); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotCollaboratorStatus) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("operateable", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Operateable); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotCollaboratorStatus) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("manageable", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Manageable); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *BotCollaboratorStatus) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotCollaboratorStatus(%+v)", *p)

}

type AuditInfo struct {
	AuditStatus   *AuditStatus `thrift:"audit_status,1,optional" form:"audit_status" json:"audit_status,omitempty" query:"audit_status"`
	PublishID     *string      `thrift:"publish_id,2,optional" form:"publish_id" json:"publish_id,omitempty" query:"publish_id"`
	CommitVersion *string      `thrift:"commit_version,3,optional" form:"commit_version" json:"commit_version,omitempty" query:"commit_version"`
}

func NewAuditInfo() *AuditInfo {
	return &AuditInfo{}
}

func (p *AuditInfo) InitDefault() {
}

var AuditInfo_AuditStatus_DEFAULT AuditStatus

func (p *AuditInfo) GetAuditStatus() (v AuditStatus) {
	if !p.IsSetAuditStatus() {
		return AuditInfo_AuditStatus_DEFAULT
	}
	return *p.AuditStatus
}

var AuditInfo_PublishID_DEFAULT string

func (p *AuditInfo) GetPublishID() (v string) {
	if !p.IsSetPublishID() {
		return AuditInfo_PublishID_DEFAULT
	}
	return *p.PublishID
}

var AuditInfo_CommitVersion_DEFAULT string

func (p *AuditInfo) GetCommitVersion() (v string) {
	if !p.IsSetCommitVersion() {
		return AuditInfo_CommitVersion_DEFAULT
	}
	return *p.CommitVersion
}

var fieldIDToName_AuditInfo = map[int16]string{
	1: "audit_status",
	2: "publish_id",
	3: "commit_version",
}

func (p *AuditInfo) IsSetAuditStatus() bool {
	return p.AuditStatus != nil
}

func (p *AuditInfo) IsSetPublishID() bool {
	return p.PublishID != nil
}

func (p *AuditInfo) IsSetCommitVersion() bool {
	return p.CommitVersion != nil
}

func (p *AuditInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_AuditInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *AuditInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field *AuditStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := AuditStatus(v)
		_field = &tmp
	}
	p.AuditStatus = _field
	return nil
}
func (p *AuditInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PublishID = _field
	return nil
}
func (p *AuditInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitVersion = _field
	return nil
}

func (p *AuditInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("AuditInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *AuditInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetAuditStatus() {
		if err = oprot.WriteFieldBegin("audit_status", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.AuditStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *AuditInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishID() {
		if err = oprot.WriteFieldBegin("publish_id", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PublishID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *AuditInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitVersion() {
		if err = oprot.WriteFieldBegin("commit_version", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *AuditInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AuditInfo(%+v)", *p)

}

type AuditResult struct {
	AuditStatus  AuditStatus `thrift:"AuditStatus,1" form:"AuditStatus" json:"AuditStatus" query:"AuditStatus"`
	AuditMessage string      `thrift:"AuditMessage,2" form:"AuditMessage" json:"AuditMessage" query:"AuditMessage"`
}

func NewAuditResult() *AuditResult {
	return &AuditResult{}
}

func (p *AuditResult) InitDefault() {
}

func (p *AuditResult) GetAuditStatus() (v AuditStatus) {
	return p.AuditStatus
}

func (p *AuditResult) GetAuditMessage() (v string) {
	return p.AuditMessage
}

var fieldIDToName_AuditResult = map[int16]string{
	1: "AuditStatus",
	2: "AuditMessage",
}

func (p *AuditResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_AuditResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *AuditResult) ReadField1(iprot thrift.TProtocol) error {

	var _field AuditStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = AuditStatus(v)
	}
	p.AuditStatus = _field
	return nil
}
func (p *AuditResult) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AuditMessage = _field
	return nil
}

func (p *AuditResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("AuditResult"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *AuditResult) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("AuditStatus", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.AuditStatus)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *AuditResult) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("AuditMessage", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AuditMessage); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *AuditResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AuditResult(%+v)", *p)

}

// Onboarding json structure
type OnboardingContent struct {
	// Introductory remarks (C-end usage scenarios, only 1; background scenarios, possibly multiple)
	Prologue *string `thrift:"prologue,1,optional" form:"prologue" json:"prologue,omitempty" query:"prologue"`
	// suggestion question
	SuggestedQuestions         []string                               `thrift:"suggested_questions,2,optional" form:"suggested_questions" json:"suggested_questions,omitempty" query:"suggested_questions"`
	SuggestedQuestionsShowMode *bot_common.SuggestedQuestionsShowMode `thrift:"suggested_questions_show_mode,3,optional" form:"suggested_questions_show_mode" json:"suggested_questions_show_mode,omitempty" query:"suggested_questions_show_mode"`
}

func NewOnboardingContent() *OnboardingContent {
	return &OnboardingContent{}
}

func (p *OnboardingContent) InitDefault() {
}

var OnboardingContent_Prologue_DEFAULT string

func (p *OnboardingContent) GetPrologue() (v string) {
	if !p.IsSetPrologue() {
		return OnboardingContent_Prologue_DEFAULT
	}
	return *p.Prologue
}

var OnboardingContent_SuggestedQuestions_DEFAULT []string

func (p *OnboardingContent) GetSuggestedQuestions() (v []string) {
	if !p.IsSetSuggestedQuestions() {
		return OnboardingContent_SuggestedQuestions_DEFAULT
	}
	return p.SuggestedQuestions
}

var OnboardingContent_SuggestedQuestionsShowMode_DEFAULT bot_common.SuggestedQuestionsShowMode

func (p *OnboardingContent) GetSuggestedQuestionsShowMode() (v bot_common.SuggestedQuestionsShowMode) {
	if !p.IsSetSuggestedQuestionsShowMode() {
		return OnboardingContent_SuggestedQuestionsShowMode_DEFAULT
	}
	return *p.SuggestedQuestionsShowMode
}

var fieldIDToName_OnboardingContent = map[int16]string{
	1: "prologue",
	2: "suggested_questions",
	3: "suggested_questions_show_mode",
}

func (p *OnboardingContent) IsSetPrologue() bool {
	return p.Prologue != nil
}

func (p *OnboardingContent) IsSetSuggestedQuestions() bool {
	return p.SuggestedQuestions != nil
}

func (p *OnboardingContent) IsSetSuggestedQuestionsShowMode() bool {
	return p.SuggestedQuestionsShowMode != nil
}

func (p *OnboardingContent) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_OnboardingContent[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *OnboardingContent) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Prologue = _field
	return nil
}
func (p *OnboardingContent) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SuggestedQuestions = _field
	return nil
}
func (p *OnboardingContent) ReadField3(iprot thrift.TProtocol) error {

	var _field *bot_common.SuggestedQuestionsShowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := bot_common.SuggestedQuestionsShowMode(v)
		_field = &tmp
	}
	p.SuggestedQuestionsShowMode = _field
	return nil
}

func (p *OnboardingContent) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OnboardingContent"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *OnboardingContent) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPrologue() {
		if err = oprot.WriteFieldBegin("prologue", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Prologue); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *OnboardingContent) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuggestedQuestions() {
		if err = oprot.WriteFieldBegin("suggested_questions", thrift.LIST, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.SuggestedQuestions)); err != nil {
			return err
		}
		for _, v := range p.SuggestedQuestions {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *OnboardingContent) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuggestedQuestionsShowMode() {
		if err = oprot.WriteFieldBegin("suggested_questions_show_mode", thrift.I32, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.SuggestedQuestionsShowMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *OnboardingContent) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("OnboardingContent(%+v)", *p)

}

type GetSpaceListV2Request struct {
	// Search term
	SearchWord *string `thrift:"search_word,1,optional" form:"search_word" json:"search_word,omitempty" query:"search_word"`
	// Enterprise ID
	EnterpriseID *int64 `thrift:"enterprise_id,2,optional" form:"enterprise_id" json:"enterprise_id,string,omitempty" query:"enterprise_id"`
	// organization id
	OrganizationID *int64 `thrift:"organization_id,3,optional" form:"organization_id" json:"organization_id,string,omitempty" query:"organization_id"`
	// range type
	ScopeType *ScopeType `thrift:"scope_type,4,optional" form:"scope_type" json:"scope_type,omitempty" query:"scope_type"`
	// paging information
	Page *int32 `thrift:"page,5,optional" form:"page" json:"page,omitempty" query:"page"`
	// Paging size -- if page and size are not passed on, it is considered not paging
	Size *int32     `thrift:"size,6,optional" form:"size" json:"size,omitempty" query:"size"`
	Base *base.Base `thrift:"Base,255,optional" form:"-" json:"-" query:"-"`
}

func NewGetSpaceListV2Request() *GetSpaceListV2Request {
	return &GetSpaceListV2Request{}
}

func (p *GetSpaceListV2Request) InitDefault() {
}

var GetSpaceListV2Request_SearchWord_DEFAULT string

func (p *GetSpaceListV2Request) GetSearchWord() (v string) {
	if !p.IsSetSearchWord() {
		return GetSpaceListV2Request_SearchWord_DEFAULT
	}
	return *p.SearchWord
}

var GetSpaceListV2Request_EnterpriseID_DEFAULT int64

func (p *GetSpaceListV2Request) GetEnterpriseID() (v int64) {
	if !p.IsSetEnterpriseID() {
		return GetSpaceListV2Request_EnterpriseID_DEFAULT
	}
	return *p.EnterpriseID
}

var GetSpaceListV2Request_OrganizationID_DEFAULT int64

func (p *GetSpaceListV2Request) GetOrganizationID() (v int64) {
	if !p.IsSetOrganizationID() {
		return GetSpaceListV2Request_OrganizationID_DEFAULT
	}
	return *p.OrganizationID
}

var GetSpaceListV2Request_ScopeType_DEFAULT ScopeType

func (p *GetSpaceListV2Request) GetScopeType() (v ScopeType) {
	if !p.IsSetScopeType() {
		return GetSpaceListV2Request_ScopeType_DEFAULT
	}
	return *p.ScopeType
}

var GetSpaceListV2Request_Page_DEFAULT int32

func (p *GetSpaceListV2Request) GetPage() (v int32) {
	if !p.IsSetPage() {
		return GetSpaceListV2Request_Page_DEFAULT
	}
	return *p.Page
}

var GetSpaceListV2Request_Size_DEFAULT int32

func (p *GetSpaceListV2Request) GetSize() (v int32) {
	if !p.IsSetSize() {
		return GetSpaceListV2Request_Size_DEFAULT
	}
	return *p.Size
}

var GetSpaceListV2Request_Base_DEFAULT *base.Base

func (p *GetSpaceListV2Request) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetSpaceListV2Request_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetSpaceListV2Request = map[int16]string{
	1:   "search_word",
	2:   "enterprise_id",
	3:   "organization_id",
	4:   "scope_type",
	5:   "page",
	6:   "size",
	255: "Base",
}

func (p *GetSpaceListV2Request) IsSetSearchWord() bool {
	return p.SearchWord != nil
}

func (p *GetSpaceListV2Request) IsSetEnterpriseID() bool {
	return p.EnterpriseID != nil
}

func (p *GetSpaceListV2Request) IsSetOrganizationID() bool {
	return p.OrganizationID != nil
}

func (p *GetSpaceListV2Request) IsSetScopeType() bool {
	return p.ScopeType != nil
}

func (p *GetSpaceListV2Request) IsSetPage() bool {
	return p.Page != nil
}

func (p *GetSpaceListV2Request) IsSetSize() bool {
	return p.Size != nil
}

func (p *GetSpaceListV2Request) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetSpaceListV2Request) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetSpaceListV2Request[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetSpaceListV2Request) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SearchWord = _field
	return nil
}
func (p *GetSpaceListV2Request) ReadField2(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EnterpriseID = _field
	return nil
}
func (p *GetSpaceListV2Request) ReadField3(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OrganizationID = _field
	return nil
}
func (p *GetSpaceListV2Request) ReadField4(iprot thrift.TProtocol) error {

	var _field *ScopeType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := ScopeType(v)
		_field = &tmp
	}
	p.ScopeType = _field
	return nil
}
func (p *GetSpaceListV2Request) ReadField5(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Page = _field
	return nil
}
func (p *GetSpaceListV2Request) ReadField6(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Size = _field
	return nil
}
func (p *GetSpaceListV2Request) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetSpaceListV2Request) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetSpaceListV2Request"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetSpaceListV2Request) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetSearchWord() {
		if err = oprot.WriteFieldBegin("search_word", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SearchWord); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetSpaceListV2Request) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetEnterpriseID() {
		if err = oprot.WriteFieldBegin("enterprise_id", thrift.I64, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.EnterpriseID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetSpaceListV2Request) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetOrganizationID() {
		if err = oprot.WriteFieldBegin("organization_id", thrift.I64, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.OrganizationID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetSpaceListV2Request) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetScopeType() {
		if err = oprot.WriteFieldBegin("scope_type", thrift.I32, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.ScopeType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetSpaceListV2Request) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetPage() {
		if err = oprot.WriteFieldBegin("page", thrift.I32, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Page); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetSpaceListV2Request) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetSize() {
		if err = oprot.WriteFieldBegin("size", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Size); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetSpaceListV2Request) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetSpaceListV2Request) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetSpaceListV2Request(%+v)", *p)

}

type AppIDInfo struct {
	ID   string `thrift:"id,1" form:"id" json:"id" query:"id"`
	Name string `thrift:"name,2" form:"name" json:"name" query:"name"`
	Icon string `thrift:"icon,3" form:"icon" json:"icon" query:"icon"`
}

func NewAppIDInfo() *AppIDInfo {
	return &AppIDInfo{}
}

func (p *AppIDInfo) InitDefault() {
}

func (p *AppIDInfo) GetID() (v string) {
	return p.ID
}

func (p *AppIDInfo) GetName() (v string) {
	return p.Name
}

func (p *AppIDInfo) GetIcon() (v string) {
	return p.Icon
}

var fieldIDToName_AppIDInfo = map[int16]string{
	1: "id",
	2: "name",
	3: "icon",
}

func (p *AppIDInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_AppIDInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *AppIDInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *AppIDInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *AppIDInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}

func (p *AppIDInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("AppIDInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *AppIDInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *AppIDInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *AppIDInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *AppIDInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("AppIDInfo(%+v)", *p)

}

type ConnectorInfo struct {
	ID   string `thrift:"id,1" form:"id" json:"id" query:"id"`
	Name string `thrift:"name,2" form:"name" json:"name" query:"name"`
	Icon string `thrift:"icon,3" form:"icon" json:"icon" query:"icon"`
}

func NewConnectorInfo() *ConnectorInfo {
	return &ConnectorInfo{}
}

func (p *ConnectorInfo) InitDefault() {
}

func (p *ConnectorInfo) GetID() (v string) {
	return p.ID
}

func (p *ConnectorInfo) GetName() (v string) {
	return p.Name
}

func (p *ConnectorInfo) GetIcon() (v string) {
	return p.Icon
}

var fieldIDToName_ConnectorInfo = map[int16]string{
	1: "id",
	2: "name",
	3: "icon",
}

func (p *ConnectorInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ConnectorInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ConnectorInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *ConnectorInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ConnectorInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}

func (p *ConnectorInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ConnectorInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ConnectorInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ConnectorInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ConnectorInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *ConnectorInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ConnectorInfo(%+v)", *p)

}

type BotSpaceV2 struct {
	// Space id, newly created as 0
	ID int64 `thrift:"id,1" form:"id" json:"id,string" query:"id"`
	// publishing platform
	AppIds []*AppIDInfo `thrift:"app_ids,2" form:"app_ids" json:"app_ids" query:"app_ids"`
	// space name
	Name string `thrift:"name,3" form:"name" json:"name" query:"name"`
	// spatial description
	Description string `thrift:"description,4" form:"description" json:"description" query:"description"`
	// icon url
	IconURL string `thrift:"icon_url,5" form:"icon_url" json:"icon_url" query:"icon_url"`
	// space type
	SpaceType SpaceType `thrift:"space_type,6" form:"space_type" json:"space_type" query:"space_type"`
	// publishing platform
	Connectors []*ConnectorInfo `thrift:"connectors,7" form:"connectors" json:"connectors" query:"connectors"`
	// Whether to hide New, Copy Delete buttons
	HideOperation bool `thrift:"hide_operation,8" form:"hide_operation" json:"hide_operation" query:"hide_operation"`
	// Role in team 1-owner 2-admin 3-member
	RoleType int32 `thrift:"role_type,9" form:"role_type" json:"role_type" query:"role_type"`
	// Spatial Mode
	SpaceMode *SpaceMode `thrift:"space_mode,10,optional" form:"space_mode" json:"space_mode,omitempty" query:"space_mode"`
	// Whether to display the end-side plug-in creation entry
	DisplayLocalPlugin bool `thrift:"display_local_plugin,11" form:"display_local_plugin" json:"display_local_plugin" query:"display_local_plugin"`
	// Role type, enumeration
	SpaceRoleType SpaceRoleType `thrift:"space_role_type,12" form:"space_role_type" json:"space_role_type" query:"space_role_type"`
	// spatial label
	SpaceTag *SpaceTag `thrift:"space_tag,13,optional" form:"space_tag" json:"space_tag,omitempty" query:"space_tag"`
	// Enterprise ID
	EnterpriseID *int64 `thrift:"enterprise_id,14,optional" form:"enterprise_id" json:"enterprise_id,string,omitempty" query:"enterprise_id"`
	// organization id
	OrganizationID *int64 `thrift:"organization_id,15,optional" form:"organization_id" json:"organization_id,string,omitempty" query:"organization_id"`
	// Space owner uid
	OwnerUserID *int64 `thrift:"owner_user_id,16,optional" form:"owner_user_id" json:"owner_user_id,string,omitempty" query:"owner_user_id"`
	// Space owner nickname
	OwnerName *string `thrift:"owner_name,17,optional" form:"owner_name" json:"owner_name,omitempty" query:"owner_name"`
	// Space owner username
	OwnerUserName *string `thrift:"owner_user_name,18,optional" form:"owner_user_name" json:"owner_user_name,omitempty" query:"owner_user_name"`
	// Space owner image
	OwnerIconURL *string `thrift:"owner_icon_url,19,optional" form:"owner_icon_url" json:"owner_icon_url,omitempty" query:"owner_icon_url"`
	// The current visiting user joins the space status
	SpaceApplyStatus *SpaceApplyStatus `thrift:"space_apply_status,20,optional" form:"space_apply_status" json:"space_apply_status,omitempty" query:"space_apply_status"`
	// The total number of space members, only the organization space can be queried.
	TotalMemberNum *int64 `thrift:"total_member_num,21,optional" form:"total_member_num" json:"total_member_num,omitempty" query:"total_member_num"`
}

func NewBotSpaceV2() *BotSpaceV2 {
	return &BotSpaceV2{}
}

func (p *BotSpaceV2) InitDefault() {
}

func (p *BotSpaceV2) GetID() (v int64) {
	return p.ID
}

func (p *BotSpaceV2) GetAppIds() (v []*AppIDInfo) {
	return p.AppIds
}

func (p *BotSpaceV2) GetName() (v string) {
	return p.Name
}

func (p *BotSpaceV2) GetDescription() (v string) {
	return p.Description
}

func (p *BotSpaceV2) GetIconURL() (v string) {
	return p.IconURL
}

func (p *BotSpaceV2) GetSpaceType() (v SpaceType) {
	return p.SpaceType
}

func (p *BotSpaceV2) GetConnectors() (v []*ConnectorInfo) {
	return p.Connectors
}

func (p *BotSpaceV2) GetHideOperation() (v bool) {
	return p.HideOperation
}

func (p *BotSpaceV2) GetRoleType() (v int32) {
	return p.RoleType
}

var BotSpaceV2_SpaceMode_DEFAULT SpaceMode

func (p *BotSpaceV2) GetSpaceMode() (v SpaceMode) {
	if !p.IsSetSpaceMode() {
		return BotSpaceV2_SpaceMode_DEFAULT
	}
	return *p.SpaceMode
}

func (p *BotSpaceV2) GetDisplayLocalPlugin() (v bool) {
	return p.DisplayLocalPlugin
}

func (p *BotSpaceV2) GetSpaceRoleType() (v SpaceRoleType) {
	return p.SpaceRoleType
}

var BotSpaceV2_SpaceTag_DEFAULT SpaceTag

func (p *BotSpaceV2) GetSpaceTag() (v SpaceTag) {
	if !p.IsSetSpaceTag() {
		return BotSpaceV2_SpaceTag_DEFAULT
	}
	return *p.SpaceTag
}

var BotSpaceV2_EnterpriseID_DEFAULT int64

func (p *BotSpaceV2) GetEnterpriseID() (v int64) {
	if !p.IsSetEnterpriseID() {
		return BotSpaceV2_EnterpriseID_DEFAULT
	}
	return *p.EnterpriseID
}

var BotSpaceV2_OrganizationID_DEFAULT int64

func (p *BotSpaceV2) GetOrganizationID() (v int64) {
	if !p.IsSetOrganizationID() {
		return BotSpaceV2_OrganizationID_DEFAULT
	}
	return *p.OrganizationID
}

var BotSpaceV2_OwnerUserID_DEFAULT int64

func (p *BotSpaceV2) GetOwnerUserID() (v int64) {
	if !p.IsSetOwnerUserID() {
		return BotSpaceV2_OwnerUserID_DEFAULT
	}
	return *p.OwnerUserID
}

var BotSpaceV2_OwnerName_DEFAULT string

func (p *BotSpaceV2) GetOwnerName() (v string) {
	if !p.IsSetOwnerName() {
		return BotSpaceV2_OwnerName_DEFAULT
	}
	return *p.OwnerName
}

var BotSpaceV2_OwnerUserName_DEFAULT string

func (p *BotSpaceV2) GetOwnerUserName() (v string) {
	if !p.IsSetOwnerUserName() {
		return BotSpaceV2_OwnerUserName_DEFAULT
	}
	return *p.OwnerUserName
}

var BotSpaceV2_OwnerIconURL_DEFAULT string

func (p *BotSpaceV2) GetOwnerIconURL() (v string) {
	if !p.IsSetOwnerIconURL() {
		return BotSpaceV2_OwnerIconURL_DEFAULT
	}
	return *p.OwnerIconURL
}

var BotSpaceV2_SpaceApplyStatus_DEFAULT SpaceApplyStatus

func (p *BotSpaceV2) GetSpaceApplyStatus() (v SpaceApplyStatus) {
	if !p.IsSetSpaceApplyStatus() {
		return BotSpaceV2_SpaceApplyStatus_DEFAULT
	}
	return *p.SpaceApplyStatus
}

var BotSpaceV2_TotalMemberNum_DEFAULT int64

func (p *BotSpaceV2) GetTotalMemberNum() (v int64) {
	if !p.IsSetTotalMemberNum() {
		return BotSpaceV2_TotalMemberNum_DEFAULT
	}
	return *p.TotalMemberNum
}

var fieldIDToName_BotSpaceV2 = map[int16]string{
	1:  "id",
	2:  "app_ids",
	3:  "name",
	4:  "description",
	5:  "icon_url",
	6:  "space_type",
	7:  "connectors",
	8:  "hide_operation",
	9:  "role_type",
	10: "space_mode",
	11: "display_local_plugin",
	12: "space_role_type",
	13: "space_tag",
	14: "enterprise_id",
	15: "organization_id",
	16: "owner_user_id",
	17: "owner_name",
	18: "owner_user_name",
	19: "owner_icon_url",
	20: "space_apply_status",
	21: "total_member_num",
}

func (p *BotSpaceV2) IsSetSpaceMode() bool {
	return p.SpaceMode != nil
}

func (p *BotSpaceV2) IsSetSpaceTag() bool {
	return p.SpaceTag != nil
}

func (p *BotSpaceV2) IsSetEnterpriseID() bool {
	return p.EnterpriseID != nil
}

func (p *BotSpaceV2) IsSetOrganizationID() bool {
	return p.OrganizationID != nil
}

func (p *BotSpaceV2) IsSetOwnerUserID() bool {
	return p.OwnerUserID != nil
}

func (p *BotSpaceV2) IsSetOwnerName() bool {
	return p.OwnerName != nil
}

func (p *BotSpaceV2) IsSetOwnerUserName() bool {
	return p.OwnerUserName != nil
}

func (p *BotSpaceV2) IsSetOwnerIconURL() bool {
	return p.OwnerIconURL != nil
}

func (p *BotSpaceV2) IsSetSpaceApplyStatus() bool {
	return p.SpaceApplyStatus != nil
}

func (p *BotSpaceV2) IsSetTotalMemberNum() bool {
	return p.TotalMemberNum != nil
}

func (p *BotSpaceV2) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotSpaceV2[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *BotSpaceV2) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *BotSpaceV2) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*AppIDInfo, 0, size)
	values := make([]AppIDInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.AppIds = _field
	return nil
}
func (p *BotSpaceV2) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *BotSpaceV2) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Description = _field
	return nil
}
func (p *BotSpaceV2) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *BotSpaceV2) ReadField6(iprot thrift.TProtocol) error {

	var _field SpaceType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = SpaceType(v)
	}
	p.SpaceType = _field
	return nil
}
func (p *BotSpaceV2) ReadField7(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ConnectorInfo, 0, size)
	values := make([]ConnectorInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Connectors = _field
	return nil
}
func (p *BotSpaceV2) ReadField8(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.HideOperation = _field
	return nil
}
func (p *BotSpaceV2) ReadField9(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.RoleType = _field
	return nil
}
func (p *BotSpaceV2) ReadField10(iprot thrift.TProtocol) error {

	var _field *SpaceMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := SpaceMode(v)
		_field = &tmp
	}
	p.SpaceMode = _field
	return nil
}
func (p *BotSpaceV2) ReadField11(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DisplayLocalPlugin = _field
	return nil
}
func (p *BotSpaceV2) ReadField12(iprot thrift.TProtocol) error {

	var _field SpaceRoleType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = SpaceRoleType(v)
	}
	p.SpaceRoleType = _field
	return nil
}
func (p *BotSpaceV2) ReadField13(iprot thrift.TProtocol) error {

	var _field *SpaceTag
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := SpaceTag(v)
		_field = &tmp
	}
	p.SpaceTag = _field
	return nil
}
func (p *BotSpaceV2) ReadField14(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.EnterpriseID = _field
	return nil
}
func (p *BotSpaceV2) ReadField15(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OrganizationID = _field
	return nil
}
func (p *BotSpaceV2) ReadField16(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OwnerUserID = _field
	return nil
}
func (p *BotSpaceV2) ReadField17(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OwnerName = _field
	return nil
}
func (p *BotSpaceV2) ReadField18(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OwnerUserName = _field
	return nil
}
func (p *BotSpaceV2) ReadField19(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OwnerIconURL = _field
	return nil
}
func (p *BotSpaceV2) ReadField20(iprot thrift.TProtocol) error {

	var _field *SpaceApplyStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := SpaceApplyStatus(v)
		_field = &tmp
	}
	p.SpaceApplyStatus = _field
	return nil
}
func (p *BotSpaceV2) ReadField21(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TotalMemberNum = _field
	return nil
}

func (p *BotSpaceV2) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotSpaceV2"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotSpaceV2) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BotSpaceV2) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("app_ids", thrift.LIST, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.AppIds)); err != nil {
		return err
	}
	for _, v := range p.AppIds {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BotSpaceV2) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BotSpaceV2) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("description", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Description); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *BotSpaceV2) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *BotSpaceV2) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_type", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SpaceType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *BotSpaceV2) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("connectors", thrift.LIST, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.Connectors)); err != nil {
		return err
	}
	for _, v := range p.Connectors {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *BotSpaceV2) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("hide_operation", thrift.BOOL, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.HideOperation); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *BotSpaceV2) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("role_type", thrift.I32, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.RoleType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *BotSpaceV2) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceMode() {
		if err = oprot.WriteFieldBegin("space_mode", thrift.I32, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.SpaceMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *BotSpaceV2) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("display_local_plugin", thrift.BOOL, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.DisplayLocalPlugin); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *BotSpaceV2) writeField12(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_role_type", thrift.I32, 12); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SpaceRoleType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *BotSpaceV2) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceTag() {
		if err = oprot.WriteFieldBegin("space_tag", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.SpaceTag)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *BotSpaceV2) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetEnterpriseID() {
		if err = oprot.WriteFieldBegin("enterprise_id", thrift.I64, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.EnterpriseID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *BotSpaceV2) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetOrganizationID() {
		if err = oprot.WriteFieldBegin("organization_id", thrift.I64, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.OrganizationID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *BotSpaceV2) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetOwnerUserID() {
		if err = oprot.WriteFieldBegin("owner_user_id", thrift.I64, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.OwnerUserID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *BotSpaceV2) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetOwnerName() {
		if err = oprot.WriteFieldBegin("owner_name", thrift.STRING, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.OwnerName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *BotSpaceV2) writeField18(oprot thrift.TProtocol) (err error) {
	if p.IsSetOwnerUserName() {
		if err = oprot.WriteFieldBegin("owner_user_name", thrift.STRING, 18); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.OwnerUserName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *BotSpaceV2) writeField19(oprot thrift.TProtocol) (err error) {
	if p.IsSetOwnerIconURL() {
		if err = oprot.WriteFieldBegin("owner_icon_url", thrift.STRING, 19); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.OwnerIconURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *BotSpaceV2) writeField20(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceApplyStatus() {
		if err = oprot.WriteFieldBegin("space_apply_status", thrift.I32, 20); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.SpaceApplyStatus)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}
func (p *BotSpaceV2) writeField21(oprot thrift.TProtocol) (err error) {
	if p.IsSetTotalMemberNum() {
		if err = oprot.WriteFieldBegin("total_member_num", thrift.I64, 21); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.TotalMemberNum); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}

func (p *BotSpaceV2) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotSpaceV2(%+v)", *p)

}

type SpaceInfo struct {
	// User joins space list
	BotSpaceList []*BotSpaceV2 `thrift:"bot_space_list,1" form:"bot_space_list" json:"bot_space_list" query:"bot_space_list"`
	// Is there any personal space available?
	HasPersonalSpace bool `thrift:"has_personal_space,2" form:"has_personal_space" json:"has_personal_space" query:"has_personal_space"`
	// Number of team spaces created by individuals
	TeamSpaceNum int32 `thrift:"team_space_num,3" form:"team_space_num" json:"team_space_num" query:"team_space_num"`
	// The maximum number of spaces an individual can create
	MaxTeamSpaceNum int32 `thrift:"max_team_space_num,4" form:"max_team_space_num" json:"max_team_space_num" query:"max_team_space_num"`
	// list of recently used spaces
	RecentlyUsedSpaceList []*BotSpaceV2 `thrift:"recently_used_space_list,5" form:"recently_used_space_list" json:"recently_used_space_list" query:"recently_used_space_list"`
	// Effective when paging
	Total *int32 `thrift:"total,6,optional" form:"total" json:"total,omitempty" query:"total"`
	// Effective when paging
	HasMore *bool `thrift:"has_more,7,optional" form:"has_more" json:"has_more,omitempty" query:"has_more"`
}

func NewSpaceInfo() *SpaceInfo {
	return &SpaceInfo{}
}

func (p *SpaceInfo) InitDefault() {
}

func (p *SpaceInfo) GetBotSpaceList() (v []*BotSpaceV2) {
	return p.BotSpaceList
}

func (p *SpaceInfo) GetHasPersonalSpace() (v bool) {
	return p.HasPersonalSpace
}

func (p *SpaceInfo) GetTeamSpaceNum() (v int32) {
	return p.TeamSpaceNum
}

func (p *SpaceInfo) GetMaxTeamSpaceNum() (v int32) {
	return p.MaxTeamSpaceNum
}

func (p *SpaceInfo) GetRecentlyUsedSpaceList() (v []*BotSpaceV2) {
	return p.RecentlyUsedSpaceList
}

var SpaceInfo_Total_DEFAULT int32

func (p *SpaceInfo) GetTotal() (v int32) {
	if !p.IsSetTotal() {
		return SpaceInfo_Total_DEFAULT
	}
	return *p.Total
}

var SpaceInfo_HasMore_DEFAULT bool

func (p *SpaceInfo) GetHasMore() (v bool) {
	if !p.IsSetHasMore() {
		return SpaceInfo_HasMore_DEFAULT
	}
	return *p.HasMore
}

var fieldIDToName_SpaceInfo = map[int16]string{
	1: "bot_space_list",
	2: "has_personal_space",
	3: "team_space_num",
	4: "max_team_space_num",
	5: "recently_used_space_list",
	6: "total",
	7: "has_more",
}

func (p *SpaceInfo) IsSetTotal() bool {
	return p.Total != nil
}

func (p *SpaceInfo) IsSetHasMore() bool {
	return p.HasMore != nil
}

func (p *SpaceInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SpaceInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SpaceInfo) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*BotSpaceV2, 0, size)
	values := make([]BotSpaceV2, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.BotSpaceList = _field
	return nil
}
func (p *SpaceInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.HasPersonalSpace = _field
	return nil
}
func (p *SpaceInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TeamSpaceNum = _field
	return nil
}
func (p *SpaceInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.MaxTeamSpaceNum = _field
	return nil
}
func (p *SpaceInfo) ReadField5(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*BotSpaceV2, 0, size)
	values := make([]BotSpaceV2, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.RecentlyUsedSpaceList = _field
	return nil
}
func (p *SpaceInfo) ReadField6(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Total = _field
	return nil
}
func (p *SpaceInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.HasMore = _field
	return nil
}

func (p *SpaceInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SpaceInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SpaceInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_space_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.BotSpaceList)); err != nil {
		return err
	}
	for _, v := range p.BotSpaceList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SpaceInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("has_personal_space", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.HasPersonalSpace); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SpaceInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("team_space_num", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.TeamSpaceNum); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *SpaceInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("max_team_space_num", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.MaxTeamSpaceNum); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *SpaceInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("recently_used_space_list", thrift.LIST, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.RecentlyUsedSpaceList)); err != nil {
		return err
	}
	for _, v := range p.RecentlyUsedSpaceList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *SpaceInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetTotal() {
		if err = oprot.WriteFieldBegin("total", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Total); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *SpaceInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetHasMore() {
		if err = oprot.WriteFieldBegin("has_more", thrift.BOOL, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.HasMore); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *SpaceInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SpaceInfo(%+v)", *p)

}

type GetSpaceListV2Response struct {
	Data     *SpaceInfo     `thrift:"data,1" form:"data" json:"data" query:"data"`
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetSpaceListV2Response() *GetSpaceListV2Response {
	return &GetSpaceListV2Response{}
}

func (p *GetSpaceListV2Response) InitDefault() {
}

var GetSpaceListV2Response_Data_DEFAULT *SpaceInfo

func (p *GetSpaceListV2Response) GetData() (v *SpaceInfo) {
	if !p.IsSetData() {
		return GetSpaceListV2Response_Data_DEFAULT
	}
	return p.Data
}

func (p *GetSpaceListV2Response) GetCode() (v int64) {
	return p.Code
}

func (p *GetSpaceListV2Response) GetMsg() (v string) {
	return p.Msg
}

var GetSpaceListV2Response_BaseResp_DEFAULT *base.BaseResp

func (p *GetSpaceListV2Response) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetSpaceListV2Response_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetSpaceListV2Response = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetSpaceListV2Response) IsSetData() bool {
	return p.Data != nil
}

func (p *GetSpaceListV2Response) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetSpaceListV2Response) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetSpaceListV2Response[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetSpaceListV2Response[fieldId]))
}

func (p *GetSpaceListV2Response) ReadField1(iprot thrift.TProtocol) error {
	_field := NewSpaceInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetSpaceListV2Response) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetSpaceListV2Response) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetSpaceListV2Response) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetSpaceListV2Response) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetSpaceListV2Response"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetSpaceListV2Response) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetSpaceListV2Response) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetSpaceListV2Response) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetSpaceListV2Response) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetSpaceListV2Response) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetSpaceListV2Response(%+v)", *p)

}

type GetImagexShortUrlResponse struct {
	Data     *GetImagexShortUrlData `thrift:"data,1" form:"data" json:"data" query:"data"`
	Code     int64                  `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                 `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp         `thrift:"BaseResp,255,required" form:"-" json:"-" query:"-"`
}

func NewGetImagexShortUrlResponse() *GetImagexShortUrlResponse {
	return &GetImagexShortUrlResponse{}
}

func (p *GetImagexShortUrlResponse) InitDefault() {
}

var GetImagexShortUrlResponse_Data_DEFAULT *GetImagexShortUrlData

func (p *GetImagexShortUrlResponse) GetData() (v *GetImagexShortUrlData) {
	if !p.IsSetData() {
		return GetImagexShortUrlResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetImagexShortUrlResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetImagexShortUrlResponse) GetMsg() (v string) {
	return p.Msg
}

var GetImagexShortUrlResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetImagexShortUrlResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetImagexShortUrlResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetImagexShortUrlResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetImagexShortUrlResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetImagexShortUrlResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetImagexShortUrlResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetImagexShortUrlResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetImagexShortUrlResponse[fieldId]))
}

func (p *GetImagexShortUrlResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetImagexShortUrlData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetImagexShortUrlResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetImagexShortUrlResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetImagexShortUrlResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetImagexShortUrlResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetImagexShortUrlResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetImagexShortUrlResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetImagexShortUrlResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetImagexShortUrlResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetImagexShortUrlResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetImagexShortUrlResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetImagexShortUrlResponse(%+v)", *p)

}

type GetImagexShortUrlData struct {
	//Audit status, key uri, value url and, audit status
	URLInfo map[string]*UrlInfo `thrift:"url_info,1" form:"url_info" json:"url_info" query:"url_info"`
}

func NewGetImagexShortUrlData() *GetImagexShortUrlData {
	return &GetImagexShortUrlData{}
}

func (p *GetImagexShortUrlData) InitDefault() {
}

func (p *GetImagexShortUrlData) GetURLInfo() (v map[string]*UrlInfo) {
	return p.URLInfo
}

var fieldIDToName_GetImagexShortUrlData = map[int16]string{
	1: "url_info",
}

func (p *GetImagexShortUrlData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetImagexShortUrlData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetImagexShortUrlData) ReadField1(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]*UrlInfo, size)
	values := make([]UrlInfo, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.URLInfo = _field
	return nil
}

func (p *GetImagexShortUrlData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetImagexShortUrlData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetImagexShortUrlData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url_info", thrift.MAP, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRUCT, len(p.URLInfo)); err != nil {
		return err
	}
	for k, v := range p.URLInfo {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *GetImagexShortUrlData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetImagexShortUrlData(%+v)", *p)

}

type UrlInfo struct {
	URL          string `thrift:"url,1" form:"url" json:"url" query:"url"`
	ReviewStatus bool   `thrift:"review_status,2" form:"review_status" json:"review_status" query:"review_status"`
}

func NewUrlInfo() *UrlInfo {
	return &UrlInfo{}
}

func (p *UrlInfo) InitDefault() {
}

func (p *UrlInfo) GetURL() (v string) {
	return p.URL
}

func (p *UrlInfo) GetReviewStatus() (v bool) {
	return p.ReviewStatus
}

var fieldIDToName_UrlInfo = map[int16]string{
	1: "url",
	2: "review_status",
}

func (p *UrlInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UrlInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UrlInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *UrlInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ReviewStatus = _field
	return nil
}

func (p *UrlInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UrlInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UrlInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UrlInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("review_status", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.ReviewStatus); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *UrlInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UrlInfo(%+v)", *p)

}

type GetImagexShortUrlRequest struct {
	Uris  []string      `thrift:"uris,1" form:"uris" json:"uris" query:"uris"`
	Scene GetImageScene `thrift:"scene,2" form:"scene" json:"scene" query:"scene"`
	Base  *base.Base    `thrift:"Base,255" form:"-" json:"-" query:"-"`
}

func NewGetImagexShortUrlRequest() *GetImagexShortUrlRequest {
	return &GetImagexShortUrlRequest{}
}

func (p *GetImagexShortUrlRequest) InitDefault() {
}

func (p *GetImagexShortUrlRequest) GetUris() (v []string) {
	return p.Uris
}

func (p *GetImagexShortUrlRequest) GetScene() (v GetImageScene) {
	return p.Scene
}

var GetImagexShortUrlRequest_Base_DEFAULT *base.Base

func (p *GetImagexShortUrlRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetImagexShortUrlRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetImagexShortUrlRequest = map[int16]string{
	1:   "uris",
	2:   "scene",
	255: "Base",
}

func (p *GetImagexShortUrlRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetImagexShortUrlRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetImagexShortUrlRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetImagexShortUrlRequest) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Uris = _field
	return nil
}
func (p *GetImagexShortUrlRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field GetImageScene
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = GetImageScene(v)
	}
	p.Scene = _field
	return nil
}
func (p *GetImagexShortUrlRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetImagexShortUrlRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetImagexShortUrlRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetImagexShortUrlRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("uris", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.Uris)); err != nil {
		return err
	}
	for _, v := range p.Uris {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetImagexShortUrlRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("scene", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Scene)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetImagexShortUrlRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetImagexShortUrlRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetImagexShortUrlRequest(%+v)", *p)

}

type UserBasicInfo struct {
	UserId int64 `thrift:"UserId,1,required" form:"user_id,required" json:"user_id,string,required"`
	// nickname
	Username string `thrift:"Username,3,required" form:"user_name,required" json:"user_name,required"`
	// avatar
	UserAvatar string `thrift:"UserAvatar,4,required" form:"user_avatar,required" json:"user_avatar,required"`
	// user name
	UserUniqueName *string `thrift:"UserUniqueName,5,optional" form:"user_unique_name" json:"user_unique_name,omitempty"`
	// user tag
	UserLabel *bot_common.UserLabel `thrift:"UserLabel,6,optional" form:"user_label" json:"user_label,omitempty"`
	// user creation time
	CreateTime *int64 `thrift:"CreateTime,7,optional" form:"create_time" json:"create_time,omitempty"`
}

func NewUserBasicInfo() *UserBasicInfo {
	return &UserBasicInfo{}
}

func (p *UserBasicInfo) InitDefault() {
}

func (p *UserBasicInfo) GetUserId() (v int64) {
	return p.UserId
}

func (p *UserBasicInfo) GetUsername() (v string) {
	return p.Username
}

func (p *UserBasicInfo) GetUserAvatar() (v string) {
	return p.UserAvatar
}

var UserBasicInfo_UserUniqueName_DEFAULT string

func (p *UserBasicInfo) GetUserUniqueName() (v string) {
	if !p.IsSetUserUniqueName() {
		return UserBasicInfo_UserUniqueName_DEFAULT
	}
	return *p.UserUniqueName
}

var UserBasicInfo_UserLabel_DEFAULT *bot_common.UserLabel

func (p *UserBasicInfo) GetUserLabel() (v *bot_common.UserLabel) {
	if !p.IsSetUserLabel() {
		return UserBasicInfo_UserLabel_DEFAULT
	}
	return p.UserLabel
}

var UserBasicInfo_CreateTime_DEFAULT int64

func (p *UserBasicInfo) GetCreateTime() (v int64) {
	if !p.IsSetCreateTime() {
		return UserBasicInfo_CreateTime_DEFAULT
	}
	return *p.CreateTime
}

var fieldIDToName_UserBasicInfo = map[int16]string{
	1: "UserId",
	3: "Username",
	4: "UserAvatar",
	5: "UserUniqueName",
	6: "UserLabel",
	7: "CreateTime",
}

func (p *UserBasicInfo) IsSetUserUniqueName() bool {
	return p.UserUniqueName != nil
}

func (p *UserBasicInfo) IsSetUserLabel() bool {
	return p.UserLabel != nil
}

func (p *UserBasicInfo) IsSetCreateTime() bool {
	return p.CreateTime != nil
}

func (p *UserBasicInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetUserId bool = false
	var issetUsername bool = false
	var issetUserAvatar bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetUserId = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetUsername = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetUserAvatar = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetUserId {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetUsername {
		fieldId = 3
		goto RequiredFieldNotSetError
	}

	if !issetUserAvatar {
		fieldId = 4
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserBasicInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UserBasicInfo[fieldId]))
}

func (p *UserBasicInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserId = _field
	return nil
}
func (p *UserBasicInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Username = _field
	return nil
}
func (p *UserBasicInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserAvatar = _field
	return nil
}
func (p *UserBasicInfo) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.UserUniqueName = _field
	return nil
}
func (p *UserBasicInfo) ReadField6(iprot thrift.TProtocol) error {
	_field := bot_common.NewUserLabel()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.UserLabel = _field
	return nil
}
func (p *UserBasicInfo) ReadField7(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CreateTime = _field
	return nil
}

func (p *UserBasicInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserBasicInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserBasicInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("UserId", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.UserId); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UserBasicInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Username", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Username); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *UserBasicInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("UserAvatar", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UserAvatar); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *UserBasicInfo) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserUniqueName() {
		if err = oprot.WriteFieldBegin("UserUniqueName", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.UserUniqueName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *UserBasicInfo) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserLabel() {
		if err = oprot.WriteFieldBegin("UserLabel", thrift.STRUCT, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.UserLabel.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *UserBasicInfo) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetCreateTime() {
		if err = oprot.WriteFieldBegin("CreateTime", thrift.I64, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.CreateTime); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *UserBasicInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserBasicInfo(%+v)", *p)

}

type MGetUserBasicInfoRequest struct {
	UserIds        []string `thrift:"UserIds,1,required" form:"user_ids,required" json:"user_ids,string,required"`
	NeedUserStatus *bool    `thrift:"NeedUserStatus,2,optional" form:"need_user_status" json:"need_user_status,omitempty"`
	// Whether enterprise authentication information is required, the default is true when the front end is called through AGW
	NeedEnterpriseIdentity *bool `thrift:"NeedEnterpriseIdentity,3,optional" form:"need_enterprise_identity" json:"need_enterprise_identity,omitempty"`
	// Do you need a volcano username?
	NeedVolcanoUserName *bool      `thrift:"NeedVolcanoUserName,4,optional" form:"need_volcano_user_name" json:"need_volcano_user_name,omitempty"`
	Base                *base.Base `thrift:"Base,255,optional" form:"-" json:"-" query:"-"`
}

func NewMGetUserBasicInfoRequest() *MGetUserBasicInfoRequest {
	return &MGetUserBasicInfoRequest{}
}

func (p *MGetUserBasicInfoRequest) InitDefault() {
}

func (p *MGetUserBasicInfoRequest) GetUserIds() (v []string) {
	return p.UserIds
}

var MGetUserBasicInfoRequest_NeedUserStatus_DEFAULT bool

func (p *MGetUserBasicInfoRequest) GetNeedUserStatus() (v bool) {
	if !p.IsSetNeedUserStatus() {
		return MGetUserBasicInfoRequest_NeedUserStatus_DEFAULT
	}
	return *p.NeedUserStatus
}

var MGetUserBasicInfoRequest_NeedEnterpriseIdentity_DEFAULT bool

func (p *MGetUserBasicInfoRequest) GetNeedEnterpriseIdentity() (v bool) {
	if !p.IsSetNeedEnterpriseIdentity() {
		return MGetUserBasicInfoRequest_NeedEnterpriseIdentity_DEFAULT
	}
	return *p.NeedEnterpriseIdentity
}

var MGetUserBasicInfoRequest_NeedVolcanoUserName_DEFAULT bool

func (p *MGetUserBasicInfoRequest) GetNeedVolcanoUserName() (v bool) {
	if !p.IsSetNeedVolcanoUserName() {
		return MGetUserBasicInfoRequest_NeedVolcanoUserName_DEFAULT
	}
	return *p.NeedVolcanoUserName
}

var MGetUserBasicInfoRequest_Base_DEFAULT *base.Base

func (p *MGetUserBasicInfoRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return MGetUserBasicInfoRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_MGetUserBasicInfoRequest = map[int16]string{
	1:   "UserIds",
	2:   "NeedUserStatus",
	3:   "NeedEnterpriseIdentity",
	4:   "NeedVolcanoUserName",
	255: "Base",
}

func (p *MGetUserBasicInfoRequest) IsSetNeedUserStatus() bool {
	return p.NeedUserStatus != nil
}

func (p *MGetUserBasicInfoRequest) IsSetNeedEnterpriseIdentity() bool {
	return p.NeedEnterpriseIdentity != nil
}

func (p *MGetUserBasicInfoRequest) IsSetNeedVolcanoUserName() bool {
	return p.NeedVolcanoUserName != nil
}

func (p *MGetUserBasicInfoRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *MGetUserBasicInfoRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetUserIds bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetUserIds = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetUserIds {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_MGetUserBasicInfoRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_MGetUserBasicInfoRequest[fieldId]))
}

func (p *MGetUserBasicInfoRequest) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.UserIds = _field
	return nil
}
func (p *MGetUserBasicInfoRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedUserStatus = _field
	return nil
}
func (p *MGetUserBasicInfoRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedEnterpriseIdentity = _field
	return nil
}
func (p *MGetUserBasicInfoRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedVolcanoUserName = _field
	return nil
}
func (p *MGetUserBasicInfoRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *MGetUserBasicInfoRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MGetUserBasicInfoRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *MGetUserBasicInfoRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("UserIds", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.UserIds)); err != nil {
		return err
	}
	for _, v := range p.UserIds {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *MGetUserBasicInfoRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedUserStatus() {
		if err = oprot.WriteFieldBegin("NeedUserStatus", thrift.BOOL, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedUserStatus); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *MGetUserBasicInfoRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedEnterpriseIdentity() {
		if err = oprot.WriteFieldBegin("NeedEnterpriseIdentity", thrift.BOOL, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedEnterpriseIdentity); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *MGetUserBasicInfoRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedVolcanoUserName() {
		if err = oprot.WriteFieldBegin("NeedVolcanoUserName", thrift.BOOL, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedVolcanoUserName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *MGetUserBasicInfoRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *MGetUserBasicInfoRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MGetUserBasicInfoRequest(%+v)", *p)

}

type MGetUserBasicInfoResponse struct {
	UserBasicInfoMap map[string]*UserBasicInfo `thrift:"UserBasicInfoMap,1,optional" form:"id_user_info_map" json:"id_user_info_map,omitempty"`
	Code             int64                     `thrift:"code,253" form:"code" json:"code" query:"code"`
	Msg              string                    `thrift:"msg,254" form:"msg" json:"msg" query:"msg"`
	BaseResp         *base.BaseResp            `thrift:"BaseResp,255,optional" form:"-" json:"-" query:"-"`
}

func NewMGetUserBasicInfoResponse() *MGetUserBasicInfoResponse {
	return &MGetUserBasicInfoResponse{}
}

func (p *MGetUserBasicInfoResponse) InitDefault() {
}

var MGetUserBasicInfoResponse_UserBasicInfoMap_DEFAULT map[string]*UserBasicInfo

func (p *MGetUserBasicInfoResponse) GetUserBasicInfoMap() (v map[string]*UserBasicInfo) {
	if !p.IsSetUserBasicInfoMap() {
		return MGetUserBasicInfoResponse_UserBasicInfoMap_DEFAULT
	}
	return p.UserBasicInfoMap
}

func (p *MGetUserBasicInfoResponse) GetCode() (v int64) {
	return p.Code
}

func (p *MGetUserBasicInfoResponse) GetMsg() (v string) {
	return p.Msg
}

var MGetUserBasicInfoResponse_BaseResp_DEFAULT *base.BaseResp

func (p *MGetUserBasicInfoResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return MGetUserBasicInfoResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_MGetUserBasicInfoResponse = map[int16]string{
	1:   "UserBasicInfoMap",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *MGetUserBasicInfoResponse) IsSetUserBasicInfoMap() bool {
	return p.UserBasicInfoMap != nil
}

func (p *MGetUserBasicInfoResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *MGetUserBasicInfoResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_MGetUserBasicInfoResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *MGetUserBasicInfoResponse) ReadField1(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]*UserBasicInfo, size)
	values := make([]UserBasicInfo, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.UserBasicInfoMap = _field
	return nil
}
func (p *MGetUserBasicInfoResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *MGetUserBasicInfoResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *MGetUserBasicInfoResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *MGetUserBasicInfoResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MGetUserBasicInfoResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *MGetUserBasicInfoResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetUserBasicInfoMap() {
		if err = oprot.WriteFieldBegin("UserBasicInfoMap", thrift.MAP, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRUCT, len(p.UserBasicInfoMap)); err != nil {
			return err
		}
		for k, v := range p.UserBasicInfoMap {
			if err := oprot.WriteString(k); err != nil {
				return err
			}
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteMapEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *MGetUserBasicInfoResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *MGetUserBasicInfoResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *MGetUserBasicInfoResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBaseResp() {
		if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.BaseResp.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *MGetUserBasicInfoResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MGetUserBasicInfoResponse(%+v)", *p)

}

type GetBotPopupInfoRequest struct {
	BotPopupTypes []BotPopupType `thrift:"bot_popup_types,1,required" form:"bot_popup_types,required" json:"bot_popup_types,required" query:"bot_popup_types,required"`
	BotID         int64          `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	Base          *base.Base     `thrift:"Base,255" form:"-" json:"-" query:"-"`
}

func NewGetBotPopupInfoRequest() *GetBotPopupInfoRequest {
	return &GetBotPopupInfoRequest{}
}

func (p *GetBotPopupInfoRequest) InitDefault() {
}

func (p *GetBotPopupInfoRequest) GetBotPopupTypes() (v []BotPopupType) {
	return p.BotPopupTypes
}

func (p *GetBotPopupInfoRequest) GetBotID() (v int64) {
	return p.BotID
}

var GetBotPopupInfoRequest_Base_DEFAULT *base.Base

func (p *GetBotPopupInfoRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetBotPopupInfoRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetBotPopupInfoRequest = map[int16]string{
	1:   "bot_popup_types",
	2:   "bot_id",
	255: "Base",
}

func (p *GetBotPopupInfoRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetBotPopupInfoRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotPopupTypes bool = false
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotPopupTypes = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotPopupTypes {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetBotPopupInfoRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetBotPopupInfoRequest[fieldId]))
}

func (p *GetBotPopupInfoRequest) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]BotPopupType, 0, size)
	for i := 0; i < size; i++ {

		var _elem BotPopupType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_elem = BotPopupType(v)
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.BotPopupTypes = _field
	return nil
}
func (p *GetBotPopupInfoRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *GetBotPopupInfoRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetBotPopupInfoRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotPopupInfoRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetBotPopupInfoRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_popup_types", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.I32, len(p.BotPopupTypes)); err != nil {
		return err
	}
	for _, v := range p.BotPopupTypes {
		if err := oprot.WriteI32(int32(v)); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetBotPopupInfoRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetBotPopupInfoRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetBotPopupInfoRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetBotPopupInfoRequest(%+v)", *p)

}

type GetBotPopupInfoResponse struct {
	Data     *BotPopupInfoData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64             `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string            `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp    `thrift:"BaseResp,255,required" form:"-" json:"-" query:"-"`
}

func NewGetBotPopupInfoResponse() *GetBotPopupInfoResponse {
	return &GetBotPopupInfoResponse{}
}

func (p *GetBotPopupInfoResponse) InitDefault() {
}

var GetBotPopupInfoResponse_Data_DEFAULT *BotPopupInfoData

func (p *GetBotPopupInfoResponse) GetData() (v *BotPopupInfoData) {
	if !p.IsSetData() {
		return GetBotPopupInfoResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetBotPopupInfoResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetBotPopupInfoResponse) GetMsg() (v string) {
	return p.Msg
}

var GetBotPopupInfoResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetBotPopupInfoResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetBotPopupInfoResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetBotPopupInfoResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetBotPopupInfoResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetBotPopupInfoResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetBotPopupInfoResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetBotPopupInfoResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetBotPopupInfoResponse[fieldId]))
}

func (p *GetBotPopupInfoResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewBotPopupInfoData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetBotPopupInfoResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetBotPopupInfoResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetBotPopupInfoResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetBotPopupInfoResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotPopupInfoResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetBotPopupInfoResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetBotPopupInfoResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetBotPopupInfoResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetBotPopupInfoResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetBotPopupInfoResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetBotPopupInfoResponse(%+v)", *p)

}

type BotPopupInfoData struct {
	BotPopupCountInfo map[BotPopupType]int64 `thrift:"bot_popup_count_info,1,required" form:"bot_popup_count_info,required" json:"bot_popup_count_info,required" query:"bot_popup_count_info,required"`
}

func NewBotPopupInfoData() *BotPopupInfoData {
	return &BotPopupInfoData{}
}

func (p *BotPopupInfoData) InitDefault() {
}

func (p *BotPopupInfoData) GetBotPopupCountInfo() (v map[BotPopupType]int64) {
	return p.BotPopupCountInfo
}

var fieldIDToName_BotPopupInfoData = map[int16]string{
	1: "bot_popup_count_info",
}

func (p *BotPopupInfoData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotPopupCountInfo bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotPopupCountInfo = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotPopupCountInfo {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BotPopupInfoData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_BotPopupInfoData[fieldId]))
}

func (p *BotPopupInfoData) ReadField1(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[BotPopupType]int64, size)
	for i := 0; i < size; i++ {
		var _key BotPopupType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_key = BotPopupType(v)
		}

		var _val int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_val = v
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.BotPopupCountInfo = _field
	return nil
}

func (p *BotPopupInfoData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BotPopupInfoData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BotPopupInfoData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_popup_count_info", thrift.MAP, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.I32, thrift.I64, len(p.BotPopupCountInfo)); err != nil {
		return err
	}
	for k, v := range p.BotPopupCountInfo {
		if err := oprot.WriteI32(int32(k)); err != nil {
			return err
		}
		if err := oprot.WriteI64(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *BotPopupInfoData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BotPopupInfoData(%+v)", *p)

}

type UpdateBotPopupInfoResponse struct {
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"-" json:"-" query:"-"`
}

func NewUpdateBotPopupInfoResponse() *UpdateBotPopupInfoResponse {
	return &UpdateBotPopupInfoResponse{}
}

func (p *UpdateBotPopupInfoResponse) InitDefault() {
}

func (p *UpdateBotPopupInfoResponse) GetCode() (v int64) {
	return p.Code
}

func (p *UpdateBotPopupInfoResponse) GetMsg() (v string) {
	return p.Msg
}

var UpdateBotPopupInfoResponse_BaseResp_DEFAULT *base.BaseResp

func (p *UpdateBotPopupInfoResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return UpdateBotPopupInfoResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_UpdateBotPopupInfoResponse = map[int16]string{
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *UpdateBotPopupInfoResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *UpdateBotPopupInfoResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateBotPopupInfoResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UpdateBotPopupInfoResponse[fieldId]))
}

func (p *UpdateBotPopupInfoResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *UpdateBotPopupInfoResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *UpdateBotPopupInfoResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *UpdateBotPopupInfoResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateBotPopupInfoResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateBotPopupInfoResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *UpdateBotPopupInfoResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *UpdateBotPopupInfoResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UpdateBotPopupInfoResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateBotPopupInfoResponse(%+v)", *p)

}

type UpdateBotPopupInfoRequest struct {
	BotPopupType BotPopupType `thrift:"bot_popup_type,1,required" form:"bot_popup_type,required" json:"bot_popup_type,required" query:"bot_popup_type,required"`
	BotID        int64        `thrift:"bot_id,2,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	Base         *base.Base   `thrift:"Base,255" form:"-" json:"-" query:"-"`
}

func NewUpdateBotPopupInfoRequest() *UpdateBotPopupInfoRequest {
	return &UpdateBotPopupInfoRequest{}
}

func (p *UpdateBotPopupInfoRequest) InitDefault() {
}

func (p *UpdateBotPopupInfoRequest) GetBotPopupType() (v BotPopupType) {
	return p.BotPopupType
}

func (p *UpdateBotPopupInfoRequest) GetBotID() (v int64) {
	return p.BotID
}

var UpdateBotPopupInfoRequest_Base_DEFAULT *base.Base

func (p *UpdateBotPopupInfoRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return UpdateBotPopupInfoRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_UpdateBotPopupInfoRequest = map[int16]string{
	1:   "bot_popup_type",
	2:   "bot_id",
	255: "Base",
}

func (p *UpdateBotPopupInfoRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *UpdateBotPopupInfoRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotPopupType bool = false
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotPopupType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotPopupType {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetBotID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateBotPopupInfoRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UpdateBotPopupInfoRequest[fieldId]))
}

func (p *UpdateBotPopupInfoRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field BotPopupType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = BotPopupType(v)
	}
	p.BotPopupType = _field
	return nil
}
func (p *UpdateBotPopupInfoRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *UpdateBotPopupInfoRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *UpdateBotPopupInfoRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateBotPopupInfoRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateBotPopupInfoRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_popup_type", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.BotPopupType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateBotPopupInfoRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UpdateBotPopupInfoRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UpdateBotPopupInfoRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateBotPopupInfoRequest(%+v)", *p)

}

type ReportUserBehaviorRequest struct {
	ResourceID   int64             `thrift:"ResourceID,1,required" form:"resource_id,required" json:"resource_id,string,required"`
	ResourceType SpaceResourceType `thrift:"ResourceType,2,required" form:"resource_type,required" json:"resource_type,required"`
	BehaviorType BehaviorType      `thrift:"BehaviorType,3,required" form:"behavior_type,required" json:"behavior_type,required"`
	// This requirement must be passed on
	SpaceID *int64     `thrift:"SpaceID,4,optional" form:"space_id" json:"space_id,string,omitempty"`
	Base    *base.Base `thrift:"Base,255" form:"-" json:"-" query:"-"`
}

func NewReportUserBehaviorRequest() *ReportUserBehaviorRequest {
	return &ReportUserBehaviorRequest{}
}

func (p *ReportUserBehaviorRequest) InitDefault() {
}

func (p *ReportUserBehaviorRequest) GetResourceID() (v int64) {
	return p.ResourceID
}

func (p *ReportUserBehaviorRequest) GetResourceType() (v SpaceResourceType) {
	return p.ResourceType
}

func (p *ReportUserBehaviorRequest) GetBehaviorType() (v BehaviorType) {
	return p.BehaviorType
}

var ReportUserBehaviorRequest_SpaceID_DEFAULT int64

func (p *ReportUserBehaviorRequest) GetSpaceID() (v int64) {
	if !p.IsSetSpaceID() {
		return ReportUserBehaviorRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var ReportUserBehaviorRequest_Base_DEFAULT *base.Base

func (p *ReportUserBehaviorRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return ReportUserBehaviorRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_ReportUserBehaviorRequest = map[int16]string{
	1:   "ResourceID",
	2:   "ResourceType",
	3:   "BehaviorType",
	4:   "SpaceID",
	255: "Base",
}

func (p *ReportUserBehaviorRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *ReportUserBehaviorRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *ReportUserBehaviorRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetResourceID bool = false
	var issetResourceType bool = false
	var issetBehaviorType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetResourceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetResourceType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetBehaviorType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetResourceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetResourceType {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetBehaviorType {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ReportUserBehaviorRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ReportUserBehaviorRequest[fieldId]))
}

func (p *ReportUserBehaviorRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ResourceID = _field
	return nil
}
func (p *ReportUserBehaviorRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field SpaceResourceType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = SpaceResourceType(v)
	}
	p.ResourceType = _field
	return nil
}
func (p *ReportUserBehaviorRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field BehaviorType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = BehaviorType(v)
	}
	p.BehaviorType = _field
	return nil
}
func (p *ReportUserBehaviorRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *ReportUserBehaviorRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *ReportUserBehaviorRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ReportUserBehaviorRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ReportUserBehaviorRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ResourceID", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.ResourceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ReportUserBehaviorRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ResourceType", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ResourceType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ReportUserBehaviorRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BehaviorType", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.BehaviorType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ReportUserBehaviorRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("SpaceID", thrift.I64, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ReportUserBehaviorRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *ReportUserBehaviorRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReportUserBehaviorRequest(%+v)", *p)

}

type ReportUserBehaviorResponse struct {
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewReportUserBehaviorResponse() *ReportUserBehaviorResponse {
	return &ReportUserBehaviorResponse{}
}

func (p *ReportUserBehaviorResponse) InitDefault() {
}

func (p *ReportUserBehaviorResponse) GetCode() (v int64) {
	return p.Code
}

func (p *ReportUserBehaviorResponse) GetMsg() (v string) {
	return p.Msg
}

var ReportUserBehaviorResponse_BaseResp_DEFAULT *base.BaseResp

func (p *ReportUserBehaviorResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return ReportUserBehaviorResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_ReportUserBehaviorResponse = map[int16]string{
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *ReportUserBehaviorResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *ReportUserBehaviorResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ReportUserBehaviorResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_ReportUserBehaviorResponse[fieldId]))
}

func (p *ReportUserBehaviorResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *ReportUserBehaviorResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *ReportUserBehaviorResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *ReportUserBehaviorResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ReportUserBehaviorResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ReportUserBehaviorResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *ReportUserBehaviorResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *ReportUserBehaviorResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *ReportUserBehaviorResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReportUserBehaviorResponse(%+v)", *p)

}

type FileInfo struct {
	URL string `thrift:"url,1" form:"url" json:"url" query:"url"`
	URI string `thrift:"uri,2" form:"uri" json:"uri" query:"uri"`
}

func NewFileInfo() *FileInfo {
	return &FileInfo{}
}

func (p *FileInfo) InitDefault() {
}

func (p *FileInfo) GetURL() (v string) {
	return p.URL
}

func (p *FileInfo) GetURI() (v string) {
	return p.URI
}

var fieldIDToName_FileInfo = map[int16]string{
	1: "url",
	2: "uri",
}

func (p *FileInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_FileInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *FileInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *FileInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URI = _field
	return nil
}

func (p *FileInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("FileInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *FileInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *FileInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("uri", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *FileInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("FileInfo(%+v)", *p)

}

type GetFileUrlsRequest struct {
	Scene GetFileUrlsScene `thrift:"scene,1" form:"scene" json:"scene" query:"scene"`
	Base  *base.Base       `thrift:"Base,255" form:"Base" json:"Base" query:"Base"`
}

func NewGetFileUrlsRequest() *GetFileUrlsRequest {
	return &GetFileUrlsRequest{}
}

func (p *GetFileUrlsRequest) InitDefault() {
}

func (p *GetFileUrlsRequest) GetScene() (v GetFileUrlsScene) {
	return p.Scene
}

var GetFileUrlsRequest_Base_DEFAULT *base.Base

func (p *GetFileUrlsRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetFileUrlsRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetFileUrlsRequest = map[int16]string{
	1:   "scene",
	255: "Base",
}

func (p *GetFileUrlsRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetFileUrlsRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetFileUrlsRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetFileUrlsRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field GetFileUrlsScene
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = GetFileUrlsScene(v)
	}
	p.Scene = _field
	return nil
}
func (p *GetFileUrlsRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetFileUrlsRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetFileUrlsRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetFileUrlsRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("scene", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Scene)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetFileUrlsRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetFileUrlsRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetFileUrlsRequest(%+v)", *p)

}

type GetFileUrlsResponse struct {
	FileList []*FileInfo    `thrift:"file_list,1" form:"file_list" json:"file_list" query:"file_list"`
	Code     int64          `thrift:"code,253" form:"code" json:"code" query:"code"`
	Msg      string         `thrift:"msg,254" form:"msg" json:"msg" query:"msg"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255" form:"BaseResp" json:"BaseResp" query:"BaseResp"`
}

func NewGetFileUrlsResponse() *GetFileUrlsResponse {
	return &GetFileUrlsResponse{}
}

func (p *GetFileUrlsResponse) InitDefault() {
}

func (p *GetFileUrlsResponse) GetFileList() (v []*FileInfo) {
	return p.FileList
}

func (p *GetFileUrlsResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetFileUrlsResponse) GetMsg() (v string) {
	return p.Msg
}

var GetFileUrlsResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetFileUrlsResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetFileUrlsResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetFileUrlsResponse = map[int16]string{
	1:   "file_list",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetFileUrlsResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetFileUrlsResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetFileUrlsResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetFileUrlsResponse) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*FileInfo, 0, size)
	values := make([]FileInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.FileList = _field
	return nil
}
func (p *GetFileUrlsResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetFileUrlsResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetFileUrlsResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetFileUrlsResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetFileUrlsResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetFileUrlsResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("file_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.FileList)); err != nil {
		return err
	}
	for _, v := range p.FileList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetFileUrlsResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetFileUrlsResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetFileUrlsResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetFileUrlsResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetFileUrlsResponse(%+v)", *p)

}

type UploadFileOpenRequest struct {
	// file type
	ContentType string `thrift:"ContentType,1,required" header:"Content-Type,required" json:"ContentType,required"`
	// binary data
	Data []byte     `thrift:"Data,2,required" json:"Data,required" raw_body:",required"`
	Base *base.Base `thrift:"Base,255" form:"Base" json:"Base" query:"Base"`
}

func NewUploadFileOpenRequest() *UploadFileOpenRequest {
	return &UploadFileOpenRequest{}
}

func (p *UploadFileOpenRequest) InitDefault() {
}

func (p *UploadFileOpenRequest) GetContentType() (v string) {
	return p.ContentType
}

func (p *UploadFileOpenRequest) GetData() (v []byte) {
	return p.Data
}

var UploadFileOpenRequest_Base_DEFAULT *base.Base

func (p *UploadFileOpenRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return UploadFileOpenRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_UploadFileOpenRequest = map[int16]string{
	1:   "ContentType",
	2:   "Data",
	255: "Base",
}

func (p *UploadFileOpenRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *UploadFileOpenRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetContentType bool = false
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetContentType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetContentType {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetData {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UploadFileOpenRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UploadFileOpenRequest[fieldId]))
}

func (p *UploadFileOpenRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ContentType = _field
	return nil
}
func (p *UploadFileOpenRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field []byte
	if v, err := iprot.ReadBinary(); err != nil {
		return err
	} else {
		_field = []byte(v)
	}
	p.Data = _field
	return nil
}
func (p *UploadFileOpenRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *UploadFileOpenRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFileOpenRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UploadFileOpenRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("ContentType", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ContentType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UploadFileOpenRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Data", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBinary([]byte(p.Data)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UploadFileOpenRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Base.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UploadFileOpenRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UploadFileOpenRequest(%+v)", *p)

}

type UploadFileOpenResponse struct {
	File     *File          `thrift:"File,1,optional" form:"data" json:"data,omitempty"`
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255" form:"BaseResp" json:"BaseResp" query:"BaseResp"`
}

func NewUploadFileOpenResponse() *UploadFileOpenResponse {
	return &UploadFileOpenResponse{}
}

func (p *UploadFileOpenResponse) InitDefault() {
}

var UploadFileOpenResponse_File_DEFAULT *File

func (p *UploadFileOpenResponse) GetFile() (v *File) {
	if !p.IsSetFile() {
		return UploadFileOpenResponse_File_DEFAULT
	}
	return p.File
}

func (p *UploadFileOpenResponse) GetCode() (v int64) {
	return p.Code
}

func (p *UploadFileOpenResponse) GetMsg() (v string) {
	return p.Msg
}

var UploadFileOpenResponse_BaseResp_DEFAULT *base.BaseResp

func (p *UploadFileOpenResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return UploadFileOpenResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_UploadFileOpenResponse = map[int16]string{
	1:   "File",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *UploadFileOpenResponse) IsSetFile() bool {
	return p.File != nil
}

func (p *UploadFileOpenResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *UploadFileOpenResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UploadFileOpenResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UploadFileOpenResponse[fieldId]))
}

func (p *UploadFileOpenResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewFile()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.File = _field
	return nil
}
func (p *UploadFileOpenResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *UploadFileOpenResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *UploadFileOpenResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *UploadFileOpenResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFileOpenResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UploadFileOpenResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetFile() {
		if err = oprot.WriteFieldBegin("File", thrift.STRUCT, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.File.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UploadFileOpenResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *UploadFileOpenResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *UploadFileOpenResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UploadFileOpenResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UploadFileOpenResponse(%+v)", *p)

}

type File struct {
	// File URI
	URI string `thrift:"URI,1" form:"uri" json:"uri"`
	// file bytes
	Bytes int64 `thrift:"Bytes,2" form:"bytes" json:"bytes"`
	// Upload timestamp in s
	CreatedAt int64 `thrift:"CreatedAt,3" form:"CreatedAt" json:"CreatedAt" query:"CreatedAt"`
	// file name
	FileName string `thrift:"FileName,4" form:"file_name" json:"file_name"`
	URL      string `thrift:"URL,5" form:"url" json:"url"`
}

func NewFile() *File {
	return &File{}
}

func (p *File) InitDefault() {
}

func (p *File) GetURI() (v string) {
	return p.URI
}

func (p *File) GetBytes() (v int64) {
	return p.Bytes
}

func (p *File) GetCreatedAt() (v int64) {
	return p.CreatedAt
}

func (p *File) GetFileName() (v string) {
	return p.FileName
}

func (p *File) GetURL() (v string) {
	return p.URL
}

var fieldIDToName_File = map[int16]string{
	1: "URI",
	2: "Bytes",
	3: "CreatedAt",
	4: "FileName",
	5: "URL",
}

func (p *File) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_File[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *File) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URI = _field
	return nil
}
func (p *File) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Bytes = _field
	return nil
}
func (p *File) ReadField3(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CreatedAt = _field
	return nil
}
func (p *File) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.FileName = _field
	return nil
}
func (p *File) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}

func (p *File) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("File"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *File) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("URI", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *File) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("Bytes", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Bytes); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *File) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("CreatedAt", thrift.I64, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.CreatedAt); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *File) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("FileName", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.FileName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *File) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("URL", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *File) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("File(%+v)", *p)

}

type GetBotOnlineInfoReq struct {
	// botId
	BotID int64 `thrift:"bot_id,1,required" form:"bot_id,required" json:"bot_id,string,required" query:"bot_id,required"`
	// Keep it first, don't expose it, and don't use the field
	ConnectorID *string `thrift:"connector_id,2,optional" form:"connector_id" json:"connector_id,omitempty" query:"connector_id"`
	// bot version, get the latest version if you don't pass it on.
	Version *string `thrift:"version,3,optional" form:"version" json:"version,omitempty" query:"version"`
}

func NewGetBotOnlineInfoReq() *GetBotOnlineInfoReq {
	return &GetBotOnlineInfoReq{}
}

func (p *GetBotOnlineInfoReq) InitDefault() {
}

func (p *GetBotOnlineInfoReq) GetBotID() (v int64) {
	return p.BotID
}

var GetBotOnlineInfoReq_ConnectorID_DEFAULT string

func (p *GetBotOnlineInfoReq) GetConnectorID() (v string) {
	if !p.IsSetConnectorID() {
		return GetBotOnlineInfoReq_ConnectorID_DEFAULT
	}
	return *p.ConnectorID
}

var GetBotOnlineInfoReq_Version_DEFAULT string

func (p *GetBotOnlineInfoReq) GetVersion() (v string) {
	if !p.IsSetVersion() {
		return GetBotOnlineInfoReq_Version_DEFAULT
	}
	return *p.Version
}

var fieldIDToName_GetBotOnlineInfoReq = map[int16]string{
	1: "bot_id",
	2: "connector_id",
	3: "version",
}

func (p *GetBotOnlineInfoReq) IsSetConnectorID() bool {
	return p.ConnectorID != nil
}

func (p *GetBotOnlineInfoReq) IsSetVersion() bool {
	return p.Version != nil
}

func (p *GetBotOnlineInfoReq) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBotID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetBotID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBotID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetBotOnlineInfoReq[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetBotOnlineInfoReq[fieldId]))
}

func (p *GetBotOnlineInfoReq) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.BotID = _field
	return nil
}
func (p *GetBotOnlineInfoReq) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ConnectorID = _field
	return nil
}
func (p *GetBotOnlineInfoReq) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Version = _field
	return nil
}

func (p *GetBotOnlineInfoReq) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotOnlineInfoReq"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetBotOnlineInfoReq) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("bot_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.BotID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetBotOnlineInfoReq) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetConnectorID() {
		if err = oprot.WriteFieldBegin("connector_id", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ConnectorID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetBotOnlineInfoReq) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetVersion() {
		if err = oprot.WriteFieldBegin("version", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Version); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetBotOnlineInfoReq) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetBotOnlineInfoReq(%+v)", *p)

}

// resp
type GetBotOnlineInfoResp struct {
	Code int32                      `thrift:"code,1,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg  string                     `thrift:"msg,2,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	Data *bot_common.OpenAPIBotInfo `thrift:"data,3,required" form:"data,required" json:"data,required" query:"data,required"`
}

func NewGetBotOnlineInfoResp() *GetBotOnlineInfoResp {
	return &GetBotOnlineInfoResp{}
}

func (p *GetBotOnlineInfoResp) InitDefault() {
}

func (p *GetBotOnlineInfoResp) GetCode() (v int32) {
	return p.Code
}

func (p *GetBotOnlineInfoResp) GetMsg() (v string) {
	return p.Msg
}

var GetBotOnlineInfoResp_Data_DEFAULT *bot_common.OpenAPIBotInfo

func (p *GetBotOnlineInfoResp) GetData() (v *bot_common.OpenAPIBotInfo) {
	if !p.IsSetData() {
		return GetBotOnlineInfoResp_Data_DEFAULT
	}
	return p.Data
}

var fieldIDToName_GetBotOnlineInfoResp = map[int16]string{
	1: "code",
	2: "msg",
	3: "data",
}

func (p *GetBotOnlineInfoResp) IsSetData() bool {
	return p.Data != nil
}

func (p *GetBotOnlineInfoResp) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetData {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetBotOnlineInfoResp[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetBotOnlineInfoResp[fieldId]))
}

func (p *GetBotOnlineInfoResp) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetBotOnlineInfoResp) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetBotOnlineInfoResp) ReadField3(iprot thrift.TProtocol) error {
	_field := bot_common.NewOpenAPIBotInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}

func (p *GetBotOnlineInfoResp) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotOnlineInfoResp"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetBotOnlineInfoResp) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetBotOnlineInfoResp) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetBotOnlineInfoResp) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *GetBotOnlineInfoResp) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetBotOnlineInfoResp(%+v)", *p)

}

type PlaygroundService interface {
	UpdateDraftBotInfoAgw(ctx context.Context, request *UpdateDraftBotInfoAgwRequest) (r *UpdateDraftBotInfoAgwResponse, err error)

	GetDraftBotInfoAgw(ctx context.Context, request *GetDraftBotInfoAgwRequest) (r *GetDraftBotInfoAgwResponse, err error)

	GetImagexShortUrl(ctx context.Context, request *GetImagexShortUrlRequest) (r *GetImagexShortUrlResponse, err error)
	// public popup_info
	GetBotPopupInfo(ctx context.Context, request *GetBotPopupInfoRequest) (r *GetBotPopupInfoResponse, err error)

	UpdateBotPopupInfo(ctx context.Context, request *UpdateBotPopupInfoRequest) (r *UpdateBotPopupInfoResponse, err error)

	ReportUserBehavior(ctx context.Context, request *ReportUserBehaviorRequest) (r *ReportUserBehaviorResponse, err error)
	// Create shortcut instructions
	CreateUpdateShortcutCommand(ctx context.Context, req *CreateUpdateShortcutCommandRequest) (r *CreateUpdateShortcutCommandResponse, err error)

	GetFileUrls(ctx context.Context, req *GetFileUrlsRequest) (r *GetFileUrlsResponse, err error)
	// prompt resource
	GetOfficialPromptResourceList(ctx context.Context, request *GetOfficialPromptResourceListRequest) (r *GetOfficialPromptResourceListResponse, err error)

	GetPromptResourceInfo(ctx context.Context, request *GetPromptResourceInfoRequest) (r *GetPromptResourceInfoResponse, err error)

	UpsertPromptResource(ctx context.Context, request *UpsertPromptResourceRequest) (r *UpsertPromptResourceResponse, err error)

	DeletePromptResource(ctx context.Context, request *DeletePromptResourceRequest) (r *DeletePromptResourceResponse, err error)

	GetSpaceListV2(ctx context.Context, request *GetSpaceListV2Request) (r *GetSpaceListV2Response, err error)

	MGetUserBasicInfo(ctx context.Context, request *MGetUserBasicInfoRequest) (r *MGetUserBasicInfoResponse, err error)
	//openapi
	GetBotOnlineInfo(ctx context.Context, request *GetBotOnlineInfoReq) (r *GetBotOnlineInfoResp, err error)
	// File related OpenAPI
	UploadFileOpen(ctx context.Context, request *UploadFileOpenRequest) (r *UploadFileOpenResponse, err error)
}

type PlaygroundServiceClient struct {
	c thrift.TClient
}

func NewPlaygroundServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *PlaygroundServiceClient {
	return &PlaygroundServiceClient{
		c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
	}
}

func NewPlaygroundServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *PlaygroundServiceClient {
	return &PlaygroundServiceClient{
		c: thrift.NewTStandardClient(iprot, oprot),
	}
}

func NewPlaygroundServiceClient(c thrift.TClient) *PlaygroundServiceClient {
	return &PlaygroundServiceClient{
		c: c,
	}
}

func (p *PlaygroundServiceClient) Client_() thrift.TClient {
	return p.c
}

func (p *PlaygroundServiceClient) UpdateDraftBotInfoAgw(ctx context.Context, request *UpdateDraftBotInfoAgwRequest) (r *UpdateDraftBotInfoAgwResponse, err error) {
	var _args PlaygroundServiceUpdateDraftBotInfoAgwArgs
	_args.Request = request
	var _result PlaygroundServiceUpdateDraftBotInfoAgwResult
	if err = p.Client_().Call(ctx, "UpdateDraftBotInfoAgw", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetDraftBotInfoAgw(ctx context.Context, request *GetDraftBotInfoAgwRequest) (r *GetDraftBotInfoAgwResponse, err error) {
	var _args PlaygroundServiceGetDraftBotInfoAgwArgs
	_args.Request = request
	var _result PlaygroundServiceGetDraftBotInfoAgwResult
	if err = p.Client_().Call(ctx, "GetDraftBotInfoAgw", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetImagexShortUrl(ctx context.Context, request *GetImagexShortUrlRequest) (r *GetImagexShortUrlResponse, err error) {
	var _args PlaygroundServiceGetImagexShortUrlArgs
	_args.Request = request
	var _result PlaygroundServiceGetImagexShortUrlResult
	if err = p.Client_().Call(ctx, "GetImagexShortUrl", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetBotPopupInfo(ctx context.Context, request *GetBotPopupInfoRequest) (r *GetBotPopupInfoResponse, err error) {
	var _args PlaygroundServiceGetBotPopupInfoArgs
	_args.Request = request
	var _result PlaygroundServiceGetBotPopupInfoResult
	if err = p.Client_().Call(ctx, "GetBotPopupInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) UpdateBotPopupInfo(ctx context.Context, request *UpdateBotPopupInfoRequest) (r *UpdateBotPopupInfoResponse, err error) {
	var _args PlaygroundServiceUpdateBotPopupInfoArgs
	_args.Request = request
	var _result PlaygroundServiceUpdateBotPopupInfoResult
	if err = p.Client_().Call(ctx, "UpdateBotPopupInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) ReportUserBehavior(ctx context.Context, request *ReportUserBehaviorRequest) (r *ReportUserBehaviorResponse, err error) {
	var _args PlaygroundServiceReportUserBehaviorArgs
	_args.Request = request
	var _result PlaygroundServiceReportUserBehaviorResult
	if err = p.Client_().Call(ctx, "ReportUserBehavior", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) CreateUpdateShortcutCommand(ctx context.Context, req *CreateUpdateShortcutCommandRequest) (r *CreateUpdateShortcutCommandResponse, err error) {
	var _args PlaygroundServiceCreateUpdateShortcutCommandArgs
	_args.Req = req
	var _result PlaygroundServiceCreateUpdateShortcutCommandResult
	if err = p.Client_().Call(ctx, "CreateUpdateShortcutCommand", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetFileUrls(ctx context.Context, req *GetFileUrlsRequest) (r *GetFileUrlsResponse, err error) {
	var _args PlaygroundServiceGetFileUrlsArgs
	_args.Req = req
	var _result PlaygroundServiceGetFileUrlsResult
	if err = p.Client_().Call(ctx, "GetFileUrls", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetOfficialPromptResourceList(ctx context.Context, request *GetOfficialPromptResourceListRequest) (r *GetOfficialPromptResourceListResponse, err error) {
	var _args PlaygroundServiceGetOfficialPromptResourceListArgs
	_args.Request = request
	var _result PlaygroundServiceGetOfficialPromptResourceListResult
	if err = p.Client_().Call(ctx, "GetOfficialPromptResourceList", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetPromptResourceInfo(ctx context.Context, request *GetPromptResourceInfoRequest) (r *GetPromptResourceInfoResponse, err error) {
	var _args PlaygroundServiceGetPromptResourceInfoArgs
	_args.Request = request
	var _result PlaygroundServiceGetPromptResourceInfoResult
	if err = p.Client_().Call(ctx, "GetPromptResourceInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) UpsertPromptResource(ctx context.Context, request *UpsertPromptResourceRequest) (r *UpsertPromptResourceResponse, err error) {
	var _args PlaygroundServiceUpsertPromptResourceArgs
	_args.Request = request
	var _result PlaygroundServiceUpsertPromptResourceResult
	if err = p.Client_().Call(ctx, "UpsertPromptResource", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) DeletePromptResource(ctx context.Context, request *DeletePromptResourceRequest) (r *DeletePromptResourceResponse, err error) {
	var _args PlaygroundServiceDeletePromptResourceArgs
	_args.Request = request
	var _result PlaygroundServiceDeletePromptResourceResult
	if err = p.Client_().Call(ctx, "DeletePromptResource", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetSpaceListV2(ctx context.Context, request *GetSpaceListV2Request) (r *GetSpaceListV2Response, err error) {
	var _args PlaygroundServiceGetSpaceListV2Args
	_args.Request = request
	var _result PlaygroundServiceGetSpaceListV2Result
	if err = p.Client_().Call(ctx, "GetSpaceListV2", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) MGetUserBasicInfo(ctx context.Context, request *MGetUserBasicInfoRequest) (r *MGetUserBasicInfoResponse, err error) {
	var _args PlaygroundServiceMGetUserBasicInfoArgs
	_args.Request = request
	var _result PlaygroundServiceMGetUserBasicInfoResult
	if err = p.Client_().Call(ctx, "MGetUserBasicInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) GetBotOnlineInfo(ctx context.Context, request *GetBotOnlineInfoReq) (r *GetBotOnlineInfoResp, err error) {
	var _args PlaygroundServiceGetBotOnlineInfoArgs
	_args.Request = request
	var _result PlaygroundServiceGetBotOnlineInfoResult
	if err = p.Client_().Call(ctx, "GetBotOnlineInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *PlaygroundServiceClient) UploadFileOpen(ctx context.Context, request *UploadFileOpenRequest) (r *UploadFileOpenResponse, err error) {
	var _args PlaygroundServiceUploadFileOpenArgs
	_args.Request = request
	var _result PlaygroundServiceUploadFileOpenResult
	if err = p.Client_().Call(ctx, "UploadFileOpen", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}

type PlaygroundServiceProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      PlaygroundService
}

func (p *PlaygroundServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *PlaygroundServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *PlaygroundServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewPlaygroundServiceProcessor(handler PlaygroundService) *PlaygroundServiceProcessor {
	self := &PlaygroundServiceProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self.AddToProcessorMap("UpdateDraftBotInfoAgw", &playgroundServiceProcessorUpdateDraftBotInfoAgw{handler: handler})
	self.AddToProcessorMap("GetDraftBotInfoAgw", &playgroundServiceProcessorGetDraftBotInfoAgw{handler: handler})
	self.AddToProcessorMap("GetImagexShortUrl", &playgroundServiceProcessorGetImagexShortUrl{handler: handler})
	self.AddToProcessorMap("GetBotPopupInfo", &playgroundServiceProcessorGetBotPopupInfo{handler: handler})
	self.AddToProcessorMap("UpdateBotPopupInfo", &playgroundServiceProcessorUpdateBotPopupInfo{handler: handler})
	self.AddToProcessorMap("ReportUserBehavior", &playgroundServiceProcessorReportUserBehavior{handler: handler})
	self.AddToProcessorMap("CreateUpdateShortcutCommand", &playgroundServiceProcessorCreateUpdateShortcutCommand{handler: handler})
	self.AddToProcessorMap("GetFileUrls", &playgroundServiceProcessorGetFileUrls{handler: handler})
	self.AddToProcessorMap("GetOfficialPromptResourceList", &playgroundServiceProcessorGetOfficialPromptResourceList{handler: handler})
	self.AddToProcessorMap("GetPromptResourceInfo", &playgroundServiceProcessorGetPromptResourceInfo{handler: handler})
	self.AddToProcessorMap("UpsertPromptResource", &playgroundServiceProcessorUpsertPromptResource{handler: handler})
	self.AddToProcessorMap("DeletePromptResource", &playgroundServiceProcessorDeletePromptResource{handler: handler})
	self.AddToProcessorMap("GetSpaceListV2", &playgroundServiceProcessorGetSpaceListV2{handler: handler})
	self.AddToProcessorMap("MGetUserBasicInfo", &playgroundServiceProcessorMGetUserBasicInfo{handler: handler})
	self.AddToProcessorMap("GetBotOnlineInfo", &playgroundServiceProcessorGetBotOnlineInfo{handler: handler})
	self.AddToProcessorMap("UploadFileOpen", &playgroundServiceProcessorUploadFileOpen{handler: handler})
	return self
}
func (p *PlaygroundServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(ctx, seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush(ctx)
	return false, x
}

type playgroundServiceProcessorUpdateDraftBotInfoAgw struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorUpdateDraftBotInfoAgw) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceUpdateDraftBotInfoAgwArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UpdateDraftBotInfoAgw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceUpdateDraftBotInfoAgwResult{}
	var retval *UpdateDraftBotInfoAgwResponse
	if retval, err2 = p.handler.UpdateDraftBotInfoAgw(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UpdateDraftBotInfoAgw: "+err2.Error())
		oprot.WriteMessageBegin("UpdateDraftBotInfoAgw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UpdateDraftBotInfoAgw", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetDraftBotInfoAgw struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetDraftBotInfoAgw) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetDraftBotInfoAgwArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetDraftBotInfoAgw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetDraftBotInfoAgwResult{}
	var retval *GetDraftBotInfoAgwResponse
	if retval, err2 = p.handler.GetDraftBotInfoAgw(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetDraftBotInfoAgw: "+err2.Error())
		oprot.WriteMessageBegin("GetDraftBotInfoAgw", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetDraftBotInfoAgw", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetImagexShortUrl struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetImagexShortUrl) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetImagexShortUrlArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetImagexShortUrl", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetImagexShortUrlResult{}
	var retval *GetImagexShortUrlResponse
	if retval, err2 = p.handler.GetImagexShortUrl(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetImagexShortUrl: "+err2.Error())
		oprot.WriteMessageBegin("GetImagexShortUrl", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetImagexShortUrl", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetBotPopupInfo struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetBotPopupInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetBotPopupInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetBotPopupInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetBotPopupInfoResult{}
	var retval *GetBotPopupInfoResponse
	if retval, err2 = p.handler.GetBotPopupInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetBotPopupInfo: "+err2.Error())
		oprot.WriteMessageBegin("GetBotPopupInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetBotPopupInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorUpdateBotPopupInfo struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorUpdateBotPopupInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceUpdateBotPopupInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UpdateBotPopupInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceUpdateBotPopupInfoResult{}
	var retval *UpdateBotPopupInfoResponse
	if retval, err2 = p.handler.UpdateBotPopupInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UpdateBotPopupInfo: "+err2.Error())
		oprot.WriteMessageBegin("UpdateBotPopupInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UpdateBotPopupInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorReportUserBehavior struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorReportUserBehavior) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceReportUserBehaviorArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("ReportUserBehavior", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceReportUserBehaviorResult{}
	var retval *ReportUserBehaviorResponse
	if retval, err2 = p.handler.ReportUserBehavior(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ReportUserBehavior: "+err2.Error())
		oprot.WriteMessageBegin("ReportUserBehavior", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("ReportUserBehavior", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorCreateUpdateShortcutCommand struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorCreateUpdateShortcutCommand) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceCreateUpdateShortcutCommandArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CreateUpdateShortcutCommand", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceCreateUpdateShortcutCommandResult{}
	var retval *CreateUpdateShortcutCommandResponse
	if retval, err2 = p.handler.CreateUpdateShortcutCommand(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CreateUpdateShortcutCommand: "+err2.Error())
		oprot.WriteMessageBegin("CreateUpdateShortcutCommand", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CreateUpdateShortcutCommand", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetFileUrls struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetFileUrls) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetFileUrlsArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetFileUrls", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetFileUrlsResult{}
	var retval *GetFileUrlsResponse
	if retval, err2 = p.handler.GetFileUrls(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetFileUrls: "+err2.Error())
		oprot.WriteMessageBegin("GetFileUrls", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetFileUrls", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetOfficialPromptResourceList struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetOfficialPromptResourceList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetOfficialPromptResourceListArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetOfficialPromptResourceList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetOfficialPromptResourceListResult{}
	var retval *GetOfficialPromptResourceListResponse
	if retval, err2 = p.handler.GetOfficialPromptResourceList(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetOfficialPromptResourceList: "+err2.Error())
		oprot.WriteMessageBegin("GetOfficialPromptResourceList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetOfficialPromptResourceList", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetPromptResourceInfo struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetPromptResourceInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetPromptResourceInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetPromptResourceInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetPromptResourceInfoResult{}
	var retval *GetPromptResourceInfoResponse
	if retval, err2 = p.handler.GetPromptResourceInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetPromptResourceInfo: "+err2.Error())
		oprot.WriteMessageBegin("GetPromptResourceInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetPromptResourceInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorUpsertPromptResource struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorUpsertPromptResource) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceUpsertPromptResourceArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UpsertPromptResource", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceUpsertPromptResourceResult{}
	var retval *UpsertPromptResourceResponse
	if retval, err2 = p.handler.UpsertPromptResource(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UpsertPromptResource: "+err2.Error())
		oprot.WriteMessageBegin("UpsertPromptResource", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UpsertPromptResource", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorDeletePromptResource struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorDeletePromptResource) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceDeletePromptResourceArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("DeletePromptResource", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceDeletePromptResourceResult{}
	var retval *DeletePromptResourceResponse
	if retval, err2 = p.handler.DeletePromptResource(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing DeletePromptResource: "+err2.Error())
		oprot.WriteMessageBegin("DeletePromptResource", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("DeletePromptResource", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetSpaceListV2 struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetSpaceListV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetSpaceListV2Args{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetSpaceListV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetSpaceListV2Result{}
	var retval *GetSpaceListV2Response
	if retval, err2 = p.handler.GetSpaceListV2(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetSpaceListV2: "+err2.Error())
		oprot.WriteMessageBegin("GetSpaceListV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetSpaceListV2", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorMGetUserBasicInfo struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorMGetUserBasicInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceMGetUserBasicInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("MGetUserBasicInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceMGetUserBasicInfoResult{}
	var retval *MGetUserBasicInfoResponse
	if retval, err2 = p.handler.MGetUserBasicInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing MGetUserBasicInfo: "+err2.Error())
		oprot.WriteMessageBegin("MGetUserBasicInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("MGetUserBasicInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorGetBotOnlineInfo struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorGetBotOnlineInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceGetBotOnlineInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetBotOnlineInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceGetBotOnlineInfoResult{}
	var retval *GetBotOnlineInfoResp
	if retval, err2 = p.handler.GetBotOnlineInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetBotOnlineInfo: "+err2.Error())
		oprot.WriteMessageBegin("GetBotOnlineInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetBotOnlineInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type playgroundServiceProcessorUploadFileOpen struct {
	handler PlaygroundService
}

func (p *playgroundServiceProcessorUploadFileOpen) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := PlaygroundServiceUploadFileOpenArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UploadFileOpen", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := PlaygroundServiceUploadFileOpenResult{}
	var retval *UploadFileOpenResponse
	if retval, err2 = p.handler.UploadFileOpen(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UploadFileOpen: "+err2.Error())
		oprot.WriteMessageBegin("UploadFileOpen", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UploadFileOpen", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type PlaygroundServiceUpdateDraftBotInfoAgwArgs struct {
	Request *UpdateDraftBotInfoAgwRequest `thrift:"request,1"`
}

func NewPlaygroundServiceUpdateDraftBotInfoAgwArgs() *PlaygroundServiceUpdateDraftBotInfoAgwArgs {
	return &PlaygroundServiceUpdateDraftBotInfoAgwArgs{}
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) InitDefault() {
}

var PlaygroundServiceUpdateDraftBotInfoAgwArgs_Request_DEFAULT *UpdateDraftBotInfoAgwRequest

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) GetRequest() (v *UpdateDraftBotInfoAgwRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceUpdateDraftBotInfoAgwArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceUpdateDraftBotInfoAgwArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUpdateDraftBotInfoAgwArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpdateDraftBotInfoAgwRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotInfoAgw_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUpdateDraftBotInfoAgwArgs(%+v)", *p)

}

type PlaygroundServiceUpdateDraftBotInfoAgwResult struct {
	Success *UpdateDraftBotInfoAgwResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceUpdateDraftBotInfoAgwResult() *PlaygroundServiceUpdateDraftBotInfoAgwResult {
	return &PlaygroundServiceUpdateDraftBotInfoAgwResult{}
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) InitDefault() {
}

var PlaygroundServiceUpdateDraftBotInfoAgwResult_Success_DEFAULT *UpdateDraftBotInfoAgwResponse

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) GetSuccess() (v *UpdateDraftBotInfoAgwResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceUpdateDraftBotInfoAgwResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceUpdateDraftBotInfoAgwResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUpdateDraftBotInfoAgwResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUpdateDraftBotInfoAgwResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateDraftBotInfoAgw_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceUpdateDraftBotInfoAgwResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUpdateDraftBotInfoAgwResult(%+v)", *p)

}

type PlaygroundServiceGetDraftBotInfoAgwArgs struct {
	Request *GetDraftBotInfoAgwRequest `thrift:"request,1"`
}

func NewPlaygroundServiceGetDraftBotInfoAgwArgs() *PlaygroundServiceGetDraftBotInfoAgwArgs {
	return &PlaygroundServiceGetDraftBotInfoAgwArgs{}
}

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) InitDefault() {
}

var PlaygroundServiceGetDraftBotInfoAgwArgs_Request_DEFAULT *GetDraftBotInfoAgwRequest

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) GetRequest() (v *GetDraftBotInfoAgwRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceGetDraftBotInfoAgwArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceGetDraftBotInfoAgwArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetDraftBotInfoAgwArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetDraftBotInfoAgwRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotInfoAgw_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetDraftBotInfoAgwArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetDraftBotInfoAgwArgs(%+v)", *p)

}

type PlaygroundServiceGetDraftBotInfoAgwResult struct {
	Success *GetDraftBotInfoAgwResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetDraftBotInfoAgwResult() *PlaygroundServiceGetDraftBotInfoAgwResult {
	return &PlaygroundServiceGetDraftBotInfoAgwResult{}
}

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) InitDefault() {
}

var PlaygroundServiceGetDraftBotInfoAgwResult_Success_DEFAULT *GetDraftBotInfoAgwResponse

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) GetSuccess() (v *GetDraftBotInfoAgwResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetDraftBotInfoAgwResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetDraftBotInfoAgwResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetDraftBotInfoAgwResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetDraftBotInfoAgwResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDraftBotInfoAgw_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetDraftBotInfoAgwResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetDraftBotInfoAgwResult(%+v)", *p)

}

type PlaygroundServiceGetImagexShortUrlArgs struct {
	Request *GetImagexShortUrlRequest `thrift:"request,1"`
}

func NewPlaygroundServiceGetImagexShortUrlArgs() *PlaygroundServiceGetImagexShortUrlArgs {
	return &PlaygroundServiceGetImagexShortUrlArgs{}
}

func (p *PlaygroundServiceGetImagexShortUrlArgs) InitDefault() {
}

var PlaygroundServiceGetImagexShortUrlArgs_Request_DEFAULT *GetImagexShortUrlRequest

func (p *PlaygroundServiceGetImagexShortUrlArgs) GetRequest() (v *GetImagexShortUrlRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceGetImagexShortUrlArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceGetImagexShortUrlArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceGetImagexShortUrlArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceGetImagexShortUrlArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetImagexShortUrlArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetImagexShortUrlArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetImagexShortUrlRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceGetImagexShortUrlArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetImagexShortUrl_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetImagexShortUrlArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetImagexShortUrlArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetImagexShortUrlArgs(%+v)", *p)

}

type PlaygroundServiceGetImagexShortUrlResult struct {
	Success *GetImagexShortUrlResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetImagexShortUrlResult() *PlaygroundServiceGetImagexShortUrlResult {
	return &PlaygroundServiceGetImagexShortUrlResult{}
}

func (p *PlaygroundServiceGetImagexShortUrlResult) InitDefault() {
}

var PlaygroundServiceGetImagexShortUrlResult_Success_DEFAULT *GetImagexShortUrlResponse

func (p *PlaygroundServiceGetImagexShortUrlResult) GetSuccess() (v *GetImagexShortUrlResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetImagexShortUrlResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetImagexShortUrlResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetImagexShortUrlResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetImagexShortUrlResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetImagexShortUrlResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetImagexShortUrlResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetImagexShortUrlResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetImagexShortUrlResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetImagexShortUrl_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetImagexShortUrlResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetImagexShortUrlResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetImagexShortUrlResult(%+v)", *p)

}

type PlaygroundServiceGetBotPopupInfoArgs struct {
	Request *GetBotPopupInfoRequest `thrift:"request,1"`
}

func NewPlaygroundServiceGetBotPopupInfoArgs() *PlaygroundServiceGetBotPopupInfoArgs {
	return &PlaygroundServiceGetBotPopupInfoArgs{}
}

func (p *PlaygroundServiceGetBotPopupInfoArgs) InitDefault() {
}

var PlaygroundServiceGetBotPopupInfoArgs_Request_DEFAULT *GetBotPopupInfoRequest

func (p *PlaygroundServiceGetBotPopupInfoArgs) GetRequest() (v *GetBotPopupInfoRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceGetBotPopupInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceGetBotPopupInfoArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceGetBotPopupInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceGetBotPopupInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetBotPopupInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotPopupInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetBotPopupInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceGetBotPopupInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotPopupInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotPopupInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetBotPopupInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetBotPopupInfoArgs(%+v)", *p)

}

type PlaygroundServiceGetBotPopupInfoResult struct {
	Success *GetBotPopupInfoResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetBotPopupInfoResult() *PlaygroundServiceGetBotPopupInfoResult {
	return &PlaygroundServiceGetBotPopupInfoResult{}
}

func (p *PlaygroundServiceGetBotPopupInfoResult) InitDefault() {
}

var PlaygroundServiceGetBotPopupInfoResult_Success_DEFAULT *GetBotPopupInfoResponse

func (p *PlaygroundServiceGetBotPopupInfoResult) GetSuccess() (v *GetBotPopupInfoResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetBotPopupInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetBotPopupInfoResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetBotPopupInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetBotPopupInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetBotPopupInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotPopupInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetBotPopupInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetBotPopupInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotPopupInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotPopupInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetBotPopupInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetBotPopupInfoResult(%+v)", *p)

}

type PlaygroundServiceUpdateBotPopupInfoArgs struct {
	Request *UpdateBotPopupInfoRequest `thrift:"request,1"`
}

func NewPlaygroundServiceUpdateBotPopupInfoArgs() *PlaygroundServiceUpdateBotPopupInfoArgs {
	return &PlaygroundServiceUpdateBotPopupInfoArgs{}
}

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) InitDefault() {
}

var PlaygroundServiceUpdateBotPopupInfoArgs_Request_DEFAULT *UpdateBotPopupInfoRequest

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) GetRequest() (v *UpdateBotPopupInfoRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceUpdateBotPopupInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceUpdateBotPopupInfoArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUpdateBotPopupInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpdateBotPopupInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateBotPopupInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceUpdateBotPopupInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUpdateBotPopupInfoArgs(%+v)", *p)

}

type PlaygroundServiceUpdateBotPopupInfoResult struct {
	Success *UpdateBotPopupInfoResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceUpdateBotPopupInfoResult() *PlaygroundServiceUpdateBotPopupInfoResult {
	return &PlaygroundServiceUpdateBotPopupInfoResult{}
}

func (p *PlaygroundServiceUpdateBotPopupInfoResult) InitDefault() {
}

var PlaygroundServiceUpdateBotPopupInfoResult_Success_DEFAULT *UpdateBotPopupInfoResponse

func (p *PlaygroundServiceUpdateBotPopupInfoResult) GetSuccess() (v *UpdateBotPopupInfoResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceUpdateBotPopupInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceUpdateBotPopupInfoResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceUpdateBotPopupInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceUpdateBotPopupInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUpdateBotPopupInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateBotPopupInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUpdateBotPopupInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceUpdateBotPopupInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateBotPopupInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUpdateBotPopupInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceUpdateBotPopupInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUpdateBotPopupInfoResult(%+v)", *p)

}

type PlaygroundServiceReportUserBehaviorArgs struct {
	Request *ReportUserBehaviorRequest `thrift:"request,1"`
}

func NewPlaygroundServiceReportUserBehaviorArgs() *PlaygroundServiceReportUserBehaviorArgs {
	return &PlaygroundServiceReportUserBehaviorArgs{}
}

func (p *PlaygroundServiceReportUserBehaviorArgs) InitDefault() {
}

var PlaygroundServiceReportUserBehaviorArgs_Request_DEFAULT *ReportUserBehaviorRequest

func (p *PlaygroundServiceReportUserBehaviorArgs) GetRequest() (v *ReportUserBehaviorRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceReportUserBehaviorArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceReportUserBehaviorArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceReportUserBehaviorArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceReportUserBehaviorArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceReportUserBehaviorArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceReportUserBehaviorArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewReportUserBehaviorRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceReportUserBehaviorArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ReportUserBehavior_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceReportUserBehaviorArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceReportUserBehaviorArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceReportUserBehaviorArgs(%+v)", *p)

}

type PlaygroundServiceReportUserBehaviorResult struct {
	Success *ReportUserBehaviorResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceReportUserBehaviorResult() *PlaygroundServiceReportUserBehaviorResult {
	return &PlaygroundServiceReportUserBehaviorResult{}
}

func (p *PlaygroundServiceReportUserBehaviorResult) InitDefault() {
}

var PlaygroundServiceReportUserBehaviorResult_Success_DEFAULT *ReportUserBehaviorResponse

func (p *PlaygroundServiceReportUserBehaviorResult) GetSuccess() (v *ReportUserBehaviorResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceReportUserBehaviorResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceReportUserBehaviorResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceReportUserBehaviorResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceReportUserBehaviorResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceReportUserBehaviorResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceReportUserBehaviorResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewReportUserBehaviorResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceReportUserBehaviorResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ReportUserBehavior_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceReportUserBehaviorResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceReportUserBehaviorResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceReportUserBehaviorResult(%+v)", *p)

}

type PlaygroundServiceCreateUpdateShortcutCommandArgs struct {
	Req *CreateUpdateShortcutCommandRequest `thrift:"req,1"`
}

func NewPlaygroundServiceCreateUpdateShortcutCommandArgs() *PlaygroundServiceCreateUpdateShortcutCommandArgs {
	return &PlaygroundServiceCreateUpdateShortcutCommandArgs{}
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) InitDefault() {
}

var PlaygroundServiceCreateUpdateShortcutCommandArgs_Req_DEFAULT *CreateUpdateShortcutCommandRequest

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) GetReq() (v *CreateUpdateShortcutCommandRequest) {
	if !p.IsSetReq() {
		return PlaygroundServiceCreateUpdateShortcutCommandArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_PlaygroundServiceCreateUpdateShortcutCommandArgs = map[int16]string{
	1: "req",
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceCreateUpdateShortcutCommandArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCreateUpdateShortcutCommandRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateUpdateShortcutCommand_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceCreateUpdateShortcutCommandArgs(%+v)", *p)

}

type PlaygroundServiceCreateUpdateShortcutCommandResult struct {
	Success *CreateUpdateShortcutCommandResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceCreateUpdateShortcutCommandResult() *PlaygroundServiceCreateUpdateShortcutCommandResult {
	return &PlaygroundServiceCreateUpdateShortcutCommandResult{}
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) InitDefault() {
}

var PlaygroundServiceCreateUpdateShortcutCommandResult_Success_DEFAULT *CreateUpdateShortcutCommandResponse

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) GetSuccess() (v *CreateUpdateShortcutCommandResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceCreateUpdateShortcutCommandResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceCreateUpdateShortcutCommandResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceCreateUpdateShortcutCommandResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCreateUpdateShortcutCommandResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateUpdateShortcutCommand_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceCreateUpdateShortcutCommandResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceCreateUpdateShortcutCommandResult(%+v)", *p)

}

type PlaygroundServiceGetFileUrlsArgs struct {
	Req *GetFileUrlsRequest `thrift:"req,1"`
}

func NewPlaygroundServiceGetFileUrlsArgs() *PlaygroundServiceGetFileUrlsArgs {
	return &PlaygroundServiceGetFileUrlsArgs{}
}

func (p *PlaygroundServiceGetFileUrlsArgs) InitDefault() {
}

var PlaygroundServiceGetFileUrlsArgs_Req_DEFAULT *GetFileUrlsRequest

func (p *PlaygroundServiceGetFileUrlsArgs) GetReq() (v *GetFileUrlsRequest) {
	if !p.IsSetReq() {
		return PlaygroundServiceGetFileUrlsArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_PlaygroundServiceGetFileUrlsArgs = map[int16]string{
	1: "req",
}

func (p *PlaygroundServiceGetFileUrlsArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *PlaygroundServiceGetFileUrlsArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetFileUrlsArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetFileUrlsArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetFileUrlsRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *PlaygroundServiceGetFileUrlsArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetFileUrls_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetFileUrlsArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetFileUrlsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetFileUrlsArgs(%+v)", *p)

}

type PlaygroundServiceGetFileUrlsResult struct {
	Success *GetFileUrlsResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetFileUrlsResult() *PlaygroundServiceGetFileUrlsResult {
	return &PlaygroundServiceGetFileUrlsResult{}
}

func (p *PlaygroundServiceGetFileUrlsResult) InitDefault() {
}

var PlaygroundServiceGetFileUrlsResult_Success_DEFAULT *GetFileUrlsResponse

func (p *PlaygroundServiceGetFileUrlsResult) GetSuccess() (v *GetFileUrlsResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetFileUrlsResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetFileUrlsResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetFileUrlsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetFileUrlsResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetFileUrlsResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetFileUrlsResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetFileUrlsResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetFileUrlsResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetFileUrls_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetFileUrlsResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetFileUrlsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetFileUrlsResult(%+v)", *p)

}

type PlaygroundServiceGetOfficialPromptResourceListArgs struct {
	Request *GetOfficialPromptResourceListRequest `thrift:"request,1"`
}

func NewPlaygroundServiceGetOfficialPromptResourceListArgs() *PlaygroundServiceGetOfficialPromptResourceListArgs {
	return &PlaygroundServiceGetOfficialPromptResourceListArgs{}
}

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) InitDefault() {
}

var PlaygroundServiceGetOfficialPromptResourceListArgs_Request_DEFAULT *GetOfficialPromptResourceListRequest

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) GetRequest() (v *GetOfficialPromptResourceListRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceGetOfficialPromptResourceListArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceGetOfficialPromptResourceListArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetOfficialPromptResourceListArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetOfficialPromptResourceListRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetOfficialPromptResourceList_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetOfficialPromptResourceListArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetOfficialPromptResourceListArgs(%+v)", *p)

}

type PlaygroundServiceGetOfficialPromptResourceListResult struct {
	Success *GetOfficialPromptResourceListResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetOfficialPromptResourceListResult() *PlaygroundServiceGetOfficialPromptResourceListResult {
	return &PlaygroundServiceGetOfficialPromptResourceListResult{}
}

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) InitDefault() {
}

var PlaygroundServiceGetOfficialPromptResourceListResult_Success_DEFAULT *GetOfficialPromptResourceListResponse

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) GetSuccess() (v *GetOfficialPromptResourceListResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetOfficialPromptResourceListResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetOfficialPromptResourceListResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetOfficialPromptResourceListResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetOfficialPromptResourceListResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetOfficialPromptResourceList_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetOfficialPromptResourceListResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetOfficialPromptResourceListResult(%+v)", *p)

}

type PlaygroundServiceGetPromptResourceInfoArgs struct {
	Request *GetPromptResourceInfoRequest `thrift:"request,1"`
}

func NewPlaygroundServiceGetPromptResourceInfoArgs() *PlaygroundServiceGetPromptResourceInfoArgs {
	return &PlaygroundServiceGetPromptResourceInfoArgs{}
}

func (p *PlaygroundServiceGetPromptResourceInfoArgs) InitDefault() {
}

var PlaygroundServiceGetPromptResourceInfoArgs_Request_DEFAULT *GetPromptResourceInfoRequest

func (p *PlaygroundServiceGetPromptResourceInfoArgs) GetRequest() (v *GetPromptResourceInfoRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceGetPromptResourceInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceGetPromptResourceInfoArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceGetPromptResourceInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceGetPromptResourceInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetPromptResourceInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetPromptResourceInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetPromptResourceInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceGetPromptResourceInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetPromptResourceInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetPromptResourceInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetPromptResourceInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetPromptResourceInfoArgs(%+v)", *p)

}

type PlaygroundServiceGetPromptResourceInfoResult struct {
	Success *GetPromptResourceInfoResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetPromptResourceInfoResult() *PlaygroundServiceGetPromptResourceInfoResult {
	return &PlaygroundServiceGetPromptResourceInfoResult{}
}

func (p *PlaygroundServiceGetPromptResourceInfoResult) InitDefault() {
}

var PlaygroundServiceGetPromptResourceInfoResult_Success_DEFAULT *GetPromptResourceInfoResponse

func (p *PlaygroundServiceGetPromptResourceInfoResult) GetSuccess() (v *GetPromptResourceInfoResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetPromptResourceInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetPromptResourceInfoResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetPromptResourceInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetPromptResourceInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetPromptResourceInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetPromptResourceInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetPromptResourceInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetPromptResourceInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetPromptResourceInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetPromptResourceInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetPromptResourceInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetPromptResourceInfoResult(%+v)", *p)

}

type PlaygroundServiceUpsertPromptResourceArgs struct {
	Request *UpsertPromptResourceRequest `thrift:"request,1"`
}

func NewPlaygroundServiceUpsertPromptResourceArgs() *PlaygroundServiceUpsertPromptResourceArgs {
	return &PlaygroundServiceUpsertPromptResourceArgs{}
}

func (p *PlaygroundServiceUpsertPromptResourceArgs) InitDefault() {
}

var PlaygroundServiceUpsertPromptResourceArgs_Request_DEFAULT *UpsertPromptResourceRequest

func (p *PlaygroundServiceUpsertPromptResourceArgs) GetRequest() (v *UpsertPromptResourceRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceUpsertPromptResourceArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceUpsertPromptResourceArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceUpsertPromptResourceArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceUpsertPromptResourceArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUpsertPromptResourceArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUpsertPromptResourceArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpsertPromptResourceRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceUpsertPromptResourceArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpsertPromptResource_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUpsertPromptResourceArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceUpsertPromptResourceArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUpsertPromptResourceArgs(%+v)", *p)

}

type PlaygroundServiceUpsertPromptResourceResult struct {
	Success *UpsertPromptResourceResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceUpsertPromptResourceResult() *PlaygroundServiceUpsertPromptResourceResult {
	return &PlaygroundServiceUpsertPromptResourceResult{}
}

func (p *PlaygroundServiceUpsertPromptResourceResult) InitDefault() {
}

var PlaygroundServiceUpsertPromptResourceResult_Success_DEFAULT *UpsertPromptResourceResponse

func (p *PlaygroundServiceUpsertPromptResourceResult) GetSuccess() (v *UpsertPromptResourceResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceUpsertPromptResourceResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceUpsertPromptResourceResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceUpsertPromptResourceResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceUpsertPromptResourceResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUpsertPromptResourceResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUpsertPromptResourceResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUpsertPromptResourceResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceUpsertPromptResourceResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpsertPromptResource_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUpsertPromptResourceResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceUpsertPromptResourceResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUpsertPromptResourceResult(%+v)", *p)

}

type PlaygroundServiceDeletePromptResourceArgs struct {
	Request *DeletePromptResourceRequest `thrift:"request,1"`
}

func NewPlaygroundServiceDeletePromptResourceArgs() *PlaygroundServiceDeletePromptResourceArgs {
	return &PlaygroundServiceDeletePromptResourceArgs{}
}

func (p *PlaygroundServiceDeletePromptResourceArgs) InitDefault() {
}

var PlaygroundServiceDeletePromptResourceArgs_Request_DEFAULT *DeletePromptResourceRequest

func (p *PlaygroundServiceDeletePromptResourceArgs) GetRequest() (v *DeletePromptResourceRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceDeletePromptResourceArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceDeletePromptResourceArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceDeletePromptResourceArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceDeletePromptResourceArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceDeletePromptResourceArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceDeletePromptResourceArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDeletePromptResourceRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceDeletePromptResourceArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeletePromptResource_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceDeletePromptResourceArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceDeletePromptResourceArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceDeletePromptResourceArgs(%+v)", *p)

}

type PlaygroundServiceDeletePromptResourceResult struct {
	Success *DeletePromptResourceResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceDeletePromptResourceResult() *PlaygroundServiceDeletePromptResourceResult {
	return &PlaygroundServiceDeletePromptResourceResult{}
}

func (p *PlaygroundServiceDeletePromptResourceResult) InitDefault() {
}

var PlaygroundServiceDeletePromptResourceResult_Success_DEFAULT *DeletePromptResourceResponse

func (p *PlaygroundServiceDeletePromptResourceResult) GetSuccess() (v *DeletePromptResourceResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceDeletePromptResourceResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceDeletePromptResourceResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceDeletePromptResourceResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceDeletePromptResourceResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceDeletePromptResourceResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceDeletePromptResourceResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDeletePromptResourceResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceDeletePromptResourceResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeletePromptResource_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceDeletePromptResourceResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceDeletePromptResourceResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceDeletePromptResourceResult(%+v)", *p)

}

type PlaygroundServiceGetSpaceListV2Args struct {
	Request *GetSpaceListV2Request `thrift:"request,1"`
}

func NewPlaygroundServiceGetSpaceListV2Args() *PlaygroundServiceGetSpaceListV2Args {
	return &PlaygroundServiceGetSpaceListV2Args{}
}

func (p *PlaygroundServiceGetSpaceListV2Args) InitDefault() {
}

var PlaygroundServiceGetSpaceListV2Args_Request_DEFAULT *GetSpaceListV2Request

func (p *PlaygroundServiceGetSpaceListV2Args) GetRequest() (v *GetSpaceListV2Request) {
	if !p.IsSetRequest() {
		return PlaygroundServiceGetSpaceListV2Args_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceGetSpaceListV2Args = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceGetSpaceListV2Args) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceGetSpaceListV2Args) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetSpaceListV2Args[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetSpaceListV2Args) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetSpaceListV2Request()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceGetSpaceListV2Args) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetSpaceListV2_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetSpaceListV2Args) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetSpaceListV2Args) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetSpaceListV2Args(%+v)", *p)

}

type PlaygroundServiceGetSpaceListV2Result struct {
	Success *GetSpaceListV2Response `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetSpaceListV2Result() *PlaygroundServiceGetSpaceListV2Result {
	return &PlaygroundServiceGetSpaceListV2Result{}
}

func (p *PlaygroundServiceGetSpaceListV2Result) InitDefault() {
}

var PlaygroundServiceGetSpaceListV2Result_Success_DEFAULT *GetSpaceListV2Response

func (p *PlaygroundServiceGetSpaceListV2Result) GetSuccess() (v *GetSpaceListV2Response) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetSpaceListV2Result_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetSpaceListV2Result = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetSpaceListV2Result) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetSpaceListV2Result) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetSpaceListV2Result[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetSpaceListV2Result) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetSpaceListV2Response()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetSpaceListV2Result) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetSpaceListV2_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetSpaceListV2Result) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetSpaceListV2Result) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetSpaceListV2Result(%+v)", *p)

}

type PlaygroundServiceMGetUserBasicInfoArgs struct {
	Request *MGetUserBasicInfoRequest `thrift:"request,1"`
}

func NewPlaygroundServiceMGetUserBasicInfoArgs() *PlaygroundServiceMGetUserBasicInfoArgs {
	return &PlaygroundServiceMGetUserBasicInfoArgs{}
}

func (p *PlaygroundServiceMGetUserBasicInfoArgs) InitDefault() {
}

var PlaygroundServiceMGetUserBasicInfoArgs_Request_DEFAULT *MGetUserBasicInfoRequest

func (p *PlaygroundServiceMGetUserBasicInfoArgs) GetRequest() (v *MGetUserBasicInfoRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceMGetUserBasicInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceMGetUserBasicInfoArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceMGetUserBasicInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceMGetUserBasicInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceMGetUserBasicInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceMGetUserBasicInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewMGetUserBasicInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceMGetUserBasicInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MGetUserBasicInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceMGetUserBasicInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceMGetUserBasicInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceMGetUserBasicInfoArgs(%+v)", *p)

}

type PlaygroundServiceMGetUserBasicInfoResult struct {
	Success *MGetUserBasicInfoResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceMGetUserBasicInfoResult() *PlaygroundServiceMGetUserBasicInfoResult {
	return &PlaygroundServiceMGetUserBasicInfoResult{}
}

func (p *PlaygroundServiceMGetUserBasicInfoResult) InitDefault() {
}

var PlaygroundServiceMGetUserBasicInfoResult_Success_DEFAULT *MGetUserBasicInfoResponse

func (p *PlaygroundServiceMGetUserBasicInfoResult) GetSuccess() (v *MGetUserBasicInfoResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceMGetUserBasicInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceMGetUserBasicInfoResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceMGetUserBasicInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceMGetUserBasicInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceMGetUserBasicInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceMGetUserBasicInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewMGetUserBasicInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceMGetUserBasicInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MGetUserBasicInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceMGetUserBasicInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceMGetUserBasicInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceMGetUserBasicInfoResult(%+v)", *p)

}

type PlaygroundServiceGetBotOnlineInfoArgs struct {
	Request *GetBotOnlineInfoReq `thrift:"request,1"`
}

func NewPlaygroundServiceGetBotOnlineInfoArgs() *PlaygroundServiceGetBotOnlineInfoArgs {
	return &PlaygroundServiceGetBotOnlineInfoArgs{}
}

func (p *PlaygroundServiceGetBotOnlineInfoArgs) InitDefault() {
}

var PlaygroundServiceGetBotOnlineInfoArgs_Request_DEFAULT *GetBotOnlineInfoReq

func (p *PlaygroundServiceGetBotOnlineInfoArgs) GetRequest() (v *GetBotOnlineInfoReq) {
	if !p.IsSetRequest() {
		return PlaygroundServiceGetBotOnlineInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceGetBotOnlineInfoArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceGetBotOnlineInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceGetBotOnlineInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetBotOnlineInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotOnlineInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetBotOnlineInfoReq()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceGetBotOnlineInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotOnlineInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotOnlineInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceGetBotOnlineInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetBotOnlineInfoArgs(%+v)", *p)

}

type PlaygroundServiceGetBotOnlineInfoResult struct {
	Success *GetBotOnlineInfoResp `thrift:"success,0,optional"`
}

func NewPlaygroundServiceGetBotOnlineInfoResult() *PlaygroundServiceGetBotOnlineInfoResult {
	return &PlaygroundServiceGetBotOnlineInfoResult{}
}

func (p *PlaygroundServiceGetBotOnlineInfoResult) InitDefault() {
}

var PlaygroundServiceGetBotOnlineInfoResult_Success_DEFAULT *GetBotOnlineInfoResp

func (p *PlaygroundServiceGetBotOnlineInfoResult) GetSuccess() (v *GetBotOnlineInfoResp) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceGetBotOnlineInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceGetBotOnlineInfoResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceGetBotOnlineInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceGetBotOnlineInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceGetBotOnlineInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotOnlineInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetBotOnlineInfoResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceGetBotOnlineInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetBotOnlineInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceGetBotOnlineInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceGetBotOnlineInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceGetBotOnlineInfoResult(%+v)", *p)

}

type PlaygroundServiceUploadFileOpenArgs struct {
	Request *UploadFileOpenRequest `thrift:"request,1"`
}

func NewPlaygroundServiceUploadFileOpenArgs() *PlaygroundServiceUploadFileOpenArgs {
	return &PlaygroundServiceUploadFileOpenArgs{}
}

func (p *PlaygroundServiceUploadFileOpenArgs) InitDefault() {
}

var PlaygroundServiceUploadFileOpenArgs_Request_DEFAULT *UploadFileOpenRequest

func (p *PlaygroundServiceUploadFileOpenArgs) GetRequest() (v *UploadFileOpenRequest) {
	if !p.IsSetRequest() {
		return PlaygroundServiceUploadFileOpenArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_PlaygroundServiceUploadFileOpenArgs = map[int16]string{
	1: "request",
}

func (p *PlaygroundServiceUploadFileOpenArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *PlaygroundServiceUploadFileOpenArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUploadFileOpenArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUploadFileOpenArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUploadFileOpenRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *PlaygroundServiceUploadFileOpenArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFileOpen_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUploadFileOpenArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *PlaygroundServiceUploadFileOpenArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUploadFileOpenArgs(%+v)", *p)

}

type PlaygroundServiceUploadFileOpenResult struct {
	Success *UploadFileOpenResponse `thrift:"success,0,optional"`
}

func NewPlaygroundServiceUploadFileOpenResult() *PlaygroundServiceUploadFileOpenResult {
	return &PlaygroundServiceUploadFileOpenResult{}
}

func (p *PlaygroundServiceUploadFileOpenResult) InitDefault() {
}

var PlaygroundServiceUploadFileOpenResult_Success_DEFAULT *UploadFileOpenResponse

func (p *PlaygroundServiceUploadFileOpenResult) GetSuccess() (v *UploadFileOpenResponse) {
	if !p.IsSetSuccess() {
		return PlaygroundServiceUploadFileOpenResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_PlaygroundServiceUploadFileOpenResult = map[int16]string{
	0: "success",
}

func (p *PlaygroundServiceUploadFileOpenResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *PlaygroundServiceUploadFileOpenResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PlaygroundServiceUploadFileOpenResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PlaygroundServiceUploadFileOpenResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUploadFileOpenResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *PlaygroundServiceUploadFileOpenResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UploadFileOpen_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PlaygroundServiceUploadFileOpenResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *PlaygroundServiceUploadFileOpenResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PlaygroundServiceUploadFileOpenResult(%+v)", *p)

}
