// Code generated by thriftgo (0.4.1). DO NOT EDIT.

package workflow

import (
	"context"
	"fmt"
	"github.com/apache/thrift/lib/go/thrift"
)

type WorkflowService interface {
	// Create process
	CreateWorkflow(ctx context.Context, request *CreateWorkflowRequest) (r *CreateWorkflowResponse, err error)
	// query process
	GetCanvasInfo(ctx context.Context, request *GetCanvasInfoRequest) (r *GetCanvasInfoResponse, err error)

	GetHistorySchema(ctx context.Context, request *GetHistorySchemaRequest) (r *GetHistorySchemaResponse, err error)
	// save process
	SaveWorkflow(ctx context.Context, request *SaveWorkflowRequest) (r *SaveWorkflowResponse, err error)

	UpdateWorkflowMeta(ctx context.Context, request *UpdateWorkflowMetaRequest) (r *UpdateWorkflowMetaResponse, err error)

	DeleteWorkflow(ctx context.Context, request *DeleteWorkflowRequest) (r *DeleteWorkflowResponse, err error)

	BatchDeleteWorkflow(ctx context.Context, request *BatchDeleteWorkflowRequest) (r *BatchDeleteWorkflowResponse, err error)

	GetDeleteStrategy(ctx context.Context, request *GetDeleteStrategyRequest) (r *GetDeleteStrategyResponse, err error)
	// Publish process. The purpose of this interface is to publish processes that are not internal to the project.
	PublishWorkflow(ctx context.Context, request *PublishWorkflowRequest) (r *PublishWorkflowResponse, err error)

	CopyWorkflow(ctx context.Context, request *CopyWorkflowRequest) (r *CopyWorkflowResponse, err error)

	CopyWkTemplateApi(ctx context.Context, request *CopyWkTemplateApiRequest) (r *CopyWkTemplateApiResponse, err error)

	GetReleasedWorkflows(ctx context.Context, request *GetReleasedWorkflowsRequest) (r *GetReleasedWorkflowsResponse, err error)

	GetWorkflowReferences(ctx context.Context, request *GetWorkflowReferencesRequest) (r *GetWorkflowReferencesResponse, err error)
	// Get a list of sample processes
	GetExampleWorkFlowList(ctx context.Context, request *GetExampleWorkFlowListRequest) (r *GetExampleWorkFlowListResponse, err error)
	// Gets a list of processes.
	GetWorkFlowList(ctx context.Context, request *GetWorkFlowListRequest) (r *GetWorkFlowListResponse, err error)

	QueryWorkflowNodeTypes(ctx context.Context, request *QueryWorkflowNodeTypeRequest) (r *QueryWorkflowNodeTypeResponse, err error)
	// Canvas
	NodeTemplateList(ctx context.Context, request *NodeTemplateListRequest) (r *NodeTemplateListResponse, err error)

	NodePanelSearch(ctx context.Context, request *NodePanelSearchRequest) (r *NodePanelSearchResponse, err error)

	GetLLMNodeFCSettingsMerged(ctx context.Context, req *GetLLMNodeFCSettingsMergedRequest) (r *GetLLMNodeFCSettingsMergedResponse, err error)

	GetLLMNodeFCSettingDetail(ctx context.Context, req *GetLLMNodeFCSettingDetailRequest) (r *GetLLMNodeFCSettingDetailResponse, err error)
	// Practice running process (test run)
	WorkFlowTestRun(ctx context.Context, request *WorkFlowTestRunRequest) (r *WorkFlowTestRunResponse, err error)

	WorkFlowTestResume(ctx context.Context, request *WorkflowTestResumeRequest) (r *WorkflowTestResumeResponse, err error)

	CancelWorkFlow(ctx context.Context, request *CancelWorkFlowRequest) (r *CancelWorkFlowResponse, err error)
	// View practice run history.
	GetWorkFlowProcess(ctx context.Context, request *GetWorkflowProcessRequest) (r *GetWorkflowProcessResponse, err error)

	GetNodeExecuteHistory(ctx context.Context, request *GetNodeExecuteHistoryRequest) (r *GetNodeExecuteHistoryResponse, err error)

	GetApiDetail(ctx context.Context, request *GetApiDetailRequest) (r *GetApiDetailResponse, err error)

	WorkflowNodeDebugV2(ctx context.Context, request *WorkflowNodeDebugV2Request) (r *WorkflowNodeDebugV2Response, err error)
	// file upload
	GetWorkflowUploadAuthToken(ctx context.Context, request *GetUploadAuthTokenRequest) (r *GetUploadAuthTokenResponse, err error)

	SignImageURL(ctx context.Context, request *SignImageURLRequest) (r *SignImageURLResponse, err error)
	// conversation
	CreateProjectConversationDef(ctx context.Context, request *CreateProjectConversationDefRequest) (r *CreateProjectConversationDefResponse, err error)

	UpdateProjectConversationDef(ctx context.Context, request *UpdateProjectConversationDefRequest) (r *UpdateProjectConversationDefResponse, err error)

	DeleteProjectConversationDef(ctx context.Context, request *DeleteProjectConversationDefRequest) (r *DeleteProjectConversationDefResponse, err error)

	ListProjectConversationDef(ctx context.Context, request *ListProjectConversationRequest) (r *ListProjectConversationResponse, err error)
	// Trace
	// List traces of historical execution
	ListRootSpans(ctx context.Context, req *ListRootSpansRequest) (r *ListRootSpansResponse, err error)

	GetTraceSDK(ctx context.Context, req *GetTraceSDKRequest) (r *GetTraceSDKResponse, err error)
	// App
	GetWorkflowDetail(ctx context.Context, request *GetWorkflowDetailRequest) (r *GetWorkflowDetailResponse, err error)

	GetWorkflowDetailInfo(ctx context.Context, request *GetWorkflowDetailInfoRequest) (r *GetWorkflowDetailInfoResponse, err error)

	ValidateTree(ctx context.Context, request *ValidateTreeRequest) (r *ValidateTreeResponse, err error)
	// chat flow role config
	GetChatFlowRole(ctx context.Context, request *GetChatFlowRoleRequest) (r *GetChatFlowRoleResponse, err error)

	CreateChatFlowRole(ctx context.Context, request *CreateChatFlowRoleRequest) (r *CreateChatFlowRoleResponse, err error)

	DeleteChatFlowRole(ctx context.Context, request *DeleteChatFlowRoleRequest) (r *DeleteChatFlowRoleResponse, err error)
	// App Release Management
	ListPublishWorkflow(ctx context.Context, request *ListPublishWorkflowRequest) (r *ListPublishWorkflowResponse, err error)
	// Open API
	OpenAPIRunFlow(ctx context.Context, request *OpenAPIRunFlowRequest) (r *OpenAPIRunFlowResponse, err error)

	OpenAPIStreamRunFlow(ctx context.Context, request *OpenAPIRunFlowRequest) (r *OpenAPIStreamRunFlowResponse, err error)

	OpenAPIStreamResumeFlow(ctx context.Context, request *OpenAPIStreamResumeFlowRequest) (r *OpenAPIStreamRunFlowResponse, err error)

	OpenAPIGetWorkflowRunHistory(ctx context.Context, request *GetWorkflowRunHistoryRequest) (r *GetWorkflowRunHistoryResponse, err error)

	OpenAPIChatFlowRun(ctx context.Context, request *ChatFlowRunRequest) (r *ChatFlowRunResponse, err error)

	OpenAPIGetWorkflowInfo(ctx context.Context, request *OpenAPIGetWorkflowInfoRequest) (r *OpenAPIGetWorkflowInfoResponse, err error)
}

type WorkflowServiceClient struct {
	c thrift.TClient
}

func NewWorkflowServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *WorkflowServiceClient {
	return &WorkflowServiceClient{
		c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
	}
}

func NewWorkflowServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *WorkflowServiceClient {
	return &WorkflowServiceClient{
		c: thrift.NewTStandardClient(iprot, oprot),
	}
}

func NewWorkflowServiceClient(c thrift.TClient) *WorkflowServiceClient {
	return &WorkflowServiceClient{
		c: c,
	}
}

func (p *WorkflowServiceClient) Client_() thrift.TClient {
	return p.c
}

func (p *WorkflowServiceClient) CreateWorkflow(ctx context.Context, request *CreateWorkflowRequest) (r *CreateWorkflowResponse, err error) {
	var _args WorkflowServiceCreateWorkflowArgs
	_args.Request = request
	var _result WorkflowServiceCreateWorkflowResult
	if err = p.Client_().Call(ctx, "CreateWorkflow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetCanvasInfo(ctx context.Context, request *GetCanvasInfoRequest) (r *GetCanvasInfoResponse, err error) {
	var _args WorkflowServiceGetCanvasInfoArgs
	_args.Request = request
	var _result WorkflowServiceGetCanvasInfoResult
	if err = p.Client_().Call(ctx, "GetCanvasInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetHistorySchema(ctx context.Context, request *GetHistorySchemaRequest) (r *GetHistorySchemaResponse, err error) {
	var _args WorkflowServiceGetHistorySchemaArgs
	_args.Request = request
	var _result WorkflowServiceGetHistorySchemaResult
	if err = p.Client_().Call(ctx, "GetHistorySchema", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) SaveWorkflow(ctx context.Context, request *SaveWorkflowRequest) (r *SaveWorkflowResponse, err error) {
	var _args WorkflowServiceSaveWorkflowArgs
	_args.Request = request
	var _result WorkflowServiceSaveWorkflowResult
	if err = p.Client_().Call(ctx, "SaveWorkflow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) UpdateWorkflowMeta(ctx context.Context, request *UpdateWorkflowMetaRequest) (r *UpdateWorkflowMetaResponse, err error) {
	var _args WorkflowServiceUpdateWorkflowMetaArgs
	_args.Request = request
	var _result WorkflowServiceUpdateWorkflowMetaResult
	if err = p.Client_().Call(ctx, "UpdateWorkflowMeta", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) DeleteWorkflow(ctx context.Context, request *DeleteWorkflowRequest) (r *DeleteWorkflowResponse, err error) {
	var _args WorkflowServiceDeleteWorkflowArgs
	_args.Request = request
	var _result WorkflowServiceDeleteWorkflowResult
	if err = p.Client_().Call(ctx, "DeleteWorkflow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) BatchDeleteWorkflow(ctx context.Context, request *BatchDeleteWorkflowRequest) (r *BatchDeleteWorkflowResponse, err error) {
	var _args WorkflowServiceBatchDeleteWorkflowArgs
	_args.Request = request
	var _result WorkflowServiceBatchDeleteWorkflowResult
	if err = p.Client_().Call(ctx, "BatchDeleteWorkflow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetDeleteStrategy(ctx context.Context, request *GetDeleteStrategyRequest) (r *GetDeleteStrategyResponse, err error) {
	var _args WorkflowServiceGetDeleteStrategyArgs
	_args.Request = request
	var _result WorkflowServiceGetDeleteStrategyResult
	if err = p.Client_().Call(ctx, "GetDeleteStrategy", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) PublishWorkflow(ctx context.Context, request *PublishWorkflowRequest) (r *PublishWorkflowResponse, err error) {
	var _args WorkflowServicePublishWorkflowArgs
	_args.Request = request
	var _result WorkflowServicePublishWorkflowResult
	if err = p.Client_().Call(ctx, "PublishWorkflow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) CopyWorkflow(ctx context.Context, request *CopyWorkflowRequest) (r *CopyWorkflowResponse, err error) {
	var _args WorkflowServiceCopyWorkflowArgs
	_args.Request = request
	var _result WorkflowServiceCopyWorkflowResult
	if err = p.Client_().Call(ctx, "CopyWorkflow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) CopyWkTemplateApi(ctx context.Context, request *CopyWkTemplateApiRequest) (r *CopyWkTemplateApiResponse, err error) {
	var _args WorkflowServiceCopyWkTemplateApiArgs
	_args.Request = request
	var _result WorkflowServiceCopyWkTemplateApiResult
	if err = p.Client_().Call(ctx, "CopyWkTemplateApi", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetReleasedWorkflows(ctx context.Context, request *GetReleasedWorkflowsRequest) (r *GetReleasedWorkflowsResponse, err error) {
	var _args WorkflowServiceGetReleasedWorkflowsArgs
	_args.Request = request
	var _result WorkflowServiceGetReleasedWorkflowsResult
	if err = p.Client_().Call(ctx, "GetReleasedWorkflows", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetWorkflowReferences(ctx context.Context, request *GetWorkflowReferencesRequest) (r *GetWorkflowReferencesResponse, err error) {
	var _args WorkflowServiceGetWorkflowReferencesArgs
	_args.Request = request
	var _result WorkflowServiceGetWorkflowReferencesResult
	if err = p.Client_().Call(ctx, "GetWorkflowReferences", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetExampleWorkFlowList(ctx context.Context, request *GetExampleWorkFlowListRequest) (r *GetExampleWorkFlowListResponse, err error) {
	var _args WorkflowServiceGetExampleWorkFlowListArgs
	_args.Request = request
	var _result WorkflowServiceGetExampleWorkFlowListResult
	if err = p.Client_().Call(ctx, "GetExampleWorkFlowList", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetWorkFlowList(ctx context.Context, request *GetWorkFlowListRequest) (r *GetWorkFlowListResponse, err error) {
	var _args WorkflowServiceGetWorkFlowListArgs
	_args.Request = request
	var _result WorkflowServiceGetWorkFlowListResult
	if err = p.Client_().Call(ctx, "GetWorkFlowList", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) QueryWorkflowNodeTypes(ctx context.Context, request *QueryWorkflowNodeTypeRequest) (r *QueryWorkflowNodeTypeResponse, err error) {
	var _args WorkflowServiceQueryWorkflowNodeTypesArgs
	_args.Request = request
	var _result WorkflowServiceQueryWorkflowNodeTypesResult
	if err = p.Client_().Call(ctx, "QueryWorkflowNodeTypes", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) NodeTemplateList(ctx context.Context, request *NodeTemplateListRequest) (r *NodeTemplateListResponse, err error) {
	var _args WorkflowServiceNodeTemplateListArgs
	_args.Request = request
	var _result WorkflowServiceNodeTemplateListResult
	if err = p.Client_().Call(ctx, "NodeTemplateList", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) NodePanelSearch(ctx context.Context, request *NodePanelSearchRequest) (r *NodePanelSearchResponse, err error) {
	var _args WorkflowServiceNodePanelSearchArgs
	_args.Request = request
	var _result WorkflowServiceNodePanelSearchResult
	if err = p.Client_().Call(ctx, "NodePanelSearch", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetLLMNodeFCSettingsMerged(ctx context.Context, req *GetLLMNodeFCSettingsMergedRequest) (r *GetLLMNodeFCSettingsMergedResponse, err error) {
	var _args WorkflowServiceGetLLMNodeFCSettingsMergedArgs
	_args.Req = req
	var _result WorkflowServiceGetLLMNodeFCSettingsMergedResult
	if err = p.Client_().Call(ctx, "GetLLMNodeFCSettingsMerged", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetLLMNodeFCSettingDetail(ctx context.Context, req *GetLLMNodeFCSettingDetailRequest) (r *GetLLMNodeFCSettingDetailResponse, err error) {
	var _args WorkflowServiceGetLLMNodeFCSettingDetailArgs
	_args.Req = req
	var _result WorkflowServiceGetLLMNodeFCSettingDetailResult
	if err = p.Client_().Call(ctx, "GetLLMNodeFCSettingDetail", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) WorkFlowTestRun(ctx context.Context, request *WorkFlowTestRunRequest) (r *WorkFlowTestRunResponse, err error) {
	var _args WorkflowServiceWorkFlowTestRunArgs
	_args.Request = request
	var _result WorkflowServiceWorkFlowTestRunResult
	if err = p.Client_().Call(ctx, "WorkFlowTestRun", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) WorkFlowTestResume(ctx context.Context, request *WorkflowTestResumeRequest) (r *WorkflowTestResumeResponse, err error) {
	var _args WorkflowServiceWorkFlowTestResumeArgs
	_args.Request = request
	var _result WorkflowServiceWorkFlowTestResumeResult
	if err = p.Client_().Call(ctx, "WorkFlowTestResume", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) CancelWorkFlow(ctx context.Context, request *CancelWorkFlowRequest) (r *CancelWorkFlowResponse, err error) {
	var _args WorkflowServiceCancelWorkFlowArgs
	_args.Request = request
	var _result WorkflowServiceCancelWorkFlowResult
	if err = p.Client_().Call(ctx, "CancelWorkFlow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetWorkFlowProcess(ctx context.Context, request *GetWorkflowProcessRequest) (r *GetWorkflowProcessResponse, err error) {
	var _args WorkflowServiceGetWorkFlowProcessArgs
	_args.Request = request
	var _result WorkflowServiceGetWorkFlowProcessResult
	if err = p.Client_().Call(ctx, "GetWorkFlowProcess", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetNodeExecuteHistory(ctx context.Context, request *GetNodeExecuteHistoryRequest) (r *GetNodeExecuteHistoryResponse, err error) {
	var _args WorkflowServiceGetNodeExecuteHistoryArgs
	_args.Request = request
	var _result WorkflowServiceGetNodeExecuteHistoryResult
	if err = p.Client_().Call(ctx, "GetNodeExecuteHistory", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetApiDetail(ctx context.Context, request *GetApiDetailRequest) (r *GetApiDetailResponse, err error) {
	var _args WorkflowServiceGetApiDetailArgs
	_args.Request = request
	var _result WorkflowServiceGetApiDetailResult
	if err = p.Client_().Call(ctx, "GetApiDetail", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) WorkflowNodeDebugV2(ctx context.Context, request *WorkflowNodeDebugV2Request) (r *WorkflowNodeDebugV2Response, err error) {
	var _args WorkflowServiceWorkflowNodeDebugV2Args
	_args.Request = request
	var _result WorkflowServiceWorkflowNodeDebugV2Result
	if err = p.Client_().Call(ctx, "WorkflowNodeDebugV2", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetWorkflowUploadAuthToken(ctx context.Context, request *GetUploadAuthTokenRequest) (r *GetUploadAuthTokenResponse, err error) {
	var _args WorkflowServiceGetWorkflowUploadAuthTokenArgs
	_args.Request = request
	var _result WorkflowServiceGetWorkflowUploadAuthTokenResult
	if err = p.Client_().Call(ctx, "GetWorkflowUploadAuthToken", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) SignImageURL(ctx context.Context, request *SignImageURLRequest) (r *SignImageURLResponse, err error) {
	var _args WorkflowServiceSignImageURLArgs
	_args.Request = request
	var _result WorkflowServiceSignImageURLResult
	if err = p.Client_().Call(ctx, "SignImageURL", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) CreateProjectConversationDef(ctx context.Context, request *CreateProjectConversationDefRequest) (r *CreateProjectConversationDefResponse, err error) {
	var _args WorkflowServiceCreateProjectConversationDefArgs
	_args.Request = request
	var _result WorkflowServiceCreateProjectConversationDefResult
	if err = p.Client_().Call(ctx, "CreateProjectConversationDef", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) UpdateProjectConversationDef(ctx context.Context, request *UpdateProjectConversationDefRequest) (r *UpdateProjectConversationDefResponse, err error) {
	var _args WorkflowServiceUpdateProjectConversationDefArgs
	_args.Request = request
	var _result WorkflowServiceUpdateProjectConversationDefResult
	if err = p.Client_().Call(ctx, "UpdateProjectConversationDef", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) DeleteProjectConversationDef(ctx context.Context, request *DeleteProjectConversationDefRequest) (r *DeleteProjectConversationDefResponse, err error) {
	var _args WorkflowServiceDeleteProjectConversationDefArgs
	_args.Request = request
	var _result WorkflowServiceDeleteProjectConversationDefResult
	if err = p.Client_().Call(ctx, "DeleteProjectConversationDef", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) ListProjectConversationDef(ctx context.Context, request *ListProjectConversationRequest) (r *ListProjectConversationResponse, err error) {
	var _args WorkflowServiceListProjectConversationDefArgs
	_args.Request = request
	var _result WorkflowServiceListProjectConversationDefResult
	if err = p.Client_().Call(ctx, "ListProjectConversationDef", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) ListRootSpans(ctx context.Context, req *ListRootSpansRequest) (r *ListRootSpansResponse, err error) {
	var _args WorkflowServiceListRootSpansArgs
	_args.Req = req
	var _result WorkflowServiceListRootSpansResult
	if err = p.Client_().Call(ctx, "ListRootSpans", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetTraceSDK(ctx context.Context, req *GetTraceSDKRequest) (r *GetTraceSDKResponse, err error) {
	var _args WorkflowServiceGetTraceSDKArgs
	_args.Req = req
	var _result WorkflowServiceGetTraceSDKResult
	if err = p.Client_().Call(ctx, "GetTraceSDK", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetWorkflowDetail(ctx context.Context, request *GetWorkflowDetailRequest) (r *GetWorkflowDetailResponse, err error) {
	var _args WorkflowServiceGetWorkflowDetailArgs
	_args.Request = request
	var _result WorkflowServiceGetWorkflowDetailResult
	if err = p.Client_().Call(ctx, "GetWorkflowDetail", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetWorkflowDetailInfo(ctx context.Context, request *GetWorkflowDetailInfoRequest) (r *GetWorkflowDetailInfoResponse, err error) {
	var _args WorkflowServiceGetWorkflowDetailInfoArgs
	_args.Request = request
	var _result WorkflowServiceGetWorkflowDetailInfoResult
	if err = p.Client_().Call(ctx, "GetWorkflowDetailInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) ValidateTree(ctx context.Context, request *ValidateTreeRequest) (r *ValidateTreeResponse, err error) {
	var _args WorkflowServiceValidateTreeArgs
	_args.Request = request
	var _result WorkflowServiceValidateTreeResult
	if err = p.Client_().Call(ctx, "ValidateTree", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) GetChatFlowRole(ctx context.Context, request *GetChatFlowRoleRequest) (r *GetChatFlowRoleResponse, err error) {
	var _args WorkflowServiceGetChatFlowRoleArgs
	_args.Request = request
	var _result WorkflowServiceGetChatFlowRoleResult
	if err = p.Client_().Call(ctx, "GetChatFlowRole", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) CreateChatFlowRole(ctx context.Context, request *CreateChatFlowRoleRequest) (r *CreateChatFlowRoleResponse, err error) {
	var _args WorkflowServiceCreateChatFlowRoleArgs
	_args.Request = request
	var _result WorkflowServiceCreateChatFlowRoleResult
	if err = p.Client_().Call(ctx, "CreateChatFlowRole", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) DeleteChatFlowRole(ctx context.Context, request *DeleteChatFlowRoleRequest) (r *DeleteChatFlowRoleResponse, err error) {
	var _args WorkflowServiceDeleteChatFlowRoleArgs
	_args.Request = request
	var _result WorkflowServiceDeleteChatFlowRoleResult
	if err = p.Client_().Call(ctx, "DeleteChatFlowRole", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) ListPublishWorkflow(ctx context.Context, request *ListPublishWorkflowRequest) (r *ListPublishWorkflowResponse, err error) {
	var _args WorkflowServiceListPublishWorkflowArgs
	_args.Request = request
	var _result WorkflowServiceListPublishWorkflowResult
	if err = p.Client_().Call(ctx, "ListPublishWorkflow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) OpenAPIRunFlow(ctx context.Context, request *OpenAPIRunFlowRequest) (r *OpenAPIRunFlowResponse, err error) {
	var _args WorkflowServiceOpenAPIRunFlowArgs
	_args.Request = request
	var _result WorkflowServiceOpenAPIRunFlowResult
	if err = p.Client_().Call(ctx, "OpenAPIRunFlow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) OpenAPIStreamRunFlow(ctx context.Context, request *OpenAPIRunFlowRequest) (r *OpenAPIStreamRunFlowResponse, err error) {
	var _args WorkflowServiceOpenAPIStreamRunFlowArgs
	_args.Request = request
	var _result WorkflowServiceOpenAPIStreamRunFlowResult
	if err = p.Client_().Call(ctx, "OpenAPIStreamRunFlow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) OpenAPIStreamResumeFlow(ctx context.Context, request *OpenAPIStreamResumeFlowRequest) (r *OpenAPIStreamRunFlowResponse, err error) {
	var _args WorkflowServiceOpenAPIStreamResumeFlowArgs
	_args.Request = request
	var _result WorkflowServiceOpenAPIStreamResumeFlowResult
	if err = p.Client_().Call(ctx, "OpenAPIStreamResumeFlow", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) OpenAPIGetWorkflowRunHistory(ctx context.Context, request *GetWorkflowRunHistoryRequest) (r *GetWorkflowRunHistoryResponse, err error) {
	var _args WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs
	_args.Request = request
	var _result WorkflowServiceOpenAPIGetWorkflowRunHistoryResult
	if err = p.Client_().Call(ctx, "OpenAPIGetWorkflowRunHistory", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) OpenAPIChatFlowRun(ctx context.Context, request *ChatFlowRunRequest) (r *ChatFlowRunResponse, err error) {
	var _args WorkflowServiceOpenAPIChatFlowRunArgs
	_args.Request = request
	var _result WorkflowServiceOpenAPIChatFlowRunResult
	if err = p.Client_().Call(ctx, "OpenAPIChatFlowRun", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}
func (p *WorkflowServiceClient) OpenAPIGetWorkflowInfo(ctx context.Context, request *OpenAPIGetWorkflowInfoRequest) (r *OpenAPIGetWorkflowInfoResponse, err error) {
	var _args WorkflowServiceOpenAPIGetWorkflowInfoArgs
	_args.Request = request
	var _result WorkflowServiceOpenAPIGetWorkflowInfoResult
	if err = p.Client_().Call(ctx, "OpenAPIGetWorkflowInfo", &_args, &_result); err != nil {
		return
	}
	return _result.GetSuccess(), nil
}

type WorkflowServiceProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      WorkflowService
}

func (p *WorkflowServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *WorkflowServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *WorkflowServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewWorkflowServiceProcessor(handler WorkflowService) *WorkflowServiceProcessor {
	self := &WorkflowServiceProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self.AddToProcessorMap("CreateWorkflow", &workflowServiceProcessorCreateWorkflow{handler: handler})
	self.AddToProcessorMap("GetCanvasInfo", &workflowServiceProcessorGetCanvasInfo{handler: handler})
	self.AddToProcessorMap("GetHistorySchema", &workflowServiceProcessorGetHistorySchema{handler: handler})
	self.AddToProcessorMap("SaveWorkflow", &workflowServiceProcessorSaveWorkflow{handler: handler})
	self.AddToProcessorMap("UpdateWorkflowMeta", &workflowServiceProcessorUpdateWorkflowMeta{handler: handler})
	self.AddToProcessorMap("DeleteWorkflow", &workflowServiceProcessorDeleteWorkflow{handler: handler})
	self.AddToProcessorMap("BatchDeleteWorkflow", &workflowServiceProcessorBatchDeleteWorkflow{handler: handler})
	self.AddToProcessorMap("GetDeleteStrategy", &workflowServiceProcessorGetDeleteStrategy{handler: handler})
	self.AddToProcessorMap("PublishWorkflow", &workflowServiceProcessorPublishWorkflow{handler: handler})
	self.AddToProcessorMap("CopyWorkflow", &workflowServiceProcessorCopyWorkflow{handler: handler})
	self.AddToProcessorMap("CopyWkTemplateApi", &workflowServiceProcessorCopyWkTemplateApi{handler: handler})
	self.AddToProcessorMap("GetReleasedWorkflows", &workflowServiceProcessorGetReleasedWorkflows{handler: handler})
	self.AddToProcessorMap("GetWorkflowReferences", &workflowServiceProcessorGetWorkflowReferences{handler: handler})
	self.AddToProcessorMap("GetExampleWorkFlowList", &workflowServiceProcessorGetExampleWorkFlowList{handler: handler})
	self.AddToProcessorMap("GetWorkFlowList", &workflowServiceProcessorGetWorkFlowList{handler: handler})
	self.AddToProcessorMap("QueryWorkflowNodeTypes", &workflowServiceProcessorQueryWorkflowNodeTypes{handler: handler})
	self.AddToProcessorMap("NodeTemplateList", &workflowServiceProcessorNodeTemplateList{handler: handler})
	self.AddToProcessorMap("NodePanelSearch", &workflowServiceProcessorNodePanelSearch{handler: handler})
	self.AddToProcessorMap("GetLLMNodeFCSettingsMerged", &workflowServiceProcessorGetLLMNodeFCSettingsMerged{handler: handler})
	self.AddToProcessorMap("GetLLMNodeFCSettingDetail", &workflowServiceProcessorGetLLMNodeFCSettingDetail{handler: handler})
	self.AddToProcessorMap("WorkFlowTestRun", &workflowServiceProcessorWorkFlowTestRun{handler: handler})
	self.AddToProcessorMap("WorkFlowTestResume", &workflowServiceProcessorWorkFlowTestResume{handler: handler})
	self.AddToProcessorMap("CancelWorkFlow", &workflowServiceProcessorCancelWorkFlow{handler: handler})
	self.AddToProcessorMap("GetWorkFlowProcess", &workflowServiceProcessorGetWorkFlowProcess{handler: handler})
	self.AddToProcessorMap("GetNodeExecuteHistory", &workflowServiceProcessorGetNodeExecuteHistory{handler: handler})
	self.AddToProcessorMap("GetApiDetail", &workflowServiceProcessorGetApiDetail{handler: handler})
	self.AddToProcessorMap("WorkflowNodeDebugV2", &workflowServiceProcessorWorkflowNodeDebugV2{handler: handler})
	self.AddToProcessorMap("GetWorkflowUploadAuthToken", &workflowServiceProcessorGetWorkflowUploadAuthToken{handler: handler})
	self.AddToProcessorMap("SignImageURL", &workflowServiceProcessorSignImageURL{handler: handler})
	self.AddToProcessorMap("CreateProjectConversationDef", &workflowServiceProcessorCreateProjectConversationDef{handler: handler})
	self.AddToProcessorMap("UpdateProjectConversationDef", &workflowServiceProcessorUpdateProjectConversationDef{handler: handler})
	self.AddToProcessorMap("DeleteProjectConversationDef", &workflowServiceProcessorDeleteProjectConversationDef{handler: handler})
	self.AddToProcessorMap("ListProjectConversationDef", &workflowServiceProcessorListProjectConversationDef{handler: handler})
	self.AddToProcessorMap("ListRootSpans", &workflowServiceProcessorListRootSpans{handler: handler})
	self.AddToProcessorMap("GetTraceSDK", &workflowServiceProcessorGetTraceSDK{handler: handler})
	self.AddToProcessorMap("GetWorkflowDetail", &workflowServiceProcessorGetWorkflowDetail{handler: handler})
	self.AddToProcessorMap("GetWorkflowDetailInfo", &workflowServiceProcessorGetWorkflowDetailInfo{handler: handler})
	self.AddToProcessorMap("ValidateTree", &workflowServiceProcessorValidateTree{handler: handler})
	self.AddToProcessorMap("GetChatFlowRole", &workflowServiceProcessorGetChatFlowRole{handler: handler})
	self.AddToProcessorMap("CreateChatFlowRole", &workflowServiceProcessorCreateChatFlowRole{handler: handler})
	self.AddToProcessorMap("DeleteChatFlowRole", &workflowServiceProcessorDeleteChatFlowRole{handler: handler})
	self.AddToProcessorMap("ListPublishWorkflow", &workflowServiceProcessorListPublishWorkflow{handler: handler})
	self.AddToProcessorMap("OpenAPIRunFlow", &workflowServiceProcessorOpenAPIRunFlow{handler: handler})
	self.AddToProcessorMap("OpenAPIStreamRunFlow", &workflowServiceProcessorOpenAPIStreamRunFlow{handler: handler})
	self.AddToProcessorMap("OpenAPIStreamResumeFlow", &workflowServiceProcessorOpenAPIStreamResumeFlow{handler: handler})
	self.AddToProcessorMap("OpenAPIGetWorkflowRunHistory", &workflowServiceProcessorOpenAPIGetWorkflowRunHistory{handler: handler})
	self.AddToProcessorMap("OpenAPIChatFlowRun", &workflowServiceProcessorOpenAPIChatFlowRun{handler: handler})
	self.AddToProcessorMap("OpenAPIGetWorkflowInfo", &workflowServiceProcessorOpenAPIGetWorkflowInfo{handler: handler})
	return self
}
func (p *WorkflowServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err := iprot.ReadMessageBegin()
	if err != nil {
		return false, err
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(ctx, seqId, iprot, oprot)
	}
	iprot.Skip(thrift.STRUCT)
	iprot.ReadMessageEnd()
	x := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(name, thrift.EXCEPTION, seqId)
	x.Write(oprot)
	oprot.WriteMessageEnd()
	oprot.Flush(ctx)
	return false, x
}

type workflowServiceProcessorCreateWorkflow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorCreateWorkflow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceCreateWorkflowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CreateWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceCreateWorkflowResult{}
	var retval *CreateWorkflowResponse
	if retval, err2 = p.handler.CreateWorkflow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CreateWorkflow: "+err2.Error())
		oprot.WriteMessageBegin("CreateWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CreateWorkflow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetCanvasInfo struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetCanvasInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetCanvasInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetCanvasInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetCanvasInfoResult{}
	var retval *GetCanvasInfoResponse
	if retval, err2 = p.handler.GetCanvasInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetCanvasInfo: "+err2.Error())
		oprot.WriteMessageBegin("GetCanvasInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetCanvasInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetHistorySchema struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetHistorySchema) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetHistorySchemaArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetHistorySchema", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetHistorySchemaResult{}
	var retval *GetHistorySchemaResponse
	if retval, err2 = p.handler.GetHistorySchema(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetHistorySchema: "+err2.Error())
		oprot.WriteMessageBegin("GetHistorySchema", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetHistorySchema", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorSaveWorkflow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorSaveWorkflow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceSaveWorkflowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("SaveWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceSaveWorkflowResult{}
	var retval *SaveWorkflowResponse
	if retval, err2 = p.handler.SaveWorkflow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing SaveWorkflow: "+err2.Error())
		oprot.WriteMessageBegin("SaveWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("SaveWorkflow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorUpdateWorkflowMeta struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorUpdateWorkflowMeta) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceUpdateWorkflowMetaArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UpdateWorkflowMeta", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceUpdateWorkflowMetaResult{}
	var retval *UpdateWorkflowMetaResponse
	if retval, err2 = p.handler.UpdateWorkflowMeta(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UpdateWorkflowMeta: "+err2.Error())
		oprot.WriteMessageBegin("UpdateWorkflowMeta", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UpdateWorkflowMeta", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorDeleteWorkflow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorDeleteWorkflow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceDeleteWorkflowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("DeleteWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceDeleteWorkflowResult{}
	var retval *DeleteWorkflowResponse
	if retval, err2 = p.handler.DeleteWorkflow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing DeleteWorkflow: "+err2.Error())
		oprot.WriteMessageBegin("DeleteWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("DeleteWorkflow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorBatchDeleteWorkflow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorBatchDeleteWorkflow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceBatchDeleteWorkflowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("BatchDeleteWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceBatchDeleteWorkflowResult{}
	var retval *BatchDeleteWorkflowResponse
	if retval, err2 = p.handler.BatchDeleteWorkflow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing BatchDeleteWorkflow: "+err2.Error())
		oprot.WriteMessageBegin("BatchDeleteWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("BatchDeleteWorkflow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetDeleteStrategy struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetDeleteStrategy) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetDeleteStrategyArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetDeleteStrategy", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetDeleteStrategyResult{}
	var retval *GetDeleteStrategyResponse
	if retval, err2 = p.handler.GetDeleteStrategy(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetDeleteStrategy: "+err2.Error())
		oprot.WriteMessageBegin("GetDeleteStrategy", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetDeleteStrategy", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorPublishWorkflow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorPublishWorkflow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServicePublishWorkflowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("PublishWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServicePublishWorkflowResult{}
	var retval *PublishWorkflowResponse
	if retval, err2 = p.handler.PublishWorkflow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing PublishWorkflow: "+err2.Error())
		oprot.WriteMessageBegin("PublishWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("PublishWorkflow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorCopyWorkflow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorCopyWorkflow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceCopyWorkflowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CopyWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceCopyWorkflowResult{}
	var retval *CopyWorkflowResponse
	if retval, err2 = p.handler.CopyWorkflow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CopyWorkflow: "+err2.Error())
		oprot.WriteMessageBegin("CopyWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CopyWorkflow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorCopyWkTemplateApi struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorCopyWkTemplateApi) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceCopyWkTemplateApiArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CopyWkTemplateApi", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceCopyWkTemplateApiResult{}
	var retval *CopyWkTemplateApiResponse
	if retval, err2 = p.handler.CopyWkTemplateApi(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CopyWkTemplateApi: "+err2.Error())
		oprot.WriteMessageBegin("CopyWkTemplateApi", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CopyWkTemplateApi", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetReleasedWorkflows struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetReleasedWorkflows) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetReleasedWorkflowsArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetReleasedWorkflows", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetReleasedWorkflowsResult{}
	var retval *GetReleasedWorkflowsResponse
	if retval, err2 = p.handler.GetReleasedWorkflows(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetReleasedWorkflows: "+err2.Error())
		oprot.WriteMessageBegin("GetReleasedWorkflows", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetReleasedWorkflows", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetWorkflowReferences struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetWorkflowReferences) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetWorkflowReferencesArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetWorkflowReferences", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetWorkflowReferencesResult{}
	var retval *GetWorkflowReferencesResponse
	if retval, err2 = p.handler.GetWorkflowReferences(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetWorkflowReferences: "+err2.Error())
		oprot.WriteMessageBegin("GetWorkflowReferences", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetWorkflowReferences", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetExampleWorkFlowList struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetExampleWorkFlowList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetExampleWorkFlowListArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetExampleWorkFlowList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetExampleWorkFlowListResult{}
	var retval *GetExampleWorkFlowListResponse
	if retval, err2 = p.handler.GetExampleWorkFlowList(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetExampleWorkFlowList: "+err2.Error())
		oprot.WriteMessageBegin("GetExampleWorkFlowList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetExampleWorkFlowList", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetWorkFlowList struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetWorkFlowList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetWorkFlowListArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetWorkFlowList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetWorkFlowListResult{}
	var retval *GetWorkFlowListResponse
	if retval, err2 = p.handler.GetWorkFlowList(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetWorkFlowList: "+err2.Error())
		oprot.WriteMessageBegin("GetWorkFlowList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetWorkFlowList", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorQueryWorkflowNodeTypes struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorQueryWorkflowNodeTypes) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceQueryWorkflowNodeTypesArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("QueryWorkflowNodeTypes", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceQueryWorkflowNodeTypesResult{}
	var retval *QueryWorkflowNodeTypeResponse
	if retval, err2 = p.handler.QueryWorkflowNodeTypes(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing QueryWorkflowNodeTypes: "+err2.Error())
		oprot.WriteMessageBegin("QueryWorkflowNodeTypes", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("QueryWorkflowNodeTypes", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorNodeTemplateList struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorNodeTemplateList) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceNodeTemplateListArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("NodeTemplateList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceNodeTemplateListResult{}
	var retval *NodeTemplateListResponse
	if retval, err2 = p.handler.NodeTemplateList(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing NodeTemplateList: "+err2.Error())
		oprot.WriteMessageBegin("NodeTemplateList", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("NodeTemplateList", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorNodePanelSearch struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorNodePanelSearch) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceNodePanelSearchArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("NodePanelSearch", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceNodePanelSearchResult{}
	var retval *NodePanelSearchResponse
	if retval, err2 = p.handler.NodePanelSearch(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing NodePanelSearch: "+err2.Error())
		oprot.WriteMessageBegin("NodePanelSearch", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("NodePanelSearch", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetLLMNodeFCSettingsMerged struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetLLMNodeFCSettingsMerged) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetLLMNodeFCSettingsMergedArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetLLMNodeFCSettingsMerged", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetLLMNodeFCSettingsMergedResult{}
	var retval *GetLLMNodeFCSettingsMergedResponse
	if retval, err2 = p.handler.GetLLMNodeFCSettingsMerged(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetLLMNodeFCSettingsMerged: "+err2.Error())
		oprot.WriteMessageBegin("GetLLMNodeFCSettingsMerged", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetLLMNodeFCSettingsMerged", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetLLMNodeFCSettingDetail struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetLLMNodeFCSettingDetail) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetLLMNodeFCSettingDetailArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetLLMNodeFCSettingDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetLLMNodeFCSettingDetailResult{}
	var retval *GetLLMNodeFCSettingDetailResponse
	if retval, err2 = p.handler.GetLLMNodeFCSettingDetail(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetLLMNodeFCSettingDetail: "+err2.Error())
		oprot.WriteMessageBegin("GetLLMNodeFCSettingDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetLLMNodeFCSettingDetail", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorWorkFlowTestRun struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorWorkFlowTestRun) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceWorkFlowTestRunArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("WorkFlowTestRun", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceWorkFlowTestRunResult{}
	var retval *WorkFlowTestRunResponse
	if retval, err2 = p.handler.WorkFlowTestRun(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing WorkFlowTestRun: "+err2.Error())
		oprot.WriteMessageBegin("WorkFlowTestRun", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("WorkFlowTestRun", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorWorkFlowTestResume struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorWorkFlowTestResume) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceWorkFlowTestResumeArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("WorkFlowTestResume", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceWorkFlowTestResumeResult{}
	var retval *WorkflowTestResumeResponse
	if retval, err2 = p.handler.WorkFlowTestResume(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing WorkFlowTestResume: "+err2.Error())
		oprot.WriteMessageBegin("WorkFlowTestResume", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("WorkFlowTestResume", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorCancelWorkFlow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorCancelWorkFlow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceCancelWorkFlowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CancelWorkFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceCancelWorkFlowResult{}
	var retval *CancelWorkFlowResponse
	if retval, err2 = p.handler.CancelWorkFlow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CancelWorkFlow: "+err2.Error())
		oprot.WriteMessageBegin("CancelWorkFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CancelWorkFlow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetWorkFlowProcess struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetWorkFlowProcess) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetWorkFlowProcessArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetWorkFlowProcess", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetWorkFlowProcessResult{}
	var retval *GetWorkflowProcessResponse
	if retval, err2 = p.handler.GetWorkFlowProcess(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetWorkFlowProcess: "+err2.Error())
		oprot.WriteMessageBegin("GetWorkFlowProcess", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetWorkFlowProcess", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetNodeExecuteHistory struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetNodeExecuteHistory) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetNodeExecuteHistoryArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetNodeExecuteHistory", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetNodeExecuteHistoryResult{}
	var retval *GetNodeExecuteHistoryResponse
	if retval, err2 = p.handler.GetNodeExecuteHistory(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetNodeExecuteHistory: "+err2.Error())
		oprot.WriteMessageBegin("GetNodeExecuteHistory", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetNodeExecuteHistory", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetApiDetail struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetApiDetail) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetApiDetailArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetApiDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetApiDetailResult{}
	var retval *GetApiDetailResponse
	if retval, err2 = p.handler.GetApiDetail(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetApiDetail: "+err2.Error())
		oprot.WriteMessageBegin("GetApiDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetApiDetail", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorWorkflowNodeDebugV2 struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorWorkflowNodeDebugV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceWorkflowNodeDebugV2Args{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("WorkflowNodeDebugV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceWorkflowNodeDebugV2Result{}
	var retval *WorkflowNodeDebugV2Response
	if retval, err2 = p.handler.WorkflowNodeDebugV2(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing WorkflowNodeDebugV2: "+err2.Error())
		oprot.WriteMessageBegin("WorkflowNodeDebugV2", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("WorkflowNodeDebugV2", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetWorkflowUploadAuthToken struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetWorkflowUploadAuthToken) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetWorkflowUploadAuthTokenArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetWorkflowUploadAuthToken", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetWorkflowUploadAuthTokenResult{}
	var retval *GetUploadAuthTokenResponse
	if retval, err2 = p.handler.GetWorkflowUploadAuthToken(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetWorkflowUploadAuthToken: "+err2.Error())
		oprot.WriteMessageBegin("GetWorkflowUploadAuthToken", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetWorkflowUploadAuthToken", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorSignImageURL struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorSignImageURL) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceSignImageURLArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("SignImageURL", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceSignImageURLResult{}
	var retval *SignImageURLResponse
	if retval, err2 = p.handler.SignImageURL(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing SignImageURL: "+err2.Error())
		oprot.WriteMessageBegin("SignImageURL", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("SignImageURL", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorCreateProjectConversationDef struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorCreateProjectConversationDef) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceCreateProjectConversationDefArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CreateProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceCreateProjectConversationDefResult{}
	var retval *CreateProjectConversationDefResponse
	if retval, err2 = p.handler.CreateProjectConversationDef(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CreateProjectConversationDef: "+err2.Error())
		oprot.WriteMessageBegin("CreateProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CreateProjectConversationDef", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorUpdateProjectConversationDef struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorUpdateProjectConversationDef) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceUpdateProjectConversationDefArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("UpdateProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceUpdateProjectConversationDefResult{}
	var retval *UpdateProjectConversationDefResponse
	if retval, err2 = p.handler.UpdateProjectConversationDef(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing UpdateProjectConversationDef: "+err2.Error())
		oprot.WriteMessageBegin("UpdateProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("UpdateProjectConversationDef", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorDeleteProjectConversationDef struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorDeleteProjectConversationDef) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceDeleteProjectConversationDefArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("DeleteProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceDeleteProjectConversationDefResult{}
	var retval *DeleteProjectConversationDefResponse
	if retval, err2 = p.handler.DeleteProjectConversationDef(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing DeleteProjectConversationDef: "+err2.Error())
		oprot.WriteMessageBegin("DeleteProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("DeleteProjectConversationDef", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorListProjectConversationDef struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorListProjectConversationDef) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceListProjectConversationDefArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("ListProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceListProjectConversationDefResult{}
	var retval *ListProjectConversationResponse
	if retval, err2 = p.handler.ListProjectConversationDef(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ListProjectConversationDef: "+err2.Error())
		oprot.WriteMessageBegin("ListProjectConversationDef", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("ListProjectConversationDef", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorListRootSpans struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorListRootSpans) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceListRootSpansArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("ListRootSpans", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceListRootSpansResult{}
	var retval *ListRootSpansResponse
	if retval, err2 = p.handler.ListRootSpans(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ListRootSpans: "+err2.Error())
		oprot.WriteMessageBegin("ListRootSpans", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("ListRootSpans", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetTraceSDK struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetTraceSDK) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetTraceSDKArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetTraceSDK", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetTraceSDKResult{}
	var retval *GetTraceSDKResponse
	if retval, err2 = p.handler.GetTraceSDK(ctx, args.Req); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetTraceSDK: "+err2.Error())
		oprot.WriteMessageBegin("GetTraceSDK", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetTraceSDK", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetWorkflowDetail struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetWorkflowDetail) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetWorkflowDetailArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetWorkflowDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetWorkflowDetailResult{}
	var retval *GetWorkflowDetailResponse
	if retval, err2 = p.handler.GetWorkflowDetail(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetWorkflowDetail: "+err2.Error())
		oprot.WriteMessageBegin("GetWorkflowDetail", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetWorkflowDetail", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetWorkflowDetailInfo struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetWorkflowDetailInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetWorkflowDetailInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetWorkflowDetailInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetWorkflowDetailInfoResult{}
	var retval *GetWorkflowDetailInfoResponse
	if retval, err2 = p.handler.GetWorkflowDetailInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetWorkflowDetailInfo: "+err2.Error())
		oprot.WriteMessageBegin("GetWorkflowDetailInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetWorkflowDetailInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorValidateTree struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorValidateTree) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceValidateTreeArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("ValidateTree", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceValidateTreeResult{}
	var retval *ValidateTreeResponse
	if retval, err2 = p.handler.ValidateTree(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ValidateTree: "+err2.Error())
		oprot.WriteMessageBegin("ValidateTree", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("ValidateTree", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorGetChatFlowRole struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorGetChatFlowRole) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceGetChatFlowRoleArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("GetChatFlowRole", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceGetChatFlowRoleResult{}
	var retval *GetChatFlowRoleResponse
	if retval, err2 = p.handler.GetChatFlowRole(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing GetChatFlowRole: "+err2.Error())
		oprot.WriteMessageBegin("GetChatFlowRole", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("GetChatFlowRole", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorCreateChatFlowRole struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorCreateChatFlowRole) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceCreateChatFlowRoleArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("CreateChatFlowRole", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceCreateChatFlowRoleResult{}
	var retval *CreateChatFlowRoleResponse
	if retval, err2 = p.handler.CreateChatFlowRole(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing CreateChatFlowRole: "+err2.Error())
		oprot.WriteMessageBegin("CreateChatFlowRole", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("CreateChatFlowRole", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorDeleteChatFlowRole struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorDeleteChatFlowRole) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceDeleteChatFlowRoleArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("DeleteChatFlowRole", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceDeleteChatFlowRoleResult{}
	var retval *DeleteChatFlowRoleResponse
	if retval, err2 = p.handler.DeleteChatFlowRole(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing DeleteChatFlowRole: "+err2.Error())
		oprot.WriteMessageBegin("DeleteChatFlowRole", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("DeleteChatFlowRole", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorListPublishWorkflow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorListPublishWorkflow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceListPublishWorkflowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("ListPublishWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceListPublishWorkflowResult{}
	var retval *ListPublishWorkflowResponse
	if retval, err2 = p.handler.ListPublishWorkflow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ListPublishWorkflow: "+err2.Error())
		oprot.WriteMessageBegin("ListPublishWorkflow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("ListPublishWorkflow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorOpenAPIRunFlow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorOpenAPIRunFlow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceOpenAPIRunFlowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("OpenAPIRunFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceOpenAPIRunFlowResult{}
	var retval *OpenAPIRunFlowResponse
	if retval, err2 = p.handler.OpenAPIRunFlow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing OpenAPIRunFlow: "+err2.Error())
		oprot.WriteMessageBegin("OpenAPIRunFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("OpenAPIRunFlow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorOpenAPIStreamRunFlow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorOpenAPIStreamRunFlow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceOpenAPIStreamRunFlowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("OpenAPIStreamRunFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceOpenAPIStreamRunFlowResult{}
	var retval *OpenAPIStreamRunFlowResponse
	if retval, err2 = p.handler.OpenAPIStreamRunFlow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing OpenAPIStreamRunFlow: "+err2.Error())
		oprot.WriteMessageBegin("OpenAPIStreamRunFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("OpenAPIStreamRunFlow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorOpenAPIStreamResumeFlow struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorOpenAPIStreamResumeFlow) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceOpenAPIStreamResumeFlowArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("OpenAPIStreamResumeFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceOpenAPIStreamResumeFlowResult{}
	var retval *OpenAPIStreamRunFlowResponse
	if retval, err2 = p.handler.OpenAPIStreamResumeFlow(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing OpenAPIStreamResumeFlow: "+err2.Error())
		oprot.WriteMessageBegin("OpenAPIStreamResumeFlow", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("OpenAPIStreamResumeFlow", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorOpenAPIGetWorkflowRunHistory struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorOpenAPIGetWorkflowRunHistory) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("OpenAPIGetWorkflowRunHistory", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceOpenAPIGetWorkflowRunHistoryResult{}
	var retval *GetWorkflowRunHistoryResponse
	if retval, err2 = p.handler.OpenAPIGetWorkflowRunHistory(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing OpenAPIGetWorkflowRunHistory: "+err2.Error())
		oprot.WriteMessageBegin("OpenAPIGetWorkflowRunHistory", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("OpenAPIGetWorkflowRunHistory", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorOpenAPIChatFlowRun struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorOpenAPIChatFlowRun) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceOpenAPIChatFlowRunArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("OpenAPIChatFlowRun", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceOpenAPIChatFlowRunResult{}
	var retval *ChatFlowRunResponse
	if retval, err2 = p.handler.OpenAPIChatFlowRun(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing OpenAPIChatFlowRun: "+err2.Error())
		oprot.WriteMessageBegin("OpenAPIChatFlowRun", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("OpenAPIChatFlowRun", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type workflowServiceProcessorOpenAPIGetWorkflowInfo struct {
	handler WorkflowService
}

func (p *workflowServiceProcessorOpenAPIGetWorkflowInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := WorkflowServiceOpenAPIGetWorkflowInfoArgs{}
	if err = args.Read(iprot); err != nil {
		iprot.ReadMessageEnd()
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err.Error())
		oprot.WriteMessageBegin("OpenAPIGetWorkflowInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return false, err
	}

	iprot.ReadMessageEnd()
	var err2 error
	result := WorkflowServiceOpenAPIGetWorkflowInfoResult{}
	var retval *OpenAPIGetWorkflowInfoResponse
	if retval, err2 = p.handler.OpenAPIGetWorkflowInfo(ctx, args.Request); err2 != nil {
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing OpenAPIGetWorkflowInfo: "+err2.Error())
		oprot.WriteMessageBegin("OpenAPIGetWorkflowInfo", thrift.EXCEPTION, seqId)
		x.Write(oprot)
		oprot.WriteMessageEnd()
		oprot.Flush(ctx)
		return true, err2
	} else {
		result.Success = retval
	}
	if err2 = oprot.WriteMessageBegin("OpenAPIGetWorkflowInfo", thrift.REPLY, seqId); err2 != nil {
		err = err2
	}
	if err2 = result.Write(oprot); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
		err = err2
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = err2
	}
	if err != nil {
		return
	}
	return true, err
}

type WorkflowServiceCreateWorkflowArgs struct {
	Request *CreateWorkflowRequest `thrift:"request,1"`
}

func NewWorkflowServiceCreateWorkflowArgs() *WorkflowServiceCreateWorkflowArgs {
	return &WorkflowServiceCreateWorkflowArgs{}
}

func (p *WorkflowServiceCreateWorkflowArgs) InitDefault() {
}

var WorkflowServiceCreateWorkflowArgs_Request_DEFAULT *CreateWorkflowRequest

func (p *WorkflowServiceCreateWorkflowArgs) GetRequest() (v *CreateWorkflowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceCreateWorkflowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceCreateWorkflowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceCreateWorkflowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceCreateWorkflowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCreateWorkflowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCreateWorkflowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCreateWorkflowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceCreateWorkflowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateWorkflow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCreateWorkflowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceCreateWorkflowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCreateWorkflowArgs(%+v)", *p)

}

type WorkflowServiceCreateWorkflowResult struct {
	Success *CreateWorkflowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceCreateWorkflowResult() *WorkflowServiceCreateWorkflowResult {
	return &WorkflowServiceCreateWorkflowResult{}
}

func (p *WorkflowServiceCreateWorkflowResult) InitDefault() {
}

var WorkflowServiceCreateWorkflowResult_Success_DEFAULT *CreateWorkflowResponse

func (p *WorkflowServiceCreateWorkflowResult) GetSuccess() (v *CreateWorkflowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceCreateWorkflowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceCreateWorkflowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceCreateWorkflowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceCreateWorkflowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCreateWorkflowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCreateWorkflowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCreateWorkflowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceCreateWorkflowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateWorkflow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCreateWorkflowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceCreateWorkflowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCreateWorkflowResult(%+v)", *p)

}

type WorkflowServiceGetCanvasInfoArgs struct {
	Request *GetCanvasInfoRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetCanvasInfoArgs() *WorkflowServiceGetCanvasInfoArgs {
	return &WorkflowServiceGetCanvasInfoArgs{}
}

func (p *WorkflowServiceGetCanvasInfoArgs) InitDefault() {
}

var WorkflowServiceGetCanvasInfoArgs_Request_DEFAULT *GetCanvasInfoRequest

func (p *WorkflowServiceGetCanvasInfoArgs) GetRequest() (v *GetCanvasInfoRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetCanvasInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetCanvasInfoArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetCanvasInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetCanvasInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetCanvasInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetCanvasInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetCanvasInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetCanvasInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetCanvasInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetCanvasInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetCanvasInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetCanvasInfoArgs(%+v)", *p)

}

type WorkflowServiceGetCanvasInfoResult struct {
	Success *GetCanvasInfoResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetCanvasInfoResult() *WorkflowServiceGetCanvasInfoResult {
	return &WorkflowServiceGetCanvasInfoResult{}
}

func (p *WorkflowServiceGetCanvasInfoResult) InitDefault() {
}

var WorkflowServiceGetCanvasInfoResult_Success_DEFAULT *GetCanvasInfoResponse

func (p *WorkflowServiceGetCanvasInfoResult) GetSuccess() (v *GetCanvasInfoResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetCanvasInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetCanvasInfoResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetCanvasInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetCanvasInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetCanvasInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetCanvasInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetCanvasInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetCanvasInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetCanvasInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetCanvasInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetCanvasInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetCanvasInfoResult(%+v)", *p)

}

type WorkflowServiceGetHistorySchemaArgs struct {
	Request *GetHistorySchemaRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetHistorySchemaArgs() *WorkflowServiceGetHistorySchemaArgs {
	return &WorkflowServiceGetHistorySchemaArgs{}
}

func (p *WorkflowServiceGetHistorySchemaArgs) InitDefault() {
}

var WorkflowServiceGetHistorySchemaArgs_Request_DEFAULT *GetHistorySchemaRequest

func (p *WorkflowServiceGetHistorySchemaArgs) GetRequest() (v *GetHistorySchemaRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetHistorySchemaArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetHistorySchemaArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetHistorySchemaArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetHistorySchemaArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetHistorySchemaArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetHistorySchemaArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetHistorySchemaRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetHistorySchemaArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetHistorySchema_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetHistorySchemaArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetHistorySchemaArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetHistorySchemaArgs(%+v)", *p)

}

type WorkflowServiceGetHistorySchemaResult struct {
	Success *GetHistorySchemaResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetHistorySchemaResult() *WorkflowServiceGetHistorySchemaResult {
	return &WorkflowServiceGetHistorySchemaResult{}
}

func (p *WorkflowServiceGetHistorySchemaResult) InitDefault() {
}

var WorkflowServiceGetHistorySchemaResult_Success_DEFAULT *GetHistorySchemaResponse

func (p *WorkflowServiceGetHistorySchemaResult) GetSuccess() (v *GetHistorySchemaResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetHistorySchemaResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetHistorySchemaResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetHistorySchemaResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetHistorySchemaResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetHistorySchemaResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetHistorySchemaResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetHistorySchemaResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetHistorySchemaResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetHistorySchema_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetHistorySchemaResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetHistorySchemaResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetHistorySchemaResult(%+v)", *p)

}

type WorkflowServiceSaveWorkflowArgs struct {
	Request *SaveWorkflowRequest `thrift:"request,1"`
}

func NewWorkflowServiceSaveWorkflowArgs() *WorkflowServiceSaveWorkflowArgs {
	return &WorkflowServiceSaveWorkflowArgs{}
}

func (p *WorkflowServiceSaveWorkflowArgs) InitDefault() {
}

var WorkflowServiceSaveWorkflowArgs_Request_DEFAULT *SaveWorkflowRequest

func (p *WorkflowServiceSaveWorkflowArgs) GetRequest() (v *SaveWorkflowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceSaveWorkflowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceSaveWorkflowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceSaveWorkflowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceSaveWorkflowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceSaveWorkflowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceSaveWorkflowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewSaveWorkflowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceSaveWorkflowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SaveWorkflow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceSaveWorkflowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceSaveWorkflowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceSaveWorkflowArgs(%+v)", *p)

}

type WorkflowServiceSaveWorkflowResult struct {
	Success *SaveWorkflowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceSaveWorkflowResult() *WorkflowServiceSaveWorkflowResult {
	return &WorkflowServiceSaveWorkflowResult{}
}

func (p *WorkflowServiceSaveWorkflowResult) InitDefault() {
}

var WorkflowServiceSaveWorkflowResult_Success_DEFAULT *SaveWorkflowResponse

func (p *WorkflowServiceSaveWorkflowResult) GetSuccess() (v *SaveWorkflowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceSaveWorkflowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceSaveWorkflowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceSaveWorkflowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceSaveWorkflowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceSaveWorkflowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceSaveWorkflowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewSaveWorkflowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceSaveWorkflowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SaveWorkflow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceSaveWorkflowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceSaveWorkflowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceSaveWorkflowResult(%+v)", *p)

}

type WorkflowServiceUpdateWorkflowMetaArgs struct {
	Request *UpdateWorkflowMetaRequest `thrift:"request,1"`
}

func NewWorkflowServiceUpdateWorkflowMetaArgs() *WorkflowServiceUpdateWorkflowMetaArgs {
	return &WorkflowServiceUpdateWorkflowMetaArgs{}
}

func (p *WorkflowServiceUpdateWorkflowMetaArgs) InitDefault() {
}

var WorkflowServiceUpdateWorkflowMetaArgs_Request_DEFAULT *UpdateWorkflowMetaRequest

func (p *WorkflowServiceUpdateWorkflowMetaArgs) GetRequest() (v *UpdateWorkflowMetaRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceUpdateWorkflowMetaArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceUpdateWorkflowMetaArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceUpdateWorkflowMetaArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceUpdateWorkflowMetaArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceUpdateWorkflowMetaArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateWorkflowMetaArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpdateWorkflowMetaRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceUpdateWorkflowMetaArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateWorkflowMeta_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateWorkflowMetaArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceUpdateWorkflowMetaArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceUpdateWorkflowMetaArgs(%+v)", *p)

}

type WorkflowServiceUpdateWorkflowMetaResult struct {
	Success *UpdateWorkflowMetaResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceUpdateWorkflowMetaResult() *WorkflowServiceUpdateWorkflowMetaResult {
	return &WorkflowServiceUpdateWorkflowMetaResult{}
}

func (p *WorkflowServiceUpdateWorkflowMetaResult) InitDefault() {
}

var WorkflowServiceUpdateWorkflowMetaResult_Success_DEFAULT *UpdateWorkflowMetaResponse

func (p *WorkflowServiceUpdateWorkflowMetaResult) GetSuccess() (v *UpdateWorkflowMetaResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceUpdateWorkflowMetaResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceUpdateWorkflowMetaResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceUpdateWorkflowMetaResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceUpdateWorkflowMetaResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceUpdateWorkflowMetaResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateWorkflowMetaResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUpdateWorkflowMetaResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceUpdateWorkflowMetaResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateWorkflowMeta_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateWorkflowMetaResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceUpdateWorkflowMetaResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceUpdateWorkflowMetaResult(%+v)", *p)

}

type WorkflowServiceDeleteWorkflowArgs struct {
	Request *DeleteWorkflowRequest `thrift:"request,1"`
}

func NewWorkflowServiceDeleteWorkflowArgs() *WorkflowServiceDeleteWorkflowArgs {
	return &WorkflowServiceDeleteWorkflowArgs{}
}

func (p *WorkflowServiceDeleteWorkflowArgs) InitDefault() {
}

var WorkflowServiceDeleteWorkflowArgs_Request_DEFAULT *DeleteWorkflowRequest

func (p *WorkflowServiceDeleteWorkflowArgs) GetRequest() (v *DeleteWorkflowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceDeleteWorkflowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceDeleteWorkflowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceDeleteWorkflowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceDeleteWorkflowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceDeleteWorkflowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteWorkflowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDeleteWorkflowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceDeleteWorkflowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteWorkflow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteWorkflowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceDeleteWorkflowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceDeleteWorkflowArgs(%+v)", *p)

}

type WorkflowServiceDeleteWorkflowResult struct {
	Success *DeleteWorkflowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceDeleteWorkflowResult() *WorkflowServiceDeleteWorkflowResult {
	return &WorkflowServiceDeleteWorkflowResult{}
}

func (p *WorkflowServiceDeleteWorkflowResult) InitDefault() {
}

var WorkflowServiceDeleteWorkflowResult_Success_DEFAULT *DeleteWorkflowResponse

func (p *WorkflowServiceDeleteWorkflowResult) GetSuccess() (v *DeleteWorkflowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceDeleteWorkflowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceDeleteWorkflowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceDeleteWorkflowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceDeleteWorkflowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceDeleteWorkflowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteWorkflowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDeleteWorkflowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceDeleteWorkflowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteWorkflow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteWorkflowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceDeleteWorkflowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceDeleteWorkflowResult(%+v)", *p)

}

type WorkflowServiceBatchDeleteWorkflowArgs struct {
	Request *BatchDeleteWorkflowRequest `thrift:"request,1"`
}

func NewWorkflowServiceBatchDeleteWorkflowArgs() *WorkflowServiceBatchDeleteWorkflowArgs {
	return &WorkflowServiceBatchDeleteWorkflowArgs{}
}

func (p *WorkflowServiceBatchDeleteWorkflowArgs) InitDefault() {
}

var WorkflowServiceBatchDeleteWorkflowArgs_Request_DEFAULT *BatchDeleteWorkflowRequest

func (p *WorkflowServiceBatchDeleteWorkflowArgs) GetRequest() (v *BatchDeleteWorkflowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceBatchDeleteWorkflowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceBatchDeleteWorkflowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceBatchDeleteWorkflowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceBatchDeleteWorkflowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceBatchDeleteWorkflowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceBatchDeleteWorkflowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewBatchDeleteWorkflowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceBatchDeleteWorkflowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BatchDeleteWorkflow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceBatchDeleteWorkflowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceBatchDeleteWorkflowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceBatchDeleteWorkflowArgs(%+v)", *p)

}

type WorkflowServiceBatchDeleteWorkflowResult struct {
	Success *BatchDeleteWorkflowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceBatchDeleteWorkflowResult() *WorkflowServiceBatchDeleteWorkflowResult {
	return &WorkflowServiceBatchDeleteWorkflowResult{}
}

func (p *WorkflowServiceBatchDeleteWorkflowResult) InitDefault() {
}

var WorkflowServiceBatchDeleteWorkflowResult_Success_DEFAULT *BatchDeleteWorkflowResponse

func (p *WorkflowServiceBatchDeleteWorkflowResult) GetSuccess() (v *BatchDeleteWorkflowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceBatchDeleteWorkflowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceBatchDeleteWorkflowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceBatchDeleteWorkflowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceBatchDeleteWorkflowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceBatchDeleteWorkflowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceBatchDeleteWorkflowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewBatchDeleteWorkflowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceBatchDeleteWorkflowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BatchDeleteWorkflow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceBatchDeleteWorkflowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceBatchDeleteWorkflowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceBatchDeleteWorkflowResult(%+v)", *p)

}

type WorkflowServiceGetDeleteStrategyArgs struct {
	Request *GetDeleteStrategyRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetDeleteStrategyArgs() *WorkflowServiceGetDeleteStrategyArgs {
	return &WorkflowServiceGetDeleteStrategyArgs{}
}

func (p *WorkflowServiceGetDeleteStrategyArgs) InitDefault() {
}

var WorkflowServiceGetDeleteStrategyArgs_Request_DEFAULT *GetDeleteStrategyRequest

func (p *WorkflowServiceGetDeleteStrategyArgs) GetRequest() (v *GetDeleteStrategyRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetDeleteStrategyArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetDeleteStrategyArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetDeleteStrategyArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetDeleteStrategyArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetDeleteStrategyArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetDeleteStrategyArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetDeleteStrategyRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetDeleteStrategyArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDeleteStrategy_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetDeleteStrategyArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetDeleteStrategyArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetDeleteStrategyArgs(%+v)", *p)

}

type WorkflowServiceGetDeleteStrategyResult struct {
	Success *GetDeleteStrategyResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetDeleteStrategyResult() *WorkflowServiceGetDeleteStrategyResult {
	return &WorkflowServiceGetDeleteStrategyResult{}
}

func (p *WorkflowServiceGetDeleteStrategyResult) InitDefault() {
}

var WorkflowServiceGetDeleteStrategyResult_Success_DEFAULT *GetDeleteStrategyResponse

func (p *WorkflowServiceGetDeleteStrategyResult) GetSuccess() (v *GetDeleteStrategyResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetDeleteStrategyResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetDeleteStrategyResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetDeleteStrategyResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetDeleteStrategyResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetDeleteStrategyResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetDeleteStrategyResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetDeleteStrategyResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetDeleteStrategyResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDeleteStrategy_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetDeleteStrategyResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetDeleteStrategyResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetDeleteStrategyResult(%+v)", *p)

}

type WorkflowServicePublishWorkflowArgs struct {
	Request *PublishWorkflowRequest `thrift:"request,1"`
}

func NewWorkflowServicePublishWorkflowArgs() *WorkflowServicePublishWorkflowArgs {
	return &WorkflowServicePublishWorkflowArgs{}
}

func (p *WorkflowServicePublishWorkflowArgs) InitDefault() {
}

var WorkflowServicePublishWorkflowArgs_Request_DEFAULT *PublishWorkflowRequest

func (p *WorkflowServicePublishWorkflowArgs) GetRequest() (v *PublishWorkflowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServicePublishWorkflowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServicePublishWorkflowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServicePublishWorkflowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServicePublishWorkflowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServicePublishWorkflowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServicePublishWorkflowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewPublishWorkflowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServicePublishWorkflowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishWorkflow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServicePublishWorkflowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServicePublishWorkflowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServicePublishWorkflowArgs(%+v)", *p)

}

type WorkflowServicePublishWorkflowResult struct {
	Success *PublishWorkflowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServicePublishWorkflowResult() *WorkflowServicePublishWorkflowResult {
	return &WorkflowServicePublishWorkflowResult{}
}

func (p *WorkflowServicePublishWorkflowResult) InitDefault() {
}

var WorkflowServicePublishWorkflowResult_Success_DEFAULT *PublishWorkflowResponse

func (p *WorkflowServicePublishWorkflowResult) GetSuccess() (v *PublishWorkflowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServicePublishWorkflowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServicePublishWorkflowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServicePublishWorkflowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServicePublishWorkflowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServicePublishWorkflowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServicePublishWorkflowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewPublishWorkflowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServicePublishWorkflowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishWorkflow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServicePublishWorkflowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServicePublishWorkflowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServicePublishWorkflowResult(%+v)", *p)

}

type WorkflowServiceCopyWorkflowArgs struct {
	Request *CopyWorkflowRequest `thrift:"request,1"`
}

func NewWorkflowServiceCopyWorkflowArgs() *WorkflowServiceCopyWorkflowArgs {
	return &WorkflowServiceCopyWorkflowArgs{}
}

func (p *WorkflowServiceCopyWorkflowArgs) InitDefault() {
}

var WorkflowServiceCopyWorkflowArgs_Request_DEFAULT *CopyWorkflowRequest

func (p *WorkflowServiceCopyWorkflowArgs) GetRequest() (v *CopyWorkflowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceCopyWorkflowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceCopyWorkflowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceCopyWorkflowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceCopyWorkflowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCopyWorkflowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWorkflowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCopyWorkflowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceCopyWorkflowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWorkflow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWorkflowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceCopyWorkflowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCopyWorkflowArgs(%+v)", *p)

}

type WorkflowServiceCopyWorkflowResult struct {
	Success *CopyWorkflowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceCopyWorkflowResult() *WorkflowServiceCopyWorkflowResult {
	return &WorkflowServiceCopyWorkflowResult{}
}

func (p *WorkflowServiceCopyWorkflowResult) InitDefault() {
}

var WorkflowServiceCopyWorkflowResult_Success_DEFAULT *CopyWorkflowResponse

func (p *WorkflowServiceCopyWorkflowResult) GetSuccess() (v *CopyWorkflowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceCopyWorkflowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceCopyWorkflowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceCopyWorkflowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceCopyWorkflowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCopyWorkflowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWorkflowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCopyWorkflowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceCopyWorkflowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWorkflow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWorkflowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceCopyWorkflowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCopyWorkflowResult(%+v)", *p)

}

type WorkflowServiceCopyWkTemplateApiArgs struct {
	Request *CopyWkTemplateApiRequest `thrift:"request,1"`
}

func NewWorkflowServiceCopyWkTemplateApiArgs() *WorkflowServiceCopyWkTemplateApiArgs {
	return &WorkflowServiceCopyWkTemplateApiArgs{}
}

func (p *WorkflowServiceCopyWkTemplateApiArgs) InitDefault() {
}

var WorkflowServiceCopyWkTemplateApiArgs_Request_DEFAULT *CopyWkTemplateApiRequest

func (p *WorkflowServiceCopyWkTemplateApiArgs) GetRequest() (v *CopyWkTemplateApiRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceCopyWkTemplateApiArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceCopyWkTemplateApiArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceCopyWkTemplateApiArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceCopyWkTemplateApiArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCopyWkTemplateApiArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWkTemplateApiArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCopyWkTemplateApiRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceCopyWkTemplateApiArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWkTemplateApi_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWkTemplateApiArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceCopyWkTemplateApiArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCopyWkTemplateApiArgs(%+v)", *p)

}

type WorkflowServiceCopyWkTemplateApiResult struct {
	Success *CopyWkTemplateApiResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceCopyWkTemplateApiResult() *WorkflowServiceCopyWkTemplateApiResult {
	return &WorkflowServiceCopyWkTemplateApiResult{}
}

func (p *WorkflowServiceCopyWkTemplateApiResult) InitDefault() {
}

var WorkflowServiceCopyWkTemplateApiResult_Success_DEFAULT *CopyWkTemplateApiResponse

func (p *WorkflowServiceCopyWkTemplateApiResult) GetSuccess() (v *CopyWkTemplateApiResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceCopyWkTemplateApiResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceCopyWkTemplateApiResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceCopyWkTemplateApiResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceCopyWkTemplateApiResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCopyWkTemplateApiResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWkTemplateApiResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCopyWkTemplateApiResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceCopyWkTemplateApiResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWkTemplateApi_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCopyWkTemplateApiResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceCopyWkTemplateApiResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCopyWkTemplateApiResult(%+v)", *p)

}

type WorkflowServiceGetReleasedWorkflowsArgs struct {
	Request *GetReleasedWorkflowsRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetReleasedWorkflowsArgs() *WorkflowServiceGetReleasedWorkflowsArgs {
	return &WorkflowServiceGetReleasedWorkflowsArgs{}
}

func (p *WorkflowServiceGetReleasedWorkflowsArgs) InitDefault() {
}

var WorkflowServiceGetReleasedWorkflowsArgs_Request_DEFAULT *GetReleasedWorkflowsRequest

func (p *WorkflowServiceGetReleasedWorkflowsArgs) GetRequest() (v *GetReleasedWorkflowsRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetReleasedWorkflowsArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetReleasedWorkflowsArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetReleasedWorkflowsArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetReleasedWorkflowsArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetReleasedWorkflowsArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetReleasedWorkflowsArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetReleasedWorkflowsRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetReleasedWorkflowsArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetReleasedWorkflows_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetReleasedWorkflowsArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetReleasedWorkflowsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetReleasedWorkflowsArgs(%+v)", *p)

}

type WorkflowServiceGetReleasedWorkflowsResult struct {
	Success *GetReleasedWorkflowsResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetReleasedWorkflowsResult() *WorkflowServiceGetReleasedWorkflowsResult {
	return &WorkflowServiceGetReleasedWorkflowsResult{}
}

func (p *WorkflowServiceGetReleasedWorkflowsResult) InitDefault() {
}

var WorkflowServiceGetReleasedWorkflowsResult_Success_DEFAULT *GetReleasedWorkflowsResponse

func (p *WorkflowServiceGetReleasedWorkflowsResult) GetSuccess() (v *GetReleasedWorkflowsResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetReleasedWorkflowsResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetReleasedWorkflowsResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetReleasedWorkflowsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetReleasedWorkflowsResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetReleasedWorkflowsResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetReleasedWorkflowsResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetReleasedWorkflowsResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetReleasedWorkflowsResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetReleasedWorkflows_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetReleasedWorkflowsResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetReleasedWorkflowsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetReleasedWorkflowsResult(%+v)", *p)

}

type WorkflowServiceGetWorkflowReferencesArgs struct {
	Request *GetWorkflowReferencesRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetWorkflowReferencesArgs() *WorkflowServiceGetWorkflowReferencesArgs {
	return &WorkflowServiceGetWorkflowReferencesArgs{}
}

func (p *WorkflowServiceGetWorkflowReferencesArgs) InitDefault() {
}

var WorkflowServiceGetWorkflowReferencesArgs_Request_DEFAULT *GetWorkflowReferencesRequest

func (p *WorkflowServiceGetWorkflowReferencesArgs) GetRequest() (v *GetWorkflowReferencesRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetWorkflowReferencesArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetWorkflowReferencesArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetWorkflowReferencesArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetWorkflowReferencesArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowReferencesArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowReferencesArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowReferencesRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowReferencesArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowReferences_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowReferencesArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowReferencesArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowReferencesArgs(%+v)", *p)

}

type WorkflowServiceGetWorkflowReferencesResult struct {
	Success *GetWorkflowReferencesResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetWorkflowReferencesResult() *WorkflowServiceGetWorkflowReferencesResult {
	return &WorkflowServiceGetWorkflowReferencesResult{}
}

func (p *WorkflowServiceGetWorkflowReferencesResult) InitDefault() {
}

var WorkflowServiceGetWorkflowReferencesResult_Success_DEFAULT *GetWorkflowReferencesResponse

func (p *WorkflowServiceGetWorkflowReferencesResult) GetSuccess() (v *GetWorkflowReferencesResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetWorkflowReferencesResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetWorkflowReferencesResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetWorkflowReferencesResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetWorkflowReferencesResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowReferencesResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowReferencesResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowReferencesResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowReferencesResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowReferences_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowReferencesResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowReferencesResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowReferencesResult(%+v)", *p)

}

type WorkflowServiceGetExampleWorkFlowListArgs struct {
	Request *GetExampleWorkFlowListRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetExampleWorkFlowListArgs() *WorkflowServiceGetExampleWorkFlowListArgs {
	return &WorkflowServiceGetExampleWorkFlowListArgs{}
}

func (p *WorkflowServiceGetExampleWorkFlowListArgs) InitDefault() {
}

var WorkflowServiceGetExampleWorkFlowListArgs_Request_DEFAULT *GetExampleWorkFlowListRequest

func (p *WorkflowServiceGetExampleWorkFlowListArgs) GetRequest() (v *GetExampleWorkFlowListRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetExampleWorkFlowListArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetExampleWorkFlowListArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetExampleWorkFlowListArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetExampleWorkFlowListArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetExampleWorkFlowListArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetExampleWorkFlowListArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetExampleWorkFlowListRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetExampleWorkFlowListArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetExampleWorkFlowList_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetExampleWorkFlowListArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetExampleWorkFlowListArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetExampleWorkFlowListArgs(%+v)", *p)

}

type WorkflowServiceGetExampleWorkFlowListResult struct {
	Success *GetExampleWorkFlowListResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetExampleWorkFlowListResult() *WorkflowServiceGetExampleWorkFlowListResult {
	return &WorkflowServiceGetExampleWorkFlowListResult{}
}

func (p *WorkflowServiceGetExampleWorkFlowListResult) InitDefault() {
}

var WorkflowServiceGetExampleWorkFlowListResult_Success_DEFAULT *GetExampleWorkFlowListResponse

func (p *WorkflowServiceGetExampleWorkFlowListResult) GetSuccess() (v *GetExampleWorkFlowListResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetExampleWorkFlowListResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetExampleWorkFlowListResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetExampleWorkFlowListResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetExampleWorkFlowListResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetExampleWorkFlowListResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetExampleWorkFlowListResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetExampleWorkFlowListResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetExampleWorkFlowListResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetExampleWorkFlowList_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetExampleWorkFlowListResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetExampleWorkFlowListResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetExampleWorkFlowListResult(%+v)", *p)

}

type WorkflowServiceGetWorkFlowListArgs struct {
	Request *GetWorkFlowListRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetWorkFlowListArgs() *WorkflowServiceGetWorkFlowListArgs {
	return &WorkflowServiceGetWorkFlowListArgs{}
}

func (p *WorkflowServiceGetWorkFlowListArgs) InitDefault() {
}

var WorkflowServiceGetWorkFlowListArgs_Request_DEFAULT *GetWorkFlowListRequest

func (p *WorkflowServiceGetWorkFlowListArgs) GetRequest() (v *GetWorkFlowListRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetWorkFlowListArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetWorkFlowListArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetWorkFlowListArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetWorkFlowListArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkFlowListArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowListArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetWorkFlowListRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetWorkFlowListArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkFlowList_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowListArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowListArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkFlowListArgs(%+v)", *p)

}

type WorkflowServiceGetWorkFlowListResult struct {
	Success *GetWorkFlowListResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetWorkFlowListResult() *WorkflowServiceGetWorkFlowListResult {
	return &WorkflowServiceGetWorkFlowListResult{}
}

func (p *WorkflowServiceGetWorkFlowListResult) InitDefault() {
}

var WorkflowServiceGetWorkFlowListResult_Success_DEFAULT *GetWorkFlowListResponse

func (p *WorkflowServiceGetWorkFlowListResult) GetSuccess() (v *GetWorkFlowListResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetWorkFlowListResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetWorkFlowListResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetWorkFlowListResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetWorkFlowListResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkFlowListResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowListResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetWorkFlowListResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetWorkFlowListResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkFlowList_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowListResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowListResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkFlowListResult(%+v)", *p)

}

type WorkflowServiceQueryWorkflowNodeTypesArgs struct {
	Request *QueryWorkflowNodeTypeRequest `thrift:"request,1"`
}

func NewWorkflowServiceQueryWorkflowNodeTypesArgs() *WorkflowServiceQueryWorkflowNodeTypesArgs {
	return &WorkflowServiceQueryWorkflowNodeTypesArgs{}
}

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) InitDefault() {
}

var WorkflowServiceQueryWorkflowNodeTypesArgs_Request_DEFAULT *QueryWorkflowNodeTypeRequest

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) GetRequest() (v *QueryWorkflowNodeTypeRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceQueryWorkflowNodeTypesArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceQueryWorkflowNodeTypesArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceQueryWorkflowNodeTypesArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewQueryWorkflowNodeTypeRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("QueryWorkflowNodeTypes_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceQueryWorkflowNodeTypesArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceQueryWorkflowNodeTypesArgs(%+v)", *p)

}

type WorkflowServiceQueryWorkflowNodeTypesResult struct {
	Success *QueryWorkflowNodeTypeResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceQueryWorkflowNodeTypesResult() *WorkflowServiceQueryWorkflowNodeTypesResult {
	return &WorkflowServiceQueryWorkflowNodeTypesResult{}
}

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) InitDefault() {
}

var WorkflowServiceQueryWorkflowNodeTypesResult_Success_DEFAULT *QueryWorkflowNodeTypeResponse

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) GetSuccess() (v *QueryWorkflowNodeTypeResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceQueryWorkflowNodeTypesResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceQueryWorkflowNodeTypesResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceQueryWorkflowNodeTypesResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewQueryWorkflowNodeTypeResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("QueryWorkflowNodeTypes_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceQueryWorkflowNodeTypesResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceQueryWorkflowNodeTypesResult(%+v)", *p)

}

type WorkflowServiceNodeTemplateListArgs struct {
	Request *NodeTemplateListRequest `thrift:"request,1"`
}

func NewWorkflowServiceNodeTemplateListArgs() *WorkflowServiceNodeTemplateListArgs {
	return &WorkflowServiceNodeTemplateListArgs{}
}

func (p *WorkflowServiceNodeTemplateListArgs) InitDefault() {
}

var WorkflowServiceNodeTemplateListArgs_Request_DEFAULT *NodeTemplateListRequest

func (p *WorkflowServiceNodeTemplateListArgs) GetRequest() (v *NodeTemplateListRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceNodeTemplateListArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceNodeTemplateListArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceNodeTemplateListArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceNodeTemplateListArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceNodeTemplateListArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceNodeTemplateListArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewNodeTemplateListRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceNodeTemplateListArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("NodeTemplateList_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceNodeTemplateListArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceNodeTemplateListArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceNodeTemplateListArgs(%+v)", *p)

}

type WorkflowServiceNodeTemplateListResult struct {
	Success *NodeTemplateListResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceNodeTemplateListResult() *WorkflowServiceNodeTemplateListResult {
	return &WorkflowServiceNodeTemplateListResult{}
}

func (p *WorkflowServiceNodeTemplateListResult) InitDefault() {
}

var WorkflowServiceNodeTemplateListResult_Success_DEFAULT *NodeTemplateListResponse

func (p *WorkflowServiceNodeTemplateListResult) GetSuccess() (v *NodeTemplateListResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceNodeTemplateListResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceNodeTemplateListResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceNodeTemplateListResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceNodeTemplateListResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceNodeTemplateListResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceNodeTemplateListResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewNodeTemplateListResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceNodeTemplateListResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("NodeTemplateList_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceNodeTemplateListResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceNodeTemplateListResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceNodeTemplateListResult(%+v)", *p)

}

type WorkflowServiceNodePanelSearchArgs struct {
	Request *NodePanelSearchRequest `thrift:"request,1"`
}

func NewWorkflowServiceNodePanelSearchArgs() *WorkflowServiceNodePanelSearchArgs {
	return &WorkflowServiceNodePanelSearchArgs{}
}

func (p *WorkflowServiceNodePanelSearchArgs) InitDefault() {
}

var WorkflowServiceNodePanelSearchArgs_Request_DEFAULT *NodePanelSearchRequest

func (p *WorkflowServiceNodePanelSearchArgs) GetRequest() (v *NodePanelSearchRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceNodePanelSearchArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceNodePanelSearchArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceNodePanelSearchArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceNodePanelSearchArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceNodePanelSearchArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceNodePanelSearchArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewNodePanelSearchRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceNodePanelSearchArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("NodePanelSearch_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceNodePanelSearchArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceNodePanelSearchArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceNodePanelSearchArgs(%+v)", *p)

}

type WorkflowServiceNodePanelSearchResult struct {
	Success *NodePanelSearchResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceNodePanelSearchResult() *WorkflowServiceNodePanelSearchResult {
	return &WorkflowServiceNodePanelSearchResult{}
}

func (p *WorkflowServiceNodePanelSearchResult) InitDefault() {
}

var WorkflowServiceNodePanelSearchResult_Success_DEFAULT *NodePanelSearchResponse

func (p *WorkflowServiceNodePanelSearchResult) GetSuccess() (v *NodePanelSearchResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceNodePanelSearchResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceNodePanelSearchResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceNodePanelSearchResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceNodePanelSearchResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceNodePanelSearchResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceNodePanelSearchResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewNodePanelSearchResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceNodePanelSearchResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("NodePanelSearch_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceNodePanelSearchResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceNodePanelSearchResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceNodePanelSearchResult(%+v)", *p)

}

type WorkflowServiceGetLLMNodeFCSettingsMergedArgs struct {
	Req *GetLLMNodeFCSettingsMergedRequest `thrift:"req,1"`
}

func NewWorkflowServiceGetLLMNodeFCSettingsMergedArgs() *WorkflowServiceGetLLMNodeFCSettingsMergedArgs {
	return &WorkflowServiceGetLLMNodeFCSettingsMergedArgs{}
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) InitDefault() {
}

var WorkflowServiceGetLLMNodeFCSettingsMergedArgs_Req_DEFAULT *GetLLMNodeFCSettingsMergedRequest

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) GetReq() (v *GetLLMNodeFCSettingsMergedRequest) {
	if !p.IsSetReq() {
		return WorkflowServiceGetLLMNodeFCSettingsMergedArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_WorkflowServiceGetLLMNodeFCSettingsMergedArgs = map[int16]string{
	1: "req",
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetLLMNodeFCSettingsMergedArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetLLMNodeFCSettingsMergedRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetLLMNodeFCSettingsMerged_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetLLMNodeFCSettingsMergedArgs(%+v)", *p)

}

type WorkflowServiceGetLLMNodeFCSettingsMergedResult struct {
	Success *GetLLMNodeFCSettingsMergedResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetLLMNodeFCSettingsMergedResult() *WorkflowServiceGetLLMNodeFCSettingsMergedResult {
	return &WorkflowServiceGetLLMNodeFCSettingsMergedResult{}
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) InitDefault() {
}

var WorkflowServiceGetLLMNodeFCSettingsMergedResult_Success_DEFAULT *GetLLMNodeFCSettingsMergedResponse

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) GetSuccess() (v *GetLLMNodeFCSettingsMergedResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetLLMNodeFCSettingsMergedResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetLLMNodeFCSettingsMergedResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetLLMNodeFCSettingsMergedResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetLLMNodeFCSettingsMergedResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetLLMNodeFCSettingsMerged_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingsMergedResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetLLMNodeFCSettingsMergedResult(%+v)", *p)

}

type WorkflowServiceGetLLMNodeFCSettingDetailArgs struct {
	Req *GetLLMNodeFCSettingDetailRequest `thrift:"req,1"`
}

func NewWorkflowServiceGetLLMNodeFCSettingDetailArgs() *WorkflowServiceGetLLMNodeFCSettingDetailArgs {
	return &WorkflowServiceGetLLMNodeFCSettingDetailArgs{}
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) InitDefault() {
}

var WorkflowServiceGetLLMNodeFCSettingDetailArgs_Req_DEFAULT *GetLLMNodeFCSettingDetailRequest

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) GetReq() (v *GetLLMNodeFCSettingDetailRequest) {
	if !p.IsSetReq() {
		return WorkflowServiceGetLLMNodeFCSettingDetailArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_WorkflowServiceGetLLMNodeFCSettingDetailArgs = map[int16]string{
	1: "req",
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetLLMNodeFCSettingDetailArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetLLMNodeFCSettingDetailRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetLLMNodeFCSettingDetail_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetLLMNodeFCSettingDetailArgs(%+v)", *p)

}

type WorkflowServiceGetLLMNodeFCSettingDetailResult struct {
	Success *GetLLMNodeFCSettingDetailResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetLLMNodeFCSettingDetailResult() *WorkflowServiceGetLLMNodeFCSettingDetailResult {
	return &WorkflowServiceGetLLMNodeFCSettingDetailResult{}
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) InitDefault() {
}

var WorkflowServiceGetLLMNodeFCSettingDetailResult_Success_DEFAULT *GetLLMNodeFCSettingDetailResponse

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) GetSuccess() (v *GetLLMNodeFCSettingDetailResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetLLMNodeFCSettingDetailResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetLLMNodeFCSettingDetailResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetLLMNodeFCSettingDetailResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetLLMNodeFCSettingDetailResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetLLMNodeFCSettingDetail_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetLLMNodeFCSettingDetailResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetLLMNodeFCSettingDetailResult(%+v)", *p)

}

type WorkflowServiceWorkFlowTestRunArgs struct {
	Request *WorkFlowTestRunRequest `thrift:"request,1"`
}

func NewWorkflowServiceWorkFlowTestRunArgs() *WorkflowServiceWorkFlowTestRunArgs {
	return &WorkflowServiceWorkFlowTestRunArgs{}
}

func (p *WorkflowServiceWorkFlowTestRunArgs) InitDefault() {
}

var WorkflowServiceWorkFlowTestRunArgs_Request_DEFAULT *WorkFlowTestRunRequest

func (p *WorkflowServiceWorkFlowTestRunArgs) GetRequest() (v *WorkFlowTestRunRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceWorkFlowTestRunArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceWorkFlowTestRunArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceWorkFlowTestRunArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceWorkFlowTestRunArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceWorkFlowTestRunArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestRunArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkFlowTestRunRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceWorkFlowTestRunArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowTestRun_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestRunArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestRunArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceWorkFlowTestRunArgs(%+v)", *p)

}

type WorkflowServiceWorkFlowTestRunResult struct {
	Success *WorkFlowTestRunResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceWorkFlowTestRunResult() *WorkflowServiceWorkFlowTestRunResult {
	return &WorkflowServiceWorkFlowTestRunResult{}
}

func (p *WorkflowServiceWorkFlowTestRunResult) InitDefault() {
}

var WorkflowServiceWorkFlowTestRunResult_Success_DEFAULT *WorkFlowTestRunResponse

func (p *WorkflowServiceWorkFlowTestRunResult) GetSuccess() (v *WorkFlowTestRunResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceWorkFlowTestRunResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceWorkFlowTestRunResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceWorkFlowTestRunResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceWorkFlowTestRunResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceWorkFlowTestRunResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestRunResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewWorkFlowTestRunResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceWorkFlowTestRunResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowTestRun_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestRunResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestRunResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceWorkFlowTestRunResult(%+v)", *p)

}

type WorkflowServiceWorkFlowTestResumeArgs struct {
	Request *WorkflowTestResumeRequest `thrift:"request,1"`
}

func NewWorkflowServiceWorkFlowTestResumeArgs() *WorkflowServiceWorkFlowTestResumeArgs {
	return &WorkflowServiceWorkFlowTestResumeArgs{}
}

func (p *WorkflowServiceWorkFlowTestResumeArgs) InitDefault() {
}

var WorkflowServiceWorkFlowTestResumeArgs_Request_DEFAULT *WorkflowTestResumeRequest

func (p *WorkflowServiceWorkFlowTestResumeArgs) GetRequest() (v *WorkflowTestResumeRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceWorkFlowTestResumeArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceWorkFlowTestResumeArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceWorkFlowTestResumeArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceWorkFlowTestResumeArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceWorkFlowTestResumeArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestResumeArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkflowTestResumeRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceWorkFlowTestResumeArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowTestResume_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestResumeArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestResumeArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceWorkFlowTestResumeArgs(%+v)", *p)

}

type WorkflowServiceWorkFlowTestResumeResult struct {
	Success *WorkflowTestResumeResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceWorkFlowTestResumeResult() *WorkflowServiceWorkFlowTestResumeResult {
	return &WorkflowServiceWorkFlowTestResumeResult{}
}

func (p *WorkflowServiceWorkFlowTestResumeResult) InitDefault() {
}

var WorkflowServiceWorkFlowTestResumeResult_Success_DEFAULT *WorkflowTestResumeResponse

func (p *WorkflowServiceWorkFlowTestResumeResult) GetSuccess() (v *WorkflowTestResumeResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceWorkFlowTestResumeResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceWorkFlowTestResumeResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceWorkFlowTestResumeResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceWorkFlowTestResumeResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceWorkFlowTestResumeResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestResumeResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewWorkflowTestResumeResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceWorkFlowTestResumeResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowTestResume_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestResumeResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceWorkFlowTestResumeResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceWorkFlowTestResumeResult(%+v)", *p)

}

type WorkflowServiceCancelWorkFlowArgs struct {
	Request *CancelWorkFlowRequest `thrift:"request,1"`
}

func NewWorkflowServiceCancelWorkFlowArgs() *WorkflowServiceCancelWorkFlowArgs {
	return &WorkflowServiceCancelWorkFlowArgs{}
}

func (p *WorkflowServiceCancelWorkFlowArgs) InitDefault() {
}

var WorkflowServiceCancelWorkFlowArgs_Request_DEFAULT *CancelWorkFlowRequest

func (p *WorkflowServiceCancelWorkFlowArgs) GetRequest() (v *CancelWorkFlowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceCancelWorkFlowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceCancelWorkFlowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceCancelWorkFlowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceCancelWorkFlowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCancelWorkFlowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCancelWorkFlowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCancelWorkFlowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceCancelWorkFlowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CancelWorkFlow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCancelWorkFlowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceCancelWorkFlowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCancelWorkFlowArgs(%+v)", *p)

}

type WorkflowServiceCancelWorkFlowResult struct {
	Success *CancelWorkFlowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceCancelWorkFlowResult() *WorkflowServiceCancelWorkFlowResult {
	return &WorkflowServiceCancelWorkFlowResult{}
}

func (p *WorkflowServiceCancelWorkFlowResult) InitDefault() {
}

var WorkflowServiceCancelWorkFlowResult_Success_DEFAULT *CancelWorkFlowResponse

func (p *WorkflowServiceCancelWorkFlowResult) GetSuccess() (v *CancelWorkFlowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceCancelWorkFlowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceCancelWorkFlowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceCancelWorkFlowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceCancelWorkFlowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCancelWorkFlowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCancelWorkFlowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCancelWorkFlowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceCancelWorkFlowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CancelWorkFlow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCancelWorkFlowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceCancelWorkFlowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCancelWorkFlowResult(%+v)", *p)

}

type WorkflowServiceGetWorkFlowProcessArgs struct {
	Request *GetWorkflowProcessRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetWorkFlowProcessArgs() *WorkflowServiceGetWorkFlowProcessArgs {
	return &WorkflowServiceGetWorkFlowProcessArgs{}
}

func (p *WorkflowServiceGetWorkFlowProcessArgs) InitDefault() {
}

var WorkflowServiceGetWorkFlowProcessArgs_Request_DEFAULT *GetWorkflowProcessRequest

func (p *WorkflowServiceGetWorkFlowProcessArgs) GetRequest() (v *GetWorkflowProcessRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetWorkFlowProcessArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetWorkFlowProcessArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetWorkFlowProcessArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetWorkFlowProcessArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkFlowProcessArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowProcessArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowProcessRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetWorkFlowProcessArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkFlowProcess_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowProcessArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowProcessArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkFlowProcessArgs(%+v)", *p)

}

type WorkflowServiceGetWorkFlowProcessResult struct {
	Success *GetWorkflowProcessResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetWorkFlowProcessResult() *WorkflowServiceGetWorkFlowProcessResult {
	return &WorkflowServiceGetWorkFlowProcessResult{}
}

func (p *WorkflowServiceGetWorkFlowProcessResult) InitDefault() {
}

var WorkflowServiceGetWorkFlowProcessResult_Success_DEFAULT *GetWorkflowProcessResponse

func (p *WorkflowServiceGetWorkFlowProcessResult) GetSuccess() (v *GetWorkflowProcessResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetWorkFlowProcessResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetWorkFlowProcessResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetWorkFlowProcessResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetWorkFlowProcessResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkFlowProcessResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowProcessResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowProcessResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetWorkFlowProcessResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkFlowProcess_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowProcessResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkFlowProcessResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkFlowProcessResult(%+v)", *p)

}

type WorkflowServiceGetNodeExecuteHistoryArgs struct {
	Request *GetNodeExecuteHistoryRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetNodeExecuteHistoryArgs() *WorkflowServiceGetNodeExecuteHistoryArgs {
	return &WorkflowServiceGetNodeExecuteHistoryArgs{}
}

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) InitDefault() {
}

var WorkflowServiceGetNodeExecuteHistoryArgs_Request_DEFAULT *GetNodeExecuteHistoryRequest

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) GetRequest() (v *GetNodeExecuteHistoryRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetNodeExecuteHistoryArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetNodeExecuteHistoryArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetNodeExecuteHistoryArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetNodeExecuteHistoryRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetNodeExecuteHistory_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetNodeExecuteHistoryArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetNodeExecuteHistoryArgs(%+v)", *p)

}

type WorkflowServiceGetNodeExecuteHistoryResult struct {
	Success *GetNodeExecuteHistoryResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetNodeExecuteHistoryResult() *WorkflowServiceGetNodeExecuteHistoryResult {
	return &WorkflowServiceGetNodeExecuteHistoryResult{}
}

func (p *WorkflowServiceGetNodeExecuteHistoryResult) InitDefault() {
}

var WorkflowServiceGetNodeExecuteHistoryResult_Success_DEFAULT *GetNodeExecuteHistoryResponse

func (p *WorkflowServiceGetNodeExecuteHistoryResult) GetSuccess() (v *GetNodeExecuteHistoryResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetNodeExecuteHistoryResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetNodeExecuteHistoryResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetNodeExecuteHistoryResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetNodeExecuteHistoryResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetNodeExecuteHistoryResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetNodeExecuteHistoryResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetNodeExecuteHistoryResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetNodeExecuteHistoryResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetNodeExecuteHistory_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetNodeExecuteHistoryResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetNodeExecuteHistoryResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetNodeExecuteHistoryResult(%+v)", *p)

}

type WorkflowServiceGetApiDetailArgs struct {
	Request *GetApiDetailRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetApiDetailArgs() *WorkflowServiceGetApiDetailArgs {
	return &WorkflowServiceGetApiDetailArgs{}
}

func (p *WorkflowServiceGetApiDetailArgs) InitDefault() {
}

var WorkflowServiceGetApiDetailArgs_Request_DEFAULT *GetApiDetailRequest

func (p *WorkflowServiceGetApiDetailArgs) GetRequest() (v *GetApiDetailRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetApiDetailArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetApiDetailArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetApiDetailArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetApiDetailArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetApiDetailArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetApiDetailArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetApiDetailRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetApiDetailArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetApiDetail_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetApiDetailArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetApiDetailArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetApiDetailArgs(%+v)", *p)

}

type WorkflowServiceGetApiDetailResult struct {
	Success *GetApiDetailResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetApiDetailResult() *WorkflowServiceGetApiDetailResult {
	return &WorkflowServiceGetApiDetailResult{}
}

func (p *WorkflowServiceGetApiDetailResult) InitDefault() {
}

var WorkflowServiceGetApiDetailResult_Success_DEFAULT *GetApiDetailResponse

func (p *WorkflowServiceGetApiDetailResult) GetSuccess() (v *GetApiDetailResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetApiDetailResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetApiDetailResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetApiDetailResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetApiDetailResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetApiDetailResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetApiDetailResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetApiDetailResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetApiDetailResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetApiDetail_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetApiDetailResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetApiDetailResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetApiDetailResult(%+v)", *p)

}

type WorkflowServiceWorkflowNodeDebugV2Args struct {
	Request *WorkflowNodeDebugV2Request `thrift:"request,1"`
}

func NewWorkflowServiceWorkflowNodeDebugV2Args() *WorkflowServiceWorkflowNodeDebugV2Args {
	return &WorkflowServiceWorkflowNodeDebugV2Args{}
}

func (p *WorkflowServiceWorkflowNodeDebugV2Args) InitDefault() {
}

var WorkflowServiceWorkflowNodeDebugV2Args_Request_DEFAULT *WorkflowNodeDebugV2Request

func (p *WorkflowServiceWorkflowNodeDebugV2Args) GetRequest() (v *WorkflowNodeDebugV2Request) {
	if !p.IsSetRequest() {
		return WorkflowServiceWorkflowNodeDebugV2Args_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceWorkflowNodeDebugV2Args = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceWorkflowNodeDebugV2Args) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceWorkflowNodeDebugV2Args) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceWorkflowNodeDebugV2Args[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceWorkflowNodeDebugV2Args) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkflowNodeDebugV2Request()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceWorkflowNodeDebugV2Args) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowNodeDebugV2_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceWorkflowNodeDebugV2Args) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceWorkflowNodeDebugV2Args) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceWorkflowNodeDebugV2Args(%+v)", *p)

}

type WorkflowServiceWorkflowNodeDebugV2Result struct {
	Success *WorkflowNodeDebugV2Response `thrift:"success,0,optional"`
}

func NewWorkflowServiceWorkflowNodeDebugV2Result() *WorkflowServiceWorkflowNodeDebugV2Result {
	return &WorkflowServiceWorkflowNodeDebugV2Result{}
}

func (p *WorkflowServiceWorkflowNodeDebugV2Result) InitDefault() {
}

var WorkflowServiceWorkflowNodeDebugV2Result_Success_DEFAULT *WorkflowNodeDebugV2Response

func (p *WorkflowServiceWorkflowNodeDebugV2Result) GetSuccess() (v *WorkflowNodeDebugV2Response) {
	if !p.IsSetSuccess() {
		return WorkflowServiceWorkflowNodeDebugV2Result_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceWorkflowNodeDebugV2Result = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceWorkflowNodeDebugV2Result) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceWorkflowNodeDebugV2Result) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceWorkflowNodeDebugV2Result[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceWorkflowNodeDebugV2Result) ReadField0(iprot thrift.TProtocol) error {
	_field := NewWorkflowNodeDebugV2Response()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceWorkflowNodeDebugV2Result) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowNodeDebugV2_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceWorkflowNodeDebugV2Result) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceWorkflowNodeDebugV2Result) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceWorkflowNodeDebugV2Result(%+v)", *p)

}

type WorkflowServiceGetWorkflowUploadAuthTokenArgs struct {
	Request *GetUploadAuthTokenRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetWorkflowUploadAuthTokenArgs() *WorkflowServiceGetWorkflowUploadAuthTokenArgs {
	return &WorkflowServiceGetWorkflowUploadAuthTokenArgs{}
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) InitDefault() {
}

var WorkflowServiceGetWorkflowUploadAuthTokenArgs_Request_DEFAULT *GetUploadAuthTokenRequest

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) GetRequest() (v *GetUploadAuthTokenRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetWorkflowUploadAuthTokenArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetWorkflowUploadAuthTokenArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowUploadAuthTokenArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetUploadAuthTokenRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowUploadAuthToken_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowUploadAuthTokenArgs(%+v)", *p)

}

type WorkflowServiceGetWorkflowUploadAuthTokenResult struct {
	Success *GetUploadAuthTokenResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetWorkflowUploadAuthTokenResult() *WorkflowServiceGetWorkflowUploadAuthTokenResult {
	return &WorkflowServiceGetWorkflowUploadAuthTokenResult{}
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) InitDefault() {
}

var WorkflowServiceGetWorkflowUploadAuthTokenResult_Success_DEFAULT *GetUploadAuthTokenResponse

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) GetSuccess() (v *GetUploadAuthTokenResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetWorkflowUploadAuthTokenResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetWorkflowUploadAuthTokenResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowUploadAuthTokenResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetUploadAuthTokenResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowUploadAuthToken_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowUploadAuthTokenResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowUploadAuthTokenResult(%+v)", *p)

}

type WorkflowServiceSignImageURLArgs struct {
	Request *SignImageURLRequest `thrift:"request,1"`
}

func NewWorkflowServiceSignImageURLArgs() *WorkflowServiceSignImageURLArgs {
	return &WorkflowServiceSignImageURLArgs{}
}

func (p *WorkflowServiceSignImageURLArgs) InitDefault() {
}

var WorkflowServiceSignImageURLArgs_Request_DEFAULT *SignImageURLRequest

func (p *WorkflowServiceSignImageURLArgs) GetRequest() (v *SignImageURLRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceSignImageURLArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceSignImageURLArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceSignImageURLArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceSignImageURLArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceSignImageURLArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceSignImageURLArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewSignImageURLRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceSignImageURLArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SignImageURL_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceSignImageURLArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceSignImageURLArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceSignImageURLArgs(%+v)", *p)

}

type WorkflowServiceSignImageURLResult struct {
	Success *SignImageURLResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceSignImageURLResult() *WorkflowServiceSignImageURLResult {
	return &WorkflowServiceSignImageURLResult{}
}

func (p *WorkflowServiceSignImageURLResult) InitDefault() {
}

var WorkflowServiceSignImageURLResult_Success_DEFAULT *SignImageURLResponse

func (p *WorkflowServiceSignImageURLResult) GetSuccess() (v *SignImageURLResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceSignImageURLResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceSignImageURLResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceSignImageURLResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceSignImageURLResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceSignImageURLResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceSignImageURLResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewSignImageURLResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceSignImageURLResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SignImageURL_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceSignImageURLResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceSignImageURLResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceSignImageURLResult(%+v)", *p)

}

type WorkflowServiceCreateProjectConversationDefArgs struct {
	Request *CreateProjectConversationDefRequest `thrift:"request,1"`
}

func NewWorkflowServiceCreateProjectConversationDefArgs() *WorkflowServiceCreateProjectConversationDefArgs {
	return &WorkflowServiceCreateProjectConversationDefArgs{}
}

func (p *WorkflowServiceCreateProjectConversationDefArgs) InitDefault() {
}

var WorkflowServiceCreateProjectConversationDefArgs_Request_DEFAULT *CreateProjectConversationDefRequest

func (p *WorkflowServiceCreateProjectConversationDefArgs) GetRequest() (v *CreateProjectConversationDefRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceCreateProjectConversationDefArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceCreateProjectConversationDefArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceCreateProjectConversationDefArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceCreateProjectConversationDefArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCreateProjectConversationDefArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCreateProjectConversationDefArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCreateProjectConversationDefRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceCreateProjectConversationDefArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateProjectConversationDef_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCreateProjectConversationDefArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceCreateProjectConversationDefArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCreateProjectConversationDefArgs(%+v)", *p)

}

type WorkflowServiceCreateProjectConversationDefResult struct {
	Success *CreateProjectConversationDefResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceCreateProjectConversationDefResult() *WorkflowServiceCreateProjectConversationDefResult {
	return &WorkflowServiceCreateProjectConversationDefResult{}
}

func (p *WorkflowServiceCreateProjectConversationDefResult) InitDefault() {
}

var WorkflowServiceCreateProjectConversationDefResult_Success_DEFAULT *CreateProjectConversationDefResponse

func (p *WorkflowServiceCreateProjectConversationDefResult) GetSuccess() (v *CreateProjectConversationDefResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceCreateProjectConversationDefResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceCreateProjectConversationDefResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceCreateProjectConversationDefResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceCreateProjectConversationDefResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCreateProjectConversationDefResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCreateProjectConversationDefResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCreateProjectConversationDefResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceCreateProjectConversationDefResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateProjectConversationDef_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCreateProjectConversationDefResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceCreateProjectConversationDefResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCreateProjectConversationDefResult(%+v)", *p)

}

type WorkflowServiceUpdateProjectConversationDefArgs struct {
	Request *UpdateProjectConversationDefRequest `thrift:"request,1"`
}

func NewWorkflowServiceUpdateProjectConversationDefArgs() *WorkflowServiceUpdateProjectConversationDefArgs {
	return &WorkflowServiceUpdateProjectConversationDefArgs{}
}

func (p *WorkflowServiceUpdateProjectConversationDefArgs) InitDefault() {
}

var WorkflowServiceUpdateProjectConversationDefArgs_Request_DEFAULT *UpdateProjectConversationDefRequest

func (p *WorkflowServiceUpdateProjectConversationDefArgs) GetRequest() (v *UpdateProjectConversationDefRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceUpdateProjectConversationDefArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceUpdateProjectConversationDefArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceUpdateProjectConversationDefArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceUpdateProjectConversationDefArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceUpdateProjectConversationDefArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateProjectConversationDefArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewUpdateProjectConversationDefRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceUpdateProjectConversationDefArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateProjectConversationDef_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateProjectConversationDefArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceUpdateProjectConversationDefArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceUpdateProjectConversationDefArgs(%+v)", *p)

}

type WorkflowServiceUpdateProjectConversationDefResult struct {
	Success *UpdateProjectConversationDefResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceUpdateProjectConversationDefResult() *WorkflowServiceUpdateProjectConversationDefResult {
	return &WorkflowServiceUpdateProjectConversationDefResult{}
}

func (p *WorkflowServiceUpdateProjectConversationDefResult) InitDefault() {
}

var WorkflowServiceUpdateProjectConversationDefResult_Success_DEFAULT *UpdateProjectConversationDefResponse

func (p *WorkflowServiceUpdateProjectConversationDefResult) GetSuccess() (v *UpdateProjectConversationDefResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceUpdateProjectConversationDefResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceUpdateProjectConversationDefResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceUpdateProjectConversationDefResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceUpdateProjectConversationDefResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceUpdateProjectConversationDefResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateProjectConversationDefResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewUpdateProjectConversationDefResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceUpdateProjectConversationDefResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateProjectConversationDef_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceUpdateProjectConversationDefResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceUpdateProjectConversationDefResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceUpdateProjectConversationDefResult(%+v)", *p)

}

type WorkflowServiceDeleteProjectConversationDefArgs struct {
	Request *DeleteProjectConversationDefRequest `thrift:"request,1"`
}

func NewWorkflowServiceDeleteProjectConversationDefArgs() *WorkflowServiceDeleteProjectConversationDefArgs {
	return &WorkflowServiceDeleteProjectConversationDefArgs{}
}

func (p *WorkflowServiceDeleteProjectConversationDefArgs) InitDefault() {
}

var WorkflowServiceDeleteProjectConversationDefArgs_Request_DEFAULT *DeleteProjectConversationDefRequest

func (p *WorkflowServiceDeleteProjectConversationDefArgs) GetRequest() (v *DeleteProjectConversationDefRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceDeleteProjectConversationDefArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceDeleteProjectConversationDefArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceDeleteProjectConversationDefArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceDeleteProjectConversationDefArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceDeleteProjectConversationDefArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteProjectConversationDefArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDeleteProjectConversationDefRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceDeleteProjectConversationDefArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteProjectConversationDef_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteProjectConversationDefArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceDeleteProjectConversationDefArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceDeleteProjectConversationDefArgs(%+v)", *p)

}

type WorkflowServiceDeleteProjectConversationDefResult struct {
	Success *DeleteProjectConversationDefResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceDeleteProjectConversationDefResult() *WorkflowServiceDeleteProjectConversationDefResult {
	return &WorkflowServiceDeleteProjectConversationDefResult{}
}

func (p *WorkflowServiceDeleteProjectConversationDefResult) InitDefault() {
}

var WorkflowServiceDeleteProjectConversationDefResult_Success_DEFAULT *DeleteProjectConversationDefResponse

func (p *WorkflowServiceDeleteProjectConversationDefResult) GetSuccess() (v *DeleteProjectConversationDefResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceDeleteProjectConversationDefResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceDeleteProjectConversationDefResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceDeleteProjectConversationDefResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceDeleteProjectConversationDefResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceDeleteProjectConversationDefResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteProjectConversationDefResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDeleteProjectConversationDefResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceDeleteProjectConversationDefResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteProjectConversationDef_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteProjectConversationDefResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceDeleteProjectConversationDefResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceDeleteProjectConversationDefResult(%+v)", *p)

}

type WorkflowServiceListProjectConversationDefArgs struct {
	Request *ListProjectConversationRequest `thrift:"request,1"`
}

func NewWorkflowServiceListProjectConversationDefArgs() *WorkflowServiceListProjectConversationDefArgs {
	return &WorkflowServiceListProjectConversationDefArgs{}
}

func (p *WorkflowServiceListProjectConversationDefArgs) InitDefault() {
}

var WorkflowServiceListProjectConversationDefArgs_Request_DEFAULT *ListProjectConversationRequest

func (p *WorkflowServiceListProjectConversationDefArgs) GetRequest() (v *ListProjectConversationRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceListProjectConversationDefArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceListProjectConversationDefArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceListProjectConversationDefArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceListProjectConversationDefArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceListProjectConversationDefArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceListProjectConversationDefArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewListProjectConversationRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceListProjectConversationDefArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListProjectConversationDef_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceListProjectConversationDefArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceListProjectConversationDefArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceListProjectConversationDefArgs(%+v)", *p)

}

type WorkflowServiceListProjectConversationDefResult struct {
	Success *ListProjectConversationResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceListProjectConversationDefResult() *WorkflowServiceListProjectConversationDefResult {
	return &WorkflowServiceListProjectConversationDefResult{}
}

func (p *WorkflowServiceListProjectConversationDefResult) InitDefault() {
}

var WorkflowServiceListProjectConversationDefResult_Success_DEFAULT *ListProjectConversationResponse

func (p *WorkflowServiceListProjectConversationDefResult) GetSuccess() (v *ListProjectConversationResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceListProjectConversationDefResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceListProjectConversationDefResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceListProjectConversationDefResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceListProjectConversationDefResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceListProjectConversationDefResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceListProjectConversationDefResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewListProjectConversationResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceListProjectConversationDefResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListProjectConversationDef_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceListProjectConversationDefResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceListProjectConversationDefResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceListProjectConversationDefResult(%+v)", *p)

}

type WorkflowServiceListRootSpansArgs struct {
	Req *ListRootSpansRequest `thrift:"req,1"`
}

func NewWorkflowServiceListRootSpansArgs() *WorkflowServiceListRootSpansArgs {
	return &WorkflowServiceListRootSpansArgs{}
}

func (p *WorkflowServiceListRootSpansArgs) InitDefault() {
}

var WorkflowServiceListRootSpansArgs_Req_DEFAULT *ListRootSpansRequest

func (p *WorkflowServiceListRootSpansArgs) GetReq() (v *ListRootSpansRequest) {
	if !p.IsSetReq() {
		return WorkflowServiceListRootSpansArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_WorkflowServiceListRootSpansArgs = map[int16]string{
	1: "req",
}

func (p *WorkflowServiceListRootSpansArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *WorkflowServiceListRootSpansArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceListRootSpansArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceListRootSpansArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewListRootSpansRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *WorkflowServiceListRootSpansArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListRootSpans_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceListRootSpansArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceListRootSpansArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceListRootSpansArgs(%+v)", *p)

}

type WorkflowServiceListRootSpansResult struct {
	Success *ListRootSpansResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceListRootSpansResult() *WorkflowServiceListRootSpansResult {
	return &WorkflowServiceListRootSpansResult{}
}

func (p *WorkflowServiceListRootSpansResult) InitDefault() {
}

var WorkflowServiceListRootSpansResult_Success_DEFAULT *ListRootSpansResponse

func (p *WorkflowServiceListRootSpansResult) GetSuccess() (v *ListRootSpansResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceListRootSpansResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceListRootSpansResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceListRootSpansResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceListRootSpansResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceListRootSpansResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceListRootSpansResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewListRootSpansResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceListRootSpansResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListRootSpans_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceListRootSpansResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceListRootSpansResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceListRootSpansResult(%+v)", *p)

}

type WorkflowServiceGetTraceSDKArgs struct {
	Req *GetTraceSDKRequest `thrift:"req,1"`
}

func NewWorkflowServiceGetTraceSDKArgs() *WorkflowServiceGetTraceSDKArgs {
	return &WorkflowServiceGetTraceSDKArgs{}
}

func (p *WorkflowServiceGetTraceSDKArgs) InitDefault() {
}

var WorkflowServiceGetTraceSDKArgs_Req_DEFAULT *GetTraceSDKRequest

func (p *WorkflowServiceGetTraceSDKArgs) GetReq() (v *GetTraceSDKRequest) {
	if !p.IsSetReq() {
		return WorkflowServiceGetTraceSDKArgs_Req_DEFAULT
	}
	return p.Req
}

var fieldIDToName_WorkflowServiceGetTraceSDKArgs = map[int16]string{
	1: "req",
}

func (p *WorkflowServiceGetTraceSDKArgs) IsSetReq() bool {
	return p.Req != nil
}

func (p *WorkflowServiceGetTraceSDKArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetTraceSDKArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetTraceSDKArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetTraceSDKRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Req = _field
	return nil
}

func (p *WorkflowServiceGetTraceSDKArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetTraceSDK_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetTraceSDKArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("req", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Req.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetTraceSDKArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetTraceSDKArgs(%+v)", *p)

}

type WorkflowServiceGetTraceSDKResult struct {
	Success *GetTraceSDKResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetTraceSDKResult() *WorkflowServiceGetTraceSDKResult {
	return &WorkflowServiceGetTraceSDKResult{}
}

func (p *WorkflowServiceGetTraceSDKResult) InitDefault() {
}

var WorkflowServiceGetTraceSDKResult_Success_DEFAULT *GetTraceSDKResponse

func (p *WorkflowServiceGetTraceSDKResult) GetSuccess() (v *GetTraceSDKResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetTraceSDKResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetTraceSDKResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetTraceSDKResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetTraceSDKResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetTraceSDKResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetTraceSDKResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetTraceSDKResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetTraceSDKResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetTraceSDK_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetTraceSDKResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetTraceSDKResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetTraceSDKResult(%+v)", *p)

}

type WorkflowServiceGetWorkflowDetailArgs struct {
	Request *GetWorkflowDetailRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetWorkflowDetailArgs() *WorkflowServiceGetWorkflowDetailArgs {
	return &WorkflowServiceGetWorkflowDetailArgs{}
}

func (p *WorkflowServiceGetWorkflowDetailArgs) InitDefault() {
}

var WorkflowServiceGetWorkflowDetailArgs_Request_DEFAULT *GetWorkflowDetailRequest

func (p *WorkflowServiceGetWorkflowDetailArgs) GetRequest() (v *GetWorkflowDetailRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetWorkflowDetailArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetWorkflowDetailArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetWorkflowDetailArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetWorkflowDetailArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowDetailArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowDetailRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowDetailArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowDetail_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowDetailArgs(%+v)", *p)

}

type WorkflowServiceGetWorkflowDetailResult struct {
	Success *GetWorkflowDetailResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetWorkflowDetailResult() *WorkflowServiceGetWorkflowDetailResult {
	return &WorkflowServiceGetWorkflowDetailResult{}
}

func (p *WorkflowServiceGetWorkflowDetailResult) InitDefault() {
}

var WorkflowServiceGetWorkflowDetailResult_Success_DEFAULT *GetWorkflowDetailResponse

func (p *WorkflowServiceGetWorkflowDetailResult) GetSuccess() (v *GetWorkflowDetailResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetWorkflowDetailResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetWorkflowDetailResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetWorkflowDetailResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetWorkflowDetailResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowDetailResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowDetailResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowDetailResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowDetail_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowDetailResult(%+v)", *p)

}

type WorkflowServiceGetWorkflowDetailInfoArgs struct {
	Request *GetWorkflowDetailInfoRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetWorkflowDetailInfoArgs() *WorkflowServiceGetWorkflowDetailInfoArgs {
	return &WorkflowServiceGetWorkflowDetailInfoArgs{}
}

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) InitDefault() {
}

var WorkflowServiceGetWorkflowDetailInfoArgs_Request_DEFAULT *GetWorkflowDetailInfoRequest

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) GetRequest() (v *GetWorkflowDetailInfoRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetWorkflowDetailInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetWorkflowDetailInfoArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowDetailInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowDetailInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowDetailInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowDetailInfoArgs(%+v)", *p)

}

type WorkflowServiceGetWorkflowDetailInfoResult struct {
	Success *GetWorkflowDetailInfoResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetWorkflowDetailInfoResult() *WorkflowServiceGetWorkflowDetailInfoResult {
	return &WorkflowServiceGetWorkflowDetailInfoResult{}
}

func (p *WorkflowServiceGetWorkflowDetailInfoResult) InitDefault() {
}

var WorkflowServiceGetWorkflowDetailInfoResult_Success_DEFAULT *GetWorkflowDetailInfoResponse

func (p *WorkflowServiceGetWorkflowDetailInfoResult) GetSuccess() (v *GetWorkflowDetailInfoResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetWorkflowDetailInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetWorkflowDetailInfoResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetWorkflowDetailInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetWorkflowDetailInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetWorkflowDetailInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowDetailInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetWorkflowDetailInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowDetailInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetWorkflowDetailInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetWorkflowDetailInfoResult(%+v)", *p)

}

type WorkflowServiceValidateTreeArgs struct {
	Request *ValidateTreeRequest `thrift:"request,1"`
}

func NewWorkflowServiceValidateTreeArgs() *WorkflowServiceValidateTreeArgs {
	return &WorkflowServiceValidateTreeArgs{}
}

func (p *WorkflowServiceValidateTreeArgs) InitDefault() {
}

var WorkflowServiceValidateTreeArgs_Request_DEFAULT *ValidateTreeRequest

func (p *WorkflowServiceValidateTreeArgs) GetRequest() (v *ValidateTreeRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceValidateTreeArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceValidateTreeArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceValidateTreeArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceValidateTreeArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceValidateTreeArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceValidateTreeArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewValidateTreeRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceValidateTreeArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ValidateTree_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceValidateTreeArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceValidateTreeArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceValidateTreeArgs(%+v)", *p)

}

type WorkflowServiceValidateTreeResult struct {
	Success *ValidateTreeResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceValidateTreeResult() *WorkflowServiceValidateTreeResult {
	return &WorkflowServiceValidateTreeResult{}
}

func (p *WorkflowServiceValidateTreeResult) InitDefault() {
}

var WorkflowServiceValidateTreeResult_Success_DEFAULT *ValidateTreeResponse

func (p *WorkflowServiceValidateTreeResult) GetSuccess() (v *ValidateTreeResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceValidateTreeResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceValidateTreeResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceValidateTreeResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceValidateTreeResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceValidateTreeResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceValidateTreeResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewValidateTreeResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceValidateTreeResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ValidateTree_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceValidateTreeResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceValidateTreeResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceValidateTreeResult(%+v)", *p)

}

type WorkflowServiceGetChatFlowRoleArgs struct {
	Request *GetChatFlowRoleRequest `thrift:"request,1"`
}

func NewWorkflowServiceGetChatFlowRoleArgs() *WorkflowServiceGetChatFlowRoleArgs {
	return &WorkflowServiceGetChatFlowRoleArgs{}
}

func (p *WorkflowServiceGetChatFlowRoleArgs) InitDefault() {
}

var WorkflowServiceGetChatFlowRoleArgs_Request_DEFAULT *GetChatFlowRoleRequest

func (p *WorkflowServiceGetChatFlowRoleArgs) GetRequest() (v *GetChatFlowRoleRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceGetChatFlowRoleArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceGetChatFlowRoleArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceGetChatFlowRoleArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceGetChatFlowRoleArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetChatFlowRoleArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetChatFlowRoleArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetChatFlowRoleRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceGetChatFlowRoleArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetChatFlowRole_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetChatFlowRoleArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceGetChatFlowRoleArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetChatFlowRoleArgs(%+v)", *p)

}

type WorkflowServiceGetChatFlowRoleResult struct {
	Success *GetChatFlowRoleResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceGetChatFlowRoleResult() *WorkflowServiceGetChatFlowRoleResult {
	return &WorkflowServiceGetChatFlowRoleResult{}
}

func (p *WorkflowServiceGetChatFlowRoleResult) InitDefault() {
}

var WorkflowServiceGetChatFlowRoleResult_Success_DEFAULT *GetChatFlowRoleResponse

func (p *WorkflowServiceGetChatFlowRoleResult) GetSuccess() (v *GetChatFlowRoleResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceGetChatFlowRoleResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceGetChatFlowRoleResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceGetChatFlowRoleResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceGetChatFlowRoleResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceGetChatFlowRoleResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceGetChatFlowRoleResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetChatFlowRoleResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceGetChatFlowRoleResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetChatFlowRole_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceGetChatFlowRoleResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceGetChatFlowRoleResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceGetChatFlowRoleResult(%+v)", *p)

}

type WorkflowServiceCreateChatFlowRoleArgs struct {
	Request *CreateChatFlowRoleRequest `thrift:"request,1"`
}

func NewWorkflowServiceCreateChatFlowRoleArgs() *WorkflowServiceCreateChatFlowRoleArgs {
	return &WorkflowServiceCreateChatFlowRoleArgs{}
}

func (p *WorkflowServiceCreateChatFlowRoleArgs) InitDefault() {
}

var WorkflowServiceCreateChatFlowRoleArgs_Request_DEFAULT *CreateChatFlowRoleRequest

func (p *WorkflowServiceCreateChatFlowRoleArgs) GetRequest() (v *CreateChatFlowRoleRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceCreateChatFlowRoleArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceCreateChatFlowRoleArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceCreateChatFlowRoleArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceCreateChatFlowRoleArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCreateChatFlowRoleArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCreateChatFlowRoleArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCreateChatFlowRoleRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceCreateChatFlowRoleArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateChatFlowRole_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCreateChatFlowRoleArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceCreateChatFlowRoleArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCreateChatFlowRoleArgs(%+v)", *p)

}

type WorkflowServiceCreateChatFlowRoleResult struct {
	Success *CreateChatFlowRoleResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceCreateChatFlowRoleResult() *WorkflowServiceCreateChatFlowRoleResult {
	return &WorkflowServiceCreateChatFlowRoleResult{}
}

func (p *WorkflowServiceCreateChatFlowRoleResult) InitDefault() {
}

var WorkflowServiceCreateChatFlowRoleResult_Success_DEFAULT *CreateChatFlowRoleResponse

func (p *WorkflowServiceCreateChatFlowRoleResult) GetSuccess() (v *CreateChatFlowRoleResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceCreateChatFlowRoleResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceCreateChatFlowRoleResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceCreateChatFlowRoleResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceCreateChatFlowRoleResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceCreateChatFlowRoleResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceCreateChatFlowRoleResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewCreateChatFlowRoleResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceCreateChatFlowRoleResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateChatFlowRole_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceCreateChatFlowRoleResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceCreateChatFlowRoleResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceCreateChatFlowRoleResult(%+v)", *p)

}

type WorkflowServiceDeleteChatFlowRoleArgs struct {
	Request *DeleteChatFlowRoleRequest `thrift:"request,1"`
}

func NewWorkflowServiceDeleteChatFlowRoleArgs() *WorkflowServiceDeleteChatFlowRoleArgs {
	return &WorkflowServiceDeleteChatFlowRoleArgs{}
}

func (p *WorkflowServiceDeleteChatFlowRoleArgs) InitDefault() {
}

var WorkflowServiceDeleteChatFlowRoleArgs_Request_DEFAULT *DeleteChatFlowRoleRequest

func (p *WorkflowServiceDeleteChatFlowRoleArgs) GetRequest() (v *DeleteChatFlowRoleRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceDeleteChatFlowRoleArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceDeleteChatFlowRoleArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceDeleteChatFlowRoleArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceDeleteChatFlowRoleArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceDeleteChatFlowRoleArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteChatFlowRoleArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDeleteChatFlowRoleRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceDeleteChatFlowRoleArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteChatFlowRole_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteChatFlowRoleArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceDeleteChatFlowRoleArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceDeleteChatFlowRoleArgs(%+v)", *p)

}

type WorkflowServiceDeleteChatFlowRoleResult struct {
	Success *DeleteChatFlowRoleResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceDeleteChatFlowRoleResult() *WorkflowServiceDeleteChatFlowRoleResult {
	return &WorkflowServiceDeleteChatFlowRoleResult{}
}

func (p *WorkflowServiceDeleteChatFlowRoleResult) InitDefault() {
}

var WorkflowServiceDeleteChatFlowRoleResult_Success_DEFAULT *DeleteChatFlowRoleResponse

func (p *WorkflowServiceDeleteChatFlowRoleResult) GetSuccess() (v *DeleteChatFlowRoleResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceDeleteChatFlowRoleResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceDeleteChatFlowRoleResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceDeleteChatFlowRoleResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceDeleteChatFlowRoleResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceDeleteChatFlowRoleResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteChatFlowRoleResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewDeleteChatFlowRoleResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceDeleteChatFlowRoleResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteChatFlowRole_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceDeleteChatFlowRoleResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceDeleteChatFlowRoleResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceDeleteChatFlowRoleResult(%+v)", *p)

}

type WorkflowServiceListPublishWorkflowArgs struct {
	Request *ListPublishWorkflowRequest `thrift:"request,1"`
}

func NewWorkflowServiceListPublishWorkflowArgs() *WorkflowServiceListPublishWorkflowArgs {
	return &WorkflowServiceListPublishWorkflowArgs{}
}

func (p *WorkflowServiceListPublishWorkflowArgs) InitDefault() {
}

var WorkflowServiceListPublishWorkflowArgs_Request_DEFAULT *ListPublishWorkflowRequest

func (p *WorkflowServiceListPublishWorkflowArgs) GetRequest() (v *ListPublishWorkflowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceListPublishWorkflowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceListPublishWorkflowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceListPublishWorkflowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceListPublishWorkflowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceListPublishWorkflowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceListPublishWorkflowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewListPublishWorkflowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceListPublishWorkflowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListPublishWorkflow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceListPublishWorkflowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceListPublishWorkflowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceListPublishWorkflowArgs(%+v)", *p)

}

type WorkflowServiceListPublishWorkflowResult struct {
	Success *ListPublishWorkflowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceListPublishWorkflowResult() *WorkflowServiceListPublishWorkflowResult {
	return &WorkflowServiceListPublishWorkflowResult{}
}

func (p *WorkflowServiceListPublishWorkflowResult) InitDefault() {
}

var WorkflowServiceListPublishWorkflowResult_Success_DEFAULT *ListPublishWorkflowResponse

func (p *WorkflowServiceListPublishWorkflowResult) GetSuccess() (v *ListPublishWorkflowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceListPublishWorkflowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceListPublishWorkflowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceListPublishWorkflowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceListPublishWorkflowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceListPublishWorkflowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceListPublishWorkflowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewListPublishWorkflowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceListPublishWorkflowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ListPublishWorkflow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceListPublishWorkflowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceListPublishWorkflowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceListPublishWorkflowResult(%+v)", *p)

}

type WorkflowServiceOpenAPIRunFlowArgs struct {
	Request *OpenAPIRunFlowRequest `thrift:"request,1"`
}

func NewWorkflowServiceOpenAPIRunFlowArgs() *WorkflowServiceOpenAPIRunFlowArgs {
	return &WorkflowServiceOpenAPIRunFlowArgs{}
}

func (p *WorkflowServiceOpenAPIRunFlowArgs) InitDefault() {
}

var WorkflowServiceOpenAPIRunFlowArgs_Request_DEFAULT *OpenAPIRunFlowRequest

func (p *WorkflowServiceOpenAPIRunFlowArgs) GetRequest() (v *OpenAPIRunFlowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceOpenAPIRunFlowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceOpenAPIRunFlowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceOpenAPIRunFlowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceOpenAPIRunFlowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIRunFlowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIRunFlowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewOpenAPIRunFlowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceOpenAPIRunFlowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIRunFlow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIRunFlowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIRunFlowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIRunFlowArgs(%+v)", *p)

}

type WorkflowServiceOpenAPIRunFlowResult struct {
	Success *OpenAPIRunFlowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceOpenAPIRunFlowResult() *WorkflowServiceOpenAPIRunFlowResult {
	return &WorkflowServiceOpenAPIRunFlowResult{}
}

func (p *WorkflowServiceOpenAPIRunFlowResult) InitDefault() {
}

var WorkflowServiceOpenAPIRunFlowResult_Success_DEFAULT *OpenAPIRunFlowResponse

func (p *WorkflowServiceOpenAPIRunFlowResult) GetSuccess() (v *OpenAPIRunFlowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceOpenAPIRunFlowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceOpenAPIRunFlowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceOpenAPIRunFlowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceOpenAPIRunFlowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIRunFlowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIRunFlowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewOpenAPIRunFlowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceOpenAPIRunFlowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIRunFlow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIRunFlowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIRunFlowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIRunFlowResult(%+v)", *p)

}

type WorkflowServiceOpenAPIStreamRunFlowArgs struct {
	Request *OpenAPIRunFlowRequest `thrift:"request,1"`
}

func NewWorkflowServiceOpenAPIStreamRunFlowArgs() *WorkflowServiceOpenAPIStreamRunFlowArgs {
	return &WorkflowServiceOpenAPIStreamRunFlowArgs{}
}

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) InitDefault() {
}

var WorkflowServiceOpenAPIStreamRunFlowArgs_Request_DEFAULT *OpenAPIRunFlowRequest

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) GetRequest() (v *OpenAPIRunFlowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceOpenAPIStreamRunFlowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceOpenAPIStreamRunFlowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIStreamRunFlowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewOpenAPIRunFlowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIStreamRunFlow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamRunFlowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIStreamRunFlowArgs(%+v)", *p)

}

type WorkflowServiceOpenAPIStreamRunFlowResult struct {
	Success *OpenAPIStreamRunFlowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceOpenAPIStreamRunFlowResult() *WorkflowServiceOpenAPIStreamRunFlowResult {
	return &WorkflowServiceOpenAPIStreamRunFlowResult{}
}

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) InitDefault() {
}

var WorkflowServiceOpenAPIStreamRunFlowResult_Success_DEFAULT *OpenAPIStreamRunFlowResponse

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) GetSuccess() (v *OpenAPIStreamRunFlowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceOpenAPIStreamRunFlowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceOpenAPIStreamRunFlowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIStreamRunFlowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewOpenAPIStreamRunFlowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIStreamRunFlow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamRunFlowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIStreamRunFlowResult(%+v)", *p)

}

type WorkflowServiceOpenAPIStreamResumeFlowArgs struct {
	Request *OpenAPIStreamResumeFlowRequest `thrift:"request,1"`
}

func NewWorkflowServiceOpenAPIStreamResumeFlowArgs() *WorkflowServiceOpenAPIStreamResumeFlowArgs {
	return &WorkflowServiceOpenAPIStreamResumeFlowArgs{}
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) InitDefault() {
}

var WorkflowServiceOpenAPIStreamResumeFlowArgs_Request_DEFAULT *OpenAPIStreamResumeFlowRequest

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) GetRequest() (v *OpenAPIStreamResumeFlowRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceOpenAPIStreamResumeFlowArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceOpenAPIStreamResumeFlowArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIStreamResumeFlowArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewOpenAPIStreamResumeFlowRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIStreamResumeFlow_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIStreamResumeFlowArgs(%+v)", *p)

}

type WorkflowServiceOpenAPIStreamResumeFlowResult struct {
	Success *OpenAPIStreamRunFlowResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceOpenAPIStreamResumeFlowResult() *WorkflowServiceOpenAPIStreamResumeFlowResult {
	return &WorkflowServiceOpenAPIStreamResumeFlowResult{}
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) InitDefault() {
}

var WorkflowServiceOpenAPIStreamResumeFlowResult_Success_DEFAULT *OpenAPIStreamRunFlowResponse

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) GetSuccess() (v *OpenAPIStreamRunFlowResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceOpenAPIStreamResumeFlowResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceOpenAPIStreamResumeFlowResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIStreamResumeFlowResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewOpenAPIStreamRunFlowResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIStreamResumeFlow_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIStreamResumeFlowResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIStreamResumeFlowResult(%+v)", *p)

}

type WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs struct {
	Request *GetWorkflowRunHistoryRequest `thrift:"request,1"`
}

func NewWorkflowServiceOpenAPIGetWorkflowRunHistoryArgs() *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs {
	return &WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs{}
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) InitDefault() {
}

var WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs_Request_DEFAULT *GetWorkflowRunHistoryRequest

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) GetRequest() (v *GetWorkflowRunHistoryRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowRunHistoryRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIGetWorkflowRunHistory_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIGetWorkflowRunHistoryArgs(%+v)", *p)

}

type WorkflowServiceOpenAPIGetWorkflowRunHistoryResult struct {
	Success *GetWorkflowRunHistoryResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceOpenAPIGetWorkflowRunHistoryResult() *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult {
	return &WorkflowServiceOpenAPIGetWorkflowRunHistoryResult{}
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) InitDefault() {
}

var WorkflowServiceOpenAPIGetWorkflowRunHistoryResult_Success_DEFAULT *GetWorkflowRunHistoryResponse

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) GetSuccess() (v *GetWorkflowRunHistoryResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceOpenAPIGetWorkflowRunHistoryResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceOpenAPIGetWorkflowRunHistoryResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIGetWorkflowRunHistoryResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewGetWorkflowRunHistoryResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIGetWorkflowRunHistory_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowRunHistoryResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIGetWorkflowRunHistoryResult(%+v)", *p)

}

type WorkflowServiceOpenAPIChatFlowRunArgs struct {
	Request *ChatFlowRunRequest `thrift:"request,1"`
}

func NewWorkflowServiceOpenAPIChatFlowRunArgs() *WorkflowServiceOpenAPIChatFlowRunArgs {
	return &WorkflowServiceOpenAPIChatFlowRunArgs{}
}

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) InitDefault() {
}

var WorkflowServiceOpenAPIChatFlowRunArgs_Request_DEFAULT *ChatFlowRunRequest

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) GetRequest() (v *ChatFlowRunRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceOpenAPIChatFlowRunArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceOpenAPIChatFlowRunArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIChatFlowRunArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewChatFlowRunRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIChatFlowRun_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIChatFlowRunArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIChatFlowRunArgs(%+v)", *p)

}

type WorkflowServiceOpenAPIChatFlowRunResult struct {
	Success *ChatFlowRunResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceOpenAPIChatFlowRunResult() *WorkflowServiceOpenAPIChatFlowRunResult {
	return &WorkflowServiceOpenAPIChatFlowRunResult{}
}

func (p *WorkflowServiceOpenAPIChatFlowRunResult) InitDefault() {
}

var WorkflowServiceOpenAPIChatFlowRunResult_Success_DEFAULT *ChatFlowRunResponse

func (p *WorkflowServiceOpenAPIChatFlowRunResult) GetSuccess() (v *ChatFlowRunResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceOpenAPIChatFlowRunResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceOpenAPIChatFlowRunResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceOpenAPIChatFlowRunResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceOpenAPIChatFlowRunResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIChatFlowRunResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIChatFlowRunResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewChatFlowRunResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceOpenAPIChatFlowRunResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIChatFlowRun_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIChatFlowRunResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIChatFlowRunResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIChatFlowRunResult(%+v)", *p)

}

type WorkflowServiceOpenAPIGetWorkflowInfoArgs struct {
	Request *OpenAPIGetWorkflowInfoRequest `thrift:"request,1"`
}

func NewWorkflowServiceOpenAPIGetWorkflowInfoArgs() *WorkflowServiceOpenAPIGetWorkflowInfoArgs {
	return &WorkflowServiceOpenAPIGetWorkflowInfoArgs{}
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) InitDefault() {
}

var WorkflowServiceOpenAPIGetWorkflowInfoArgs_Request_DEFAULT *OpenAPIGetWorkflowInfoRequest

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) GetRequest() (v *OpenAPIGetWorkflowInfoRequest) {
	if !p.IsSetRequest() {
		return WorkflowServiceOpenAPIGetWorkflowInfoArgs_Request_DEFAULT
	}
	return p.Request
}

var fieldIDToName_WorkflowServiceOpenAPIGetWorkflowInfoArgs = map[int16]string{
	1: "request",
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) IsSetRequest() bool {
	return p.Request != nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIGetWorkflowInfoArgs[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) ReadField1(iprot thrift.TProtocol) error {
	_field := NewOpenAPIGetWorkflowInfoRequest()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Request = _field
	return nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIGetWorkflowInfo_args"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("request", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Request.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIGetWorkflowInfoArgs(%+v)", *p)

}

type WorkflowServiceOpenAPIGetWorkflowInfoResult struct {
	Success *OpenAPIGetWorkflowInfoResponse `thrift:"success,0,optional"`
}

func NewWorkflowServiceOpenAPIGetWorkflowInfoResult() *WorkflowServiceOpenAPIGetWorkflowInfoResult {
	return &WorkflowServiceOpenAPIGetWorkflowInfoResult{}
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) InitDefault() {
}

var WorkflowServiceOpenAPIGetWorkflowInfoResult_Success_DEFAULT *OpenAPIGetWorkflowInfoResponse

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) GetSuccess() (v *OpenAPIGetWorkflowInfoResponse) {
	if !p.IsSetSuccess() {
		return WorkflowServiceOpenAPIGetWorkflowInfoResult_Success_DEFAULT
	}
	return p.Success
}

var fieldIDToName_WorkflowServiceOpenAPIGetWorkflowInfoResult = map[int16]string{
	0: "success",
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField0(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowServiceOpenAPIGetWorkflowInfoResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) ReadField0(iprot thrift.TProtocol) error {
	_field := NewOpenAPIGetWorkflowInfoResponse()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Success = _field
	return nil
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPIGetWorkflowInfo_result"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField0(oprot); err != nil {
			fieldId = 0
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) writeField0(oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err = oprot.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Success.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 0 end error: ", p), err)
}

func (p *WorkflowServiceOpenAPIGetWorkflowInfoResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowServiceOpenAPIGetWorkflowInfoResult(%+v)", *p)

}
