// Code generated by thriftgo (0.4.1). DO NOT EDIT.

package workflow

import (
	"database/sql"
	"database/sql/driver"
	"fmt"
	"github.com/apache/thrift/lib/go/thrift"
	"github.com/coze-dev/coze-studio/backend/api/model/base"
)

type PersistenceModel int64

const (
	PersistenceModel_DB       PersistenceModel = 1
	PersistenceModel_VCS      PersistenceModel = 2
	PersistenceModel_External PersistenceModel = 3
)

func (p PersistenceModel) String() string {
	switch p {
	case PersistenceModel_DB:
		return "DB"
	case PersistenceModel_VCS:
		return "VCS"
	case PersistenceModel_External:
		return "External"
	}
	return "<UNSET>"
}

func PersistenceModelFromString(s string) (PersistenceModel, error) {
	switch s {
	case "DB":
		return PersistenceModel_DB, nil
	case "VCS":
		return PersistenceModel_VCS, nil
	case "External":
		return PersistenceModel_External, nil
	}
	return PersistenceModel(0), fmt.Errorf("not a valid PersistenceModel string")
}

func PersistenceModelPtr(v PersistenceModel) *PersistenceModel { return &v }
func (p *PersistenceModel) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PersistenceModel(result.Int64)
	return
}

func (p *PersistenceModel) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// WorkflowMode is used to distinguish between Workflow and chatflow.
type WorkflowMode int64

const (
	WorkflowMode_Workflow  WorkflowMode = 0
	WorkflowMode_Imageflow WorkflowMode = 1
	WorkflowMode_SceneFlow WorkflowMode = 2
	WorkflowMode_ChatFlow  WorkflowMode = 3
	// Use only when querying
	WorkflowMode_All WorkflowMode = 100
)

func (p WorkflowMode) String() string {
	switch p {
	case WorkflowMode_Workflow:
		return "Workflow"
	case WorkflowMode_Imageflow:
		return "Imageflow"
	case WorkflowMode_SceneFlow:
		return "SceneFlow"
	case WorkflowMode_ChatFlow:
		return "ChatFlow"
	case WorkflowMode_All:
		return "All"
	}
	return "<UNSET>"
}

func WorkflowModeFromString(s string) (WorkflowMode, error) {
	switch s {
	case "Workflow":
		return WorkflowMode_Workflow, nil
	case "Imageflow":
		return WorkflowMode_Imageflow, nil
	case "SceneFlow":
		return WorkflowMode_SceneFlow, nil
	case "ChatFlow":
		return WorkflowMode_ChatFlow, nil
	case "All":
		return WorkflowMode_All, nil
	}
	return WorkflowMode(0), fmt.Errorf("not a valid WorkflowMode string")
}

func WorkflowModePtr(v WorkflowMode) *WorkflowMode { return &v }
func (p *WorkflowMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkflowMode(result.Int64)
	return
}

func (p *WorkflowMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Workflow Product Review Draft Status
type ProductDraftStatus int64

const (
	// default
	ProductDraftStatus_Default ProductDraftStatus = 0
	// Under review.
	ProductDraftStatus_Pending ProductDraftStatus = 1
	// approved
	ProductDraftStatus_Approved ProductDraftStatus = 2
	// The review failed.
	ProductDraftStatus_Rejected ProductDraftStatus = 3
	// Abandoned
	ProductDraftStatus_Abandoned ProductDraftStatus = 4
)

func (p ProductDraftStatus) String() string {
	switch p {
	case ProductDraftStatus_Default:
		return "Default"
	case ProductDraftStatus_Pending:
		return "Pending"
	case ProductDraftStatus_Approved:
		return "Approved"
	case ProductDraftStatus_Rejected:
		return "Rejected"
	case ProductDraftStatus_Abandoned:
		return "Abandoned"
	}
	return "<UNSET>"
}

func ProductDraftStatusFromString(s string) (ProductDraftStatus, error) {
	switch s {
	case "Default":
		return ProductDraftStatus_Default, nil
	case "Pending":
		return ProductDraftStatus_Pending, nil
	case "Approved":
		return ProductDraftStatus_Approved, nil
	case "Rejected":
		return ProductDraftStatus_Rejected, nil
	case "Abandoned":
		return ProductDraftStatus_Abandoned, nil
	}
	return ProductDraftStatus(0), fmt.Errorf("not a valid ProductDraftStatus string")
}

func ProductDraftStatusPtr(v ProductDraftStatus) *ProductDraftStatus { return &v }
func (p *ProductDraftStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ProductDraftStatus(result.Int64)
	return
}

func (p *ProductDraftStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type CollaboratorMode int64

const (
	// Turn off multiplayer collaboration mode
	CollaboratorMode_Close CollaboratorMode = 0
	// Enable multiplayer collaboration mode
	CollaboratorMode_Open CollaboratorMode = 1
)

func (p CollaboratorMode) String() string {
	switch p {
	case CollaboratorMode_Close:
		return "Close"
	case CollaboratorMode_Open:
		return "Open"
	}
	return "<UNSET>"
}

func CollaboratorModeFromString(s string) (CollaboratorMode, error) {
	switch s {
	case "Close":
		return CollaboratorMode_Close, nil
	case "Open":
		return CollaboratorMode_Open, nil
	}
	return CollaboratorMode(0), fmt.Errorf("not a valid CollaboratorMode string")
}

func CollaboratorModePtr(v CollaboratorMode) *CollaboratorMode { return &v }
func (p *CollaboratorMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = CollaboratorMode(result.Int64)
	return
}

func (p *CollaboratorMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SchemaType int64

const (
	// abandoned
	SchemaType_DAG SchemaType = 0
	SchemaType_FDL SchemaType = 1
	// abandoned
	SchemaType_BlockWise SchemaType = 2
)

func (p SchemaType) String() string {
	switch p {
	case SchemaType_DAG:
		return "DAG"
	case SchemaType_FDL:
		return "FDL"
	case SchemaType_BlockWise:
		return "BlockWise"
	}
	return "<UNSET>"
}

func SchemaTypeFromString(s string) (SchemaType, error) {
	switch s {
	case "DAG":
		return SchemaType_DAG, nil
	case "FDL":
		return SchemaType_FDL, nil
	case "BlockWise":
		return SchemaType_BlockWise, nil
	}
	return SchemaType(0), fmt.Errorf("not a valid SchemaType string")
}

func SchemaTypePtr(v SchemaType) *SchemaType { return &v }
func (p *SchemaType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SchemaType(result.Int64)
	return
}

func (p *SchemaType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type WorkFlowType int64

const (
	// user defined
	WorkFlowType_User WorkFlowType = 0
	// official template
	WorkFlowType_GuanFang WorkFlowType = 1
)

func (p WorkFlowType) String() string {
	switch p {
	case WorkFlowType_User:
		return "User"
	case WorkFlowType_GuanFang:
		return "GuanFang"
	}
	return "<UNSET>"
}

func WorkFlowTypeFromString(s string) (WorkFlowType, error) {
	switch s {
	case "User":
		return WorkFlowType_User, nil
	case "GuanFang":
		return WorkFlowType_GuanFang, nil
	}
	return WorkFlowType(0), fmt.Errorf("not a valid WorkFlowType string")
}

func WorkFlowTypePtr(v WorkFlowType) *WorkFlowType { return &v }
func (p *WorkFlowType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkFlowType(result.Int64)
	return
}

func (p *WorkFlowType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type Tag int64

const (
	Tag_All           Tag = 1
	Tag_Hot           Tag = 2
	Tag_Information   Tag = 3
	Tag_Music         Tag = 4
	Tag_Picture       Tag = 5
	Tag_UtilityTool   Tag = 6
	Tag_Life          Tag = 7
	Tag_Traval        Tag = 8
	Tag_Network       Tag = 9
	Tag_System        Tag = 10
	Tag_Movie         Tag = 11
	Tag_Office        Tag = 12
	Tag_Shopping      Tag = 13
	Tag_Education     Tag = 14
	Tag_Health        Tag = 15
	Tag_Social        Tag = 16
	Tag_Entertainment Tag = 17
	Tag_Finance       Tag = 18
	Tag_Hidden        Tag = 100
)

func (p Tag) String() string {
	switch p {
	case Tag_All:
		return "All"
	case Tag_Hot:
		return "Hot"
	case Tag_Information:
		return "Information"
	case Tag_Music:
		return "Music"
	case Tag_Picture:
		return "Picture"
	case Tag_UtilityTool:
		return "UtilityTool"
	case Tag_Life:
		return "Life"
	case Tag_Traval:
		return "Traval"
	case Tag_Network:
		return "Network"
	case Tag_System:
		return "System"
	case Tag_Movie:
		return "Movie"
	case Tag_Office:
		return "Office"
	case Tag_Shopping:
		return "Shopping"
	case Tag_Education:
		return "Education"
	case Tag_Health:
		return "Health"
	case Tag_Social:
		return "Social"
	case Tag_Entertainment:
		return "Entertainment"
	case Tag_Finance:
		return "Finance"
	case Tag_Hidden:
		return "Hidden"
	}
	return "<UNSET>"
}

func TagFromString(s string) (Tag, error) {
	switch s {
	case "All":
		return Tag_All, nil
	case "Hot":
		return Tag_Hot, nil
	case "Information":
		return Tag_Information, nil
	case "Music":
		return Tag_Music, nil
	case "Picture":
		return Tag_Picture, nil
	case "UtilityTool":
		return Tag_UtilityTool, nil
	case "Life":
		return Tag_Life, nil
	case "Traval":
		return Tag_Traval, nil
	case "Network":
		return Tag_Network, nil
	case "System":
		return Tag_System, nil
	case "Movie":
		return Tag_Movie, nil
	case "Office":
		return Tag_Office, nil
	case "Shopping":
		return Tag_Shopping, nil
	case "Education":
		return Tag_Education, nil
	case "Health":
		return Tag_Health, nil
	case "Social":
		return Tag_Social, nil
	case "Entertainment":
		return Tag_Entertainment, nil
	case "Finance":
		return Tag_Finance, nil
	case "Hidden":
		return Tag_Hidden, nil
	}
	return Tag(0), fmt.Errorf("not a valid Tag string")
}

func TagPtr(v Tag) *Tag { return &v }
func (p *Tag) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = Tag(result.Int64)
	return
}

func (p *Tag) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Node structure
type NodeType int64

const (
	NodeType_Start               NodeType = 1
	NodeType_End                 NodeType = 2
	NodeType_LLM                 NodeType = 3
	NodeType_Api                 NodeType = 4
	NodeType_Code                NodeType = 5
	NodeType_Dataset             NodeType = 6
	NodeType_If                  NodeType = 8
	NodeType_SubWorkflow         NodeType = 9
	NodeType_Variable            NodeType = 11
	NodeType_Database            NodeType = 12
	NodeType_Message             NodeType = 13
	NodeType_Text                NodeType = 15
	NodeType_ImageGenerate       NodeType = 16
	NodeType_ImageReference      NodeType = 17
	NodeType_Question            NodeType = 18
	NodeType_Break               NodeType = 19
	NodeType_LoopSetVariable     NodeType = 20
	NodeType_Loop                NodeType = 21
	NodeType_Intent              NodeType = 22
	NodeType_DrawingBoard        NodeType = 23
	NodeType_SceneVariable       NodeType = 24
	NodeType_SceneChat           NodeType = 25
	NodeType_DatasetWrite        NodeType = 27
	NodeType_Input               NodeType = 30
	NodeType_Batch               NodeType = 28
	NodeType_Continue            NodeType = 29
	NodeType_AssignVariable      NodeType = 40
	NodeType_JsonSerialization   NodeType = 58
	NodeType_JsonDeserialization NodeType = 59
	NodeType_DatasetDelete       NodeType = 60
)

func (p NodeType) String() string {
	switch p {
	case NodeType_Start:
		return "Start"
	case NodeType_End:
		return "End"
	case NodeType_LLM:
		return "LLM"
	case NodeType_Api:
		return "Api"
	case NodeType_Code:
		return "Code"
	case NodeType_Dataset:
		return "Dataset"
	case NodeType_If:
		return "If"
	case NodeType_SubWorkflow:
		return "SubWorkflow"
	case NodeType_Variable:
		return "Variable"
	case NodeType_Database:
		return "Database"
	case NodeType_Message:
		return "Message"
	case NodeType_Text:
		return "Text"
	case NodeType_ImageGenerate:
		return "ImageGenerate"
	case NodeType_ImageReference:
		return "ImageReference"
	case NodeType_Question:
		return "Question"
	case NodeType_Break:
		return "Break"
	case NodeType_LoopSetVariable:
		return "LoopSetVariable"
	case NodeType_Loop:
		return "Loop"
	case NodeType_Intent:
		return "Intent"
	case NodeType_DrawingBoard:
		return "DrawingBoard"
	case NodeType_SceneVariable:
		return "SceneVariable"
	case NodeType_SceneChat:
		return "SceneChat"
	case NodeType_DatasetWrite:
		return "DatasetWrite"
	case NodeType_Input:
		return "Input"
	case NodeType_Batch:
		return "Batch"
	case NodeType_Continue:
		return "Continue"
	case NodeType_AssignVariable:
		return "AssignVariable"
	case NodeType_JsonSerialization:
		return "JsonSerialization"
	case NodeType_JsonDeserialization:
		return "JsonDeserialization"
	case NodeType_DatasetDelete:
		return "DatasetDelete"
	}
	return "<UNSET>"
}

func NodeTypeFromString(s string) (NodeType, error) {
	switch s {
	case "Start":
		return NodeType_Start, nil
	case "End":
		return NodeType_End, nil
	case "LLM":
		return NodeType_LLM, nil
	case "Api":
		return NodeType_Api, nil
	case "Code":
		return NodeType_Code, nil
	case "Dataset":
		return NodeType_Dataset, nil
	case "If":
		return NodeType_If, nil
	case "SubWorkflow":
		return NodeType_SubWorkflow, nil
	case "Variable":
		return NodeType_Variable, nil
	case "Database":
		return NodeType_Database, nil
	case "Message":
		return NodeType_Message, nil
	case "Text":
		return NodeType_Text, nil
	case "ImageGenerate":
		return NodeType_ImageGenerate, nil
	case "ImageReference":
		return NodeType_ImageReference, nil
	case "Question":
		return NodeType_Question, nil
	case "Break":
		return NodeType_Break, nil
	case "LoopSetVariable":
		return NodeType_LoopSetVariable, nil
	case "Loop":
		return NodeType_Loop, nil
	case "Intent":
		return NodeType_Intent, nil
	case "DrawingBoard":
		return NodeType_DrawingBoard, nil
	case "SceneVariable":
		return NodeType_SceneVariable, nil
	case "SceneChat":
		return NodeType_SceneChat, nil
	case "DatasetWrite":
		return NodeType_DatasetWrite, nil
	case "Input":
		return NodeType_Input, nil
	case "Batch":
		return NodeType_Batch, nil
	case "Continue":
		return NodeType_Continue, nil
	case "AssignVariable":
		return NodeType_AssignVariable, nil
	case "JsonSerialization":
		return NodeType_JsonSerialization, nil
	case "JsonDeserialization":
		return NodeType_JsonDeserialization, nil
	case "DatasetDelete":
		return NodeType_DatasetDelete, nil
	}
	return NodeType(0), fmt.Errorf("not a valid NodeType string")
}

func NodeTypePtr(v NodeType) *NodeType { return &v }
func (p *NodeType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = NodeType(result.Int64)
	return
}

func (p *NodeType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// The node template type is basically the same as NodeType. One copy is due to the addition of an Imageflow type to avoid affecting the business semantics of the original NodeType
type NodeTemplateType int64

const (
	NodeTemplateType_Start               NodeTemplateType = 1
	NodeTemplateType_End                 NodeTemplateType = 2
	NodeTemplateType_LLM                 NodeTemplateType = 3
	NodeTemplateType_Api                 NodeTemplateType = 4
	NodeTemplateType_Code                NodeTemplateType = 5
	NodeTemplateType_Dataset             NodeTemplateType = 6
	NodeTemplateType_If                  NodeTemplateType = 8
	NodeTemplateType_SubWorkflow         NodeTemplateType = 9
	NodeTemplateType_Variable            NodeTemplateType = 11
	NodeTemplateType_Database            NodeTemplateType = 12
	NodeTemplateType_Message             NodeTemplateType = 13
	NodeTemplateType_Imageflow           NodeTemplateType = 14
	NodeTemplateType_Text                NodeTemplateType = 15
	NodeTemplateType_ImageGenerate       NodeTemplateType = 16
	NodeTemplateType_ImageReference      NodeTemplateType = 17
	NodeTemplateType_Question            NodeTemplateType = 18
	NodeTemplateType_Break               NodeTemplateType = 19
	NodeTemplateType_LoopSetVariable     NodeTemplateType = 20
	NodeTemplateType_Loop                NodeTemplateType = 21
	NodeTemplateType_Intent              NodeTemplateType = 22
	NodeTemplateType_DrawingBoard        NodeTemplateType = 23
	NodeTemplateType_SceneVariable       NodeTemplateType = 24
	NodeTemplateType_SceneChat           NodeTemplateType = 25
	NodeTemplateType_DatasetWrite        NodeTemplateType = 27
	NodeTemplateType_Input               NodeTemplateType = 30
	NodeTemplateType_Batch               NodeTemplateType = 28
	NodeTemplateType_Continue            NodeTemplateType = 29
	NodeTemplateType_AssignVariable      NodeTemplateType = 40
	NodeTemplateType_DatabaseInsert      NodeTemplateType = 41
	NodeTemplateType_DatabaseUpdate      NodeTemplateType = 42
	NodeTemplateType_DatabasesELECT      NodeTemplateType = 43
	NodeTemplateType_DatabaseDelete      NodeTemplateType = 44
	NodeTemplateType_JsonSerialization   NodeTemplateType = 58
	NodeTemplateType_JsonDeserialization NodeTemplateType = 59
	NodeTemplateType_DatasetDelete       NodeTemplateType = 60
)

func (p NodeTemplateType) String() string {
	switch p {
	case NodeTemplateType_Start:
		return "Start"
	case NodeTemplateType_End:
		return "End"
	case NodeTemplateType_LLM:
		return "LLM"
	case NodeTemplateType_Api:
		return "Api"
	case NodeTemplateType_Code:
		return "Code"
	case NodeTemplateType_Dataset:
		return "Dataset"
	case NodeTemplateType_If:
		return "If"
	case NodeTemplateType_SubWorkflow:
		return "SubWorkflow"
	case NodeTemplateType_Variable:
		return "Variable"
	case NodeTemplateType_Database:
		return "Database"
	case NodeTemplateType_Message:
		return "Message"
	case NodeTemplateType_Imageflow:
		return "Imageflow"
	case NodeTemplateType_Text:
		return "Text"
	case NodeTemplateType_ImageGenerate:
		return "ImageGenerate"
	case NodeTemplateType_ImageReference:
		return "ImageReference"
	case NodeTemplateType_Question:
		return "Question"
	case NodeTemplateType_Break:
		return "Break"
	case NodeTemplateType_LoopSetVariable:
		return "LoopSetVariable"
	case NodeTemplateType_Loop:
		return "Loop"
	case NodeTemplateType_Intent:
		return "Intent"
	case NodeTemplateType_DrawingBoard:
		return "DrawingBoard"
	case NodeTemplateType_SceneVariable:
		return "SceneVariable"
	case NodeTemplateType_SceneChat:
		return "SceneChat"
	case NodeTemplateType_DatasetWrite:
		return "DatasetWrite"
	case NodeTemplateType_Input:
		return "Input"
	case NodeTemplateType_Batch:
		return "Batch"
	case NodeTemplateType_Continue:
		return "Continue"
	case NodeTemplateType_AssignVariable:
		return "AssignVariable"
	case NodeTemplateType_DatabaseInsert:
		return "DatabaseInsert"
	case NodeTemplateType_DatabaseUpdate:
		return "DatabaseUpdate"
	case NodeTemplateType_DatabasesELECT:
		return "DatabasesELECT"
	case NodeTemplateType_DatabaseDelete:
		return "DatabaseDelete"
	case NodeTemplateType_JsonSerialization:
		return "JsonSerialization"
	case NodeTemplateType_JsonDeserialization:
		return "JsonDeserialization"
	case NodeTemplateType_DatasetDelete:
		return "DatasetDelete"
	}
	return "<UNSET>"
}

func NodeTemplateTypeFromString(s string) (NodeTemplateType, error) {
	switch s {
	case "Start":
		return NodeTemplateType_Start, nil
	case "End":
		return NodeTemplateType_End, nil
	case "LLM":
		return NodeTemplateType_LLM, nil
	case "Api":
		return NodeTemplateType_Api, nil
	case "Code":
		return NodeTemplateType_Code, nil
	case "Dataset":
		return NodeTemplateType_Dataset, nil
	case "If":
		return NodeTemplateType_If, nil
	case "SubWorkflow":
		return NodeTemplateType_SubWorkflow, nil
	case "Variable":
		return NodeTemplateType_Variable, nil
	case "Database":
		return NodeTemplateType_Database, nil
	case "Message":
		return NodeTemplateType_Message, nil
	case "Imageflow":
		return NodeTemplateType_Imageflow, nil
	case "Text":
		return NodeTemplateType_Text, nil
	case "ImageGenerate":
		return NodeTemplateType_ImageGenerate, nil
	case "ImageReference":
		return NodeTemplateType_ImageReference, nil
	case "Question":
		return NodeTemplateType_Question, nil
	case "Break":
		return NodeTemplateType_Break, nil
	case "LoopSetVariable":
		return NodeTemplateType_LoopSetVariable, nil
	case "Loop":
		return NodeTemplateType_Loop, nil
	case "Intent":
		return NodeTemplateType_Intent, nil
	case "DrawingBoard":
		return NodeTemplateType_DrawingBoard, nil
	case "SceneVariable":
		return NodeTemplateType_SceneVariable, nil
	case "SceneChat":
		return NodeTemplateType_SceneChat, nil
	case "DatasetWrite":
		return NodeTemplateType_DatasetWrite, nil
	case "Input":
		return NodeTemplateType_Input, nil
	case "Batch":
		return NodeTemplateType_Batch, nil
	case "Continue":
		return NodeTemplateType_Continue, nil
	case "AssignVariable":
		return NodeTemplateType_AssignVariable, nil
	case "DatabaseInsert":
		return NodeTemplateType_DatabaseInsert, nil
	case "DatabaseUpdate":
		return NodeTemplateType_DatabaseUpdate, nil
	case "DatabasesELECT":
		return NodeTemplateType_DatabasesELECT, nil
	case "DatabaseDelete":
		return NodeTemplateType_DatabaseDelete, nil
	case "JsonSerialization":
		return NodeTemplateType_JsonSerialization, nil
	case "JsonDeserialization":
		return NodeTemplateType_JsonDeserialization, nil
	case "DatasetDelete":
		return NodeTemplateType_DatasetDelete, nil
	}
	return NodeTemplateType(0), fmt.Errorf("not a valid NodeTemplateType string")
}

func NodeTemplateTypePtr(v NodeTemplateType) *NodeTemplateType { return &v }
func (p *NodeTemplateType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = NodeTemplateType(result.Int64)
	return
}

func (p *NodeTemplateType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type IfConditionRelation int64

const (
	IfConditionRelation_And IfConditionRelation = 1
	IfConditionRelation_Or  IfConditionRelation = 2
)

func (p IfConditionRelation) String() string {
	switch p {
	case IfConditionRelation_And:
		return "And"
	case IfConditionRelation_Or:
		return "Or"
	}
	return "<UNSET>"
}

func IfConditionRelationFromString(s string) (IfConditionRelation, error) {
	switch s {
	case "And":
		return IfConditionRelation_And, nil
	case "Or":
		return IfConditionRelation_Or, nil
	}
	return IfConditionRelation(0), fmt.Errorf("not a valid IfConditionRelation string")
}

func IfConditionRelationPtr(v IfConditionRelation) *IfConditionRelation { return &v }
func (p *IfConditionRelation) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = IfConditionRelation(result.Int64)
	return
}

func (p *IfConditionRelation) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ConditionType int64

const (
	ConditionType_Equal         ConditionType = 1
	ConditionType_NotEqual      ConditionType = 2
	ConditionType_LengthGt      ConditionType = 3
	ConditionType_LengthGtEqual ConditionType = 4
	ConditionType_LengthLt      ConditionType = 5
	ConditionType_LengthLtEqual ConditionType = 6
	ConditionType_Contains      ConditionType = 7
	ConditionType_NotContains   ConditionType = 8
	ConditionType_Null          ConditionType = 9
	ConditionType_NotNull       ConditionType = 10
	ConditionType_True          ConditionType = 11
	ConditionType_False         ConditionType = 12
	ConditionType_Gt            ConditionType = 13
	ConditionType_GtEqual       ConditionType = 14
	ConditionType_Lt            ConditionType = 15
	ConditionType_LtEqual       ConditionType = 16
)

func (p ConditionType) String() string {
	switch p {
	case ConditionType_Equal:
		return "Equal"
	case ConditionType_NotEqual:
		return "NotEqual"
	case ConditionType_LengthGt:
		return "LengthGt"
	case ConditionType_LengthGtEqual:
		return "LengthGtEqual"
	case ConditionType_LengthLt:
		return "LengthLt"
	case ConditionType_LengthLtEqual:
		return "LengthLtEqual"
	case ConditionType_Contains:
		return "Contains"
	case ConditionType_NotContains:
		return "NotContains"
	case ConditionType_Null:
		return "Null"
	case ConditionType_NotNull:
		return "NotNull"
	case ConditionType_True:
		return "True"
	case ConditionType_False:
		return "False"
	case ConditionType_Gt:
		return "Gt"
	case ConditionType_GtEqual:
		return "GtEqual"
	case ConditionType_Lt:
		return "Lt"
	case ConditionType_LtEqual:
		return "LtEqual"
	}
	return "<UNSET>"
}

func ConditionTypeFromString(s string) (ConditionType, error) {
	switch s {
	case "Equal":
		return ConditionType_Equal, nil
	case "NotEqual":
		return ConditionType_NotEqual, nil
	case "LengthGt":
		return ConditionType_LengthGt, nil
	case "LengthGtEqual":
		return ConditionType_LengthGtEqual, nil
	case "LengthLt":
		return ConditionType_LengthLt, nil
	case "LengthLtEqual":
		return ConditionType_LengthLtEqual, nil
	case "Contains":
		return ConditionType_Contains, nil
	case "NotContains":
		return ConditionType_NotContains, nil
	case "Null":
		return ConditionType_Null, nil
	case "NotNull":
		return ConditionType_NotNull, nil
	case "True":
		return ConditionType_True, nil
	case "False":
		return ConditionType_False, nil
	case "Gt":
		return ConditionType_Gt, nil
	case "GtEqual":
		return ConditionType_GtEqual, nil
	case "Lt":
		return ConditionType_Lt, nil
	case "LtEqual":
		return ConditionType_LtEqual, nil
	}
	return ConditionType(0), fmt.Errorf("not a valid ConditionType string")
}

func ConditionTypePtr(v ConditionType) *ConditionType { return &v }
func (p *ConditionType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ConditionType(result.Int64)
	return
}

func (p *ConditionType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type InputType int64

const (
	InputType_String  InputType = 1
	InputType_Integer InputType = 2
	InputType_Boolean InputType = 3
	InputType_Number  InputType = 4
	InputType_Array   InputType = 5
	InputType_Object  InputType = 6
)

func (p InputType) String() string {
	switch p {
	case InputType_String:
		return "String"
	case InputType_Integer:
		return "Integer"
	case InputType_Boolean:
		return "Boolean"
	case InputType_Number:
		return "Number"
	case InputType_Array:
		return "Array"
	case InputType_Object:
		return "Object"
	}
	return "<UNSET>"
}

func InputTypeFromString(s string) (InputType, error) {
	switch s {
	case "String":
		return InputType_String, nil
	case "Integer":
		return InputType_Integer, nil
	case "Boolean":
		return InputType_Boolean, nil
	case "Number":
		return InputType_Number, nil
	case "Array":
		return InputType_Array, nil
	case "Object":
		return InputType_Object, nil
	}
	return InputType(0), fmt.Errorf("not a valid InputType string")
}

func InputTypePtr(v InputType) *InputType { return &v }
func (p *InputType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = InputType(result.Int64)
	return
}

func (p *InputType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ParamRequirementType int64

const (
	ParamRequirementType_CanNotDelete         ParamRequirementType = 1
	ParamRequirementType_CanNotChangeName     ParamRequirementType = 2
	ParamRequirementType_CanChange            ParamRequirementType = 3
	ParamRequirementType_CanNotChangeAnything ParamRequirementType = 4
)

func (p ParamRequirementType) String() string {
	switch p {
	case ParamRequirementType_CanNotDelete:
		return "CanNotDelete"
	case ParamRequirementType_CanNotChangeName:
		return "CanNotChangeName"
	case ParamRequirementType_CanChange:
		return "CanChange"
	case ParamRequirementType_CanNotChangeAnything:
		return "CanNotChangeAnything"
	}
	return "<UNSET>"
}

func ParamRequirementTypeFromString(s string) (ParamRequirementType, error) {
	switch s {
	case "CanNotDelete":
		return ParamRequirementType_CanNotDelete, nil
	case "CanNotChangeName":
		return ParamRequirementType_CanNotChangeName, nil
	case "CanChange":
		return ParamRequirementType_CanChange, nil
	case "CanNotChangeAnything":
		return ParamRequirementType_CanNotChangeAnything, nil
	}
	return ParamRequirementType(0), fmt.Errorf("not a valid ParamRequirementType string")
}

func ParamRequirementTypePtr(v ParamRequirementType) *ParamRequirementType { return &v }
func (p *ParamRequirementType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ParamRequirementType(result.Int64)
	return
}

func (p *ParamRequirementType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type TerminatePlanType int64

const (
	TerminatePlanType_USELLM     TerminatePlanType = 1
	TerminatePlanType_USESETTING TerminatePlanType = 2
)

func (p TerminatePlanType) String() string {
	switch p {
	case TerminatePlanType_USELLM:
		return "USELLM"
	case TerminatePlanType_USESETTING:
		return "USESETTING"
	}
	return "<UNSET>"
}

func TerminatePlanTypeFromString(s string) (TerminatePlanType, error) {
	switch s {
	case "USELLM":
		return TerminatePlanType_USELLM, nil
	case "USESETTING":
		return TerminatePlanType_USESETTING, nil
	}
	return TerminatePlanType(0), fmt.Errorf("not a valid TerminatePlanType string")
}

func TerminatePlanTypePtr(v TerminatePlanType) *TerminatePlanType { return &v }
func (p *TerminatePlanType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = TerminatePlanType(result.Int64)
	return
}

func (p *TerminatePlanType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SupportBatch int64

const (
	// 1: Not supported
	SupportBatch_NOT_SUPPORT SupportBatch = 1
	// 2: Support
	SupportBatch_SUPPORT SupportBatch = 2
)

func (p SupportBatch) String() string {
	switch p {
	case SupportBatch_NOT_SUPPORT:
		return "NOT_SUPPORT"
	case SupportBatch_SUPPORT:
		return "SUPPORT"
	}
	return "<UNSET>"
}

func SupportBatchFromString(s string) (SupportBatch, error) {
	switch s {
	case "NOT_SUPPORT":
		return SupportBatch_NOT_SUPPORT, nil
	case "SUPPORT":
		return SupportBatch_SUPPORT, nil
	}
	return SupportBatch(0), fmt.Errorf("not a valid SupportBatch string")
}

func SupportBatchPtr(v SupportBatch) *SupportBatch { return &v }
func (p *SupportBatch) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SupportBatch(result.Int64)
	return
}

func (p *SupportBatch) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type PluginParamTypeFormat int64

const (
	PluginParamTypeFormat_ImageUrl PluginParamTypeFormat = 1
)

func (p PluginParamTypeFormat) String() string {
	switch p {
	case PluginParamTypeFormat_ImageUrl:
		return "ImageUrl"
	}
	return "<UNSET>"
}

func PluginParamTypeFormatFromString(s string) (PluginParamTypeFormat, error) {
	switch s {
	case "ImageUrl":
		return PluginParamTypeFormat_ImageUrl, nil
	}
	return PluginParamTypeFormat(0), fmt.Errorf("not a valid PluginParamTypeFormat string")
}

func PluginParamTypeFormatPtr(v PluginParamTypeFormat) *PluginParamTypeFormat { return &v }
func (p *PluginParamTypeFormat) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PluginParamTypeFormat(result.Int64)
	return
}

func (p *PluginParamTypeFormat) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Status, 1 Not Submitted 2 Submitted 3 Submitted 4 Obsolete
type WorkFlowDevStatus int64

const (
	// unsubmittable
	WorkFlowDevStatus_CanNotSubmit WorkFlowDevStatus = 1
	// submittable
	WorkFlowDevStatus_CanSubmit WorkFlowDevStatus = 2
	// Submitted
	WorkFlowDevStatus_HadSubmit WorkFlowDevStatus = 3
	// delete
	WorkFlowDevStatus_Deleted WorkFlowDevStatus = 4
)

func (p WorkFlowDevStatus) String() string {
	switch p {
	case WorkFlowDevStatus_CanNotSubmit:
		return "CanNotSubmit"
	case WorkFlowDevStatus_CanSubmit:
		return "CanSubmit"
	case WorkFlowDevStatus_HadSubmit:
		return "HadSubmit"
	case WorkFlowDevStatus_Deleted:
		return "Deleted"
	}
	return "<UNSET>"
}

func WorkFlowDevStatusFromString(s string) (WorkFlowDevStatus, error) {
	switch s {
	case "CanNotSubmit":
		return WorkFlowDevStatus_CanNotSubmit, nil
	case "CanSubmit":
		return WorkFlowDevStatus_CanSubmit, nil
	case "HadSubmit":
		return WorkFlowDevStatus_HadSubmit, nil
	case "Deleted":
		return WorkFlowDevStatus_Deleted, nil
	}
	return WorkFlowDevStatus(0), fmt.Errorf("not a valid WorkFlowDevStatus string")
}

func WorkFlowDevStatusPtr(v WorkFlowDevStatus) *WorkFlowDevStatus { return &v }
func (p *WorkFlowDevStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkFlowDevStatus(result.Int64)
	return
}

func (p *WorkFlowDevStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Status, 1 Unpublishable 2 Publishable 3 Published 4 Deleted 5 Removed
type WorkFlowStatus int64

const (
	// unpublishable
	WorkFlowStatus_CanNotPublish WorkFlowStatus = 1
	// publishable
	WorkFlowStatus_CanPublish WorkFlowStatus = 2
	// Published
	WorkFlowStatus_HadPublished WorkFlowStatus = 3
	// delete
	WorkFlowStatus_Deleted WorkFlowStatus = 4
	// offline
	WorkFlowStatus_Unlisted WorkFlowStatus = 5
)

func (p WorkFlowStatus) String() string {
	switch p {
	case WorkFlowStatus_CanNotPublish:
		return "CanNotPublish"
	case WorkFlowStatus_CanPublish:
		return "CanPublish"
	case WorkFlowStatus_HadPublished:
		return "HadPublished"
	case WorkFlowStatus_Deleted:
		return "Deleted"
	case WorkFlowStatus_Unlisted:
		return "Unlisted"
	}
	return "<UNSET>"
}

func WorkFlowStatusFromString(s string) (WorkFlowStatus, error) {
	switch s {
	case "CanNotPublish":
		return WorkFlowStatus_CanNotPublish, nil
	case "CanPublish":
		return WorkFlowStatus_CanPublish, nil
	case "HadPublished":
		return WorkFlowStatus_HadPublished, nil
	case "Deleted":
		return WorkFlowStatus_Deleted, nil
	case "Unlisted":
		return WorkFlowStatus_Unlisted, nil
	}
	return WorkFlowStatus(0), fmt.Errorf("not a valid WorkFlowStatus string")
}

func WorkFlowStatusPtr(v WorkFlowStatus) *WorkFlowStatus { return &v }
func (p *WorkFlowStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkFlowStatus(result.Int64)
	return
}

func (p *WorkFlowStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type VCSCanvasType int64

const (
	VCSCanvasType_Draft   VCSCanvasType = 1
	VCSCanvasType_Submit  VCSCanvasType = 2
	VCSCanvasType_Publish VCSCanvasType = 3
)

func (p VCSCanvasType) String() string {
	switch p {
	case VCSCanvasType_Draft:
		return "Draft"
	case VCSCanvasType_Submit:
		return "Submit"
	case VCSCanvasType_Publish:
		return "Publish"
	}
	return "<UNSET>"
}

func VCSCanvasTypeFromString(s string) (VCSCanvasType, error) {
	switch s {
	case "Draft":
		return VCSCanvasType_Draft, nil
	case "Submit":
		return VCSCanvasType_Submit, nil
	case "Publish":
		return VCSCanvasType_Publish, nil
	}
	return VCSCanvasType(0), fmt.Errorf("not a valid VCSCanvasType string")
}

func VCSCanvasTypePtr(v VCSCanvasType) *VCSCanvasType { return &v }
func (p *VCSCanvasType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = VCSCanvasType(result.Int64)
	return
}

func (p *VCSCanvasType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type OperateType int64

const (
	OperateType_DraftOperate            OperateType = 0
	OperateType_SubmitOperate           OperateType = 1
	OperateType_PublishOperate          OperateType = 2
	OperateType_PubPPEOperate           OperateType = 3
	OperateType_SubmitPublishPPEOperate OperateType = 4
)

func (p OperateType) String() string {
	switch p {
	case OperateType_DraftOperate:
		return "DraftOperate"
	case OperateType_SubmitOperate:
		return "SubmitOperate"
	case OperateType_PublishOperate:
		return "PublishOperate"
	case OperateType_PubPPEOperate:
		return "PubPPEOperate"
	case OperateType_SubmitPublishPPEOperate:
		return "SubmitPublishPPEOperate"
	}
	return "<UNSET>"
}

func OperateTypeFromString(s string) (OperateType, error) {
	switch s {
	case "DraftOperate":
		return OperateType_DraftOperate, nil
	case "SubmitOperate":
		return OperateType_SubmitOperate, nil
	case "PublishOperate":
		return OperateType_PublishOperate, nil
	case "PubPPEOperate":
		return OperateType_PubPPEOperate, nil
	case "SubmitPublishPPEOperate":
		return OperateType_SubmitPublishPPEOperate, nil
	}
	return OperateType(0), fmt.Errorf("not a valid OperateType string")
}

func OperateTypePtr(v OperateType) *OperateType { return &v }
func (p *OperateType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = OperateType(result.Int64)
	return
}

func (p *OperateType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type DeleteAction int64

const (
	// Blockwise Unbinding
	DeleteAction_BlockwiseUnbind DeleteAction = 1
	// Blockwise removal
	DeleteAction_BlockwiseDelete DeleteAction = 2
)

func (p DeleteAction) String() string {
	switch p {
	case DeleteAction_BlockwiseUnbind:
		return "BlockwiseUnbind"
	case DeleteAction_BlockwiseDelete:
		return "BlockwiseDelete"
	}
	return "<UNSET>"
}

func DeleteActionFromString(s string) (DeleteAction, error) {
	switch s {
	case "BlockwiseUnbind":
		return DeleteAction_BlockwiseUnbind, nil
	case "BlockwiseDelete":
		return DeleteAction_BlockwiseDelete, nil
	}
	return DeleteAction(0), fmt.Errorf("not a valid DeleteAction string")
}

func DeleteActionPtr(v DeleteAction) *DeleteAction { return &v }
func (p *DeleteAction) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = DeleteAction(result.Int64)
	return
}

func (p *DeleteAction) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type DeleteStatus int64

const (
	DeleteStatus_SUCCESS DeleteStatus = 0
	DeleteStatus_FAIL    DeleteStatus = 1
)

func (p DeleteStatus) String() string {
	switch p {
	case DeleteStatus_SUCCESS:
		return "SUCCESS"
	case DeleteStatus_FAIL:
		return "FAIL"
	}
	return "<UNSET>"
}

func DeleteStatusFromString(s string) (DeleteStatus, error) {
	switch s {
	case "SUCCESS":
		return DeleteStatus_SUCCESS, nil
	case "FAIL":
		return DeleteStatus_FAIL, nil
	}
	return DeleteStatus(0), fmt.Errorf("not a valid DeleteStatus string")
}

func DeleteStatusPtr(v DeleteStatus) *DeleteStatus { return &v }
func (p *DeleteStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = DeleteStatus(result.Int64)
	return
}

func (p *DeleteStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type DeleteType int64

const (
	// Can be deleted: No workflow product/product removed from the shelves/first time on the shelves and the review failed
	DeleteType_CanDelete DeleteType = 0
	// Review failed after deletion: The workflow product is on the shelves for the first time and is under review.
	DeleteType_RejectProductDraft DeleteType = 1
	// Products that need to be removed from the shelves first: workflow products have been put on the shelves.
	DeleteType_UnListProduct DeleteType = 2
)

func (p DeleteType) String() string {
	switch p {
	case DeleteType_CanDelete:
		return "CanDelete"
	case DeleteType_RejectProductDraft:
		return "RejectProductDraft"
	case DeleteType_UnListProduct:
		return "UnListProduct"
	}
	return "<UNSET>"
}

func DeleteTypeFromString(s string) (DeleteType, error) {
	switch s {
	case "CanDelete":
		return DeleteType_CanDelete, nil
	case "RejectProductDraft":
		return DeleteType_RejectProductDraft, nil
	case "UnListProduct":
		return DeleteType_UnListProduct, nil
	}
	return DeleteType(0), fmt.Errorf("not a valid DeleteType string")
}

func DeleteTypePtr(v DeleteType) *DeleteType { return &v }
func (p *DeleteType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = DeleteType(result.Int64)
	return
}

func (p *DeleteType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type OrderBy int64

const (
	OrderBy_CreateTime  OrderBy = 0
	OrderBy_UpdateTime  OrderBy = 1
	OrderBy_PublishTime OrderBy = 2
	OrderBy_Hot         OrderBy = 3
	OrderBy_Id          OrderBy = 4
)

func (p OrderBy) String() string {
	switch p {
	case OrderBy_CreateTime:
		return "CreateTime"
	case OrderBy_UpdateTime:
		return "UpdateTime"
	case OrderBy_PublishTime:
		return "PublishTime"
	case OrderBy_Hot:
		return "Hot"
	case OrderBy_Id:
		return "Id"
	}
	return "<UNSET>"
}

func OrderByFromString(s string) (OrderBy, error) {
	switch s {
	case "CreateTime":
		return OrderBy_CreateTime, nil
	case "UpdateTime":
		return OrderBy_UpdateTime, nil
	case "PublishTime":
		return OrderBy_PublishTime, nil
	case "Hot":
		return OrderBy_Hot, nil
	case "Id":
		return OrderBy_Id, nil
	}
	return OrderBy(0), fmt.Errorf("not a valid OrderBy string")
}

func OrderByPtr(v OrderBy) *OrderBy { return &v }
func (p *OrderBy) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = OrderBy(result.Int64)
	return
}

func (p *OrderBy) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type WorkFlowListStatus int64

const (
	WorkFlowListStatus_UnPublished  WorkFlowListStatus = 1
	WorkFlowListStatus_HadPublished WorkFlowListStatus = 2
)

func (p WorkFlowListStatus) String() string {
	switch p {
	case WorkFlowListStatus_UnPublished:
		return "UnPublished"
	case WorkFlowListStatus_HadPublished:
		return "HadPublished"
	}
	return "<UNSET>"
}

func WorkFlowListStatusFromString(s string) (WorkFlowListStatus, error) {
	switch s {
	case "UnPublished":
		return WorkFlowListStatus_UnPublished, nil
	case "HadPublished":
		return WorkFlowListStatus_HadPublished, nil
	}
	return WorkFlowListStatus(0), fmt.Errorf("not a valid WorkFlowListStatus string")
}

func WorkFlowListStatusPtr(v WorkFlowListStatus) *WorkFlowListStatus { return &v }
func (p *WorkFlowListStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkFlowListStatus(result.Int64)
	return
}

func (p *WorkFlowListStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type CheckType int64

const (
	CheckType_WebSDKPublish    CheckType = 1
	CheckType_SocialPublish    CheckType = 2
	CheckType_BotAgent         CheckType = 3
	CheckType_BotSocialPublish CheckType = 4
	CheckType_BotWebSDKPublish CheckType = 5
)

func (p CheckType) String() string {
	switch p {
	case CheckType_WebSDKPublish:
		return "WebSDKPublish"
	case CheckType_SocialPublish:
		return "SocialPublish"
	case CheckType_BotAgent:
		return "BotAgent"
	case CheckType_BotSocialPublish:
		return "BotSocialPublish"
	case CheckType_BotWebSDKPublish:
		return "BotWebSDKPublish"
	}
	return "<UNSET>"
}

func CheckTypeFromString(s string) (CheckType, error) {
	switch s {
	case "WebSDKPublish":
		return CheckType_WebSDKPublish, nil
	case "SocialPublish":
		return CheckType_SocialPublish, nil
	case "BotAgent":
		return CheckType_BotAgent, nil
	case "BotSocialPublish":
		return CheckType_BotSocialPublish, nil
	case "BotWebSDKPublish":
		return CheckType_BotWebSDKPublish, nil
	}
	return CheckType(0), fmt.Errorf("not a valid CheckType string")
}

func CheckTypePtr(v CheckType) *CheckType { return &v }
func (p *CheckType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = CheckType(result.Int64)
	return
}

func (p *CheckType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type BindBizType int64

const (
	BindBizType_Agent BindBizType = 1
	BindBizType_Scene BindBizType = 2
	// Douyin doppelganger
	BindBizType_DouYinBot BindBizType = 3
)

func (p BindBizType) String() string {
	switch p {
	case BindBizType_Agent:
		return "Agent"
	case BindBizType_Scene:
		return "Scene"
	case BindBizType_DouYinBot:
		return "DouYinBot"
	}
	return "<UNSET>"
}

func BindBizTypeFromString(s string) (BindBizType, error) {
	switch s {
	case "Agent":
		return BindBizType_Agent, nil
	case "Scene":
		return BindBizType_Scene, nil
	case "DouYinBot":
		return BindBizType_DouYinBot, nil
	}
	return BindBizType(0), fmt.Errorf("not a valid BindBizType string")
}

func BindBizTypePtr(v BindBizType) *BindBizType { return &v }
func (p *BindBizType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = BindBizType(result.Int64)
	return
}

func (p *BindBizType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type WorkflowExeStatus int64

const (
	WorkflowExeStatus_Running WorkflowExeStatus = 1
	WorkflowExeStatus_Success WorkflowExeStatus = 2
	WorkflowExeStatus_Fail    WorkflowExeStatus = 3
	WorkflowExeStatus_Cancel  WorkflowExeStatus = 4
)

func (p WorkflowExeStatus) String() string {
	switch p {
	case WorkflowExeStatus_Running:
		return "Running"
	case WorkflowExeStatus_Success:
		return "Success"
	case WorkflowExeStatus_Fail:
		return "Fail"
	case WorkflowExeStatus_Cancel:
		return "Cancel"
	}
	return "<UNSET>"
}

func WorkflowExeStatusFromString(s string) (WorkflowExeStatus, error) {
	switch s {
	case "Running":
		return WorkflowExeStatus_Running, nil
	case "Success":
		return WorkflowExeStatus_Success, nil
	case "Fail":
		return WorkflowExeStatus_Fail, nil
	case "Cancel":
		return WorkflowExeStatus_Cancel, nil
	}
	return WorkflowExeStatus(0), fmt.Errorf("not a valid WorkflowExeStatus string")
}

func WorkflowExeStatusPtr(v WorkflowExeStatus) *WorkflowExeStatus { return &v }
func (p *WorkflowExeStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkflowExeStatus(result.Int64)
	return
}

func (p *WorkflowExeStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type WorkflowExeHistoryStatus int64

const (
	WorkflowExeHistoryStatus_NoHistory  WorkflowExeHistoryStatus = 1
	WorkflowExeHistoryStatus_HasHistory WorkflowExeHistoryStatus = 2
)

func (p WorkflowExeHistoryStatus) String() string {
	switch p {
	case WorkflowExeHistoryStatus_NoHistory:
		return "NoHistory"
	case WorkflowExeHistoryStatus_HasHistory:
		return "HasHistory"
	}
	return "<UNSET>"
}

func WorkflowExeHistoryStatusFromString(s string) (WorkflowExeHistoryStatus, error) {
	switch s {
	case "NoHistory":
		return WorkflowExeHistoryStatus_NoHistory, nil
	case "HasHistory":
		return WorkflowExeHistoryStatus_HasHistory, nil
	}
	return WorkflowExeHistoryStatus(0), fmt.Errorf("not a valid WorkflowExeHistoryStatus string")
}

func WorkflowExeHistoryStatusPtr(v WorkflowExeHistoryStatus) *WorkflowExeHistoryStatus { return &v }
func (p *WorkflowExeHistoryStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkflowExeHistoryStatus(result.Int64)
	return
}

func (p *WorkflowExeHistoryStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type NodeHistoryScene int64

const (
	NodeHistoryScene_Default      NodeHistoryScene = 0
	NodeHistoryScene_TestRunInput NodeHistoryScene = 1
)

func (p NodeHistoryScene) String() string {
	switch p {
	case NodeHistoryScene_Default:
		return "Default"
	case NodeHistoryScene_TestRunInput:
		return "TestRunInput"
	}
	return "<UNSET>"
}

func NodeHistorySceneFromString(s string) (NodeHistoryScene, error) {
	switch s {
	case "Default":
		return NodeHistoryScene_Default, nil
	case "TestRunInput":
		return NodeHistoryScene_TestRunInput, nil
	}
	return NodeHistoryScene(0), fmt.Errorf("not a valid NodeHistoryScene string")
}

func NodeHistoryScenePtr(v NodeHistoryScene) *NodeHistoryScene { return &v }
func (p *NodeHistoryScene) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = NodeHistoryScene(result.Int64)
	return
}

func (p *NodeHistoryScene) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type NodeExeStatus int64

const (
	NodeExeStatus_Waiting NodeExeStatus = 1
	NodeExeStatus_Running NodeExeStatus = 2
	NodeExeStatus_Success NodeExeStatus = 3
	NodeExeStatus_Fail    NodeExeStatus = 4
)

func (p NodeExeStatus) String() string {
	switch p {
	case NodeExeStatus_Waiting:
		return "Waiting"
	case NodeExeStatus_Running:
		return "Running"
	case NodeExeStatus_Success:
		return "Success"
	case NodeExeStatus_Fail:
		return "Fail"
	}
	return "<UNSET>"
}

func NodeExeStatusFromString(s string) (NodeExeStatus, error) {
	switch s {
	case "Waiting":
		return NodeExeStatus_Waiting, nil
	case "Running":
		return NodeExeStatus_Running, nil
	case "Success":
		return NodeExeStatus_Success, nil
	case "Fail":
		return NodeExeStatus_Fail, nil
	}
	return NodeExeStatus(0), fmt.Errorf("not a valid NodeExeStatus string")
}

func NodeExeStatusPtr(v NodeExeStatus) *NodeExeStatus { return &v }
func (p *NodeExeStatus) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = NodeExeStatus(result.Int64)
	return
}

func (p *NodeExeStatus) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type EventType int64

const (
	EventType_LocalPlugin         EventType = 1
	EventType_Question            EventType = 2
	EventType_RequireInfos        EventType = 3
	EventType_SceneChat           EventType = 4
	EventType_InputNode           EventType = 5
	EventType_WorkflowLocalPlugin EventType = 6
	EventType_WorkflowOauthPlugin EventType = 7
)

func (p EventType) String() string {
	switch p {
	case EventType_LocalPlugin:
		return "LocalPlugin"
	case EventType_Question:
		return "Question"
	case EventType_RequireInfos:
		return "RequireInfos"
	case EventType_SceneChat:
		return "SceneChat"
	case EventType_InputNode:
		return "InputNode"
	case EventType_WorkflowLocalPlugin:
		return "WorkflowLocalPlugin"
	case EventType_WorkflowOauthPlugin:
		return "WorkflowOauthPlugin"
	}
	return "<UNSET>"
}

func EventTypeFromString(s string) (EventType, error) {
	switch s {
	case "LocalPlugin":
		return EventType_LocalPlugin, nil
	case "Question":
		return EventType_Question, nil
	case "RequireInfos":
		return EventType_RequireInfos, nil
	case "SceneChat":
		return EventType_SceneChat, nil
	case "InputNode":
		return EventType_InputNode, nil
	case "WorkflowLocalPlugin":
		return EventType_WorkflowLocalPlugin, nil
	case "WorkflowOauthPlugin":
		return EventType_WorkflowOauthPlugin, nil
	}
	return EventType(0), fmt.Errorf("not a valid EventType string")
}

func EventTypePtr(v EventType) *EventType { return &v }
func (p *EventType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = EventType(result.Int64)
	return
}

func (p *EventType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ValidateErrorType int64

const (
	ValidateErrorType_BotValidateNodeErr   ValidateErrorType = 1
	ValidateErrorType_BotValidatePathErr   ValidateErrorType = 2
	ValidateErrorType_BotConcurrentPathErr ValidateErrorType = 3
)

func (p ValidateErrorType) String() string {
	switch p {
	case ValidateErrorType_BotValidateNodeErr:
		return "BotValidateNodeErr"
	case ValidateErrorType_BotValidatePathErr:
		return "BotValidatePathErr"
	case ValidateErrorType_BotConcurrentPathErr:
		return "BotConcurrentPathErr"
	}
	return "<UNSET>"
}

func ValidateErrorTypeFromString(s string) (ValidateErrorType, error) {
	switch s {
	case "BotValidateNodeErr":
		return ValidateErrorType_BotValidateNodeErr, nil
	case "BotValidatePathErr":
		return ValidateErrorType_BotValidatePathErr, nil
	case "BotConcurrentPathErr":
		return ValidateErrorType_BotConcurrentPathErr, nil
	}
	return ValidateErrorType(0), fmt.Errorf("not a valid ValidateErrorType string")
}

func ValidateErrorTypePtr(v ValidateErrorType) *ValidateErrorType { return &v }
func (p *ValidateErrorType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ValidateErrorType(result.Int64)
	return
}

func (p *ValidateErrorType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type PluginType int64

const (
	PluginType_PLUGIN    PluginType = 1
	PluginType_APP       PluginType = 2
	PluginType_FUNC      PluginType = 3
	PluginType_WORKFLOW  PluginType = 4
	PluginType_IMAGEFLOW PluginType = 5
	PluginType_LOCAL     PluginType = 6
)

func (p PluginType) String() string {
	switch p {
	case PluginType_PLUGIN:
		return "PLUGIN"
	case PluginType_APP:
		return "APP"
	case PluginType_FUNC:
		return "FUNC"
	case PluginType_WORKFLOW:
		return "WORKFLOW"
	case PluginType_IMAGEFLOW:
		return "IMAGEFLOW"
	case PluginType_LOCAL:
		return "LOCAL"
	}
	return "<UNSET>"
}

func PluginTypeFromString(s string) (PluginType, error) {
	switch s {
	case "PLUGIN":
		return PluginType_PLUGIN, nil
	case "APP":
		return PluginType_APP, nil
	case "FUNC":
		return PluginType_FUNC, nil
	case "WORKFLOW":
		return PluginType_WORKFLOW, nil
	case "IMAGEFLOW":
		return PluginType_IMAGEFLOW, nil
	case "LOCAL":
		return PluginType_LOCAL, nil
	}
	return PluginType(0), fmt.Errorf("not a valid PluginType string")
}

func PluginTypePtr(v PluginType) *PluginType { return &v }
func (p *PluginType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PluginType(result.Int64)
	return
}

func (p *PluginType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ParameterType int64

const (
	ParameterType_String  ParameterType = 1
	ParameterType_Integer ParameterType = 2
	ParameterType_Number  ParameterType = 3
	ParameterType_Object  ParameterType = 4
	ParameterType_Array   ParameterType = 5
	ParameterType_Bool    ParameterType = 6
)

func (p ParameterType) String() string {
	switch p {
	case ParameterType_String:
		return "String"
	case ParameterType_Integer:
		return "Integer"
	case ParameterType_Number:
		return "Number"
	case ParameterType_Object:
		return "Object"
	case ParameterType_Array:
		return "Array"
	case ParameterType_Bool:
		return "Bool"
	}
	return "<UNSET>"
}

func ParameterTypeFromString(s string) (ParameterType, error) {
	switch s {
	case "String":
		return ParameterType_String, nil
	case "Integer":
		return ParameterType_Integer, nil
	case "Number":
		return ParameterType_Number, nil
	case "Object":
		return ParameterType_Object, nil
	case "Array":
		return ParameterType_Array, nil
	case "Bool":
		return ParameterType_Bool, nil
	}
	return ParameterType(0), fmt.Errorf("not a valid ParameterType string")
}

func ParameterTypePtr(v ParameterType) *ParameterType { return &v }
func (p *ParameterType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ParameterType(result.Int64)
	return
}

func (p *ParameterType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ParameterLocation int64

const (
	ParameterLocation_Path   ParameterLocation = 1
	ParameterLocation_Query  ParameterLocation = 2
	ParameterLocation_Body   ParameterLocation = 3
	ParameterLocation_Header ParameterLocation = 4
)

func (p ParameterLocation) String() string {
	switch p {
	case ParameterLocation_Path:
		return "Path"
	case ParameterLocation_Query:
		return "Query"
	case ParameterLocation_Body:
		return "Body"
	case ParameterLocation_Header:
		return "Header"
	}
	return "<UNSET>"
}

func ParameterLocationFromString(s string) (ParameterLocation, error) {
	switch s {
	case "Path":
		return ParameterLocation_Path, nil
	case "Query":
		return ParameterLocation_Query, nil
	case "Body":
		return ParameterLocation_Body, nil
	case "Header":
		return ParameterLocation_Header, nil
	}
	return ParameterLocation(0), fmt.Errorf("not a valid ParameterLocation string")
}

func ParameterLocationPtr(v ParameterLocation) *ParameterLocation { return &v }
func (p *ParameterLocation) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = ParameterLocation(result.Int64)
	return
}

func (p *ParameterLocation) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Default imported parameter settings source
type DefaultParamSource int64

const (
	// default user input
	DefaultParamSource_Input DefaultParamSource = 0
	// reference variable
	DefaultParamSource_Variable DefaultParamSource = 1
)

func (p DefaultParamSource) String() string {
	switch p {
	case DefaultParamSource_Input:
		return "Input"
	case DefaultParamSource_Variable:
		return "Variable"
	}
	return "<UNSET>"
}

func DefaultParamSourceFromString(s string) (DefaultParamSource, error) {
	switch s {
	case "Input":
		return DefaultParamSource_Input, nil
	case "Variable":
		return DefaultParamSource_Variable, nil
	}
	return DefaultParamSource(0), fmt.Errorf("not a valid DefaultParamSource string")
}

func DefaultParamSourcePtr(v DefaultParamSource) *DefaultParamSource { return &v }
func (p *DefaultParamSource) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = DefaultParamSource(result.Int64)
	return
}

func (p *DefaultParamSource) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// Subdivision types for File type parameters
type AssistParameterType int64

const (
	AssistParameterType_DEFAULT AssistParameterType = 1
	AssistParameterType_IMAGE   AssistParameterType = 2
	AssistParameterType_DOC     AssistParameterType = 3
	AssistParameterType_CODE    AssistParameterType = 4
	AssistParameterType_PPT     AssistParameterType = 5
	AssistParameterType_TXT     AssistParameterType = 6
	AssistParameterType_EXCEL   AssistParameterType = 7
	AssistParameterType_AUDIO   AssistParameterType = 8
	AssistParameterType_ZIP     AssistParameterType = 9
	AssistParameterType_VIDEO   AssistParameterType = 10
	AssistParameterType_SVG     AssistParameterType = 11
	AssistParameterType_Voice   AssistParameterType = 12
)

func (p AssistParameterType) String() string {
	switch p {
	case AssistParameterType_DEFAULT:
		return "DEFAULT"
	case AssistParameterType_IMAGE:
		return "IMAGE"
	case AssistParameterType_DOC:
		return "DOC"
	case AssistParameterType_CODE:
		return "CODE"
	case AssistParameterType_PPT:
		return "PPT"
	case AssistParameterType_TXT:
		return "TXT"
	case AssistParameterType_EXCEL:
		return "EXCEL"
	case AssistParameterType_AUDIO:
		return "AUDIO"
	case AssistParameterType_ZIP:
		return "ZIP"
	case AssistParameterType_VIDEO:
		return "VIDEO"
	case AssistParameterType_SVG:
		return "SVG"
	case AssistParameterType_Voice:
		return "Voice"
	}
	return "<UNSET>"
}

func AssistParameterTypeFromString(s string) (AssistParameterType, error) {
	switch s {
	case "DEFAULT":
		return AssistParameterType_DEFAULT, nil
	case "IMAGE":
		return AssistParameterType_IMAGE, nil
	case "DOC":
		return AssistParameterType_DOC, nil
	case "CODE":
		return AssistParameterType_CODE, nil
	case "PPT":
		return AssistParameterType_PPT, nil
	case "TXT":
		return AssistParameterType_TXT, nil
	case "EXCEL":
		return AssistParameterType_EXCEL, nil
	case "AUDIO":
		return AssistParameterType_AUDIO, nil
	case "ZIP":
		return AssistParameterType_ZIP, nil
	case "VIDEO":
		return AssistParameterType_VIDEO, nil
	case "SVG":
		return AssistParameterType_SVG, nil
	case "Voice":
		return AssistParameterType_Voice, nil
	}
	return AssistParameterType(0), fmt.Errorf("not a valid AssistParameterType string")
}

func AssistParameterTypePtr(v AssistParameterType) *AssistParameterType { return &v }
func (p *AssistParameterType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = AssistParameterType(result.Int64)
	return
}

func (p *AssistParameterType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type CreateMethod int64

const (
	CreateMethod_ManualCreate CreateMethod = 1
	CreateMethod_NodeCreate   CreateMethod = 2
)

func (p CreateMethod) String() string {
	switch p {
	case CreateMethod_ManualCreate:
		return "ManualCreate"
	case CreateMethod_NodeCreate:
		return "NodeCreate"
	}
	return "<UNSET>"
}

func CreateMethodFromString(s string) (CreateMethod, error) {
	switch s {
	case "ManualCreate":
		return CreateMethod_ManualCreate, nil
	case "NodeCreate":
		return CreateMethod_NodeCreate, nil
	}
	return CreateMethod(0), fmt.Errorf("not a valid CreateMethod string")
}

func CreateMethodPtr(v CreateMethod) *CreateMethod { return &v }
func (p *CreateMethod) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = CreateMethod(result.Int64)
	return
}

func (p *CreateMethod) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type CreateEnv int64

const (
	CreateEnv_Draft   CreateEnv = 1
	CreateEnv_Release CreateEnv = 2
)

func (p CreateEnv) String() string {
	switch p {
	case CreateEnv_Draft:
		return "Draft"
	case CreateEnv_Release:
		return "Release"
	}
	return "<UNSET>"
}

func CreateEnvFromString(s string) (CreateEnv, error) {
	switch s {
	case "Draft":
		return CreateEnv_Draft, nil
	case "Release":
		return CreateEnv_Release, nil
	}
	return CreateEnv(0), fmt.Errorf("not a valid CreateEnv string")
}

func CreateEnvPtr(v CreateEnv) *CreateEnv { return &v }
func (p *CreateEnv) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = CreateEnv(result.Int64)
	return
}

func (p *CreateEnv) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SuggestReplyInfoMode int64

const (
	// close
	SuggestReplyInfoMode_Disable SuggestReplyInfoMode = 0
	// system
	SuggestReplyInfoMode_System SuggestReplyInfoMode = 1
	// custom
	SuggestReplyInfoMode_Custom SuggestReplyInfoMode = 2
)

func (p SuggestReplyInfoMode) String() string {
	switch p {
	case SuggestReplyInfoMode_Disable:
		return "Disable"
	case SuggestReplyInfoMode_System:
		return "System"
	case SuggestReplyInfoMode_Custom:
		return "Custom"
	}
	return "<UNSET>"
}

func SuggestReplyInfoModeFromString(s string) (SuggestReplyInfoMode, error) {
	switch s {
	case "Disable":
		return SuggestReplyInfoMode_Disable, nil
	case "System":
		return SuggestReplyInfoMode_System, nil
	case "Custom":
		return SuggestReplyInfoMode_Custom, nil
	}
	return SuggestReplyInfoMode(0), fmt.Errorf("not a valid SuggestReplyInfoMode string")
}

func SuggestReplyInfoModePtr(v SuggestReplyInfoMode) *SuggestReplyInfoMode { return &v }
func (p *SuggestReplyInfoMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SuggestReplyInfoMode(result.Int64)
	return
}

func (p *SuggestReplyInfoMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type Caller int64

const (
	Caller_Canvas    Caller = 1
	Caller_UIBuilder Caller = 2
)

func (p Caller) String() string {
	switch p {
	case Caller_Canvas:
		return "Canvas"
	case Caller_UIBuilder:
		return "UIBuilder"
	}
	return "<UNSET>"
}

func CallerFromString(s string) (Caller, error) {
	switch s {
	case "Canvas":
		return Caller_Canvas, nil
	case "UIBuilder":
		return Caller_UIBuilder, nil
	}
	return Caller(0), fmt.Errorf("not a valid Caller string")
}

func CallerPtr(v Caller) *Caller { return &v }
func (p *Caller) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = Caller(result.Int64)
	return
}

func (p *Caller) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type InputMode int64

const (
	// Type input
	InputMode_Text InputMode = 1
	// Voice input
	InputMode_Audio InputMode = 2
)

func (p InputMode) String() string {
	switch p {
	case InputMode_Text:
		return "Text"
	case InputMode_Audio:
		return "Audio"
	}
	return "<UNSET>"
}

func InputModeFromString(s string) (InputMode, error) {
	switch s {
	case "Text":
		return InputMode_Text, nil
	case "Audio":
		return InputMode_Audio, nil
	}
	return InputMode(0), fmt.Errorf("not a valid InputMode string")
}

func InputModePtr(v InputMode) *InputMode { return &v }
func (p *InputMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = InputMode(result.Int64)
	return
}

func (p *InputMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type SendVoiceMode int64

const (
	// text message
	SendVoiceMode_Text SendVoiceMode = 1
	// Send as voice
	SendVoiceMode_Audio SendVoiceMode = 2
)

func (p SendVoiceMode) String() string {
	switch p {
	case SendVoiceMode_Text:
		return "Text"
	case SendVoiceMode_Audio:
		return "Audio"
	}
	return "<UNSET>"
}

func SendVoiceModeFromString(s string) (SendVoiceMode, error) {
	switch s {
	case "Text":
		return SendVoiceMode_Text, nil
	case "Audio":
		return SendVoiceMode_Audio, nil
	}
	return SendVoiceMode(0), fmt.Errorf("not a valid SendVoiceMode string")
}

func SendVoiceModePtr(v SendVoiceMode) *SendVoiceMode { return &v }
func (p *SendVoiceMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = SendVoiceMode(result.Int64)
	return
}

func (p *SendVoiceMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type NodePanelSearchType int64

const (
	NodePanelSearchType_All              NodePanelSearchType = 0
	NodePanelSearchType_ResourceWorkflow NodePanelSearchType = 1
	NodePanelSearchType_ProjectWorkflow  NodePanelSearchType = 2
	NodePanelSearchType_FavoritePlugin   NodePanelSearchType = 3
	NodePanelSearchType_ResourcePlugin   NodePanelSearchType = 4
	NodePanelSearchType_ProjectPlugin    NodePanelSearchType = 5
	NodePanelSearchType_StorePlugin      NodePanelSearchType = 6
)

func (p NodePanelSearchType) String() string {
	switch p {
	case NodePanelSearchType_All:
		return "All"
	case NodePanelSearchType_ResourceWorkflow:
		return "ResourceWorkflow"
	case NodePanelSearchType_ProjectWorkflow:
		return "ProjectWorkflow"
	case NodePanelSearchType_FavoritePlugin:
		return "FavoritePlugin"
	case NodePanelSearchType_ResourcePlugin:
		return "ResourcePlugin"
	case NodePanelSearchType_ProjectPlugin:
		return "ProjectPlugin"
	case NodePanelSearchType_StorePlugin:
		return "StorePlugin"
	}
	return "<UNSET>"
}

func NodePanelSearchTypeFromString(s string) (NodePanelSearchType, error) {
	switch s {
	case "All":
		return NodePanelSearchType_All, nil
	case "ResourceWorkflow":
		return NodePanelSearchType_ResourceWorkflow, nil
	case "ProjectWorkflow":
		return NodePanelSearchType_ProjectWorkflow, nil
	case "FavoritePlugin":
		return NodePanelSearchType_FavoritePlugin, nil
	case "ResourcePlugin":
		return NodePanelSearchType_ResourcePlugin, nil
	case "ProjectPlugin":
		return NodePanelSearchType_ProjectPlugin, nil
	case "StorePlugin":
		return NodePanelSearchType_StorePlugin, nil
	}
	return NodePanelSearchType(0), fmt.Errorf("not a valid NodePanelSearchType string")
}

func NodePanelSearchTypePtr(v NodePanelSearchType) *NodePanelSearchType { return &v }
func (p *NodePanelSearchType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = NodePanelSearchType(result.Int64)
	return
}

func (p *NodePanelSearchType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type OrderByType int64

const (
	OrderByType_Asc  OrderByType = 1
	OrderByType_Desc OrderByType = 2
)

func (p OrderByType) String() string {
	switch p {
	case OrderByType_Asc:
		return "Asc"
	case OrderByType_Desc:
		return "Desc"
	}
	return "<UNSET>"
}

func OrderByTypeFromString(s string) (OrderByType, error) {
	switch s {
	case "Asc":
		return OrderByType_Asc, nil
	case "Desc":
		return OrderByType_Desc, nil
	}
	return OrderByType(0), fmt.Errorf("not a valid OrderByType string")
}

func OrderByTypePtr(v OrderByType) *OrderByType { return &v }
func (p *OrderByType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = OrderByType(result.Int64)
	return
}

func (p *OrderByType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type PermissionType int64

const (
	//Can't view details
	PermissionType_NoDetail PermissionType = 1
	//You can check the details.
	PermissionType_Detail PermissionType = 2
	//Can be viewed and operated
	PermissionType_Operate PermissionType = 3
)

func (p PermissionType) String() string {
	switch p {
	case PermissionType_NoDetail:
		return "NoDetail"
	case PermissionType_Detail:
		return "Detail"
	case PermissionType_Operate:
		return "Operate"
	}
	return "<UNSET>"
}

func PermissionTypeFromString(s string) (PermissionType, error) {
	switch s {
	case "NoDetail":
		return PermissionType_NoDetail, nil
	case "Detail":
		return PermissionType_Detail, nil
	case "Operate":
		return PermissionType_Operate, nil
	}
	return PermissionType(0), fmt.Errorf("not a valid PermissionType string")
}

func PermissionTypePtr(v PermissionType) *PermissionType { return &v }
func (p *PermissionType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = PermissionType(result.Int64)
	return
}

func (p *PermissionType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

// This enumeration needs to be aligned with the plugin's PluginInterruptType
type InterruptType int64

const (
	InterruptType_LocalPlugin  InterruptType = 1
	InterruptType_Question     InterruptType = 2
	InterruptType_RequireInfos InterruptType = 3
	InterruptType_SceneChat    InterruptType = 4
	InterruptType_Input        InterruptType = 5
	InterruptType_OauthPlugin  InterruptType = 7
)

func (p InterruptType) String() string {
	switch p {
	case InterruptType_LocalPlugin:
		return "LocalPlugin"
	case InterruptType_Question:
		return "Question"
	case InterruptType_RequireInfos:
		return "RequireInfos"
	case InterruptType_SceneChat:
		return "SceneChat"
	case InterruptType_Input:
		return "Input"
	case InterruptType_OauthPlugin:
		return "OauthPlugin"
	}
	return "<UNSET>"
}

func InterruptTypeFromString(s string) (InterruptType, error) {
	switch s {
	case "LocalPlugin":
		return InterruptType_LocalPlugin, nil
	case "Question":
		return InterruptType_Question, nil
	case "RequireInfos":
		return InterruptType_RequireInfos, nil
	case "SceneChat":
		return InterruptType_SceneChat, nil
	case "Input":
		return InterruptType_Input, nil
	case "OauthPlugin":
		return InterruptType_OauthPlugin, nil
	}
	return InterruptType(0), fmt.Errorf("not a valid InterruptType string")
}

func InterruptTypePtr(v InterruptType) *InterruptType { return &v }
func (p *InterruptType) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = InterruptType(result.Int64)
	return
}

func (p *InterruptType) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type WorkflowRunMode int64

const (
	WorkflowRunMode_Sync   WorkflowRunMode = 0
	WorkflowRunMode_Stream WorkflowRunMode = 1
	WorkflowRunMode_Async  WorkflowRunMode = 2
)

func (p WorkflowRunMode) String() string {
	switch p {
	case WorkflowRunMode_Sync:
		return "Sync"
	case WorkflowRunMode_Stream:
		return "Stream"
	case WorkflowRunMode_Async:
		return "Async"
	}
	return "<UNSET>"
}

func WorkflowRunModeFromString(s string) (WorkflowRunMode, error) {
	switch s {
	case "Sync":
		return WorkflowRunMode_Sync, nil
	case "Stream":
		return WorkflowRunMode_Stream, nil
	case "Async":
		return WorkflowRunMode_Async, nil
	}
	return WorkflowRunMode(0), fmt.Errorf("not a valid WorkflowRunMode string")
}

func WorkflowRunModePtr(v WorkflowRunMode) *WorkflowRunMode { return &v }
func (p *WorkflowRunMode) Scan(value interface{}) (err error) {
	var result sql.NullInt64
	err = result.Scan(value)
	*p = WorkflowRunMode(result.Int64)
	return
}

func (p *WorkflowRunMode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type Workflow struct {
	WorkflowID string            `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	Name       string            `thrift:"name,2" form:"name" json:"name" query:"name"`
	Desc       string            `thrift:"desc,3" form:"desc" json:"desc" query:"desc"`
	URL        string            `thrift:"url,4" form:"url" json:"url" query:"url"`
	IconURI    string            `thrift:"icon_uri,5" form:"icon_uri" json:"icon_uri" query:"icon_uri"`
	Status     WorkFlowDevStatus `thrift:"status,6" form:"status" json:"status" query:"status"`
	// Type 1: Official Template
	Type WorkFlowType `thrift:"type,7" form:"type" json:"type" query:"type"`
	// Plugin ID for workflow
	PluginID   string     `thrift:"plugin_id,8" form:"plugin_id" json:"plugin_id" query:"plugin_id"`
	CreateTime int64      `thrift:"create_time,9" form:"create_time" json:"create_time" query:"create_time"`
	UpdateTime int64      `thrift:"update_time,10" form:"update_time" json:"update_time" query:"update_time"`
	SchemaType SchemaType `thrift:"schema_type,11" form:"schema_type" json:"schema_type" query:"schema_type"`
	StartNode  *Node      `thrift:"start_node,12,optional" form:"start_node" json:"start_node,omitempty" query:"start_node"`
	Tag        *Tag       `thrift:"tag,13,optional" form:"tag" json:"tag,omitempty" query:"tag"`
	// template creator id
	TemplateAuthorID *string `thrift:"template_author_id,14,optional" form:"template_author_id" json:"template_author_id,omitempty" query:"template_author_id"`
	// template creator nickname
	TemplateAuthorName *string `thrift:"template_author_name,15,optional" form:"template_author_name" json:"template_author_name,omitempty" query:"template_author_name"`
	// template creator avatar
	TemplateAuthorPictureURL *string `thrift:"template_author_picture_url,16,optional" form:"template_author_picture_url" json:"template_author_picture_url,omitempty" query:"template_author_picture_url"`
	// Space ID
	SpaceID *string `thrift:"space_id,17,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	// process entry and exit
	InterfaceStr *string `thrift:"interface_str,18,optional" form:"interface_str" json:"interface_str,omitempty" query:"interface_str"`
	// New workflow definition schema
	SchemaJSON *string `thrift:"schema_json,19,optional" form:"schema_json" json:"schema_json,omitempty" query:"schema_json"`
	// Workflow creator information
	Creator *Creator `thrift:"creator,20" form:"creator" json:"creator" query:"creator"`
	// Storage Model
	PersistenceModel PersistenceModel `thrift:"persistence_model,21" form:"persistence_model" json:"persistence_model" query:"persistence_model"`
	// Workflow or imageflow, the default is workflow
	FlowMode WorkflowMode `thrift:"flow_mode,22" form:"flow_mode" json:"flow_mode" query:"flow_mode"`
	// Workflow product review version status
	ProductDraftStatus ProductDraftStatus `thrift:"product_draft_status,23" form:"product_draft_status" json:"product_draft_status" query:"product_draft_status"`
	// {"project_id":"xxx","flow_id":xxxx}
	ExternalFlowInfo *string `thrift:"external_flow_info,24,optional" form:"external_flow_info" json:"external_flow_info,omitempty" query:"external_flow_info"`
	// Workflow Multiplayer Collaboration Button Status
	CollaboratorMode CollaboratorMode `thrift:"collaborator_mode,25" form:"collaborator_mode" json:"collaborator_mode" query:"collaborator_mode"`
	CheckResult      []*CheckResult   `thrift:"check_result,26" form:"check_result" json:"check_result" query:"check_result"`
	ProjectID        *string          `thrift:"project_id,27,optional" form:"project_id" json:"project_id,omitempty" query:"project_id"`
	// Only the workflow under the project is available.
	DevPluginID *string `thrift:"dev_plugin_id,28,optional" form:"dev_plugin_id" json:"dev_plugin_id,omitempty" query:"dev_plugin_id"`
}

func NewWorkflow() *Workflow {
	return &Workflow{}
}

func (p *Workflow) InitDefault() {
}

func (p *Workflow) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *Workflow) GetName() (v string) {
	return p.Name
}

func (p *Workflow) GetDesc() (v string) {
	return p.Desc
}

func (p *Workflow) GetURL() (v string) {
	return p.URL
}

func (p *Workflow) GetIconURI() (v string) {
	return p.IconURI
}

func (p *Workflow) GetStatus() (v WorkFlowDevStatus) {
	return p.Status
}

func (p *Workflow) GetType() (v WorkFlowType) {
	return p.Type
}

func (p *Workflow) GetPluginID() (v string) {
	return p.PluginID
}

func (p *Workflow) GetCreateTime() (v int64) {
	return p.CreateTime
}

func (p *Workflow) GetUpdateTime() (v int64) {
	return p.UpdateTime
}

func (p *Workflow) GetSchemaType() (v SchemaType) {
	return p.SchemaType
}

var Workflow_StartNode_DEFAULT *Node

func (p *Workflow) GetStartNode() (v *Node) {
	if !p.IsSetStartNode() {
		return Workflow_StartNode_DEFAULT
	}
	return p.StartNode
}

var Workflow_Tag_DEFAULT Tag

func (p *Workflow) GetTag() (v Tag) {
	if !p.IsSetTag() {
		return Workflow_Tag_DEFAULT
	}
	return *p.Tag
}

var Workflow_TemplateAuthorID_DEFAULT string

func (p *Workflow) GetTemplateAuthorID() (v string) {
	if !p.IsSetTemplateAuthorID() {
		return Workflow_TemplateAuthorID_DEFAULT
	}
	return *p.TemplateAuthorID
}

var Workflow_TemplateAuthorName_DEFAULT string

func (p *Workflow) GetTemplateAuthorName() (v string) {
	if !p.IsSetTemplateAuthorName() {
		return Workflow_TemplateAuthorName_DEFAULT
	}
	return *p.TemplateAuthorName
}

var Workflow_TemplateAuthorPictureURL_DEFAULT string

func (p *Workflow) GetTemplateAuthorPictureURL() (v string) {
	if !p.IsSetTemplateAuthorPictureURL() {
		return Workflow_TemplateAuthorPictureURL_DEFAULT
	}
	return *p.TemplateAuthorPictureURL
}

var Workflow_SpaceID_DEFAULT string

func (p *Workflow) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return Workflow_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var Workflow_InterfaceStr_DEFAULT string

func (p *Workflow) GetInterfaceStr() (v string) {
	if !p.IsSetInterfaceStr() {
		return Workflow_InterfaceStr_DEFAULT
	}
	return *p.InterfaceStr
}

var Workflow_SchemaJSON_DEFAULT string

func (p *Workflow) GetSchemaJSON() (v string) {
	if !p.IsSetSchemaJSON() {
		return Workflow_SchemaJSON_DEFAULT
	}
	return *p.SchemaJSON
}

var Workflow_Creator_DEFAULT *Creator

func (p *Workflow) GetCreator() (v *Creator) {
	if !p.IsSetCreator() {
		return Workflow_Creator_DEFAULT
	}
	return p.Creator
}

func (p *Workflow) GetPersistenceModel() (v PersistenceModel) {
	return p.PersistenceModel
}

func (p *Workflow) GetFlowMode() (v WorkflowMode) {
	return p.FlowMode
}

func (p *Workflow) GetProductDraftStatus() (v ProductDraftStatus) {
	return p.ProductDraftStatus
}

var Workflow_ExternalFlowInfo_DEFAULT string

func (p *Workflow) GetExternalFlowInfo() (v string) {
	if !p.IsSetExternalFlowInfo() {
		return Workflow_ExternalFlowInfo_DEFAULT
	}
	return *p.ExternalFlowInfo
}

func (p *Workflow) GetCollaboratorMode() (v CollaboratorMode) {
	return p.CollaboratorMode
}

func (p *Workflow) GetCheckResult() (v []*CheckResult) {
	return p.CheckResult
}

var Workflow_ProjectID_DEFAULT string

func (p *Workflow) GetProjectID() (v string) {
	if !p.IsSetProjectID() {
		return Workflow_ProjectID_DEFAULT
	}
	return *p.ProjectID
}

var Workflow_DevPluginID_DEFAULT string

func (p *Workflow) GetDevPluginID() (v string) {
	if !p.IsSetDevPluginID() {
		return Workflow_DevPluginID_DEFAULT
	}
	return *p.DevPluginID
}

var fieldIDToName_Workflow = map[int16]string{
	1:  "workflow_id",
	2:  "name",
	3:  "desc",
	4:  "url",
	5:  "icon_uri",
	6:  "status",
	7:  "type",
	8:  "plugin_id",
	9:  "create_time",
	10: "update_time",
	11: "schema_type",
	12: "start_node",
	13: "tag",
	14: "template_author_id",
	15: "template_author_name",
	16: "template_author_picture_url",
	17: "space_id",
	18: "interface_str",
	19: "schema_json",
	20: "creator",
	21: "persistence_model",
	22: "flow_mode",
	23: "product_draft_status",
	24: "external_flow_info",
	25: "collaborator_mode",
	26: "check_result",
	27: "project_id",
	28: "dev_plugin_id",
}

func (p *Workflow) IsSetStartNode() bool {
	return p.StartNode != nil
}

func (p *Workflow) IsSetTag() bool {
	return p.Tag != nil
}

func (p *Workflow) IsSetTemplateAuthorID() bool {
	return p.TemplateAuthorID != nil
}

func (p *Workflow) IsSetTemplateAuthorName() bool {
	return p.TemplateAuthorName != nil
}

func (p *Workflow) IsSetTemplateAuthorPictureURL() bool {
	return p.TemplateAuthorPictureURL != nil
}

func (p *Workflow) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *Workflow) IsSetInterfaceStr() bool {
	return p.InterfaceStr != nil
}

func (p *Workflow) IsSetSchemaJSON() bool {
	return p.SchemaJSON != nil
}

func (p *Workflow) IsSetCreator() bool {
	return p.Creator != nil
}

func (p *Workflow) IsSetExternalFlowInfo() bool {
	return p.ExternalFlowInfo != nil
}

func (p *Workflow) IsSetProjectID() bool {
	return p.ProjectID != nil
}

func (p *Workflow) IsSetDevPluginID() bool {
	return p.DevPluginID != nil
}

func (p *Workflow) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 22:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField22(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 23:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField23(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 24:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField24(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 25:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField25(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 26:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField26(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 27:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField27(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 28:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField28(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Workflow[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Workflow) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *Workflow) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *Workflow) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *Workflow) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *Workflow) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURI = _field
	return nil
}
func (p *Workflow) ReadField6(iprot thrift.TProtocol) error {

	var _field WorkFlowDevStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowDevStatus(v)
	}
	p.Status = _field
	return nil
}
func (p *Workflow) ReadField7(iprot thrift.TProtocol) error {

	var _field WorkFlowType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowType(v)
	}
	p.Type = _field
	return nil
}
func (p *Workflow) ReadField8(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginID = _field
	return nil
}
func (p *Workflow) ReadField9(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CreateTime = _field
	return nil
}
func (p *Workflow) ReadField10(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UpdateTime = _field
	return nil
}
func (p *Workflow) ReadField11(iprot thrift.TProtocol) error {

	var _field SchemaType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = SchemaType(v)
	}
	p.SchemaType = _field
	return nil
}
func (p *Workflow) ReadField12(iprot thrift.TProtocol) error {
	_field := NewNode()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.StartNode = _field
	return nil
}
func (p *Workflow) ReadField13(iprot thrift.TProtocol) error {

	var _field *Tag
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := Tag(v)
		_field = &tmp
	}
	p.Tag = _field
	return nil
}
func (p *Workflow) ReadField14(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TemplateAuthorID = _field
	return nil
}
func (p *Workflow) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TemplateAuthorName = _field
	return nil
}
func (p *Workflow) ReadField16(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TemplateAuthorPictureURL = _field
	return nil
}
func (p *Workflow) ReadField17(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *Workflow) ReadField18(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.InterfaceStr = _field
	return nil
}
func (p *Workflow) ReadField19(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SchemaJSON = _field
	return nil
}
func (p *Workflow) ReadField20(iprot thrift.TProtocol) error {
	_field := NewCreator()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Creator = _field
	return nil
}
func (p *Workflow) ReadField21(iprot thrift.TProtocol) error {

	var _field PersistenceModel
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = PersistenceModel(v)
	}
	p.PersistenceModel = _field
	return nil
}
func (p *Workflow) ReadField22(iprot thrift.TProtocol) error {

	var _field WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkflowMode(v)
	}
	p.FlowMode = _field
	return nil
}
func (p *Workflow) ReadField23(iprot thrift.TProtocol) error {

	var _field ProductDraftStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ProductDraftStatus(v)
	}
	p.ProductDraftStatus = _field
	return nil
}
func (p *Workflow) ReadField24(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ExternalFlowInfo = _field
	return nil
}
func (p *Workflow) ReadField25(iprot thrift.TProtocol) error {

	var _field CollaboratorMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = CollaboratorMode(v)
	}
	p.CollaboratorMode = _field
	return nil
}
func (p *Workflow) ReadField26(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*CheckResult, 0, size)
	values := make([]CheckResult, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.CheckResult = _field
	return nil
}
func (p *Workflow) ReadField27(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProjectID = _field
	return nil
}
func (p *Workflow) ReadField28(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.DevPluginID = _field
	return nil
}

func (p *Workflow) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Workflow"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
		if err = p.writeField22(oprot); err != nil {
			fieldId = 22
			goto WriteFieldError
		}
		if err = p.writeField23(oprot); err != nil {
			fieldId = 23
			goto WriteFieldError
		}
		if err = p.writeField24(oprot); err != nil {
			fieldId = 24
			goto WriteFieldError
		}
		if err = p.writeField25(oprot); err != nil {
			fieldId = 25
			goto WriteFieldError
		}
		if err = p.writeField26(oprot); err != nil {
			fieldId = 26
			goto WriteFieldError
		}
		if err = p.writeField27(oprot); err != nil {
			fieldId = 27
			goto WriteFieldError
		}
		if err = p.writeField28(oprot); err != nil {
			fieldId = 28
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Workflow) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Workflow) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Workflow) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Workflow) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Workflow) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Workflow) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("status", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *Workflow) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *Workflow) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("plugin_id", thrift.STRING, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PluginID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *Workflow) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("create_time", thrift.I64, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.CreateTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *Workflow) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("update_time", thrift.I64, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.UpdateTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *Workflow) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("schema_type", thrift.I32, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SchemaType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *Workflow) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetStartNode() {
		if err = oprot.WriteFieldBegin("start_node", thrift.STRUCT, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.StartNode.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *Workflow) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetTag() {
		if err = oprot.WriteFieldBegin("tag", thrift.I32, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Tag)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *Workflow) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetTemplateAuthorID() {
		if err = oprot.WriteFieldBegin("template_author_id", thrift.STRING, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.TemplateAuthorID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *Workflow) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetTemplateAuthorName() {
		if err = oprot.WriteFieldBegin("template_author_name", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.TemplateAuthorName); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *Workflow) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetTemplateAuthorPictureURL() {
		if err = oprot.WriteFieldBegin("template_author_picture_url", thrift.STRING, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.TemplateAuthorPictureURL); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *Workflow) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *Workflow) writeField18(oprot thrift.TProtocol) (err error) {
	if p.IsSetInterfaceStr() {
		if err = oprot.WriteFieldBegin("interface_str", thrift.STRING, 18); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.InterfaceStr); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *Workflow) writeField19(oprot thrift.TProtocol) (err error) {
	if p.IsSetSchemaJSON() {
		if err = oprot.WriteFieldBegin("schema_json", thrift.STRING, 19); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SchemaJSON); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *Workflow) writeField20(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("creator", thrift.STRUCT, 20); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Creator.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}
func (p *Workflow) writeField21(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("persistence_model", thrift.I32, 21); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.PersistenceModel)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}
func (p *Workflow) writeField22(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 22); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.FlowMode)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 end error: ", p), err)
}
func (p *Workflow) writeField23(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("product_draft_status", thrift.I32, 23); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.ProductDraftStatus)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 23 end error: ", p), err)
}
func (p *Workflow) writeField24(oprot thrift.TProtocol) (err error) {
	if p.IsSetExternalFlowInfo() {
		if err = oprot.WriteFieldBegin("external_flow_info", thrift.STRING, 24); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ExternalFlowInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 24 end error: ", p), err)
}
func (p *Workflow) writeField25(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("collaborator_mode", thrift.I32, 25); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.CollaboratorMode)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 25 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 25 end error: ", p), err)
}
func (p *Workflow) writeField26(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("check_result", thrift.LIST, 26); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.CheckResult)); err != nil {
		return err
	}
	for _, v := range p.CheckResult {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 26 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 26 end error: ", p), err)
}
func (p *Workflow) writeField27(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectID() {
		if err = oprot.WriteFieldBegin("project_id", thrift.STRING, 27); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProjectID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 27 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 27 end error: ", p), err)
}
func (p *Workflow) writeField28(oprot thrift.TProtocol) (err error) {
	if p.IsSetDevPluginID() {
		if err = oprot.WriteFieldBegin("dev_plugin_id", thrift.STRING, 28); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.DevPluginID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 28 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 28 end error: ", p), err)
}

func (p *Workflow) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Workflow(%+v)", *p)

}

type CheckResult struct {
	// check type
	Type CheckType `thrift:"type,1" form:"type" json:"type" query:"type"`
	// Whether to pass
	IsPass bool `thrift:"is_pass,2" form:"is_pass" json:"is_pass" query:"is_pass"`
	// Reason for not passing
	Reason string `thrift:"reason,3" form:"reason" json:"reason" query:"reason"`
}

func NewCheckResult() *CheckResult {
	return &CheckResult{}
}

func (p *CheckResult) InitDefault() {
}

func (p *CheckResult) GetType() (v CheckType) {
	return p.Type
}

func (p *CheckResult) GetIsPass() (v bool) {
	return p.IsPass
}

func (p *CheckResult) GetReason() (v string) {
	return p.Reason
}

var fieldIDToName_CheckResult = map[int16]string{
	1: "type",
	2: "is_pass",
	3: "reason",
}

func (p *CheckResult) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CheckResult[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CheckResult) ReadField1(iprot thrift.TProtocol) error {

	var _field CheckType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = CheckType(v)
	}
	p.Type = _field
	return nil
}
func (p *CheckResult) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsPass = _field
	return nil
}
func (p *CheckResult) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Reason = _field
	return nil
}

func (p *CheckResult) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CheckResult"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CheckResult) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CheckResult) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_pass", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsPass); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CheckResult) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("reason", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Reason); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *CheckResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CheckResult(%+v)", *p)

}

type Creator struct {
	ID        string `thrift:"id,1" form:"id" json:"id" query:"id"`
	Name      string `thrift:"name,2" form:"name" json:"name" query:"name"`
	AvatarURL string `thrift:"avatar_url,3" form:"avatar_url" json:"avatar_url" query:"avatar_url"`
	// Did you create it yourself?
	Self bool `thrift:"self,4" form:"self" json:"self" query:"self"`
}

func NewCreator() *Creator {
	return &Creator{}
}

func (p *Creator) InitDefault() {
}

func (p *Creator) GetID() (v string) {
	return p.ID
}

func (p *Creator) GetName() (v string) {
	return p.Name
}

func (p *Creator) GetAvatarURL() (v string) {
	return p.AvatarURL
}

func (p *Creator) GetSelf() (v bool) {
	return p.Self
}

var fieldIDToName_Creator = map[int16]string{
	1: "id",
	2: "name",
	3: "avatar_url",
	4: "self",
}

func (p *Creator) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Creator[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Creator) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *Creator) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *Creator) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.AvatarURL = _field
	return nil
}
func (p *Creator) ReadField4(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Self = _field
	return nil
}

func (p *Creator) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Creator"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Creator) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Creator) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Creator) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("avatar_url", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.AvatarURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Creator) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("self", thrift.BOOL, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Self); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *Creator) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Creator(%+v)", *p)

}

type Param struct {
	Key      []string  `thrift:"key,1" form:"key" json:"key" query:"key"`
	Desc     string    `thrift:"desc,2" form:"desc" json:"desc" query:"desc"`
	Type     InputType `thrift:"type,3" form:"type" json:"type" query:"type"`
	Required bool      `thrift:"required,4" form:"required" json:"required" query:"required"`
	Value    string    `thrift:"value,5" form:"value" json:"value" query:"value"`
	// Requirements 1 Do not allow deletion 2 Do not allow name change 3 Anything can be modified 4 Only display, all are not allowed to be changed
	Requirement ParamRequirementType `thrift:"requirement,6" form:"requirement" json:"requirement" query:"requirement"`
	FromNodeID  *string              `thrift:"from_node_id,7,optional" form:"from_node_id" json:"from_node_id,omitempty" query:"from_node_id"`
	FromOutput  []string             `thrift:"from_output,8,optional" form:"from_output" json:"from_output,omitempty" query:"from_output"`
}

func NewParam() *Param {
	return &Param{}
}

func (p *Param) InitDefault() {
}

func (p *Param) GetKey() (v []string) {
	return p.Key
}

func (p *Param) GetDesc() (v string) {
	return p.Desc
}

func (p *Param) GetType() (v InputType) {
	return p.Type
}

func (p *Param) GetRequired() (v bool) {
	return p.Required
}

func (p *Param) GetValue() (v string) {
	return p.Value
}

func (p *Param) GetRequirement() (v ParamRequirementType) {
	return p.Requirement
}

var Param_FromNodeID_DEFAULT string

func (p *Param) GetFromNodeID() (v string) {
	if !p.IsSetFromNodeID() {
		return Param_FromNodeID_DEFAULT
	}
	return *p.FromNodeID
}

var Param_FromOutput_DEFAULT []string

func (p *Param) GetFromOutput() (v []string) {
	if !p.IsSetFromOutput() {
		return Param_FromOutput_DEFAULT
	}
	return p.FromOutput
}

var fieldIDToName_Param = map[int16]string{
	1: "key",
	2: "desc",
	3: "type",
	4: "required",
	5: "value",
	6: "requirement",
	7: "from_node_id",
	8: "from_output",
}

func (p *Param) IsSetFromNodeID() bool {
	return p.FromNodeID != nil
}

func (p *Param) IsSetFromOutput() bool {
	return p.FromOutput != nil
}

func (p *Param) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Param[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Param) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Key = _field
	return nil
}
func (p *Param) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *Param) ReadField3(iprot thrift.TProtocol) error {

	var _field InputType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = InputType(v)
	}
	p.Type = _field
	return nil
}
func (p *Param) ReadField4(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Required = _field
	return nil
}
func (p *Param) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Value = _field
	return nil
}
func (p *Param) ReadField6(iprot thrift.TProtocol) error {

	var _field ParamRequirementType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ParamRequirementType(v)
	}
	p.Requirement = _field
	return nil
}
func (p *Param) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.FromNodeID = _field
	return nil
}
func (p *Param) ReadField8(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.FromOutput = _field
	return nil
}

func (p *Param) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Param"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Param) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("key", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.Key)); err != nil {
		return err
	}
	for _, v := range p.Key {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Param) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Param) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Param) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("required", thrift.BOOL, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Required); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Param) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("value", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Value); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Param) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("requirement", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Requirement)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *Param) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetFromNodeID() {
		if err = oprot.WriteFieldBegin("from_node_id", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.FromNodeID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *Param) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetFromOutput() {
		if err = oprot.WriteFieldBegin("from_output", thrift.LIST, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.FromOutput)); err != nil {
			return err
		}
		for _, v := range p.FromOutput {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}

func (p *Param) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Param(%+v)", *p)

}

type APIParam struct {
	PluginID      string `thrift:"plugin_id,1" form:"plugin_id" json:"plugin_id" query:"plugin_id"`
	APIID         string `thrift:"api_id,2" form:"api_id" json:"api_id" query:"api_id"`
	PluginVersion string `thrift:"plugin_version,3" form:"plugin_version" json:"plugin_version" query:"plugin_version"`
	PluginName    string `thrift:"plugin_name,4" form:"plugin_name" json:"plugin_name" query:"plugin_name"`
	APIName       string `thrift:"api_name,5" form:"api_name" json:"api_name" query:"api_name"`
	OutDocLink    string `thrift:"out_doc_link,6" form:"out_doc_link" json:"out_doc_link" query:"out_doc_link"`
	Tips          string `thrift:"tips,7" form:"tips" json:"tips" query:"tips"`
}

func NewAPIParam() *APIParam {
	return &APIParam{}
}

func (p *APIParam) InitDefault() {
}

func (p *APIParam) GetPluginID() (v string) {
	return p.PluginID
}

func (p *APIParam) GetAPIID() (v string) {
	return p.APIID
}

func (p *APIParam) GetPluginVersion() (v string) {
	return p.PluginVersion
}

func (p *APIParam) GetPluginName() (v string) {
	return p.PluginName
}

func (p *APIParam) GetAPIName() (v string) {
	return p.APIName
}

func (p *APIParam) GetOutDocLink() (v string) {
	return p.OutDocLink
}

func (p *APIParam) GetTips() (v string) {
	return p.Tips
}

var fieldIDToName_APIParam = map[int16]string{
	1: "plugin_id",
	2: "api_id",
	3: "plugin_version",
	4: "plugin_name",
	5: "api_name",
	6: "out_doc_link",
	7: "tips",
}

func (p *APIParam) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_APIParam[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *APIParam) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginID = _field
	return nil
}
func (p *APIParam) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.APIID = _field
	return nil
}
func (p *APIParam) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginVersion = _field
	return nil
}
func (p *APIParam) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginName = _field
	return nil
}
func (p *APIParam) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.APIName = _field
	return nil
}
func (p *APIParam) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.OutDocLink = _field
	return nil
}
func (p *APIParam) ReadField7(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Tips = _field
	return nil
}

func (p *APIParam) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("APIParam"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *APIParam) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("plugin_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PluginID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *APIParam) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("api_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.APIID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *APIParam) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("plugin_version", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PluginVersion); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *APIParam) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("plugin_name", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PluginName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *APIParam) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("api_name", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.APIName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *APIParam) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("out_doc_link", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.OutDocLink); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *APIParam) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("tips", thrift.STRING, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Tips); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *APIParam) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("APIParam(%+v)", *p)

}

type CodeParam struct {
	CodeSnippet string `thrift:"code_snippet,1" form:"code_snippet" json:"code_snippet" query:"code_snippet"`
}

func NewCodeParam() *CodeParam {
	return &CodeParam{}
}

func (p *CodeParam) InitDefault() {
}

func (p *CodeParam) GetCodeSnippet() (v string) {
	return p.CodeSnippet
}

var fieldIDToName_CodeParam = map[int16]string{
	1: "code_snippet",
}

func (p *CodeParam) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CodeParam[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CodeParam) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CodeSnippet = _field
	return nil
}

func (p *CodeParam) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CodeParam"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CodeParam) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code_snippet", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.CodeSnippet); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *CodeParam) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CodeParam(%+v)", *p)

}

type LLMParam struct {
	ModelType   int32   `thrift:"model_type,1" form:"model_type" json:"model_type" query:"model_type"`
	Temperature float64 `thrift:"temperature,2" form:"temperature" json:"temperature" query:"temperature"`
	Prompt      string  `thrift:"prompt,3" form:"prompt" json:"prompt" query:"prompt"`
	ModelName   string  `thrift:"model_name,4" form:"model_name" json:"model_name" query:"model_name"`
}

func NewLLMParam() *LLMParam {
	return &LLMParam{}
}

func (p *LLMParam) InitDefault() {
}

func (p *LLMParam) GetModelType() (v int32) {
	return p.ModelType
}

func (p *LLMParam) GetTemperature() (v float64) {
	return p.Temperature
}

func (p *LLMParam) GetPrompt() (v string) {
	return p.Prompt
}

func (p *LLMParam) GetModelName() (v string) {
	return p.ModelName
}

var fieldIDToName_LLMParam = map[int16]string{
	1: "model_type",
	2: "temperature",
	3: "prompt",
	4: "model_name",
}

func (p *LLMParam) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_LLMParam[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *LLMParam) ReadField1(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelType = _field
	return nil
}
func (p *LLMParam) ReadField2(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Temperature = _field
	return nil
}
func (p *LLMParam) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Prompt = _field
	return nil
}
func (p *LLMParam) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ModelName = _field
	return nil
}

func (p *LLMParam) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("LLMParam"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *LLMParam) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_type", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.ModelType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *LLMParam) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("temperature", thrift.DOUBLE, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.Temperature); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *LLMParam) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("prompt", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Prompt); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *LLMParam) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("model_name", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ModelName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *LLMParam) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("LLMParam(%+v)", *p)

}

type DatasetParam struct {
	DatasetList []string `thrift:"dataset_list,1" form:"dataset_list" json:"dataset_list" query:"dataset_list"`
}

func NewDatasetParam() *DatasetParam {
	return &DatasetParam{}
}

func (p *DatasetParam) InitDefault() {
}

func (p *DatasetParam) GetDatasetList() (v []string) {
	return p.DatasetList
}

var fieldIDToName_DatasetParam = map[int16]string{
	1: "dataset_list",
}

func (p *DatasetParam) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DatasetParam[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DatasetParam) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.DatasetList = _field
	return nil
}

func (p *DatasetParam) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DatasetParam"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DatasetParam) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("dataset_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.DatasetList)); err != nil {
		return err
	}
	for _, v := range p.DatasetList {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DatasetParam) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DatasetParam(%+v)", *p)

}

type IfParam struct {
	IfBranch   *IfBranch `thrift:"if_branch,1,optional" form:"if_branch" json:"if_branch,omitempty" query:"if_branch"`
	ElseBranch *IfBranch `thrift:"else_branch,2,optional" form:"else_branch" json:"else_branch,omitempty" query:"else_branch"`
}

func NewIfParam() *IfParam {
	return &IfParam{}
}

func (p *IfParam) InitDefault() {
}

var IfParam_IfBranch_DEFAULT *IfBranch

func (p *IfParam) GetIfBranch() (v *IfBranch) {
	if !p.IsSetIfBranch() {
		return IfParam_IfBranch_DEFAULT
	}
	return p.IfBranch
}

var IfParam_ElseBranch_DEFAULT *IfBranch

func (p *IfParam) GetElseBranch() (v *IfBranch) {
	if !p.IsSetElseBranch() {
		return IfParam_ElseBranch_DEFAULT
	}
	return p.ElseBranch
}

var fieldIDToName_IfParam = map[int16]string{
	1: "if_branch",
	2: "else_branch",
}

func (p *IfParam) IsSetIfBranch() bool {
	return p.IfBranch != nil
}

func (p *IfParam) IsSetElseBranch() bool {
	return p.ElseBranch != nil
}

func (p *IfParam) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_IfParam[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *IfParam) ReadField1(iprot thrift.TProtocol) error {
	_field := NewIfBranch()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.IfBranch = _field
	return nil
}
func (p *IfParam) ReadField2(iprot thrift.TProtocol) error {
	_field := NewIfBranch()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.ElseBranch = _field
	return nil
}

func (p *IfParam) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("IfParam"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *IfParam) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetIfBranch() {
		if err = oprot.WriteFieldBegin("if_branch", thrift.STRUCT, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.IfBranch.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *IfParam) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetElseBranch() {
		if err = oprot.WriteFieldBegin("else_branch", thrift.STRUCT, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.ElseBranch.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *IfParam) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("IfParam(%+v)", *p)

}

type IfBranch struct {
	// Conditions for this branch
	IfConditions []*IfCondition `thrift:"if_conditions,1,optional" form:"if_conditions" json:"if_conditions,omitempty" query:"if_conditions"`
	// The relationship between the conditions of this branch
	IfConditionRelation *IfConditionRelation `thrift:"if_condition_relation,2,optional" form:"if_condition_relation" json:"if_condition_relation,omitempty" query:"if_condition_relation"`
	// The next node corresponding to this branch
	NextNodeID []string `thrift:"next_node_id,3,optional" form:"next_node_id" json:"next_node_id,omitempty" query:"next_node_id"`
}

func NewIfBranch() *IfBranch {
	return &IfBranch{}
}

func (p *IfBranch) InitDefault() {
}

var IfBranch_IfConditions_DEFAULT []*IfCondition

func (p *IfBranch) GetIfConditions() (v []*IfCondition) {
	if !p.IsSetIfConditions() {
		return IfBranch_IfConditions_DEFAULT
	}
	return p.IfConditions
}

var IfBranch_IfConditionRelation_DEFAULT IfConditionRelation

func (p *IfBranch) GetIfConditionRelation() (v IfConditionRelation) {
	if !p.IsSetIfConditionRelation() {
		return IfBranch_IfConditionRelation_DEFAULT
	}
	return *p.IfConditionRelation
}

var IfBranch_NextNodeID_DEFAULT []string

func (p *IfBranch) GetNextNodeID() (v []string) {
	if !p.IsSetNextNodeID() {
		return IfBranch_NextNodeID_DEFAULT
	}
	return p.NextNodeID
}

var fieldIDToName_IfBranch = map[int16]string{
	1: "if_conditions",
	2: "if_condition_relation",
	3: "next_node_id",
}

func (p *IfBranch) IsSetIfConditions() bool {
	return p.IfConditions != nil
}

func (p *IfBranch) IsSetIfConditionRelation() bool {
	return p.IfConditionRelation != nil
}

func (p *IfBranch) IsSetNextNodeID() bool {
	return p.NextNodeID != nil
}

func (p *IfBranch) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_IfBranch[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *IfBranch) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*IfCondition, 0, size)
	values := make([]IfCondition, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.IfConditions = _field
	return nil
}
func (p *IfBranch) ReadField2(iprot thrift.TProtocol) error {

	var _field *IfConditionRelation
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := IfConditionRelation(v)
		_field = &tmp
	}
	p.IfConditionRelation = _field
	return nil
}
func (p *IfBranch) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.NextNodeID = _field
	return nil
}

func (p *IfBranch) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("IfBranch"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *IfBranch) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetIfConditions() {
		if err = oprot.WriteFieldBegin("if_conditions", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.IfConditions)); err != nil {
			return err
		}
		for _, v := range p.IfConditions {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *IfBranch) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetIfConditionRelation() {
		if err = oprot.WriteFieldBegin("if_condition_relation", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.IfConditionRelation)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *IfBranch) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetNextNodeID() {
		if err = oprot.WriteFieldBegin("next_node_id", thrift.LIST, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.NextNodeID)); err != nil {
			return err
		}
		for _, v := range p.NextNodeID {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *IfBranch) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("IfBranch(%+v)", *p)

}

type IfCondition struct {
	FirstParameter  *Parameter    `thrift:"first_parameter,1,required" form:"first_parameter,required" json:"first_parameter,required" query:"first_parameter,required"`
	Condition       ConditionType `thrift:"condition,2,required" form:"condition,required" json:"condition,required" query:"condition,required"`
	SecondParameter *Parameter    `thrift:"second_parameter,3,required" form:"second_parameter,required" json:"second_parameter,required" query:"second_parameter,required"`
}

func NewIfCondition() *IfCondition {
	return &IfCondition{}
}

func (p *IfCondition) InitDefault() {
}

var IfCondition_FirstParameter_DEFAULT *Parameter

func (p *IfCondition) GetFirstParameter() (v *Parameter) {
	if !p.IsSetFirstParameter() {
		return IfCondition_FirstParameter_DEFAULT
	}
	return p.FirstParameter
}

func (p *IfCondition) GetCondition() (v ConditionType) {
	return p.Condition
}

var IfCondition_SecondParameter_DEFAULT *Parameter

func (p *IfCondition) GetSecondParameter() (v *Parameter) {
	if !p.IsSetSecondParameter() {
		return IfCondition_SecondParameter_DEFAULT
	}
	return p.SecondParameter
}

var fieldIDToName_IfCondition = map[int16]string{
	1: "first_parameter",
	2: "condition",
	3: "second_parameter",
}

func (p *IfCondition) IsSetFirstParameter() bool {
	return p.FirstParameter != nil
}

func (p *IfCondition) IsSetSecondParameter() bool {
	return p.SecondParameter != nil
}

func (p *IfCondition) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetFirstParameter bool = false
	var issetCondition bool = false
	var issetSecondParameter bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetFirstParameter = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetCondition = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetSecondParameter = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetFirstParameter {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCondition {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetSecondParameter {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_IfCondition[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_IfCondition[fieldId]))
}

func (p *IfCondition) ReadField1(iprot thrift.TProtocol) error {
	_field := NewParameter()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.FirstParameter = _field
	return nil
}
func (p *IfCondition) ReadField2(iprot thrift.TProtocol) error {

	var _field ConditionType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = ConditionType(v)
	}
	p.Condition = _field
	return nil
}
func (p *IfCondition) ReadField3(iprot thrift.TProtocol) error {
	_field := NewParameter()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.SecondParameter = _field
	return nil
}

func (p *IfCondition) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("IfCondition"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *IfCondition) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("first_parameter", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.FirstParameter.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *IfCondition) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("condition", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Condition)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *IfCondition) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("second_parameter", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.SecondParameter.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *IfCondition) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("IfCondition(%+v)", *p)

}

type LayOut struct {
	X float64 `thrift:"x,1" form:"x" json:"x" query:"x"`
	Y float64 `thrift:"y,2" form:"y" json:"y" query:"y"`
}

func NewLayOut() *LayOut {
	return &LayOut{}
}

func (p *LayOut) InitDefault() {
}

func (p *LayOut) GetX() (v float64) {
	return p.X
}

func (p *LayOut) GetY() (v float64) {
	return p.Y
}

var fieldIDToName_LayOut = map[int16]string{
	1: "x",
	2: "y",
}

func (p *LayOut) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.DOUBLE {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_LayOut[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *LayOut) ReadField1(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.X = _field
	return nil
}
func (p *LayOut) ReadField2(iprot thrift.TProtocol) error {

	var _field float64
	if v, err := iprot.ReadDouble(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Y = _field
	return nil
}

func (p *LayOut) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("LayOut"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *LayOut) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("x", thrift.DOUBLE, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.X); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *LayOut) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("y", thrift.DOUBLE, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteDouble(p.Y); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *LayOut) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("LayOut(%+v)", *p)

}

type TerminatePlan struct {
	//End method
	Plan    TerminatePlanType `thrift:"plan,1" form:"plan" json:"plan" query:"plan"`
	Content string            `thrift:"content,2" form:"content" json:"content" query:"content"`
}

func NewTerminatePlan() *TerminatePlan {
	return &TerminatePlan{}
}

func (p *TerminatePlan) InitDefault() {
}

func (p *TerminatePlan) GetPlan() (v TerminatePlanType) {
	return p.Plan
}

func (p *TerminatePlan) GetContent() (v string) {
	return p.Content
}

var fieldIDToName_TerminatePlan = map[int16]string{
	1: "plan",
	2: "content",
}

func (p *TerminatePlan) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_TerminatePlan[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *TerminatePlan) ReadField1(iprot thrift.TProtocol) error {

	var _field TerminatePlanType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = TerminatePlanType(v)
	}
	p.Plan = _field
	return nil
}
func (p *TerminatePlan) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Content = _field
	return nil
}

func (p *TerminatePlan) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("TerminatePlan"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *TerminatePlan) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("plan", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Plan)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *TerminatePlan) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("content", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Content); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *TerminatePlan) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TerminatePlan(%+v)", *p)

}

type NodeParam struct {
	// Enter parameter list, support multi-level; support mapping
	InputList []*Param `thrift:"input_list,1,optional" form:"input_list" json:"input_list,omitempty" query:"input_list"`
	// Output parameter list, support multi-level
	OutputList []*Param `thrift:"output_list,2,optional" form:"output_list" json:"output_list,omitempty" query:"output_list"`
	// If it is an API type Node, plug-in name, API name, plug-in version, API description
	APIParam *APIParam `thrift:"api_param,3,optional" form:"api_param" json:"api_param,omitempty" query:"api_param"`
	// If it is a code snippet, include the code content
	CodeParam *CodeParam `thrift:"code_param,4,optional" form:"code_param" json:"code_param,omitempty" query:"code_param"`
	// If it is a model, include the basic information of the model
	LlmParam *LLMParam `thrift:"llm_param,5,optional" form:"llm_param" json:"llm_param,omitempty" query:"llm_param"`
	// If it is a dataset, select a fragment of the dataset
	DatasetParam *DatasetParam `thrift:"dataset_param,6,optional" form:"dataset_param" json:"dataset_param,omitempty" query:"dataset_param"`
	// End node, how to end
	TerminatePlan *TerminatePlan `thrift:"terminate_plan,7,optional" form:"terminate_plan" json:"terminate_plan,omitempty" query:"terminate_plan"`
	// (New) input parameter list
	InputParameters []*Parameter `thrift:"input_parameters,8,optional" form:"input_parameters" json:"input_parameters,omitempty" query:"input_parameters"`
	// (New) Output parameter list
	OutputParameters []*Parameter `thrift:"output_parameters,9,optional" form:"output_parameters" json:"output_parameters,omitempty" query:"output_parameters"`
	// batch setup
	Batch *Batch `thrift:"batch,10,optional" form:"batch" json:"batch,omitempty" query:"batch"`
	// if node parameter
	IfParam *IfParam `thrift:"if_param,11,optional" form:"if_param" json:"if_param,omitempty" query:"if_param"`
}

func NewNodeParam() *NodeParam {
	return &NodeParam{}
}

func (p *NodeParam) InitDefault() {
}

var NodeParam_InputList_DEFAULT []*Param

func (p *NodeParam) GetInputList() (v []*Param) {
	if !p.IsSetInputList() {
		return NodeParam_InputList_DEFAULT
	}
	return p.InputList
}

var NodeParam_OutputList_DEFAULT []*Param

func (p *NodeParam) GetOutputList() (v []*Param) {
	if !p.IsSetOutputList() {
		return NodeParam_OutputList_DEFAULT
	}
	return p.OutputList
}

var NodeParam_APIParam_DEFAULT *APIParam

func (p *NodeParam) GetAPIParam() (v *APIParam) {
	if !p.IsSetAPIParam() {
		return NodeParam_APIParam_DEFAULT
	}
	return p.APIParam
}

var NodeParam_CodeParam_DEFAULT *CodeParam

func (p *NodeParam) GetCodeParam() (v *CodeParam) {
	if !p.IsSetCodeParam() {
		return NodeParam_CodeParam_DEFAULT
	}
	return p.CodeParam
}

var NodeParam_LlmParam_DEFAULT *LLMParam

func (p *NodeParam) GetLlmParam() (v *LLMParam) {
	if !p.IsSetLlmParam() {
		return NodeParam_LlmParam_DEFAULT
	}
	return p.LlmParam
}

var NodeParam_DatasetParam_DEFAULT *DatasetParam

func (p *NodeParam) GetDatasetParam() (v *DatasetParam) {
	if !p.IsSetDatasetParam() {
		return NodeParam_DatasetParam_DEFAULT
	}
	return p.DatasetParam
}

var NodeParam_TerminatePlan_DEFAULT *TerminatePlan

func (p *NodeParam) GetTerminatePlan() (v *TerminatePlan) {
	if !p.IsSetTerminatePlan() {
		return NodeParam_TerminatePlan_DEFAULT
	}
	return p.TerminatePlan
}

var NodeParam_InputParameters_DEFAULT []*Parameter

func (p *NodeParam) GetInputParameters() (v []*Parameter) {
	if !p.IsSetInputParameters() {
		return NodeParam_InputParameters_DEFAULT
	}
	return p.InputParameters
}

var NodeParam_OutputParameters_DEFAULT []*Parameter

func (p *NodeParam) GetOutputParameters() (v []*Parameter) {
	if !p.IsSetOutputParameters() {
		return NodeParam_OutputParameters_DEFAULT
	}
	return p.OutputParameters
}

var NodeParam_Batch_DEFAULT *Batch

func (p *NodeParam) GetBatch() (v *Batch) {
	if !p.IsSetBatch() {
		return NodeParam_Batch_DEFAULT
	}
	return p.Batch
}

var NodeParam_IfParam_DEFAULT *IfParam

func (p *NodeParam) GetIfParam() (v *IfParam) {
	if !p.IsSetIfParam() {
		return NodeParam_IfParam_DEFAULT
	}
	return p.IfParam
}

var fieldIDToName_NodeParam = map[int16]string{
	1:  "input_list",
	2:  "output_list",
	3:  "api_param",
	4:  "code_param",
	5:  "llm_param",
	6:  "dataset_param",
	7:  "terminate_plan",
	8:  "input_parameters",
	9:  "output_parameters",
	10: "batch",
	11: "if_param",
}

func (p *NodeParam) IsSetInputList() bool {
	return p.InputList != nil
}

func (p *NodeParam) IsSetOutputList() bool {
	return p.OutputList != nil
}

func (p *NodeParam) IsSetAPIParam() bool {
	return p.APIParam != nil
}

func (p *NodeParam) IsSetCodeParam() bool {
	return p.CodeParam != nil
}

func (p *NodeParam) IsSetLlmParam() bool {
	return p.LlmParam != nil
}

func (p *NodeParam) IsSetDatasetParam() bool {
	return p.DatasetParam != nil
}

func (p *NodeParam) IsSetTerminatePlan() bool {
	return p.TerminatePlan != nil
}

func (p *NodeParam) IsSetInputParameters() bool {
	return p.InputParameters != nil
}

func (p *NodeParam) IsSetOutputParameters() bool {
	return p.OutputParameters != nil
}

func (p *NodeParam) IsSetBatch() bool {
	return p.Batch != nil
}

func (p *NodeParam) IsSetIfParam() bool {
	return p.IfParam != nil
}

func (p *NodeParam) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_NodeParam[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *NodeParam) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Param, 0, size)
	values := make([]Param, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.InputList = _field
	return nil
}
func (p *NodeParam) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Param, 0, size)
	values := make([]Param, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.OutputList = _field
	return nil
}
func (p *NodeParam) ReadField3(iprot thrift.TProtocol) error {
	_field := NewAPIParam()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.APIParam = _field
	return nil
}
func (p *NodeParam) ReadField4(iprot thrift.TProtocol) error {
	_field := NewCodeParam()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.CodeParam = _field
	return nil
}
func (p *NodeParam) ReadField5(iprot thrift.TProtocol) error {
	_field := NewLLMParam()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.LlmParam = _field
	return nil
}
func (p *NodeParam) ReadField6(iprot thrift.TProtocol) error {
	_field := NewDatasetParam()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.DatasetParam = _field
	return nil
}
func (p *NodeParam) ReadField7(iprot thrift.TProtocol) error {
	_field := NewTerminatePlan()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.TerminatePlan = _field
	return nil
}
func (p *NodeParam) ReadField8(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Parameter, 0, size)
	values := make([]Parameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.InputParameters = _field
	return nil
}
func (p *NodeParam) ReadField9(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Parameter, 0, size)
	values := make([]Parameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.OutputParameters = _field
	return nil
}
func (p *NodeParam) ReadField10(iprot thrift.TProtocol) error {
	_field := NewBatch()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Batch = _field
	return nil
}
func (p *NodeParam) ReadField11(iprot thrift.TProtocol) error {
	_field := NewIfParam()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.IfParam = _field
	return nil
}

func (p *NodeParam) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("NodeParam"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *NodeParam) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetInputList() {
		if err = oprot.WriteFieldBegin("input_list", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.InputList)); err != nil {
			return err
		}
		for _, v := range p.InputList {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *NodeParam) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetOutputList() {
		if err = oprot.WriteFieldBegin("output_list", thrift.LIST, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.OutputList)); err != nil {
			return err
		}
		for _, v := range p.OutputList {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *NodeParam) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetAPIParam() {
		if err = oprot.WriteFieldBegin("api_param", thrift.STRUCT, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.APIParam.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *NodeParam) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetCodeParam() {
		if err = oprot.WriteFieldBegin("code_param", thrift.STRUCT, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.CodeParam.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *NodeParam) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetLlmParam() {
		if err = oprot.WriteFieldBegin("llm_param", thrift.STRUCT, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.LlmParam.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *NodeParam) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetDatasetParam() {
		if err = oprot.WriteFieldBegin("dataset_param", thrift.STRUCT, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.DatasetParam.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *NodeParam) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetTerminatePlan() {
		if err = oprot.WriteFieldBegin("terminate_plan", thrift.STRUCT, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.TerminatePlan.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *NodeParam) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetInputParameters() {
		if err = oprot.WriteFieldBegin("input_parameters", thrift.LIST, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.InputParameters)); err != nil {
			return err
		}
		for _, v := range p.InputParameters {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *NodeParam) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetOutputParameters() {
		if err = oprot.WriteFieldBegin("output_parameters", thrift.LIST, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.OutputParameters)); err != nil {
			return err
		}
		for _, v := range p.OutputParameters {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *NodeParam) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetBatch() {
		if err = oprot.WriteFieldBegin("batch", thrift.STRUCT, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Batch.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *NodeParam) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetIfParam() {
		if err = oprot.WriteFieldBegin("if_param", thrift.STRUCT, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.IfParam.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}

func (p *NodeParam) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeParam(%+v)", *p)

}

type NodeDesc struct {
	Desc string `thrift:"desc,1" form:"desc" json:"desc" query:"desc"`
	// Subtitle name
	Name string `thrift:"name,2" form:"name" json:"name" query:"name"`
	// This type of icon
	IconURL string `thrift:"icon_url,3" form:"icon_url" json:"icon_url" query:"icon_url"`
	// Whether to support batch, 1 does not support, 2 supports
	SupportBatch int32 `thrift:"support_batch,4" form:"support_batch" json:"support_batch" query:"support_batch"`
	// Connection requirements 1 or so can be connected 2 only support the right side
	LinkLimit int32 `thrift:"link_limit,5" form:"link_limit" json:"link_limit" query:"link_limit"`
}

func NewNodeDesc() *NodeDesc {
	return &NodeDesc{}
}

func (p *NodeDesc) InitDefault() {
}

func (p *NodeDesc) GetDesc() (v string) {
	return p.Desc
}

func (p *NodeDesc) GetName() (v string) {
	return p.Name
}

func (p *NodeDesc) GetIconURL() (v string) {
	return p.IconURL
}

func (p *NodeDesc) GetSupportBatch() (v int32) {
	return p.SupportBatch
}

func (p *NodeDesc) GetLinkLimit() (v int32) {
	return p.LinkLimit
}

var fieldIDToName_NodeDesc = map[int16]string{
	1: "desc",
	2: "name",
	3: "icon_url",
	4: "support_batch",
	5: "link_limit",
}

func (p *NodeDesc) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_NodeDesc[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *NodeDesc) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *NodeDesc) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *NodeDesc) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURL = _field
	return nil
}
func (p *NodeDesc) ReadField4(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SupportBatch = _field
	return nil
}
func (p *NodeDesc) ReadField5(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LinkLimit = _field
	return nil
}

func (p *NodeDesc) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("NodeDesc"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *NodeDesc) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *NodeDesc) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *NodeDesc) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_url", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *NodeDesc) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("support_batch", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.SupportBatch); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *NodeDesc) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("link_limit", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.LinkLimit); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *NodeDesc) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeDesc(%+v)", *p)

}

type OpenAPI struct {
	InputList  []*Parameter `thrift:"input_list,1" form:"input_list" json:"input_list" query:"input_list"`
	OutputList []*Parameter `thrift:"output_list,2" form:"output_list" json:"output_list" query:"output_list"`
}

func NewOpenAPI() *OpenAPI {
	return &OpenAPI{}
}

func (p *OpenAPI) InitDefault() {
}

func (p *OpenAPI) GetInputList() (v []*Parameter) {
	return p.InputList
}

func (p *OpenAPI) GetOutputList() (v []*Parameter) {
	return p.OutputList
}

var fieldIDToName_OpenAPI = map[int16]string{
	1: "input_list",
	2: "output_list",
}

func (p *OpenAPI) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_OpenAPI[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *OpenAPI) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Parameter, 0, size)
	values := make([]Parameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.InputList = _field
	return nil
}
func (p *OpenAPI) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Parameter, 0, size)
	values := make([]Parameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.OutputList = _field
	return nil
}

func (p *OpenAPI) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OpenAPI"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *OpenAPI) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("input_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.InputList)); err != nil {
		return err
	}
	for _, v := range p.InputList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *OpenAPI) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("output_list", thrift.LIST, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.OutputList)); err != nil {
		return err
	}
	for _, v := range p.OutputList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *OpenAPI) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("OpenAPI(%+v)", *p)

}

type Batch struct {
	// Is the batch switch on?
	IsBatch bool `thrift:"is_batch,1" form:"is_batch" json:"is_batch" query:"is_batch"`
	// Only process input in the range [0, take_count)
	TakeCount int64 `thrift:"take_count,2" form:"take_count" json:"take_count" query:"take_count"`
	// Batch input required
	InputParam *Parameter `thrift:"input_param,3" form:"input_param" json:"input_param" query:"input_param"`
}

func NewBatch() *Batch {
	return &Batch{}
}

func (p *Batch) InitDefault() {
}

func (p *Batch) GetIsBatch() (v bool) {
	return p.IsBatch
}

func (p *Batch) GetTakeCount() (v int64) {
	return p.TakeCount
}

var Batch_InputParam_DEFAULT *Parameter

func (p *Batch) GetInputParam() (v *Parameter) {
	if !p.IsSetInputParam() {
		return Batch_InputParam_DEFAULT
	}
	return p.InputParam
}

var fieldIDToName_Batch = map[int16]string{
	1: "is_batch",
	2: "take_count",
	3: "input_param",
}

func (p *Batch) IsSetInputParam() bool {
	return p.InputParam != nil
}

func (p *Batch) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Batch[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Batch) ReadField1(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsBatch = _field
	return nil
}
func (p *Batch) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TakeCount = _field
	return nil
}
func (p *Batch) ReadField3(iprot thrift.TProtocol) error {
	_field := NewParameter()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.InputParam = _field
	return nil
}

func (p *Batch) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Batch"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Batch) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_batch", thrift.BOOL, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsBatch); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Batch) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("take_count", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.TakeCount); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Batch) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("input_param", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.InputParam.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *Batch) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Batch(%+v)", *p)

}

type Node struct {
	WorkflowID string `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	// Node ID
	NodeID string `thrift:"node_id,2" form:"node_id" json:"node_id" query:"node_id"`
	// Change node name
	NodeName string `thrift:"node_name,3" form:"node_name" json:"node_name" query:"node_name"`
	// Node type
	NodeType NodeType `thrift:"node_type,4" form:"node_type" json:"node_type" query:"node_type"`
	// Core parameters of the node
	NodeParam *NodeParam `thrift:"node_param,5" form:"node_param" json:"node_param" query:"node_param"`
	// Node location
	LayOut *LayOut `thrift:"lay_out,6" form:"lay_out" json:"lay_out" query:"lay_out"`
	// Description of Node, explaining the link
	Desc *NodeDesc `thrift:"desc,7" form:"desc" json:"desc" query:"desc"`
	// dependent upstream node
	DependsOn []string `thrift:"depends_on,8" form:"depends_on" json:"depends_on" query:"depends_on"`
	// All inputs and outputs
	OpenAPI *OpenAPI `thrift:"open_api,9" form:"open_api" json:"open_api" query:"open_api"`
}

func NewNode() *Node {
	return &Node{}
}

func (p *Node) InitDefault() {
}

func (p *Node) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *Node) GetNodeID() (v string) {
	return p.NodeID
}

func (p *Node) GetNodeName() (v string) {
	return p.NodeName
}

func (p *Node) GetNodeType() (v NodeType) {
	return p.NodeType
}

var Node_NodeParam_DEFAULT *NodeParam

func (p *Node) GetNodeParam() (v *NodeParam) {
	if !p.IsSetNodeParam() {
		return Node_NodeParam_DEFAULT
	}
	return p.NodeParam
}

var Node_LayOut_DEFAULT *LayOut

func (p *Node) GetLayOut() (v *LayOut) {
	if !p.IsSetLayOut() {
		return Node_LayOut_DEFAULT
	}
	return p.LayOut
}

var Node_Desc_DEFAULT *NodeDesc

func (p *Node) GetDesc() (v *NodeDesc) {
	if !p.IsSetDesc() {
		return Node_Desc_DEFAULT
	}
	return p.Desc
}

func (p *Node) GetDependsOn() (v []string) {
	return p.DependsOn
}

var Node_OpenAPI_DEFAULT *OpenAPI

func (p *Node) GetOpenAPI() (v *OpenAPI) {
	if !p.IsSetOpenAPI() {
		return Node_OpenAPI_DEFAULT
	}
	return p.OpenAPI
}

var fieldIDToName_Node = map[int16]string{
	1: "workflow_id",
	2: "node_id",
	3: "node_name",
	4: "node_type",
	5: "node_param",
	6: "lay_out",
	7: "desc",
	8: "depends_on",
	9: "open_api",
}

func (p *Node) IsSetNodeParam() bool {
	return p.NodeParam != nil
}

func (p *Node) IsSetLayOut() bool {
	return p.LayOut != nil
}

func (p *Node) IsSetDesc() bool {
	return p.Desc != nil
}

func (p *Node) IsSetOpenAPI() bool {
	return p.OpenAPI != nil
}

func (p *Node) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Node[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Node) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *Node) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.NodeID = _field
	return nil
}
func (p *Node) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.NodeName = _field
	return nil
}
func (p *Node) ReadField4(iprot thrift.TProtocol) error {

	var _field NodeType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = NodeType(v)
	}
	p.NodeType = _field
	return nil
}
func (p *Node) ReadField5(iprot thrift.TProtocol) error {
	_field := NewNodeParam()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.NodeParam = _field
	return nil
}
func (p *Node) ReadField6(iprot thrift.TProtocol) error {
	_field := NewLayOut()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.LayOut = _field
	return nil
}
func (p *Node) ReadField7(iprot thrift.TProtocol) error {
	_field := NewNodeDesc()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Desc = _field
	return nil
}
func (p *Node) ReadField8(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.DependsOn = _field
	return nil
}
func (p *Node) ReadField9(iprot thrift.TProtocol) error {
	_field := NewOpenAPI()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.OpenAPI = _field
	return nil
}

func (p *Node) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Node"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Node) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Node) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("node_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.NodeID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Node) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("node_name", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.NodeName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Node) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("node_type", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.NodeType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Node) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("node_param", thrift.STRUCT, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.NodeParam.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Node) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("lay_out", thrift.STRUCT, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.LayOut.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *Node) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRUCT, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Desc.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *Node) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("depends_on", thrift.LIST, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.DependsOn)); err != nil {
		return err
	}
	for _, v := range p.DependsOn {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *Node) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("open_api", thrift.STRUCT, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.OpenAPI.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}

func (p *Node) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Node(%+v)", *p)

}

type Parameter struct {
	Name          string       `thrift:"name,1" form:"name" json:"name" query:"name"`
	Desc          string       `thrift:"desc,2" form:"desc" json:"desc" query:"desc"`
	Required      bool         `thrift:"required,3" form:"required" json:"required" query:"required"`
	Type          InputType    `thrift:"type,4" form:"type" json:"type" query:"type"`
	SubParameters []*Parameter `thrift:"sub_parameters,5" form:"sub_parameters" json:"sub_parameters" query:"sub_parameters"`
	// If Type is an array, there is a subtype
	SubType InputType `thrift:"sub_type,6" form:"sub_type" json:"sub_type" query:"sub_type"`
	// fromNodeId if the value of the imported parameter is a reference
	FromNodeID *string `thrift:"from_node_id,7,optional" form:"from_node_id" json:"from_node_id,omitempty" query:"from_node_id"`
	// Which node's key is specifically referenced?
	FromOutput []string `thrift:"from_output,8,optional" form:"from_output" json:"from_output,omitempty" query:"from_output"`
	// If the imported parameter is the user's hand input, put it here
	Value  *string                `thrift:"value,9,optional" form:"value" json:"value,omitempty" query:"value"`
	Format *PluginParamTypeFormat `thrift:"format,10,optional" form:"format" json:"format,omitempty" query:"format"`
	// Auxiliary type; type = string takes effect, 0 is unset
	AssistType *int64 `thrift:"assist_type,11,optional" form:"assist_type" json:"assist_type,omitempty" query:"assist_type"`
	// If Type is an array, it represents the auxiliary type of the child element; sub_type = string takes effect, 0 is unset
	SubAssistType *int64 `thrift:"sub_assist_type,12,optional" form:"sub_assist_type" json:"sub_assist_type,omitempty" query:"sub_assist_type"`
}

func NewParameter() *Parameter {
	return &Parameter{}
}

func (p *Parameter) InitDefault() {
}

func (p *Parameter) GetName() (v string) {
	return p.Name
}

func (p *Parameter) GetDesc() (v string) {
	return p.Desc
}

func (p *Parameter) GetRequired() (v bool) {
	return p.Required
}

func (p *Parameter) GetType() (v InputType) {
	return p.Type
}

func (p *Parameter) GetSubParameters() (v []*Parameter) {
	return p.SubParameters
}

func (p *Parameter) GetSubType() (v InputType) {
	return p.SubType
}

var Parameter_FromNodeID_DEFAULT string

func (p *Parameter) GetFromNodeID() (v string) {
	if !p.IsSetFromNodeID() {
		return Parameter_FromNodeID_DEFAULT
	}
	return *p.FromNodeID
}

var Parameter_FromOutput_DEFAULT []string

func (p *Parameter) GetFromOutput() (v []string) {
	if !p.IsSetFromOutput() {
		return Parameter_FromOutput_DEFAULT
	}
	return p.FromOutput
}

var Parameter_Value_DEFAULT string

func (p *Parameter) GetValue() (v string) {
	if !p.IsSetValue() {
		return Parameter_Value_DEFAULT
	}
	return *p.Value
}

var Parameter_Format_DEFAULT PluginParamTypeFormat

func (p *Parameter) GetFormat() (v PluginParamTypeFormat) {
	if !p.IsSetFormat() {
		return Parameter_Format_DEFAULT
	}
	return *p.Format
}

var Parameter_AssistType_DEFAULT int64

func (p *Parameter) GetAssistType() (v int64) {
	if !p.IsSetAssistType() {
		return Parameter_AssistType_DEFAULT
	}
	return *p.AssistType
}

var Parameter_SubAssistType_DEFAULT int64

func (p *Parameter) GetSubAssistType() (v int64) {
	if !p.IsSetSubAssistType() {
		return Parameter_SubAssistType_DEFAULT
	}
	return *p.SubAssistType
}

var fieldIDToName_Parameter = map[int16]string{
	1:  "name",
	2:  "desc",
	3:  "required",
	4:  "type",
	5:  "sub_parameters",
	6:  "sub_type",
	7:  "from_node_id",
	8:  "from_output",
	9:  "value",
	10: "format",
	11: "assist_type",
	12: "sub_assist_type",
}

func (p *Parameter) IsSetFromNodeID() bool {
	return p.FromNodeID != nil
}

func (p *Parameter) IsSetFromOutput() bool {
	return p.FromOutput != nil
}

func (p *Parameter) IsSetValue() bool {
	return p.Value != nil
}

func (p *Parameter) IsSetFormat() bool {
	return p.Format != nil
}

func (p *Parameter) IsSetAssistType() bool {
	return p.AssistType != nil
}

func (p *Parameter) IsSetSubAssistType() bool {
	return p.SubAssistType != nil
}

func (p *Parameter) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_Parameter[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *Parameter) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *Parameter) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *Parameter) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Required = _field
	return nil
}
func (p *Parameter) ReadField4(iprot thrift.TProtocol) error {

	var _field InputType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = InputType(v)
	}
	p.Type = _field
	return nil
}
func (p *Parameter) ReadField5(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Parameter, 0, size)
	values := make([]Parameter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubParameters = _field
	return nil
}
func (p *Parameter) ReadField6(iprot thrift.TProtocol) error {

	var _field InputType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = InputType(v)
	}
	p.SubType = _field
	return nil
}
func (p *Parameter) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.FromNodeID = _field
	return nil
}
func (p *Parameter) ReadField8(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.FromOutput = _field
	return nil
}
func (p *Parameter) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Value = _field
	return nil
}
func (p *Parameter) ReadField10(iprot thrift.TProtocol) error {

	var _field *PluginParamTypeFormat
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := PluginParamTypeFormat(v)
		_field = &tmp
	}
	p.Format = _field
	return nil
}
func (p *Parameter) ReadField11(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.AssistType = _field
	return nil
}
func (p *Parameter) ReadField12(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SubAssistType = _field
	return nil
}

func (p *Parameter) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("Parameter"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *Parameter) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *Parameter) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *Parameter) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("required", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Required); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *Parameter) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *Parameter) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("sub_parameters", thrift.LIST, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.SubParameters)); err != nil {
		return err
	}
	for _, v := range p.SubParameters {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *Parameter) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("sub_type", thrift.I32, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SubType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *Parameter) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetFromNodeID() {
		if err = oprot.WriteFieldBegin("from_node_id", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.FromNodeID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *Parameter) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetFromOutput() {
		if err = oprot.WriteFieldBegin("from_output", thrift.LIST, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.FromOutput)); err != nil {
			return err
		}
		for _, v := range p.FromOutput {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *Parameter) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetValue() {
		if err = oprot.WriteFieldBegin("value", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Value); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *Parameter) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetFormat() {
		if err = oprot.WriteFieldBegin("format", thrift.I32, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Format)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *Parameter) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetAssistType() {
		if err = oprot.WriteFieldBegin("assist_type", thrift.I64, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.AssistType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *Parameter) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubAssistType() {
		if err = oprot.WriteFieldBegin("sub_assist_type", thrift.I64, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.SubAssistType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}

func (p *Parameter) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("Parameter(%+v)", *p)

}

type CreateWorkflowRequest struct {
	// process name
	Name string `thrift:"name,1,required" form:"name,required" json:"name,required" query:"name,required"`
	// Process description, not null
	Desc string `thrift:"desc,2,required" form:"desc,required" json:"desc,required" query:"desc,required"`
	// Process icon uri, not nullable
	IconURI string `thrift:"icon_uri,3,required" form:"icon_uri,required" json:"icon_uri,required" query:"icon_uri,required"`
	// Space id, cannot be empty
	SpaceID string `thrift:"space_id,4,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	// Workflow or chatflow, the default is workflow
	FlowMode   *WorkflowMode `thrift:"flow_mode,5,optional" form:"flow_mode" json:"flow_mode,omitempty" query:"flow_mode"`
	SchemaType *SchemaType   `thrift:"schema_type,6,optional" form:"schema_type" json:"schema_type,omitempty" query:"schema_type"`
	BindBizID  *string       `thrift:"bind_biz_id,7,optional" form:"bind_biz_id" json:"bind_biz_id,omitempty" query:"bind_biz_id"`
	// Bind the business type, do not fill in if necessary. Refer to the BindBizType structure, when the value is 3, it represents the Douyin doppelganger.
	BindBizType *int32 `thrift:"bind_biz_type,8,optional" form:"bind_biz_type" json:"bind_biz_type,omitempty" query:"bind_biz_type"`
	// Application id, when filled in, it means that the process is the process under the project, and it needs to be released with the project.
	ProjectID *string `thrift:"project_id,9,optional" form:"project_id" json:"project_id,omitempty" query:"project_id"`
	// Whether to create a session, only if flow_mode = chatflow
	CreateConversation *bool      `thrift:"create_conversation,10,optional" form:"create_conversation" json:"create_conversation,omitempty" query:"create_conversation"`
	Base               *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewCreateWorkflowRequest() *CreateWorkflowRequest {
	return &CreateWorkflowRequest{}
}

func (p *CreateWorkflowRequest) InitDefault() {
}

func (p *CreateWorkflowRequest) GetName() (v string) {
	return p.Name
}

func (p *CreateWorkflowRequest) GetDesc() (v string) {
	return p.Desc
}

func (p *CreateWorkflowRequest) GetIconURI() (v string) {
	return p.IconURI
}

func (p *CreateWorkflowRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var CreateWorkflowRequest_FlowMode_DEFAULT WorkflowMode

func (p *CreateWorkflowRequest) GetFlowMode() (v WorkflowMode) {
	if !p.IsSetFlowMode() {
		return CreateWorkflowRequest_FlowMode_DEFAULT
	}
	return *p.FlowMode
}

var CreateWorkflowRequest_SchemaType_DEFAULT SchemaType

func (p *CreateWorkflowRequest) GetSchemaType() (v SchemaType) {
	if !p.IsSetSchemaType() {
		return CreateWorkflowRequest_SchemaType_DEFAULT
	}
	return *p.SchemaType
}

var CreateWorkflowRequest_BindBizID_DEFAULT string

func (p *CreateWorkflowRequest) GetBindBizID() (v string) {
	if !p.IsSetBindBizID() {
		return CreateWorkflowRequest_BindBizID_DEFAULT
	}
	return *p.BindBizID
}

var CreateWorkflowRequest_BindBizType_DEFAULT int32

func (p *CreateWorkflowRequest) GetBindBizType() (v int32) {
	if !p.IsSetBindBizType() {
		return CreateWorkflowRequest_BindBizType_DEFAULT
	}
	return *p.BindBizType
}

var CreateWorkflowRequest_ProjectID_DEFAULT string

func (p *CreateWorkflowRequest) GetProjectID() (v string) {
	if !p.IsSetProjectID() {
		return CreateWorkflowRequest_ProjectID_DEFAULT
	}
	return *p.ProjectID
}

var CreateWorkflowRequest_CreateConversation_DEFAULT bool

func (p *CreateWorkflowRequest) GetCreateConversation() (v bool) {
	if !p.IsSetCreateConversation() {
		return CreateWorkflowRequest_CreateConversation_DEFAULT
	}
	return *p.CreateConversation
}

var CreateWorkflowRequest_Base_DEFAULT *base.Base

func (p *CreateWorkflowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return CreateWorkflowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_CreateWorkflowRequest = map[int16]string{
	1:   "name",
	2:   "desc",
	3:   "icon_uri",
	4:   "space_id",
	5:   "flow_mode",
	6:   "schema_type",
	7:   "bind_biz_id",
	8:   "bind_biz_type",
	9:   "project_id",
	10:  "create_conversation",
	255: "Base",
}

func (p *CreateWorkflowRequest) IsSetFlowMode() bool {
	return p.FlowMode != nil
}

func (p *CreateWorkflowRequest) IsSetSchemaType() bool {
	return p.SchemaType != nil
}

func (p *CreateWorkflowRequest) IsSetBindBizID() bool {
	return p.BindBizID != nil
}

func (p *CreateWorkflowRequest) IsSetBindBizType() bool {
	return p.BindBizType != nil
}

func (p *CreateWorkflowRequest) IsSetProjectID() bool {
	return p.ProjectID != nil
}

func (p *CreateWorkflowRequest) IsSetCreateConversation() bool {
	return p.CreateConversation != nil
}

func (p *CreateWorkflowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *CreateWorkflowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetName bool = false
	var issetDesc bool = false
	var issetIconURI bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetName = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetDesc = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetIconURI = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetName {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetDesc {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetIconURI {
		fieldId = 3
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 4
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CreateWorkflowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CreateWorkflowRequest[fieldId]))
}

func (p *CreateWorkflowRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURI = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkflowMode(v)
		_field = &tmp
	}
	p.FlowMode = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *SchemaType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := SchemaType(v)
		_field = &tmp
	}
	p.SchemaType = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BindBizID = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BindBizType = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProjectID = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField10(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CreateConversation = _field
	return nil
}
func (p *CreateWorkflowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *CreateWorkflowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateWorkflowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CreateWorkflowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetFlowMode() {
		if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.FlowMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetSchemaType() {
		if err = oprot.WriteFieldBegin("schema_type", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.SchemaType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizID() {
		if err = oprot.WriteFieldBegin("bind_biz_id", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BindBizID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizType() {
		if err = oprot.WriteFieldBegin("bind_biz_type", thrift.I32, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.BindBizType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectID() {
		if err = oprot.WriteFieldBegin("project_id", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProjectID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetCreateConversation() {
		if err = oprot.WriteFieldBegin("create_conversation", thrift.BOOL, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.CreateConversation); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *CreateWorkflowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CreateWorkflowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CreateWorkflowRequest(%+v)", *p)

}

type CreateWorkflowData struct {
	// The ID of the process, used to identify a unique process
	WorkflowID string `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	// process name
	Name     string         `thrift:"name,2" form:"name" json:"name" query:"name"`
	URL      string         `thrift:"url,3" form:"url" json:"url" query:"url"`
	Status   WorkFlowStatus `thrift:"status,4" form:"status" json:"status" query:"status"`
	Type     SchemaType     `thrift:"type,5" form:"type" json:"type" query:"type"`
	NodeList []*Node        `thrift:"node_list,6" form:"node_list" json:"node_list" query:"node_list"`
	// {"project_id":"xxx","flow_id":xxxx}
	ExternalFlowInfo *string `thrift:"external_flow_info,7,optional" form:"external_flow_info" json:"external_flow_info,omitempty" query:"external_flow_info"`
}

func NewCreateWorkflowData() *CreateWorkflowData {
	return &CreateWorkflowData{}
}

func (p *CreateWorkflowData) InitDefault() {
}

func (p *CreateWorkflowData) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *CreateWorkflowData) GetName() (v string) {
	return p.Name
}

func (p *CreateWorkflowData) GetURL() (v string) {
	return p.URL
}

func (p *CreateWorkflowData) GetStatus() (v WorkFlowStatus) {
	return p.Status
}

func (p *CreateWorkflowData) GetType() (v SchemaType) {
	return p.Type
}

func (p *CreateWorkflowData) GetNodeList() (v []*Node) {
	return p.NodeList
}

var CreateWorkflowData_ExternalFlowInfo_DEFAULT string

func (p *CreateWorkflowData) GetExternalFlowInfo() (v string) {
	if !p.IsSetExternalFlowInfo() {
		return CreateWorkflowData_ExternalFlowInfo_DEFAULT
	}
	return *p.ExternalFlowInfo
}

var fieldIDToName_CreateWorkflowData = map[int16]string{
	1: "workflow_id",
	2: "name",
	3: "url",
	4: "status",
	5: "type",
	6: "node_list",
	7: "external_flow_info",
}

func (p *CreateWorkflowData) IsSetExternalFlowInfo() bool {
	return p.ExternalFlowInfo != nil
}

func (p *CreateWorkflowData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CreateWorkflowData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CreateWorkflowData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *CreateWorkflowData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *CreateWorkflowData) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *CreateWorkflowData) ReadField4(iprot thrift.TProtocol) error {

	var _field WorkFlowStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowStatus(v)
	}
	p.Status = _field
	return nil
}
func (p *CreateWorkflowData) ReadField5(iprot thrift.TProtocol) error {

	var _field SchemaType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = SchemaType(v)
	}
	p.Type = _field
	return nil
}
func (p *CreateWorkflowData) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Node, 0, size)
	values := make([]Node, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.NodeList = _field
	return nil
}
func (p *CreateWorkflowData) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ExternalFlowInfo = _field
	return nil
}

func (p *CreateWorkflowData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateWorkflowData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CreateWorkflowData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CreateWorkflowData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CreateWorkflowData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *CreateWorkflowData) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("status", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *CreateWorkflowData) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *CreateWorkflowData) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("node_list", thrift.LIST, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.NodeList)); err != nil {
		return err
	}
	for _, v := range p.NodeList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *CreateWorkflowData) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetExternalFlowInfo() {
		if err = oprot.WriteFieldBegin("external_flow_info", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ExternalFlowInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}

func (p *CreateWorkflowData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CreateWorkflowData(%+v)", *p)

}

type CreateWorkflowResponse struct {
	Data     *CreateWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64               `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string              `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp      `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewCreateWorkflowResponse() *CreateWorkflowResponse {
	return &CreateWorkflowResponse{}
}

func (p *CreateWorkflowResponse) InitDefault() {
}

var CreateWorkflowResponse_Data_DEFAULT *CreateWorkflowData

func (p *CreateWorkflowResponse) GetData() (v *CreateWorkflowData) {
	if !p.IsSetData() {
		return CreateWorkflowResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *CreateWorkflowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *CreateWorkflowResponse) GetMsg() (v string) {
	return p.Msg
}

var CreateWorkflowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *CreateWorkflowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return CreateWorkflowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_CreateWorkflowResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *CreateWorkflowResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *CreateWorkflowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *CreateWorkflowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CreateWorkflowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CreateWorkflowResponse[fieldId]))
}

func (p *CreateWorkflowResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCreateWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *CreateWorkflowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *CreateWorkflowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *CreateWorkflowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *CreateWorkflowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CreateWorkflowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CreateWorkflowResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CreateWorkflowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *CreateWorkflowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *CreateWorkflowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CreateWorkflowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CreateWorkflowResponse(%+v)", *p)

}

type SaveWorkflowRequest struct {
	// The ID of the process, used to identify a unique process
	WorkflowID string `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	// Process schema
	Schema *string `thrift:"schema,2,optional" form:"schema" json:"schema,omitempty" query:"schema"`
	// Required, space id, not nullable
	SpaceID *string `thrift:"space_id,3,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	Name    *string `thrift:"name,4,optional" form:"name" json:"name,omitempty" query:"name"`
	Desc    *string `thrift:"desc,5,optional" form:"desc" json:"desc,omitempty" query:"desc"`
	IconURI *string `thrift:"icon_uri,6,optional" form:"icon_uri" json:"icon_uri,omitempty" query:"icon_uri"`
	// The commit_id of a commit. This is used to uniquely identify individual commit versions of a process (each commit_id corresponds only and only to one commit version of a process).
	SubmitCommitID       string     `thrift:"submit_commit_id,7,required" form:"submit_commit_id,required" json:"submit_commit_id,required" query:"submit_commit_id,required"`
	IgnoreStatusTransfer *bool      `thrift:"ignore_status_transfer,8,optional" form:"ignore_status_transfer" json:"ignore_status_transfer,omitempty" query:"ignore_status_transfer"`
	Base                 *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewSaveWorkflowRequest() *SaveWorkflowRequest {
	return &SaveWorkflowRequest{}
}

func (p *SaveWorkflowRequest) InitDefault() {
}

func (p *SaveWorkflowRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

var SaveWorkflowRequest_Schema_DEFAULT string

func (p *SaveWorkflowRequest) GetSchema() (v string) {
	if !p.IsSetSchema() {
		return SaveWorkflowRequest_Schema_DEFAULT
	}
	return *p.Schema
}

var SaveWorkflowRequest_SpaceID_DEFAULT string

func (p *SaveWorkflowRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return SaveWorkflowRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var SaveWorkflowRequest_Name_DEFAULT string

func (p *SaveWorkflowRequest) GetName() (v string) {
	if !p.IsSetName() {
		return SaveWorkflowRequest_Name_DEFAULT
	}
	return *p.Name
}

var SaveWorkflowRequest_Desc_DEFAULT string

func (p *SaveWorkflowRequest) GetDesc() (v string) {
	if !p.IsSetDesc() {
		return SaveWorkflowRequest_Desc_DEFAULT
	}
	return *p.Desc
}

var SaveWorkflowRequest_IconURI_DEFAULT string

func (p *SaveWorkflowRequest) GetIconURI() (v string) {
	if !p.IsSetIconURI() {
		return SaveWorkflowRequest_IconURI_DEFAULT
	}
	return *p.IconURI
}

func (p *SaveWorkflowRequest) GetSubmitCommitID() (v string) {
	return p.SubmitCommitID
}

var SaveWorkflowRequest_IgnoreStatusTransfer_DEFAULT bool

func (p *SaveWorkflowRequest) GetIgnoreStatusTransfer() (v bool) {
	if !p.IsSetIgnoreStatusTransfer() {
		return SaveWorkflowRequest_IgnoreStatusTransfer_DEFAULT
	}
	return *p.IgnoreStatusTransfer
}

var SaveWorkflowRequest_Base_DEFAULT *base.Base

func (p *SaveWorkflowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return SaveWorkflowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_SaveWorkflowRequest = map[int16]string{
	1:   "workflow_id",
	2:   "schema",
	3:   "space_id",
	4:   "name",
	5:   "desc",
	6:   "icon_uri",
	7:   "submit_commit_id",
	8:   "ignore_status_transfer",
	255: "Base",
}

func (p *SaveWorkflowRequest) IsSetSchema() bool {
	return p.Schema != nil
}

func (p *SaveWorkflowRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *SaveWorkflowRequest) IsSetName() bool {
	return p.Name != nil
}

func (p *SaveWorkflowRequest) IsSetDesc() bool {
	return p.Desc != nil
}

func (p *SaveWorkflowRequest) IsSetIconURI() bool {
	return p.IconURI != nil
}

func (p *SaveWorkflowRequest) IsSetIgnoreStatusTransfer() bool {
	return p.IgnoreStatusTransfer != nil
}

func (p *SaveWorkflowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *SaveWorkflowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSubmitCommitID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
				issetSubmitCommitID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSubmitCommitID {
		fieldId = 7
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SaveWorkflowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_SaveWorkflowRequest[fieldId]))
}

func (p *SaveWorkflowRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Schema = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Desc = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IconURI = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SubmitCommitID = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IgnoreStatusTransfer = _field
	return nil
}
func (p *SaveWorkflowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *SaveWorkflowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SaveWorkflowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SaveWorkflowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSchema() {
		if err = oprot.WriteFieldBegin("schema", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Schema); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetDesc() {
		if err = oprot.WriteFieldBegin("desc", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Desc); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetIconURI() {
		if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IconURI); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("submit_commit_id", thrift.STRING, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SubmitCommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetIgnoreStatusTransfer() {
		if err = oprot.WriteFieldBegin("ignore_status_transfer", thrift.BOOL, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IgnoreStatusTransfer); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *SaveWorkflowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *SaveWorkflowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SaveWorkflowRequest(%+v)", *p)

}

type SaveWorkflowData struct {
	Name           string            `thrift:"name,1" form:"name" json:"name" query:"name"`
	URL            string            `thrift:"url,2" form:"url" json:"url" query:"url"`
	Status         WorkFlowDevStatus `thrift:"status,3" form:"status" json:"status" query:"status"`
	WorkflowStatus WorkFlowStatus    `thrift:"workflow_status,4" form:"workflow_status" json:"workflow_status" query:"workflow_status"`
}

func NewSaveWorkflowData() *SaveWorkflowData {
	return &SaveWorkflowData{}
}

func (p *SaveWorkflowData) InitDefault() {
}

func (p *SaveWorkflowData) GetName() (v string) {
	return p.Name
}

func (p *SaveWorkflowData) GetURL() (v string) {
	return p.URL
}

func (p *SaveWorkflowData) GetStatus() (v WorkFlowDevStatus) {
	return p.Status
}

func (p *SaveWorkflowData) GetWorkflowStatus() (v WorkFlowStatus) {
	return p.WorkflowStatus
}

var fieldIDToName_SaveWorkflowData = map[int16]string{
	1: "name",
	2: "url",
	3: "status",
	4: "workflow_status",
}

func (p *SaveWorkflowData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SaveWorkflowData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SaveWorkflowData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *SaveWorkflowData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *SaveWorkflowData) ReadField3(iprot thrift.TProtocol) error {

	var _field WorkFlowDevStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowDevStatus(v)
	}
	p.Status = _field
	return nil
}
func (p *SaveWorkflowData) ReadField4(iprot thrift.TProtocol) error {

	var _field WorkFlowStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowStatus(v)
	}
	p.WorkflowStatus = _field
	return nil
}

func (p *SaveWorkflowData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SaveWorkflowData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SaveWorkflowData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SaveWorkflowData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *SaveWorkflowData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("status", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *SaveWorkflowData) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_status", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.WorkflowStatus)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *SaveWorkflowData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SaveWorkflowData(%+v)", *p)

}

type SaveWorkflowResponse struct {
	Data     *SaveWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64             `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string            `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp    `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewSaveWorkflowResponse() *SaveWorkflowResponse {
	return &SaveWorkflowResponse{}
}

func (p *SaveWorkflowResponse) InitDefault() {
}

var SaveWorkflowResponse_Data_DEFAULT *SaveWorkflowData

func (p *SaveWorkflowResponse) GetData() (v *SaveWorkflowData) {
	if !p.IsSetData() {
		return SaveWorkflowResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *SaveWorkflowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *SaveWorkflowResponse) GetMsg() (v string) {
	return p.Msg
}

var SaveWorkflowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *SaveWorkflowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return SaveWorkflowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_SaveWorkflowResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *SaveWorkflowResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *SaveWorkflowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *SaveWorkflowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SaveWorkflowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_SaveWorkflowResponse[fieldId]))
}

func (p *SaveWorkflowResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewSaveWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *SaveWorkflowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *SaveWorkflowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *SaveWorkflowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *SaveWorkflowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SaveWorkflowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SaveWorkflowResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SaveWorkflowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *SaveWorkflowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *SaveWorkflowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *SaveWorkflowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SaveWorkflowResponse(%+v)", *p)

}

type UpdateWorkflowMetaRequest struct {
	WorkflowID string        `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SpaceID    string        `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	Name       *string       `thrift:"name,3,optional" form:"name" json:"name,omitempty" query:"name"`
	Desc       *string       `thrift:"desc,4,optional" form:"desc" json:"desc,omitempty" query:"desc"`
	IconURI    *string       `thrift:"icon_uri,5,optional" form:"icon_uri" json:"icon_uri,omitempty" query:"icon_uri"`
	FlowMode   *WorkflowMode `thrift:"flow_mode,6,optional" form:"flow_mode" json:"flow_mode,omitempty" query:"flow_mode"`
	Base       *base.Base    `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewUpdateWorkflowMetaRequest() *UpdateWorkflowMetaRequest {
	return &UpdateWorkflowMetaRequest{}
}

func (p *UpdateWorkflowMetaRequest) InitDefault() {
}

func (p *UpdateWorkflowMetaRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *UpdateWorkflowMetaRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var UpdateWorkflowMetaRequest_Name_DEFAULT string

func (p *UpdateWorkflowMetaRequest) GetName() (v string) {
	if !p.IsSetName() {
		return UpdateWorkflowMetaRequest_Name_DEFAULT
	}
	return *p.Name
}

var UpdateWorkflowMetaRequest_Desc_DEFAULT string

func (p *UpdateWorkflowMetaRequest) GetDesc() (v string) {
	if !p.IsSetDesc() {
		return UpdateWorkflowMetaRequest_Desc_DEFAULT
	}
	return *p.Desc
}

var UpdateWorkflowMetaRequest_IconURI_DEFAULT string

func (p *UpdateWorkflowMetaRequest) GetIconURI() (v string) {
	if !p.IsSetIconURI() {
		return UpdateWorkflowMetaRequest_IconURI_DEFAULT
	}
	return *p.IconURI
}

var UpdateWorkflowMetaRequest_FlowMode_DEFAULT WorkflowMode

func (p *UpdateWorkflowMetaRequest) GetFlowMode() (v WorkflowMode) {
	if !p.IsSetFlowMode() {
		return UpdateWorkflowMetaRequest_FlowMode_DEFAULT
	}
	return *p.FlowMode
}

var UpdateWorkflowMetaRequest_Base_DEFAULT *base.Base

func (p *UpdateWorkflowMetaRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return UpdateWorkflowMetaRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_UpdateWorkflowMetaRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	3:   "name",
	4:   "desc",
	5:   "icon_uri",
	6:   "flow_mode",
	255: "Base",
}

func (p *UpdateWorkflowMetaRequest) IsSetName() bool {
	return p.Name != nil
}

func (p *UpdateWorkflowMetaRequest) IsSetDesc() bool {
	return p.Desc != nil
}

func (p *UpdateWorkflowMetaRequest) IsSetIconURI() bool {
	return p.IconURI != nil
}

func (p *UpdateWorkflowMetaRequest) IsSetFlowMode() bool {
	return p.FlowMode != nil
}

func (p *UpdateWorkflowMetaRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *UpdateWorkflowMetaRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateWorkflowMetaRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UpdateWorkflowMetaRequest[fieldId]))
}

func (p *UpdateWorkflowMetaRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *UpdateWorkflowMetaRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *UpdateWorkflowMetaRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *UpdateWorkflowMetaRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Desc = _field
	return nil
}
func (p *UpdateWorkflowMetaRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IconURI = _field
	return nil
}
func (p *UpdateWorkflowMetaRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkflowMode(v)
		_field = &tmp
	}
	p.FlowMode = _field
	return nil
}
func (p *UpdateWorkflowMetaRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *UpdateWorkflowMetaRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateWorkflowMetaRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateWorkflowMetaRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UpdateWorkflowMetaRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UpdateWorkflowMetaRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *UpdateWorkflowMetaRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetDesc() {
		if err = oprot.WriteFieldBegin("desc", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Desc); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *UpdateWorkflowMetaRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetIconURI() {
		if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IconURI); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *UpdateWorkflowMetaRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetFlowMode() {
		if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.FlowMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *UpdateWorkflowMetaRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UpdateWorkflowMetaRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateWorkflowMetaRequest(%+v)", *p)

}

type UpdateWorkflowMetaResponse struct {
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewUpdateWorkflowMetaResponse() *UpdateWorkflowMetaResponse {
	return &UpdateWorkflowMetaResponse{}
}

func (p *UpdateWorkflowMetaResponse) InitDefault() {
}

func (p *UpdateWorkflowMetaResponse) GetCode() (v int64) {
	return p.Code
}

func (p *UpdateWorkflowMetaResponse) GetMsg() (v string) {
	return p.Msg
}

var UpdateWorkflowMetaResponse_BaseResp_DEFAULT *base.BaseResp

func (p *UpdateWorkflowMetaResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return UpdateWorkflowMetaResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_UpdateWorkflowMetaResponse = map[int16]string{
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *UpdateWorkflowMetaResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *UpdateWorkflowMetaResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UpdateWorkflowMetaResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_UpdateWorkflowMetaResponse[fieldId]))
}

func (p *UpdateWorkflowMetaResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *UpdateWorkflowMetaResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *UpdateWorkflowMetaResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *UpdateWorkflowMetaResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UpdateWorkflowMetaResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UpdateWorkflowMetaResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *UpdateWorkflowMetaResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *UpdateWorkflowMetaResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *UpdateWorkflowMetaResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UpdateWorkflowMetaResponse(%+v)", *p)

}

type MergeWorkflowRequest struct {
	WorkflowID     string     `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	Schema         *string    `thrift:"schema,2,optional" form:"schema" json:"schema,omitempty" query:"schema"`
	SpaceID        *string    `thrift:"space_id,3,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	Name           *string    `thrift:"name,4,optional" form:"name" json:"name,omitempty" query:"name"`
	Desc           *string    `thrift:"desc,5,optional" form:"desc" json:"desc,omitempty" query:"desc"`
	IconURI        *string    `thrift:"icon_uri,6,optional" form:"icon_uri" json:"icon_uri,omitempty" query:"icon_uri"`
	SubmitCommitID string     `thrift:"submit_commit_id,7,required" form:"submit_commit_id,required" json:"submit_commit_id,required" query:"submit_commit_id,required"`
	Base           *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewMergeWorkflowRequest() *MergeWorkflowRequest {
	return &MergeWorkflowRequest{}
}

func (p *MergeWorkflowRequest) InitDefault() {
}

func (p *MergeWorkflowRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

var MergeWorkflowRequest_Schema_DEFAULT string

func (p *MergeWorkflowRequest) GetSchema() (v string) {
	if !p.IsSetSchema() {
		return MergeWorkflowRequest_Schema_DEFAULT
	}
	return *p.Schema
}

var MergeWorkflowRequest_SpaceID_DEFAULT string

func (p *MergeWorkflowRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return MergeWorkflowRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var MergeWorkflowRequest_Name_DEFAULT string

func (p *MergeWorkflowRequest) GetName() (v string) {
	if !p.IsSetName() {
		return MergeWorkflowRequest_Name_DEFAULT
	}
	return *p.Name
}

var MergeWorkflowRequest_Desc_DEFAULT string

func (p *MergeWorkflowRequest) GetDesc() (v string) {
	if !p.IsSetDesc() {
		return MergeWorkflowRequest_Desc_DEFAULT
	}
	return *p.Desc
}

var MergeWorkflowRequest_IconURI_DEFAULT string

func (p *MergeWorkflowRequest) GetIconURI() (v string) {
	if !p.IsSetIconURI() {
		return MergeWorkflowRequest_IconURI_DEFAULT
	}
	return *p.IconURI
}

func (p *MergeWorkflowRequest) GetSubmitCommitID() (v string) {
	return p.SubmitCommitID
}

var MergeWorkflowRequest_Base_DEFAULT *base.Base

func (p *MergeWorkflowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return MergeWorkflowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_MergeWorkflowRequest = map[int16]string{
	1:   "workflow_id",
	2:   "schema",
	3:   "space_id",
	4:   "name",
	5:   "desc",
	6:   "icon_uri",
	7:   "submit_commit_id",
	255: "Base",
}

func (p *MergeWorkflowRequest) IsSetSchema() bool {
	return p.Schema != nil
}

func (p *MergeWorkflowRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *MergeWorkflowRequest) IsSetName() bool {
	return p.Name != nil
}

func (p *MergeWorkflowRequest) IsSetDesc() bool {
	return p.Desc != nil
}

func (p *MergeWorkflowRequest) IsSetIconURI() bool {
	return p.IconURI != nil
}

func (p *MergeWorkflowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *MergeWorkflowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSubmitCommitID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
				issetSubmitCommitID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSubmitCommitID {
		fieldId = 7
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_MergeWorkflowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_MergeWorkflowRequest[fieldId]))
}

func (p *MergeWorkflowRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *MergeWorkflowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Schema = _field
	return nil
}
func (p *MergeWorkflowRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *MergeWorkflowRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *MergeWorkflowRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Desc = _field
	return nil
}
func (p *MergeWorkflowRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IconURI = _field
	return nil
}
func (p *MergeWorkflowRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SubmitCommitID = _field
	return nil
}
func (p *MergeWorkflowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *MergeWorkflowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MergeWorkflowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *MergeWorkflowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *MergeWorkflowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSchema() {
		if err = oprot.WriteFieldBegin("schema", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Schema); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *MergeWorkflowRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *MergeWorkflowRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *MergeWorkflowRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetDesc() {
		if err = oprot.WriteFieldBegin("desc", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Desc); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *MergeWorkflowRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetIconURI() {
		if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.IconURI); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *MergeWorkflowRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("submit_commit_id", thrift.STRING, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SubmitCommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *MergeWorkflowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *MergeWorkflowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MergeWorkflowRequest(%+v)", *p)

}

type MergeWorkflowData struct {
	Name   string            `thrift:"name,1" form:"name" json:"name" query:"name"`
	URL    string            `thrift:"url,2" form:"url" json:"url" query:"url"`
	Status WorkFlowDevStatus `thrift:"status,3" form:"status" json:"status" query:"status"`
}

func NewMergeWorkflowData() *MergeWorkflowData {
	return &MergeWorkflowData{}
}

func (p *MergeWorkflowData) InitDefault() {
}

func (p *MergeWorkflowData) GetName() (v string) {
	return p.Name
}

func (p *MergeWorkflowData) GetURL() (v string) {
	return p.URL
}

func (p *MergeWorkflowData) GetStatus() (v WorkFlowDevStatus) {
	return p.Status
}

var fieldIDToName_MergeWorkflowData = map[int16]string{
	1: "name",
	2: "url",
	3: "status",
}

func (p *MergeWorkflowData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_MergeWorkflowData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *MergeWorkflowData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *MergeWorkflowData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *MergeWorkflowData) ReadField3(iprot thrift.TProtocol) error {

	var _field WorkFlowDevStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowDevStatus(v)
	}
	p.Status = _field
	return nil
}

func (p *MergeWorkflowData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MergeWorkflowData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *MergeWorkflowData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *MergeWorkflowData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *MergeWorkflowData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("status", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *MergeWorkflowData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MergeWorkflowData(%+v)", *p)

}

type MergeWorkflowResponse struct {
	Data     *MergeWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64              `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string             `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp     `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewMergeWorkflowResponse() *MergeWorkflowResponse {
	return &MergeWorkflowResponse{}
}

func (p *MergeWorkflowResponse) InitDefault() {
}

var MergeWorkflowResponse_Data_DEFAULT *MergeWorkflowData

func (p *MergeWorkflowResponse) GetData() (v *MergeWorkflowData) {
	if !p.IsSetData() {
		return MergeWorkflowResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *MergeWorkflowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *MergeWorkflowResponse) GetMsg() (v string) {
	return p.Msg
}

var MergeWorkflowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *MergeWorkflowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return MergeWorkflowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_MergeWorkflowResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *MergeWorkflowResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *MergeWorkflowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *MergeWorkflowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_MergeWorkflowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_MergeWorkflowResponse[fieldId]))
}

func (p *MergeWorkflowResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewMergeWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *MergeWorkflowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *MergeWorkflowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *MergeWorkflowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *MergeWorkflowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("MergeWorkflowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *MergeWorkflowResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *MergeWorkflowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *MergeWorkflowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *MergeWorkflowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *MergeWorkflowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("MergeWorkflowResponse(%+v)", *p)

}

type VCSCanvasData struct {
	SubmitCommitID  string        `thrift:"submit_commit_id,1" form:"submit_commit_id" json:"submit_commit_id" query:"submit_commit_id"`
	DraftCommitID   string        `thrift:"draft_commit_id,2" form:"draft_commit_id" json:"draft_commit_id" query:"draft_commit_id"`
	Type            VCSCanvasType `thrift:"type,3" form:"type" json:"type" query:"type"`
	CanEdit         bool          `thrift:"can_edit,4" form:"can_edit" json:"can_edit" query:"can_edit"`
	PublishCommitID *string       `thrift:"publish_commit_id,5,optional" form:"publish_commit_id" json:"publish_commit_id,omitempty" query:"publish_commit_id"`
}

func NewVCSCanvasData() *VCSCanvasData {
	return &VCSCanvasData{}
}

func (p *VCSCanvasData) InitDefault() {
}

func (p *VCSCanvasData) GetSubmitCommitID() (v string) {
	return p.SubmitCommitID
}

func (p *VCSCanvasData) GetDraftCommitID() (v string) {
	return p.DraftCommitID
}

func (p *VCSCanvasData) GetType() (v VCSCanvasType) {
	return p.Type
}

func (p *VCSCanvasData) GetCanEdit() (v bool) {
	return p.CanEdit
}

var VCSCanvasData_PublishCommitID_DEFAULT string

func (p *VCSCanvasData) GetPublishCommitID() (v string) {
	if !p.IsSetPublishCommitID() {
		return VCSCanvasData_PublishCommitID_DEFAULT
	}
	return *p.PublishCommitID
}

var fieldIDToName_VCSCanvasData = map[int16]string{
	1: "submit_commit_id",
	2: "draft_commit_id",
	3: "type",
	4: "can_edit",
	5: "publish_commit_id",
}

func (p *VCSCanvasData) IsSetPublishCommitID() bool {
	return p.PublishCommitID != nil
}

func (p *VCSCanvasData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_VCSCanvasData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *VCSCanvasData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SubmitCommitID = _field
	return nil
}
func (p *VCSCanvasData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.DraftCommitID = _field
	return nil
}
func (p *VCSCanvasData) ReadField3(iprot thrift.TProtocol) error {

	var _field VCSCanvasType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = VCSCanvasType(v)
	}
	p.Type = _field
	return nil
}
func (p *VCSCanvasData) ReadField4(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CanEdit = _field
	return nil
}
func (p *VCSCanvasData) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.PublishCommitID = _field
	return nil
}

func (p *VCSCanvasData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("VCSCanvasData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *VCSCanvasData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("submit_commit_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SubmitCommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *VCSCanvasData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("draft_commit_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.DraftCommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *VCSCanvasData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *VCSCanvasData) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("can_edit", thrift.BOOL, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.CanEdit); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *VCSCanvasData) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetPublishCommitID() {
		if err = oprot.WriteFieldBegin("publish_commit_id", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.PublishCommitID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *VCSCanvasData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("VCSCanvasData(%+v)", *p)

}

type DBCanvasData struct {
	Status WorkFlowStatus `thrift:"status,1" form:"status" json:"status" query:"status"`
}

func NewDBCanvasData() *DBCanvasData {
	return &DBCanvasData{}
}

func (p *DBCanvasData) InitDefault() {
}

func (p *DBCanvasData) GetStatus() (v WorkFlowStatus) {
	return p.Status
}

var fieldIDToName_DBCanvasData = map[int16]string{
	1: "status",
}

func (p *DBCanvasData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DBCanvasData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DBCanvasData) ReadField1(iprot thrift.TProtocol) error {

	var _field WorkFlowStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowStatus(v)
	}
	p.Status = _field
	return nil
}

func (p *DBCanvasData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DBCanvasData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DBCanvasData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("status", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DBCanvasData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DBCanvasData(%+v)", *p)

}

type OperationInfo struct {
	Operator     *Creator `thrift:"operator,1" form:"operator" json:"operator" query:"operator"`
	OperatorTime int64    `thrift:"operator_time,2" form:"operator_time" json:"operator_time" query:"operator_time"`
}

func NewOperationInfo() *OperationInfo {
	return &OperationInfo{}
}

func (p *OperationInfo) InitDefault() {
}

var OperationInfo_Operator_DEFAULT *Creator

func (p *OperationInfo) GetOperator() (v *Creator) {
	if !p.IsSetOperator() {
		return OperationInfo_Operator_DEFAULT
	}
	return p.Operator
}

func (p *OperationInfo) GetOperatorTime() (v int64) {
	return p.OperatorTime
}

var fieldIDToName_OperationInfo = map[int16]string{
	1: "operator",
	2: "operator_time",
}

func (p *OperationInfo) IsSetOperator() bool {
	return p.Operator != nil
}

func (p *OperationInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_OperationInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *OperationInfo) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCreator()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Operator = _field
	return nil
}
func (p *OperationInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.OperatorTime = _field
	return nil
}

func (p *OperationInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("OperationInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *OperationInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("operator", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Operator.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *OperationInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("operator_time", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.OperatorTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *OperationInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("OperationInfo(%+v)", *p)

}

type CanvasData struct {
	Workflow         *Workflow      `thrift:"workflow,1" form:"workflow" json:"workflow" query:"workflow"`
	VcsData          *VCSCanvasData `thrift:"vcs_data,2" form:"vcs_data" json:"vcs_data" query:"vcs_data"`
	DbData           *DBCanvasData  `thrift:"db_data,3" form:"db_data" json:"db_data" query:"db_data"`
	OperationInfo    *OperationInfo `thrift:"operation_info,4" form:"operation_info" json:"operation_info" query:"operation_info"`
	ExternalFlowInfo *string        `thrift:"external_flow_info,5,optional" form:"external_flow_info" json:"external_flow_info,omitempty" query:"external_flow_info"`
	// Is the Agent bound?
	IsBindAgent     *bool   `thrift:"is_bind_agent,6,optional" form:"is_bind_agent" json:"is_bind_agent,omitempty" query:"is_bind_agent"`
	BindBizID       *string `thrift:"bind_biz_id,7,optional" form:"bind_biz_id" json:"bind_biz_id,omitempty" query:"bind_biz_id"`
	BindBizType     *int32  `thrift:"bind_biz_type,8,optional" form:"bind_biz_type" json:"bind_biz_type,omitempty" query:"bind_biz_type"`
	WorkflowVersion *string `thrift:"workflow_version,9,optional" form:"workflow_version" json:"workflow_version,omitempty" query:"workflow_version"`
}

func NewCanvasData() *CanvasData {
	return &CanvasData{}
}

func (p *CanvasData) InitDefault() {
}

var CanvasData_Workflow_DEFAULT *Workflow

func (p *CanvasData) GetWorkflow() (v *Workflow) {
	if !p.IsSetWorkflow() {
		return CanvasData_Workflow_DEFAULT
	}
	return p.Workflow
}

var CanvasData_VcsData_DEFAULT *VCSCanvasData

func (p *CanvasData) GetVcsData() (v *VCSCanvasData) {
	if !p.IsSetVcsData() {
		return CanvasData_VcsData_DEFAULT
	}
	return p.VcsData
}

var CanvasData_DbData_DEFAULT *DBCanvasData

func (p *CanvasData) GetDbData() (v *DBCanvasData) {
	if !p.IsSetDbData() {
		return CanvasData_DbData_DEFAULT
	}
	return p.DbData
}

var CanvasData_OperationInfo_DEFAULT *OperationInfo

func (p *CanvasData) GetOperationInfo() (v *OperationInfo) {
	if !p.IsSetOperationInfo() {
		return CanvasData_OperationInfo_DEFAULT
	}
	return p.OperationInfo
}

var CanvasData_ExternalFlowInfo_DEFAULT string

func (p *CanvasData) GetExternalFlowInfo() (v string) {
	if !p.IsSetExternalFlowInfo() {
		return CanvasData_ExternalFlowInfo_DEFAULT
	}
	return *p.ExternalFlowInfo
}

var CanvasData_IsBindAgent_DEFAULT bool

func (p *CanvasData) GetIsBindAgent() (v bool) {
	if !p.IsSetIsBindAgent() {
		return CanvasData_IsBindAgent_DEFAULT
	}
	return *p.IsBindAgent
}

var CanvasData_BindBizID_DEFAULT string

func (p *CanvasData) GetBindBizID() (v string) {
	if !p.IsSetBindBizID() {
		return CanvasData_BindBizID_DEFAULT
	}
	return *p.BindBizID
}

var CanvasData_BindBizType_DEFAULT int32

func (p *CanvasData) GetBindBizType() (v int32) {
	if !p.IsSetBindBizType() {
		return CanvasData_BindBizType_DEFAULT
	}
	return *p.BindBizType
}

var CanvasData_WorkflowVersion_DEFAULT string

func (p *CanvasData) GetWorkflowVersion() (v string) {
	if !p.IsSetWorkflowVersion() {
		return CanvasData_WorkflowVersion_DEFAULT
	}
	return *p.WorkflowVersion
}

var fieldIDToName_CanvasData = map[int16]string{
	1: "workflow",
	2: "vcs_data",
	3: "db_data",
	4: "operation_info",
	5: "external_flow_info",
	6: "is_bind_agent",
	7: "bind_biz_id",
	8: "bind_biz_type",
	9: "workflow_version",
}

func (p *CanvasData) IsSetWorkflow() bool {
	return p.Workflow != nil
}

func (p *CanvasData) IsSetVcsData() bool {
	return p.VcsData != nil
}

func (p *CanvasData) IsSetDbData() bool {
	return p.DbData != nil
}

func (p *CanvasData) IsSetOperationInfo() bool {
	return p.OperationInfo != nil
}

func (p *CanvasData) IsSetExternalFlowInfo() bool {
	return p.ExternalFlowInfo != nil
}

func (p *CanvasData) IsSetIsBindAgent() bool {
	return p.IsBindAgent != nil
}

func (p *CanvasData) IsSetBindBizID() bool {
	return p.BindBizID != nil
}

func (p *CanvasData) IsSetBindBizType() bool {
	return p.BindBizType != nil
}

func (p *CanvasData) IsSetWorkflowVersion() bool {
	return p.WorkflowVersion != nil
}

func (p *CanvasData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CanvasData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *CanvasData) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkflow()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Workflow = _field
	return nil
}
func (p *CanvasData) ReadField2(iprot thrift.TProtocol) error {
	_field := NewVCSCanvasData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.VcsData = _field
	return nil
}
func (p *CanvasData) ReadField3(iprot thrift.TProtocol) error {
	_field := NewDBCanvasData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.DbData = _field
	return nil
}
func (p *CanvasData) ReadField4(iprot thrift.TProtocol) error {
	_field := NewOperationInfo()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.OperationInfo = _field
	return nil
}
func (p *CanvasData) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ExternalFlowInfo = _field
	return nil
}
func (p *CanvasData) ReadField6(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsBindAgent = _field
	return nil
}
func (p *CanvasData) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BindBizID = _field
	return nil
}
func (p *CanvasData) ReadField8(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BindBizType = _field
	return nil
}
func (p *CanvasData) ReadField9(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.WorkflowVersion = _field
	return nil
}

func (p *CanvasData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CanvasData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CanvasData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Workflow.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CanvasData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("vcs_data", thrift.STRUCT, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.VcsData.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CanvasData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("db_data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.DbData.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *CanvasData) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("operation_info", thrift.STRUCT, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.OperationInfo.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *CanvasData) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetExternalFlowInfo() {
		if err = oprot.WriteFieldBegin("external_flow_info", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ExternalFlowInfo); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *CanvasData) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsBindAgent() {
		if err = oprot.WriteFieldBegin("is_bind_agent", thrift.BOOL, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsBindAgent); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *CanvasData) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizID() {
		if err = oprot.WriteFieldBegin("bind_biz_id", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BindBizID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *CanvasData) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizType() {
		if err = oprot.WriteFieldBegin("bind_biz_type", thrift.I32, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.BindBizType); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *CanvasData) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowVersion() {
		if err = oprot.WriteFieldBegin("workflow_version", thrift.STRING, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.WorkflowVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}

func (p *CanvasData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CanvasData(%+v)", *p)

}

type GetCanvasInfoRequest struct {
	// Space id, cannot be empty
	SpaceID string `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	// Required, process id, not null
	WorkflowID *string    `thrift:"workflow_id,2,optional" form:"workflow_id" json:"workflow_id,omitempty" query:"workflow_id"`
	Base       *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetCanvasInfoRequest() *GetCanvasInfoRequest {
	return &GetCanvasInfoRequest{}
}

func (p *GetCanvasInfoRequest) InitDefault() {
}

func (p *GetCanvasInfoRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var GetCanvasInfoRequest_WorkflowID_DEFAULT string

func (p *GetCanvasInfoRequest) GetWorkflowID() (v string) {
	if !p.IsSetWorkflowID() {
		return GetCanvasInfoRequest_WorkflowID_DEFAULT
	}
	return *p.WorkflowID
}

var GetCanvasInfoRequest_Base_DEFAULT *base.Base

func (p *GetCanvasInfoRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetCanvasInfoRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetCanvasInfoRequest = map[int16]string{
	1:   "space_id",
	2:   "workflow_id",
	255: "Base",
}

func (p *GetCanvasInfoRequest) IsSetWorkflowID() bool {
	return p.WorkflowID != nil
}

func (p *GetCanvasInfoRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetCanvasInfoRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetCanvasInfoRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetCanvasInfoRequest[fieldId]))
}

func (p *GetCanvasInfoRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetCanvasInfoRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.WorkflowID = _field
	return nil
}
func (p *GetCanvasInfoRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetCanvasInfoRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetCanvasInfoRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetCanvasInfoRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetCanvasInfoRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowID() {
		if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.WorkflowID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetCanvasInfoRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetCanvasInfoRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetCanvasInfoRequest(%+v)", *p)

}

type GetCanvasInfoResponse struct {
	Data     *CanvasData    `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetCanvasInfoResponse() *GetCanvasInfoResponse {
	return &GetCanvasInfoResponse{}
}

func (p *GetCanvasInfoResponse) InitDefault() {
}

var GetCanvasInfoResponse_Data_DEFAULT *CanvasData

func (p *GetCanvasInfoResponse) GetData() (v *CanvasData) {
	if !p.IsSetData() {
		return GetCanvasInfoResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetCanvasInfoResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetCanvasInfoResponse) GetMsg() (v string) {
	return p.Msg
}

var GetCanvasInfoResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetCanvasInfoResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetCanvasInfoResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetCanvasInfoResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetCanvasInfoResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetCanvasInfoResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetCanvasInfoResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetCanvasInfoResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetCanvasInfoResponse[fieldId]))
}

func (p *GetCanvasInfoResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCanvasData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetCanvasInfoResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetCanvasInfoResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetCanvasInfoResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetCanvasInfoResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetCanvasInfoResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetCanvasInfoResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetCanvasInfoResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetCanvasInfoResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetCanvasInfoResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetCanvasInfoResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetCanvasInfoResponse(%+v)", *p)

}

type GetHistorySchemaRequest struct {
	SpaceID    string `thrift:"space_id,1,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	WorkflowID string `thrift:"workflow_id,2,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	// You need to pass in when paging multiple times.
	CommitID        *string     `thrift:"commit_id,3,optional" form:"commit_id" json:"commit_id,omitempty" query:"commit_id"`
	Type            OperateType `thrift:"type,4,required" form:"type,required" json:"type,required" query:"type,required"`
	Env             *string     `thrift:"env,5,optional" form:"env" json:"env,omitempty" query:"env"`
	WorkflowVersion *string     `thrift:"workflow_version,6,optional" form:"workflow_version" json:"workflow_version,omitempty" query:"workflow_version"`
	ProjectVersion  *string     `thrift:"project_version,7,optional" form:"project_version" json:"project_version,omitempty" query:"project_version"`
	ProjectID       *string     `thrift:"project_id,8,optional" form:"project_id" json:"project_id,omitempty" query:"project_id"`
	ExecuteID       *string     `thrift:"execute_id,51,optional" form:"execute_id" json:"execute_id,omitempty" query:"execute_id"`
	SubExecuteID    *string     `thrift:"sub_execute_id,52,optional" form:"sub_execute_id" json:"sub_execute_id,omitempty" query:"sub_execute_id"`
	LogID           *string     `thrift:"log_id,53,optional" form:"log_id" json:"log_id,omitempty" query:"log_id"`
	Base            *base.Base  `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetHistorySchemaRequest() *GetHistorySchemaRequest {
	return &GetHistorySchemaRequest{}
}

func (p *GetHistorySchemaRequest) InitDefault() {
}

func (p *GetHistorySchemaRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

func (p *GetHistorySchemaRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

var GetHistorySchemaRequest_CommitID_DEFAULT string

func (p *GetHistorySchemaRequest) GetCommitID() (v string) {
	if !p.IsSetCommitID() {
		return GetHistorySchemaRequest_CommitID_DEFAULT
	}
	return *p.CommitID
}

func (p *GetHistorySchemaRequest) GetType() (v OperateType) {
	return p.Type
}

var GetHistorySchemaRequest_Env_DEFAULT string

func (p *GetHistorySchemaRequest) GetEnv() (v string) {
	if !p.IsSetEnv() {
		return GetHistorySchemaRequest_Env_DEFAULT
	}
	return *p.Env
}

var GetHistorySchemaRequest_WorkflowVersion_DEFAULT string

func (p *GetHistorySchemaRequest) GetWorkflowVersion() (v string) {
	if !p.IsSetWorkflowVersion() {
		return GetHistorySchemaRequest_WorkflowVersion_DEFAULT
	}
	return *p.WorkflowVersion
}

var GetHistorySchemaRequest_ProjectVersion_DEFAULT string

func (p *GetHistorySchemaRequest) GetProjectVersion() (v string) {
	if !p.IsSetProjectVersion() {
		return GetHistorySchemaRequest_ProjectVersion_DEFAULT
	}
	return *p.ProjectVersion
}

var GetHistorySchemaRequest_ProjectID_DEFAULT string

func (p *GetHistorySchemaRequest) GetProjectID() (v string) {
	if !p.IsSetProjectID() {
		return GetHistorySchemaRequest_ProjectID_DEFAULT
	}
	return *p.ProjectID
}

var GetHistorySchemaRequest_ExecuteID_DEFAULT string

func (p *GetHistorySchemaRequest) GetExecuteID() (v string) {
	if !p.IsSetExecuteID() {
		return GetHistorySchemaRequest_ExecuteID_DEFAULT
	}
	return *p.ExecuteID
}

var GetHistorySchemaRequest_SubExecuteID_DEFAULT string

func (p *GetHistorySchemaRequest) GetSubExecuteID() (v string) {
	if !p.IsSetSubExecuteID() {
		return GetHistorySchemaRequest_SubExecuteID_DEFAULT
	}
	return *p.SubExecuteID
}

var GetHistorySchemaRequest_LogID_DEFAULT string

func (p *GetHistorySchemaRequest) GetLogID() (v string) {
	if !p.IsSetLogID() {
		return GetHistorySchemaRequest_LogID_DEFAULT
	}
	return *p.LogID
}

var GetHistorySchemaRequest_Base_DEFAULT *base.Base

func (p *GetHistorySchemaRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetHistorySchemaRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetHistorySchemaRequest = map[int16]string{
	1:   "space_id",
	2:   "workflow_id",
	3:   "commit_id",
	4:   "type",
	5:   "env",
	6:   "workflow_version",
	7:   "project_version",
	8:   "project_id",
	51:  "execute_id",
	52:  "sub_execute_id",
	53:  "log_id",
	255: "Base",
}

func (p *GetHistorySchemaRequest) IsSetCommitID() bool {
	return p.CommitID != nil
}

func (p *GetHistorySchemaRequest) IsSetEnv() bool {
	return p.Env != nil
}

func (p *GetHistorySchemaRequest) IsSetWorkflowVersion() bool {
	return p.WorkflowVersion != nil
}

func (p *GetHistorySchemaRequest) IsSetProjectVersion() bool {
	return p.ProjectVersion != nil
}

func (p *GetHistorySchemaRequest) IsSetProjectID() bool {
	return p.ProjectID != nil
}

func (p *GetHistorySchemaRequest) IsSetExecuteID() bool {
	return p.ExecuteID != nil
}

func (p *GetHistorySchemaRequest) IsSetSubExecuteID() bool {
	return p.SubExecuteID != nil
}

func (p *GetHistorySchemaRequest) IsSetLogID() bool {
	return p.LogID != nil
}

func (p *GetHistorySchemaRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetHistorySchemaRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetSpaceID bool = false
	var issetWorkflowID bool = false
	var issetType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 51:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField51(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 52:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField52(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 53:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField53(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetSpaceID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetWorkflowID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetType {
		fieldId = 4
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetHistorySchemaRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetHistorySchemaRequest[fieldId]))
}

func (p *GetHistorySchemaRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitID = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field OperateType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = OperateType(v)
	}
	p.Type = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Env = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.WorkflowVersion = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProjectVersion = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProjectID = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField51(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ExecuteID = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField52(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SubExecuteID = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField53(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.LogID = _field
	return nil
}
func (p *GetHistorySchemaRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetHistorySchemaRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetHistorySchemaRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField51(oprot); err != nil {
			fieldId = 51
			goto WriteFieldError
		}
		if err = p.writeField52(oprot); err != nil {
			fieldId = 52
			goto WriteFieldError
		}
		if err = p.writeField53(oprot); err != nil {
			fieldId = 53
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetHistorySchemaRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitID() {
		if err = oprot.WriteFieldBegin("commit_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Type)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetEnv() {
		if err = oprot.WriteFieldBegin("env", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Env); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowVersion() {
		if err = oprot.WriteFieldBegin("workflow_version", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.WorkflowVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectVersion() {
		if err = oprot.WriteFieldBegin("project_version", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProjectVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectID() {
		if err = oprot.WriteFieldBegin("project_id", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProjectID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField51(oprot thrift.TProtocol) (err error) {
	if p.IsSetExecuteID() {
		if err = oprot.WriteFieldBegin("execute_id", thrift.STRING, 51); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ExecuteID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 51 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 51 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField52(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubExecuteID() {
		if err = oprot.WriteFieldBegin("sub_execute_id", thrift.STRING, 52); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SubExecuteID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 52 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 52 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField53(oprot thrift.TProtocol) (err error) {
	if p.IsSetLogID() {
		if err = oprot.WriteFieldBegin("log_id", thrift.STRING, 53); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.LogID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 53 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 53 end error: ", p), err)
}
func (p *GetHistorySchemaRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetHistorySchemaRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetHistorySchemaRequest(%+v)", *p)

}

type GetHistorySchemaData struct {
	Name         string       `thrift:"name,1" form:"name" json:"name" query:"name"`
	Describe     string       `thrift:"describe,2" form:"describe" json:"describe" query:"describe"`
	URL          string       `thrift:"url,3" form:"url" json:"url" query:"url"`
	Schema       string       `thrift:"schema,4" form:"schema" json:"schema" query:"schema"`
	FlowMode     WorkflowMode `thrift:"flow_mode,5" form:"flow_mode" json:"flow_mode" query:"flow_mode"`
	BindBizID    *string      `thrift:"bind_biz_id,6,optional" form:"bind_biz_id" json:"bind_biz_id,omitempty" query:"bind_biz_id"`
	BindBizType  *BindBizType `thrift:"bind_biz_type,7,optional" form:"bind_biz_type" json:"bind_biz_type,omitempty" query:"bind_biz_type"`
	WorkflowID   string       `thrift:"workflow_id,8" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	CommitID     string       `thrift:"commit_id,9" form:"commit_id" json:"commit_id" query:"commit_id"`
	ExecuteID    *string      `thrift:"execute_id,51,optional" form:"execute_id" json:"execute_id,omitempty" query:"execute_id"`
	SubExecuteID *string      `thrift:"sub_execute_id,52,optional" form:"sub_execute_id" json:"sub_execute_id,omitempty" query:"sub_execute_id"`
	LogID        *string      `thrift:"log_id,53,optional" form:"log_id" json:"log_id,omitempty" query:"log_id"`
}

func NewGetHistorySchemaData() *GetHistorySchemaData {
	return &GetHistorySchemaData{}
}

func (p *GetHistorySchemaData) InitDefault() {
}

func (p *GetHistorySchemaData) GetName() (v string) {
	return p.Name
}

func (p *GetHistorySchemaData) GetDescribe() (v string) {
	return p.Describe
}

func (p *GetHistorySchemaData) GetURL() (v string) {
	return p.URL
}

func (p *GetHistorySchemaData) GetSchema() (v string) {
	return p.Schema
}

func (p *GetHistorySchemaData) GetFlowMode() (v WorkflowMode) {
	return p.FlowMode
}

var GetHistorySchemaData_BindBizID_DEFAULT string

func (p *GetHistorySchemaData) GetBindBizID() (v string) {
	if !p.IsSetBindBizID() {
		return GetHistorySchemaData_BindBizID_DEFAULT
	}
	return *p.BindBizID
}

var GetHistorySchemaData_BindBizType_DEFAULT BindBizType

func (p *GetHistorySchemaData) GetBindBizType() (v BindBizType) {
	if !p.IsSetBindBizType() {
		return GetHistorySchemaData_BindBizType_DEFAULT
	}
	return *p.BindBizType
}

func (p *GetHistorySchemaData) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *GetHistorySchemaData) GetCommitID() (v string) {
	return p.CommitID
}

var GetHistorySchemaData_ExecuteID_DEFAULT string

func (p *GetHistorySchemaData) GetExecuteID() (v string) {
	if !p.IsSetExecuteID() {
		return GetHistorySchemaData_ExecuteID_DEFAULT
	}
	return *p.ExecuteID
}

var GetHistorySchemaData_SubExecuteID_DEFAULT string

func (p *GetHistorySchemaData) GetSubExecuteID() (v string) {
	if !p.IsSetSubExecuteID() {
		return GetHistorySchemaData_SubExecuteID_DEFAULT
	}
	return *p.SubExecuteID
}

var GetHistorySchemaData_LogID_DEFAULT string

func (p *GetHistorySchemaData) GetLogID() (v string) {
	if !p.IsSetLogID() {
		return GetHistorySchemaData_LogID_DEFAULT
	}
	return *p.LogID
}

var fieldIDToName_GetHistorySchemaData = map[int16]string{
	1:  "name",
	2:  "describe",
	3:  "url",
	4:  "schema",
	5:  "flow_mode",
	6:  "bind_biz_id",
	7:  "bind_biz_type",
	8:  "workflow_id",
	9:  "commit_id",
	51: "execute_id",
	52: "sub_execute_id",
	53: "log_id",
}

func (p *GetHistorySchemaData) IsSetBindBizID() bool {
	return p.BindBizID != nil
}

func (p *GetHistorySchemaData) IsSetBindBizType() bool {
	return p.BindBizType != nil
}

func (p *GetHistorySchemaData) IsSetExecuteID() bool {
	return p.ExecuteID != nil
}

func (p *GetHistorySchemaData) IsSetSubExecuteID() bool {
	return p.SubExecuteID != nil
}

func (p *GetHistorySchemaData) IsSetLogID() bool {
	return p.LogID != nil
}

func (p *GetHistorySchemaData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 51:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField51(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 52:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField52(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 53:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField53(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetHistorySchemaData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetHistorySchemaData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Describe = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Schema = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField5(iprot thrift.TProtocol) error {

	var _field WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkflowMode(v)
	}
	p.FlowMode = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BindBizID = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField7(iprot thrift.TProtocol) error {

	var _field *BindBizType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := BindBizType(v)
		_field = &tmp
	}
	p.BindBizType = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField8(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField9(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CommitID = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField51(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ExecuteID = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField52(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SubExecuteID = _field
	return nil
}
func (p *GetHistorySchemaData) ReadField53(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.LogID = _field
	return nil
}

func (p *GetHistorySchemaData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetHistorySchemaData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField51(oprot); err != nil {
			fieldId = 51
			goto WriteFieldError
		}
		if err = p.writeField52(oprot); err != nil {
			fieldId = 52
			goto WriteFieldError
		}
		if err = p.writeField53(oprot); err != nil {
			fieldId = 53
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetHistorySchemaData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("describe", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Describe); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("schema", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Schema); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.FlowMode)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizID() {
		if err = oprot.WriteFieldBegin("bind_biz_id", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BindBizID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizType() {
		if err = oprot.WriteFieldBegin("bind_biz_type", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.BindBizType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("commit_id", thrift.STRING, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.CommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField51(oprot thrift.TProtocol) (err error) {
	if p.IsSetExecuteID() {
		if err = oprot.WriteFieldBegin("execute_id", thrift.STRING, 51); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ExecuteID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 51 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 51 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField52(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubExecuteID() {
		if err = oprot.WriteFieldBegin("sub_execute_id", thrift.STRING, 52); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SubExecuteID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 52 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 52 end error: ", p), err)
}
func (p *GetHistorySchemaData) writeField53(oprot thrift.TProtocol) (err error) {
	if p.IsSetLogID() {
		if err = oprot.WriteFieldBegin("log_id", thrift.STRING, 53); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.LogID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 53 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 53 end error: ", p), err)
}

func (p *GetHistorySchemaData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetHistorySchemaData(%+v)", *p)

}

type GetHistorySchemaResponse struct {
	Data     *GetHistorySchemaData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64                 `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp        `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetHistorySchemaResponse() *GetHistorySchemaResponse {
	return &GetHistorySchemaResponse{}
}

func (p *GetHistorySchemaResponse) InitDefault() {
}

var GetHistorySchemaResponse_Data_DEFAULT *GetHistorySchemaData

func (p *GetHistorySchemaResponse) GetData() (v *GetHistorySchemaData) {
	if !p.IsSetData() {
		return GetHistorySchemaResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetHistorySchemaResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetHistorySchemaResponse) GetMsg() (v string) {
	return p.Msg
}

var GetHistorySchemaResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetHistorySchemaResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetHistorySchemaResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetHistorySchemaResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetHistorySchemaResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetHistorySchemaResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetHistorySchemaResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetHistorySchemaResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetHistorySchemaResponse[fieldId]))
}

func (p *GetHistorySchemaResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewGetHistorySchemaData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetHistorySchemaResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetHistorySchemaResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetHistorySchemaResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetHistorySchemaResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetHistorySchemaResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetHistorySchemaResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetHistorySchemaResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetHistorySchemaResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetHistorySchemaResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetHistorySchemaResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetHistorySchemaResponse(%+v)", *p)

}

type DeleteWorkflowRequest struct {
	WorkflowID string        `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SpaceID    string        `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	Action     *DeleteAction `thrift:"action,3,optional" form:"action" json:"action,omitempty" query:"action"`
	Base       *base.Base    `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewDeleteWorkflowRequest() *DeleteWorkflowRequest {
	return &DeleteWorkflowRequest{}
}

func (p *DeleteWorkflowRequest) InitDefault() {
}

func (p *DeleteWorkflowRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *DeleteWorkflowRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var DeleteWorkflowRequest_Action_DEFAULT DeleteAction

func (p *DeleteWorkflowRequest) GetAction() (v DeleteAction) {
	if !p.IsSetAction() {
		return DeleteWorkflowRequest_Action_DEFAULT
	}
	return *p.Action
}

var DeleteWorkflowRequest_Base_DEFAULT *base.Base

func (p *DeleteWorkflowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return DeleteWorkflowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_DeleteWorkflowRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	3:   "action",
	255: "Base",
}

func (p *DeleteWorkflowRequest) IsSetAction() bool {
	return p.Action != nil
}

func (p *DeleteWorkflowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *DeleteWorkflowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeleteWorkflowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DeleteWorkflowRequest[fieldId]))
}

func (p *DeleteWorkflowRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *DeleteWorkflowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *DeleteWorkflowRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *DeleteAction
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := DeleteAction(v)
		_field = &tmp
	}
	p.Action = _field
	return nil
}
func (p *DeleteWorkflowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *DeleteWorkflowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteWorkflowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeleteWorkflowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DeleteWorkflowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *DeleteWorkflowRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetAction() {
		if err = oprot.WriteFieldBegin("action", thrift.I32, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Action)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *DeleteWorkflowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *DeleteWorkflowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeleteWorkflowRequest(%+v)", *p)

}

type DeleteWorkflowData struct {
	Status DeleteStatus `thrift:"status,1" form:"status" json:"status" query:"status"`
}

func NewDeleteWorkflowData() *DeleteWorkflowData {
	return &DeleteWorkflowData{}
}

func (p *DeleteWorkflowData) InitDefault() {
}

func (p *DeleteWorkflowData) GetStatus() (v DeleteStatus) {
	return p.Status
}

var fieldIDToName_DeleteWorkflowData = map[int16]string{
	1: "status",
}

func (p *DeleteWorkflowData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeleteWorkflowData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *DeleteWorkflowData) ReadField1(iprot thrift.TProtocol) error {

	var _field DeleteStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = DeleteStatus(v)
	}
	p.Status = _field
	return nil
}

func (p *DeleteWorkflowData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteWorkflowData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeleteWorkflowData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("status", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *DeleteWorkflowData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeleteWorkflowData(%+v)", *p)

}

type DeleteWorkflowResponse struct {
	Data     *DeleteWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64               `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string              `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp      `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewDeleteWorkflowResponse() *DeleteWorkflowResponse {
	return &DeleteWorkflowResponse{}
}

func (p *DeleteWorkflowResponse) InitDefault() {
}

var DeleteWorkflowResponse_Data_DEFAULT *DeleteWorkflowData

func (p *DeleteWorkflowResponse) GetData() (v *DeleteWorkflowData) {
	if !p.IsSetData() {
		return DeleteWorkflowResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *DeleteWorkflowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *DeleteWorkflowResponse) GetMsg() (v string) {
	return p.Msg
}

var DeleteWorkflowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *DeleteWorkflowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return DeleteWorkflowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_DeleteWorkflowResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *DeleteWorkflowResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *DeleteWorkflowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *DeleteWorkflowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_DeleteWorkflowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_DeleteWorkflowResponse[fieldId]))
}

func (p *DeleteWorkflowResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDeleteWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *DeleteWorkflowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *DeleteWorkflowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *DeleteWorkflowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *DeleteWorkflowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("DeleteWorkflowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *DeleteWorkflowResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *DeleteWorkflowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *DeleteWorkflowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *DeleteWorkflowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *DeleteWorkflowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("DeleteWorkflowResponse(%+v)", *p)

}

type BatchDeleteWorkflowResponse struct {
	Data     *DeleteWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64               `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string              `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp      `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewBatchDeleteWorkflowResponse() *BatchDeleteWorkflowResponse {
	return &BatchDeleteWorkflowResponse{}
}

func (p *BatchDeleteWorkflowResponse) InitDefault() {
}

var BatchDeleteWorkflowResponse_Data_DEFAULT *DeleteWorkflowData

func (p *BatchDeleteWorkflowResponse) GetData() (v *DeleteWorkflowData) {
	if !p.IsSetData() {
		return BatchDeleteWorkflowResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *BatchDeleteWorkflowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *BatchDeleteWorkflowResponse) GetMsg() (v string) {
	return p.Msg
}

var BatchDeleteWorkflowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *BatchDeleteWorkflowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return BatchDeleteWorkflowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_BatchDeleteWorkflowResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *BatchDeleteWorkflowResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *BatchDeleteWorkflowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *BatchDeleteWorkflowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BatchDeleteWorkflowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_BatchDeleteWorkflowResponse[fieldId]))
}

func (p *BatchDeleteWorkflowResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewDeleteWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *BatchDeleteWorkflowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *BatchDeleteWorkflowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *BatchDeleteWorkflowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *BatchDeleteWorkflowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BatchDeleteWorkflowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BatchDeleteWorkflowResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BatchDeleteWorkflowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *BatchDeleteWorkflowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *BatchDeleteWorkflowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *BatchDeleteWorkflowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BatchDeleteWorkflowResponse(%+v)", *p)

}

type BatchDeleteWorkflowRequest struct {
	WorkflowIDList []string      `thrift:"workflow_id_list,1,required" form:"workflow_id_list,required" json:"workflow_id_list,required" query:"workflow_id_list,required"`
	SpaceID        string        `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	Action         *DeleteAction `thrift:"action,3,optional" form:"action" json:"action,omitempty" query:"action"`
	Base           *base.Base    `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewBatchDeleteWorkflowRequest() *BatchDeleteWorkflowRequest {
	return &BatchDeleteWorkflowRequest{}
}

func (p *BatchDeleteWorkflowRequest) InitDefault() {
}

func (p *BatchDeleteWorkflowRequest) GetWorkflowIDList() (v []string) {
	return p.WorkflowIDList
}

func (p *BatchDeleteWorkflowRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var BatchDeleteWorkflowRequest_Action_DEFAULT DeleteAction

func (p *BatchDeleteWorkflowRequest) GetAction() (v DeleteAction) {
	if !p.IsSetAction() {
		return BatchDeleteWorkflowRequest_Action_DEFAULT
	}
	return *p.Action
}

var BatchDeleteWorkflowRequest_Base_DEFAULT *base.Base

func (p *BatchDeleteWorkflowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return BatchDeleteWorkflowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_BatchDeleteWorkflowRequest = map[int16]string{
	1:   "workflow_id_list",
	2:   "space_id",
	3:   "action",
	255: "Base",
}

func (p *BatchDeleteWorkflowRequest) IsSetAction() bool {
	return p.Action != nil
}

func (p *BatchDeleteWorkflowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *BatchDeleteWorkflowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowIDList bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowIDList = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowIDList {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_BatchDeleteWorkflowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_BatchDeleteWorkflowRequest[fieldId]))
}

func (p *BatchDeleteWorkflowRequest) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowIDList = _field
	return nil
}
func (p *BatchDeleteWorkflowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *BatchDeleteWorkflowRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *DeleteAction
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := DeleteAction(v)
		_field = &tmp
	}
	p.Action = _field
	return nil
}
func (p *BatchDeleteWorkflowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *BatchDeleteWorkflowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("BatchDeleteWorkflowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *BatchDeleteWorkflowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.WorkflowIDList)); err != nil {
		return err
	}
	for _, v := range p.WorkflowIDList {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *BatchDeleteWorkflowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *BatchDeleteWorkflowRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetAction() {
		if err = oprot.WriteFieldBegin("action", thrift.I32, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Action)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *BatchDeleteWorkflowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *BatchDeleteWorkflowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("BatchDeleteWorkflowRequest(%+v)", *p)

}

type GetDeleteStrategyRequest struct {
	WorkflowID string     `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SpaceID    string     `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	Base       *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetDeleteStrategyRequest() *GetDeleteStrategyRequest {
	return &GetDeleteStrategyRequest{}
}

func (p *GetDeleteStrategyRequest) InitDefault() {
}

func (p *GetDeleteStrategyRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *GetDeleteStrategyRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var GetDeleteStrategyRequest_Base_DEFAULT *base.Base

func (p *GetDeleteStrategyRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetDeleteStrategyRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetDeleteStrategyRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	255: "Base",
}

func (p *GetDeleteStrategyRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetDeleteStrategyRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetDeleteStrategyRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetDeleteStrategyRequest[fieldId]))
}

func (p *GetDeleteStrategyRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *GetDeleteStrategyRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetDeleteStrategyRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetDeleteStrategyRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDeleteStrategyRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetDeleteStrategyRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetDeleteStrategyRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetDeleteStrategyRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetDeleteStrategyRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetDeleteStrategyRequest(%+v)", *p)

}

type GetDeleteStrategyResponse struct {
	Data     DeleteType     `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetDeleteStrategyResponse() *GetDeleteStrategyResponse {
	return &GetDeleteStrategyResponse{}
}

func (p *GetDeleteStrategyResponse) InitDefault() {
}

func (p *GetDeleteStrategyResponse) GetData() (v DeleteType) {
	return p.Data
}

func (p *GetDeleteStrategyResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetDeleteStrategyResponse) GetMsg() (v string) {
	return p.Msg
}

var GetDeleteStrategyResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetDeleteStrategyResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetDeleteStrategyResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetDeleteStrategyResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetDeleteStrategyResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetDeleteStrategyResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetDeleteStrategyResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetDeleteStrategyResponse[fieldId]))
}

func (p *GetDeleteStrategyResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field DeleteType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = DeleteType(v)
	}
	p.Data = _field
	return nil
}
func (p *GetDeleteStrategyResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetDeleteStrategyResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetDeleteStrategyResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetDeleteStrategyResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetDeleteStrategyResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetDeleteStrategyResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.I32, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Data)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetDeleteStrategyResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetDeleteStrategyResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetDeleteStrategyResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetDeleteStrategyResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetDeleteStrategyResponse(%+v)", *p)

}

type PublishWorkflowRequest struct {
	WorkflowID      string `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SpaceID         string `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	HasCollaborator bool   `thrift:"has_collaborator,3,required" form:"has_collaborator,required" json:"has_collaborator,required" query:"has_collaborator,required"`
	// Which environment to publish to, do not fill in the default line
	Env *string `thrift:"env,4,optional" form:"env" json:"env,omitempty" query:"env"`
	// Which version to use to release, do not fill in the default latest commit version
	CommitID *string `thrift:"commit_id,5,optional" form:"commit_id" json:"commit_id,omitempty" query:"commit_id"`
	// Force release. If the TestRun step was executed before the process was published, the "force" parameter value should be false, or not passed; if the TestRun step was not executed before the process was published, the "force" parameter value should be true.
	Force *bool `thrift:"force,6,optional" form:"force" json:"force,omitempty" query:"force"`
	// Required, the version number of the published workflow, in SemVer format "vx.y.z", must be larger than the current version, the current version can be obtained through GetCanvasInfo
	WorkflowVersion *string `thrift:"workflow_version,7,optional" form:"workflow_version" json:"workflow_version,omitempty" query:"workflow_version"`
	// Workflow version description
	VersionDescription *string    `thrift:"version_description,8,optional" form:"version_description" json:"version_description,omitempty" query:"version_description"`
	Base               *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewPublishWorkflowRequest() *PublishWorkflowRequest {
	return &PublishWorkflowRequest{}
}

func (p *PublishWorkflowRequest) InitDefault() {
}

func (p *PublishWorkflowRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *PublishWorkflowRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

func (p *PublishWorkflowRequest) GetHasCollaborator() (v bool) {
	return p.HasCollaborator
}

var PublishWorkflowRequest_Env_DEFAULT string

func (p *PublishWorkflowRequest) GetEnv() (v string) {
	if !p.IsSetEnv() {
		return PublishWorkflowRequest_Env_DEFAULT
	}
	return *p.Env
}

var PublishWorkflowRequest_CommitID_DEFAULT string

func (p *PublishWorkflowRequest) GetCommitID() (v string) {
	if !p.IsSetCommitID() {
		return PublishWorkflowRequest_CommitID_DEFAULT
	}
	return *p.CommitID
}

var PublishWorkflowRequest_Force_DEFAULT bool

func (p *PublishWorkflowRequest) GetForce() (v bool) {
	if !p.IsSetForce() {
		return PublishWorkflowRequest_Force_DEFAULT
	}
	return *p.Force
}

var PublishWorkflowRequest_WorkflowVersion_DEFAULT string

func (p *PublishWorkflowRequest) GetWorkflowVersion() (v string) {
	if !p.IsSetWorkflowVersion() {
		return PublishWorkflowRequest_WorkflowVersion_DEFAULT
	}
	return *p.WorkflowVersion
}

var PublishWorkflowRequest_VersionDescription_DEFAULT string

func (p *PublishWorkflowRequest) GetVersionDescription() (v string) {
	if !p.IsSetVersionDescription() {
		return PublishWorkflowRequest_VersionDescription_DEFAULT
	}
	return *p.VersionDescription
}

var PublishWorkflowRequest_Base_DEFAULT *base.Base

func (p *PublishWorkflowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return PublishWorkflowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_PublishWorkflowRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	3:   "has_collaborator",
	4:   "env",
	5:   "commit_id",
	6:   "force",
	7:   "workflow_version",
	8:   "version_description",
	255: "Base",
}

func (p *PublishWorkflowRequest) IsSetEnv() bool {
	return p.Env != nil
}

func (p *PublishWorkflowRequest) IsSetCommitID() bool {
	return p.CommitID != nil
}

func (p *PublishWorkflowRequest) IsSetForce() bool {
	return p.Force != nil
}

func (p *PublishWorkflowRequest) IsSetWorkflowVersion() bool {
	return p.WorkflowVersion != nil
}

func (p *PublishWorkflowRequest) IsSetVersionDescription() bool {
	return p.VersionDescription != nil
}

func (p *PublishWorkflowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *PublishWorkflowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false
	var issetHasCollaborator bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetHasCollaborator = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetHasCollaborator {
		fieldId = 3
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishWorkflowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_PublishWorkflowRequest[fieldId]))
}

func (p *PublishWorkflowRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.HasCollaborator = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Env = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitID = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Force = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.WorkflowVersion = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.VersionDescription = _field
	return nil
}
func (p *PublishWorkflowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *PublishWorkflowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishWorkflowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishWorkflowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("has_collaborator", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.HasCollaborator); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetEnv() {
		if err = oprot.WriteFieldBegin("env", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Env); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitID() {
		if err = oprot.WriteFieldBegin("commit_id", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetForce() {
		if err = oprot.WriteFieldBegin("force", thrift.BOOL, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.Force); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowVersion() {
		if err = oprot.WriteFieldBegin("workflow_version", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.WorkflowVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetVersionDescription() {
		if err = oprot.WriteFieldBegin("version_description", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.VersionDescription); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *PublishWorkflowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *PublishWorkflowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishWorkflowRequest(%+v)", *p)

}

type PublishWorkflowData struct {
	WorkflowID      string `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	PublishCommitID string `thrift:"publish_commit_id,2" form:"publish_commit_id" json:"publish_commit_id" query:"publish_commit_id"`
	Success         bool   `thrift:"success,3" form:"success" json:"success" query:"success"`
}

func NewPublishWorkflowData() *PublishWorkflowData {
	return &PublishWorkflowData{}
}

func (p *PublishWorkflowData) InitDefault() {
}

func (p *PublishWorkflowData) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *PublishWorkflowData) GetPublishCommitID() (v string) {
	return p.PublishCommitID
}

func (p *PublishWorkflowData) GetSuccess() (v bool) {
	return p.Success
}

var fieldIDToName_PublishWorkflowData = map[int16]string{
	1: "workflow_id",
	2: "publish_commit_id",
	3: "success",
}

func (p *PublishWorkflowData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishWorkflowData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *PublishWorkflowData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *PublishWorkflowData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PublishCommitID = _field
	return nil
}
func (p *PublishWorkflowData) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Success = _field
	return nil
}

func (p *PublishWorkflowData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishWorkflowData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishWorkflowData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishWorkflowData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("publish_commit_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PublishCommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *PublishWorkflowData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("success", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.Success); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *PublishWorkflowData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishWorkflowData(%+v)", *p)

}

type PublishWorkflowResponse struct {
	Data     *PublishWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64                `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string               `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp       `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewPublishWorkflowResponse() *PublishWorkflowResponse {
	return &PublishWorkflowResponse{}
}

func (p *PublishWorkflowResponse) InitDefault() {
}

var PublishWorkflowResponse_Data_DEFAULT *PublishWorkflowData

func (p *PublishWorkflowResponse) GetData() (v *PublishWorkflowData) {
	if !p.IsSetData() {
		return PublishWorkflowResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *PublishWorkflowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *PublishWorkflowResponse) GetMsg() (v string) {
	return p.Msg
}

var PublishWorkflowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *PublishWorkflowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return PublishWorkflowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_PublishWorkflowResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *PublishWorkflowResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *PublishWorkflowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *PublishWorkflowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_PublishWorkflowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_PublishWorkflowResponse[fieldId]))
}

func (p *PublishWorkflowResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewPublishWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *PublishWorkflowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *PublishWorkflowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *PublishWorkflowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *PublishWorkflowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("PublishWorkflowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *PublishWorkflowResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *PublishWorkflowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *PublishWorkflowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *PublishWorkflowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *PublishWorkflowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("PublishWorkflowResponse(%+v)", *p)

}

type CopyWorkflowRequest struct {
	WorkflowID string     `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SpaceID    string     `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	Base       *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewCopyWorkflowRequest() *CopyWorkflowRequest {
	return &CopyWorkflowRequest{}
}

func (p *CopyWorkflowRequest) InitDefault() {
}

func (p *CopyWorkflowRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *CopyWorkflowRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var CopyWorkflowRequest_Base_DEFAULT *base.Base

func (p *CopyWorkflowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return CopyWorkflowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_CopyWorkflowRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	255: "Base",
}

func (p *CopyWorkflowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *CopyWorkflowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CopyWorkflowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CopyWorkflowRequest[fieldId]))
}

func (p *CopyWorkflowRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *CopyWorkflowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *CopyWorkflowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *CopyWorkflowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWorkflowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CopyWorkflowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CopyWorkflowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CopyWorkflowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CopyWorkflowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CopyWorkflowRequest(%+v)", *p)

}

type CopyWorkflowData struct {
	WorkflowID string     `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SchemaType SchemaType `thrift:"schema_type,2,required" form:"schema_type,required" json:"schema_type,required" query:"schema_type,required"`
}

func NewCopyWorkflowData() *CopyWorkflowData {
	return &CopyWorkflowData{}
}

func (p *CopyWorkflowData) InitDefault() {
}

func (p *CopyWorkflowData) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *CopyWorkflowData) GetSchemaType() (v SchemaType) {
	return p.SchemaType
}

var fieldIDToName_CopyWorkflowData = map[int16]string{
	1: "workflow_id",
	2: "schema_type",
}

func (p *CopyWorkflowData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSchemaType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSchemaType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSchemaType {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CopyWorkflowData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CopyWorkflowData[fieldId]))
}

func (p *CopyWorkflowData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *CopyWorkflowData) ReadField2(iprot thrift.TProtocol) error {

	var _field SchemaType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = SchemaType(v)
	}
	p.SchemaType = _field
	return nil
}

func (p *CopyWorkflowData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWorkflowData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CopyWorkflowData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CopyWorkflowData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("schema_type", thrift.I32, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.SchemaType)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *CopyWorkflowData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CopyWorkflowData(%+v)", *p)

}

type CopyWorkflowResponse struct {
	Data     *CopyWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64             `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string            `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp    `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewCopyWorkflowResponse() *CopyWorkflowResponse {
	return &CopyWorkflowResponse{}
}

func (p *CopyWorkflowResponse) InitDefault() {
}

var CopyWorkflowResponse_Data_DEFAULT *CopyWorkflowData

func (p *CopyWorkflowResponse) GetData() (v *CopyWorkflowData) {
	if !p.IsSetData() {
		return CopyWorkflowResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *CopyWorkflowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *CopyWorkflowResponse) GetMsg() (v string) {
	return p.Msg
}

var CopyWorkflowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *CopyWorkflowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return CopyWorkflowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_CopyWorkflowResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *CopyWorkflowResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *CopyWorkflowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *CopyWorkflowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CopyWorkflowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CopyWorkflowResponse[fieldId]))
}

func (p *CopyWorkflowResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewCopyWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *CopyWorkflowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *CopyWorkflowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *CopyWorkflowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *CopyWorkflowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWorkflowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CopyWorkflowResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CopyWorkflowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *CopyWorkflowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *CopyWorkflowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CopyWorkflowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CopyWorkflowResponse(%+v)", *p)

}

type UserInfo struct {
	UserID     int64  `thrift:"user_id,1" form:"user_id" json:"user_id" query:"user_id"`
	UserName   string `thrift:"user_name,2" form:"user_name" json:"user_name" query:"user_name"`
	UserAvatar string `thrift:"user_avatar,3" form:"user_avatar" json:"user_avatar" query:"user_avatar"`
	// user nickname
	Nickname string `thrift:"nickname,4" form:"nickname" json:"nickname" query:"nickname"`
}

func NewUserInfo() *UserInfo {
	return &UserInfo{}
}

func (p *UserInfo) InitDefault() {
}

func (p *UserInfo) GetUserID() (v int64) {
	return p.UserID
}

func (p *UserInfo) GetUserName() (v string) {
	return p.UserName
}

func (p *UserInfo) GetUserAvatar() (v string) {
	return p.UserAvatar
}

func (p *UserInfo) GetNickname() (v string) {
	return p.Nickname
}

var fieldIDToName_UserInfo = map[int16]string{
	1: "user_id",
	2: "user_name",
	3: "user_avatar",
	4: "nickname",
}

func (p *UserInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_UserInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *UserInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserID = _field
	return nil
}
func (p *UserInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserName = _field
	return nil
}
func (p *UserInfo) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserAvatar = _field
	return nil
}
func (p *UserInfo) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Nickname = _field
	return nil
}

func (p *UserInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("UserInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *UserInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.UserID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *UserInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UserName); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *UserInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_avatar", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UserAvatar); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *UserInfo) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("nickname", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Nickname); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *UserInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("UserInfo(%+v)", *p)

}

type ReleasedWorkflowData struct {
	WorkflowList []*ReleasedWorkflow `thrift:"workflow_list,1" form:"workflow_list" json:"workflow_list" query:"workflow_list"`
	Total        int64               `thrift:"total,2" form:"total" json:"total" query:"total"`
}

func NewReleasedWorkflowData() *ReleasedWorkflowData {
	return &ReleasedWorkflowData{}
}

func (p *ReleasedWorkflowData) InitDefault() {
}

func (p *ReleasedWorkflowData) GetWorkflowList() (v []*ReleasedWorkflow) {
	return p.WorkflowList
}

func (p *ReleasedWorkflowData) GetTotal() (v int64) {
	return p.Total
}

var fieldIDToName_ReleasedWorkflowData = map[int16]string{
	1: "workflow_list",
	2: "total",
}

func (p *ReleasedWorkflowData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ReleasedWorkflowData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ReleasedWorkflowData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ReleasedWorkflow, 0, size)
	values := make([]ReleasedWorkflow, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowList = _field
	return nil
}
func (p *ReleasedWorkflowData) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Total = _field
	return nil
}

func (p *ReleasedWorkflowData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ReleasedWorkflowData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ReleasedWorkflowData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.WorkflowList)); err != nil {
		return err
	}
	for _, v := range p.WorkflowList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ReleasedWorkflowData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("total", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Total); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *ReleasedWorkflowData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReleasedWorkflowData(%+v)", *p)

}

type ReleasedWorkflow struct {
	PluginID        string         `thrift:"plugin_id,1" form:"plugin_id" json:"plugin_id" query:"plugin_id"`
	WorkflowID      string         `thrift:"workflow_id,2" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	SpaceID         string         `thrift:"space_id,3" form:"space_id" json:"space_id" query:"space_id"`
	Name            string         `thrift:"name,4" form:"name" json:"name" query:"name"`
	Desc            string         `thrift:"desc,5" form:"desc" json:"desc" query:"desc"`
	Icon            string         `thrift:"icon,6" form:"icon" json:"icon" query:"icon"`
	Inputs          string         `thrift:"inputs,7" form:"inputs" json:"inputs" query:"inputs"`
	Outputs         string         `thrift:"outputs,8" form:"outputs" json:"outputs" query:"outputs"`
	EndType         int32          `thrift:"end_type,9" form:"end_type" json:"end_type" query:"end_type"`
	Type            int32          `thrift:"type,10" form:"type" json:"type" query:"type"`
	SubWorkflowList []*SubWorkflow `thrift:"sub_workflow_list,11" form:"sub_workflow_list" json:"sub_workflow_list" query:"sub_workflow_list"`
	Version         string         `thrift:"version,12" form:"version" json:"version" query:"version"`
	CreateTime      int64          `thrift:"create_time,13" form:"create_time" json:"create_time" query:"create_time"`
	UpdateTime      int64          `thrift:"update_time,14" form:"update_time" json:"update_time" query:"update_time"`
	// Workflow creator information
	Creator               *Creator     `thrift:"creator,15" form:"creator" json:"creator" query:"creator"`
	FlowMode              WorkflowMode `thrift:"flow_mode,16" form:"flow_mode" json:"flow_mode" query:"flow_mode"`
	FlowVersion           string       `thrift:"flow_version,17" form:"flow_version" json:"flow_version" query:"flow_version"`
	FlowVersionDesc       string       `thrift:"flow_version_desc,18" form:"flow_version_desc" json:"flow_version_desc" query:"flow_version_desc"`
	LatestFlowVersion     string       `thrift:"latest_flow_version,19" form:"latest_flow_version" json:"latest_flow_version" query:"latest_flow_version"`
	LatestFlowVersionDesc string       `thrift:"latest_flow_version_desc,20" form:"latest_flow_version_desc" json:"latest_flow_version_desc" query:"latest_flow_version_desc"`
	CommitID              string       `thrift:"commit_id,21" form:"commit_id" json:"commit_id" query:"commit_id"`
	OutputNodes           []*NodeInfo  `thrift:"output_nodes,22" form:"output_nodes" json:"output_nodes" query:"output_nodes"`
}

func NewReleasedWorkflow() *ReleasedWorkflow {
	return &ReleasedWorkflow{}
}

func (p *ReleasedWorkflow) InitDefault() {
}

func (p *ReleasedWorkflow) GetPluginID() (v string) {
	return p.PluginID
}

func (p *ReleasedWorkflow) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *ReleasedWorkflow) GetSpaceID() (v string) {
	return p.SpaceID
}

func (p *ReleasedWorkflow) GetName() (v string) {
	return p.Name
}

func (p *ReleasedWorkflow) GetDesc() (v string) {
	return p.Desc
}

func (p *ReleasedWorkflow) GetIcon() (v string) {
	return p.Icon
}

func (p *ReleasedWorkflow) GetInputs() (v string) {
	return p.Inputs
}

func (p *ReleasedWorkflow) GetOutputs() (v string) {
	return p.Outputs
}

func (p *ReleasedWorkflow) GetEndType() (v int32) {
	return p.EndType
}

func (p *ReleasedWorkflow) GetType() (v int32) {
	return p.Type
}

func (p *ReleasedWorkflow) GetSubWorkflowList() (v []*SubWorkflow) {
	return p.SubWorkflowList
}

func (p *ReleasedWorkflow) GetVersion() (v string) {
	return p.Version
}

func (p *ReleasedWorkflow) GetCreateTime() (v int64) {
	return p.CreateTime
}

func (p *ReleasedWorkflow) GetUpdateTime() (v int64) {
	return p.UpdateTime
}

var ReleasedWorkflow_Creator_DEFAULT *Creator

func (p *ReleasedWorkflow) GetCreator() (v *Creator) {
	if !p.IsSetCreator() {
		return ReleasedWorkflow_Creator_DEFAULT
	}
	return p.Creator
}

func (p *ReleasedWorkflow) GetFlowMode() (v WorkflowMode) {
	return p.FlowMode
}

func (p *ReleasedWorkflow) GetFlowVersion() (v string) {
	return p.FlowVersion
}

func (p *ReleasedWorkflow) GetFlowVersionDesc() (v string) {
	return p.FlowVersionDesc
}

func (p *ReleasedWorkflow) GetLatestFlowVersion() (v string) {
	return p.LatestFlowVersion
}

func (p *ReleasedWorkflow) GetLatestFlowVersionDesc() (v string) {
	return p.LatestFlowVersionDesc
}

func (p *ReleasedWorkflow) GetCommitID() (v string) {
	return p.CommitID
}

func (p *ReleasedWorkflow) GetOutputNodes() (v []*NodeInfo) {
	return p.OutputNodes
}

var fieldIDToName_ReleasedWorkflow = map[int16]string{
	1:  "plugin_id",
	2:  "workflow_id",
	3:  "space_id",
	4:  "name",
	5:  "desc",
	6:  "icon",
	7:  "inputs",
	8:  "outputs",
	9:  "end_type",
	10: "type",
	11: "sub_workflow_list",
	12: "version",
	13: "create_time",
	14: "update_time",
	15: "creator",
	16: "flow_mode",
	17: "flow_version",
	18: "flow_version_desc",
	19: "latest_flow_version",
	20: "latest_flow_version_desc",
	21: "commit_id",
	22: "output_nodes",
}

func (p *ReleasedWorkflow) IsSetCreator() bool {
	return p.Creator != nil
}

func (p *ReleasedWorkflow) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 19:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField19(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 20:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField20(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 21:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField21(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 22:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField22(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ReleasedWorkflow[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ReleasedWorkflow) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginID = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Icon = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField7(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Inputs = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField8(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Outputs = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField9(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.EndType = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField10(iprot thrift.TProtocol) error {

	var _field int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Type = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField11(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*SubWorkflow, 0, size)
	values := make([]SubWorkflow, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubWorkflowList = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField12(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Version = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField13(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CreateTime = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField14(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UpdateTime = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField15(iprot thrift.TProtocol) error {
	_field := NewCreator()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Creator = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField16(iprot thrift.TProtocol) error {

	var _field WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkflowMode(v)
	}
	p.FlowMode = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField17(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.FlowVersion = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField18(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.FlowVersionDesc = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField19(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LatestFlowVersion = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField20(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LatestFlowVersionDesc = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField21(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CommitID = _field
	return nil
}
func (p *ReleasedWorkflow) ReadField22(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*NodeInfo, 0, size)
	values := make([]NodeInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.OutputNodes = _field
	return nil
}

func (p *ReleasedWorkflow) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ReleasedWorkflow"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
		if err = p.writeField19(oprot); err != nil {
			fieldId = 19
			goto WriteFieldError
		}
		if err = p.writeField20(oprot); err != nil {
			fieldId = 20
			goto WriteFieldError
		}
		if err = p.writeField21(oprot); err != nil {
			fieldId = 21
			goto WriteFieldError
		}
		if err = p.writeField22(oprot); err != nil {
			fieldId = 22
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ReleasedWorkflow) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("plugin_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.PluginID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Icon); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("inputs", thrift.STRING, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Inputs); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("outputs", thrift.STRING, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Outputs); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("end_type", thrift.I32, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.EndType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.I32, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(p.Type); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("sub_workflow_list", thrift.LIST, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.SubWorkflowList)); err != nil {
		return err
	}
	for _, v := range p.SubWorkflowList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField12(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("version", thrift.STRING, 12); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Version); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField13(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("create_time", thrift.I64, 13); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.CreateTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField14(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("update_time", thrift.I64, 14); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.UpdateTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField15(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("creator", thrift.STRUCT, 15); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Creator.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField16(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 16); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.FlowMode)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField17(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("flow_version", thrift.STRING, 17); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.FlowVersion); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField18(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("flow_version_desc", thrift.STRING, 18); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.FlowVersionDesc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField19(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("latest_flow_version", thrift.STRING, 19); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.LatestFlowVersion); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 19 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField20(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("latest_flow_version_desc", thrift.STRING, 20); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.LatestFlowVersionDesc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 20 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField21(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("commit_id", thrift.STRING, 21); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.CommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 21 end error: ", p), err)
}
func (p *ReleasedWorkflow) writeField22(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("output_nodes", thrift.LIST, 22); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.OutputNodes)); err != nil {
		return err
	}
	for _, v := range p.OutputNodes {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 22 end error: ", p), err)
}

func (p *ReleasedWorkflow) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ReleasedWorkflow(%+v)", *p)

}

type SubWorkflow struct {
	ID   string `thrift:"id,1" form:"id" json:"id" query:"id"`
	Name string `thrift:"name,2" form:"name" json:"name" query:"name"`
}

func NewSubWorkflow() *SubWorkflow {
	return &SubWorkflow{}
}

func (p *SubWorkflow) InitDefault() {
}

func (p *SubWorkflow) GetID() (v string) {
	return p.ID
}

func (p *SubWorkflow) GetName() (v string) {
	return p.Name
}

var fieldIDToName_SubWorkflow = map[int16]string{
	1: "id",
	2: "name",
}

func (p *SubWorkflow) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_SubWorkflow[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *SubWorkflow) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *SubWorkflow) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}

func (p *SubWorkflow) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("SubWorkflow"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *SubWorkflow) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *SubWorkflow) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *SubWorkflow) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("SubWorkflow(%+v)", *p)

}

// Workflow filter
type WorkflowFilter struct {
	WorkflowID      string  `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	WorkflowVersion *string `thrift:"workflow_version,2,optional" form:"workflow_version" json:"workflow_version,omitempty" query:"workflow_version"`
}

func NewWorkflowFilter() *WorkflowFilter {
	return &WorkflowFilter{}
}

func (p *WorkflowFilter) InitDefault() {
}

func (p *WorkflowFilter) GetWorkflowID() (v string) {
	return p.WorkflowID
}

var WorkflowFilter_WorkflowVersion_DEFAULT string

func (p *WorkflowFilter) GetWorkflowVersion() (v string) {
	if !p.IsSetWorkflowVersion() {
		return WorkflowFilter_WorkflowVersion_DEFAULT
	}
	return *p.WorkflowVersion
}

var fieldIDToName_WorkflowFilter = map[int16]string{
	1: "workflow_id",
	2: "workflow_version",
}

func (p *WorkflowFilter) IsSetWorkflowVersion() bool {
	return p.WorkflowVersion != nil
}

func (p *WorkflowFilter) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowFilter[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowFilter) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *WorkflowFilter) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.WorkflowVersion = _field
	return nil
}

func (p *WorkflowFilter) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowFilter"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowFilter) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowFilter) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowVersion() {
		if err = oprot.WriteFieldBegin("workflow_version", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.WorkflowVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}

func (p *WorkflowFilter) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowFilter(%+v)", *p)

}

type GetReleasedWorkflowsRequest struct {
	Page            *int32        `thrift:"page,1,optional" form:"page" json:"page,omitempty" query:"page"`
	Size            *int32        `thrift:"size,2,optional" form:"size" json:"size,omitempty" query:"size"`
	Type            *WorkFlowType `thrift:"type,4,optional" form:"type" json:"type,omitempty" query:"type"`
	Name            *string       `thrift:"name,5,optional" form:"name" json:"name,omitempty" query:"name"`
	WorkflowIds     []string      `thrift:"workflow_ids,6,optional" form:"workflow_ids" json:"workflow_ids,omitempty" query:"workflow_ids"`
	Tags            *Tag          `thrift:"tags,7,optional" form:"tags" json:"tags,omitempty" query:"tags"`
	SpaceID         *string       `thrift:"space_id,8,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	OrderBy         *OrderBy      `thrift:"order_by,9,optional" form:"order_by" json:"order_by,omitempty" query:"order_by"`
	LoginUserCreate *bool         `thrift:"login_user_create,10,optional" form:"login_user_create" json:"login_user_create,omitempty" query:"login_user_create"`
	// Workflow or imageflow, default to workflow
	FlowMode *WorkflowMode `thrift:"flow_mode,11,optional" form:"flow_mode" json:"flow_mode,omitempty" query:"flow_mode"`
	// Filter conditions, support workflow_id and workflow_version
	WorkflowFilterList []*WorkflowFilter `thrift:"workflow_filter_list,12,optional" form:"workflow_filter_list" json:"workflow_filter_list,omitempty" query:"workflow_filter_list"`
	Base               *base.Base        `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetReleasedWorkflowsRequest() *GetReleasedWorkflowsRequest {
	return &GetReleasedWorkflowsRequest{}
}

func (p *GetReleasedWorkflowsRequest) InitDefault() {
}

var GetReleasedWorkflowsRequest_Page_DEFAULT int32

func (p *GetReleasedWorkflowsRequest) GetPage() (v int32) {
	if !p.IsSetPage() {
		return GetReleasedWorkflowsRequest_Page_DEFAULT
	}
	return *p.Page
}

var GetReleasedWorkflowsRequest_Size_DEFAULT int32

func (p *GetReleasedWorkflowsRequest) GetSize() (v int32) {
	if !p.IsSetSize() {
		return GetReleasedWorkflowsRequest_Size_DEFAULT
	}
	return *p.Size
}

var GetReleasedWorkflowsRequest_Type_DEFAULT WorkFlowType

func (p *GetReleasedWorkflowsRequest) GetType() (v WorkFlowType) {
	if !p.IsSetType() {
		return GetReleasedWorkflowsRequest_Type_DEFAULT
	}
	return *p.Type
}

var GetReleasedWorkflowsRequest_Name_DEFAULT string

func (p *GetReleasedWorkflowsRequest) GetName() (v string) {
	if !p.IsSetName() {
		return GetReleasedWorkflowsRequest_Name_DEFAULT
	}
	return *p.Name
}

var GetReleasedWorkflowsRequest_WorkflowIds_DEFAULT []string

func (p *GetReleasedWorkflowsRequest) GetWorkflowIds() (v []string) {
	if !p.IsSetWorkflowIds() {
		return GetReleasedWorkflowsRequest_WorkflowIds_DEFAULT
	}
	return p.WorkflowIds
}

var GetReleasedWorkflowsRequest_Tags_DEFAULT Tag

func (p *GetReleasedWorkflowsRequest) GetTags() (v Tag) {
	if !p.IsSetTags() {
		return GetReleasedWorkflowsRequest_Tags_DEFAULT
	}
	return *p.Tags
}

var GetReleasedWorkflowsRequest_SpaceID_DEFAULT string

func (p *GetReleasedWorkflowsRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return GetReleasedWorkflowsRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var GetReleasedWorkflowsRequest_OrderBy_DEFAULT OrderBy

func (p *GetReleasedWorkflowsRequest) GetOrderBy() (v OrderBy) {
	if !p.IsSetOrderBy() {
		return GetReleasedWorkflowsRequest_OrderBy_DEFAULT
	}
	return *p.OrderBy
}

var GetReleasedWorkflowsRequest_LoginUserCreate_DEFAULT bool

func (p *GetReleasedWorkflowsRequest) GetLoginUserCreate() (v bool) {
	if !p.IsSetLoginUserCreate() {
		return GetReleasedWorkflowsRequest_LoginUserCreate_DEFAULT
	}
	return *p.LoginUserCreate
}

var GetReleasedWorkflowsRequest_FlowMode_DEFAULT WorkflowMode

func (p *GetReleasedWorkflowsRequest) GetFlowMode() (v WorkflowMode) {
	if !p.IsSetFlowMode() {
		return GetReleasedWorkflowsRequest_FlowMode_DEFAULT
	}
	return *p.FlowMode
}

var GetReleasedWorkflowsRequest_WorkflowFilterList_DEFAULT []*WorkflowFilter

func (p *GetReleasedWorkflowsRequest) GetWorkflowFilterList() (v []*WorkflowFilter) {
	if !p.IsSetWorkflowFilterList() {
		return GetReleasedWorkflowsRequest_WorkflowFilterList_DEFAULT
	}
	return p.WorkflowFilterList
}

var GetReleasedWorkflowsRequest_Base_DEFAULT *base.Base

func (p *GetReleasedWorkflowsRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetReleasedWorkflowsRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetReleasedWorkflowsRequest = map[int16]string{
	1:   "page",
	2:   "size",
	4:   "type",
	5:   "name",
	6:   "workflow_ids",
	7:   "tags",
	8:   "space_id",
	9:   "order_by",
	10:  "login_user_create",
	11:  "flow_mode",
	12:  "workflow_filter_list",
	255: "Base",
}

func (p *GetReleasedWorkflowsRequest) IsSetPage() bool {
	return p.Page != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetSize() bool {
	return p.Size != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetType() bool {
	return p.Type != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetName() bool {
	return p.Name != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetWorkflowIds() bool {
	return p.WorkflowIds != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetTags() bool {
	return p.Tags != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetOrderBy() bool {
	return p.OrderBy != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetLoginUserCreate() bool {
	return p.LoginUserCreate != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetFlowMode() bool {
	return p.FlowMode != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetWorkflowFilterList() bool {
	return p.WorkflowFilterList != nil
}

func (p *GetReleasedWorkflowsRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetReleasedWorkflowsRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetReleasedWorkflowsRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetReleasedWorkflowsRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Page = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Size = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *WorkFlowType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkFlowType(v)
		_field = &tmp
	}
	p.Type = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField6(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowIds = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *Tag
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := Tag(v)
		_field = &tmp
	}
	p.Tags = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField9(iprot thrift.TProtocol) error {

	var _field *OrderBy
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := OrderBy(v)
		_field = &tmp
	}
	p.OrderBy = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField10(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.LoginUserCreate = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField11(iprot thrift.TProtocol) error {

	var _field *WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkflowMode(v)
		_field = &tmp
	}
	p.FlowMode = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField12(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*WorkflowFilter, 0, size)
	values := make([]WorkflowFilter, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowFilterList = _field
	return nil
}
func (p *GetReleasedWorkflowsRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetReleasedWorkflowsRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetReleasedWorkflowsRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetReleasedWorkflowsRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPage() {
		if err = oprot.WriteFieldBegin("page", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Page); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSize() {
		if err = oprot.WriteFieldBegin("size", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Size); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetType() {
		if err = oprot.WriteFieldBegin("type", thrift.I32, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Type)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowIds() {
		if err = oprot.WriteFieldBegin("workflow_ids", thrift.LIST, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.WorkflowIds)); err != nil {
			return err
		}
		for _, v := range p.WorkflowIds {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetTags() {
		if err = oprot.WriteFieldBegin("tags", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Tags)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetOrderBy() {
		if err = oprot.WriteFieldBegin("order_by", thrift.I32, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.OrderBy)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetLoginUserCreate() {
		if err = oprot.WriteFieldBegin("login_user_create", thrift.BOOL, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.LoginUserCreate); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetFlowMode() {
		if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.FlowMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowFilterList() {
		if err = oprot.WriteFieldBegin("workflow_filter_list", thrift.LIST, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.WorkflowFilterList)); err != nil {
			return err
		}
		for _, v := range p.WorkflowFilterList {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *GetReleasedWorkflowsRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetReleasedWorkflowsRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetReleasedWorkflowsRequest(%+v)", *p)

}

type GetReleasedWorkflowsResponse struct {
	Data     *ReleasedWorkflowData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64                 `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp        `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetReleasedWorkflowsResponse() *GetReleasedWorkflowsResponse {
	return &GetReleasedWorkflowsResponse{}
}

func (p *GetReleasedWorkflowsResponse) InitDefault() {
}

var GetReleasedWorkflowsResponse_Data_DEFAULT *ReleasedWorkflowData

func (p *GetReleasedWorkflowsResponse) GetData() (v *ReleasedWorkflowData) {
	if !p.IsSetData() {
		return GetReleasedWorkflowsResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetReleasedWorkflowsResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetReleasedWorkflowsResponse) GetMsg() (v string) {
	return p.Msg
}

var GetReleasedWorkflowsResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetReleasedWorkflowsResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetReleasedWorkflowsResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetReleasedWorkflowsResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetReleasedWorkflowsResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetReleasedWorkflowsResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetReleasedWorkflowsResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetReleasedWorkflowsResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetReleasedWorkflowsResponse[fieldId]))
}

func (p *GetReleasedWorkflowsResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewReleasedWorkflowData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetReleasedWorkflowsResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetReleasedWorkflowsResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetReleasedWorkflowsResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetReleasedWorkflowsResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetReleasedWorkflowsResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetReleasedWorkflowsResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetReleasedWorkflowsResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetReleasedWorkflowsResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetReleasedWorkflowsResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetReleasedWorkflowsResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetReleasedWorkflowsResponse(%+v)", *p)

}

type WorkflowReferencesData struct {
	WorkflowList []*Workflow `thrift:"workflow_list,1" form:"workflow_list" json:"workflow_list" query:"workflow_list"`
}

func NewWorkflowReferencesData() *WorkflowReferencesData {
	return &WorkflowReferencesData{}
}

func (p *WorkflowReferencesData) InitDefault() {
}

func (p *WorkflowReferencesData) GetWorkflowList() (v []*Workflow) {
	return p.WorkflowList
}

var fieldIDToName_WorkflowReferencesData = map[int16]string{
	1: "workflow_list",
}

func (p *WorkflowReferencesData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowReferencesData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowReferencesData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Workflow, 0, size)
	values := make([]Workflow, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowList = _field
	return nil
}

func (p *WorkflowReferencesData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowReferencesData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowReferencesData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.WorkflowList)); err != nil {
		return err
	}
	for _, v := range p.WorkflowList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}

func (p *WorkflowReferencesData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowReferencesData(%+v)", *p)

}

type GetWorkflowReferencesRequest struct {
	WorkflowID string     `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SpaceID    string     `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	Base       *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetWorkflowReferencesRequest() *GetWorkflowReferencesRequest {
	return &GetWorkflowReferencesRequest{}
}

func (p *GetWorkflowReferencesRequest) InitDefault() {
}

func (p *GetWorkflowReferencesRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *GetWorkflowReferencesRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var GetWorkflowReferencesRequest_Base_DEFAULT *base.Base

func (p *GetWorkflowReferencesRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetWorkflowReferencesRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetWorkflowReferencesRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	255: "Base",
}

func (p *GetWorkflowReferencesRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetWorkflowReferencesRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetWorkflowReferencesRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetWorkflowReferencesRequest[fieldId]))
}

func (p *GetWorkflowReferencesRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *GetWorkflowReferencesRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetWorkflowReferencesRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetWorkflowReferencesRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowReferencesRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetWorkflowReferencesRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetWorkflowReferencesRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetWorkflowReferencesRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetWorkflowReferencesRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetWorkflowReferencesRequest(%+v)", *p)

}

type GetWorkflowReferencesResponse struct {
	Data     *WorkflowReferencesData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64                   `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                  `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp          `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetWorkflowReferencesResponse() *GetWorkflowReferencesResponse {
	return &GetWorkflowReferencesResponse{}
}

func (p *GetWorkflowReferencesResponse) InitDefault() {
}

var GetWorkflowReferencesResponse_Data_DEFAULT *WorkflowReferencesData

func (p *GetWorkflowReferencesResponse) GetData() (v *WorkflowReferencesData) {
	if !p.IsSetData() {
		return GetWorkflowReferencesResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetWorkflowReferencesResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetWorkflowReferencesResponse) GetMsg() (v string) {
	return p.Msg
}

var GetWorkflowReferencesResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetWorkflowReferencesResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetWorkflowReferencesResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetWorkflowReferencesResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetWorkflowReferencesResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetWorkflowReferencesResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetWorkflowReferencesResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetWorkflowReferencesResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetWorkflowReferencesResponse[fieldId]))
}

func (p *GetWorkflowReferencesResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkflowReferencesData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetWorkflowReferencesResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetWorkflowReferencesResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetWorkflowReferencesResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetWorkflowReferencesResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowReferencesResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetWorkflowReferencesResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetWorkflowReferencesResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetWorkflowReferencesResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetWorkflowReferencesResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetWorkflowReferencesResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetWorkflowReferencesResponse(%+v)", *p)

}

type GetExampleWorkFlowListResponse struct {
	Data     *WorkFlowListData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64             `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string            `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp    `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetExampleWorkFlowListResponse() *GetExampleWorkFlowListResponse {
	return &GetExampleWorkFlowListResponse{}
}

func (p *GetExampleWorkFlowListResponse) InitDefault() {
}

var GetExampleWorkFlowListResponse_Data_DEFAULT *WorkFlowListData

func (p *GetExampleWorkFlowListResponse) GetData() (v *WorkFlowListData) {
	if !p.IsSetData() {
		return GetExampleWorkFlowListResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetExampleWorkFlowListResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetExampleWorkFlowListResponse) GetMsg() (v string) {
	return p.Msg
}

var GetExampleWorkFlowListResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetExampleWorkFlowListResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetExampleWorkFlowListResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetExampleWorkFlowListResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetExampleWorkFlowListResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetExampleWorkFlowListResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetExampleWorkFlowListResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetExampleWorkFlowListResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetExampleWorkFlowListResponse[fieldId]))
}

func (p *GetExampleWorkFlowListResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkFlowListData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetExampleWorkFlowListResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetExampleWorkFlowListResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetExampleWorkFlowListResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetExampleWorkFlowListResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetExampleWorkFlowListResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetExampleWorkFlowListResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetExampleWorkFlowListResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetExampleWorkFlowListResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetExampleWorkFlowListResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetExampleWorkFlowListResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetExampleWorkFlowListResponse(%+v)", *p)

}

type GetExampleWorkFlowListRequest struct {
	// Paging function, specifying the page number of the list of results you want to retrieve.
	Page *int32 `thrift:"page,1,optional" form:"page" json:"page,omitempty" query:"page"`
	// Paging function, specifies the number of entries returned per page, must be greater than 0, less than or equal to 100
	Size *int32 `thrift:"size,2,optional" form:"size" json:"size,omitempty" query:"size"`
	// Filter the list of sample workflows by the name of the workflow.
	Name *string `thrift:"name,5,optional" form:"name" json:"name,omitempty" query:"name"`
	// Filter the sample workflow list based on the workflow pattern (e.g., standard workflow, conversation flow, etc.).
	FlowMode *WorkflowMode `thrift:"flow_mode,11,optional" form:"flow_mode" json:"flow_mode,omitempty" query:"flow_mode"`
	// Bot's Workflow as Agent mode will be used, only scenarios with BotAgent = 3 will be used
	Checker []CheckType `thrift:"checker,14,optional" form:"checker" json:"checker,omitempty" query:"checker"`
	Base    *base.Base  `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetExampleWorkFlowListRequest() *GetExampleWorkFlowListRequest {
	return &GetExampleWorkFlowListRequest{}
}

func (p *GetExampleWorkFlowListRequest) InitDefault() {
}

var GetExampleWorkFlowListRequest_Page_DEFAULT int32

func (p *GetExampleWorkFlowListRequest) GetPage() (v int32) {
	if !p.IsSetPage() {
		return GetExampleWorkFlowListRequest_Page_DEFAULT
	}
	return *p.Page
}

var GetExampleWorkFlowListRequest_Size_DEFAULT int32

func (p *GetExampleWorkFlowListRequest) GetSize() (v int32) {
	if !p.IsSetSize() {
		return GetExampleWorkFlowListRequest_Size_DEFAULT
	}
	return *p.Size
}

var GetExampleWorkFlowListRequest_Name_DEFAULT string

func (p *GetExampleWorkFlowListRequest) GetName() (v string) {
	if !p.IsSetName() {
		return GetExampleWorkFlowListRequest_Name_DEFAULT
	}
	return *p.Name
}

var GetExampleWorkFlowListRequest_FlowMode_DEFAULT WorkflowMode

func (p *GetExampleWorkFlowListRequest) GetFlowMode() (v WorkflowMode) {
	if !p.IsSetFlowMode() {
		return GetExampleWorkFlowListRequest_FlowMode_DEFAULT
	}
	return *p.FlowMode
}

var GetExampleWorkFlowListRequest_Checker_DEFAULT []CheckType

func (p *GetExampleWorkFlowListRequest) GetChecker() (v []CheckType) {
	if !p.IsSetChecker() {
		return GetExampleWorkFlowListRequest_Checker_DEFAULT
	}
	return p.Checker
}

var GetExampleWorkFlowListRequest_Base_DEFAULT *base.Base

func (p *GetExampleWorkFlowListRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetExampleWorkFlowListRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetExampleWorkFlowListRequest = map[int16]string{
	1:   "page",
	2:   "size",
	5:   "name",
	11:  "flow_mode",
	14:  "checker",
	255: "Base",
}

func (p *GetExampleWorkFlowListRequest) IsSetPage() bool {
	return p.Page != nil
}

func (p *GetExampleWorkFlowListRequest) IsSetSize() bool {
	return p.Size != nil
}

func (p *GetExampleWorkFlowListRequest) IsSetName() bool {
	return p.Name != nil
}

func (p *GetExampleWorkFlowListRequest) IsSetFlowMode() bool {
	return p.FlowMode != nil
}

func (p *GetExampleWorkFlowListRequest) IsSetChecker() bool {
	return p.Checker != nil
}

func (p *GetExampleWorkFlowListRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetExampleWorkFlowListRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetExampleWorkFlowListRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetExampleWorkFlowListRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Page = _field
	return nil
}
func (p *GetExampleWorkFlowListRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Size = _field
	return nil
}
func (p *GetExampleWorkFlowListRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *GetExampleWorkFlowListRequest) ReadField11(iprot thrift.TProtocol) error {

	var _field *WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkflowMode(v)
		_field = &tmp
	}
	p.FlowMode = _field
	return nil
}
func (p *GetExampleWorkFlowListRequest) ReadField14(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]CheckType, 0, size)
	for i := 0; i < size; i++ {

		var _elem CheckType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_elem = CheckType(v)
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Checker = _field
	return nil
}
func (p *GetExampleWorkFlowListRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetExampleWorkFlowListRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetExampleWorkFlowListRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetExampleWorkFlowListRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPage() {
		if err = oprot.WriteFieldBegin("page", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Page); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetExampleWorkFlowListRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSize() {
		if err = oprot.WriteFieldBegin("size", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Size); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetExampleWorkFlowListRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetExampleWorkFlowListRequest) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetFlowMode() {
		if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.FlowMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *GetExampleWorkFlowListRequest) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetChecker() {
		if err = oprot.WriteFieldBegin("checker", thrift.LIST, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.I32, len(p.Checker)); err != nil {
			return err
		}
		for _, v := range p.Checker {
			if err := oprot.WriteI32(int32(v)); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *GetExampleWorkFlowListRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetExampleWorkFlowListRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetExampleWorkFlowListRequest(%+v)", *p)

}

type GetWorkFlowListRequest struct {
	Page *int32 `thrift:"page,1,optional" form:"page" json:"page,omitempty" query:"page"`
	// Page size, usually 10.
	Size *int32 `thrift:"size,2,optional" form:"size" json:"size,omitempty" query:"size"`
	// Query the corresponding process according to the process id list
	WorkflowIds []string `thrift:"workflow_ids,3,optional" form:"workflow_ids" json:"workflow_ids,omitempty" query:"workflow_ids"`
	// Filter processes by process type
	Type *WorkFlowType `thrift:"type,4,optional" form:"type" json:"type,omitempty" query:"type"`
	// Filter processes by process name
	Name *string `thrift:"name,5,optional" form:"name" json:"name,omitempty" query:"name"`
	// Filter process by label
	Tags *Tag `thrift:"tags,6,optional" form:"tags" json:"tags,omitempty" query:"tags"`
	// Required, space id
	SpaceID *string `thrift:"space_id,7,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	// Filter process according to whether the process has been published
	Status  *WorkFlowListStatus `thrift:"status,8,optional" form:"status" json:"status,omitempty" query:"status"`
	OrderBy *OrderBy            `thrift:"order_by,9,optional" form:"order_by" json:"order_by,omitempty" query:"order_by"`
	// Filter processes based on whether the interface requester is the process creator
	LoginUserCreate *bool `thrift:"login_user_create,10,optional" form:"login_user_create" json:"login_user_create,omitempty" query:"login_user_create"`
	// Workflow or chatflow, the default is workflow. Filter processes by process type
	FlowMode *WorkflowMode `thrift:"flow_mode,11,optional" form:"flow_mode" json:"flow_mode,omitempty" query:"flow_mode"`
	// New field for filtering schema_type
	SchemaTypeList []SchemaType `thrift:"schema_type_list,12,optional" form:"schema_type_list" json:"schema_type_list,omitempty" query:"schema_type_list"`
	// Query process under the corresponding project
	ProjectID *string `thrift:"project_id,13,optional" form:"project_id" json:"project_id,omitempty" query:"project_id"`
	// For project publication filtering, each CheckType element in this list can specify a specific rule that determines whether the returned process passes the check.
	Checker        []CheckType  `thrift:"checker,14,optional" form:"checker" json:"checker,omitempty" query:"checker"`
	BindBizID      *string      `thrift:"bind_biz_id,15,optional" form:"bind_biz_id" json:"bind_biz_id,omitempty" query:"bind_biz_id"`
	BindBizType    *BindBizType `thrift:"bind_biz_type,16,optional" form:"bind_biz_type" json:"bind_biz_type,omitempty" query:"bind_biz_type"`
	ProjectVersion *string      `thrift:"project_version,17,optional" form:"project_version" json:"project_version,omitempty" query:"project_version"`
	Base           *base.Base   `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetWorkFlowListRequest() *GetWorkFlowListRequest {
	return &GetWorkFlowListRequest{}
}

func (p *GetWorkFlowListRequest) InitDefault() {
}

var GetWorkFlowListRequest_Page_DEFAULT int32

func (p *GetWorkFlowListRequest) GetPage() (v int32) {
	if !p.IsSetPage() {
		return GetWorkFlowListRequest_Page_DEFAULT
	}
	return *p.Page
}

var GetWorkFlowListRequest_Size_DEFAULT int32

func (p *GetWorkFlowListRequest) GetSize() (v int32) {
	if !p.IsSetSize() {
		return GetWorkFlowListRequest_Size_DEFAULT
	}
	return *p.Size
}

var GetWorkFlowListRequest_WorkflowIds_DEFAULT []string

func (p *GetWorkFlowListRequest) GetWorkflowIds() (v []string) {
	if !p.IsSetWorkflowIds() {
		return GetWorkFlowListRequest_WorkflowIds_DEFAULT
	}
	return p.WorkflowIds
}

var GetWorkFlowListRequest_Type_DEFAULT WorkFlowType

func (p *GetWorkFlowListRequest) GetType() (v WorkFlowType) {
	if !p.IsSetType() {
		return GetWorkFlowListRequest_Type_DEFAULT
	}
	return *p.Type
}

var GetWorkFlowListRequest_Name_DEFAULT string

func (p *GetWorkFlowListRequest) GetName() (v string) {
	if !p.IsSetName() {
		return GetWorkFlowListRequest_Name_DEFAULT
	}
	return *p.Name
}

var GetWorkFlowListRequest_Tags_DEFAULT Tag

func (p *GetWorkFlowListRequest) GetTags() (v Tag) {
	if !p.IsSetTags() {
		return GetWorkFlowListRequest_Tags_DEFAULT
	}
	return *p.Tags
}

var GetWorkFlowListRequest_SpaceID_DEFAULT string

func (p *GetWorkFlowListRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return GetWorkFlowListRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var GetWorkFlowListRequest_Status_DEFAULT WorkFlowListStatus

func (p *GetWorkFlowListRequest) GetStatus() (v WorkFlowListStatus) {
	if !p.IsSetStatus() {
		return GetWorkFlowListRequest_Status_DEFAULT
	}
	return *p.Status
}

var GetWorkFlowListRequest_OrderBy_DEFAULT OrderBy

func (p *GetWorkFlowListRequest) GetOrderBy() (v OrderBy) {
	if !p.IsSetOrderBy() {
		return GetWorkFlowListRequest_OrderBy_DEFAULT
	}
	return *p.OrderBy
}

var GetWorkFlowListRequest_LoginUserCreate_DEFAULT bool

func (p *GetWorkFlowListRequest) GetLoginUserCreate() (v bool) {
	if !p.IsSetLoginUserCreate() {
		return GetWorkFlowListRequest_LoginUserCreate_DEFAULT
	}
	return *p.LoginUserCreate
}

var GetWorkFlowListRequest_FlowMode_DEFAULT WorkflowMode

func (p *GetWorkFlowListRequest) GetFlowMode() (v WorkflowMode) {
	if !p.IsSetFlowMode() {
		return GetWorkFlowListRequest_FlowMode_DEFAULT
	}
	return *p.FlowMode
}

var GetWorkFlowListRequest_SchemaTypeList_DEFAULT []SchemaType

func (p *GetWorkFlowListRequest) GetSchemaTypeList() (v []SchemaType) {
	if !p.IsSetSchemaTypeList() {
		return GetWorkFlowListRequest_SchemaTypeList_DEFAULT
	}
	return p.SchemaTypeList
}

var GetWorkFlowListRequest_ProjectID_DEFAULT string

func (p *GetWorkFlowListRequest) GetProjectID() (v string) {
	if !p.IsSetProjectID() {
		return GetWorkFlowListRequest_ProjectID_DEFAULT
	}
	return *p.ProjectID
}

var GetWorkFlowListRequest_Checker_DEFAULT []CheckType

func (p *GetWorkFlowListRequest) GetChecker() (v []CheckType) {
	if !p.IsSetChecker() {
		return GetWorkFlowListRequest_Checker_DEFAULT
	}
	return p.Checker
}

var GetWorkFlowListRequest_BindBizID_DEFAULT string

func (p *GetWorkFlowListRequest) GetBindBizID() (v string) {
	if !p.IsSetBindBizID() {
		return GetWorkFlowListRequest_BindBizID_DEFAULT
	}
	return *p.BindBizID
}

var GetWorkFlowListRequest_BindBizType_DEFAULT BindBizType

func (p *GetWorkFlowListRequest) GetBindBizType() (v BindBizType) {
	if !p.IsSetBindBizType() {
		return GetWorkFlowListRequest_BindBizType_DEFAULT
	}
	return *p.BindBizType
}

var GetWorkFlowListRequest_ProjectVersion_DEFAULT string

func (p *GetWorkFlowListRequest) GetProjectVersion() (v string) {
	if !p.IsSetProjectVersion() {
		return GetWorkFlowListRequest_ProjectVersion_DEFAULT
	}
	return *p.ProjectVersion
}

var GetWorkFlowListRequest_Base_DEFAULT *base.Base

func (p *GetWorkFlowListRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetWorkFlowListRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetWorkFlowListRequest = map[int16]string{
	1:   "page",
	2:   "size",
	3:   "workflow_ids",
	4:   "type",
	5:   "name",
	6:   "tags",
	7:   "space_id",
	8:   "status",
	9:   "order_by",
	10:  "login_user_create",
	11:  "flow_mode",
	12:  "schema_type_list",
	13:  "project_id",
	14:  "checker",
	15:  "bind_biz_id",
	16:  "bind_biz_type",
	17:  "project_version",
	255: "Base",
}

func (p *GetWorkFlowListRequest) IsSetPage() bool {
	return p.Page != nil
}

func (p *GetWorkFlowListRequest) IsSetSize() bool {
	return p.Size != nil
}

func (p *GetWorkFlowListRequest) IsSetWorkflowIds() bool {
	return p.WorkflowIds != nil
}

func (p *GetWorkFlowListRequest) IsSetType() bool {
	return p.Type != nil
}

func (p *GetWorkFlowListRequest) IsSetName() bool {
	return p.Name != nil
}

func (p *GetWorkFlowListRequest) IsSetTags() bool {
	return p.Tags != nil
}

func (p *GetWorkFlowListRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *GetWorkFlowListRequest) IsSetStatus() bool {
	return p.Status != nil
}

func (p *GetWorkFlowListRequest) IsSetOrderBy() bool {
	return p.OrderBy != nil
}

func (p *GetWorkFlowListRequest) IsSetLoginUserCreate() bool {
	return p.LoginUserCreate != nil
}

func (p *GetWorkFlowListRequest) IsSetFlowMode() bool {
	return p.FlowMode != nil
}

func (p *GetWorkFlowListRequest) IsSetSchemaTypeList() bool {
	return p.SchemaTypeList != nil
}

func (p *GetWorkFlowListRequest) IsSetProjectID() bool {
	return p.ProjectID != nil
}

func (p *GetWorkFlowListRequest) IsSetChecker() bool {
	return p.Checker != nil
}

func (p *GetWorkFlowListRequest) IsSetBindBizID() bool {
	return p.BindBizID != nil
}

func (p *GetWorkFlowListRequest) IsSetBindBizType() bool {
	return p.BindBizType != nil
}

func (p *GetWorkFlowListRequest) IsSetProjectVersion() bool {
	return p.ProjectVersion != nil
}

func (p *GetWorkFlowListRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetWorkFlowListRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetWorkFlowListRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetWorkFlowListRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Page = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Size = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowIds = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *WorkFlowType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkFlowType(v)
		_field = &tmp
	}
	p.Type = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.Name = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *Tag
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := Tag(v)
		_field = &tmp
	}
	p.Tags = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field *WorkFlowListStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkFlowListStatus(v)
		_field = &tmp
	}
	p.Status = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField9(iprot thrift.TProtocol) error {

	var _field *OrderBy
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := OrderBy(v)
		_field = &tmp
	}
	p.OrderBy = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField10(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.LoginUserCreate = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField11(iprot thrift.TProtocol) error {

	var _field *WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := WorkflowMode(v)
		_field = &tmp
	}
	p.FlowMode = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField12(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]SchemaType, 0, size)
	for i := 0; i < size; i++ {

		var _elem SchemaType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_elem = SchemaType(v)
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SchemaTypeList = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField13(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProjectID = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField14(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]CheckType, 0, size)
	for i := 0; i < size; i++ {

		var _elem CheckType
		if v, err := iprot.ReadI32(); err != nil {
			return err
		} else {
			_elem = CheckType(v)
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.Checker = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField15(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BindBizID = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField16(iprot thrift.TProtocol) error {

	var _field *BindBizType
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := BindBizType(v)
		_field = &tmp
	}
	p.BindBizType = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField17(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProjectVersion = _field
	return nil
}
func (p *GetWorkFlowListRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetWorkFlowListRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkFlowListRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetWorkFlowListRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetPage() {
		if err = oprot.WriteFieldBegin("page", thrift.I32, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Page); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSize() {
		if err = oprot.WriteFieldBegin("size", thrift.I32, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.Size); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowIds() {
		if err = oprot.WriteFieldBegin("workflow_ids", thrift.LIST, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.WorkflowIds)); err != nil {
			return err
		}
		for _, v := range p.WorkflowIds {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetType() {
		if err = oprot.WriteFieldBegin("type", thrift.I32, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Type)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetName() {
		if err = oprot.WriteFieldBegin("name", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.Name); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetTags() {
		if err = oprot.WriteFieldBegin("tags", thrift.I32, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Tags)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if p.IsSetStatus() {
		if err = oprot.WriteFieldBegin("status", thrift.I32, 8); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.Status)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetOrderBy() {
		if err = oprot.WriteFieldBegin("order_by", thrift.I32, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.OrderBy)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField10(oprot thrift.TProtocol) (err error) {
	if p.IsSetLoginUserCreate() {
		if err = oprot.WriteFieldBegin("login_user_create", thrift.BOOL, 10); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.LoginUserCreate); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField11(oprot thrift.TProtocol) (err error) {
	if p.IsSetFlowMode() {
		if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 11); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.FlowMode)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField12(oprot thrift.TProtocol) (err error) {
	if p.IsSetSchemaTypeList() {
		if err = oprot.WriteFieldBegin("schema_type_list", thrift.LIST, 12); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.I32, len(p.SchemaTypeList)); err != nil {
			return err
		}
		for _, v := range p.SchemaTypeList {
			if err := oprot.WriteI32(int32(v)); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField13(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectID() {
		if err = oprot.WriteFieldBegin("project_id", thrift.STRING, 13); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProjectID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField14(oprot thrift.TProtocol) (err error) {
	if p.IsSetChecker() {
		if err = oprot.WriteFieldBegin("checker", thrift.LIST, 14); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.I32, len(p.Checker)); err != nil {
			return err
		}
		for _, v := range p.Checker {
			if err := oprot.WriteI32(int32(v)); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField15(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizID() {
		if err = oprot.WriteFieldBegin("bind_biz_id", thrift.STRING, 15); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BindBizID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField16(oprot thrift.TProtocol) (err error) {
	if p.IsSetBindBizType() {
		if err = oprot.WriteFieldBegin("bind_biz_type", thrift.I32, 16); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.BindBizType)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField17(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectVersion() {
		if err = oprot.WriteFieldBegin("project_version", thrift.STRING, 17); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProjectVersion); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *GetWorkFlowListRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetWorkFlowListRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetWorkFlowListRequest(%+v)", *p)

}

type ResourceActionAuth struct {
	CanEdit   bool `thrift:"can_edit,1" form:"can_edit" json:"can_edit" query:"can_edit"`
	CanDelete bool `thrift:"can_delete,2" form:"can_delete" json:"can_delete" query:"can_delete"`
	CanCopy   bool `thrift:"can_copy,3" form:"can_copy" json:"can_copy" query:"can_copy"`
}

func NewResourceActionAuth() *ResourceActionAuth {
	return &ResourceActionAuth{}
}

func (p *ResourceActionAuth) InitDefault() {
}

func (p *ResourceActionAuth) GetCanEdit() (v bool) {
	return p.CanEdit
}

func (p *ResourceActionAuth) GetCanDelete() (v bool) {
	return p.CanDelete
}

func (p *ResourceActionAuth) GetCanCopy() (v bool) {
	return p.CanCopy
}

var fieldIDToName_ResourceActionAuth = map[int16]string{
	1: "can_edit",
	2: "can_delete",
	3: "can_copy",
}

func (p *ResourceActionAuth) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ResourceActionAuth[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ResourceActionAuth) ReadField1(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CanEdit = _field
	return nil
}
func (p *ResourceActionAuth) ReadField2(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CanDelete = _field
	return nil
}
func (p *ResourceActionAuth) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CanCopy = _field
	return nil
}

func (p *ResourceActionAuth) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ResourceActionAuth"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ResourceActionAuth) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("can_edit", thrift.BOOL, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.CanEdit); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ResourceActionAuth) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("can_delete", thrift.BOOL, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.CanDelete); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ResourceActionAuth) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("can_copy", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.CanCopy); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *ResourceActionAuth) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ResourceActionAuth(%+v)", *p)

}

type ResourceAuthInfo struct {
	// Resource ID
	WorkflowID string `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	// user id
	UserID string `thrift:"user_id,2" form:"user_id" json:"user_id" query:"user_id"`
	// user resource operation permission
	Auth *ResourceActionAuth `thrift:"auth,3" form:"auth" json:"auth" query:"auth"`
}

func NewResourceAuthInfo() *ResourceAuthInfo {
	return &ResourceAuthInfo{}
}

func (p *ResourceAuthInfo) InitDefault() {
}

func (p *ResourceAuthInfo) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *ResourceAuthInfo) GetUserID() (v string) {
	return p.UserID
}

var ResourceAuthInfo_Auth_DEFAULT *ResourceActionAuth

func (p *ResourceAuthInfo) GetAuth() (v *ResourceActionAuth) {
	if !p.IsSetAuth() {
		return ResourceAuthInfo_Auth_DEFAULT
	}
	return p.Auth
}

var fieldIDToName_ResourceAuthInfo = map[int16]string{
	1: "workflow_id",
	2: "user_id",
	3: "auth",
}

func (p *ResourceAuthInfo) IsSetAuth() bool {
	return p.Auth != nil
}

func (p *ResourceAuthInfo) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_ResourceAuthInfo[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *ResourceAuthInfo) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *ResourceAuthInfo) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UserID = _field
	return nil
}
func (p *ResourceAuthInfo) ReadField3(iprot thrift.TProtocol) error {
	_field := NewResourceActionAuth()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Auth = _field
	return nil
}

func (p *ResourceAuthInfo) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("ResourceAuthInfo"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *ResourceAuthInfo) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *ResourceAuthInfo) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("user_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.UserID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *ResourceAuthInfo) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("auth", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Auth.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *ResourceAuthInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ResourceAuthInfo(%+v)", *p)

}

type WorkFlowListData struct {
	WorkflowList []*Workflow         `thrift:"workflow_list,1" form:"workflow_list" json:"workflow_list" query:"workflow_list"`
	AuthList     []*ResourceAuthInfo `thrift:"auth_list,2" form:"auth_list" json:"auth_list" query:"auth_list"`
	Total        int64               `thrift:"total,3" form:"total" json:"total" query:"total"`
}

func NewWorkFlowListData() *WorkFlowListData {
	return &WorkFlowListData{}
}

func (p *WorkFlowListData) InitDefault() {
}

func (p *WorkFlowListData) GetWorkflowList() (v []*Workflow) {
	return p.WorkflowList
}

func (p *WorkFlowListData) GetAuthList() (v []*ResourceAuthInfo) {
	return p.AuthList
}

func (p *WorkFlowListData) GetTotal() (v int64) {
	return p.Total
}

var fieldIDToName_WorkFlowListData = map[int16]string{
	1: "workflow_list",
	2: "auth_list",
	3: "total",
}

func (p *WorkFlowListData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkFlowListData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkFlowListData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*Workflow, 0, size)
	values := make([]Workflow, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowList = _field
	return nil
}
func (p *WorkFlowListData) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*ResourceAuthInfo, 0, size)
	values := make([]ResourceAuthInfo, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.AuthList = _field
	return nil
}
func (p *WorkFlowListData) ReadField3(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Total = _field
	return nil
}

func (p *WorkFlowListData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowListData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkFlowListData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_list", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.WorkflowList)); err != nil {
		return err
	}
	for _, v := range p.WorkflowList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkFlowListData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("auth_list", thrift.LIST, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRUCT, len(p.AuthList)); err != nil {
		return err
	}
	for _, v := range p.AuthList {
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkFlowListData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("total", thrift.I64, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Total); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *WorkFlowListData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkFlowListData(%+v)", *p)

}

type GetWorkFlowListResponse struct {
	Data     *WorkFlowListData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64             `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string            `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp    `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetWorkFlowListResponse() *GetWorkFlowListResponse {
	return &GetWorkFlowListResponse{}
}

func (p *GetWorkFlowListResponse) InitDefault() {
}

var GetWorkFlowListResponse_Data_DEFAULT *WorkFlowListData

func (p *GetWorkFlowListResponse) GetData() (v *WorkFlowListData) {
	if !p.IsSetData() {
		return GetWorkFlowListResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *GetWorkFlowListResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetWorkFlowListResponse) GetMsg() (v string) {
	return p.Msg
}

var GetWorkFlowListResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetWorkFlowListResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetWorkFlowListResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetWorkFlowListResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *GetWorkFlowListResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetWorkFlowListResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetWorkFlowListResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetWorkFlowListResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetWorkFlowListResponse[fieldId]))
}

func (p *GetWorkFlowListResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkFlowListData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetWorkFlowListResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetWorkFlowListResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetWorkFlowListResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetWorkFlowListResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkFlowListResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetWorkFlowListResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetWorkFlowListResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *GetWorkFlowListResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *GetWorkFlowListResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetWorkFlowListResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetWorkFlowListResponse(%+v)", *p)

}

type QueryWorkflowNodeTypeRequest struct {
	SpaceID    string     `thrift:"space_id,1" form:"space_id" json:"space_id" query:"space_id"`
	WorkflowID string     `thrift:"workflow_id,2" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	Base       *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewQueryWorkflowNodeTypeRequest() *QueryWorkflowNodeTypeRequest {
	return &QueryWorkflowNodeTypeRequest{}
}

func (p *QueryWorkflowNodeTypeRequest) InitDefault() {
}

func (p *QueryWorkflowNodeTypeRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

func (p *QueryWorkflowNodeTypeRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

var QueryWorkflowNodeTypeRequest_Base_DEFAULT *base.Base

func (p *QueryWorkflowNodeTypeRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return QueryWorkflowNodeTypeRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_QueryWorkflowNodeTypeRequest = map[int16]string{
	1:   "space_id",
	2:   "workflow_id",
	255: "Base",
}

func (p *QueryWorkflowNodeTypeRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *QueryWorkflowNodeTypeRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_QueryWorkflowNodeTypeRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *QueryWorkflowNodeTypeRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *QueryWorkflowNodeTypeRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *QueryWorkflowNodeTypeRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *QueryWorkflowNodeTypeRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("QueryWorkflowNodeTypeRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *QueryWorkflowNodeTypeRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *QueryWorkflowNodeTypeRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *QueryWorkflowNodeTypeRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *QueryWorkflowNodeTypeRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("QueryWorkflowNodeTypeRequest(%+v)", *p)

}

type QueryWorkflowNodeTypeResponse struct {
	Data     *WorkflowNodeTypeData `thrift:"data,1" form:"data" json:"data" query:"data"`
	Code     int64                 `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp        `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewQueryWorkflowNodeTypeResponse() *QueryWorkflowNodeTypeResponse {
	return &QueryWorkflowNodeTypeResponse{}
}

func (p *QueryWorkflowNodeTypeResponse) InitDefault() {
}

var QueryWorkflowNodeTypeResponse_Data_DEFAULT *WorkflowNodeTypeData

func (p *QueryWorkflowNodeTypeResponse) GetData() (v *WorkflowNodeTypeData) {
	if !p.IsSetData() {
		return QueryWorkflowNodeTypeResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *QueryWorkflowNodeTypeResponse) GetCode() (v int64) {
	return p.Code
}

func (p *QueryWorkflowNodeTypeResponse) GetMsg() (v string) {
	return p.Msg
}

var QueryWorkflowNodeTypeResponse_BaseResp_DEFAULT *base.BaseResp

func (p *QueryWorkflowNodeTypeResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return QueryWorkflowNodeTypeResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_QueryWorkflowNodeTypeResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *QueryWorkflowNodeTypeResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *QueryWorkflowNodeTypeResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *QueryWorkflowNodeTypeResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_QueryWorkflowNodeTypeResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_QueryWorkflowNodeTypeResponse[fieldId]))
}

func (p *QueryWorkflowNodeTypeResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkflowNodeTypeData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *QueryWorkflowNodeTypeResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *QueryWorkflowNodeTypeResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *QueryWorkflowNodeTypeResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *QueryWorkflowNodeTypeResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("QueryWorkflowNodeTypeResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *QueryWorkflowNodeTypeResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *QueryWorkflowNodeTypeResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *QueryWorkflowNodeTypeResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *QueryWorkflowNodeTypeResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *QueryWorkflowNodeTypeResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("QueryWorkflowNodeTypeResponse(%+v)", *p)

}

type NodeProps struct {
	ID                  string `thrift:"id,1" form:"id" json:"id" query:"id"`
	Type                string `thrift:"type,2" form:"type" json:"type" query:"type"`
	IsEnableChatHistory bool   `thrift:"is_enable_chat_history,3" form:"is_enable_chat_history" json:"is_enable_chat_history" query:"is_enable_chat_history"`
	IsEnableUserQuery   bool   `thrift:"is_enable_user_query,4" form:"is_enable_user_query" json:"is_enable_user_query" query:"is_enable_user_query"`
	IsRefGlobalVariable bool   `thrift:"is_ref_global_variable,5" form:"is_ref_global_variable" json:"is_ref_global_variable" query:"is_ref_global_variable"`
}

func NewNodeProps() *NodeProps {
	return &NodeProps{}
}

func (p *NodeProps) InitDefault() {
}

func (p *NodeProps) GetID() (v string) {
	return p.ID
}

func (p *NodeProps) GetType() (v string) {
	return p.Type
}

func (p *NodeProps) GetIsEnableChatHistory() (v bool) {
	return p.IsEnableChatHistory
}

func (p *NodeProps) GetIsEnableUserQuery() (v bool) {
	return p.IsEnableUserQuery
}

func (p *NodeProps) GetIsRefGlobalVariable() (v bool) {
	return p.IsRefGlobalVariable
}

var fieldIDToName_NodeProps = map[int16]string{
	1: "id",
	2: "type",
	3: "is_enable_chat_history",
	4: "is_enable_user_query",
	5: "is_ref_global_variable",
}

func (p *NodeProps) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_NodeProps[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *NodeProps) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ID = _field
	return nil
}
func (p *NodeProps) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Type = _field
	return nil
}
func (p *NodeProps) ReadField3(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsEnableChatHistory = _field
	return nil
}
func (p *NodeProps) ReadField4(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsEnableUserQuery = _field
	return nil
}
func (p *NodeProps) ReadField5(iprot thrift.TProtocol) error {

	var _field bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IsRefGlobalVariable = _field
	return nil
}

func (p *NodeProps) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("NodeProps"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *NodeProps) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *NodeProps) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("type", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Type); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *NodeProps) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_enable_chat_history", thrift.BOOL, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsEnableChatHistory); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *NodeProps) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_enable_user_query", thrift.BOOL, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsEnableUserQuery); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *NodeProps) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("is_ref_global_variable", thrift.BOOL, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteBool(p.IsRefGlobalVariable); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}

func (p *NodeProps) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("NodeProps(%+v)", *p)

}

type WorkflowNodeTypeData struct {
	NodeTypes                  []string     `thrift:"node_types,1,optional" form:"node_types" json:"node_types,omitempty" query:"node_types"`
	SubWorkflowNodeTypes       []string     `thrift:"sub_workflow_node_types,2,optional" form:"sub_workflow_node_types" json:"sub_workflow_node_types,omitempty" query:"sub_workflow_node_types"`
	NodesProperties            []*NodeProps `thrift:"nodes_properties,3,optional" form:"nodes_properties" json:"nodes_properties,omitempty" query:"nodes_properties"`
	SubWorkflowNodesProperties []*NodeProps `thrift:"sub_workflow_nodes_properties,4,optional" form:"sub_workflow_nodes_properties" json:"sub_workflow_nodes_properties,omitempty" query:"sub_workflow_nodes_properties"`
}

func NewWorkflowNodeTypeData() *WorkflowNodeTypeData {
	return &WorkflowNodeTypeData{}
}

func (p *WorkflowNodeTypeData) InitDefault() {
}

var WorkflowNodeTypeData_NodeTypes_DEFAULT []string

func (p *WorkflowNodeTypeData) GetNodeTypes() (v []string) {
	if !p.IsSetNodeTypes() {
		return WorkflowNodeTypeData_NodeTypes_DEFAULT
	}
	return p.NodeTypes
}

var WorkflowNodeTypeData_SubWorkflowNodeTypes_DEFAULT []string

func (p *WorkflowNodeTypeData) GetSubWorkflowNodeTypes() (v []string) {
	if !p.IsSetSubWorkflowNodeTypes() {
		return WorkflowNodeTypeData_SubWorkflowNodeTypes_DEFAULT
	}
	return p.SubWorkflowNodeTypes
}

var WorkflowNodeTypeData_NodesProperties_DEFAULT []*NodeProps

func (p *WorkflowNodeTypeData) GetNodesProperties() (v []*NodeProps) {
	if !p.IsSetNodesProperties() {
		return WorkflowNodeTypeData_NodesProperties_DEFAULT
	}
	return p.NodesProperties
}

var WorkflowNodeTypeData_SubWorkflowNodesProperties_DEFAULT []*NodeProps

func (p *WorkflowNodeTypeData) GetSubWorkflowNodesProperties() (v []*NodeProps) {
	if !p.IsSetSubWorkflowNodesProperties() {
		return WorkflowNodeTypeData_SubWorkflowNodesProperties_DEFAULT
	}
	return p.SubWorkflowNodesProperties
}

var fieldIDToName_WorkflowNodeTypeData = map[int16]string{
	1: "node_types",
	2: "sub_workflow_node_types",
	3: "nodes_properties",
	4: "sub_workflow_nodes_properties",
}

func (p *WorkflowNodeTypeData) IsSetNodeTypes() bool {
	return p.NodeTypes != nil
}

func (p *WorkflowNodeTypeData) IsSetSubWorkflowNodeTypes() bool {
	return p.SubWorkflowNodeTypes != nil
}

func (p *WorkflowNodeTypeData) IsSetNodesProperties() bool {
	return p.NodesProperties != nil
}

func (p *WorkflowNodeTypeData) IsSetSubWorkflowNodesProperties() bool {
	return p.SubWorkflowNodesProperties != nil
}

func (p *WorkflowNodeTypeData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowNodeTypeData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkflowNodeTypeData) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.NodeTypes = _field
	return nil
}
func (p *WorkflowNodeTypeData) ReadField2(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubWorkflowNodeTypes = _field
	return nil
}
func (p *WorkflowNodeTypeData) ReadField3(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*NodeProps, 0, size)
	values := make([]NodeProps, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.NodesProperties = _field
	return nil
}
func (p *WorkflowNodeTypeData) ReadField4(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]*NodeProps, 0, size)
	values := make([]NodeProps, size)
	for i := 0; i < size; i++ {
		_elem := &values[i]
		_elem.InitDefault()

		if err := _elem.Read(iprot); err != nil {
			return err
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubWorkflowNodesProperties = _field
	return nil
}

func (p *WorkflowNodeTypeData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowNodeTypeData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowNodeTypeData) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetNodeTypes() {
		if err = oprot.WriteFieldBegin("node_types", thrift.LIST, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.NodeTypes)); err != nil {
			return err
		}
		for _, v := range p.NodeTypes {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowNodeTypeData) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubWorkflowNodeTypes() {
		if err = oprot.WriteFieldBegin("sub_workflow_node_types", thrift.LIST, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRING, len(p.SubWorkflowNodeTypes)); err != nil {
			return err
		}
		for _, v := range p.SubWorkflowNodeTypes {
			if err := oprot.WriteString(v); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowNodeTypeData) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetNodesProperties() {
		if err = oprot.WriteFieldBegin("nodes_properties", thrift.LIST, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.NodesProperties)); err != nil {
			return err
		}
		for _, v := range p.NodesProperties {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkflowNodeTypeData) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubWorkflowNodesProperties() {
		if err = oprot.WriteFieldBegin("sub_workflow_nodes_properties", thrift.LIST, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteListBegin(thrift.STRUCT, len(p.SubWorkflowNodesProperties)); err != nil {
			return err
		}
		for _, v := range p.SubWorkflowNodesProperties {
			if err := v.Write(oprot); err != nil {
				return err
			}
		}
		if err := oprot.WriteListEnd(); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}

func (p *WorkflowNodeTypeData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowNodeTypeData(%+v)", *p)

}

type WorkFlowTestRunRequest struct {
	WorkflowID string            `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	Input      map[string]string `thrift:"input,2" form:"input" json:"input" query:"input"`
	SpaceID    *string           `thrift:"space_id,3,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	// The id of the agent, the process under non-project, the process involving variable nodes and databases
	BotID *string `thrift:"bot_id,4,optional" form:"bot_id" json:"bot_id,omitempty" query:"bot_id"`
	// abandoned
	SubmitCommitID *string `thrift:"submit_commit_id,5,optional" form:"submit_commit_id" json:"submit_commit_id,omitempty" query:"submit_commit_id"`
	// Specify vcs commit_id, default is empty
	CommitID  *string    `thrift:"commit_id,6,optional" form:"commit_id" json:"commit_id,omitempty" query:"commit_id"`
	ProjectID *string    `thrift:"project_id,7,optional" form:"project_id" json:"project_id,omitempty" query:"project_id"`
	Base      *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewWorkFlowTestRunRequest() *WorkFlowTestRunRequest {
	return &WorkFlowTestRunRequest{}
}

func (p *WorkFlowTestRunRequest) InitDefault() {
}

func (p *WorkFlowTestRunRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *WorkFlowTestRunRequest) GetInput() (v map[string]string) {
	return p.Input
}

var WorkFlowTestRunRequest_SpaceID_DEFAULT string

func (p *WorkFlowTestRunRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return WorkFlowTestRunRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var WorkFlowTestRunRequest_BotID_DEFAULT string

func (p *WorkFlowTestRunRequest) GetBotID() (v string) {
	if !p.IsSetBotID() {
		return WorkFlowTestRunRequest_BotID_DEFAULT
	}
	return *p.BotID
}

var WorkFlowTestRunRequest_SubmitCommitID_DEFAULT string

func (p *WorkFlowTestRunRequest) GetSubmitCommitID() (v string) {
	if !p.IsSetSubmitCommitID() {
		return WorkFlowTestRunRequest_SubmitCommitID_DEFAULT
	}
	return *p.SubmitCommitID
}

var WorkFlowTestRunRequest_CommitID_DEFAULT string

func (p *WorkFlowTestRunRequest) GetCommitID() (v string) {
	if !p.IsSetCommitID() {
		return WorkFlowTestRunRequest_CommitID_DEFAULT
	}
	return *p.CommitID
}

var WorkFlowTestRunRequest_ProjectID_DEFAULT string

func (p *WorkFlowTestRunRequest) GetProjectID() (v string) {
	if !p.IsSetProjectID() {
		return WorkFlowTestRunRequest_ProjectID_DEFAULT
	}
	return *p.ProjectID
}

var WorkFlowTestRunRequest_Base_DEFAULT *base.Base

func (p *WorkFlowTestRunRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return WorkFlowTestRunRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_WorkFlowTestRunRequest = map[int16]string{
	1:   "workflow_id",
	2:   "input",
	3:   "space_id",
	4:   "bot_id",
	5:   "submit_commit_id",
	6:   "commit_id",
	7:   "project_id",
	255: "Base",
}

func (p *WorkFlowTestRunRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *WorkFlowTestRunRequest) IsSetBotID() bool {
	return p.BotID != nil
}

func (p *WorkFlowTestRunRequest) IsSetSubmitCommitID() bool {
	return p.SubmitCommitID != nil
}

func (p *WorkFlowTestRunRequest) IsSetCommitID() bool {
	return p.CommitID != nil
}

func (p *WorkFlowTestRunRequest) IsSetProjectID() bool {
	return p.ProjectID != nil
}

func (p *WorkFlowTestRunRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *WorkFlowTestRunRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkFlowTestRunRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_WorkFlowTestRunRequest[fieldId]))
}

func (p *WorkFlowTestRunRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *WorkFlowTestRunRequest) ReadField2(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[string]string, size)
	for i := 0; i < size; i++ {
		var _key string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_key = v
		}

		var _val string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_val = v
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.Input = _field
	return nil
}
func (p *WorkFlowTestRunRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *WorkFlowTestRunRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BotID = _field
	return nil
}
func (p *WorkFlowTestRunRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SubmitCommitID = _field
	return nil
}
func (p *WorkFlowTestRunRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.CommitID = _field
	return nil
}
func (p *WorkFlowTestRunRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ProjectID = _field
	return nil
}
func (p *WorkFlowTestRunRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *WorkFlowTestRunRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowTestRunRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkFlowTestRunRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkFlowTestRunRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("input", thrift.MAP, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.STRING, thrift.STRING, len(p.Input)); err != nil {
		return err
	}
	for k, v := range p.Input {
		if err := oprot.WriteString(k); err != nil {
			return err
		}
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkFlowTestRunRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkFlowTestRunRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetBotID() {
		if err = oprot.WriteFieldBegin("bot_id", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.BotID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkFlowTestRunRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubmitCommitID() {
		if err = oprot.WriteFieldBegin("submit_commit_id", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SubmitCommitID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WorkFlowTestRunRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetCommitID() {
		if err = oprot.WriteFieldBegin("commit_id", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.CommitID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *WorkFlowTestRunRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetProjectID() {
		if err = oprot.WriteFieldBegin("project_id", thrift.STRING, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ProjectID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *WorkFlowTestRunRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *WorkFlowTestRunRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkFlowTestRunRequest(%+v)", *p)

}

type WorkFlowTestRunData struct {
	WorkflowID string `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id" query:"workflow_id"`
	ExecuteID  string `thrift:"execute_id,2" form:"execute_id" json:"execute_id" query:"execute_id"`
	SessionID  string `thrift:"session_id,3" form:"session_id" json:"session_id" query:"session_id"`
}

func NewWorkFlowTestRunData() *WorkFlowTestRunData {
	return &WorkFlowTestRunData{}
}

func (p *WorkFlowTestRunData) InitDefault() {
}

func (p *WorkFlowTestRunData) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *WorkFlowTestRunData) GetExecuteID() (v string) {
	return p.ExecuteID
}

func (p *WorkFlowTestRunData) GetSessionID() (v string) {
	return p.SessionID
}

var fieldIDToName_WorkFlowTestRunData = map[int16]string{
	1: "workflow_id",
	2: "execute_id",
	3: "session_id",
}

func (p *WorkFlowTestRunData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkFlowTestRunData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WorkFlowTestRunData) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *WorkFlowTestRunData) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ExecuteID = _field
	return nil
}
func (p *WorkFlowTestRunData) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SessionID = _field
	return nil
}

func (p *WorkFlowTestRunData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowTestRunData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkFlowTestRunData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkFlowTestRunData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("execute_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ExecuteID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkFlowTestRunData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("session_id", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SessionID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}

func (p *WorkFlowTestRunData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkFlowTestRunData(%+v)", *p)

}

type WorkFlowTestRunResponse struct {
	Data     *WorkFlowTestRunData `thrift:"data,1,required" form:"data,required" json:"data,required" query:"data,required"`
	Code     int64                `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string               `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp       `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewWorkFlowTestRunResponse() *WorkFlowTestRunResponse {
	return &WorkFlowTestRunResponse{}
}

func (p *WorkFlowTestRunResponse) InitDefault() {
}

var WorkFlowTestRunResponse_Data_DEFAULT *WorkFlowTestRunData

func (p *WorkFlowTestRunResponse) GetData() (v *WorkFlowTestRunData) {
	if !p.IsSetData() {
		return WorkFlowTestRunResponse_Data_DEFAULT
	}
	return p.Data
}

func (p *WorkFlowTestRunResponse) GetCode() (v int64) {
	return p.Code
}

func (p *WorkFlowTestRunResponse) GetMsg() (v string) {
	return p.Msg
}

var WorkFlowTestRunResponse_BaseResp_DEFAULT *base.BaseResp

func (p *WorkFlowTestRunResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return WorkFlowTestRunResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_WorkFlowTestRunResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *WorkFlowTestRunResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *WorkFlowTestRunResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *WorkFlowTestRunResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkFlowTestRunResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_WorkFlowTestRunResponse[fieldId]))
}

func (p *WorkFlowTestRunResponse) ReadField1(iprot thrift.TProtocol) error {
	_field := NewWorkFlowTestRunData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *WorkFlowTestRunResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *WorkFlowTestRunResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *WorkFlowTestRunResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *WorkFlowTestRunResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkFlowTestRunResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkFlowTestRunResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkFlowTestRunResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *WorkFlowTestRunResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *WorkFlowTestRunResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *WorkFlowTestRunResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkFlowTestRunResponse(%+v)", *p)

}

type WorkflowTestResumeRequest struct {
	WorkflowID string     `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	ExecuteID  string     `thrift:"execute_id,2,required" form:"execute_id,required" json:"execute_id,required" query:"execute_id,required"`
	EventID    string     `thrift:"event_id,3,required" form:"event_id,required" json:"event_id,required" query:"event_id,required"`
	Data       string     `thrift:"data,4,required" form:"data,required" json:"data,required" query:"data,required"`
	SpaceID    *string    `thrift:"space_id,5,optional" form:"space_id" json:"space_id,omitempty" query:"space_id"`
	Base       *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewWorkflowTestResumeRequest() *WorkflowTestResumeRequest {
	return &WorkflowTestResumeRequest{}
}

func (p *WorkflowTestResumeRequest) InitDefault() {
}

func (p *WorkflowTestResumeRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *WorkflowTestResumeRequest) GetExecuteID() (v string) {
	return p.ExecuteID
}

func (p *WorkflowTestResumeRequest) GetEventID() (v string) {
	return p.EventID
}

func (p *WorkflowTestResumeRequest) GetData() (v string) {
	return p.Data
}

var WorkflowTestResumeRequest_SpaceID_DEFAULT string

func (p *WorkflowTestResumeRequest) GetSpaceID() (v string) {
	if !p.IsSetSpaceID() {
		return WorkflowTestResumeRequest_SpaceID_DEFAULT
	}
	return *p.SpaceID
}

var WorkflowTestResumeRequest_Base_DEFAULT *base.Base

func (p *WorkflowTestResumeRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return WorkflowTestResumeRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_WorkflowTestResumeRequest = map[int16]string{
	1:   "workflow_id",
	2:   "execute_id",
	3:   "event_id",
	4:   "data",
	5:   "space_id",
	255: "Base",
}

func (p *WorkflowTestResumeRequest) IsSetSpaceID() bool {
	return p.SpaceID != nil
}

func (p *WorkflowTestResumeRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *WorkflowTestResumeRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetExecuteID bool = false
	var issetEventID bool = false
	var issetData bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetExecuteID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetEventID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetExecuteID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetEventID {
		fieldId = 3
		goto RequiredFieldNotSetError
	}

	if !issetData {
		fieldId = 4
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowTestResumeRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_WorkflowTestResumeRequest[fieldId]))
}

func (p *WorkflowTestResumeRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *WorkflowTestResumeRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ExecuteID = _field
	return nil
}
func (p *WorkflowTestResumeRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.EventID = _field
	return nil
}
func (p *WorkflowTestResumeRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Data = _field
	return nil
}
func (p *WorkflowTestResumeRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SpaceID = _field
	return nil
}
func (p *WorkflowTestResumeRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *WorkflowTestResumeRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowTestResumeRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowTestResumeRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WorkflowTestResumeRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("execute_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ExecuteID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WorkflowTestResumeRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("event_id", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.EventID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WorkflowTestResumeRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Data); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WorkflowTestResumeRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetSpaceID() {
		if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SpaceID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WorkflowTestResumeRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *WorkflowTestResumeRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowTestResumeRequest(%+v)", *p)

}

type WorkflowTestResumeResponse struct {
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewWorkflowTestResumeResponse() *WorkflowTestResumeResponse {
	return &WorkflowTestResumeResponse{}
}

func (p *WorkflowTestResumeResponse) InitDefault() {
}

func (p *WorkflowTestResumeResponse) GetCode() (v int64) {
	return p.Code
}

func (p *WorkflowTestResumeResponse) GetMsg() (v string) {
	return p.Msg
}

var WorkflowTestResumeResponse_BaseResp_DEFAULT *base.BaseResp

func (p *WorkflowTestResumeResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return WorkflowTestResumeResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_WorkflowTestResumeResponse = map[int16]string{
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *WorkflowTestResumeResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *WorkflowTestResumeResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WorkflowTestResumeResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_WorkflowTestResumeResponse[fieldId]))
}

func (p *WorkflowTestResumeResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *WorkflowTestResumeResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *WorkflowTestResumeResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *WorkflowTestResumeResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WorkflowTestResumeResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WorkflowTestResumeResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *WorkflowTestResumeResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *WorkflowTestResumeResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *WorkflowTestResumeResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WorkflowTestResumeResponse(%+v)", *p)

}

type CancelWorkFlowRequest struct {
	ExecuteID  string     `thrift:"execute_id,1,required" form:"execute_id,required" json:"execute_id,required" query:"execute_id,required"`
	SpaceID    string     `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	WorkflowID *string    `thrift:"workflow_id,3,optional" form:"workflow_id" json:"workflow_id,omitempty" query:"workflow_id"`
	Base       *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewCancelWorkFlowRequest() *CancelWorkFlowRequest {
	return &CancelWorkFlowRequest{}
}

func (p *CancelWorkFlowRequest) InitDefault() {
}

func (p *CancelWorkFlowRequest) GetExecuteID() (v string) {
	return p.ExecuteID
}

func (p *CancelWorkFlowRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var CancelWorkFlowRequest_WorkflowID_DEFAULT string

func (p *CancelWorkFlowRequest) GetWorkflowID() (v string) {
	if !p.IsSetWorkflowID() {
		return CancelWorkFlowRequest_WorkflowID_DEFAULT
	}
	return *p.WorkflowID
}

var CancelWorkFlowRequest_Base_DEFAULT *base.Base

func (p *CancelWorkFlowRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return CancelWorkFlowRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_CancelWorkFlowRequest = map[int16]string{
	1:   "execute_id",
	2:   "space_id",
	3:   "workflow_id",
	255: "Base",
}

func (p *CancelWorkFlowRequest) IsSetWorkflowID() bool {
	return p.WorkflowID != nil
}

func (p *CancelWorkFlowRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *CancelWorkFlowRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetExecuteID bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetExecuteID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetExecuteID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CancelWorkFlowRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CancelWorkFlowRequest[fieldId]))
}

func (p *CancelWorkFlowRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ExecuteID = _field
	return nil
}
func (p *CancelWorkFlowRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *CancelWorkFlowRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.WorkflowID = _field
	return nil
}
func (p *CancelWorkFlowRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *CancelWorkFlowRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CancelWorkFlowRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CancelWorkFlowRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("execute_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ExecuteID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CancelWorkFlowRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CancelWorkFlowRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetWorkflowID() {
		if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.WorkflowID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *CancelWorkFlowRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CancelWorkFlowRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CancelWorkFlowRequest(%+v)", *p)

}

type CancelWorkFlowResponse struct {
	Code     int64          `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string         `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewCancelWorkFlowResponse() *CancelWorkFlowResponse {
	return &CancelWorkFlowResponse{}
}

func (p *CancelWorkFlowResponse) InitDefault() {
}

func (p *CancelWorkFlowResponse) GetCode() (v int64) {
	return p.Code
}

func (p *CancelWorkFlowResponse) GetMsg() (v string) {
	return p.Msg
}

var CancelWorkFlowResponse_BaseResp_DEFAULT *base.BaseResp

func (p *CancelWorkFlowResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return CancelWorkFlowResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_CancelWorkFlowResponse = map[int16]string{
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *CancelWorkFlowResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *CancelWorkFlowResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CancelWorkFlowResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CancelWorkFlowResponse[fieldId]))
}

func (p *CancelWorkFlowResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *CancelWorkFlowResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *CancelWorkFlowResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *CancelWorkFlowResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CancelWorkFlowResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CancelWorkFlowResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *CancelWorkFlowResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *CancelWorkFlowResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CancelWorkFlowResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CancelWorkFlowResponse(%+v)", *p)

}

// Workflow snapshot basic information
type WkPluginBasicData struct {
	WorkflowID int64          `thrift:"workflow_id,1" form:"workflow_id" json:"workflow_id,string" query:"workflow_id"`
	SpaceID    int64          `thrift:"space_id,2" form:"space_id" json:"space_id,string" query:"space_id"`
	Name       string         `thrift:"name,3" form:"name" json:"name" query:"name"`
	Desc       string         `thrift:"desc,4" form:"desc" json:"desc" query:"desc"`
	URL        string         `thrift:"url,5" form:"url" json:"url" query:"url"`
	IconURI    string         `thrift:"icon_uri,6" form:"icon_uri" json:"icon_uri" query:"icon_uri"`
	Status     WorkFlowStatus `thrift:"status,7" form:"status" json:"status" query:"status"`
	// Plugin ID for workflow
	PluginID              int64        `thrift:"plugin_id,8" form:"plugin_id" json:"plugin_id,string" query:"plugin_id"`
	CreateTime            int64        `thrift:"create_time,9" form:"create_time" json:"create_time" query:"create_time"`
	UpdateTime            int64        `thrift:"update_time,10" form:"update_time" json:"update_time" query:"update_time"`
	SourceID              int64        `thrift:"source_id,11" form:"source_id" json:"source_id,string" query:"source_id"`
	Creator               *Creator     `thrift:"creator,12" form:"creator" json:"creator" query:"creator"`
	Schema                string       `thrift:"schema,13" form:"schema" json:"schema" query:"schema"`
	StartNode             *Node        `thrift:"start_node,14" form:"start_node" json:"start_node" query:"start_node"`
	FlowMode              WorkflowMode `thrift:"flow_mode,15" form:"flow_mode" json:"flow_mode" query:"flow_mode"`
	SubWorkflows          []int64      `thrift:"sub_workflows,16" form:"sub_workflows" json:"sub_workflows" query:"sub_workflows"`
	LatestPublishCommitID string       `thrift:"latest_publish_commit_id,17" form:"latest_publish_commit_id" json:"latest_publish_commit_id" query:"latest_publish_commit_id"`
	EndNode               *Node        `thrift:"end_node,18" form:"end_node" json:"end_node" query:"end_node"`
}

func NewWkPluginBasicData() *WkPluginBasicData {
	return &WkPluginBasicData{}
}

func (p *WkPluginBasicData) InitDefault() {
}

func (p *WkPluginBasicData) GetWorkflowID() (v int64) {
	return p.WorkflowID
}

func (p *WkPluginBasicData) GetSpaceID() (v int64) {
	return p.SpaceID
}

func (p *WkPluginBasicData) GetName() (v string) {
	return p.Name
}

func (p *WkPluginBasicData) GetDesc() (v string) {
	return p.Desc
}

func (p *WkPluginBasicData) GetURL() (v string) {
	return p.URL
}

func (p *WkPluginBasicData) GetIconURI() (v string) {
	return p.IconURI
}

func (p *WkPluginBasicData) GetStatus() (v WorkFlowStatus) {
	return p.Status
}

func (p *WkPluginBasicData) GetPluginID() (v int64) {
	return p.PluginID
}

func (p *WkPluginBasicData) GetCreateTime() (v int64) {
	return p.CreateTime
}

func (p *WkPluginBasicData) GetUpdateTime() (v int64) {
	return p.UpdateTime
}

func (p *WkPluginBasicData) GetSourceID() (v int64) {
	return p.SourceID
}

var WkPluginBasicData_Creator_DEFAULT *Creator

func (p *WkPluginBasicData) GetCreator() (v *Creator) {
	if !p.IsSetCreator() {
		return WkPluginBasicData_Creator_DEFAULT
	}
	return p.Creator
}

func (p *WkPluginBasicData) GetSchema() (v string) {
	return p.Schema
}

var WkPluginBasicData_StartNode_DEFAULT *Node

func (p *WkPluginBasicData) GetStartNode() (v *Node) {
	if !p.IsSetStartNode() {
		return WkPluginBasicData_StartNode_DEFAULT
	}
	return p.StartNode
}

func (p *WkPluginBasicData) GetFlowMode() (v WorkflowMode) {
	return p.FlowMode
}

func (p *WkPluginBasicData) GetSubWorkflows() (v []int64) {
	return p.SubWorkflows
}

func (p *WkPluginBasicData) GetLatestPublishCommitID() (v string) {
	return p.LatestPublishCommitID
}

var WkPluginBasicData_EndNode_DEFAULT *Node

func (p *WkPluginBasicData) GetEndNode() (v *Node) {
	if !p.IsSetEndNode() {
		return WkPluginBasicData_EndNode_DEFAULT
	}
	return p.EndNode
}

var fieldIDToName_WkPluginBasicData = map[int16]string{
	1:  "workflow_id",
	2:  "space_id",
	3:  "name",
	4:  "desc",
	5:  "url",
	6:  "icon_uri",
	7:  "status",
	8:  "plugin_id",
	9:  "create_time",
	10: "update_time",
	11: "source_id",
	12: "creator",
	13: "schema",
	14: "start_node",
	15: "flow_mode",
	16: "sub_workflows",
	17: "latest_publish_commit_id",
	18: "end_node",
}

func (p *WkPluginBasicData) IsSetCreator() bool {
	return p.Creator != nil
}

func (p *WkPluginBasicData) IsSetStartNode() bool {
	return p.StartNode != nil
}

func (p *WkPluginBasicData) IsSetEndNode() bool {
	return p.EndNode != nil
}

func (p *WkPluginBasicData) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 10:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField10(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 11:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField11(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 12:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField12(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 13:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField13(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 14:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField14(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 15:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField15(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 16:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField16(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 17:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField17(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 18:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField18(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_WkPluginBasicData[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *WkPluginBasicData) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *WkPluginBasicData) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *WkPluginBasicData) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Name = _field
	return nil
}
func (p *WkPluginBasicData) ReadField4(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Desc = _field
	return nil
}
func (p *WkPluginBasicData) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.URL = _field
	return nil
}
func (p *WkPluginBasicData) ReadField6(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.IconURI = _field
	return nil
}
func (p *WkPluginBasicData) ReadField7(iprot thrift.TProtocol) error {

	var _field WorkFlowStatus
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkFlowStatus(v)
	}
	p.Status = _field
	return nil
}
func (p *WkPluginBasicData) ReadField8(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.PluginID = _field
	return nil
}
func (p *WkPluginBasicData) ReadField9(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.CreateTime = _field
	return nil
}
func (p *WkPluginBasicData) ReadField10(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.UpdateTime = _field
	return nil
}
func (p *WkPluginBasicData) ReadField11(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SourceID = _field
	return nil
}
func (p *WkPluginBasicData) ReadField12(iprot thrift.TProtocol) error {
	_field := NewCreator()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Creator = _field
	return nil
}
func (p *WkPluginBasicData) ReadField13(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Schema = _field
	return nil
}
func (p *WkPluginBasicData) ReadField14(iprot thrift.TProtocol) error {
	_field := NewNode()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.StartNode = _field
	return nil
}
func (p *WkPluginBasicData) ReadField15(iprot thrift.TProtocol) error {

	var _field WorkflowMode
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = WorkflowMode(v)
	}
	p.FlowMode = _field
	return nil
}
func (p *WkPluginBasicData) ReadField16(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]int64, 0, size)
	for i := 0; i < size; i++ {

		var _elem int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.SubWorkflows = _field
	return nil
}
func (p *WkPluginBasicData) ReadField17(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.LatestPublishCommitID = _field
	return nil
}
func (p *WkPluginBasicData) ReadField18(iprot thrift.TProtocol) error {
	_field := NewNode()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.EndNode = _field
	return nil
}

func (p *WkPluginBasicData) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("WkPluginBasicData"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField10(oprot); err != nil {
			fieldId = 10
			goto WriteFieldError
		}
		if err = p.writeField11(oprot); err != nil {
			fieldId = 11
			goto WriteFieldError
		}
		if err = p.writeField12(oprot); err != nil {
			fieldId = 12
			goto WriteFieldError
		}
		if err = p.writeField13(oprot); err != nil {
			fieldId = 13
			goto WriteFieldError
		}
		if err = p.writeField14(oprot); err != nil {
			fieldId = 14
			goto WriteFieldError
		}
		if err = p.writeField15(oprot); err != nil {
			fieldId = 15
			goto WriteFieldError
		}
		if err = p.writeField16(oprot); err != nil {
			fieldId = 16
			goto WriteFieldError
		}
		if err = p.writeField17(oprot); err != nil {
			fieldId = 17
			goto WriteFieldError
		}
		if err = p.writeField18(oprot); err != nil {
			fieldId = 18
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *WkPluginBasicData) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("name", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Name); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField4(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("desc", thrift.STRING, 4); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Desc); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("url", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.URL); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField6(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("icon_uri", thrift.STRING, 6); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.IconURI); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField7(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("status", thrift.I32, 7); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.Status)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("plugin_id", thrift.I64, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.PluginID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField9(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("create_time", thrift.I64, 9); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.CreateTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField10(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("update_time", thrift.I64, 10); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.UpdateTime); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 10 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField11(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("source_id", thrift.I64, 11); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.SourceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 11 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField12(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("creator", thrift.STRUCT, 12); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Creator.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 12 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField13(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("schema", thrift.STRING, 13); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Schema); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 13 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField14(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("start_node", thrift.STRUCT, 14); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.StartNode.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 14 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField15(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("flow_mode", thrift.I32, 15); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI32(int32(p.FlowMode)); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 15 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField16(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("sub_workflows", thrift.LIST, 16); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.I64, len(p.SubWorkflows)); err != nil {
		return err
	}
	for _, v := range p.SubWorkflows {
		if err := oprot.WriteI64(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 16 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField17(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("latest_publish_commit_id", thrift.STRING, 17); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.LatestPublishCommitID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 17 end error: ", p), err)
}
func (p *WkPluginBasicData) writeField18(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("end_node", thrift.STRUCT, 18); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.EndNode.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 18 end error: ", p), err)
}

func (p *WkPluginBasicData) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("WkPluginBasicData(%+v)", *p)

}

type CopyWkTemplateApiRequest struct {
	WorkflowIds []string `thrift:"workflow_ids,1,required" form:"workflow_ids,required" json:"workflow_ids,required" query:"workflow_ids,required"`
	// Copy target space
	TargetSpaceID int64      `thrift:"target_space_id,2,required" form:"target_space_id,required" json:"target_space_id,string,required" query:"target_space_id,required"`
	Base          *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewCopyWkTemplateApiRequest() *CopyWkTemplateApiRequest {
	return &CopyWkTemplateApiRequest{}
}

func (p *CopyWkTemplateApiRequest) InitDefault() {
}

func (p *CopyWkTemplateApiRequest) GetWorkflowIds() (v []string) {
	return p.WorkflowIds
}

func (p *CopyWkTemplateApiRequest) GetTargetSpaceID() (v int64) {
	return p.TargetSpaceID
}

var CopyWkTemplateApiRequest_Base_DEFAULT *base.Base

func (p *CopyWkTemplateApiRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return CopyWkTemplateApiRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_CopyWkTemplateApiRequest = map[int16]string{
	1:   "workflow_ids",
	2:   "target_space_id",
	255: "Base",
}

func (p *CopyWkTemplateApiRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *CopyWkTemplateApiRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowIds bool = false
	var issetTargetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.LIST {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowIds = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetTargetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowIds {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetTargetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CopyWkTemplateApiRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CopyWkTemplateApiRequest[fieldId]))
}

func (p *CopyWkTemplateApiRequest) ReadField1(iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin()
	if err != nil {
		return err
	}
	_field := make([]string, 0, size)
	for i := 0; i < size; i++ {

		var _elem string
		if v, err := iprot.ReadString(); err != nil {
			return err
		} else {
			_elem = v
		}

		_field = append(_field, _elem)
	}
	if err := iprot.ReadListEnd(); err != nil {
		return err
	}
	p.WorkflowIds = _field
	return nil
}
func (p *CopyWkTemplateApiRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.TargetSpaceID = _field
	return nil
}
func (p *CopyWkTemplateApiRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *CopyWkTemplateApiRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWkTemplateApiRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CopyWkTemplateApiRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_ids", thrift.LIST, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteListBegin(thrift.STRING, len(p.WorkflowIds)); err != nil {
		return err
	}
	for _, v := range p.WorkflowIds {
		if err := oprot.WriteString(v); err != nil {
			return err
		}
	}
	if err := oprot.WriteListEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CopyWkTemplateApiRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("target_space_id", thrift.I64, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.TargetSpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *CopyWkTemplateApiRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CopyWkTemplateApiRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CopyWkTemplateApiRequest(%+v)", *p)

}

type CopyWkTemplateApiResponse struct {
	// Template ID: Copy copy of data
	Data     map[int64]*WkPluginBasicData `thrift:"data,1,required" form:"data,required" json:"data,string,required" query:"data,required"`
	Code     int64                        `thrift:"code,253,required" form:"code,required" json:"code,required" query:"code,required"`
	Msg      string                       `thrift:"msg,254,required" form:"msg,required" json:"msg,required" query:"msg,required"`
	BaseResp *base.BaseResp               `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewCopyWkTemplateApiResponse() *CopyWkTemplateApiResponse {
	return &CopyWkTemplateApiResponse{}
}

func (p *CopyWkTemplateApiResponse) InitDefault() {
}

func (p *CopyWkTemplateApiResponse) GetData() (v map[int64]*WkPluginBasicData) {
	return p.Data
}

func (p *CopyWkTemplateApiResponse) GetCode() (v int64) {
	return p.Code
}

func (p *CopyWkTemplateApiResponse) GetMsg() (v string) {
	return p.Msg
}

var CopyWkTemplateApiResponse_BaseResp_DEFAULT *base.BaseResp

func (p *CopyWkTemplateApiResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return CopyWkTemplateApiResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_CopyWkTemplateApiResponse = map[int16]string{
	1:   "data",
	253: "code",
	254: "msg",
	255: "BaseResp",
}

func (p *CopyWkTemplateApiResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *CopyWkTemplateApiResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetData bool = false
	var issetCode bool = false
	var issetMsg bool = false
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.MAP {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetData = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 253:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField253(iprot); err != nil {
					goto ReadFieldError
				}
				issetCode = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 254:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField254(iprot); err != nil {
					goto ReadFieldError
				}
				issetMsg = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetData {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetCode {
		fieldId = 253
		goto RequiredFieldNotSetError
	}

	if !issetMsg {
		fieldId = 254
		goto RequiredFieldNotSetError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_CopyWkTemplateApiResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_CopyWkTemplateApiResponse[fieldId]))
}

func (p *CopyWkTemplateApiResponse) ReadField1(iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin()
	if err != nil {
		return err
	}
	_field := make(map[int64]*WkPluginBasicData, size)
	values := make([]WkPluginBasicData, size)
	for i := 0; i < size; i++ {
		var _key int64
		if v, err := iprot.ReadI64(); err != nil {
			return err
		} else {
			_key = v
		}

		_val := &values[i]
		_val.InitDefault()
		if err := _val.Read(iprot); err != nil {
			return err
		}

		_field[_key] = _val
	}
	if err := iprot.ReadMapEnd(); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *CopyWkTemplateApiResponse) ReadField253(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *CopyWkTemplateApiResponse) ReadField254(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *CopyWkTemplateApiResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *CopyWkTemplateApiResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("CopyWkTemplateApiResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField253(oprot); err != nil {
			fieldId = 253
			goto WriteFieldError
		}
		if err = p.writeField254(oprot); err != nil {
			fieldId = 254
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *CopyWkTemplateApiResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.MAP, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteMapBegin(thrift.I64, thrift.STRUCT, len(p.Data)); err != nil {
		return err
	}
	for k, v := range p.Data {
		if err := oprot.WriteI64(k); err != nil {
			return err
		}
		if err := v.Write(oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteMapEnd(); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *CopyWkTemplateApiResponse) writeField253(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 253); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 253 end error: ", p), err)
}
func (p *CopyWkTemplateApiResponse) writeField254(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 254); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 254 end error: ", p), err)
}
func (p *CopyWkTemplateApiResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *CopyWkTemplateApiResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("CopyWkTemplateApiResponse(%+v)", *p)

}

// === node history ===
type GetWorkflowProcessRequest struct {
	// Process id, not empty
	WorkflowID string `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	// Space id, not empty
	SpaceID string `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	// Execution ID of the process
	ExecuteID *string `thrift:"execute_id,3,optional" form:"execute_id" json:"execute_id,omitempty" query:"execute_id"`
	// Execution ID of the subprocess
	SubExecuteID *string `thrift:"sub_execute_id,4,optional" form:"sub_execute_id" json:"sub_execute_id,omitempty" query:"sub_execute_id"`
	// Whether to return all batch node contents
	NeedAsync *bool `thrift:"need_async,5,optional" form:"need_async" json:"need_async,omitempty" query:"need_async"`
	// When execute_id is not transmitted, it can be obtained through log_id execute_id
	LogID  *string    `thrift:"log_id,6,optional" form:"log_id" json:"log_id,omitempty" query:"log_id"`
	NodeID *int64     `thrift:"node_id,7,optional" form:"node_id" json:"node_id,string,omitempty" query:"node_id"`
	Base   *base.Base `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetWorkflowProcessRequest() *GetWorkflowProcessRequest {
	return &GetWorkflowProcessRequest{}
}

func (p *GetWorkflowProcessRequest) InitDefault() {
}

func (p *GetWorkflowProcessRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *GetWorkflowProcessRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

var GetWorkflowProcessRequest_ExecuteID_DEFAULT string

func (p *GetWorkflowProcessRequest) GetExecuteID() (v string) {
	if !p.IsSetExecuteID() {
		return GetWorkflowProcessRequest_ExecuteID_DEFAULT
	}
	return *p.ExecuteID
}

var GetWorkflowProcessRequest_SubExecuteID_DEFAULT string

func (p *GetWorkflowProcessRequest) GetSubExecuteID() (v string) {
	if !p.IsSetSubExecuteID() {
		return GetWorkflowProcessRequest_SubExecuteID_DEFAULT
	}
	return *p.SubExecuteID
}

var GetWorkflowProcessRequest_NeedAsync_DEFAULT bool

func (p *GetWorkflowProcessRequest) GetNeedAsync() (v bool) {
	if !p.IsSetNeedAsync() {
		return GetWorkflowProcessRequest_NeedAsync_DEFAULT
	}
	return *p.NeedAsync
}

var GetWorkflowProcessRequest_LogID_DEFAULT string

func (p *GetWorkflowProcessRequest) GetLogID() (v string) {
	if !p.IsSetLogID() {
		return GetWorkflowProcessRequest_LogID_DEFAULT
	}
	return *p.LogID
}

var GetWorkflowProcessRequest_NodeID_DEFAULT int64

func (p *GetWorkflowProcessRequest) GetNodeID() (v int64) {
	if !p.IsSetNodeID() {
		return GetWorkflowProcessRequest_NodeID_DEFAULT
	}
	return *p.NodeID
}

var GetWorkflowProcessRequest_Base_DEFAULT *base.Base

func (p *GetWorkflowProcessRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetWorkflowProcessRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetWorkflowProcessRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	3:   "execute_id",
	4:   "sub_execute_id",
	5:   "need_async",
	6:   "log_id",
	7:   "node_id",
	255: "Base",
}

func (p *GetWorkflowProcessRequest) IsSetExecuteID() bool {
	return p.ExecuteID != nil
}

func (p *GetWorkflowProcessRequest) IsSetSubExecuteID() bool {
	return p.SubExecuteID != nil
}

func (p *GetWorkflowProcessRequest) IsSetNeedAsync() bool {
	return p.NeedAsync != nil
}

func (p *GetWorkflowProcessRequest) IsSetLogID() bool {
	return p.LogID != nil
}

func (p *GetWorkflowProcessRequest) IsSetNodeID() bool {
	return p.NodeID != nil
}

func (p *GetWorkflowProcessRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetWorkflowProcessRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetWorkflowProcessRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetWorkflowProcessRequest[fieldId]))
}

func (p *GetWorkflowProcessRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *GetWorkflowProcessRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetWorkflowProcessRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.ExecuteID = _field
	return nil
}
func (p *GetWorkflowProcessRequest) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.SubExecuteID = _field
	return nil
}
func (p *GetWorkflowProcessRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NeedAsync = _field
	return nil
}
func (p *GetWorkflowProcessRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.LogID = _field
	return nil
}
func (p *GetWorkflowProcessRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.NodeID = _field
	return nil
}
func (p *GetWorkflowProcessRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetWorkflowProcessRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowProcessRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetWorkflowProcessRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetWorkflowProcessRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetWorkflowProcessRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetExecuteID() {
		if err = oprot.WriteFieldBegin("execute_id", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.ExecuteID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetWorkflowProcessRequest) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetSubExecuteID() {
		if err = oprot.WriteFieldBegin("sub_execute_id", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.SubExecuteID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *GetWorkflowProcessRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetNeedAsync() {
		if err = oprot.WriteFieldBegin("need_async", thrift.BOOL, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.NeedAsync); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetWorkflowProcessRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetLogID() {
		if err = oprot.WriteFieldBegin("log_id", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.LogID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetWorkflowProcessRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetNodeID() {
		if err = oprot.WriteFieldBegin("node_id", thrift.I64, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI64(*p.NodeID); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetWorkflowProcessRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetWorkflowProcessRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetWorkflowProcessRequest(%+v)", *p)

}

type GetWorkflowProcessResponse struct {
	Code     int64                   `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg      string                  `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data     *GetWorkFlowProcessData `thrift:"data,3" form:"data" json:"data" query:"data"`
	BaseResp *base.BaseResp          `thrift:"BaseResp,255,required" form:"BaseResp,required" json:"BaseResp,required" query:"BaseResp,required"`
}

func NewGetWorkflowProcessResponse() *GetWorkflowProcessResponse {
	return &GetWorkflowProcessResponse{}
}

func (p *GetWorkflowProcessResponse) InitDefault() {
}

func (p *GetWorkflowProcessResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetWorkflowProcessResponse) GetMsg() (v string) {
	return p.Msg
}

var GetWorkflowProcessResponse_Data_DEFAULT *GetWorkFlowProcessData

func (p *GetWorkflowProcessResponse) GetData() (v *GetWorkFlowProcessData) {
	if !p.IsSetData() {
		return GetWorkflowProcessResponse_Data_DEFAULT
	}
	return p.Data
}

var GetWorkflowProcessResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetWorkflowProcessResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetWorkflowProcessResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetWorkflowProcessResponse = map[int16]string{
	1:   "code",
	2:   "msg",
	3:   "data",
	255: "BaseResp",
}

func (p *GetWorkflowProcessResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetWorkflowProcessResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetWorkflowProcessResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetBaseResp bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
				issetBaseResp = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetBaseResp {
		fieldId = 255
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetWorkflowProcessResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetWorkflowProcessResponse[fieldId]))
}

func (p *GetWorkflowProcessResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetWorkflowProcessResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetWorkflowProcessResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewGetWorkFlowProcessData()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetWorkflowProcessResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetWorkflowProcessResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetWorkflowProcessResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetWorkflowProcessResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetWorkflowProcessResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetWorkflowProcessResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetWorkflowProcessResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetWorkflowProcessResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetWorkflowProcessResponse(%+v)", *p)

}

type TokenAndCost struct {
	// Input Consumption Tokens
	InputTokens *string `thrift:"inputTokens,1,optional" form:"inputTokens" json:"inputTokens,omitempty" query:"inputTokens"`
	// Input cost
	InputCost *string `thrift:"inputCost,2,optional" form:"inputCost" json:"inputCost,omitempty" query:"inputCost"`
	// Output Consumption Tokens
	OutputTokens *string `thrift:"outputTokens,3,optional" form:"outputTokens" json:"outputTokens,omitempty" query:"outputTokens"`
	// Output cost
	OutputCost *string `thrift:"outputCost,4,optional" form:"outputCost" json:"outputCost,omitempty" query:"outputCost"`
	// Total Consumed Tokens
	TotalTokens *string `thrift:"totalTokens,5,optional" form:"totalTokens" json:"totalTokens,omitempty" query:"totalTokens"`
	// total cost
	TotalCost *string `thrift:"totalCost,6,optional" form:"totalCost" json:"totalCost,omitempty" query:"totalCost"`
}

func NewTokenAndCost() *TokenAndCost {
	return &TokenAndCost{}
}

func (p *TokenAndCost) InitDefault() {
}

var TokenAndCost_InputTokens_DEFAULT string

func (p *TokenAndCost) GetInputTokens() (v string) {
	if !p.IsSetInputTokens() {
		return TokenAndCost_InputTokens_DEFAULT
	}
	return *p.InputTokens
}

var TokenAndCost_InputCost_DEFAULT string

func (p *TokenAndCost) GetInputCost() (v string) {
	if !p.IsSetInputCost() {
		return TokenAndCost_InputCost_DEFAULT
	}
	return *p.InputCost
}

var TokenAndCost_OutputTokens_DEFAULT string

func (p *TokenAndCost) GetOutputTokens() (v string) {
	if !p.IsSetOutputTokens() {
		return TokenAndCost_OutputTokens_DEFAULT
	}
	return *p.OutputTokens
}

var TokenAndCost_OutputCost_DEFAULT string

func (p *TokenAndCost) GetOutputCost() (v string) {
	if !p.IsSetOutputCost() {
		return TokenAndCost_OutputCost_DEFAULT
	}
	return *p.OutputCost
}

var TokenAndCost_TotalTokens_DEFAULT string

func (p *TokenAndCost) GetTotalTokens() (v string) {
	if !p.IsSetTotalTokens() {
		return TokenAndCost_TotalTokens_DEFAULT
	}
	return *p.TotalTokens
}

var TokenAndCost_TotalCost_DEFAULT string

func (p *TokenAndCost) GetTotalCost() (v string) {
	if !p.IsSetTotalCost() {
		return TokenAndCost_TotalCost_DEFAULT
	}
	return *p.TotalCost
}

var fieldIDToName_TokenAndCost = map[int16]string{
	1: "inputTokens",
	2: "inputCost",
	3: "outputTokens",
	4: "outputCost",
	5: "totalTokens",
	6: "totalCost",
}

func (p *TokenAndCost) IsSetInputTokens() bool {
	return p.InputTokens != nil
}

func (p *TokenAndCost) IsSetInputCost() bool {
	return p.InputCost != nil
}

func (p *TokenAndCost) IsSetOutputTokens() bool {
	return p.OutputTokens != nil
}

func (p *TokenAndCost) IsSetOutputCost() bool {
	return p.OutputCost != nil
}

func (p *TokenAndCost) IsSetTotalTokens() bool {
	return p.TotalTokens != nil
}

func (p *TokenAndCost) IsSetTotalCost() bool {
	return p.TotalCost != nil
}

func (p *TokenAndCost) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField4(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_TokenAndCost[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *TokenAndCost) ReadField1(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.InputTokens = _field
	return nil
}
func (p *TokenAndCost) ReadField2(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.InputCost = _field
	return nil
}
func (p *TokenAndCost) ReadField3(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OutputTokens = _field
	return nil
}
func (p *TokenAndCost) ReadField4(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.OutputCost = _field
	return nil
}
func (p *TokenAndCost) ReadField5(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TotalTokens = _field
	return nil
}
func (p *TokenAndCost) ReadField6(iprot thrift.TProtocol) error {

	var _field *string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.TotalCost = _field
	return nil
}

func (p *TokenAndCost) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("TokenAndCost"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField4(oprot); err != nil {
			fieldId = 4
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *TokenAndCost) writeField1(oprot thrift.TProtocol) (err error) {
	if p.IsSetInputTokens() {
		if err = oprot.WriteFieldBegin("inputTokens", thrift.STRING, 1); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.InputTokens); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *TokenAndCost) writeField2(oprot thrift.TProtocol) (err error) {
	if p.IsSetInputCost() {
		if err = oprot.WriteFieldBegin("inputCost", thrift.STRING, 2); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.InputCost); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *TokenAndCost) writeField3(oprot thrift.TProtocol) (err error) {
	if p.IsSetOutputTokens() {
		if err = oprot.WriteFieldBegin("outputTokens", thrift.STRING, 3); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.OutputTokens); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *TokenAndCost) writeField4(oprot thrift.TProtocol) (err error) {
	if p.IsSetOutputCost() {
		if err = oprot.WriteFieldBegin("outputCost", thrift.STRING, 4); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.OutputCost); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 4 end error: ", p), err)
}
func (p *TokenAndCost) writeField5(oprot thrift.TProtocol) (err error) {
	if p.IsSetTotalTokens() {
		if err = oprot.WriteFieldBegin("totalTokens", thrift.STRING, 5); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.TotalTokens); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *TokenAndCost) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetTotalCost() {
		if err = oprot.WriteFieldBegin("totalCost", thrift.STRING, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteString(*p.TotalCost); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}

func (p *TokenAndCost) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("TokenAndCost(%+v)", *p)

}

type GetNodeExecuteHistoryRequest struct {
	WorkflowID string `thrift:"workflow_id,1,required" form:"workflow_id,required" json:"workflow_id,required" query:"workflow_id,required"`
	SpaceID    string `thrift:"space_id,2,required" form:"space_id,required" json:"space_id,required" query:"space_id,required"`
	ExecuteID  string `thrift:"execute_id,3,required" form:"execute_id,required" json:"execute_id,required" query:"execute_id,required"`
	// Node ID
	NodeID string `thrift:"node_id,5,required" form:"node_id,required" json:"node_id,required" query:"node_id,required"`
	// Whether batch node
	IsBatch *bool `thrift:"is_batch,6,optional" form:"is_batch" json:"is_batch,omitempty" query:"is_batch"`
	// execution batch
	BatchIndex       *int32            `thrift:"batch_index,7,optional" form:"batch_index" json:"batch_index,omitempty" query:"batch_index"`
	NodeType         string            `thrift:"node_type,8,required" form:"node_type,required" json:"node_type,required" query:"node_type,required"`
	NodeHistoryScene *NodeHistoryScene `thrift:"node_history_scene,9,optional" form:"node_history_scene" json:"node_history_scene,omitempty" query:"node_history_scene"`
	Base             *base.Base        `thrift:"Base,255,optional" form:"Base" json:"Base,omitempty" query:"Base"`
}

func NewGetNodeExecuteHistoryRequest() *GetNodeExecuteHistoryRequest {
	return &GetNodeExecuteHistoryRequest{}
}

func (p *GetNodeExecuteHistoryRequest) InitDefault() {
}

func (p *GetNodeExecuteHistoryRequest) GetWorkflowID() (v string) {
	return p.WorkflowID
}

func (p *GetNodeExecuteHistoryRequest) GetSpaceID() (v string) {
	return p.SpaceID
}

func (p *GetNodeExecuteHistoryRequest) GetExecuteID() (v string) {
	return p.ExecuteID
}

func (p *GetNodeExecuteHistoryRequest) GetNodeID() (v string) {
	return p.NodeID
}

var GetNodeExecuteHistoryRequest_IsBatch_DEFAULT bool

func (p *GetNodeExecuteHistoryRequest) GetIsBatch() (v bool) {
	if !p.IsSetIsBatch() {
		return GetNodeExecuteHistoryRequest_IsBatch_DEFAULT
	}
	return *p.IsBatch
}

var GetNodeExecuteHistoryRequest_BatchIndex_DEFAULT int32

func (p *GetNodeExecuteHistoryRequest) GetBatchIndex() (v int32) {
	if !p.IsSetBatchIndex() {
		return GetNodeExecuteHistoryRequest_BatchIndex_DEFAULT
	}
	return *p.BatchIndex
}

func (p *GetNodeExecuteHistoryRequest) GetNodeType() (v string) {
	return p.NodeType
}

var GetNodeExecuteHistoryRequest_NodeHistoryScene_DEFAULT NodeHistoryScene

func (p *GetNodeExecuteHistoryRequest) GetNodeHistoryScene() (v NodeHistoryScene) {
	if !p.IsSetNodeHistoryScene() {
		return GetNodeExecuteHistoryRequest_NodeHistoryScene_DEFAULT
	}
	return *p.NodeHistoryScene
}

var GetNodeExecuteHistoryRequest_Base_DEFAULT *base.Base

func (p *GetNodeExecuteHistoryRequest) GetBase() (v *base.Base) {
	if !p.IsSetBase() {
		return GetNodeExecuteHistoryRequest_Base_DEFAULT
	}
	return p.Base
}

var fieldIDToName_GetNodeExecuteHistoryRequest = map[int16]string{
	1:   "workflow_id",
	2:   "space_id",
	3:   "execute_id",
	5:   "node_id",
	6:   "is_batch",
	7:   "batch_index",
	8:   "node_type",
	9:   "node_history_scene",
	255: "Base",
}

func (p *GetNodeExecuteHistoryRequest) IsSetIsBatch() bool {
	return p.IsBatch != nil
}

func (p *GetNodeExecuteHistoryRequest) IsSetBatchIndex() bool {
	return p.BatchIndex != nil
}

func (p *GetNodeExecuteHistoryRequest) IsSetNodeHistoryScene() bool {
	return p.NodeHistoryScene != nil
}

func (p *GetNodeExecuteHistoryRequest) IsSetBase() bool {
	return p.Base != nil
}

func (p *GetNodeExecuteHistoryRequest) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16
	var issetWorkflowID bool = false
	var issetSpaceID bool = false
	var issetExecuteID bool = false
	var issetNodeID bool = false
	var issetNodeType bool = false

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
				issetWorkflowID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
				issetSpaceID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
				issetExecuteID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 5:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField5(iprot); err != nil {
					goto ReadFieldError
				}
				issetNodeID = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 6:
			if fieldTypeId == thrift.BOOL {
				if err = p.ReadField6(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 7:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField7(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 8:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField8(iprot); err != nil {
					goto ReadFieldError
				}
				issetNodeType = true
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 9:
			if fieldTypeId == thrift.I32 {
				if err = p.ReadField9(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	if !issetWorkflowID {
		fieldId = 1
		goto RequiredFieldNotSetError
	}

	if !issetSpaceID {
		fieldId = 2
		goto RequiredFieldNotSetError
	}

	if !issetExecuteID {
		fieldId = 3
		goto RequiredFieldNotSetError
	}

	if !issetNodeID {
		fieldId = 5
		goto RequiredFieldNotSetError
	}

	if !issetNodeType {
		fieldId = 8
		goto RequiredFieldNotSetError
	}
	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetNodeExecuteHistoryRequest[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
RequiredFieldNotSetError:
	return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("required field %s is not set", fieldIDToName_GetNodeExecuteHistoryRequest[fieldId]))
}

func (p *GetNodeExecuteHistoryRequest) ReadField1(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.WorkflowID = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.SpaceID = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField3(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.ExecuteID = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField5(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.NodeID = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField6(iprot thrift.TProtocol) error {

	var _field *bool
	if v, err := iprot.ReadBool(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.IsBatch = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField7(iprot thrift.TProtocol) error {

	var _field *int32
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		_field = &v
	}
	p.BatchIndex = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField8(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.NodeType = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField9(iprot thrift.TProtocol) error {

	var _field *NodeHistoryScene
	if v, err := iprot.ReadI32(); err != nil {
		return err
	} else {
		tmp := NodeHistoryScene(v)
		_field = &tmp
	}
	p.NodeHistoryScene = _field
	return nil
}
func (p *GetNodeExecuteHistoryRequest) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBase()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Base = _field
	return nil
}

func (p *GetNodeExecuteHistoryRequest) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetNodeExecuteHistoryRequest"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField5(oprot); err != nil {
			fieldId = 5
			goto WriteFieldError
		}
		if err = p.writeField6(oprot); err != nil {
			fieldId = 6
			goto WriteFieldError
		}
		if err = p.writeField7(oprot); err != nil {
			fieldId = 7
			goto WriteFieldError
		}
		if err = p.writeField8(oprot); err != nil {
			fieldId = 8
			goto WriteFieldError
		}
		if err = p.writeField9(oprot); err != nil {
			fieldId = 9
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetNodeExecuteHistoryRequest) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("workflow_id", thrift.STRING, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.WorkflowID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("space_id", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.SpaceID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("execute_id", thrift.STRING, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.ExecuteID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField5(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("node_id", thrift.STRING, 5); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.NodeID); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 5 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField6(oprot thrift.TProtocol) (err error) {
	if p.IsSetIsBatch() {
		if err = oprot.WriteFieldBegin("is_batch", thrift.BOOL, 6); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteBool(*p.IsBatch); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 6 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField7(oprot thrift.TProtocol) (err error) {
	if p.IsSetBatchIndex() {
		if err = oprot.WriteFieldBegin("batch_index", thrift.I32, 7); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(*p.BatchIndex); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 7 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField8(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("node_type", thrift.STRING, 8); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.NodeType); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 8 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField9(oprot thrift.TProtocol) (err error) {
	if p.IsSetNodeHistoryScene() {
		if err = oprot.WriteFieldBegin("node_history_scene", thrift.I32, 9); err != nil {
			goto WriteFieldBeginError
		}
		if err := oprot.WriteI32(int32(*p.NodeHistoryScene)); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 9 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryRequest) writeField255(oprot thrift.TProtocol) (err error) {
	if p.IsSetBase() {
		if err = oprot.WriteFieldBegin("Base", thrift.STRUCT, 255); err != nil {
			goto WriteFieldBeginError
		}
		if err := p.Base.Write(oprot); err != nil {
			return err
		}
		if err = oprot.WriteFieldEnd(); err != nil {
			goto WriteFieldEndError
		}
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetNodeExecuteHistoryRequest) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetNodeExecuteHistoryRequest(%+v)", *p)

}

type GetNodeExecuteHistoryResponse struct {
	Code     int64          `thrift:"code,1" form:"code" json:"code" query:"code"`
	Msg      string         `thrift:"msg,2" form:"msg" json:"msg" query:"msg"`
	Data     *NodeResult    `thrift:"data,3" form:"data" json:"data" query:"data"`
	BaseResp *base.BaseResp `thrift:"BaseResp,255" form:"BaseResp" json:"BaseResp" query:"BaseResp"`
}

func NewGetNodeExecuteHistoryResponse() *GetNodeExecuteHistoryResponse {
	return &GetNodeExecuteHistoryResponse{}
}

func (p *GetNodeExecuteHistoryResponse) InitDefault() {
}

func (p *GetNodeExecuteHistoryResponse) GetCode() (v int64) {
	return p.Code
}

func (p *GetNodeExecuteHistoryResponse) GetMsg() (v string) {
	return p.Msg
}

var GetNodeExecuteHistoryResponse_Data_DEFAULT *NodeResult

func (p *GetNodeExecuteHistoryResponse) GetData() (v *NodeResult) {
	if !p.IsSetData() {
		return GetNodeExecuteHistoryResponse_Data_DEFAULT
	}
	return p.Data
}

var GetNodeExecuteHistoryResponse_BaseResp_DEFAULT *base.BaseResp

func (p *GetNodeExecuteHistoryResponse) GetBaseResp() (v *base.BaseResp) {
	if !p.IsSetBaseResp() {
		return GetNodeExecuteHistoryResponse_BaseResp_DEFAULT
	}
	return p.BaseResp
}

var fieldIDToName_GetNodeExecuteHistoryResponse = map[int16]string{
	1:   "code",
	2:   "msg",
	3:   "data",
	255: "BaseResp",
}

func (p *GetNodeExecuteHistoryResponse) IsSetData() bool {
	return p.Data != nil
}

func (p *GetNodeExecuteHistoryResponse) IsSetBaseResp() bool {
	return p.BaseResp != nil
}

func (p *GetNodeExecuteHistoryResponse) Read(iprot thrift.TProtocol) (err error) {
	var fieldTypeId thrift.TType
	var fieldId int16

	if _, err = iprot.ReadStructBegin(); err != nil {
		goto ReadStructBeginError
	}

	for {
		_, fieldTypeId, fieldId, err = iprot.ReadFieldBegin()
		if err != nil {
			goto ReadFieldBeginError
		}
		if fieldTypeId == thrift.STOP {
			break
		}

		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err = p.ReadField1(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err = p.ReadField2(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 3:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField3(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		case 255:
			if fieldTypeId == thrift.STRUCT {
				if err = p.ReadField255(iprot); err != nil {
					goto ReadFieldError
				}
			} else if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		default:
			if err = iprot.Skip(fieldTypeId); err != nil {
				goto SkipFieldError
			}
		}
		if err = iprot.ReadFieldEnd(); err != nil {
			goto ReadFieldEndError
		}
	}
	if err = iprot.ReadStructEnd(); err != nil {
		goto ReadStructEndError
	}

	return nil
ReadStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read struct begin error: ", p), err)
ReadFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d begin error: ", p, fieldId), err)
ReadFieldError:
	return thrift.PrependError(fmt.Sprintf("%T read field %d '%s' error: ", p, fieldId, fieldIDToName_GetNodeExecuteHistoryResponse[fieldId]), err)
SkipFieldError:
	return thrift.PrependError(fmt.Sprintf("%T field %d skip type %d error: ", p, fieldId, fieldTypeId), err)

ReadFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T read field end error", p), err)
ReadStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
}

func (p *GetNodeExecuteHistoryResponse) ReadField1(iprot thrift.TProtocol) error {

	var _field int64
	if v, err := iprot.ReadI64(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Code = _field
	return nil
}
func (p *GetNodeExecuteHistoryResponse) ReadField2(iprot thrift.TProtocol) error {

	var _field string
	if v, err := iprot.ReadString(); err != nil {
		return err
	} else {
		_field = v
	}
	p.Msg = _field
	return nil
}
func (p *GetNodeExecuteHistoryResponse) ReadField3(iprot thrift.TProtocol) error {
	_field := NewNodeResult()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.Data = _field
	return nil
}
func (p *GetNodeExecuteHistoryResponse) ReadField255(iprot thrift.TProtocol) error {
	_field := base.NewBaseResp()
	if err := _field.Read(iprot); err != nil {
		return err
	}
	p.BaseResp = _field
	return nil
}

func (p *GetNodeExecuteHistoryResponse) Write(oprot thrift.TProtocol) (err error) {
	var fieldId int16
	if err = oprot.WriteStructBegin("GetNodeExecuteHistoryResponse"); err != nil {
		goto WriteStructBeginError
	}
	if p != nil {
		if err = p.writeField1(oprot); err != nil {
			fieldId = 1
			goto WriteFieldError
		}
		if err = p.writeField2(oprot); err != nil {
			fieldId = 2
			goto WriteFieldError
		}
		if err = p.writeField3(oprot); err != nil {
			fieldId = 3
			goto WriteFieldError
		}
		if err = p.writeField255(oprot); err != nil {
			fieldId = 255
			goto WriteFieldError
		}
	}
	if err = oprot.WriteFieldStop(); err != nil {
		goto WriteFieldStopError
	}
	if err = oprot.WriteStructEnd(); err != nil {
		goto WriteStructEndError
	}
	return nil
WriteStructBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
WriteFieldError:
	return thrift.PrependError(fmt.Sprintf("%T write field %d error: ", p, fieldId), err)
WriteFieldStopError:
	return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", p), err)
WriteStructEndError:
	return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", p), err)
}

func (p *GetNodeExecuteHistoryResponse) writeField1(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("code", thrift.I64, 1); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteI64(p.Code); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 1 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryResponse) writeField2(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("msg", thrift.STRING, 2); err != nil {
		goto WriteFieldBeginError
	}
	if err := oprot.WriteString(p.Msg); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 2 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryResponse) writeField3(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("data", thrift.STRUCT, 3); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.Data.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 3 end error: ", p), err)
}
func (p *GetNodeExecuteHistoryResponse) writeField255(oprot thrift.TProtocol) (err error) {
	if err = oprot.WriteFieldBegin("BaseResp", thrift.STRUCT, 255); err != nil {
		goto WriteFieldBeginError
	}
	if err := p.BaseResp.Write(oprot); err != nil {
		return err
	}
	if err = oprot.WriteFieldEnd(); err != nil {
		goto WriteFieldEndError
	}
	return nil
WriteFieldBeginError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 begin error: ", p), err)
WriteFieldEndError:
	return thrift.PrependError(fmt.Sprintf("%T write field 255 end error: ", p), err)
}

func (p *GetNodeExecuteHistoryResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("GetNodeExecuteHistoryResponse(%+v)", *p)

}

type GetWorkFlowProcessData struct {
	WorkFlowId    string            `thrift:"workFlowId,1" form:"workFlowId" json:"workFlowId" query:"workFlowId"`
	ExecuteId     string            `thrift:"executeId,2" form:"executeId" json:"executeId" query:"executeId"`
	ExecuteStatus WorkflowExeStatus `thrift:"executeStatus,3" form:"executeStatus" json:"executeStatus" query:"executeStatus"`
	NodeResults   []*NodeResult     `thrift:"nodeResults,4" form:"nodeResults" json:"nodeResults" query:"nodeResults"`
	// execution progress
	Rate string `thrift:"rate,5" form:"rate" json:"rate" query:"rate"`
	// Current node practice run state 1: no practice run 2: practice run
	ExeHistoryStatus WorkflowExeHistoryStatus `thrift:"exeHistoryStatus,6" form:"exeHistoryStatus" json:"exeHistoryStatus" query:"exeHistoryStatus"`
	// Workflow practice running time
	WorkflowExeCost string `thrift:"workflowExeCost,7" form:"workflowExeCost" json:"workflowExeCost" query:"workflowExeCost"`
	// consume
	TokenAndCost *TokenAndCost `thrift:"tokenAndCost,8,optional" form:"tokenAndCost" json:"tokenAndCost,omitempty" query:"tokenAndCost"`
	// reason for failure
	Reason *string `thrift:"reason,9,optional" form:"reason" json:"reason,omitempty" query:"reason"`
	// The ID of the last node
	LastNodeID *string `thrift:"lastNodeID,10,optional" form:"lastNodeID" json:"lastNodeID,omitempty" query:"lastNodeID"`
	LogID      string  `thrift:"logID,11" form:"logID" json:"logID" query:"logID"`
	// Returns only events in the interrupt
	NodeEvents []*NodeEvent `thrift:"nodeEvents,12" form:"nodeEvents" json:"nodeEvents" query:"nodeEvents"`
	ProjectId  string       `thrift:"projectId,13" form:"projectId" json:"projectId" query:"projectId"`
}

func NewGetWorkFlowProcessData() *GetWorkFlowProcessData {
	return &GetWorkFlowProcessData{}
}

func (p *GetWorkFlowProcessData) InitDefault() {
}

func (p *GetWorkFlowProcessData) GetWorkFlowId() (v string) {
	return p.WorkFlowId
}

func (p *GetWorkFlowProcessData) GetExecuteId() (v string) {
	return p.ExecuteId
}

func (p *GetWorkFlowProcessData) GetExecuteStatus() (v WorkflowExeStatus) {
	return p.ExecuteStatus
}

func (p *GetWorkFlowProcessData) GetNodeResults() (v []*NodeResult) {
	return p.NodeResults
}

func (p *GetWorkFlowProcessData) GetRate() (v string) {
	return p.Rate
}

func (p *GetWor