/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.
/* eslint-disable */
/* tslint:disable */
// @ts-nocheck

export type Int64 = string | number;

export enum ActionKey {
  /** 复制 */
  Copy = 1,
  /** 删除 */
  Delete = 2,
  /** 启用/禁用 */
  EnableSwitch = 3,
  /** 编辑 */
  Edit = 4,
  /** 切换成funcflow */
  SwitchToFuncflow = 8,
  /** 切换成chatflow */
  SwitchToChatflow = 9,
  /** 跨空间复制 */
  CrossSpaceCopy = 10,
}

export enum CopyStatus {
  Successful = 1,
  Processing = 2,
  Failed = 3,
  /** 如果是KeepOrigin，表示该资源不需要做变更，资源方不需要设置Target相关信息；引用方直接忽略即可 */
  KeepOrigin = 4,
  /** 表示回滚到草稿时，资源从有->无的变更 */
  Deleted = 5,
}

export enum ProjectResourceActionKey {
  /** 重命名 */
  Rename = 1,
  /** 创建副本/复制到当前项目 */
  Copy = 2,
  /** 复制到资源库 */
  CopyToLibrary = 3,
  /** 移动到资源库 */
  MoveToLibrary = 4,
  /** 删除 */
  Delete = 5,
  /** 启用 */
  Enable = 6,
  /** 禁用 */
  Disable = 7,
  /** 切换成funcflow */
  SwitchToFuncflow = 8,
  /** 切换成chatflow */
  SwitchToChatflow = 9,
  /** 修改描述 */
  UpdateDesc = 10,
}

export enum ProjectResourceGroupType {
  Workflow = 1,
  Plugin = 2,
  Data = 3,
}

export enum PublishStatus {
  /** 未发布 */
  UnPublished = 1,
  /** 已发布 */
  Published = 2,
}

export enum ResourceCopyScene {
  /** 复制项目内的资源，浅拷贝 */
  CopyProjectResource = 1,
  /** 复制项目资源到Library，复制后要发布 */
  CopyResourceToLibrary = 2,
  /** 移动项目资源到Library，复制后要发布，后置要删除项目资源 */
  MoveResourceToLibrary = 3,
  /** 复制Library资源到项目 */
  CopyResourceFromLibrary = 4,
  /** 复制项目，连带资源要复制。复制当前草稿。 */
  CopyProject = 5,
  /** 项目发布到渠道，连带资源需要发布（含商店）。以当前草稿发布。 */
  PublishProject = 6,
  /** 复制项目模板。 */
  CopyProjectTemplate = 7,
  /** 项目发布到模板，以项目的指定版本发布成临时模板。 */
  PublishProjectTemplate = 8,
  /** 模板审核通过，上架，根据临时模板复制正式模板。 */
  LaunchTemplate = 9,
  /** 草稿版本存档 */
  ArchiveProject = 10,
  /** 线上版本加载到草稿，草稿版本加载到草稿 */
  RollbackProject = 11,
  /** 单个资源跨空间复制 */
  CrossSpaceCopy = 12,
  /** 项目跨空间复制 */
  CrossSpaceCopyProject = 13,
}

export enum ResType {
  Plugin = 1,
  Workflow = 2,
  Imageflow = 3,
  Knowledge = 4,
  UI = 5,
  Prompt = 6,
  Database = 7,
  Variable = 8,
  Voice = 9,
}

export enum SyncOperation {
  Upsert = 1,
  Delete = 2,
}

/** struct ResourceCopyExtraInfo{
    // 表示操作资源后，资源要改成该名称
    1 : optional string ResourceName (go.tag = "json:\"resource_name\"", agw.key = "resource_name")
    // 表示资源发布后的版本号
    2 : optional string VersionNum  (go.tag = "json:\"version_num\"", agw.key = "version_num")
    // 该版本的版本描述
    3 : optional string VersionDesc  (go.tag = "json:\"version_desc\"", agw.key = "version_desc")
    // 每个资源不同的信息，对插件，是个人信息收集声明。schema和各个资源方约定
    4 : optional string ResourceExtendInfo  (go.tag = "json:\"resource_extend_info\"", agw.key = "resource_extend_info")
} */
export enum TaskStatus {
  Successed = 1,
  Processing = 2,
  Failed = 3,
  Canceled = 4,
}
/* eslint-enable */
