/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.
/* eslint-disable */
/* tslint:disable */
// @ts-nocheck

export type Int64 = string | number;

export enum AgentType {
  Start_Agent = 0,
  LLM_Agent = 1,
  Task_Agent = 2,
  Global_Agent = 3,
  Bot_Agent = 4,
}

/** 版本兼容：0-旧版本 1-可回退的新版本 2-不可回退的新版本 3-可回退的新版本(不再提示) */
export enum AgentVersionCompat {
  OldVersion = 0,
  MiddleVersion = 1,
  NewVersion = 2,
  MiddleVersionNotPrompt = 3,
}

/** AnswerActions */
export enum AnswerActionsMode {
  Default = 1,
  Customize = 2,
}

export enum AnswerActionTriggerType {
  /** 平台预设Trigger action */
  Direct = 1,
  /** 点击Action 显示自定义的H5页面 */
  WebView = 2,
  /** 点击Action 发送自定义的用户消息 */
  SendMessage = 3,
}

export enum BacktrackMode {
  Current = 1,
  Previous = 2,
  Start = 3,
  MostSuitable = 4,
}

export enum BotMode {
  SingleMode = 0,
  MultiMode = 1,
  WorkflowMode = 2,
}

export enum BotSpecies {
  /** bot种类
从flow创建 */
  Default = 0,
  /** 从coze创建 */
  Function = 1,
}

export enum BotStatus {
  Deleted = 0,
  Using = 1,
  Banned = 2,
}

export enum BotTableRWMode {
  LimitedReadWrite = 1,
  ReadOnly = 2,
  UnlimitedReadWrite = 3,
  RWModeMax = 4,
}

export enum BusinessType {
  Default = 0,
  DouyinAvatar = 1,
}

export enum CacheType {
  /** 缓存关闭 */
  CacheClosed = 0,
  /** 前缀缓存 */
  PrefixCache = 1,
}

/** 上下文允许传输的类型 */
export enum ContextMode {
  Chat = 0,
  FunctionCall_1 = 1,
  FunctionCall_2 = 2,
  FunctionCall_3 = 3,
}

export enum DefaultUserInputType {
  /** 没设置 */
  NotSet = 0,
  /** 文字 */
  Text = 1,
  /** 按住语音 */
  Voice = 2,
  /** 语音通话 */
  Call = 3,
  /** 视频通话 */
  VideoCall = 4,
}

export enum DisablePromptCalling {
  Off = 0,
  On = 1,
}

export enum FieldItemType {
  /** 文本 String */
  Text = 1,
  /** 数字 Integer */
  Number = 2,
  /** 时间 Time */
  Date = 3,
  /** float Number */
  Float = 4,
  /** bool Boolean */
  Boolean = 5,
}

export enum FileboxInfoMode {
  Off = 0,
  On = 1,
}

export enum IndependentRecognitionModelType {
  /** 小模型 */
  SLM = 0,
  /** 大模型 */
  LLM = 1,
}

export enum IndependentTiming {
  /** 判断用户输入（前置） */
  Pre = 1,
  /** 判断节点输出（后置） */
  Post = 2,
  /** 前置模式和后置模式支持同时选择 */
  PreAndPost = 3,
}

export enum KnowledgeNoRecallReplyMode {
  Default = 0,
  CustomizePrompt = 1,
}

export enum KnowledgeShowSourceMode {
  ReplyBottom = 0,
  CardList = 1,
}

export enum KnowledgeType {
  Coze = 0,
  Volcano = 1,
}

export enum KnowledgeTypeMode {
  Coze = 0,
  Volcano = 1,
}

export enum MessageFeedbackDetailType {
  UnlikeDefault = 0,
  /** 有害信息 */
  UnlikeHarmful = 1,
  /** 信息有误 */
  UnlikeIncorrect = 2,
  /** 未遵循指令 */
  UnlikeNotFollowInstructions = 3,
  /** 其他 */
  UnlikeOthers = 4,
}

export enum MessageFeedbackType {
  Default = 0,
  Like = 1,
  Unlike = 2,
}

export enum ModelFuncConfigStatus {
  FullSupport = 0,
  PoorSupport = 1,
  NotSupport = 2,
}

export enum ModelFuncConfigType {
  Plugin = 1,
  Workflow = 2,
  ImageFlow = 3,
  Trigger = 4,
  KnowledgeText = 5,
  KnowledgeTable = 6,
  KnowledgeAutoCall = 7,
  KnowledgeOnDemandCall = 8,
  Variable = 9,
  Database = 10,
  LongTermMemory = 11,
  FileBox = 12,
  Onboarding = 13,
  Suggestion = 14,
  ShortcutCommand = 15,
  BackGroundImage = 16,
  TTS = 17,
  MultiAgentRecognize = 18,
  KnowledgePhoto = 19,
  HookInfo = 20,
  KnowledgeValcanoUnstructured = 21,
  KnowledgeValcanoStructured = 22,
  Model = 23,
}

export enum ModelResponseFormat {
  Text = 0,
  Markdown = 1,
  JSON = 2,
}

export enum ModelStyle {
  Custom = 0,
  Creative = 1,
  Balance = 2,
  Precise = 3,
}

export enum MultiAgentConnectorType {
  Curve = 0,
  Straight = 1,
}

export enum MultiAgentSessionType {
  Flow = 1,
  Host = 2,
}

/** onboarding内容生成模式 */
export enum OnboardingMode {
  /** 不需要 */
  NO_NEED = 1,
  /** 人工指定内容（多语言支持由LLM兜底） */
  USE_MANUAL = 2,
  /** 由LLM生成 */
  USE_LLM = 3,
}

export enum PromptMode {
  Standard = 0,
  /** 前缀提示词 */
  PrefixPrompt = 1,
}

export enum RecognitionMode {
  FunctionCall = 1,
  Independent = 2,
}

export enum ReferenceInfoStatus {
  /** 1:有可用更新 */
  HasUpdates = 1,
  /** 2:被删除 */
  IsDelete = 2,
}

/** struct ContentAttachment {
    1: required string FileID (api.body = "file_id")
}
 struct MetaContent{
     1: required string Type (agw.key="type"),
     2: optional string Text ( agw.key="text"),
     3: optional string FileID (agw.key="file_id"),
     4: optional string FileURL (agw.key="file_url"),
     5: optional string Card (agw.key="card"),
 }
 struct EnterMessage  {
     1: required string Role (agw.key = "role")
     2: string Content(agw.key = "content")     // 内容
     3: map<string,string> MetaData(agw.key = "meta_data")
     4: string ContentType(agw.key = "content_type")//text/card/object_string
     5: string Type(agw.key = "type")
 }
 struct OpenMessageApi {
     1: string Id(agw.key = "id")             // 主键ID
     2: string BotId(agw.key = "bot_id")        // bot id //已TODO 所有的i64加注解str,入参和出参都要
     3: string Role(agw.key = "role")
     4: string Content(agw.key = "content")          // 内容
     5: string ConversationId(agw.key = "conversation_id")   // conversation id
     6: map<string,string> MetaData(agw.key = "meta_data")
     7: string CreatedAt(agw.key = "created_at")      // 创建时间
     8: string UpdatedAt(agw.key = "updated_at")      // 更新时间 //已TODO 时间改成int
     9: string ChatId(agw.key = "chat_id")
     10: string ContentType(agw.key = "content_type")
     11: string Type(agw.key = "type")
 } */
export enum ReferenceUpdateType {
  ManualUpdate = 1,
  AutoUpdate = 2,
}

export enum Scene {
  Default = 0,
  Explore = 1,
  BotStore = 2,
  CozeHome = 3,
  Playground = 4,
  /** 评测平台 */
  Evaluation = 5,
  AgentAPP = 6,
  /** prompt优化 */
  PromptOptimize = 7,
  /** createbot的nl2bot功能 */
  GenerateAgentInfo = 8,
}

export enum SearchStrategy {
  /** 语义搜索 */
  SemanticSearch = 0,
  /** 混合搜索 */
  HybirdSearch = 1,
  /** 全文搜索 */
  FullTextSearch = 20,
}

export enum SocietyVisibility {
  /** 对所有人可见 */
  Public = 1,
  /** 仅对host可见 */
  Anonymous = 2,
  /** 自定义 */
  Custom = 3,
}

export enum SuggestedQuestionsShowMode {
  Random = 0,
  All = 1,
}

export enum SuggestReplyMode {
  System = 0,
  Custom = 1,
  Disable = 2,
  /** agent专用，复用源Bot配置 */
  OriBot = 3,
}

export enum TimeCapsuleMode {
  /** 关 */
  Off = 0,
  /** 开 */
  On = 1,
}

export enum WorkflowMode {
  Workflow = 0,
  Imageflow = 1,
  SceneFlow = 2,
  ChatFlow = 3,
  All = 100,
}

export interface PluginParameter {
  name?: string;
  desc?: string;
  required?: boolean;
  type?: string;
  sub_parameters?: Array<PluginParameter>;
  /** 如果Type是数组，则有subtype */
  sub_type?: string;
}

export interface SocietyVisibiltyConfig {
  /** 社会场景中可见性: Public = 1,Anonymous = 2 */
  visibility_type?: SocietyVisibility;
  /** 可见角色列表 */
  visibility_roles?: Array<string>;
}

export interface Variable {
  /** key, Field */
  key?: string;
  /** 描述 */
  description?: string;
  /** 默认值 */
  default_value?: string;
  /** 是否系统值系统值 */
  is_system?: boolean;
  /** 是否支持在Prompt中调用 默认支持 */
  prompt_disabled?: boolean;
  /** 社会场景中可见性: Public = 1,Anonymous = 2 */
  society_visibility_config?: SocietyVisibiltyConfig;
  /** 是否禁用，默认为false代表启用 */
  is_disabled?: boolean;
}
/* eslint-enable */
