/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS IS AN AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.
/* eslint-disable */
/* tslint:disable */
// @ts-nocheck

export type Int64 = string | number;

export enum ActionKey {
  /** 复制 */
  Copy = 1,
  /** 删除 */
  Delete = 2,
  /** 启用/禁用 */
  EnableSwitch = 3,
  /** 编辑 */
  Edit = 4,
}

export enum CopyStatus {
  Successful = 1,
  Processing = 2,
  Failed = 3,
}

export enum ProjectResourceActionKey {
  /** 重命名 */
  Rename = 1,
  /** 创建副本/复制到当前项目 */
  Copy = 2,
  /** 复制到资源库 */
  CopyToLibrary = 3,
  /** 移动到资源库 */
  MoveToLibrary = 4,
  /** 删除 */
  Delete = 5,
  /** 启用 */
  Enable = 6,
  /** 禁用 */
  Disable = 7,
  /** 切换成funcflow */
  SwitchToFuncflow = 8,
  /** 切换成chatflow */
  SwitchToChatflow = 9,
}

export enum ProjectResourceGroupType {
  Workflow = 1,
  Plugin = 2,
  Data = 3,
}

export enum PublishStatus {
  /** 未发布 */
  UnPublished = 1,
  /** 已发布 */
  Published = 2,
}

export enum ResourceCopyScene {
  /** 复制项目内的资源，浅拷贝 */
  CopyProjectResource = 1,
  /** 复制项目资源到Library，复制后要发布 */
  CopyResourceToLibrary = 2,
  /** 移动项目资源到Library，复制后要发布，后置要删除项目资源 */
  MoveResourceToLibrary = 3,
  /** 复制Library资源到项目 */
  CopyResourceFromLibrary = 4,
  /** 复制项目，连带资源要复制。复制当前草稿。 */
  CopyProject = 5,
  /** 项目发布到渠道，连带资源需要发布（含商店）。以当前草稿发布。 */
  PublishProject = 6,
  /** 复制项目模板。 */
  CopyProjectTemplate = 7,
  /** 项目发布到模板，以项目的指定版本发布成模板。 */
  PublishProjectTemplate = 8,
  /** 项目模版上架。 */
  LaunchProjectTemplate = 9,
  /** 草稿版本存档 */
  ArchiveProject = 10,
  /** 线上版本加载到草稿，草稿版本加载到草稿 */
  RollbackProject = 11,
  /** 单个资源跨空间复制 */
  CrossSpaceCopy = 12,
  /** 项目跨空间复制 */
  CrossSpaceCopyProject = 13,
}

export enum ResType {
  Plugin = 1,
  Workflow = 2,
  Imageflow = 3,
  Knowledge = 4,
  UI = 5,
  Database = 7,
  Variable = 8,
}

export enum SyncOperation {
  Upsert = 1,
  Delete = 2,
}

/** struct ResourceCopyExtraInfo{
    // 表示操作资源后，资源要改成该名称
    1 : optional string ResourceName (go.tag = "json:\"resource_name\"", agw.key = "resource_name")
    // 表示资源发布后的版本号
    2 : optional string VersionNum  (go.tag = "json:\"version_num\"", agw.key = "version_num")
    // 该版本的版本描述
    3 : optional string VersionDesc  (go.tag = "json:\"version_desc\"", agw.key = "version_desc")
    // 每个资源不同的信息，对插件，是个人信息收集声明。schema和各个资源方约定
    4 : optional string ResourceExtendInfo  (go.tag = "json:\"resource_extend_info\"", agw.key = "resource_extend_info")
} */
export enum TaskStatus {
  Successed = 1,
  Processing = 2,
  Failed = 3,
}

export interface RefTreeNode {
  ResourceLocator?: ResourceLocator;
  /** 引用的子资源，子资源在不同层级的引用可以出现多次。A-B, A-C-B, A-D, B可以同时在A和C的ChildrenNodes出现 */
  ChildrenNodes?: Array<RefTreeNode>;
}

export interface ResourceCopyEnv {
  Scene?: ResourceCopyScene;
  /** 原项目ID。如果被复制的资源在项目中，则有值。场景：CopyProjectResource、CopyResourceToLibrary、MoveResourceToLibrary、CopyProject */
  OriginProjectID?: Int64;
  /** 目标项目ID。如果复制后的资源要赋值project_id，则有值。场景：CopyProjectResource、CopyResourceFromLibrary、CopyProject */
  TargetProjectID?: Int64;
  /** 被用户选择复制/移动的资源ID。如果操作的目标是资源，则有值。场景：CopyProjectResource、CopyResourceToLibrary、MoveResourceToLibrary、CopyResourceFromLibrary */
  ResourceLocator?: ResourceLocator;
  /** 当次任务的唯一约束，控制幂等。有则传，发起任务时不用传 */
  TaskUniqKey?: string;
  /** 项目发布时，项目版本。场景：PublishProject、PublishProjectTemplate */
  TargetProjectVersion?: Int64;
  OriginProjectSpaceID?: Int64;
  TargetProjectSpaceID?: Int64;
  /** 操作者用户id */
  CurrentUserID?: Int64;
  /** 发布模板时，原项目版本。or 复制模板时，模板的项目版本。 */
  OriginProjectVersion?: Int64;
}

/** 用于定位一个资源数据的结构：某资源的某版本 */
export interface ResourceLocator {
  ResID?: Int64;
  ResType?: ResType;
  /** 资源的当前版本，没有则是最新版本。项目发布版本或Library发布版本 */
  PublishVersion?: Int64;
}
/* eslint-enable */
