/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'reflect-metadata';
export {
  FlowMinimapService,
  MinimapRender,
  createMinimapPlugin,
} from '@flowgram.ai/minimap-plugin';
export {
  type WorkflowNodeJSON,
  type InteractiveType,
  type WorkflowNodeRegistry,
  type WorkflowNodeMeta,
  type WorkflowLinePortInfo,
  type WorkflowJSON,
  type WorkflowContentChangeEvent,
  type WorkflowSubCanvas,
  type WorkflowNodeRenderProps,
  type WorkflowPortType,
  type WorkflowNodeFormMeta,
  LineType,
  usePlayground,
  useService,
  WorkflowContentChangeType,
  WorkflowDocument,
  useCurrentEntity,
  useNodeRender,
  WorkflowHoverService,
  WorkflowSelectService,
  WorkflowDocumentOptions,
  WorkflowNodeEntity,
  WorkflowCommands,
  WorkflowNodeLinesData,
  WorkflowNodePortsData,
  WorkflowPortEntity,
  nanoid,
  WorkflowDocumentContainerModule,
  WorkflowLinesManager,
  LineColors,
  useRefresh,
  getAntiOverlapPosition,
  bindConfigEntity,
  WorkflowDragService,
  delay,
  WorkflowLineEntity,
  WorkflowResetLayoutService,
  WorkflowDocumentProvider,
  POINT_RADIUS,
  WorkflowLineRenderData,
  usePlaygroundReadonlyState,
  type WorkflowEdgeJSON,
} from '@flowgram.ai/free-layout-core';
export {
  FormModelV2,
  type FieldRenderProps,
  type PlaygroundTools,
  type FieldError,
  type FieldName,
  type IForm,
  type IField,
  type IFieldArray,
  type FieldState,
  type FormMeta as FormMetaV2,
  type FormMeta,
  type Validate,
  type FieldArrayRenderProps,
  type Effect,
  type FormRenderProps,
  type EffectOptions,
  type FieldWarning,
  usePlaygroundTools,
  isFormV2,
  Field,
  Form,
  PlaygroundEntityContext,
  FieldArray,
  useFieldValidate,
  useCurrentField,
  useCurrentFieldState,
  useForm,
  useWatch,
  // useFormItemValidate,
  ValidateTrigger,
  useWatchFormErrors,
  DataEvent,
  useField,
  FlowNodeVariableData,
  ASTKind,
  createEffectOptions,
  Emitter,
  type FreeLayoutProps,
} from '@flowgram.ai/free-layout-editor';
export {
  type PluginCreator,
  type PluginContext,
  type PositionSchema,
  type PlaygroundConfigRevealOpts,
  type PlaygroundDragEvent,
  type LayerOptions,
  type Plugin,
  EntityData,
  PositionData,
  useEntityFromContext,
  ClipboardService,
  ConfigEntity,
  Layer,
  PlaygroundConfigEntity,
  observeEntity,
  PlaygroundReactRenderer,
  PlaygroundMockTools,
  PlaygroundContext,
  bindContributions,
  Playground,
  loadPlugins,
  EntityManagerContribution,
  definePluginCreator,
  TransformData,
  EntityManager,
  LoggerEvent,
  LoggerService,
  lazyInject,
  useConfigEntity,
  SelectionService,
  SCALE_WIDTH,
  EditorState,
  EditorStateConfigEntity,
  observeEntities,
  observeEntityDatas,
  PlaygroundContribution,
  PlaygroundLayer,
  PlaygroundReactProvider,
  CommandRegistry,
} from '@flowgram.ai/core';
export {
  type FlowNodeJSON,
  type FlowNodeType,
  FlowNodeRenderData,
  FlowDocumentContribution,
  FlowNodeTransformData,
  FlowDocumentContainerModule,
  FlowNodeBaseType,
  FlowNodeEntity,
  FlowDocument,
} from '@flowgram.ai/document';
export {
  type FeedbackStatus,
  type SetterComponentProps,
  type NodeManager,
  type SetterOrDecoratorContext,
  type FormItemFeedback,
  type DecoratorComponentProps,
  type DecoratorExtension,
  type SetterExtension,
  type ValidatorProps,
  type SetterAbilityOptions,
  type FormItemMaterialContext,
  type FormDataTypeName,
  type IFormItemMeta,
  FlowNodeFormData,
  FlowNodeErrorData,
  FormModelFactory,
  createNodeContainerModules,
  createNodeEntityDatas,
  NodeRender,
  getNodeError,
  registerNodeErrorRender,
  registerNodePlaceholderRender,
  FormContribution,
  NodeContribution,
  DecoratorAbility,
  SetterAbility,
  FormManager,
  type NodeErrorRenderProps,
  FormPathService,
  type NodeContext,
  type NodeFormContext,
} from '@flowgram.ai/form-core';
export {
  type FlowSelectorBoundsLayerOptions,
  SelectorBoxConfigEntity,
  FlowRendererKey,
  FlowRendererRegistry,
  FlowRendererContribution,
  FlowDebugLayer,
  FlowNodesContentLayer,
  FlowNodesTransformLayer,
  FlowScrollBarLayer,
  FlowSelectorBoundsLayer,
  FlowSelectorBoxLayer,
  FlowRendererContainerModule,
} from '@flowgram.ai/renderer';
export {
  type DragNodeOperationValue,
  type AddOrDeleteLineOperationValue,
  type AddOrDeleteWorkflowNodeOperationValue,
  type ChangeNodeDataValue,
  createFreeHistoryPlugin,
  FreeOperationType,
  HistoryService,
  type OperationMeta,
  OperationRegistry,
  OperationContribution,
} from '@flowgram.ai/free-history-plugin';
// export {
//   FormRehajeContainerModule,
//   registerValidationErrorMessages,
//   useFormItemContext,
//   markParsed,
// } from '@flowgram.ai/form-rehaje';
export {
  type NodePanelRenderProps,
  WorkflowNodePanelService,
  createFreeNodePanelPlugin,
} from '@flowgram.ai/free-node-panel-plugin';
export {
  type LineRenderProps,
  createFreeLinesPlugin,
  WorkflowBezierLineContribution,
  WorkflowFoldLineContribution,
  WorkflowLinesLayer,
} from '@flowgram.ai/free-lines-plugin';
export {
  NodeIntoContainerService,
  NodeIntoContainerType,
  createContainerNodePlugin,
} from '@flowgram.ai/free-container-plugin';
export { createHistoryNodePlugin } from '@flowgram.ai/history-node-plugin';
export { createFreeSnapPlugin } from '@flowgram.ai/free-snap-plugin';
export {
  StackingContextManager,
  createFreeStackPlugin,
} from '@flowgram.ai/free-stack-plugin';
export {
  type LayoutNode,
  type LayoutStore,
  type GetFollowNode,
  AutoLayoutService,
  createFreeAutoLayoutPlugin,
} from '@flowgram.ai/free-auto-layout-plugin';
export * from '@flowgram.ai/form';
export {
  type Scope,
  type BaseVariableField,
  type CreateASTParams,
  type ASTNodeJSON,
  type KeyPathExpressionJSON,
  type VariablePluginOptions,
  type PropertyJSON,
  type VariableDeclarationJSON,
  type ASTNode,
  type ObjectType,
  ScopeProvider,
  VariableEngine,
  ArrayType,
  KeyPathExpression,
  BaseType,
  VariableFieldKeyRenameService,
  BaseExpression,
  postConstructAST,
  ASTFactory,
  ASTNodeFlags,
  createVariablePlugin,
  useCurrentScope,
} from '@flowgram.ai/variable-plugin';
export {
  type VariableProviderAbilityOptions,
  type VariableConsumerAbilityOptions,
  createNodeVariablePlugin,
} from '@flowgram.ai/node-variable-plugin';
export { createNodeCorePlugin } from '@flowgram.ai/node-core-plugin';

export { WorkflowJSONFormatContribution } from './workflow-json-format';
export { useEntity } from './use-entity';
export * from './deprecated';
