/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { describe, it, expect } from 'vitest';
import { DebounceTime } from '@coze-studio/autosave';

import { ItemType } from '../../../../../src/save-manager/types';
import { pluginConfig } from '../../../../../src/save-manager/auto-save/bot-skill/configs/plugin';

describe('pluginConfig', () => {
  it('should have correct configuration properties', () => {
    expect(pluginConfig).toHaveProperty('key');
    expect(pluginConfig).toHaveProperty('selector');
    expect(pluginConfig).toHaveProperty('debounce');
    expect(pluginConfig).toHaveProperty('middleware');
    expect(pluginConfig.key).toBe(ItemType.APIINFO);
    expect(pluginConfig.debounce).toBe(DebounceTime.Immediate);
  });
});
