/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** Channel IDs published as Web SDKs */
export const WEB_SDK_CONNECTOR_ID = '999';
/** Post to Button - Template Channel ID */
export const TEMPLATE_CONNECTOR_ID = '10000129';
/** Channel ID published as Mini Program - Douyin Mini Program (self-download) */
export const MINI_PROGRAM_DOUYIN_DOWNLOAD_CONNECTOR_ID = '10000130';
/** Channel ID published as Mini Program - WeChat Mini Program (self-download) */
export const MINI_PROGRAM_WECHAT_DOWNLOAD_CONNECTOR_ID = '10000131';
/** Publish channel header height when banner exists */
export const DEFAULT_PUBLISH_HEADER_HEIGHT = 97;
/** Publish channel header height when banner is closed */
export const MIN_PUBLISH_HEADER_HEIGHT = 65;
/** z-index of channel tab */
export const CONNECTOR_TAB_BAR_Z_INDEX = 1;
/** The default version_number that users fill in when they publish a new post */
export const DEFAULT_VERSION_NUMBER = 'v0.0.1';
