/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Slider } from '@coze-arch/coze-design';

import { useField } from '../hooks';
import { withField } from '../hocs';

type SliderProps = Omit<
  React.ComponentProps<typeof Slider>,
  'value' | 'onChange'
>;

export const SliderField = withField<SliderProps>(props => {
  const { value, onChange } = useField<number | number[]>();

  return <Slider value={value} onChange={onChange} {...props} />;
});
