/*
 * Copyright 2025 coze-dev Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import React from 'react';

import { type FormSchemaReactComponents } from '../types';
import { SchemaField, type SchemaFieldProps } from './schema-field';

interface CreateSchemaFieldOptions {
  components: FormSchemaReactComponents;
}

type InnerSchemaField = React.FC<
  Omit<SchemaFieldProps, 'components'> &
    Pick<Partial<SchemaFieldProps>, 'components'>
>;

export const createSchemaField = (options: CreateSchemaFieldOptions) => {
  const InnerSchemaField: InnerSchemaField = ({ components, ...props }) => (
    <SchemaField
      components={{
        ...options.components,
        ...components,
      }}
      {...props}
    />
  );

  return InnerSchemaField;
};
